package zephyr.util;

import java.io.FileOutputStream;

import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class XalanTransformer {

    private static void transform(String[] args) throws Exception {
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Source in;
        Result out;
        if (args.length >= 2 && !args[1].equals("-")) {
            in = new StreamSource(args[1]);
        } else {
            in = new StreamSource(System.in);
        }
        if (args.length >= 3 && !args[2].equals("-")) {
            out = new StreamResult(new FileOutputStream(args[2]));
        } else {
            out = new StreamResult(System.out);
        }
        Transformer transformer = tFactory.newTransformer(new StreamSource(args[0]));
        transformer.transform(in, out);
    }

    public static void main(String[] args) {
        if (args.length >= 1) {
            try {
                transform(args);
            } catch (Exception e) {
                System.err.println(e.getMessage());
            }
        } else {
            System.err.println("Usage: java XalanTransformer trans.xsl [in.xml|-] [out.xml|-]");
        }
    }

}
