package zephyr.sanshusha.accessdejp;

public class Util {

    static int sbyte2int(byte b) {
        // NOTE: Java byte is signed-byte
        return (b >= 0 ? b : (b + 256));
    }

    static byte int2sbyte(int d) {
        return (byte) (d >= 128 ? (d - 256) : d);
    }

    static int bytes2int(byte[] data) {
        int val = 0;
        if (data.length == 4) {
            for (int i = 0; i < 4; i++) {
                int v = Util.sbyte2int(data[i]);
                val += (v << (8 * i));
            }
            return val;
        } else {
            return -1;
        }
    }

    static boolean isShiftJIS(byte b0, byte b1) {
        return isShiftJIS(sbyte2int(b0), sbyte2int(b1));
    }

    static boolean isShiftJIS(int b0, int b1) {
        return ((0x81 <= b0 && b0 <= 0x9F) || (0xE0 <= b0 && b0 <= 0xFC))
                && ((0x40 <= b1 && b1 <= 0x7E) || (0x80 <= b1 && b1 <= 0xFC));
    }

}
