package zephyr.obunsha.royalfrjp;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import zephyr.util.ZephyrUtil;

public class MakeMorphHtml {

    private static final String CONJU_REGEXP =
            "<td onClick=\"open_detail\\('([^']+)'.*?title=\"(.+?)\">"
                    + "<a[^>]+>(.+?)</a><span class=\"base_mida\">&rArr;([^<]+)</span>";
    private static final Pattern CONJU = Pattern.compile(CONJU_REGEXP);

    private int nMorph = 0;

    private void loadOneMorphFile(File file) throws Exception {
        InputStream in = new FileInputStream(file);
        BufferedReader br =
                new BufferedReader(new InputStreamReader(in, ZephyrUtil.SHIFT_JIS_CODE));
        String line;

        while ((line = br.readLine()) != null) {
            Matcher m = CONJU.matcher(line);
            if (m.find()) {
                System.out.println(String.format(
                        "<dt>%s</dt><dd><a href=\"items.html#%s\">⇒%s</a> %s</dd>", m.group(3),
                        m.group(1), m.group(4), m.group(2).replace("／", " / ")));
                nMorph++;
                if ((nMorph % 10000) == 0) {
                    System.err.print(".");
                }
            }
        }
        br.close();
        in.close();
    }

    private int nLoaded = 0;

    private void loadMorphFiles(String dirname, File dir) throws Exception {
        int i = 1;
        while (true) {
            String filename = String.format("i%s%03d.htm", dirname, i);
            File file = new File(dir.getAbsolutePath(), filename);
            if (file.isFile()) {
                loadOneMorphFile(file);
                nLoaded++;
            } else {
                break;
            }
            i++;
        }
    }

    private void loadMorphFiles(String path) throws Exception {
        File dir = new File(path);
        MakeBodyHtml.checkDirectory(dir);
        String dirname = dir.getName();
        System.out.println("<html><body>");
        if (dir.isDirectory()) {
            if (dirname.length() == 1) {
                loadMorphFiles(dirname, dir);
            } else {
                for (char c = 'a'; c <= 'z'; c++) {
                    System.err.print(c);
                    dir = new File(path, Character.toString(c));
                    dirname = dir.getName();
                    loadMorphFiles(dirname, dir);
                }
            }
        }
        System.out.println("</body></html>");
        System.err.println();
        System.err.println("done. " + nLoaded + " files, " + nMorph + " conjugate entries");
    }

    public static void main(String[] args) {
        ZephyrUtil.setShiftJisOuput();

        MakeMorphHtml app = new MakeMorphHtml();
        if (args.length > 0) {
            try {
                app.loadMorphFiles(args[0]);
            } catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            System.err
                    .println("Usage: java MakeMorphHtml <SOME_DIR>/royal/contents/fr/index/conju{/[a-z]}");
        }
    }

}
