package zephyr.kenkyusya.lajp;

import java.util.List;

import zephyr.util.ZephyrUtil;

import estraier.*;

public class EstraierLoader {

    final static String ENTRY_DELIM = "======";

    private void load(String dbName) throws Exception {
        Database db = new Database();
        if (db.open(dbName, Database.DBREADER) == false) {
            throw new Exception(db.err_msg(db.error()));
        }
        int docNum = db.doc_num();
        System.err.print("loading Latin-Japanese entries ");
        boolean inJpLa = true;
        int lajpNum = 0;
        for (int id = 1; id <= docNum; id++) {
            Document doc = db.get_doc(id, 0);
            if (doc == null) {
                System.err.println("cannot get id=" + id);
                continue;
            }
            List<?> lines = doc.texts();
            if (inJpLa) {
                char c = lines.get(0).toString().charAt(0);
                if (c != 'A') {
                    continue;
                } else {
                    inJpLa = false;
                }
            }
            for (Object l : lines) {
                System.out.println(l.toString());
            }
            System.out.println(ENTRY_DELIM);
            lajpNum++;
            if ((lajpNum % 1000) == 0) {
                System.err.print('.');
            }
        }
        db.close();
        System.err.println();
        System.err.println("done. " + lajpNum + " entries");
    }

    public static void main(String[] args) {
        ZephyrUtil.setUTF8Ouput();
        EstraierLoader app = new EstraierLoader();
        if (args.length > 0) {
            try {
                app.load(args[0]);
            } catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            System.err.println("Usage: java EstraierLoader SOME_DIR/index_E");
        }
    }

}
