/***********************************************************************\
*                               winuser.d                               *
*                                                                       *
*                       Windows API header module                       *
*                                                                       *
*                 Translated from MinGW Windows headers                 *
*                                                                       *
*                       Placed into public domain                       *
\***********************************************************************/
module win32.winuser;
pragma(lib, "user32.lib");

// Conversion Notes:
// The following macros were for win16 only, and are not included in this file:
//#define EnumTaskWindows(h, f, p) EnumThreadWindows((DWORD)h, f, p)
//#define PostAppMessageA(t, m, w, l) PostThreadMessageA((DWORD)t, m, w, l)
//#define PostAppMessageW(t, m, w, l) PostThreadMessageW((DWORD)t, m, w, l)
//#define GetSysModalWindow() (NULL)
//#define SetSysModalWindow(h) (NULL)
//#define GetWindowTask(hWnd) ((HANDLE)GetWindowThreadProcessId(hWnd, NULL))
//#define DefHookProc(c, p, lp, h) CallNextHookEx((HHOOK)*h, c, p, lp)

private import win32.w32api, win32.winbase, win32.wingdi;
private import win32.windef; // for HMONITOR

// FIXME: clean up Windows version support

template MAKEINTATOM_T(int i) {
	const LPTSTR MAKEINTATOM_T = cast(LPTSTR) i;
}

const WC_DIALOG = MAKEINTATOM_T!(0x8002);

const FVIRTKEY  = 1;
const FNOINVERT = 2;
const FSHIFT    = 4;
const FCONTROL  = 8;
const FALT      = 16;

const ATF_TIMEOUTON     = 1;
const ATF_ONOFFFEEDBACK = 2;
const ATF_AVAILABLE     = 4; // May be obsolete. Not in recent MS docs.

const WH_MIN             = -1;
const WH_MSGFILTER       =  -1;
const WH_JOURNALRECORD   = 0;
const WH_JOURNALPLAYBACK = 1;
const WH_KEYBOARD        = 2;
const WH_GETMESSAGE      = 3;
const WH_CALLWNDPROC     = 4;
const WH_CBT             = 5;
const WH_SYSMSGFILTER    = 6;
const WH_MOUSE           = 7;
const WH_HARDWARE        = 8;
const WH_DEBUG           = 9;
const WH_SHELL           = 10;
const WH_FOREGROUNDIDLE  = 11;
const WH_CALLWNDPROCRET  = 12;
const WH_KEYBOARD_LL     = 13;
const WH_MOUSE_LL        = 14;
const WH_MAX             = 14;
const WH_MINHOOK         = WH_MIN;
const WH_MAXHOOK         = WH_MAX;

enum {
	HC_ACTION = 0,
	HC_GETNEXT,
	HC_SKIP,
	HC_NOREMOVE, // = 3
	HC_NOREM = HC_NOREMOVE,
	HC_SYSMODALON,
	HC_SYSMODALOFF
}

enum {
	HCBT_MOVESIZE = 0,
	HCBT_MINMAX,
	HCBT_QS,
	HCBT_CREATEWND,
	HCBT_DESTROYWND,
	HCBT_ACTIVATE,
	HCBT_CLICKSKIPPED,
	HCBT_KEYSKIPPED,
	HCBT_SYSCOMMAND,
	HCBT_SETFOCUS // = 9
}

enum {
	CF_TEXT = 1,
	CF_BITMAP,
	CF_METAFILEPICT,
	CF_SYLK,
	CF_DIF,
	CF_TIFF,
	CF_OEMTEXT,
	CF_DIB,
	CF_PALETTE,
	CF_PENDATA,
	CF_RIFF,
	CF_WAVE,
	CF_UNICODETEXT,
	CF_ENHMETAFILE,
	CF_HDROP,
	CF_LOCALE,
	CF_MAX, // = 17
	CF_OWNERDISPLAY   = 128,
	CF_DSPTEXT,
	CF_DSPBITMAP,
	CF_DSPMETAFILEPICT, // = 131
	CF_DSPENHMETAFILE = 142,
	CF_PRIVATEFIRST   = 512,
	CF_PRIVATELAST    = 767,
	CF_GDIOBJFIRST    = 768,
	CF_GDIOBJLAST     = 1023
}

const HKL_PREV = 0;
const HKL_NEXT = 1;

const KLF_ACTIVATE       = 1;
const KLF_SUBSTITUTE_OK  = 2;
const KLF_UNLOADPREVIOUS = 4;
const KLF_REORDER        = 8;
const KLF_REPLACELANG    = 16;
const KLF_NOTELLSHELL    = 128;
const KLF_SETFORPROCESS  = 256;
const KL_NAMELENGTH      = 9;

const MF_ENABLED = 0;
const MF_GRAYED = 1;
const MF_DISABLED = 2;
const MF_BITMAP = 4;
const MF_CHECKED = 8;
const MF_MENUBARBREAK = 32;
const MF_MENUBREAK = 64;
const MF_OWNERDRAW = 256;
const MF_POPUP = 16;
const MF_SEPARATOR = 0x800;
const MF_STRING = 0;
const MF_UNCHECKED = 0;
const MF_DEFAULT = 4096;
const MF_SYSMENU = 0x2000;
const MF_HELP = 0x4000;
const MF_END = 128;
const MF_RIGHTJUSTIFY = 0x4000;
const MF_MOUSESELECT = 0x8000;
const MF_INSERT = 0;
const MF_CHANGE = 128;
const MF_APPEND = 256;
const MF_DELETE = 512;
const MF_REMOVE = 4096;
const MF_USECHECKBITMAPS = 512;
const MF_UNHILITE = 0;
const MF_HILITE = 128;

// Also defined in dbt.h
const BSM_ALLCOMPONENTS      = 0;
const BSM_VXDS               = 1;
const BSM_NETDRIVER          = 2;
const BSM_INSTALLABLEDRIVERS = 4;
const BSM_APPLICATIONS       = 8;
const BSM_ALLDESKTOPS        = 16;

const BSF_QUERY              = 0x00000001;
const BSF_IGNORECURRENTTASK  = 0x00000002;
const BSF_FLUSHDISK          = 0x00000004;
const BSF_NOHANG             = 0x00000008;
const BSF_POSTMESSAGE        = 0x00000010;
const BSF_FORCEIFHUNG        = 0x00000020;
const BSF_NOTIMEOUTIFNOTHUNG = 0x00000040;

static if (_WIN32_WINNT >= 0x500) {
	const BSF_ALLOWSFW          = 0x00000080;
	const BSF_SENDNOTIFYMESSAGE = 0x00000100;
}
static if (_WIN32_WINNT >= 0x501) {
	const BSF_RETURNHDESK       = 0x00000200;
	const BSF_LUID              = 0x00000400;
}

const BROADCAST_QUERY_DENY = 1112363332;
const DWORD ENUM_CURRENT_SETTINGS  = -1;
const DWORD ENUM_REGISTRY_SETTINGS = -2;

const CDS_UPDATEREGISTRY = 1;
const CDS_TEST           = 2;
const CDS_FULLSCREEN     = 4;
const CDS_GLOBAL         = 8;
const CDS_SET_PRIMARY    = 16;
const CDS_NORESET        = 0x10000000;
const CDS_SETRECT        = 0x20000000;
const CDS_RESET          = 0x40000000;

const DISP_CHANGE_RESTART    = 1;
const DISP_CHANGE_SUCCESSFUL = 0;
const DISP_CHANGE_FAILED     = -1;
const DISP_CHANGE_BADMODE    = -2;
const DISP_CHANGE_NOTUPDATED = -3;
const DISP_CHANGE_BADFLAGS   = -4;
const DISP_CHANGE_BADPARAM   = -5;

const BST_UNCHECKED     = 0;
const BST_CHECKED       = 1;
const BST_INDETERMINATE = 2;
const BST_PUSHED        = 4;
const BST_FOCUS         = 8;

const MF_BYCOMMAND  = 0;
const MF_BYPOSITION = 1024;
// [Redefined] MF_UNCHECKED=0
// [Redefined] MF_HILITE=128
// [Redefined] MF_UNHILITE=0

const CWP_ALL             = 0;
const CWP_SKIPINVISIBLE   = 1;
const CWP_SKIPDISABLED    = 2;
const CWP_SKIPTRANSPARENT = 4;

const IMAGE_BITMAP=0;
const IMAGE_ICON=1;
const IMAGE_CURSOR=2;
const IMAGE_ENHMETAFILE=3;

const DF_ALLOWOTHERACCOUNTHOOK = 1;

const DESKTOP_READOBJECTS     = 1;
const DESKTOP_CREATEWINDOW    = 2;
const DESKTOP_CREATEMENU      = 4;
const DESKTOP_HOOKCONTROL     = 8;
const DESKTOP_JOURNALRECORD   = 16;
const DESKTOP_JOURNALPLAYBACK = 32;
const DESKTOP_ENUMERATE       = 64;
const DESKTOP_WRITEOBJECTS    = 128;
const DESKTOP_SWITCHDESKTOP   = 256;

const CW_USEDEFAULT       = 0x80000000;

const WS_OVERLAPPED       = 0;
const WS_TILED            = 0;
const WS_MAXIMIZEBOX      = 0x00010000;
const WS_MINIMIZEBOX      = 0x00020000;
const WS_SIZEBOX          = 0x00040000;
const WS_TABSTOP          = 0x00010000;
const WS_GROUP            = 0x00020000;
const WS_THICKFRAME       = 0x00040000;
const WS_SYSMENU          = 0x00080000;
const WS_HSCROLL          = 0x00100000;
const WS_VSCROLL          = 0x00200000;
const WS_DLGFRAME         = 0x00400000;
const WS_BORDER           = 0x00800000;
const WS_CAPTION          = 0x00c00000;
const WS_TILEDWINDOW      = 0x00cf0000;
const WS_OVERLAPPEDWINDOW = 0x00cf0000;
const WS_MAXIMIZE         = 0x01000000;
const WS_CLIPCHILDREN     = 0x02000000;
const WS_CLIPSIBLINGS     = 0x04000000;
const WS_DISABLED         = 0x08000000;
const WS_VISIBLE          = 0x10000000;
const WS_MINIMIZE         = 0x20000000;
const WS_ICONIC           = 0x20000000;
const WS_CHILD            = 0x40000000;
const WS_CHILDWINDOW      = 0x40000000;
const WS_POPUP            = 0x80000000;
const WS_POPUPWINDOW      = 0x80880000;

const MDIS_ALLCHILDSTYLES = 1;

const BS_3STATE = 5;
const BS_AUTO3STATE = 6;
const BS_AUTOCHECKBOX = 3;
const BS_AUTORADIOBUTTON = 9;
const BS_BITMAP = 128;
const BS_BOTTOM = 0x800;
const BS_CENTER = 0x300;
const BS_CHECKBOX = 2;
const BS_DEFPUSHBUTTON = 1;
const BS_GROUPBOX = 7;
const BS_ICON = 64;
const BS_LEFT = 256;
const BS_LEFTTEXT = 32;
const BS_MULTILINE = 0x2000;
const BS_NOTIFY = 0x4000;
const BS_OWNERDRAW = 0xb;
const BS_PUSHBUTTON = 0;
const BS_PUSHLIKE = 4096;
const BS_RADIOBUTTON = 4;
const BS_RIGHT = 512;
const BS_RIGHTBUTTON = 32;
const BS_TEXT = 0;
const BS_TOP = 0x400;
const BS_USERBUTTON = 8;
const BS_VCENTER = 0xc00;
const BS_FLAT = 0x8000;

const CBS_AUTOHSCROLL = 64;
const CBS_DISABLENOSCROLL = 0x800;
const CBS_DROPDOWN = 2;
const CBS_DROPDOWNLIST = 3;
const CBS_HASSTRINGS = 512;
const CBS_LOWERCASE = 0x4000;
const CBS_NOINTEGRALHEIGHT = 0x400;
const CBS_OEMCONVERT = 128;
const CBS_OWNERDRAWFIXED = 16;
const CBS_OWNERDRAWVARIABLE = 32;
const CBS_SIMPLE = 1;
const CBS_SORT = 256;
const CBS_UPPERCASE = 0x2000;

const ES_AUTOHSCROLL = 128;
const ES_AUTOVSCROLL = 64;
const ES_CENTER = 1;
const ES_LEFT = 0;
const ES_LOWERCASE = 16;
const ES_MULTILINE = 4;
const ES_NOHIDESEL = 256;
const ES_NUMBER = 0x2000;
const ES_OEMCONVERT = 0x400;
const ES_PASSWORD = 32;
const ES_READONLY = 0x800;
const ES_RIGHT = 2;
const ES_UPPERCASE = 8;
const ES_WANTRETURN = 4096;

const LBS_DISABLENOSCROLL = 4096;
const LBS_EXTENDEDSEL = 0x800;
const LBS_HASSTRINGS = 64;
const LBS_MULTICOLUMN = 512;
const LBS_MULTIPLESEL = 8;
const LBS_NODATA = 0x2000;
const LBS_NOINTEGRALHEIGHT = 256;
const LBS_NOREDRAW = 4;
const LBS_NOSEL = 0x4000;
const LBS_NOTIFY = 1;
const LBS_OWNERDRAWFIXED = 16;
const LBS_OWNERDRAWVARIABLE = 32;
const LBS_SORT = 2;
const LBS_STANDARD = 0xa00003;
const LBS_USETABSTOPS = 128;
const LBS_WANTKEYBOARDINPUT = 0x400;

const SBS_BOTTOMALIGN = 4;
const SBS_HORZ = 0;
const SBS_LEFTALIGN = 2;
const SBS_RIGHTALIGN = 4;
const SBS_SIZEBOX = 8;
const SBS_SIZEBOXBOTTOMRIGHTALIGN = 4;
const SBS_SIZEBOXTOPLEFTALIGN = 2;
const SBS_SIZEGRIP = 16;
const SBS_TOPALIGN = 2;
const SBS_VERT = 1;

const SS_BITMAP = 14;
const SS_BLACKFRAME = 7;
const SS_BLACKRECT = 4;
const SS_CENTER = 1;
const SS_CENTERIMAGE = 512;
const SS_ENHMETAFILE = 15;
const SS_ETCHEDFRAME = 18;
const SS_ETCHEDHORZ = 16;
const SS_ETCHEDVERT = 17;
const SS_GRAYFRAME = 8;
const SS_GRAYRECT = 5;
const SS_ICON = 3;
const SS_LEFT = 0;
const SS_LEFTNOWORDWRAP = 0xc;
const SS_NOPREFIX = 128;
const SS_NOTIFY = 256;
const SS_OWNERDRAW = 0xd;
const SS_REALSIZEIMAGE = 0x800;
const SS_RIGHT = 2;
const SS_RIGHTJUST = 0x400;
const SS_SIMPLE = 11;
const SS_SUNKEN = 4096;
const SS_WHITEFRAME = 9;
const SS_WHITERECT = 6;
const SS_USERITEM = 10;
const SS_TYPEMASK = 0x0000001FL;
const SS_ENDELLIPSIS = 0x00004000L;
const SS_PATHELLIPSIS = 0x00008000L;
const SS_WORDELLIPSIS = 0x0000C000L;
const SS_ELLIPSISMASK = 0x0000C000L;

const DS_3DLOOK = 4;
const DS_ABSALIGN = 1;
const DS_CENTER = 0x800;
const DS_CENTERMOUSE = 4096;
const DS_CONTEXTHELP = 0x2000;
const DS_CONTROL = 0x400;
const DS_FIXEDSYS = 8;
const DS_LOCALEDIT = 32;
const DS_MODALFRAME = 128;
const DS_NOFAILCREATE = 16;
const DS_NOIDLEMSG = 256;
const DS_SETFONT = 64;
const DS_SETFOREGROUND = 512;
const DS_SYSMODAL = 2;
const DS_SHELLFONT = DS_SETFONT | DS_FIXEDSYS;

const WS_EX_ACCEPTFILES = 16;
const WS_EX_APPWINDOW = 0x40000;
const WS_EX_CLIENTEDGE = 512;
const WS_EX_COMPOSITED = 0x2000000;  // XP
const WS_EX_CONTEXTHELP = 0x400;
const WS_EX_CONTROLPARENT = 0x10000;
const WS_EX_DLGMODALFRAME = 1;
const WS_EX_LAYERED = 0x80000;  // w2k
const WS_EX_LAYOUTRTL = 0x400000;  // w98, w2k
const WS_EX_LEFT = 0;
const WS_EX_LEFTSCROLLBAR = 0x4000;
const WS_EX_LTRREADING = 0;
const WS_EX_MDICHILD = 64;
const WS_EX_NOACTIVATE = 0x8000000;  // w2k
const WS_EX_NOINHERITLAYOUT = 0x100000;  // w2k
const WS_EX_NOPARENTNOTIFY = 4;
const WS_EX_OVERLAPPEDWINDOW = 0x300;
const WS_EX_PALETTEWINDOW = 0x188;
const WS_EX_RIGHT = 0x1000;
const WS_EX_RIGHTSCROLLBAR = 0;
const WS_EX_RTLREADING = 0x2000;
const WS_EX_STATICEDGE = 0x20000;
const WS_EX_TOOLWINDOW = 128;
const WS_EX_TOPMOST = 8;
const WS_EX_TRANSPARENT = 32;
const WS_EX_WINDOWEDGE = 256;

const WINSTA_ENUMDESKTOPS      = 1;
const WINSTA_READATTRIBUTES    = 2;
const WINSTA_ACCESSCLIPBOARD   = 4;
const WINSTA_CREATEDESKTOP     = 8;
const WINSTA_WRITEATTRIBUTES   = 16;
const WINSTA_ACCESSGLOBALATOMS = 32;
const WINSTA_EXITWINDOWS       = 64;
const WINSTA_ENUMERATE         = 256;
const WINSTA_READSCREEN        = 512;

const DDL_READWRITE = 0;
const DDL_READONLY  = 1;
const DDL_HIDDEN    = 2;
const DDL_SYSTEM    = 4;
const DDL_DIRECTORY = 16;
const DDL_ARCHIVE   = 32;
const DDL_POSTMSGS  = 8192;
const DDL_DRIVES    = 16384;
const DDL_EXCLUSIVE = 32768;

const DC_ACTIVE   = 0x00000001;
const DC_SMALLCAP = 0x00000002;
const DC_ICON     = 0x00000004;
const DC_TEXT     = 0x00000008;
const DC_INBUTTON = 0x00000010;

static if (WINVER >= 0x500) {
const DC_GRADIENT=0x00000020;
}
static if (_WIN32_WINNT >= 0x501) {
const DC_BUTTONS=0x00001000;
}

// Where are these documented?
//const DC_CAPTION = DC_ICON|DC_TEXT|DC_BUTTONS;
//const DC_NC      = DC_CAPTION|DC_FRAME;

const BDR_RAISEDOUTER = 1;
const BDR_SUNKENOUTER = 2;
const BDR_RAISEDINNER = 4;
const BDR_SUNKENINNER = 8;
const BDR_OUTER       = 3;
const BDR_INNER       = 0xc;
const BDR_RAISED      = 5;
const BDR_SUNKEN      = 10;

const EDGE_RAISED = BDR_RAISEDOUTER|BDR_RAISEDINNER;
const EDGE_SUNKEN = BDR_SUNKENOUTER|BDR_SUNKENINNER;
const EDGE_ETCHED = BDR_SUNKENOUTER|BDR_RAISEDINNER;
const EDGE_BUMP   = BDR_RAISEDOUTER|BDR_SUNKENINNER;

const BF_LEFT                    = 1;
const BF_TOP                     = 2;
const BF_RIGHT                   = 4;
const BF_BOTTOM                  = 8;
const BF_TOPLEFT                 = BF_TOP|BF_LEFT;
const BF_TOPRIGHT                = BF_TOP|BF_RIGHT;
const BF_BOTTOMLEFT              = BF_BOTTOM|BF_LEFT;
const BF_BOTTOMRIGHT             = BF_BOTTOM|BF_RIGHT;
const BF_RECT                    = BF_LEFT|BF_TOP|BF_RIGHT|BF_BOTTOM ;
const BF_DIAGONAL                = 16;
const BF_DIAGONAL_ENDTOPRIGHT    = BF_DIAGONAL|BF_TOP|BF_RIGHT;
const BF_DIAGONAL_ENDTOPLEFT     = BF_DIAGONAL|BF_TOP|BF_LEFT;
const BF_DIAGONAL_ENDBOTTOMLEFT  = BF_DIAGONAL|BF_BOTTOM|BF_LEFT;
const BF_DIAGONAL_ENDBOTTOMRIGHT = BF_DIAGONAL|BF_BOTTOM|BF_RIGHT;
const BF_MIDDLE                  = 0x800;
const BF_SOFT                    = 0x1000;
const BF_ADJUST                  = 0x2000;
const BF_FLAT                    = 0x4000;
const BF_MONO                    = 0x8000;

const DFC_CAPTION=1;
const DFC_MENU=2;
const DFC_SCROLL=3;
const DFC_BUTTON=4;
static if (WINVER >= 0x500) {
const DFC_POPUPMENU=5;
}// WINVER >= 0x500

const DFCS_CAPTIONCLOSE   = 0;
const DFCS_CAPTIONMIN     = 1;
const DFCS_CAPTIONMAX     = 2;
const DFCS_CAPTIONRESTORE = 3;
const DFCS_CAPTIONHELP    = 4;

const DFCS_MENUARROW      = 0;
const DFCS_MENUCHECK      = 1;
const DFCS_MENUBULLET     = 2;
const DFCS_MENUARROWRIGHT = 4;

const DFCS_SCROLLUP            = 0;
const DFCS_SCROLLDOWN          = 1;
const DFCS_SCROLLLEFT          = 2;
const DFCS_SCROLLRIGHT         = 3;
const DFCS_SCROLLCOMBOBOX      = 5;
const DFCS_SCROLLSIZEGRIP      = 8;
const DFCS_SCROLLSIZEGRIPRIGHT = 16;

const DFCS_BUTTONCHECK         = 0;
const DFCS_BUTTONRADIOIMAGE    = 1;
const DFCS_BUTTONRADIOMASK     = 2;
const DFCS_BUTTONRADIO         = 4;
const DFCS_BUTTON3STATE        = 8;
const DFCS_BUTTONPUSH          = 16;
const DFCS_INACTIVE            = 256;
const DFCS_PUSHED              = 512;
const DFCS_CHECKED             = 1024;
static if (WINVER >= 0x500) {
const DFCS_TRANSPARENT         = 0x800;
const DFCS_HOT                 = 0x1000;
}
const DFCS_ADJUSTRECT          = 0x2000;
const DFCS_FLAT                = 0x4000;
const DFCS_MONO                = 0x8000;

enum {
	DST_COMPLEX = 0,
	DST_TEXT,
	DST_PREFIXTEXT,
	DST_ICON,
	DST_BITMAP // = 4
}

const DSS_NORMAL = 0;
const DSS_UNION = 16;
const DSS_DISABLED = 32;
const DSS_MONO = 128;
const DSS_RIGHT = 0x8000;

const DT_BOTTOM = 8;
const DT_CALCRECT = 1024;
const DT_CENTER = 1;
const DT_EDITCONTROL = 8192;
const DT_END_ELLIPSIS = 32768;
const DT_PATH_ELLIPSIS = 16384;
const DT_WORD_ELLIPSIS = 0x40000;
const DT_EXPANDTABS = 64;
const DT_EXTERNALLEADING = 512;
const DT_LEFT = 0;
const DT_MODIFYSTRING = 65536;
const DT_NOCLIP = 256;
const DT_NOPREFIX = 2048;
const DT_RIGHT = 2;
const DT_RTLREADING = 131072;
const DT_SINGLELINE = 32;
const DT_TABSTOP = 128;
const DT_TOP = 0;
const DT_VCENTER = 4;
const DT_WORDBREAK = 16;
const DT_INTERNAL = 4096;

const WB_ISDELIMITER = 2;
const WB_LEFT = 0;
const WB_RIGHT = 1;

const SB_HORZ = 0;
const SB_VERT = 1;
const SB_CTL = 2;
const SB_BOTH = 3;

const ESB_DISABLE_BOTH = 3;
const ESB_DISABLE_DOWN = 2;
const ESB_DISABLE_LEFT = 1;
const ESB_DISABLE_LTUP = 1;
const ESB_DISABLE_RIGHT = 2;
const ESB_DISABLE_RTDN = 2;
const ESB_DISABLE_UP = 1;
const ESB_ENABLE_BOTH = 0;

const SB_LINEUP = 0;
const SB_LINEDOWN = 1;
const SB_LINELEFT = 0;
const SB_LINERIGHT = 1;
const SB_PAGEUP = 2;
const SB_PAGEDOWN = 3;
const SB_PAGELEFT = 2;
const SB_PAGERIGHT = 3;
const SB_THUMBPOSITION = 4;
const SB_THUMBTRACK = 5;
const SB_ENDSCROLL = 8;
const SB_LEFT = 6;
const SB_RIGHT = 7;
const SB_BOTTOM = 7;
const SB_TOP = 6;

//MACRO #define IS_INTRESOURCE(i) (((ULONG_PTR)(i) >> 16) == 0)

template MAKEINTRESOURCE_T (WORD i)
{
	const LPTSTR MAKEINTRESOURCE_T = cast(LPTSTR)(i);
}

LPSTR MAKEINTRESOURCEA(WORD i)
{
	return cast(LPSTR)(i);
}

LPWSTR MAKEINTRESOURCEW(WORD i)
{
	return cast(LPWSTR)(i);
}

const RT_CURSOR       = MAKEINTRESOURCE_T!(1);
const RT_BITMAP       = MAKEINTRESOURCE_T!(2);
const RT_ICON         = MAKEINTRESOURCE_T!(3);
const RT_MENU         = MAKEINTRESOURCE_T!(4);
const RT_DIALOG       = MAKEINTRESOURCE_T!(5);
const RT_STRING       = MAKEINTRESOURCE_T!(6);
const RT_FONTDIR      = MAKEINTRESOURCE_T!(7);
const RT_FONT         = MAKEINTRESOURCE_T!(8);
const RT_ACCELERATOR  = MAKEINTRESOURCE_T!(9);
const RT_RCDATA       = MAKEINTRESOURCE_T!(10);
const RT_MESSAGETABLE = MAKEINTRESOURCE_T!(11);

const RT_GROUP_CURSOR = MAKEINTRESOURCE_T!(12);
const RT_GROUP_ICON   = MAKEINTRESOURCE_T!(14);
const RT_VERSION      = MAKEINTRESOURCE_T!(16);
const RT_DLGINCLUDE   = MAKEINTRESOURCE_T!(17);
const RT_PLUGPLAY     = MAKEINTRESOURCE_T!(19);
const RT_VXD          = MAKEINTRESOURCE_T!(20);
const RT_ANICURSOR    = MAKEINTRESOURCE_T!(21);
const RT_ANIICON      = MAKEINTRESOURCE_T!(22);
const RT_HTML         = MAKEINTRESOURCE_T!(23);
const RT_MANIFEST     = MAKEINTRESOURCE_T!(24);

const CREATEPROCESS_MANIFEST_RESOURCE_ID                 = MAKEINTRESOURCE_T!(1);
const ISOLATIONAWARE_MANIFEST_RESOURCE_ID                = MAKEINTRESOURCE_T!(2);
const ISOLATIONAWARE_NOSTATICIMPORT_MANIFEST_RESOURCE_ID = MAKEINTRESOURCE_T!(3);

const EWX_LOGOFF   = 0;
const EWX_SHUTDOWN = 1;
const EWX_REBOOT   = 2;
const EWX_FORCE    = 4;
const EWX_POWEROFF = 8;
static if (_WIN32_WINNT >= 0x500) {
const EWX_FORCEIFHUNG = 16;
}

const CS_BYTEALIGNCLIENT = 4096;
const CS_BYTEALIGNWINDOW = 8192;
const CS_KEYCVTWINDOW = 4;
const CS_NOKEYCVT = 256;
const CS_CLASSDC = 64;
const CS_DBLCLKS = 8;
const CS_GLOBALCLASS = 16384;
const CS_HREDRAW = 2;
const CS_NOCLOSE = 512;
const CS_OWNDC = 32;
const CS_PARENTDC = 128;
const CS_SAVEBITS = 2048;
const CS_VREDRAW = 1;
const CS_IME = 0x10000;

const GCW_ATOM = -32;
const GCL_CBCLSEXTRA = -20;
const GCL_CBWNDEXTRA = -18;
const GCL_HBRBACKGROUND = -10;
const GCL_HCURSOR = -12;
const GCL_HICON = -14;
const GCL_HICONSM = -34;
const GCL_HMODULE = -16;
const GCL_MENUNAME = -8;
const GCL_STYLE = -26;
const GCL_WNDPROC = -24;

const IDC_ARROW       = MAKEINTRESOURCE_T!(32512);
const IDC_IBEAM       = MAKEINTRESOURCE_T!(32513);
const IDC_WAIT        = MAKEINTRESOURCE_T!(32514);
const IDC_CROSS       = MAKEINTRESOURCE_T!(32515);
const IDC_UPARROW     = MAKEINTRESOURCE_T!(32516);
const IDC_SIZENWSE    = MAKEINTRESOURCE_T!(32642);
const IDC_SIZENESW    = MAKEINTRESOURCE_T!(32643);
const IDC_SIZEWE      = MAKEINTRESOURCE_T!(32644);
const IDC_SIZENS      = MAKEINTRESOURCE_T!(32645);
const IDC_SIZEALL     = MAKEINTRESOURCE_T!(32646);
const IDC_NO          = MAKEINTRESOURCE_T!(32648);
const IDC_HAND        = MAKEINTRESOURCE_T!(32649);
const IDC_APPSTARTING = MAKEINTRESOURCE_T!(32650);
const IDC_HELP        = MAKEINTRESOURCE_T!(32651);
const IDC_ICON        = MAKEINTRESOURCE_T!(32641);
const IDC_SIZE        = MAKEINTRESOURCE_T!(32640);
const IDI_APPLICATION = MAKEINTRESOURCE_T!(32512);
const IDI_HAND        = MAKEINTRESOURCE_T!(32513);
const IDI_QUESTION    = MAKEINTRESOURCE_T!(32514);
const IDI_EXCLAMATION = MAKEINTRESOURCE_T!(32515);
const IDI_ASTERISK    = MAKEINTRESOURCE_T!(32516);
const IDI_WINLOGO     = MAKEINTRESOURCE_T!(32517);
const IDI_WARNING     = IDI_EXCLAMATION;
const IDI_ERROR       = IDI_HAND;
const IDI_INFORMATION = IDI_ASTERISK;

const MIIM_STATE = 1;
const MIIM_ID = 2;
const MIIM_SUBMENU = 4;
const MIIM_CHECKMARKS = 8;
const MIIM_TYPE = 16;
const MIIM_DATA = 32;
const MIIM_STRING = 64;
const MIIM_BITMAP = 128;
const MIIM_FTYPE = 256;

static if (WINVER >= 0x500) {

const MIM_MAXHEIGHT = 1;
const MIM_BACKGROUND = 2;
const MIM_HELPID = 4;
const MIM_MENUDATA = 8;
const MIM_STYLE = 16;
const MIM_APPLYTOSUBMENUS = 0x80000000L;

const MNS_NOCHECK = 0x80000000;
const MNS_MODELESS = 0x40000000;
const MNS_DRAGDROP = 0x20000000;
const MNS_AUTODISMISS = 0x10000000;
const MNS_NOTIFYBYPOS = 0x08000000;
const MNS_CHECKORBMP = 0x04000000;

}

const MFT_BITMAP = 4;
const MFT_MENUBARBREAK = 32;
const MFT_MENUBREAK = 64;
const MFT_OWNERDRAW = 256;
const MFT_RADIOCHECK = 512;
const MFT_RIGHTJUSTIFY = 0x4000;
const MFT_SEPARATOR = 0x800;
const MFT_RIGHTORDER = 0x2000L;
const MFT_STRING = 0;

const MFS_CHECKED = 8;
const MFS_DEFAULT = 4096;
const MFS_DISABLED = 3;
const MFS_ENABLED = 0;
const MFS_GRAYED = 3;
const MFS_HILITE = 128;
const MFS_UNCHECKED = 0;
const MFS_UNHILITE = 0;

const GW_HWNDNEXT = 2;
const GW_HWNDPREV = 3;
const GW_CHILD = 5;
const GW_HWNDFIRST = 0;
const GW_HWNDLAST = 1;
const GW_OWNER = 4;

const SW_HIDE = 0;
const SW_NORMAL = 1;
const SW_SHOWNORMAL = 1;
const SW_SHOWMINIMIZED = 2;
const SW_MAXIMIZE = 3;
const SW_SHOWMAXIMIZED = 3;
const SW_SHOWNOACTIVATE = 4;
const SW_SHOW = 5;
const SW_MINIMIZE = 6;
const SW_SHOWMINNOACTIVE = 7;
const SW_SHOWNA = 8;
const SW_RESTORE = 9;
const SW_SHOWDEFAULT = 10;
const SW_FORCEMINIMIZE = 11;
const SW_MAX = 11;

const MB_USERICON = 128;
const MB_ICONASTERISK = 64;
const MB_ICONEXCLAMATION = 0x30;
const MB_ICONWARNING = 0x30;
const MB_ICONERROR = 16;
const MB_ICONHAND = 16;
const MB_ICONQUESTION = 32;
const MB_OK = 0;
const MB_ABORTRETRYIGNORE = 2;
const MB_APPLMODAL = 0;
const MB_DEFAULT_DESKTOP_ONLY = 0x20000;
const MB_HELP = 0x4000;
const MB_RIGHT = 0x80000;
const MB_RTLREADING = 0x100000;
const MB_TOPMOST = 0x40000;
const MB_DEFBUTTON1 = 0;
const MB_DEFBUTTON2 = 256;
const MB_DEFBUTTON3 = 512;
const MB_DEFBUTTON4 = 0x300;
const MB_ICONINFORMATION = 64;
const MB_ICONSTOP = 16;
const MB_OKCANCEL = 1;
const MB_RETRYCANCEL = 5;

static if (_WIN32_WINNT_ONLY) {
	static if (_WIN32_WINNT >= 0x400) {
		const MB_SERVICE_NOTIFICATION = 0x00200000;
	} else {
		const MB_SERVICE_NOTIFICATION = 0x00040000;
	}
	const MB_SERVICE_NOTIFICATION_NT3X = 0x00040000;
}

const MB_SETFOREGROUND = 0x10000;
const MB_SYSTEMMODAL = 4096;
const MB_TASKMODAL = 0x2000;
const MB_YESNO = 4;
const MB_YESNOCANCEL = 3;
const MB_ICONMASK = 240;
const MB_DEFMASK = 3840;
const MB_MODEMASK = 0x00003000;
const MB_MISCMASK = 0x0000C000;
const MB_NOFOCUS = 0x00008000;
const MB_TYPEMASK = 15;
// [Redefined] MB_TOPMOST=0x40000
static if (WINVER >= 0x500) {
	const MB_CANCELTRYCONTINUE=6;
}

const IDOK       = 1;
const IDCANCEL   = 2;
const IDABORT    = 3;
const IDRETRY    = 4;
const IDIGNORE   = 5;
const IDYES      = 6;
const IDNO       = 7;
static if (WINVER >= 0x400) {
const IDCLOSE    = 8;
const IDHELP     = 9;
}
static if (WINVER >= 0x500) {
const IDTRYAGAIN = 10;
const IDCONTINUE = 11;
}

const GWL_EXSTYLE = -20;
const GWL_STYLE = -16;
const GWL_WNDPROC = -4;
const GWLP_WNDPROC = -4;
const GWL_HINSTANCE = -6;
const GWLP_HINSTANCE = -6;
const GWL_HWNDPARENT = -8;
const GWLP_HWNDPARENT = -8;
const GWL_ID = -12;
const GWLP_ID = -12;
const GWL_USERDATA = -21;
const GWLP_USERDATA = -21;

const DWL_DLGPROC = 4;
const DWLP_DLGPROC = 4;
const DWL_MSGRESULT = 0;
const DWLP_MSGRESULT = 0;
const DWL_USER = 8;
const DWLP_USER = 8;

const QS_KEY            = 1;
const QS_MOUSEMOVE      = 2;
const QS_MOUSEBUTTON    = 4;
const QS_MOUSE          = 6;
const QS_POSTMESSAGE    = 8;
const QS_TIMER          = 16;
const QS_PAINT          = 32;
const QS_SENDMESSAGE    = 64;
const QS_HOTKEY         = 128;
const QS_ALLPOSTMESSAGE = 256;
static if (_WIN32_WINNT >= 0x501) {
const QS_RAWINPUT       = 1024;
const QS_INPUT          = 1031;
const QS_ALLEVENTS      = 1215;
const QS_ALLINPUT       = 1279;
} else {
const QS_INPUT          = 7;
const QS_ALLEVENTS      = 191;
const QS_ALLINPUT       = 255;
}

const MWMO_WAITALL        = 1;
const MWMO_ALERTABLE      = 2;
const MWMO_INPUTAVAILABLE = 4;

const COLOR_3DDKSHADOW=21;
const COLOR_3DFACE=15;
const COLOR_3DHILIGHT=20;
const COLOR_3DHIGHLIGHT=20;
const COLOR_3DLIGHT=22;
const COLOR_BTNHILIGHT=20;
const COLOR_3DSHADOW=16;
const COLOR_ACTIVEBORDER=10;
const COLOR_ACTIVECAPTION=2;
const COLOR_APPWORKSPACE=12;
const COLOR_BACKGROUND=1;
const COLOR_DESKTOP=1;
const COLOR_BTNFACE=15;
const COLOR_BTNHIGHLIGHT=20;
const COLOR_BTNSHADOW=16;
const COLOR_BTNTEXT=18;
const COLOR_CAPTIONTEXT=9;
const COLOR_GRAYTEXT=17;
const COLOR_HIGHLIGHT=13;
const COLOR_HIGHLIGHTTEXT=14;
const COLOR_INACTIVEBORDER=11;
const COLOR_INACTIVECAPTION=3;
const COLOR_INACTIVECAPTIONTEXT=19;
const COLOR_INFOBK=24;
const COLOR_INFOTEXT=23;
const COLOR_MENU=4;
const COLOR_MENUTEXT=7;
const COLOR_SCROLLBAR=0;
const COLOR_WINDOW=5;
const COLOR_WINDOWFRAME=6;
const COLOR_WINDOWTEXT=8;
const COLOR_HOTLIGHT=26;
const COLOR_GRADIENTACTIVECAPTION=27;
const COLOR_GRADIENTINACTIVECAPTION=28;

const CTLCOLOR_MSGBOX=0;
const CTLCOLOR_EDIT=1;
const CTLCOLOR_LISTBOX=2;
const CTLCOLOR_BTN=3;
const CTLCOLOR_DLG=4;
const CTLCOLOR_SCROLLBAR=5;
const CTLCOLOR_STATIC=6;
const CTLCOLOR_MAX=7;

// For GetSystemMetrics()
enum : int {
	SM_CXSCREEN = 0,
	SM_CYSCREEN,
	SM_CXVSCROLL,
	SM_CYHSCROLL,
	SM_CYCAPTION,
	SM_CXBORDER,
	SM_CYBORDER,
	SM_CXDLGFRAME, // = 7,
	SM_CXFIXEDFRAME = SM_CXDLGFRAME,
	SM_CYDLGFRAME, // =8,
	SM_CYFIXEDFRAME = SM_CYDLGFRAME,
	SM_CYVTHUMB = 9,
	SM_CXHTHUMB,
	SM_CXICON,
	SM_CYICON,
	SM_CXCURSOR,
	SM_CYCURSOR,
	SM_CYMENU,
	SM_CXFULLSCREEN,
	SM_CYFULLSCREEN,
	SM_CYKANJIWINDOW,
	SM_MOUSEPRESENT,
	SM_CYVSCROLL,
	SM_CXHSCROLL,
	SM_DEBUG,
	SM_SWAPBUTTON,
	SM_RESERVED1,
	SM_RESERVED2,
	SM_RESERVED3,
	SM_RESERVED4,
	SM_CXMIN,
	SM_CYMIN,
	SM_CXSIZE,
	SM_CYSIZE,
	SM_CXSIZEFRAME, // = 32,
	SM_CXFRAME = SM_CXSIZEFRAME,
	SM_CYSIZEFRAME, // = 33
	SM_CYFRAME = SM_CYSIZEFRAME,
	SM_CXMINTRACK,
	SM_CYMINTRACK,
	SM_CXDOUBLECLK,
	SM_CYDOUBLECLK,
	SM_CXICONSPACING,
	SM_CYICONSPACING,
	SM_MENUDROPALIGNMENT,
	SM_PENWINDOWS,
	SM_DBCSENABLED,
	SM_CMOUSEBUTTONS,
	SM_SECURE,
	SM_CXEDGE,
	SM_CYEDGE,
	SM_CXMINSPACING,
	SM_CYMINSPACING,
	SM_CXSMICON,
	SM_CYSMICON,
	SM_CYSMCAPTION,
	SM_CXSMSIZE,
	SM_CYSMSIZE,
	SM_CXMENUSIZE,
	SM_CYMENUSIZE,
	SM_ARRANGE,
	SM_CXMINIMIZED,
	SM_CYMINIMIZED,
	SM_CXMAXTRACK,
	SM_CYMAXTRACK,
	SM_CXMAXIMIZED,
	SM_CYMAXIMIZED,
	SM_NETWORK, // = 63
	SM_CLEANBOOT = 67,
	SM_CXDRAG,
	SM_CYDRAG,
	SM_SHOWSOUNDS,
	SM_CXMENUCHECK,
	SM_CYMENUCHECK,
	SM_SLOWMACHINE,
	SM_MIDEASTENABLED,
	// The next values aren't supported in Win95.
	SM_MOUSEWHEELPRESENT,
	SM_XVIRTUALSCREEN,
	SM_YVIRTUALSCREEN,
	SM_CXVIRTUALSCREEN,
	SM_CYVIRTUALSCREEN,
	SM_CMONITORS,
	SM_SAMEDISPLAYFORMAT,
	SM_IMMENABLED,
	SM_CXFOCUSBORDER,
	SM_CYFOCUSBORDER, // = 84
	SM_TABLETPC = 86,
	SM_MEDIACENTER = 87,
	SM_REMOTESESSION = 0x1000,
	// These are only for WinXP and later
	SM_SHUTTINGDOWN = 0x2000,
	SM_REMOTECONTROL = 0x2001
}

const ARW_BOTTOMLEFT=0;
const ARW_BOTTOMRIGHT=1;
const ARW_HIDE=8;
const ARW_TOPLEFT=2;
const ARW_TOPRIGHT=3;
const ARW_DOWN=4;
const ARW_LEFT=0;
const ARW_RIGHT=0;
const ARW_UP=4;

const UOI_FLAGS=1;
const UOI_NAME=2;
const UOI_TYPE=3;
const UOI_USER_SID=4;

// For the fuLoad parameter of LoadImage()
enum : UINT {
	LR_DEFAULTCOLOR     = 0,
	LR_MONOCHROME       = 1,
	LR_COLOR            = 2,
	LR_COPYRETURNORG    = 4,
	LR_COPYDELETEORG    = 8,
	LR_LOADFROMFILE     = 16,
	LR_LOADTRANSPARENT  = 32,
	LR_DEFAULTSIZE      = 64,
	LR_LOADREALSIZE     = 128,
	LR_LOADMAP3DCOLORS  = 4096,
	LR_CREATEDIBSECTION = 8192,
	LR_COPYFROMRESOURCE = 16384,
	LR_SHARED           = 32768
}

const KEYEVENTF_EXTENDEDKEY = 0x00000001;
const KEYEVENTF_KEYUP       = 00000002;
static if (_WIN32_WINNT >= 0x500) {
const KEYEVENTF_UNICODE     = 0x00000004;
const KEYEVENTF_SCANCODE    = 0x00000008;
}

const OBM_BTNCORNERS = 32758;
const OBM_BTSIZE = 32761;
const OBM_CHECK = 32760;
const OBM_CHECKBOXES = 32759;
const OBM_CLOSE = 32754;
const OBM_COMBO = 32738;
const OBM_DNARROW = 32752;
const OBM_DNARROWD = 32742;
const OBM_DNARROWI = 32736;
const OBM_LFARROW = 32750;
const OBM_LFARROWI = 32734;
const OBM_LFARROWD = 32740;
const OBM_MNARROW = 32739;
const OBM_OLD_CLOSE = 32767;
const OBM_OLD_DNARROW = 32764;
const OBM_OLD_LFARROW = 32762;
const OBM_OLD_REDUCE = 32757;
const OBM_OLD_RESTORE = 32755;
const OBM_OLD_RGARROW = 32763;
const OBM_OLD_UPARROW = 32765;
const OBM_OLD_ZOOM = 32756;
const OBM_REDUCE = 32749;
const OBM_REDUCED = 32746;
const OBM_RESTORE = 32747;
const OBM_RESTORED = 32744;
const OBM_RGARROW = 32751;
const OBM_RGARROWD = 32741;
const OBM_RGARROWI = 32735;
const OBM_SIZE = 32766;
const OBM_UPARROW = 32753;
const OBM_UPARROWD = 32743;
const OBM_UPARROWI = 32737;
const OBM_ZOOM = 32748;
const OBM_ZOOMD = 32745;

const OCR_NORMAL = 32512;
const OCR_IBEAM = 32513;
const OCR_WAIT = 32514;
const OCR_CROSS = 32515;
const OCR_UP = 32516;
const OCR_SIZE = 32640;
const OCR_ICON = 32641;
const OCR_SIZENWSE = 32642;
const OCR_SIZENESW = 32643;
const OCR_SIZEWE = 32644;
const OCR_SIZENS = 32645;
const OCR_SIZEALL = 32646;
const OCR_NO = 32648;
const OCR_APPSTARTING = 32650;

const OIC_SAMPLE = 32512;
const OIC_HAND = 32513;
const OIC_QUES = 32514;
const OIC_BANG = 32515;
const OIC_NOTE = 32516;
const OIC_WINLOGO = 32517;
const OIC_WARNING = OIC_BANG;
const OIC_ERROR = OIC_HAND;
const OIC_INFORMATION = OIC_NOTE;

const HELPINFO_MENUITEM = 2;
const HELPINFO_WINDOW = 1;

const MSGF_DIALOGBOX = 0;
const MSGF_MESSAGEBOX = 1;
const MSGF_MENU = 2;
const MSGF_MOVE = 3;
const MSGF_SIZE = 4;
const MSGF_SCROLLBAR = 5;
const MSGF_NEXTWINDOW = 6;
const MSGF_MAINLOOP = 8;
const MSGF_USER = 4096;

const MOUSEEVENTF_MOVE = 1;
const MOUSEEVENTF_LEFTDOWN = 2;
const MOUSEEVENTF_LEFTUP = 4;
const MOUSEEVENTF_RIGHTDOWN = 8;
const MOUSEEVENTF_RIGHTUP = 16;
const MOUSEEVENTF_MIDDLEDOWN = 32;
const MOUSEEVENTF_MIDDLEUP = 64;
const MOUSEEVENTF_WHEEL = 0x0800;
const MOUSEEVENTF_ABSOLUTE = 32768;

const PM_NOREMOVE = 0;
const PM_REMOVE = 1;
const PM_NOYIELD = 2;

static if (WINVER >= 0x500) {
const PM_QS_INPUT = (QS_INPUT << 16);
const PM_QS_POSTMESSAGE = ((QS_POSTMESSAGE|QS_HOTKEY|QS_TIMER) << 16);
const PM_QS_PAINT = (QS_PAINT << 16);
const PM_QS_SENDMESSAGE = (QS_SENDMESSAGE << 16);
}
const HWND
	HWND_BROADCAST = cast(HWND)0xffff,
	HWND_BOTTOM    = cast(HWND)1,
	HWND_NOTOPMOST = cast(HWND)(-2),
	HWND_TOP       = cast(HWND)0,
	HWND_TOPMOST   = cast(HWND)(-1),
	HWND_DESKTOP   = cast(HWND)0,
	HWND_MESSAGE   = cast(HWND)(-3);// w2k

const RDW_INVALIDATE      = 1;
const RDW_INTERNALPAINT   = 2;
const RDW_ERASE           = 4;
const RDW_VALIDATE        = 8;
const RDW_NOINTERNALPAINT = 16;
const RDW_NOERASE         = 32;
const RDW_NOCHILDREN      = 64;
const RDW_ALLCHILDREN     = 128;
const RDW_UPDATENOW       = 256;
const RDW_ERASENOW        = 512;
const RDW_FRAME           = 1024;
const RDW_NOFRAME         = 2048;

const SMTO_NORMAL      = 0;
const SMTO_BLOCK       = 1;
const SMTO_ABORTIFHUNG = 2;

const SIF_ALL = 23;
const SIF_PAGE = 2;
const SIF_POS = 4;
const SIF_RANGE = 1;
const SIF_DISABLENOSCROLL = 8;
const SIF_TRACKPOS = 16;

const SWP_DRAWFRAME = 32;
const SWP_FRAMECHANGED = 32;
const SWP_HIDEWINDOW = 128;
const SWP_NOACTIVATE = 16;
const SWP_NOCOPYBITS = 256;
const SWP_NOMOVE = 2;
const SWP_NOSIZE = 1;
const SWP_NOREDRAW = 8;
const SWP_NOZORDER = 4;
const SWP_SHOWWINDOW = 64;
const SWP_NOOWNERZORDER = 512;
const SWP_NOREPOSITION = 512;
const SWP_NOSENDCHANGING = 1024;
const SWP_DEFERERASE = 8192;
const SWP_ASYNCWINDOWPOS = 16384;

const HSHELL_ACTIVATESHELLWINDOW = 3;
const HSHELL_GETMINRECT = 5;
const HSHELL_LANGUAGE = 8;
const HSHELL_REDRAW = 6;
const HSHELL_TASKMAN = 7;
const HSHELL_WINDOWACTIVATED = 4;
const HSHELL_WINDOWCREATED = 1;
const HSHELL_WINDOWDESTROYED = 2;
const HSHELL_FLASH = 32774;

static if (WINVER >= 0x500) {
const SPI_SETFOREGROUNDLOCKTIMEOUT=0x2001;
const SPI_GETFOREGROUNDLOCKTIMEOUT=0x2000;
}

const SPI_GETACCESSTIMEOUT=60;
const SPI_GETACTIVEWNDTRKTIMEOUT=8194;
const SPI_GETANIMATION=72;
const SPI_GETBEEP=1;
const SPI_GETBORDER=5;
const SPI_GETDEFAULTINPUTLANG=89;
const SPI_GETDRAGFULLWINDOWS=38;
const SPI_GETFASTTASKSWITCH=35;
const SPI_GETFILTERKEYS=50;
const SPI_GETFONTSMOOTHING=74;
const SPI_GETGRIDGRANULARITY=18;
const SPI_GETHIGHCONTRAST=66;
const SPI_GETICONMETRICS=45;
const SPI_GETICONTITLELOGFONT=31;
const SPI_GETICONTITLEWRAP=25;
const SPI_GETKEYBOARDDELAY=22;
const SPI_GETKEYBOARDPREF=68;
const SPI_GETKEYBOARDSPEED=10;
const SPI_GETLOWPOWERACTIVE=83;
const SPI_GETLOWPOWERTIMEOUT=79;
const SPI_GETMENUDROPALIGNMENT=27;
const SPI_GETMINIMIZEDMETRICS=43;
const SPI_GETMOUSE=3;
const SPI_GETMOUSEKEYS=54;
const SPI_GETMOUSETRAILS=94;
const SPI_GETNONCLIENTMETRICS=41;
const SPI_GETPOWEROFFACTIVE=84;
const SPI_GETPOWEROFFTIMEOUT=80;
const SPI_GETSCREENREADER=70;
const SPI_GETSCREENSAVEACTIVE=16;
const SPI_GETSCREENSAVETIMEOUT=14;
const SPI_GETSERIALKEYS=62;
const SPI_GETSHOWSOUNDS=56;
const SPI_GETSOUNDSENTRY=64;
const SPI_GETSTICKYKEYS=58;
const SPI_GETTOGGLEKEYS=52;
const SPI_GETWHEELSCROLLLINES=104;
const SPI_GETWINDOWSEXTENSION=92;
const SPI_GETWORKAREA=48;
const SPI_ICONHORIZONTALSPACING=13;
const SPI_ICONVERTICALSPACING=24;
const SPI_LANGDRIVER=12;
const SPI_SCREENSAVERRUNNING=97;
const SPI_SETACCESSTIMEOUT=61;
const SPI_SETACTIVEWNDTRKTIMEOUT=8195;
const SPI_SETANIMATION=73;
const SPI_SETBEEP=2;
const SPI_SETBORDER=6;
const SPI_SETDEFAULTINPUTLANG=90;
const SPI_SETDESKPATTERN=21;
const SPI_SETDESKWALLPAPER=20;
const SPI_SETDOUBLECLICKTIME=32;
const SPI_SETDOUBLECLKHEIGHT=30;
const SPI_SETDOUBLECLKWIDTH=29;
const SPI_SETDRAGFULLWINDOWS=37;
const SPI_SETDRAGHEIGHT=77;
const SPI_SETDRAGWIDTH=76;
const SPI_SETFASTTASKSWITCH=36;
const SPI_SETFILTERKEYS=51;
const SPI_SETFONTSMOOTHING=75;
const SPI_SETGRIDGRANULARITY=19;
const SPI_SETHANDHELD=78;
const SPI_SETHIGHCONTRAST=67;
const SPI_SETICONMETRICS=46;
const SPI_SETICONTITLELOGFONT=34;
const SPI_SETICONTITLEWRAP=26;
const SPI_SETKEYBOARDDELAY=23;
const SPI_SETKEYBOARDPREF=69;
const SPI_SETKEYBOARDSPEED=11;
const SPI_SETLANGTOGGLE=91;
const SPI_SETLOWPOWERACTIVE=85;
const SPI_SETLOWPOWERTIMEOUT=81;
const SPI_SETMENUDROPALIGNMENT=28;
const SPI_SETMINIMIZEDMETRICS=44;
const SPI_SETMOUSE=4;
const SPI_SETMOUSEBUTTONSWAP=33;
const SPI_SETMOUSEKEYS=55;
const SPI_SETMOUSETRAILS=93;
const SPI_SETNONCLIENTMETRICS=42;
const SPI_SETPENWINDOWS=49;
const SPI_SETPOWEROFFACTIVE=86;
const SPI_SETPOWEROFFTIMEOUT=82;
const SPI_SETSCREENREADER=71;
const SPI_SETSCREENSAVEACTIVE=17;
const SPI_SETSCREENSAVERRUNNING=97;
const SPI_SETSCREENSAVETIMEOUT=15;
const SPI_SETSERIALKEYS=63;
const SPI_SETSHOWSOUNDS=57;
const SPI_SETSOUNDSENTRY=65;
const SPI_SETSTICKYKEYS=59;
const SPI_SETTOGGLEKEYS=53;
const SPI_SETWHEELSCROLLLINES=105;
const SPI_SETWORKAREA=47;

static if (WINVER >= 0x500) {
const SPI_GETDESKWALLPAPER=115;
const SPI_GETMOUSESPEED=112;
const SPI_GETSCREENSAVERRUNNING=114;
const SPI_GETACTIVEWINDOWTRACKING=0x1000;
const SPI_GETACTIVEWNDTRKZORDER=0x100C;
const SPI_GETCOMBOBOXANIMATION=0x1004;
const SPI_GETCURSORSHADOW=0x101A;
const SPI_GETGRADIENTCAPTIONS=0x1008;
const SPI_GETHOTTRACKING=0x100E;
const SPI_GETKEYBOARDCUES=0x100A;
const SPI_GETLISTBOXSMOOTHSCROLLING=0x1006;
const SPI_GETMENUANIMATION=0x1002;
const SPI_GETMENUFADE=0x1012;
const SPI_GETMENUUNDERLINES=0x100A;
const SPI_GETSELECTIONFADE=0x1014;
const SPI_GETTOOLTIPANIMATION=0x1016;
const SPI_GETTOOLTIPFADE=0x1018;
const SPI_SETACTIVEWINDOWTRACKING=0x1001;
const SPI_SETACTIVEWNDTRKZORDER=0x100D;
const SPI_SETCOMBOBOXANIMATION=0x1005;
const SPI_SETCURSORSHADOW=0x101B;
const SPI_SETGRADIENTCAPTIONS=0x1009;
const SPI_SETHOTTRACKING=0x100F;
const SPI_SETKEYBOARDCUES=0x100B;
const SPI_SETLISTBOXSMOOTHSCROLLING=0x1007;
const SPI_SETMENUANIMATION=0x1003;
const SPI_SETMENUFADE=0x1013;
const SPI_SETMENUUNDERLINES=0x100B;
const SPI_SETMOUSESPEED=113;
const SPI_SETSELECTIONFADE=0x1015;
const SPI_SETTOOLTIPANIMATION=0x1017;
const SPI_SETTOOLTIPFADE=0x1019;
}

const SPIF_UPDATEINIFILE=1;
const SPIF_SENDWININICHANGE=2;
const SPIF_SENDCHANGE=2;
// [Redefined] ATF_ONOFFFEEDBACK=2
// [Redefined] ATF_TIMEOUTON=1
const WM_APP=32768;
const WM_ACTIVATE=6;
const WM_ACTIVATEAPP=28;
// FIXME/CHECK: Are WM_AFX {FIRST, LAST} valid for WINVER < 0x400?
const WM_AFXFIRST=864;
const WM_AFXLAST=895;
const WM_ASKCBFORMATNAME=780;
const WM_CANCELJOURNAL=75;
const WM_CANCELMODE=31;
const WM_CAPTURECHANGED=533;
const WM_CHANGECBCHAIN=781;
const WM_CHAR=258;
const WM_CHARTOITEM=47;
const WM_CHILDACTIVATE=34;
const WM_CLEAR=771;
const WM_CLOSE=16;
const WM_COMMAND=273;
const WM_COMMNOTIFY=68; // obsolete
const WM_COMPACTING=65;
const WM_COMPAREITEM=57;
const WM_CONTEXTMENU=123;
const WM_COPY=769;
const WM_COPYDATA=74;
const WM_CREATE=1;
const WM_CTLCOLORBTN=309;
const WM_CTLCOLORDLG=310;
const WM_CTLCOLOREDIT=307;
const WM_CTLCOLORLISTBOX=308;
const WM_CTLCOLORMSGBOX=306;
const WM_CTLCOLORSCROLLBAR=311;
const WM_CTLCOLORSTATIC=312;
const WM_CUT=768;
const WM_DEADCHAR=259;
const WM_DELETEITEM=45;
const WM_DESTROY=2;
const WM_DESTROYCLIPBOARD=775;
const WM_DEVICECHANGE=537;
const WM_DEVMODECHANGE=27;
const WM_DISPLAYCHANGE=126;
const WM_DRAWCLIPBOARD=776;
const WM_DRAWITEM=43;
const WM_DROPFILES=563;
const WM_ENABLE=10;
const WM_ENDSESSION=22;
const WM_ENTERIDLE=289;
const WM_ENTERMENULOOP=529;
const WM_ENTERSIZEMOVE=561;
const WM_ERASEBKGND=20;
const WM_EXITMENULOOP=530;
const WM_EXITSIZEMOVE=562;
const WM_FONTCHANGE=29;
const WM_GETDLGCODE=135;
const WM_GETFONT=49;
const WM_GETHOTKEY=51;
const WM_GETICON=127;
const WM_GETMINMAXINFO=36;
const WM_GETTEXT=13;
const WM_GETTEXTLENGTH=14;
const WM_HANDHELDFIRST=856;
const WM_HANDHELDLAST=863;
const WM_HELP=83;
const WM_HOTKEY=786;
const WM_HSCROLL=276;
const WM_HSCROLLCLIPBOARD=782;
const WM_ICONERASEBKGND=39;
const WM_INITDIALOG=272;
const WM_INITMENU=278;
const WM_INITMENUPOPUP=279;
const WM_INPUTLANGCHANGE=81;
const WM_INPUTLANGCHANGEREQUEST=80;
const WM_KEYDOWN=256;
const WM_KEYUP=257;
const WM_KILLFOCUS=8;
const WM_MDIACTIVATE=546;
const WM_MDICASCADE=551;
const WM_MDICREATE=544;
const WM_MDIDESTROY=545;
const WM_MDIGETACTIVE=553;
const WM_MDIICONARRANGE=552;
const WM_MDIMAXIMIZE=549;
const WM_MDINEXT=548;
const WM_MDIREFRESHMENU=564;
const WM_MDIRESTORE=547;
const WM_MDISETMENU=560;
const WM_MDITILE=550;
const WM_MEASUREITEM=44;
static if (WINVER >= 0x500) {
const WM_UNINITMENUPOPUP=0x0125;
const WM_MENURBUTTONUP=290;
const WM_MENUCOMMAND=0x0126;
const WM_MENUGETOBJECT=0x0124;
const WM_MENUDRAG=0x0123;
}

static if (_WIN32_WINNT >= 0x500) {

	enum {
		WM_CHANGEUISTATE	=	0x0127,
		WM_UPDATEUISTATE	=	0x0128,
		WM_QUERYUISTATE		=	0x0129
	}

	// LOWORD(wParam) values in WM_*UISTATE*
	enum {
		UIS_SET			=	1,
		UIS_CLEAR		=	2,
		UIS_INITIALIZE	=	3
	}

	// HIWORD(wParam) values in WM_*UISTATE*
	enum {
		UISF_HIDEFOCUS	=	0x1,
		UISF_HIDEACCEL	=	0x2
	}

}

static if (_WIN32_WINNT >= 0x501) {

	// HIWORD(wParam) values in WM_*UISTATE*
	enum {
		UISF_ACTIVE		=	0x4
	}

}

const WM_MENUCHAR=288;
const WM_MENUSELECT=287;
const WM_MOVE=3;
const WM_MOVING=534;
const WM_NCACTIVATE=134;
const WM_NCCALCSIZE=131;
const WM_NCCREATE=129;
const WM_NCDESTROY=130;
const WM_NCHITTEST=132;
const WM_NCLBUTTONDBLCLK=163;
const WM_NCLBUTTONDOWN=161;
const WM_NCLBUTTONUP=162;
const WM_NCMBUTTONDBLCLK=169;
const WM_NCMBUTTONDOWN=167;
const WM_NCMBUTTONUP=168;
static if (_WIN32_WINNT >= 0x500) {
const WM_NCXBUTTONDOWN=171;
const WM_NCXBUTTONUP=172;
const WM_NCXBUTTONDBLCLK=173;
const WM_NCMOUSEHOVER=0x02A0;
const WM_NCMOUSELEAVE=0x02A2;
}
const WM_NCMOUSEMOVE=160;
const WM_NCPAINT=133;
const WM_NCRBUTTONDBLCLK=166;
const WM_NCRBUTTONDOWN=164;
const WM_NCRBUTTONUP=165;
const WM_NEXTDLGCTL=40;
const WM_NEXTMENU=531;
const WM_NOTIFY=78;
const WM_NOTIFYFORMAT=85;
const WM_NULL=0;
const WM_PAINT=15;
const WM_PAINTCLIPBOARD=777;
const WM_PAINTICON=38;
const WM_PALETTECHANGED=785;
const WM_PALETTEISCHANGING=784;
const WM_PARENTNOTIFY=528;
const WM_PASTE=770;
const WM_PENWINFIRST=896;
const WM_PENWINLAST=911;
const WM_POWER=72;
const WM_POWERBROADCAST=536;
const WM_PRINT=791;
const WM_PRINTCLIENT=792;
const WM_QUERYDRAGICON=55;
const WM_QUERYENDSESSION=17;
const WM_QUERYNEWPALETTE=783;
const WM_QUERYOPEN=19;
const WM_QUEUESYNC=35;
const WM_QUIT=18;
const WM_RENDERALLFORMATS=774;
const WM_RENDERFORMAT=773;
const WM_SETCURSOR=32;
const WM_SETFOCUS=7;
const WM_SETFONT=48;
const WM_SETHOTKEY=50;
const WM_SETICON=128;
const WM_SETREDRAW=11;
const WM_SETTEXT=12;
const WM_SETTINGCHANGE=26;
const WM_SHOWWINDOW=24;
const WM_SIZE=5;
const WM_SIZECLIPBOARD=779;
const WM_SIZING=532;
const WM_SPOOLERSTATUS=42;
const WM_STYLECHANGED=125;
const WM_STYLECHANGING=124;
const WM_SYSCHAR=262;
const WM_SYSCOLORCHANGE=21;
const WM_SYSCOMMAND=274;
const WM_SYSDEADCHAR=263;
const WM_SYSKEYDOWN=260;
const WM_SYSKEYUP=261;
const WM_TCARD=82;
const WM_THEMECHANGED=794;
const WM_TIMECHANGE=30;
const WM_TIMER=275;
const WM_UNDO=772;
const WM_USER=1024;
const WM_USERCHANGED=84;
const WM_VKEYTOITEM=46;
const WM_VSCROLL=277;
const WM_VSCROLLCLIPBOARD=778;
const WM_WINDOWPOSCHANGED=71;
const WM_WINDOWPOSCHANGING=70;
const WM_WININICHANGE=26;
const WM_KEYFIRST=256;
const WM_KEYLAST=264;
const WM_SYNCPAINT=136;
const WM_MOUSEACTIVATE=33;
const WM_MOUSEMOVE=512;
const WM_LBUTTONDOWN=513;
const WM_LBUTTONUP=514;
const WM_LBUTTONDBLCLK=515;
const WM_RBUTTONDOWN=516;
const WM_RBUTTONUP=517;
const WM_RBUTTONDBLCLK=518;
const WM_MBUTTONDOWN=519;
const WM_MBUTTONUP=520;
const WM_MBUTTONDBLCLK=521;
const WM_MOUSEWHEEL=522;
const WM_MOUSEFIRST=512;
static if (_WIN32_WINNT >= 0x500) {
const WM_XBUTTONDOWN=523;
const WM_XBUTTONUP=524;
const WM_XBUTTONDBLCLK=525;
const WM_MOUSELAST=525;
} else {
const WM_MOUSELAST=522;
}
const WM_MOUSEHOVER=0x2A1;
const WM_MOUSELEAVE=0x2A3;
static if (_WIN32_WINNT >= 0x400) {
const WHEEL_DELTA=120;

SHORT GET_WHEEL_DELTA_WPARAM(WPARAM wparam)
{
return cast(SHORT) HIWORD(wparam);
}

const WHEEL_PAGESCROLL = uint.max;
}
const BM_CLICK=245;
const BM_GETCHECK=240;
const BM_GETIMAGE=246;
const BM_GETSTATE=242;
const BM_SETCHECK=241;
const BM_SETIMAGE=247;
const BM_SETSTATE=243;
const BM_SETSTYLE=244;
const BN_CLICKED=0;
const BN_DBLCLK=5;
const BN_DISABLE=4;
const BN_DOUBLECLICKED=5;
const BN_HILITE=2;
const BN_KILLFOCUS=7;
const BN_PAINT=1;
const BN_PUSHED=2;
const BN_SETFOCUS=6;
const BN_UNHILITE=3;
const BN_UNPUSHED=3;
const CB_ADDSTRING=323;
const CB_DELETESTRING=324;
const CB_DIR=325;
const CB_FINDSTRING=332;
const CB_FINDSTRINGEXACT=344;
const CB_GETCOUNT=326;
const CB_GETCURSEL=327;
const CB_GETDROPPEDCONTROLRECT=338;
const CB_GETDROPPEDSTATE=343;
const CB_GETDROPPEDWIDTH=351;
const CB_GETEDITSEL=320;
const CB_GETEXTENDEDUI=342;
const CB_GETHORIZONTALEXTENT=349;
const CB_GETITEMDATA=336;
const CB_GETITEMHEIGHT=340;
const CB_GETLBTEXT=328;
const CB_GETLBTEXTLEN=329;
const CB_GETLOCALE=346;
const CB_GETTOPINDEX=347;
const CB_INITSTORAGE=353;
const CB_INSERTSTRING=330;
const CB_LIMITTEXT=321;
const CB_RESETCONTENT=331;
const CB_SELECTSTRING=333;
const CB_SETCURSEL=334;
const CB_SETDROPPEDWIDTH=352;
const CB_SETEDITSEL=322;
const CB_SETEXTENDEDUI=341;
const CB_SETHORIZONTALEXTENT=350;
const CB_SETITEMDATA=337;
const CB_SETITEMHEIGHT=339;
const CB_SETLOCALE=345;
const CB_SETTOPINDEX=348;
const CB_SHOWDROPDOWN=335;

const CBN_CLOSEUP=8;
const CBN_DBLCLK=2;
const CBN_DROPDOWN=7;
const CBN_EDITCHANGE=5;
const CBN_EDITUPDATE=6;
const CBN_ERRSPACE=(-1);
const CBN_KILLFOCUS=4;
const CBN_SELCHANGE=1;
const CBN_SELENDCANCEL=10;
const CBN_SELENDOK=9;
const CBN_SETFOCUS=3;

const EM_CANUNDO=198;
const EM_CHARFROMPOS=215;
const EM_EMPTYUNDOBUFFER=205;
const EM_FMTLINES=200;
const EM_GETFIRSTVISIBLELINE=206;
const EM_GETHANDLE=189;
const EM_GETLIMITTEXT=213;
const EM_GETLINE=196;
const EM_GETLINECOUNT=186;
const EM_GETMARGINS=212;
const EM_GETMODIFY=184;
const EM_GETPASSWORDCHAR=210;
const EM_GETRECT=178;
const EM_GETSEL=176;
const EM_GETTHUMB=190;
const EM_GETWORDBREAKPROC=209;
const EM_LIMITTEXT=197;
const EM_LINEFROMCHAR=201;
const EM_LINEINDEX=187;
const EM_LINELENGTH=193;
const EM_LINESCROLL=182;
const EM_POSFROMCHAR=214;
const EM_REPLACESEL=194;
const EM_SCROLL=181;
const EM_SCROLLCARET=183;
const EM_SETHANDLE=188;
const EM_SETLIMITTEXT=197;
const EM_SETMARGINS=211;
const EM_SETMODIFY=185;
const EM_SETPASSWORDCHAR=204;
const EM_SETREADONLY=207;
const EM_SETRECT=179;
const EM_SETRECTNP=180;
const EM_SETSEL=177;
const EM_SETTABSTOPS=203;
const EM_SETWORDBREAKPROC=208;
const EM_UNDO=199;

const EN_CHANGE=768;
const EN_ERRSPACE=1280;
const EN_HSCROLL=1537;
const EN_KILLFOCUS=512;
const EN_MAXTEXT=1281;
const EN_SETFOCUS=256;
const EN_UPDATE=1024;
const EN_VSCROLL=1538;

const LB_ADDFILE=406;
const LB_ADDSTRING=384;
const LB_DELETESTRING=386;
const LB_DIR=397;
const LB_FINDSTRING=399;
const LB_FINDSTRINGEXACT=418;
const LB_GETANCHORINDEX=413;
const LB_GETCARETINDEX=415;
const LB_GETCOUNT=395;
const LB_GETCURSEL=392;
const LB_GETHORIZONTALEXTENT=403;
const LB_GETITEMDATA=409;
const LB_GETITEMHEIGHT=417;
const LB_GETITEMRECT=408;
const LB_GETLOCALE=422;
const LB_GETSEL=391;
const LB_GETSELCOUNT=400;
const LB_GETSELITEMS=401;
const LB_GETTEXT=393;
const LB_GETTEXTLEN=394;
const LB_GETTOPINDEX=398;
const LB_INITSTORAGE=424;
const LB_INSERTSTRING=385;
const LB_ITEMFROMPOINT=425;
const LB_RESETCONTENT=388;
const LB_SELECTSTRING=396;
const LB_SELITEMRANGE=411;
const LB_SELITEMRANGEEX=387;
const LB_SETANCHORINDEX=412;
const LB_SETCARETINDEX=414;
const LB_SETCOLUMNWIDTH=405;
const LB_SETCOUNT=423;
const LB_SETCURSEL=390;
const LB_SETHORIZONTALEXTENT=404;
const LB_SETITEMDATA=410;
const LB_SETITEMHEIGHT=416;
const LB_SETLOCALE=421;
const LB_SETSEL=389;
const LB_SETTABSTOPS=402;
const LB_SETTOPINDEX=407;

const LBN_DBLCLK=2;
const LBN_ERRSPACE=-2;
const LBN_KILLFOCUS=5;
const LBN_SELCANCEL=3;
const LBN_SELCHANGE=1;
const LBN_SETFOCUS=4;

const SBM_ENABLE_ARROWS=228;
const SBM_GETPOS=225;
const SBM_GETRANGE=227;
const SBM_GETSCROLLINFO=234;
const SBM_SETPOS=224;
const SBM_SETRANGE=226;
const SBM_SETRANGEREDRAW=230;
const SBM_SETSCROLLINFO=233;
const STM_GETICON=369;
const STM_GETIMAGE=371;
const STM_SETICON=368;
const STM_SETIMAGE=370;
const STN_CLICKED=0;
const STN_DBLCLK=1;
const STN_DISABLE=3;
const STN_ENABLE=2;

const DM_GETDEFID   = WM_USER;
const DM_SETDEFID   = WM_USER+1;
const DM_REPOSITION = WM_USER+2;

const PSM_PAGEINFO  = WM_USER+100;
const PSM_SHEETINFO = WM_USER+101;

const PSI_SETACTIVE=1;
const PSI_KILLACTIVE=2;
const PSI_APPLY=3;
const PSI_RESET=4;
const PSI_HASHELP=5;
const PSI_HELP=6;
const PSI_CHANGED=1;
const PSI_GUISTART=2;
const PSI_REBOOT=3;
const PSI_GETSIBLINGS=4;

const DCX_WINDOW=1;
const DCX_CACHE=2;
const DCX_PARENTCLIP=32;
const DCX_CLIPSIBLINGS=16;
const DCX_CLIPCHILDREN=8;
const DCX_NORESETATTRS=4;
const DCX_INTERSECTUPDATE=0x200;
const DCX_LOCKWINDOWUPDATE=0x400;
const DCX_EXCLUDERGN=64;
const DCX_INTERSECTRGN=128;
const DCX_VALIDATE=0x200000;

const GMDI_GOINTOPOPUPS=2;
const GMDI_USEDISABLED=1;
const FKF_AVAILABLE=2;
const FKF_CLICKON=64;
const FKF_FILTERKEYSON=1;
const FKF_HOTKEYACTIVE=4;
const FKF_HOTKEYSOUND=16;
const FKF_CONFIRMHOTKEY=8;
const FKF_INDICATOR=32;
const HCF_HIGHCONTRASTON=1;
const HCF_AVAILABLE=2;
const HCF_HOTKEYACTIVE=4;
const HCF_CONFIRMHOTKEY=8;
const HCF_HOTKEYSOUND=16;
const HCF_INDICATOR=32;
const HCF_HOTKEYAVAILABLE=64;
const MKF_AVAILABLE=2;
const MKF_CONFIRMHOTKEY=8;
const MKF_HOTKEYACTIVE=4;
const MKF_HOTKEYSOUND=16;
const MKF_INDICATOR=32;
const MKF_MOUSEKEYSON=1;
const MKF_MODIFIERS=64;
const MKF_REPLACENUMBERS=128;
const SERKF_ACTIVE=8;  // May be obsolete. Not in recent MS docs.
const SERKF_AVAILABLE=2;
const SERKF_INDICATOR=4;
const SERKF_SERIALKEYSON=1;
const SSF_AVAILABLE=2;
const SSF_SOUNDSENTRYON=1;
const SSTF_BORDER=2;
const SSTF_CHARS=1;
const SSTF_DISPLAY=3;
const SSTF_NONE=0;
const SSGF_DISPLAY=3;
const SSGF_NONE=0;
const SSWF_CUSTOM=4;
const SSWF_DISPLAY=3;
const SSWF_NONE=0;
const SSWF_TITLE=1;
const SSWF_WINDOW=2;
const SKF_AUDIBLEFEEDBACK=64;
const SKF_AVAILABLE=2;
const SKF_CONFIRMHOTKEY=8;
const SKF_HOTKEYACTIVE=4;
const SKF_HOTKEYSOUND=16;
const SKF_INDICATOR=32;
const SKF_STICKYKEYSON=1;
const SKF_TRISTATE=128;
const SKF_TWOKEYSOFF=256;
const TKF_AVAILABLE=2;
const TKF_CONFIRMHOTKEY=8;
const TKF_HOTKEYACTIVE=4;
const TKF_HOTKEYSOUND=16;
const TKF_TOGGLEKEYSON=1;
const MDITILE_SKIPDISABLED=2;
const MDITILE_HORIZONTAL=1;
const MDITILE_VERTICAL=0;

const VK_LBUTTON=1;
const VK_RBUTTON=2;
const VK_CANCEL=3;
const VK_MBUTTON=4;
static if (_WIN32_WINNT >= 0x500) {
const VK_XBUTTON1=5;
const VK_XBUTTON2=6;
}
const VK_BACK=8;
const VK_TAB=9;
const VK_CLEAR=12;
const VK_RETURN=13;
const VK_SHIFT=16;
const VK_CONTROL=17;
const VK_MENU=18;
const VK_PAUSE=19;
const VK_CAPITAL=20;
const VK_KANA=0x15;
const VK_HANGEUL=0x15;
const VK_HANGUL=0x15;
const VK_JUNJA=0x17;
const VK_FINAL=0x18;
const VK_HANJA=0x19;
const VK_KANJI=0x19;
const VK_ESCAPE=0x1B;
const VK_CONVERT=0x1C;
const VK_NONCONVERT=0x1D;
const VK_ACCEPT=0x1E;
const VK_MODECHANGE=0x1F;
const VK_SPACE=32;
const VK_PRIOR=33;
const VK_NEXT=34;
const VK_END=35;
const VK_HOME=36;
const VK_LEFT=37;
const VK_UP=38;
const VK_RIGHT=39;
const VK_DOWN=40;
const VK_SELECT=41;
const VK_PRINT=42;
const VK_EXECUTE=43;
const VK_SNAPSHOT=44;
const VK_INSERT=45;
const VK_DELETE=46;
const VK_HELP=47;
const VK_LWIN=0x5B;
const VK_RWIN=0x5C;
const VK_APPS=0x5D;
const VK_SLEEP=0x5F;
const VK_NUMPAD0=0x60;
const VK_NUMPAD1=0x61;
const VK_NUMPAD2=0x62;
const VK_NUMPAD3=0x63;
const VK_NUMPAD4=0x64;
const VK_NUMPAD5=0x65;
const VK_NUMPAD6=0x66;
const VK_NUMPAD7=0x67;
const VK_NUMPAD8=0x68;
const VK_NUMPAD9=0x69;
const VK_MULTIPLY=0x6A;
const VK_ADD=0x6B;
const VK_SEPARATOR=0x6C;
const VK_SUBTRACT=0x6D;
const VK_DECIMAL=0x6E;
const VK_DIVIDE=0x6F;
const VK_F1=0x70;
const VK_F2=0x71;
const VK_F3=0x72;
const VK_F4=0x73;
const VK_F5=0x74;
const VK_F6=0x75;
const VK_F7=0x76;
const VK_F8=0x77;
const VK_F9=0x78;
const VK_F10=0x79;
const VK_F11=0x7A;
const VK_F12=0x7B;
const VK_F13=0x7C;
const VK_F14=0x7D;
const VK_F15=0x7E;
const VK_F16=0x7F;
const VK_F17=0x80;
const VK_F18=0x81;
const VK_F19=0x82;
const VK_F20=0x83;
const VK_F21=0x84;
const VK_F22=0x85;
const VK_F23=0x86;
const VK_F24=0x87;
const VK_NUMLOCK=0x90;
const VK_SCROLL=0x91;
const VK_LSHIFT=0xA0;
const VK_RSHIFT=0xA1;
const VK_LCONTROL=0xA2;
const VK_RCONTROL=0xA3;
const VK_LMENU=0xA4;
const VK_RMENU=0xA5;
static if (_WIN32_WINNT >= 0x500) {
const VK_BROWSER_BACK=0xA6;
const VK_BROWSER_FORWARD=0xA7;
const VK_BROWSER_REFRESH=0xA8;
const VK_BROWSER_STOP=0xA9;
const VK_BROWSER_SEARCH=0xAA;
const VK_BROWSER_FAVORITES=0xAB;
const VK_BROWSER_HOME=0xAC;
const VK_VOLUME_MUTE=0xAD;
const VK_VOLUME_DOWN=0xAE;
const VK_VOLUME_UP=0xAF;
const VK_MEDIA_NEXT_TRACK=0xB0;
const VK_MEDIA_PREV_TRACK=0xB1;
const VK_MEDIA_STOP=0xB2;
const VK_MEDIA_PLAY_PAUSE=0xB3;
const VK_LAUNCH_MAIL=0xB4;
const VK_LAUNCH_MEDIA_SELECT=0xB5;
const VK_LAUNCH_APP1=0xB6;
const VK_LAUNCH_APP2=0xB7;
}
const VK_OEM_1=0xBA;
static if (_WIN32_WINNT >= 0x500) {
const VK_OEM_PLUS=0xBB;
const VK_OEM_COMMA=0xBC;
const VK_OEM_MINUS=0xBD;
const VK_OEM_PERIOD=0xBE;
}
const VK_OEM_2=0xBF;
const VK_OEM_3=0xC0;
const VK_OEM_4=0xDB;
const VK_OEM_5=0xDC;
const VK_OEM_6=0xDD;
const VK_OEM_7=0xDE;
const VK_OEM_8=0xDF;
static if (_WIN32_WINNT >= 0x500) {
const VK_OEM_102=0xE2;
}
const VK_PROCESSKEY=0xE5;
static if (_WIN32_WINNT >= 0x500) {
const VK_PACKET=0xE7;
}
const VK_ATTN=0xF6;
const VK_CRSEL=0xF7;
const VK_EXSEL=0xF8;
const VK_EREOF=0xF9;
const VK_PLAY=0xFA;
const VK_ZOOM=0xFB;
const VK_NONAME=0xFC;
const VK_PA1=0xFD;
const VK_OEM_CLEAR=0xFE;

const TME_HOVER=1;
const TME_LEAVE=2;
const TME_QUERY=0x40000000;
const TME_CANCEL=0x80000000;

const HOVER_DEFAULT=0xFFFFFFFF;

const MK_LBUTTON=1;
const MK_RBUTTON=2;
const MK_SHIFT=4;
const MK_CONTROL=8;
const MK_MBUTTON=16;
static if (_WIN32_WINNT >= 0x500) {
const MK_XBUTTON1=32;
const MK_XBUTTON2=64;
}
const TPM_CENTERALIGN=4;
const TPM_LEFTALIGN=0;
const TPM_RIGHTALIGN=8;
const TPM_LEFTBUTTON=0;
const TPM_RIGHTBUTTON=2;
const TPM_HORIZONTAL=0;
const TPM_VERTICAL=64;
const TPM_TOPALIGN=0;
const TPM_VCENTERALIGN=16;
const TPM_BOTTOMALIGN=32;
const TPM_NONOTIFY=128;
const TPM_RETURNCMD=256;
static if ((_WIN32_WINNT >= 0x500) || (_WIN32_WINDOWS >= 0x410)) {
const TPM_RECURSE=1;
}

const HELP_COMMAND=0x102;
const HELP_CONTENTS=3;
const HELP_CONTEXT=1;
const HELP_CONTEXTPOPUP=8;
const HELP_FORCEFILE=9;
const HELP_HELPONHELP=4;
const HELP_INDEX=3;
const HELP_KEY=0x101;
const HELP_MULTIKEY=0x201;
const HELP_PARTIALKEY=0x105;
const HELP_QUIT=2;
const HELP_SETCONTENTS=5;
const HELP_SETINDEX=5;
const HELP_SETWINPOS=0x203;
const HELP_CONTEXTMENU=0xa;
const HELP_FINDER=0xb;
const HELP_WM_HELP=0xc;
const HELP_TCARD=0x8000;
const HELP_TCARD_DATA=16;
const HELP_TCARD_OTHER_CALLER=0x11;

const IDH_NO_HELP=28440;
const IDH_MISSING_CONTEXT=28441;
const IDH_GENERIC_HELP_BUTTON=28442;
const IDH_OK=28443;
const IDH_CANCEL=28444;
const IDH_HELP=28445;

const LB_CTLCODE=0;
const LB_OKAY=0;
const LB_ERR=-1;
const LB_ERRSPACE=-2;

const CB_OKAY=0;
const CB_ERR=-1;
const CB_ERRSPACE=-2;

const HIDE_WINDOW=0;

const SHOW_OPENWINDOW=1;
const SHOW_ICONWINDOW=2;
const SHOW_FULLSCREEN=3;
const SHOW_OPENNOACTIVATE=4;

const SW_PARENTCLOSING=1;
const SW_OTHERZOOM=2;
const SW_PARENTOPENING=3;
const SW_OTHERUNZOOM=4;

const KF_EXTENDED=256;
const KF_DLGMODE=2048;
const KF_MENUMODE=4096;
const KF_ALTDOWN=8192;
const KF_REPEAT=16384;
const KF_UP=32768;

const WSF_VISIBLE=1;

const PWR_OK=1;
const PWR_FAIL=-1;
const PWR_SUSPENDREQUEST=1;
const PWR_SUSPENDRESUME=2;
const PWR_CRITICALRESUME=3;

const NFR_ANSI=1;
const NFR_UNICODE=2;
const NF_QUERY=3;
const NF_REQUERY=4;

const MENULOOP_WINDOW=0;
const MENULOOP_POPUP=1;

const WMSZ_LEFT=1;
const WMSZ_RIGHT=2;
const WMSZ_TOP=3;
const WMSZ_TOPLEFT=4;
const WMSZ_TOPRIGHT=5;
const WMSZ_BOTTOM=6;
const WMSZ_BOTTOMLEFT=7;
const WMSZ_BOTTOMRIGHT=8;

const HTERROR=-2;
const HTTRANSPARENT=-1;
const HTNOWHERE=0;
const HTCLIENT=1;
const HTCAPTION=2;
const HTSYSMENU=3;
const HTGROWBOX=4;
const HTSIZE=4;
const HTMENU=5;
const HTHSCROLL=6;
const HTVSCROLL=7;
const HTMINBUTTON=8;
const HTMAXBUTTON=9;
const HTREDUCE=8;
const HTZOOM=9;
const HTLEFT=10;
const HTSIZEFIRST=10;
const HTRIGHT=11;
const HTTOP=12;
const HTTOPLEFT=13;
const HTTOPRIGHT=14;
const HTBOTTOM=15;
const HTBOTTOMLEFT=16;
const HTBOTTOMRIGHT=17;
const HTSIZELAST=17;
const HTBORDER=18;
const HTOBJECT=19;
const HTCLOSE=20;
const HTHELP=21;

const MA_ACTIVATE=1;
const MA_ACTIVATEANDEAT=2;
const MA_NOACTIVATE=3;
const MA_NOACTIVATEANDEAT=4;

const SIZE_RESTORED=0;
const SIZE_MINIMIZED=1;
const SIZE_MAXIMIZED=2;
const SIZE_MAXSHOW=3;
const SIZE_MAXHIDE=4;

const SIZENORMAL=0;
const SIZEICONIC=1;
const SIZEFULLSCREEN=2;
const SIZEZOOMSHOW=3;
const SIZEZOOMHIDE=4;

const WVR_ALIGNTOP=16;
const WVR_ALIGNLEFT=32;
const WVR_ALIGNBOTTOM=64;
const WVR_ALIGNRIGHT=128;
const WVR_HREDRAW=256;
const WVR_VREDRAW=512;
const WVR_REDRAW=(WVR_HREDRAW|WVR_VREDRAW);
const WVR_VALIDRECTS=1024;

const PRF_CHECKVISIBLE=1;
const PRF_NONCLIENT=2;
const PRF_CLIENT=4;
const PRF_ERASEBKGND=8;
const PRF_CHILDREN=16;
const PRF_OWNED=32;

const IDANI_OPEN=1;
const IDANI_CLOSE=2;
const IDANI_CAPTION=3;

const WPF_RESTORETOMAXIMIZED=2;
const WPF_SETMINPOSITION=1;

const ODT_MENU=1;
const ODT_LISTBOX=2;
const ODT_COMBOBOX=3;
const ODT_BUTTON=4;
const ODT_STATIC=5;
const ODA_DRAWENTIRE=1;
const ODA_SELECT=2;
const ODA_FOCUS=4;
const ODS_SELECTED=1;
const ODS_GRAYED=2;
const ODS_DISABLED=4;
const ODS_CHECKED=8;
const ODS_FOCUS=16;
const ODS_DEFAULT=32;
const ODS_COMBOBOXEDIT=4096;

const IDHOT_SNAPWINDOW=-1;
const IDHOT_SNAPDESKTOP=-2;

const DBWF_LPARAMPOINTER=0x8000;
const DLGWINDOWEXTRA=30;
const MNC_IGNORE=0;
const MNC_CLOSE=1;
const MNC_EXECUTE=2;
const MNC_SELECT=3;
const DOF_EXECUTABLE=0x8001;
const DOF_DOCUMENT=0x8002;
const DOF_DIRECTORY=0x8003;
const DOF_MULTIPLE=0x8004;
const DOF_PROGMAN=1;
const DOF_SHELLDATA=2;
const DO_DROPFILE=0x454C4946;
const DO_PRINTFILE=0x544E5250;

const SW_SCROLLCHILDREN=1;
const SW_INVALIDATE=2;
const SW_ERASE=4;

const SC_SIZE=0xF000;
const SC_MOVE=0xF010;
const SC_MINIMIZE=0xF020;
const SC_ICON=0xf020;
const SC_MAXIMIZE=0xF030;
const SC_ZOOM=0xF030;
const SC_NEXTWINDOW=0xF040;
const SC_PREVWINDOW=0xF050;
const SC_CLOSE=0xF060;
const SC_VSCROLL=0xF070;
const SC_HSCROLL=0xF080;
const SC_MOUSEMENU=0xF090;
const SC_KEYMENU=0xF100;
const SC_ARRANGE=0xF110;
const SC_RESTORE=0xF120;
const SC_TASKLIST=0xF130;
const SC_SCREENSAVE=0xF140;
const SC_HOTKEY=0xF150;
const SC_DEFAULT=0xF160;
const SC_MONITORPOWER=0xF170;
const SC_CONTEXTHELP=0xF180;
const SC_SEPARATOR=0xF00F;

const EC_LEFTMARGIN=1;
const EC_RIGHTMARGIN=2;
const EC_USEFONTINFO=0xffff;

const DC_HASDEFID=0x534B;

const DLGC_WANTARROWS=1;
const DLGC_WANTTAB=2;
const DLGC_WANTALLKEYS=4;
const DLGC_WANTMESSAGE=4;
const DLGC_HASSETSEL=8;
const DLGC_DEFPUSHBUTTON=16;
const DLGC_UNDEFPUSHBUTTON=32;
const DLGC_RADIOBUTTON=64;
const DLGC_WANTCHARS=128;
const DLGC_STATIC=256;
const DLGC_BUTTON=0x2000;

const WA_INACTIVE=0;
const WA_ACTIVE=1;
const WA_CLICKACTIVE=2;

const ICON_SMALL=0;
const ICON_BIG=1;
static if (_WIN32_WINNT >= 0x501) {
const ICON_SMALL2=2;
}

const HBITMAP
	HBMMENU_CALLBACK = cast(HBITMAP)-1,
	HBMMENU_SYSTEM = cast(HBITMAP)1,
	HBMMENU_MBAR_RESTORE = cast(HBITMAP)2,
	HBMMENU_MBAR_MINIMIZE = cast(HBITMAP)3,
	HBMMENU_MBAR_CLOSE = cast(HBITMAP)5,
	HBMMENU_MBAR_CLOSE_D = cast(HBITMAP)6,
	HBMMENU_MBAR_MINIMIZE_D = cast(HBITMAP)7,
	HBMMENU_POPUP_CLOSE = cast(HBITMAP)8,
	HBMMENU_POPUP_RESTORE = cast(HBITMAP)9,
	HBMMENU_POPUP_MAXIMIZE = cast(HBITMAP)10,
	HBMMENU_POPUP_MINIMIZE = cast(HBITMAP)11;

const MOD_ALT=1;
const MOD_CONTROL=2;
const MOD_SHIFT=4;
const MOD_WIN=8;
const MOD_IGNORE_ALL_MODIFIER=1024;
const MOD_ON_KEYUP=2048;
const MOD_RIGHT=16384;
const MOD_LEFT=32768;

const LLKHF_EXTENDED=(KF_EXTENDED >> 8);
const LLKHF_INJECTED=0x00000010;
const LLKHF_ALTDOWN=(KF_ALTDOWN >> 8);
const LLKHF_UP=(KF_UP >> 8);

static if (WINVER >= 0x500) {
const FLASHW_STOP=0;
const FLASHW_CAPTION=1;
const FLASHW_TRAY=2;
const FLASHW_ALL=(FLASHW_CAPTION|FLASHW_TRAY);
const FLASHW_TIMER=4;
const FLASHW_TIMERNOFG=12;
}

const CURSOR_SHOWING=0x00000001;
const WS_ACTIVECAPTION=0x00000001;
static if (_WIN32_WINNT >= 0x403) {
const INPUT_MOUSE=0x00000000;
const INPUT_KEYBOARD=0x00000001;
const INPUT_HARDWARE=0x00000002;
}
static if (WINVER >= 0x400) {
const ENDSESSION_LOGOFF = 0x80000000;
}

static if (WINVER >= 0x500) {
const CHILDID_SELF   = 0;
const OBJID_WINDOW   = 0x00000000;
const OBJID_SYSMENU  = 0xFFFFFFFF;
const OBJID_TITLEBAR = 0xFFFFFFFE;
const OBJID_MENU     = 0xFFFFFFFD;
const OBJID_CLIENT   = 0xFFFFFFFC;
const OBJID_VSCROLL  = 0xFFFFFFFB;
const OBJID_HSCROLL  = 0xFFFFFFFA;
const OBJID_SIZEGRIP = 0xFFFFFFF9;
const OBJID_CARET    = 0xFFFFFFF8;
const OBJID_CURSOR   = 0xFFFFFFF7;
const OBJID_ALERT    = 0xFFFFFFF6;
const OBJID_SOUND    = 0xFFFFFFF5;

const GUI_CARETBLINKING  = 0x00000001;
const GUI_INMOVESIZE     = 0x00000002;
const GUI_INMENUMODE     = 0x00000004;
const GUI_SYSTEMMENUMODE = 0x00000008;
const GUI_POPUPMENUMODE  = 0x00000010;

static if (_WIN32_WINNT >= 0x501) {
const GUI_16BITTASK      = 0x00000020;
}
const WINEVENT_OUTOFCONTEXT=0x0000;
const WINEVENT_SKIPOWNTHREAD=0x0001;
const WINEVENT_SKIPOWNPROCESS=0x0002;
const WINEVENT_INCONTEXT=0x0004;
const AW_HOR_POSITIVE=0x00000001;
const AW_HOR_NEGATIVE=0x00000002;
const AW_VER_POSITIVE=0x00000004;
const AW_VER_NEGATIVE=0x00000008;
const AW_CENTER=0x00000010;
const AW_HIDE=0x00010000;
const AW_ACTIVATE=0x00020000;
const AW_SLIDE=0x00040000;
const AW_BLEND=0x00080000;
const DEVICE_NOTIFY_WINDOW_HANDLE=0x00000000;
const DEVICE_NOTIFY_SERVICE_HANDLE=0x00000001;

static if (_WIN32_WINNT >= 0x501) {
const DEVICE_NOTIFY_ALL_INTERFACE_CLASSES=0x00000004;
}

const EVENT_MIN = 0x00000001;
const EVENT_SYSTEM_SOUND = 0x00000001;
const EVENT_SYSTEM_ALERT = 0x00000002;
const EVENT_SYSTEM_FOREGROUND = 0x00000003;
const EVENT_SYSTEM_MENUSTART = 0x00000004;
const EVENT_SYSTEM_MENUEND = 0x00000005;
const EVENT_SYSTEM_MENUPOPUPSTART = 0x00000006;
const EVENT_SYSTEM_MENUPOPUPEND = 0x00000007;
const EVENT_SYSTEM_CAPTURESTART = 0x00000008;
const EVENT_SYSTEM_CAPTUREEND = 0x00000009;
const EVENT_SYSTEM_MOVESIZESTART = 0x0000000a;
const EVENT_SYSTEM_MOVESIZEEND = 0x0000000b;
const EVENT_SYSTEM_CONTEXTHELPSTART = 0x0000000c;
const EVENT_SYSTEM_CONTEXTHELPEND = 0x0000000d;
const EVENT_SYSTEM_DRAGDROPSTART = 0x0000000e;
const EVENT_SYSTEM_DRAGDROPEND = 0x0000000f;
const EVENT_SYSTEM_DIALOGSTART = 0x00000010;
const EVENT_SYSTEM_DIALOGEND = 0x00000011;
const EVENT_SYSTEM_SCROLLINGSTART = 0x00000012;
const EVENT_SYSTEM_SCROLLINGEND = 0x00000013;
const EVENT_SYSTEM_SWITCHSTART = 0x00000014;
const EVENT_SYSTEM_SWITCHEND = 0x00000015;
const EVENT_SYSTEM_MINIMIZESTART = 0x00000016;
const EVENT_SYSTEM_MINIMIZEEND = 0x00000017;

const EVENT_OBJECT_CREATE = 0x00008000;
const EVENT_OBJECT_DESTROY = 0x00008001;
const EVENT_OBJECT_SHOW = 0x00008002;
const EVENT_OBJECT_HIDE = 0x00008003;
const EVENT_OBJECT_REORDER = 0x00008004;
const EVENT_OBJECT_FOCUS = 0x00008005;
const EVENT_OBJECT_SELECTION = 0x00008006;
const EVENT_OBJECT_SELECTIONADD = 0x00008007;
const EVENT_OBJECT_SELECTIONREMOVE = 0x00008008;
const EVENT_OBJECT_SELECTIONWITHIN = 0x00008009;
const EVENT_OBJECT_STATECHANGE = 0x0000800a;
const EVENT_OBJECT_LOCATIONCHANGE = 0x0000800b;
const EVENT_OBJECT_NAMECHANGE = 0x0000800c;
const EVENT_OBJECT_DESCRIPTIONCHANGE = 0x0000800d;
const EVENT_OBJECT_VALUECHANGE = 0x0000800e;
const EVENT_OBJECT_PARENTCHANGE = 0x0000800f;
const EVENT_OBJECT_HELPCHANGE = 0x00008010;
const EVENT_OBJECT_DEFACTIONCHANGE = 0x00008011;
const EVENT_OBJECT_ACCELERATORCHANGE = 0x00008012;

static if (_WIN32_WINNT >= 0x501) {
const EVENT_CONSOLE_CARET             = 0x00004001;
const EVENT_CONSOLE_UPDATE_REGION     = 0x00004002;
const EVENT_CONSOLE_UPDATE_SIMPLE     = 0x00004003;
const EVENT_CONSOLE_UPDATE_SCROLL     = 0x00004004;
const EVENT_CONSOLE_LAYOUT            = 0x00004005;
const EVENT_CONSOLE_START_APPLICATION = 0x00004006;
const EVENT_CONSOLE_END_APPLICATION   = 0x00004007;

const CONSOLE_CARET_SELECTION   = 0x00000001;
const CONSOLE_CARET_VISIBLE     = 0x00000002;

const CONSOLE_APPLICATION_16BIT = 0x00000001;

}
const EVENT_MAX=0x7fffffff;

}//(WINVER >= 0x500)

static if ((_WIN32_WINNT >= 0x500) || (_WIN32_WINDOWS >= 0x490)) {
const DWORD ASFW_ANY = -1;
const LSFW_LOCK   = 1;
const LSFW_UNLOCK = 2;
}

static if (_WIN32_WINNT >= 0x500) {
const LWA_COLORKEY=0x01;
const LWA_ALPHA=0x02;
const ULW_COLORKEY=0x01;
const ULW_ALPHA=0x02;
const ULW_OPAQUE=0x04;
}

const GA_PARENT    = 1;
const GA_ROOT      = 2;
const GA_ROOTOWNER = 3;

static if ((_WIN32_WINNT >= 0x500) || (_WIN32_WINDOWS >= 0x410)) {

const MONITOR_DEFAULTTONULL    = 0;
const MONITOR_DEFAULTTOPRIMARY = 1;
const MONITOR_DEFAULTTONEAREST = 2;
const MONITORINFOF_PRIMARY     = 1;

const EDS_RAWMODE = 0x00000002;

const ISMEX_NOSEND   = 0x00000000;
const ISMEX_SEND     = 0x00000001;
const ISMEX_NOTIFY   = 0x00000002;
const ISMEX_CALLBACK = 0x00000004;
const ISMEX_REPLIED  = 0x00000008;
}

static if (_WIN32_WINNT >= 0x500) {
const GR_GDIOBJECTS  = 0;
const GR_USEROBJECTS = 1;
}

static if ((_WIN32_WINNT >= 0x500) || (_WIN32_WINDOWS >= 0x490)) {
const GMMP_USE_DISPLAY_POINTS         = 1;
const GMMP_USE_HIGH_RESOLUTION_POINTS = 2;
}

static if (_WIN32_WINNT >= 0x501) {
const PW_CLIENTONLY               = 0x00000001;
const RIM_INPUT                   = 0x00000000;
const RIM_INPUTSINK               = 0x00000001;
const RIM_TYPEMOUSE               = 0x00000000;
const RIM_TYPEKEYBOARD            = 0x00000001;
const RIM_TYPEHID                 = 0x00000002;
const MOUSE_MOVE_RELATIVE         = 0x00000000;
const MOUSE_MOVE_ABSOLUTE         = 0x00000001;
const MOUSE_VIRTUAL_DESKTOP       = 0x00000002;
const MOUSE_ATTRIBUTES_CHANGED    = 0x00000004;
const RI_MOUSE_LEFT_BUTTON_DOWN   = 0x0001;
const RI_MOUSE_LEFT_BUTTON_UP     = 0x0002;
const RI_MOUSE_RIGHT_BUTTON_DOWN  = 0x0004;
const RI_MOUSE_RIGHT_BUTTON_UP    = 0x0008;
const RI_MOUSE_MIDDLE_BUTTON_DOWN = 0x0010;
const RI_MOUSE_MIDDLE_BUTTON_UP   = 0x0020;
const RI_MOUSE_BUTTON_1_DOWN = RI_MOUSE_LEFT_BUTTON_DOWN;
const RI_MOUSE_BUTTON_1_UP   = RI_MOUSE_LEFT_BUTTON_UP;
const RI_MOUSE_BUTTON_2_DOWN = RI_MOUSE_RIGHT_BUTTON_DOWN;
const RI_MOUSE_BUTTON_2_UP   = RI_MOUSE_RIGHT_BUTTON_UP;
const RI_MOUSE_BUTTON_3_DOWN = RI_MOUSE_MIDDLE_BUTTON_DOWN;
const RI_MOUSE_BUTTON_3_UP   = RI_MOUSE_MIDDLE_BUTTON_UP;
const RI_MOUSE_BUTTON_4_DOWN = 0x0040;
const RI_MOUSE_BUTTON_4_UP   = 0x0080;
const RI_MOUSE_BUTTON_5_DOWN = 0x0100;
const RI_MOUSE_BUTTON_5_UP   = 0x0200;
const RI_MOUSE_WHEEL         = 0x0400;
const KEYBOARD_OVERRUN_MAKE_CODE = 0x00ff;
const RI_KEY_MAKE            = 0x0000;
const RI_KEY_BREAK           = 0x0001;
const RI_KEY_E0              = 0x0002;
const RI_KEY_E1              = 0x0004;
const RI_KEY_TERMSRV_SET_LED = 0x0008;
const RI_KEY_TERMSRV_SHADOW  = 0x0010;

const RID_INPUT          = 0x10000003;
const RID_HEADER         = 0x10000005;

const RIDI_PREPARSEDDATA = 0x20000005;
const RIDI_DEVICENAME    = 0x20000007;
const RIDI_DEVICEINFO    = 0x2000000b;

const RIDEV_REMOVE       = 0x00000001;
const RIDEV_EXCLUDE      = 0x00000010;
const RIDEV_PAGEONLY     = 0x00000020;
const RIDEV_NOLEGACY     = 0x00000030;
const RIDEV_INPUTSINK    = 0x00000100;
const RIDEV_CAPTUREMOUSE = 0x00000200;
const RIDEV_NOHOTKEYS    = 0x00000200;
const RIDEV_APPKEYS      = 0x00000400;
}

// Callbacks ----
extern (Windows) {
alias BOOL function (HWND, UINT, WPARAM, LPARAM)    DLGPROC;
alias void function (HWND, UINT, UINT, DWORD)       TIMERPROC;
alias BOOL function (HDC, LPARAM, int)             GRAYSTRINGPROC;
alias LRESULT function (int, WPARAM, LPARAM)       HOOKPROC;
alias BOOL function (HWND, LPCSTR, HANDLE)         PROPENUMPROCA;
alias BOOL function (HWND, LPCWSTR, HANDLE)        PROPENUMPROCW;
alias BOOL function (HWND, LPSTR, HANDLE, DWORD)    PROPENUMPROCEXA;
alias BOOL function (HWND, LPWSTR, HANDLE, DWORD)   PROPENUMPROCEXW;
alias int function (LPSTR, int, int, int)           EDITWORDBREAKPROCA;
alias int function (LPWSTR, int, int, int)          EDITWORDBREAKPROCW;
alias LRESULT function (HWND, UINT, WPARAM, LPARAM) WNDPROC;
alias BOOL function (HDC, LPARAM, WPARAM, int, int)  DRAWSTATEPROC;
alias BOOL function (HWND, LPARAM)                WNDENUMPROC;
alias BOOL function (HWND, LPARAM)                ENUMWINDOWSPROC;
alias void function (LPHELPINFO)                 MSGBOXCALLBACK;

static if (WINVER >= 0x410) {
alias BOOL function (HMONITOR, HDC, LPRECT, LPARAM) MONITORENUMPROC;
}
alias BOOL function (LPSTR, LPARAM)               NAMEENUMPROCA;
alias BOOL function (LPWSTR, LPARAM)              NAMEENUMPROCW;
alias void function (HWND, UINT, DWORD, LRESULT)    SENDASYNCPROC;

alias NAMEENUMPROCA DESKTOPENUMPROCA;
alias NAMEENUMPROCW DESKTOPENUMPROCW;
alias NAMEENUMPROCA WINSTAENUMPROCA;
alias NAMEENUMPROCW WINSTAENUMPROCW;

}

typedef HANDLE HHOOK;
typedef HANDLE HDWP;
typedef HANDLE HDEVNOTIFY;

struct ACCEL {
	BYTE fVirt;
	WORD key;
	WORD cmd;
}
alias ACCEL* LPACCEL;

struct ACCESSTIMEOUT {
	UINT  cbSize = ACCESSTIMEOUT.sizeof;
	DWORD dwFlags;
	DWORD iTimeOutMSec;
}
alias ACCESSTIMEOUT* LPACCESSTIMEOUT;

struct ANIMATIONINFO {
	UINT cbSize = ANIMATIONINFO.sizeof;
	int  iMinAnimate;
}
alias ANIMATIONINFO* LPANIMATIONINFO;

struct CREATESTRUCTA {
	LPVOID    lpCreateParams;
	HINSTANCE hInstance;
	HMENU     hMenu;
	HWND      hwndParent;
	int       cy;
	int       cx;
	int       y;
	int       x;
	LONG      style;
	LPCSTR    lpszName;
	LPCSTR    lpszClass;
	DWORD     dwExStyle;
}
alias CREATESTRUCTA* LPCREATESTRUCTA;

struct CREATESTRUCTW {
	LPVOID    lpCreateParams;
	HINSTANCE hInstance;
	HMENU     hMenu;
	HWND      hwndParent;
	int       cy;
	int       cx;
	int       y;
	int       x;
	LONG      style;
	LPCWSTR   lpszName;
	LPCWSTR   lpszClass;
	DWORD     dwExStyle;
}
alias CREATESTRUCTW* LPCREATESTRUCTW;

struct CBT_CREATEWNDA {
	LPCREATESTRUCTA lpcs;
	HWND            hwndInsertAfter;
}
alias CBT_CREATEWNDA* LPCBT_CREATEWNDA;

struct CBT_CREATEWNDW {
	LPCREATESTRUCTW lpcs;
	HWND            hwndInsertAfter;
}
alias CBT_CREATEWNDW* LPCBT_CREATEWNDW;

struct CBTACTIVATESTRUCT {
	BOOL fMouse;
	HWND hWndActive;
}
alias CBTACTIVATESTRUCT* LPCBTACTIVATESTRUCT;

struct CLIENTCREATESTRUCT {
	HANDLE hWindowMenu;
	UINT   idFirstChild;
}
alias CLIENTCREATESTRUCT* LPCLIENTCREATESTRUCT;

struct COMPAREITEMSTRUCT {
	UINT  CtlType;
	UINT  CtlID;
	HWND  hwndItem;
	UINT  itemID1;
	DWORD itemData1;
	UINT  itemID2;
	DWORD itemData2;
	DWORD dwLocaleId;
}
alias COMPAREITEMSTRUCT* LPCOMPAREITEMSTRUCT;

struct COPYDATASTRUCT {
	DWORD dwData;
	DWORD cbData;
	PVOID lpData;
}
alias COPYDATASTRUCT* PCOPYDATASTRUCT;

struct CURSORSHAPE {
	int xHotSpot;
	int yHotSpot;
	int cx;
	int cy;
	int cbWidth;
	BYTE Planes;
	BYTE BitsPixel;
}
alias CURSORSHAPE* LPCURSORSHAPE;

struct CWPRETSTRUCT {
	LRESULT lResult;
	LPARAM lParam;
	WPARAM wParam;
	DWORD message;
	HWND hwnd;
}

struct CWPSTRUCT {
	LPARAM lParam;
	WPARAM wParam;
	UINT message;
	HWND hwnd;
}
alias CWPSTRUCT* PCWPSTRUCT;

struct DEBUGHOOKINFO {
	DWORD idThread;
	DWORD idThreadInstaller;
	LPARAM lParam;
	WPARAM wParam;
	int code;
}
alias DEBUGHOOKINFO* PDEBUGHOOKINFO, LPDEBUGHOOKINFO;

struct DELETEITEMSTRUCT {
	UINT CtlType;
	UINT CtlID;
	UINT itemID;
	HWND hwndItem;
	UINT itemData;
}
alias DELETEITEMSTRUCT* PDELETEITEMSTRUCT, LPDELETEITEMSTRUCT;

align(2):
struct DLGITEMTEMPLATE {
	DWORD style;
	DWORD dwExtendedStyle;
	short x;
	short y;
	short cx;
	short cy;
	WORD id;
}
alias DLGITEMTEMPLATE* LPDLGITEMTEMPLATE;

struct DLGTEMPLATE {
	DWORD style;
	DWORD dwExtendedStyle;
	WORD cdit;
	short x;
	short y;
	short cx;
	short cy;
}
alias DLGTEMPLATE* LPDLGTEMPLATE, LPDLGTEMPLATEA, LPDLGTEMPLATEW;
alias DLGTEMPLATE* LPCDLGTEMPLATE;

align:

struct DRAWITEMSTRUCT {
	UINT  CtlType;
	UINT  CtlID;
	UINT  itemID;
	UINT  itemAction;
	UINT  itemState;
	HWND  hwndItem;
	HDC   hDC;
	RECT  rcItem;
	DWORD itemData;
}
alias DRAWITEMSTRUCT* LPDRAWITEMSTRUCT, PDRAWITEMSTRUCT;

struct DRAWTEXTPARAMS {
	UINT cbSize = DRAWTEXTPARAMS.sizeof;
	int  iTabLength;
	int  iLeftMargin;
	int  iRightMargin;
	UINT uiLengthDrawn;
}
alias DRAWTEXTPARAMS* LPDRAWTEXTPARAMS;

struct PAINTSTRUCT {
	HDC      hdc;
	BOOL     fErase;
	RECT     rcPaint;
	BOOL     fRestore;
	BOOL     fIncUpdate;
	BYTE[32] rgbReserved;
}
alias PAINTSTRUCT* LPPAINTSTRUCT;

struct MSG {
	HWND hwnd;
	UINT message;
	WPARAM wParam;
	LPARAM lParam;
	DWORD time;
	POINT pt;
}
alias MSG* LPMSG, PMSG;

struct ICONINFO {
	BOOL fIcon;
	DWORD xHotspot;
	DWORD yHotspot;
	HBITMAP hbmMask;
	HBITMAP hbmColor;
}
alias ICONINFO* PICONINFO;

struct NMHDR {
	HWND hwndFrom;
	UINT idFrom;
	UINT code;
}
alias NMHDR* LPNMHDR;

struct WNDCLASSA {
	UINT style;
	WNDPROC lpfnWndProc;
	int cbClsExtra;
	int cbWndExtra;
	HINSTANCE hInstance;
	HICON hIcon;
	HCURSOR hCursor;
	HBRUSH hbrBackground;
	LPCSTR lpszMenuName;
	LPCSTR lpszClassName;
}
alias WNDCLASSA* LPWNDCLASSA, PWNDCLASSA;

struct WNDCLASSW {
	UINT style;
	WNDPROC lpfnWndProc;
	int cbClsExtra;
	int cbWndExtra;
	HINSTANCE hInstance;
	HICON hIcon;
	HCURSOR hCursor;
	HBRUSH hbrBackground;
	LPCWSTR lpszMenuName;
	LPCWSTR lpszClassName;
}
alias WNDCLASSW* LPWNDCLASSW, PWNDCLASSW;

struct WNDCLASSEXA {
	UINT      cbSize = WNDCLASSEXA.sizeof;
	UINT      style;
	WNDPROC   lpfnWndProc;
	int       cbClsExtra;
	int       cbWndExtra;
	HINSTANCE hInstance;
	HICON     hIcon;
	HCURSOR   hCursor;
	HBRUSH    hbrBackground;
	LPCSTR    lpszMenuName;
	LPCSTR    lpszClassName;
	HICON     hIconSm;
}
alias WNDCLASSEXA* LPWNDCLASSEXA, PWNDCLASSEXA;

struct WNDCLASSEXW {
	UINT      cbSize = WNDCLASSEXW.sizeof;
	UINT      style;
	WNDPROC   lpfnWndProc;
	int       cbClsExtra;
	int       cbWndExtra;
	HINSTANCE hInstance;
	HICON     hIcon;
	HCURSOR   hCursor;
	HBRUSH    hbrBackground;
	LPCWSTR   lpszMenuName;
	LPCWSTR   lpszClassName;
	HICON     hIconSm;
}
alias WNDCLASSEXW* LPWNDCLASSEXW, PWNDCLASSEXW;

struct MENUITEMINFOA {
	UINT    cbSize = MENUITEMINFOA.sizeof;
	UINT    fMask;
	UINT    fType;
	UINT    fState;
	UINT    wID;
	HMENU   hSubMenu;
	HBITMAP hbmpChecked;
	HBITMAP hbmpUnchecked;
	DWORD   dwItemData;
	LPSTR   dwTypeData;
	UINT    cch;
	static if (_WIN32_WINNT >= 0x500) {
		HBITMAP hbmpItem;
	}
}
alias MENUITEMINFOA* LPMENUITEMINFOA;
alias MENUITEMINFOA* LPCMENUITEMINFOA;

struct MENUITEMINFOW {
	UINT    cbSize = MENUITEMINFOW.sizeof;
	UINT    fMask;
	UINT    fType;
	UINT    fState;
	UINT    wID;
	HMENU   hSubMenu;
	HBITMAP hbmpChecked;
	HBITMAP hbmpUnchecked;
	DWORD   dwItemData;
	LPWSTR  dwTypeData;
	UINT    cch;
	static if (_WIN32_WINNT >= 0x500) {
		HBITMAP hbmpItem;
	}
}
alias MENUITEMINFOW* LPMENUITEMINFOW;
alias  MENUITEMINFOW* LPCMENUITEMINFOW;

struct SCROLLINFO {
	UINT cbSize;
	UINT fMask;
	int nMin;
	int nMax;
	UINT nPage;
	int nPos;
	int nTrackPos;
}
alias SCROLLINFO* LPSCROLLINFO;
alias SCROLLINFO* LPCSCROLLINFO;

struct WINDOWPLACEMENT {
	UINT length;
	UINT flags;
	UINT showCmd;
	POINT ptMinPosition;
	POINT ptMaxPosition;
	RECT rcNormalPosition;
}
alias WINDOWPLACEMENT* LPWINDOWPLACEMENT, PWINDOWPLACEMENT;

struct MENUITEMTEMPLATEHEADER {
	WORD versionNumber;
	WORD offset;
}

struct MENUITEMTEMPLATE {
	WORD mtOption;
	WORD mtID;
	WCHAR mtString[1];
}

alias void MENUTEMPLATE, MENUTEMPLATEA, MENUTEMPLATEW;

alias MENUTEMPLATE* LPMENUTEMPLATEA, LPMENUTEMPLATEW, LPMENUTEMPLATE;

struct HELPINFO {
	UINT cbSize;
	int iContextType;
	int iCtrlId;
	HANDLE hItemHandle;
	DWORD dwContextId;
	POINT MousePos;
}
alias HELPINFO* LPHELPINFO;

struct MSGBOXPARAMSA {
	UINT cbSize;
	HWND hwndOwner;
	HINSTANCE hInstance;
	LPCSTR lpszText;
	LPCSTR lpszCaption;
	DWORD dwStyle;
	LPCSTR lpszIcon;
	DWORD dwContextHelpId;
	MSGBOXCALLBACK lpfnMsgBoxCallback;
	DWORD dwLanguageId;
}
alias MSGBOXPARAMSA* PMSGBOXPARAMSA, LPMSGBOXPARAMSA;

struct MSGBOXPARAMSW {
	UINT cbSize;
	HWND hwndOwner;
	HINSTANCE hInstance;
	LPCWSTR lpszText;
	LPCWSTR lpszCaption;
	DWORD dwStyle;
	LPCWSTR lpszIcon;
	DWORD dwContextHelpId;
	MSGBOXCALLBACK lpfnMsgBoxCallback;
	DWORD dwLanguageId;
}
alias MSGBOXPARAMSW* PMSGBOXPARAMSW, LPMSGBOXPARAMSW;

struct USEROBJECTFLAGS {
	BOOL fInherit;
	BOOL fReserved;
	DWORD dwFlags;
}

struct FILTERKEYS {
	UINT cbSize;
	DWORD dwFlags;
	DWORD iWaitMSec;
	DWORD iDelayMSec;
	DWORD iRepeatMSec;
	DWORD iBounceMSec;
}

struct HIGHCONTRASTA {
	UINT cbSize;
	DWORD dwFlags;
	LPSTR lpszDefaultScheme;
}
alias HIGHCONTRASTA* LPHIGHCONTRASTA;

struct HIGHCONTRASTW {
	UINT cbSize;
	DWORD dwFlags;
	LPWSTR lpszDefaultScheme;
}
alias HIGHCONTRASTW* LPHIGHCONTRASTW;

struct ICONMETRICSA {
	UINT cbSize;
	int iHorzSpacing;
	int iVertSpacing;
	int iTitleWrap;
	LOGFONTA lfFont;
}
alias ICONMETRICSA* LPICONMETRICSA;

struct ICONMETRICSW {
	UINT cbSize;
	int iHorzSpacing;
	int iVertSpacing;
	int iTitleWrap;
	LOGFONTW lfFont;
}
alias ICONMETRICSW* LPICONMETRICSW;

struct MINIMIZEDMETRICS {
	UINT cbSize;
	int iWidth;
	int iHorzGap;
	int iVertGap;
	int iArrange;
}
alias MINIMIZEDMETRICS* LPMINIMIZEDMETRICS;

struct MOUSEKEYS {
	UINT cbSize;
	DWORD dwFlags;
	DWORD iMaxSpeed;
	DWORD iTimeToMaxSpeed;
	DWORD iCtrlSpeed;
	DWORD dwReserved1;
	DWORD dwReserved2;
}
alias MOUSEKEYS* LPMOUSEKEYS;

struct NONCLIENTMETRICSA {
	UINT cbSize;
	int iBorderWidth;
	int iScrollWidth;
	int iScrollHeight;
	int iCaptionWidth;
	int iCaptionHeight;
	LOGFONTA lfCaptionFont;
	int iSmCaptionWidth;
	int iSmCaptionHeight;
	LOGFONTA lfSmCaptionFont;
	int iMenuWidth;
	int iMenuHeight;
	LOGFONTA lfMenuFont;
	LOGFONTA lfStatusFont;
	LOGFONTA lfMessageFont;
}
alias NONCLIENTMETRICSA* LPNONCLIENTMETRICSA;

struct NONCLIENTMETRICSW {
	UINT cbSize;
	int iBorderWidth;
	int iScrollWidth;
	int iScrollHeight;
	int iCaptionWidth;
	int iCaptionHeight;
	LOGFONTW lfCaptionFont;
	int iSmCaptionWidth;
	int iSmCaptionHeight;
	LOGFONTW lfSmCaptionFont;
	int iMenuWidth;
	int iMenuHeight;
	LOGFONTW lfMenuFont;
	LOGFONTW lfStatusFont;
	LOGFONTW lfMessageFont;
}
alias NONCLIENTMETRICSW* LPNONCLIENTMETRICSW;

struct SERIALKEYSA {
	UINT cbSize;
	DWORD dwFlags;
	LPSTR lpszActivePort;
	LPSTR lpszPort;
	UINT iBaudRate;
	UINT iPortState;
	UINT iActive;
}
alias SERIALKEYSA* LPSERIALKEYSA;

struct SERIALKEYSW {
	UINT cbSize;
	DWORD dwFlags;
	LPWSTR lpszActivePort;
	LPWSTR lpszPort;
	UINT iBaudRate;
	UINT iPortState;
	UINT iActive;
}
alias SERIALKEYSW* LPSERIALKEYSW;

struct SOUNDSENTRYA {
	UINT cbSize;
	DWORD dwFlags;
	DWORD iFSTextEffect;
	DWORD iFSTextEffectMSec;
	DWORD iFSTextEffectColorBits;
	DWORD iFSGrafEffect;
	DWORD iFSGrafEffectMSec;
	DWORD iFSGrafEffectColor;
	DWORD iWindowsEffect;
	DWORD iWindowsEffectMSec;
	LPSTR lpszWindowsEffectDLL;
	DWORD iWindowsEffectOrdinal;
}
alias SOUNDSENTRYA* LPSOUNDSENTRYA;

struct SOUNDSENTRYW {
	UINT cbSize;
	DWORD dwFlags;
	DWORD iFSTextEffect;
	DWORD iFSTextEffectMSec;
	DWORD iFSTextEffectColorBits;
	DWORD iFSGrafEffect;
	DWORD iFSGrafEffectMSec;
	DWORD iFSGrafEffectColor;
	DWORD iWindowsEffect;
	DWORD iWindowsEffectMSec;
	LPWSTR lpszWindowsEffectDLL;
	DWORD iWindowsEffectOrdinal;
}
alias SOUNDSENTRYW* LPSOUNDSENTRYW;

struct STICKYKEYS {
	DWORD cbSize;
	DWORD dwFlags;
}
alias STICKYKEYS* LPSTICKYKEYS;

struct TOGGLEKEYS {
	DWORD cbSize;
	DWORD dwFlags;
}

struct MOUSEHOOKSTRUCT {
	POINT pt;
	HWND hwnd;
	UINT wHitTestCode;
	DWORD dwExtraInfo;
}
alias MOUSEHOOKSTRUCT* LPMOUSEHOOKSTRUCT, PMOUSEHOOKSTRUCT;

struct TRACKMOUSEEVENT {
	DWORD cbSize;
	DWORD dwFlags;
	HWND  hwndTrack;
	DWORD dwHoverTime;
}
alias TRACKMOUSEEVENT* LPTRACKMOUSEEVENT;

struct TPMPARAMS {
	UINT cbSize;
	RECT rcExclude;
}
alias TPMPARAMS* LPTPMPARAMS;

struct EVENTMSG {
	UINT message;
	UINT paramL;
	UINT paramH;
	DWORD time;
	HWND hwnd;
}
alias EVENTMSG* PEVENTMSGMSG, LPEVENTMSGMSG, PEVENTMSG, LPEVENTMSG;

struct WINDOWPOS {
	HWND hwnd;
	HWND hwndInsertAfter;
	int x;
	int y;
	int cx;
	int cy;
	UINT flags;
}
alias WINDOWPOS* PWINDOWPOS, LPWINDOWPOS;

struct NCCALCSIZE_PARAMS {
	RECT rgrc[3];
	PWINDOWPOS lppos;
}
alias NCCALCSIZE_PARAMS* LPNCCALCSIZE_PARAMS;

struct MDICREATESTRUCTA {
	LPCSTR szClass;
	LPCSTR szTitle;
	HANDLE hOwner;
	int x;
	int y;
	int cx;
	int cy;
	DWORD style;
	LPARAM lParam;
}
alias MDICREATESTRUCTA* LPMDICREATESTRUCTA;

struct MDICREATESTRUCTW {
	LPCWSTR szClass;
	LPCWSTR szTitle;
	HANDLE hOwner;
	int x;
	int y;
	int cx;
	int cy;
	DWORD style;
	LPARAM lParam;
}
alias MDICREATESTRUCTW* LPMDICREATESTRUCTW;

struct MINMAXINFO {
	POINT ptReserved;
	POINT ptMaxSize;
	POINT ptMaxPosition;
	POINT ptMinTrackSize;
	POINT ptMaxTrackSize;
}
alias MINMAXINFO* PMINMAXINFO, LPMINMAXINFO;

struct MDINEXTMENU {
	HMENU hmenuIn;
	HMENU hmenuNext;
	HWND hwndNext;
}
alias MDINEXTMENU* PMDINEXTMENU, LPMDINEXTMENU;

struct MEASUREITEMSTRUCT {
	UINT CtlType;
	UINT CtlID;
	UINT itemID;
	UINT itemWidth;
	UINT itemHeight;
	DWORD itemData;
}
alias MEASUREITEMSTRUCT* PMEASUREITEMSTRUCT, LPMEASUREITEMSTRUCT;

struct DROPSTRUCT {
	HWND hwndSource;
	HWND hwndSink;
	DWORD wFmt;
	DWORD dwData;
	POINT ptDrop;
	DWORD dwControlData;
}
alias DROPSTRUCT* PDROPSTRUCT, LPDROPSTRUCT;

alias DWORD HELPPOLY;

struct MULTIKEYHELPA {
	DWORD mkSize;
	CHAR mkKeylist;
	CHAR szKeyphrase[1];
}
alias MULTIKEYHELPA* PMULTIKEYHELPA, LPMULTIKEYHELPA;

struct MULTIKEYHELPW {
	DWORD mkSize;
	WCHAR mkKeylist;
	WCHAR szKeyphrase[1];
}
alias MULTIKEYHELPW* PMULTIKEYHELPW, LPMULTIKEYHELPW;

struct HELPWININFOA {
	int wStructSize;
	int x;
	int y;
	int dx;
	int dy;
	int wMax;
	CHAR rgchMember[2];
}
alias HELPWININFOA* PHELPWININFOA, LPHELPWININFOA;

struct HELPWININFOW {
	int wStructSize;
	int x;
	int y;
	int dx;
	int dy;
	int wMax;
	WCHAR rgchMember[2];
}
alias HELPWININFOW* PHELPWININFOW, LPHELPWININFOW;

struct STYLESTRUCT {
	DWORD styleOld;
	DWORD styleNew;
}
alias STYLESTRUCT* LPSTYLESTRUCT;

struct ALTTABINFO {
	DWORD cbSize;
	int   cItems;
	int   cColumns;
	int   cRows;
	int   iColFocus;
	int   iRowFocus;
	int   cxItem;
	int   cyItem;
	POINT ptStart;
}
alias ALTTABINFO* PALTTABINFO, LPALTTABINFO;

struct COMBOBOXINFO {
	DWORD cbSize;
	RECT rcItem;
	RECT rcButton;
	DWORD stateButton;
	HWND hwndCombo;
	HWND hwndItem;
	HWND hwndList;
}
alias COMBOBOXINFO* PCOMBOBOXINFO, LPCOMBOBOXINFO;

struct CURSORINFO {
	DWORD cbSize;
	DWORD flags;
	HCURSOR hCursor;
	POINT ptScreenPos;
}
alias CURSORINFO* PCURSORINFO, LPCURSORINFO;

struct MENUBARINFO {
	DWORD cbSize;
	RECT  rcBar;
	HMENU hMenu;
	HWND  hwndMenu;
	byte bf_; // Simulated bitfield
//	BOOL  fBarFocused:1;
//	BOOL  fFocused:1;
	bool fBarFocused() { return (bf_ & 1) == 1; }
	bool fFocused() { return (bf_ & 2) == 2; }
	void fBarFocused(bool b) { bf_ = cast(byte)((bf_ & 0xFE) | b); }
	void fFocused(bool b) { bf_ = cast(byte)(b ? (bf_ | 2) : bf_ & 0xFD); }
}
alias MENUBARINFO* PMENUBARINFO;

struct MENUINFO {
	DWORD cbSize;
	DWORD fMask;
	DWORD dwStyle;
	UINT cyMax;
	HBRUSH  hbrBack;
	DWORD   dwContextHelpID;
	ULONG_PTR dwMenuData;
}
alias MENUINFO* LPMENUINFO, LPCMENUINFO;


const CCHILDREN_SCROLLBAR=5;

struct SCROLLBARINFO {
	DWORD cbSize;
	RECT  rcScrollBar;
	int   dxyLineButton;
	int   xyThumbTop;
	int   xyThumbBottom;
	int   reserved;
	DWORD rgstate[CCHILDREN_SCROLLBAR+1];
}
alias SCROLLBARINFO* PSCROLLBARINFO, LPSCROLLBARINFO;

const CCHILDREN_TITLEBAR=5;

struct TITLEBARINFO {
	DWORD cbSize = TITLEBARINFO.sizeof;
	RECT  rcTitleBar;
	DWORD[CCHILDREN_TITLEBAR+1] rgstate;
}
alias TITLEBARINFO* PTITLEBARINFO, LPTITLEBARINFO;

struct WINDOWINFO {
	DWORD cbSize = WINDOWINFO.sizeof;
	RECT  rcWindow;
	RECT  rcClient;
	DWORD dwStyle;
	DWORD dwExStyle;
	DWORD dwWindowStatus;
	UINT  cxWindowBorders;
	UINT  cyWindowBorders;
	ATOM  atomWindowType;
	WORD  wCreatorVersion;
}
alias WINDOWINFO* PWINDOWINFO, LPWINDOWINFO;

struct LASTINPUTINFO {
	UINT cbSize;
	DWORD dwTime;
}
alias LASTINPUTINFO* PLASTINPUTINFO;

struct MONITORINFO {
	DWORD cbSize;
	RECT rcMonitor;
	RECT rcWork;
	DWORD dwFlags;
}
alias MONITORINFO* LPMONITORINFO;

const CCHDEVICENAME=32;

struct MONITORINFOEXA {
	DWORD cbSize = MONITORINFOEXA.sizeof;
	RECT  rcMonitor;
	RECT  rcWork;
	DWORD dwFlags;
	CHAR[CCHDEVICENAME] szDevice;
}
alias MONITORINFOEXA* LPMONITORINFOEXA;

struct MONITORINFOEXW {
	DWORD cbSize = MONITORINFOEXW.sizeof;
	RECT  rcMonitor;
	RECT  rcWork;
	DWORD dwFlags;
	WCHAR[CCHDEVICENAME] szDevice;
}
alias MONITORINFOEXW* LPMONITORINFOEXW;

struct KBDLLHOOKSTRUCT {
	DWORD vkCode;
	DWORD scanCode;
	DWORD flags;
	DWORD time;
	DWORD dwExtraInfo;
}
alias KBDLLHOOKSTRUCT* LPKBDLLHOOKSTRUCT, PKBDLLHOOKSTRUCT;

static if ((_WIN32_WINNT >= 0x500) || (_WIN32_WINDOWS >= 0x410)) {

struct FLASHWINFO {
	UINT  cbSize;
	HWND  hwnd;
	DWORD dwFlags;
	UINT  uCount;
	DWORD dwTimeout;
}
alias FLASHWINFO* PFLASHWINFO;

}

static if ((_WIN32_WINNT >= 0x500) || (_WIN32_WINDOWS >= 0x490)) {

struct MOUSEMOVEPOINT {
	int x;
	int y;
	DWORD time;
	ULONG_PTR dwExtraInfo;
}
alias MOUSEMOVEPOINT* PMOUSEMOVEPOINT, LPMOUSEMOVEPOINT;
}

static if (_WIN32_WINNT >= 0x403) {
struct MOUSEINPUT {
	LONG dx;
	LONG dy;
	DWORD mouseData;
	DWORD dwFlags;
	DWORD time;
	ULONG_PTR dwExtraInfo;
}
alias MOUSEINPUT* PMOUSEINPUT;

struct KEYBDINPUT {
	WORD wVk;
	WORD wScan;
	DWORD dwFlags;
	DWORD time;
	ULONG_PTR dwExtraInfo;
}
alias KEYBDINPUT* PKEYBDINPUT;

struct HARDWAREINPUT {
	DWORD uMsg;
	WORD wParamL;
	WORD wParamH;
}
alias HARDWAREINPUT* PHARDWAREINPUT;

struct INPUT {
	DWORD type;
	union {
		MOUSEINPUT mi;
		KEYBDINPUT ki;
		HARDWAREINPUT hi;
	}
}
alias INPUT* PINPUT, LPINPUT;
}// (_WIN32_WINNT >= 0x403)

static if (WINVER >= 0x500) {
struct GUITHREADINFO {
	DWORD cbSize;
	DWORD flags;
	HWND hwndActive;
	HWND hwndFocus;
	HWND hwndCapture;
	HWND hwndMenuOwner;
	HWND hwndMoveSize;
	HWND hwndCaret;
	RECT rcCaret;
}
alias GUITHREADINFO* PGUITHREADINFO, LPGUITHREADINFO;
extern (Windows) {
alias void function (HWINEVENTHOOK, DWORD, HWND, LONG, LONG, DWORD, DWORD) WINEVENTPROC;
}

}// (WINVER >= 0x500)

static if (_WIN32_WINNT >= 0x501) {
struct BSMINFO {
	UINT  cbSize;
	HDESK hdesk;
	HWND  hwnd;
	LUID  luid;
}
alias BSMINFO* PBSMINFO;

typedef HANDLE HRAWINPUT;

struct RAWINPUTHEADER {
	DWORD dwType;
	DWORD dwSize;
	HANDLE hDevice;
	WPARAM wParam;
}
alias RAWINPUTHEADER* PRAWINPUTHEADER;

struct RAWMOUSE {
	USHORT usFlags;
	union {
		ULONG ulButtons;
		struct {
			USHORT usButtonFlags;
			USHORT usButtonData;
		}
	}
	ULONG ulRawButtons;
	LONG lLastX;
	LONG lLastY;
	ULONG ulExtraInformation;
}
alias RAWMOUSE* PRAWMOUSE, LPRAWMOUSE;

struct RAWKEYBOARD {
	USHORT MakeCode;
	USHORT Flags;
	USHORT Reserved;
	USHORT VKey;
	UINT Message;
	ULONG ExtraInformation;
}
alias RAWKEYBOARD* PRAWKEYBOARD, LPRAWKEYBOARD;

struct RAWHID {
	DWORD dwSizeHid;
	DWORD dwCount;
	BYTE bRawData;
}
alias RAWHID* PRAWHID, LPRAWHID;

struct RAWINPUT {
	RAWINPUTHEADER header;
	union _data {
		RAWMOUSE    mouse;
		RAWKEYBOARD keyboard;
		RAWHID      hid;
	}
	_data data;	
}
alias RAWINPUT* PRAWINPUT, LPRAWINPUT;

struct RAWINPUTDEVICE {
	USHORT usUsagePage;
	USHORT usUsage;
	DWORD dwFlags;
	HWND hwndTarget;
}
alias RAWINPUTDEVICE* PRAWINPUTDEVICE, LPRAWINPUTDEVICE;
alias RAWINPUTDEVICE* PCRAWINPUTDEVICE;

struct RAWINPUTDEVICELIST {
	HANDLE hDevice;
	DWORD dwType;
}
alias RAWINPUTDEVICELIST* PRAWINPUTDEVICELIST;
}// (_WIN32_WINNT >= 0x501)

struct MSLLHOOKSTRUCT {
	POINT pt;
	DWORD mouseData;
	DWORD flags;
	DWORD time;
	ULONG_PTR dwExtraInfo;
}
alias MSLLHOOKSTRUCT* PMSLLHOOKSTRUCT;

alias CharToOemA AnsiToOem;
alias OemToCharA OemToAnsi;
alias CharToOemBuffA AnsiToOemBuff;
alias OemToCharBuffA OemToAnsiBuff;
alias CharUpperA AnsiUpper;
alias CharUpperBuffA AnsiUpperBuff;
alias CharLowerA AnsiLower;
alias CharLowerBuffA AnsiLowerBuff;
alias CharNextA AnsiNext;
alias CharPrevA AnsiPrev;

alias MAKELONG MAKEWPARAM;
alias MAKELONG MAKELPARAM;
alias MAKELONG MAKELRESULT;

//MACRO #define POINTSTOPOINT(p, ps) { (p).x=LOWORD(*(DWORD* )&ps); (p).y=HIWORD(*(DWORD* )&ps); }
//MACRO #define POINTTOPOINTS(p) ((POINTS)MAKELONG((p).x, (p).y))

extern (Windows) {

HKL ActivateKeyboardLayout(HKL, UINT);
BOOL AdjustWindowRect(LPRECT, DWORD, BOOL);
BOOL AdjustWindowRectEx(LPRECT, DWORD, BOOL, DWORD);
BOOL AnyPopup();
BOOL AppendMenuA(HMENU, UINT, UINT_PTR, LPCSTR);
BOOL AppendMenuW(HMENU, UINT, UINT_PTR, LPCWSTR);
UINT ArrangeIconicWindows(HWND);
BOOL AttachThreadInput(DWORD, DWORD, BOOL);
HDWP BeginDeferWindowPos(int);
HDC BeginPaint(HWND, LPPAINTSTRUCT);
BOOL BringWindowToTop(HWND);
BOOL CallMsgFilterA(LPMSG, INT);
BOOL CallMsgFilterW(LPMSG, INT);
LRESULT CallNextHookEx(HHOOK, int, WPARAM, LPARAM);
LRESULT CallWindowProcA(WNDPROC, HWND, UINT, WPARAM, LPARAM);
LRESULT CallWindowProcW(WNDPROC, HWND, UINT, WPARAM, LPARAM);
WORD CascadeWindows(HWND, UINT, LPCRECT, UINT, HWND*);
BOOL ChangeClipboardChain(HWND, HWND);

LONG ChangeDisplaySettingsA(PDEVMODEA, DWORD);
LONG ChangeDisplaySettingsW(PDEVMODEW, DWORD);
LONG ChangeDisplaySettingsExA(LPCSTR, LPDEVMODEA, HWND, DWORD, LPVOID);
LONG ChangeDisplaySettingsExW(LPCWSTR, LPDEVMODEW, HWND, DWORD, LPVOID);

BOOL ChangeMenuA(HMENU, UINT, LPCSTR, UINT, UINT);
BOOL ChangeMenuW(HMENU, UINT, LPCWSTR, UINT, UINT);
LPSTR CharLowerA(LPSTR);
LPWSTR CharLowerW(LPWSTR);
DWORD CharLowerBuffA(LPSTR, DWORD);
DWORD CharLowerBuffW(LPWSTR, DWORD);
LPSTR CharNextA(LPCSTR);
LPWSTR CharNextW(LPCWSTR);
LPSTR CharNextExA(WORD, LPCSTR, DWORD);
LPWSTR CharNextExW(WORD, LPCWSTR, DWORD);
LPSTR CharPrevA(LPCSTR, LPCSTR);
LPWSTR CharPrevW(LPCWSTR, LPCWSTR);
LPSTR CharPrevExA(WORD, LPCSTR, LPCSTR, DWORD);
LPWSTR CharPrevExW(WORD, LPCWSTR, LPCWSTR, DWORD);
BOOL CharToOemA(LPCSTR, LPSTR);
BOOL CharToOemW(LPCWSTR, LPSTR);
BOOL CharToOemBuffA(LPCSTR, LPSTR, DWORD);
BOOL CharToOemBuffW(LPCWSTR, LPSTR, DWORD);
LPSTR CharUpperA(LPSTR);
LPWSTR CharUpperW(LPWSTR);
DWORD CharUpperBuffA(LPSTR, DWORD);
DWORD CharUpperBuffW(LPWSTR, DWORD);
BOOL CheckDlgButton(HWND, int, UINT);
DWORD CheckMenuItem(HMENU, UINT, UINT);
BOOL CheckMenuRadioItem(HMENU, UINT, UINT, UINT, UINT);
BOOL CheckRadioButton(HWND, int, int, int);
HWND ChildWindowFromPoint(HWND, POINT);
HWND ChildWindowFromPointEx(HWND, POINT, UINT);
BOOL ClientToScreen(HWND, LPPOINT);
BOOL ClipCursor(LPCRECT);
BOOL CloseClipboard();
BOOL CloseDesktop(HDESK);
BOOL CloseWindow(HWND);
BOOL CloseWindowStation(HWINSTA);
int CopyAcceleratorTableA(HACCEL, LPACCEL, int);
int CopyAcceleratorTableW(HACCEL, LPACCEL, int);

HICON CopyIcon(HICON);
HANDLE CopyImage(HANDLE, UINT, int, int, UINT);
BOOL CopyRect(LPRECT, LPCRECT);
int CountClipboardFormats();
HACCEL CreateAcceleratorTableA(LPACCEL, int);
HACCEL CreateAcceleratorTableW(LPACCEL, int);
BOOL CreateCaret(HWND, HBITMAP, int, int);
HCURSOR CreateCursor(HINSTANCE, int, int, int, int, PCVOID, PCVOID);

HDESK CreateDesktopA(LPCSTR, LPCSTR, LPDEVMODEA, DWORD, ACCESS_MASK, LPSECURITY_ATTRIBUTES);
HDESK CreateDesktopW(LPCWSTR, LPCWSTR, LPDEVMODEW, DWORD, ACCESS_MASK, LPSECURITY_ATTRIBUTES);

HWND CreateDialogParamA(HINSTANCE, LPCSTR, HWND, DLGPROC, LPARAM);
HWND CreateDialogParamW(HINSTANCE, LPCWSTR, HWND, DLGPROC, LPARAM);
HWND CreateDialogIndirectParamA(HINSTANCE, LPCDLGTEMPLATE, HWND, DLGPROC, LPARAM);
HWND CreateDialogIndirectParamW(HINSTANCE, LPCDLGTEMPLATE, HWND, DLGPROC, LPARAM);

HICON CreateIcon(HINSTANCE, int, int, BYTE, BYTE, BYTE*, BYTE*);
HICON CreateIconFromResource(PBYTE, DWORD, BOOL, DWORD);
HICON CreateIconFromResourceEx(PBYTE, DWORD, BOOL, DWORD, int, int, UINT);
HICON CreateIconIndirect(PICONINFO);
HWND CreateMDIWindowA(LPCSTR, LPCSTR, DWORD, int, int, int, int, HWND, HINSTANCE, LPARAM);
HWND CreateMDIWindowW(LPCWSTR, LPCWSTR, DWORD, int, int, int, int, HWND, HINSTANCE, LPARAM);
HMENU CreateMenu();
HMENU CreatePopupMenu();

HWND CreateWindowExA(DWORD, LPCSTR, LPCSTR, DWORD, int, int, int, int, HWND, HMENU, HINSTANCE, LPVOID);
HWND CreateWindowExW(DWORD, LPCWSTR, LPCWSTR, DWORD, int, int, int, int, HWND, HMENU, HINSTANCE, LPVOID);

HWINSTA CreateWindowStationA(LPSTR, DWORD, DWORD, LPSECURITY_ATTRIBUTES);
HWINSTA CreateWindowStationW(LPWSTR, DWORD, DWORD, LPSECURITY_ATTRIBUTES);
LRESULT DefDlgProcA(HWND, UINT, WPARAM, LPARAM);
LRESULT DefDlgProcW(HWND, UINT, WPARAM, LPARAM);
HDWP DeferWindowPos(HDWP, HWND, HWND, int, int, int, int, UINT);
LRESULT DefFrameProcA(HWND, HWND, UINT, WPARAM, LPARAM);
LRESULT DefFrameProcW(HWND, HWND, UINT, WPARAM, LPARAM);

LRESULT DefMDIChildProcA(HWND, UINT, WPARAM, LPARAM);
LRESULT DefMDIChildProcW(HWND, UINT, WPARAM, LPARAM);
LRESULT DefWindowProcA(HWND, UINT, WPARAM, LPARAM);
LRESULT DefWindowProcW(HWND, UINT, WPARAM, LPARAM);
BOOL DeleteMenu(HMENU, UINT, UINT);
BOOL DeregisterShellHookWindow(HWND);
BOOL DestroyAcceleratorTable(HACCEL);
BOOL DestroyCaret();
BOOL DestroyCursor(HCURSOR);
BOOL DestroyIcon(HICON);
BOOL DestroyMenu(HMENU);
BOOL DestroyWindow(HWND);

int DialogBoxParamA(HINSTANCE, LPCSTR, HWND, DLGPROC, LPARAM);
int DialogBoxParamW(HINSTANCE, LPCWSTR, HWND, DLGPROC, LPARAM);
int DialogBoxIndirectParamA(HINSTANCE, LPCDLGTEMPLATE, HWND, DLGPROC, LPARAM);
int DialogBoxIndirectParamW(HINSTANCE, LPCDLGTEMPLATE, HWND, DLGPROC, LPARAM);

} // extern (Windows)

HCURSOR CopyCursor(HCURSOR c)
{
	return cast(HCURSOR)CopyIcon(cast(HICON)c);
}

HWND CreateDialogA(HINSTANCE h, LPCSTR n, HWND w, DLGPROC f)
{
	return CreateDialogParamA(h, n, w, f, 0);
}

HWND CreateDialogW(HINSTANCE h, LPCWSTR n, HWND w, DLGPROC f)
{
	return CreateDialogParamW(h, n, w, f, 0);
}

HWND CreateDialogIndirectA(HINSTANCE h, LPCDLGTEMPLATE t, HWND w , DLGPROC f)
{
	return CreateDialogIndirectParamA(h, t, w, f, 0);
}

HWND CreateDialogIndirectW(HINSTANCE h, LPCDLGTEMPLATE t, HWND w , DLGPROC f)
{
	return CreateDialogIndirectParamW(h, t, w, f, 0);
}


HWND CreateWindowA(LPCSTR a, LPCSTR b, DWORD c, int d, int e, int f, int g, HWND h, HMENU i, HINSTANCE j, LPVOID k)
{
	return CreateWindowExA(0, a, b, c, d, e, f, g, h, i, j, k);
}

HWND CreateWindowW(LPCWSTR a, LPCWSTR b, DWORD c, int d, int e, int f, int g, HWND h, HMENU i, HINSTANCE j, LPVOID k)
{
	return CreateWindowExW(0, a, b, c, d, e, f, g, h, i, j, k);
}

int DialogBoxA(HINSTANCE i, LPCSTR t, HWND p, DLGPROC f)
{
	return DialogBoxParamA(i, t, p, f, 0);
}

int DialogBoxW(HINSTANCE i, LPCWSTR t, HWND p, DLGPROC f)
{
	return DialogBoxParamW(i, t, p, f, 0);
}

int DialogBoxIndirectA(HINSTANCE i, LPCDLGTEMPLATE t, HWND p, DLGPROC f)
{
	return DialogBoxIndirectParamA(i, t, p, f, 0);
}

int DialogBoxIndirectW(HINSTANCE i, LPCDLGTEMPLATE t, HWND p, DLGPROC f)
{
	return DialogBoxIndirectParamW(i, t, p, f, 0);
}

BOOL ExitWindows(UINT r, DWORD c)
{
	return ExitWindowsEx(EWX_LOGOFF, 0);
}
alias GetWindow GetNextWindow;

extern (Windows):
LONG DispatchMessageA( MSG*);
LONG DispatchMessageW( MSG*);
int DlgDirListA(HWND, LPSTR, int, int, UINT);
int DlgDirListW(HWND, LPWSTR, int, int, UINT);
int DlgDirListComboBoxA(HWND, LPSTR, int, int, UINT);
int DlgDirListComboBoxW(HWND, LPWSTR, int, int, UINT);
BOOL DlgDirSelectComboBoxExA(HWND, LPSTR, int, int);
BOOL DlgDirSelectComboBoxExW(HWND, LPWSTR, int, int);
BOOL DlgDirSelectExA(HWND, LPSTR, int, int);
BOOL DlgDirSelectExW(HWND, LPWSTR, int, int);
BOOL DragDetect(HWND, POINT);
DWORD DragObject(HWND, HWND, UINT, DWORD, HCURSOR);
BOOL DrawAnimatedRects(HWND, int, LPCRECT, LPCRECT);
BOOL DrawCaption(HWND, HDC, LPCRECT, UINT);
BOOL DrawEdge(HDC, LPRECT, UINT, UINT);
BOOL DrawFocusRect(HDC, LPCRECT);
BOOL DrawFrameControl(HDC, LPRECT, UINT, UINT);
BOOL DrawIcon(HDC, int, int, HICON);
BOOL DrawIconEx(HDC, int, int, HICON, int, int, UINT, HBRUSH, UINT);
BOOL DrawMenuBar(HWND);
BOOL DrawStateA(HDC, HBRUSH, DRAWSTATEPROC, LPARAM, WPARAM, int, int, int, int, UINT);
BOOL DrawStateW(HDC, HBRUSH, DRAWSTATEPROC, LPARAM, WPARAM, int, int, int, int, UINT);
int DrawTextA(HDC, LPCSTR, int, LPRECT, UINT);
int DrawTextW(HDC, LPCWSTR, int, LPRECT, UINT);
int DrawTextExA(HDC, LPSTR, int, LPRECT, UINT, LPDRAWTEXTPARAMS);
int DrawTextExW(HDC, LPWSTR, int, LPRECT, UINT, LPDRAWTEXTPARAMS);
BOOL EmptyClipboard();
BOOL EnableMenuItem(HMENU, UINT, UINT);
BOOL EnableScrollBar(HWND, UINT, UINT);
BOOL EnableWindow(HWND, BOOL);
BOOL EndDeferWindowPos(HDWP);
BOOL EndDialog(HWND, int);
BOOL EndMenu();
BOOL EndPaint(HWND, PAINTSTRUCT*);
BOOL EnumChildWindows(HWND, ENUMWINDOWSPROC, LPARAM);
UINT EnumClipboardFormats(UINT);
BOOL EnumDesktopsA(HWINSTA, DESKTOPENUMPROCA, LPARAM);
BOOL EnumDesktopsW(HWINSTA, DESKTOPENUMPROCW, LPARAM);
BOOL EnumDesktopWindows(HDESK, ENUMWINDOWSPROC, LPARAM);
BOOL EnumDisplaySettingsA(LPCSTR, DWORD, PDEVMODEA);
BOOL EnumDisplaySettingsW(LPCWSTR, DWORD, PDEVMODEW);

BOOL EnumDisplayDevicesA(LPCSTR, DWORD, PDISPLAY_DEVICEA, DWORD);
BOOL EnumDisplayDevicesW(LPCWSTR, DWORD, PDISPLAY_DEVICEW, DWORD);

int EnumPropsA(HWND, PROPENUMPROCA);
int EnumPropsW(HWND, PROPENUMPROCW);
int EnumPropsExA(HWND, PROPENUMPROCEXA, LPARAM);
int EnumPropsExW(HWND, PROPENUMPROCEXW, LPARAM);

BOOL EnumThreadWindows(DWORD, WNDENUMPROC, LPARAM);
BOOL EnumWindows(WNDENUMPROC, LPARAM);
BOOL EnumWindowStationsA(WINSTAENUMPROCA, LPARAM);
BOOL EnumWindowStationsW(WINSTAENUMPROCW, LPARAM);
BOOL EqualRect(LPCRECT, LPCRECT);

BOOL ExitWindowsEx(UINT, DWORD);
HWND FindWindowA(LPCSTR, LPCSTR);
HWND FindWindowExA(HWND, HWND, LPCSTR, LPCSTR);
HWND FindWindowExW(HWND, HWND, LPCWSTR, LPCWSTR);
HWND FindWindowW(LPCWSTR, LPCWSTR);
BOOL FlashWindow(HWND, BOOL);

int FrameRect(HDC, LPCRECT, HBRUSH);
BOOL FrameRgn(HDC, HRGN, HBRUSH, int, int);
HWND GetActiveWindow();
HWND GetAncestor(HWND, UINT);
SHORT GetAsyncKeyState(int);
HWND GetCapture();
UINT GetCaretBlinkTime();
BOOL GetCaretPos(LPPOINT);
BOOL GetClassInfoA(HINSTANCE, LPCSTR, LPWNDCLASSA);
BOOL GetClassInfoExA(HINSTANCE, LPCSTR, LPWNDCLASSEXA);
BOOL GetClassInfoW(HINSTANCE, LPCWSTR, LPWNDCLASSW);
BOOL GetClassInfoExW(HINSTANCE, LPCWSTR, LPWNDCLASSEXW);
DWORD GetClassLongA(HWND, int);
DWORD GetClassLongW(HWND, int);
int GetClassNameA(HWND, LPSTR, int);
int GetClassNameW(HWND, LPWSTR, int);
WORD GetClassWord(HWND, int);
BOOL GetClientRect(HWND, LPRECT);
HANDLE GetClipboardData(UINT);
int GetClipboardFormatNameA(UINT, LPSTR, int);
int GetClipboardFormatNameW(UINT, LPWSTR, int);
HWND GetClipboardOwner();
HWND GetClipboardViewer();
BOOL GetClipCursor(LPRECT);
BOOL GetCursorPos(LPPOINT);
HDC GetDC(HWND);
HDC GetDCEx(HWND, HRGN, DWORD);
HWND GetDesktopWindow();
int GetDialogBaseUnits();
int GetDlgCtrlID(HWND);
HWND GetDlgItem(HWND, int);
UINT GetDlgItemInt(HWND, int, PBOOL, BOOL);
UINT GetDlgItemTextA(HWND, int, LPSTR, int);
UINT GetDlgItemTextW(HWND, int, LPWSTR, int);
UINT GetDoubleClickTime();
HWND GetFocus();
HWND GetForegroundWindow();

BOOL GetIconInfo(HICON, PICONINFO);
BOOL GetInputState();
UINT GetKBCodePage();
HKL GetKeyboardLayout(DWORD);
UINT GetKeyboardLayoutList(int, HKL*);
BOOL GetKeyboardLayoutNameA(LPSTR);
BOOL GetKeyboardLayoutNameW(LPWSTR);
BOOL GetKeyboardState(PBYTE);
int GetKeyboardType(int);
int GetKeyNameTextA(LONG, LPSTR, int);
int GetKeyNameTextW(LONG, LPWSTR, int);
SHORT GetKeyState(int);
HWND GetLastActivePopup(HWND);
HMENU GetMenu(HWND);
LONG GetMenuCheckMarkDimensions();
DWORD GetMenuContextHelpId(HMENU);
UINT GetMenuDefaultItem(HMENU, UINT, UINT);
int GetMenuItemCount(HMENU);
UINT GetMenuItemID(HMENU, int);
BOOL GetMenuItemInfoA(HMENU, UINT, BOOL, LPMENUITEMINFOA);
BOOL GetMenuItemInfoW(HMENU, UINT, BOOL, LPMENUITEMINFOW);
BOOL GetMenuItemRect(HWND, HMENU, UINT, LPRECT);
UINT GetMenuState(HMENU, UINT, UINT);
int GetMenuStringA(HMENU, UINT, LPSTR, int, UINT);
int GetMenuStringW(HMENU, UINT, LPWSTR, int, UINT);
BOOL GetMessageA(LPMSG, HWND, UINT, UINT);
BOOL GetMessageW(LPMSG, HWND, UINT, UINT);
LONG GetMessageExtraInfo();
DWORD GetMessagePos();
LONG GetMessageTime();

HWND GetNextDlgGroupItem(HWND, HWND, BOOL);
HWND GetNextDlgTabItem(HWND, HWND, BOOL);

HWND GetOpenClipboardWindow();
HWND GetParent(HWND);
int GetPriorityClipboardFormat(UINT*, int);
HANDLE GetPropA(HWND, LPCSTR);
HANDLE GetPropW(HWND, LPCWSTR);

DWORD GetQueueStatus(UINT);
BOOL GetScrollInfo(HWND, int, LPSCROLLINFO);
int GetScrollPos(HWND, int);
BOOL GetScrollRange(HWND, int, LPINT, LPINT);

HMENU GetSubMenu(HMENU, int);
DWORD GetSysColor(int);
HBRUSH GetSysColorBrush(int);

HMENU GetSystemMenu(HWND, BOOL);
int GetSystemMetrics(int);
DWORD GetTabbedTextExtentA(HDC, LPCSTR, int, int, LPINT);
DWORD GetTabbedTextExtentW(HDC, LPCWSTR, int, int, LPINT);
LONG GetWindowLongA(HWND, int);
LONG GetWindowLongW(HWND, int);

HDESK GetThreadDesktop(DWORD);
HWND GetTopWindow(HWND);
BOOL GetUpdateRect(HWND, LPRECT, BOOL);
int GetUpdateRgn(HWND, HRGN, BOOL);
BOOL GetUserObjectInformationA(HANDLE, int, PVOID, DWORD, PDWORD);
BOOL GetUserObjectInformationW(HANDLE, int, PVOID, DWORD, PDWORD);
BOOL GetUserObjectSecurity(HANDLE, PSECURITY_INFORMATION, PSECURITY_DESCRIPTOR, DWORD, PDWORD);
HWND GetWindow(HWND, UINT);
DWORD GetWindowContextHelpId(HWND);
HDC GetWindowDC(HWND);
BOOL GetWindowPlacement(HWND, WINDOWPLACEMENT*);
BOOL GetWindowRect(HWND, LPRECT);
int GetWindowRgn(HWND, HRGN);
int GetWindowTextA(HWND, LPSTR, int);
int GetWindowTextLengthA(HWND);
int GetWindowTextLengthW(HWND);
int GetWindowTextW(HWND, LPWSTR, int);
WORD GetWindowWord(HWND, int);
BOOL GetAltTabInfoA(HWND, int, PALTTABINFO, LPSTR, UINT);
BOOL GetAltTabInfoW(HWND, int, PALTTABINFO, LPWSTR, UINT);
BOOL GetComboBoxInfo(HWND, PCOMBOBOXINFO);
BOOL GetCursorInfo(PCURSORINFO);
BOOL GetLastInputInfo(PLASTINPUTINFO);
DWORD GetListBoxInfo(HWND);
BOOL GetMenuBarInfo(HWND, LONG, LONG, PMENUBARINFO);
BOOL GetMenuInfo(HMENU, LPMENUINFO);
BOOL GetScrollBarInfo(HWND, LONG, PSCROLLBARINFO);
BOOL GetTitleBarInfo(HWND, PTITLEBARINFO);
BOOL GetWindowInfo(HWND, PWINDOWINFO);
UINT GetWindowModuleFileNameA(HWND, LPSTR, UINT);
UINT GetWindowModuleFileNameW(HWND, LPWSTR, UINT);
BOOL GrayStringA(HDC, HBRUSH, GRAYSTRINGPROC, LPARAM, int, int, int, int, int);
BOOL GrayStringW(HDC, HBRUSH, GRAYSTRINGPROC, LPARAM, int, int, int, int, int);
BOOL HideCaret(HWND);
BOOL HiliteMenuItem(HWND, HMENU, UINT, UINT);
BOOL InflateRect(LPRECT, int, int);
BOOL InSendMessage();
BOOL InsertMenuA(HMENU, UINT, UINT, UINT, LPCSTR);
BOOL InsertMenuW(HMENU, UINT, UINT, UINT, LPCWSTR);
BOOL InsertMenuItemA(HMENU, UINT, BOOL, LPCMENUITEMINFOA);
BOOL InsertMenuItemW(HMENU, UINT, BOOL, LPCMENUITEMINFOW);
INT InternalGetWindowText(HWND, LPWSTR, INT);
BOOL IntersectRect(LPRECT, LPCRECT, LPCRECT);
BOOL InvalidateRect(HWND, LPCRECT, BOOL);
BOOL InvalidateRgn(HWND, HRGN, BOOL);
BOOL InvertRect(HDC, LPCRECT);
BOOL IsCharAlphaA(CHAR ch);
BOOL IsCharAlphaNumericA(CHAR);
BOOL IsCharAlphaNumericW(WCHAR);
BOOL IsCharAlphaW(WCHAR);
BOOL IsCharLowerA(CHAR);
BOOL IsCharLowerW(WCHAR);
BOOL IsCharUpperA(CHAR);
BOOL IsCharUpperW(WCHAR);
BOOL IsChild(HWND, HWND);
BOOL IsClipboardFormatAvailable(UINT);
BOOL IsDialogMessageA(HWND, LPMSG);
BOOL IsDialogMessageW(HWND, LPMSG);
UINT IsDlgButtonChecked(HWND, int);
BOOL IsIconic(HWND);
BOOL IsMenu(HMENU);
BOOL IsRectEmpty(LPCRECT);
BOOL IsWindow(HWND);
BOOL IsWindowEnabled(HWND);
BOOL IsWindowUnicode(HWND);
BOOL IsWindowVisible(HWND);
BOOL IsZoomed(HWND);
void keybd_event(BYTE, BYTE, DWORD, DWORD);
BOOL KillTimer(HWND, UINT);
HACCEL LoadAcceleratorsA(HINSTANCE, LPCSTR);
HACCEL LoadAcceleratorsW(HINSTANCE, LPCWSTR);
HBITMAP LoadBitmapA(HINSTANCE, LPCSTR);
HBITMAP LoadBitmapW(HINSTANCE, LPCWSTR);
HCURSOR LoadCursorA(HINSTANCE, LPCSTR);
HCURSOR LoadCursorFromFileA(LPCSTR);
HCURSOR LoadCursorFromFileW(LPCWSTR);
HCURSOR LoadCursorW(HINSTANCE, LPCWSTR);
HICON LoadIconA(HINSTANCE, LPCSTR);
HICON LoadIconW(HINSTANCE, LPCWSTR);
HANDLE LoadImageA(HINSTANCE, LPCSTR, UINT, int, int, UINT);
HANDLE LoadImageW(HINSTANCE, LPCWSTR, UINT, int, int, UINT);
HKL LoadKeyboardLayoutA(LPCSTR, UINT);
HKL LoadKeyboardLayoutW(LPCWSTR, UINT);
HMENU LoadMenuA(HINSTANCE, LPCSTR);
HMENU LoadMenuIndirectA( MENUTEMPLATE*);
HMENU LoadMenuIndirectW( MENUTEMPLATE*);
HMENU LoadMenuW(HINSTANCE, LPCWSTR);
int LoadStringA(HINSTANCE, UINT, LPSTR, int);
int LoadStringW(HINSTANCE, UINT, LPWSTR, int);
BOOL LockWindowUpdate(HWND);
int LookupIconIdFromDirectory(PBYTE, BOOL);
int LookupIconIdFromDirectoryEx(PBYTE, BOOL, int, int, UINT);
BOOL MapDialogRect(HWND, LPRECT);
UINT MapVirtualKeyA(UINT, UINT);
UINT MapVirtualKeyExA(UINT, UINT, HKL);
UINT MapVirtualKeyExW(UINT, UINT, HKL);
UINT MapVirtualKeyW(UINT, UINT);
int MapWindowPoints(HWND, HWND, LPPOINT, UINT);
int MenuItemFromPoint(HWND, HMENU, POINT);
BOOL MessageBeep(UINT);
int MessageBoxA(HWND, LPCSTR, LPCSTR, UINT);
int MessageBoxW(HWND, LPCWSTR, LPCWSTR, UINT);
int MessageBoxExA(HWND, LPCSTR, LPCSTR, UINT, WORD);
int MessageBoxExW(HWND, LPCWSTR, LPCWSTR, UINT, WORD);
int MessageBoxIndirectA(MSGBOXPARAMSA*);
int MessageBoxIndirectW(MSGBOXPARAMSW*);
BOOL ModifyMenuA(HMENU, UINT, UINT, UINT, LPCSTR);
BOOL ModifyMenuW(HMENU, UINT, UINT, UINT, LPCWSTR);
void mouse_event(DWORD, DWORD, DWORD, DWORD, ULONG_PTR);
BOOL MoveWindow(HWND, int, int, int, int, BOOL);
DWORD MsgWaitForMultipleObjects(DWORD, HANDLE*, BOOL, DWORD, DWORD);
DWORD MsgWaitForMultipleObjectsEx(DWORD, HANDLE*, DWORD, DWORD, DWORD);
DWORD OemKeyScan(WORD);
BOOL OemToCharA(LPCSTR, LPSTR);
BOOL OemToCharBuffA(LPCSTR, LPSTR, DWORD);
BOOL OemToCharBuffW(LPCSTR, LPWSTR, DWORD);
BOOL OemToCharW(LPCSTR, LPWSTR);
BOOL OffsetRect(LPRECT, int, int);
BOOL OpenClipboard(HWND);
HDESK OpenDesktopA(LPSTR, DWORD, BOOL, DWORD);
HDESK OpenDesktopW(LPWSTR, DWORD, BOOL, DWORD);
BOOL OpenIcon(HWND);
HDESK OpenInputDesktop(DWORD, BOOL, DWORD);
HWINSTA OpenWindowStationA(LPSTR, BOOL, DWORD);
HWINSTA OpenWindowStationW(LPWSTR, BOOL, DWORD);
BOOL PaintDesktop(HDC);
BOOL PeekMessageA(LPMSG, HWND, UINT, UINT, UINT);
BOOL PeekMessageW(LPMSG, HWND, UINT, UINT, UINT);
BOOL PostMessageA(HWND, UINT, WPARAM, LPARAM);
BOOL PostMessageW(HWND, UINT, WPARAM, LPARAM);
void PostQuitMessage(int);
BOOL PostThreadMessageA(DWORD, UINT, WPARAM, LPARAM);
BOOL PostThreadMessageW(DWORD, UINT, WPARAM, LPARAM);
BOOL PtInRect(LPCRECT, POINT);
HWND RealChildWindowFromPoint(HWND, POINT);
UINT RealGetWindowClassA(HWND, LPSTR, UINT);
UINT RealGetWindowClassW(HWND, LPWSTR, UINT);
BOOL RedrawWindow(HWND, LPCRECT, HRGN, UINT);
ATOM RegisterClassA(WNDCLASSA*);
ATOM RegisterClassW(WNDCLASSW*);
ATOM RegisterClassExA(WNDCLASSEXA*);
ATOM RegisterClassExW(WNDCLASSEXW*);
UINT RegisterClipboardFormatA(LPCSTR);
UINT RegisterClipboardFormatW(LPCWSTR);
BOOL RegisterHotKey(HWND, int, UINT, UINT);
UINT RegisterWindowMessageA(LPCSTR);
UINT RegisterWindowMessageW(LPCWSTR);
BOOL ReleaseCapture();
int ReleaseDC(HWND, HDC);
BOOL RemoveMenu(HMENU, UINT, UINT);
HANDLE RemovePropA(HWND, LPCSTR);
HANDLE RemovePropW(HWND, LPCWSTR);
BOOL ReplyMessage(LRESULT);
BOOL ScreenToClient(HWND, LPPOINT);
BOOL ScrollDC(HDC, int, int, LPCRECT, LPCRECT, HRGN, LPRECT);
BOOL ScrollWindow(HWND, int, int, LPCRECT, LPCRECT);
int ScrollWindowEx(HWND, int, int, LPCRECT, LPCRECT, HRGN, LPRECT, UINT);
LONG SendDlgItemMessageA(HWND, int, UINT, WPARAM, LPARAM);
LONG SendDlgItemMessageW(HWND, int, UINT, WPARAM, LPARAM);
LRESULT SendMessageA(HWND, UINT, WPARAM, LPARAM);
BOOL SendMessageCallbackA(HWND, UINT, WPARAM, LPARAM, SENDASYNCPROC, DWORD);
BOOL SendMessageCallbackW(HWND, UINT, WPARAM, LPARAM, SENDASYNCPROC, DWORD);
LRESULT SendMessageTimeoutA(HWND, UINT, WPARAM, LPARAM, UINT, UINT, PDWORD);
LRESULT SendMessageTimeoutW(HWND, UINT, WPARAM, LPARAM, UINT, UINT, PDWORD);
LRESULT SendMessageW(HWND, UINT, WPARAM, LPARAM);
BOOL SendNotifyMessageA(HWND, UINT, WPARAM, LPARAM);
BOOL SendNotifyMessageW(HWND, UINT, WPARAM, LPARAM);
HWND SetActiveWindow(HWND);
HWND SetCapture(HWND hWnd);
BOOL SetCaretBlinkTime(UINT);
BOOL SetCaretPos(int, int);
DWORD SetClassLongA(HWND, int, LONG);
DWORD SetClassLongW(HWND, int, LONG);
WORD SetClassWord(HWND, int, WORD);
HANDLE SetClipboardData(UINT, HANDLE);
HWND SetClipboardViewer(HWND);
HCURSOR SetCursor(HCURSOR);
BOOL SetCursorPos(int, int);
void SetDebugErrorLevel(DWORD);
BOOL SetDlgItemInt(HWND, int, UINT, BOOL);
BOOL SetDlgItemTextA(HWND, int, LPCSTR);
BOOL SetDlgItemTextW(HWND, int, LPCWSTR);
BOOL SetDoubleClickTime(UINT);
HWND SetFocus(HWND);
BOOL SetForegroundWindow(HWND);
BOOL SetKeyboardState(PBYTE);
BOOL SetMenu(HWND, HMENU);
BOOL SetMenuContextHelpId(HMENU, DWORD);
BOOL SetMenuDefaultItem(HMENU, UINT, UINT);
BOOL SetMenuInfo(HMENU, LPCMENUINFO);
BOOL SetMenuItemBitmaps(HMENU, UINT, UINT, HBITMAP, HBITMAP);
BOOL SetMenuItemInfoA(HMENU, UINT, BOOL, LPCMENUITEMINFOA);
BOOL SetMenuItemInfoW( HMENU, UINT, BOOL, LPCMENUITEMINFOW);
LPARAM SetMessageExtraInfo(LPARAM);
BOOL SetMessageQueue(int);
HWND SetParent(HWND, HWND);
BOOL SetProcessWindowStation(HWINSTA);
BOOL SetPropA(HWND, LPCSTR, HANDLE);
BOOL SetPropW(HWND, LPCWSTR, HANDLE);
BOOL SetRect(LPRECT, int, int, int, int);
BOOL SetRectEmpty(LPRECT);
int SetScrollInfo(HWND, int, LPCSCROLLINFO, BOOL);
int SetScrollPos(HWND, int, int, BOOL);
BOOL SetScrollRange(HWND, int, int, int, BOOL);
BOOL SetSysColors(int, INT* , COLORREF* );
BOOL SetSystemCursor(HCURSOR, DWORD);
BOOL SetThreadDesktop(HDESK);
UINT SetTimer(HWND, UINT, UINT, TIMERPROC);
BOOL SetUserObjectInformationA(HANDLE, int, PVOID, DWORD);
BOOL SetUserObjectInformationW(HANDLE, int, PVOID, DWORD);
BOOL SetUserObjectSecurity(HANDLE, PSECURITY_INFORMATION, PSECURITY_DESCRIPTOR);
BOOL SetWindowContextHelpId(HWND, DWORD);
LONG SetWindowLongA(HWND, int, LONG);
LONG SetWindowLongW(HWND, int, LONG);
BOOL SetWindowPlacement(HWND hWnd, WINDOWPLACEMENT*);
BOOL SetWindowPos(HWND, HWND, int, int, int, int, UINT);
int SetWindowRgn(HWND, HRGN, BOOL);
HHOOK SetWindowsHookA(int, HOOKPROC);
HHOOK SetWindowsHookW(int, HOOKPROC);
HHOOK SetWindowsHookExA(int, HOOKPROC, HINSTANCE, DWORD);
HHOOK SetWindowsHookExW(int, HOOKPROC, HINSTANCE, DWORD);
BOOL SetWindowTextA(HWND, LPCSTR);
BOOL SetWindowTextW(HWND, LPCWSTR);
WORD SetWindowWord(HWND, int, WORD);
BOOL ShowCaret(HWND);
int ShowCursor(BOOL);
BOOL ShowOwnedPopups(HWND, BOOL);
BOOL ShowScrollBar(HWND, int, BOOL);
BOOL ShowWindow(HWND, int);
BOOL ShowWindowAsync(HWND, int);
BOOL SubtractRect(LPRECT, LPCRECT, LPCRECT);
BOOL SwapMouseButton(BOOL);
BOOL SwitchDesktop(HDESK);
BOOL SystemParametersInfoA(UINT, UINT, PVOID, UINT);
BOOL SystemParametersInfoW(UINT, UINT, PVOID, UINT);
LONG TabbedTextOutA(HDC, int, int, LPCSTR, int, int, LPINT, int);
LONG TabbedTextOutW(HDC, int, int, LPCWSTR, int, int, LPINT, int);
WORD TileWindows(HWND, UINT, LPCRECT, UINT, HWND* );
int ToAscii(UINT, UINT, PBYTE, LPWORD, UINT);
int ToAsciiEx(UINT, UINT, PBYTE, LPWORD, UINT, HKL);
int ToUnicode(UINT, UINT, PBYTE, LPWSTR, int, UINT);
int ToUnicodeEx(UINT, UINT, PBYTE, LPWSTR, int, UINT, HKL);
BOOL TrackMouseEvent(LPTRACKMOUSEEVENT);
BOOL TrackPopupMenu(HMENU, UINT, int, int, int, HWND, LPCRECT);
BOOL TrackPopupMenuEx(HMENU, UINT, int, int, HWND, LPTPMPARAMS);
int TranslateAcceleratorA(HWND, HACCEL, LPMSG);
int TranslateAcceleratorW(HWND, HACCEL, LPMSG);
BOOL TranslateMDISysAccel(HWND, LPMSG);
BOOL TranslateMessage( MSG*);
BOOL UnhookWindowsHook(int, HOOKPROC);
BOOL UnhookWindowsHookEx(HHOOK);
BOOL UnionRect(LPRECT, LPCRECT, LPCRECT);
BOOL UnloadKeyboardLayout(HKL);
BOOL UnregisterClassA(LPCSTR, HINSTANCE);
BOOL UnregisterClassW(LPCWSTR, HINSTANCE);
BOOL UnregisterHotKey(HWND, int);
BOOL UpdateWindow(HWND);
BOOL ValidateRect(HWND, LPCRECT);
BOOL ValidateRgn(HWND, HRGN);
SHORT VkKeyScanA(CHAR);
SHORT VkKeyScanExA(CHAR, HKL);
SHORT VkKeyScanExW(WCHAR, HKL);
SHORT VkKeyScanW(WCHAR);
DWORD WaitForInputIdle(HANDLE, DWORD);
BOOL WaitMessage();
HWND WindowFromDC(HDC hDC);
HWND WindowFromPoint(POINT);
UINT WinExec(LPCSTR, UINT);
BOOL WinHelpA(HWND, LPCSTR, UINT, DWORD);
BOOL WinHelpW(HWND, LPCWSTR, UINT, DWORD);

extern (C) {
	int wsprintfA(LPSTR, LPCSTR, ...);
	int wsprintfW(LPWSTR, LPCWSTR, ...);
}


// These shouldn't be necessary for D.
typedef char* va_list_;
int wvsprintfA(LPSTR, LPCSTR, va_list_ arglist);
int wvsprintfW(LPWSTR, LPCWSTR, va_list_ arglist);


static if (_WIN32_WINDOWS == 0x400) {
// On Win95, there's only one version.
int BroadcastSystemMessage(DWORD, LPDWORD, UINT, WPARAM, LPARAM);
}
static if (_WIN32_WINNT >= 0x400) {
int BroadcastSystemMessageA(DWORD, LPDWORD, UINT, WPARAM, LPARAM);
int BroadcastSystemMessageW(DWORD, LPDWORD, UINT, WPARAM, LPARAM);
}
static if (_WIN32_WINNT >= 0x501) {
int BroadcastSystemMessageExA(DWORD, LPDWORD, UINT, WPARAM, LPARAM, PBSMINFO);
int BroadcastSystemMessageExW(DWORD, LPDWORD, UINT, WPARAM, LPARAM, PBSMINFO);
}

static if (_WIN32_WINNT >= 0x403) {
UINT SendInput(UINT, LPINPUT, int);
}
static if (_WIN32_WINNT >= 0x500) {
BOOL AnimateWindow(HWND, DWORD, DWORD);
BOOL EndTask(HWND, BOOL, BOOL);
DWORD GetGuiResources(HANDLE, DWORD);
HWND GetShellWindow();
BOOL GetProcessDefaultLayout(DWORD*);
BOOL IsHungAppWindow(HWND);
BOOL LockWorkStation();
HDEVNOTIFY RegisterDeviceNotificationA(HANDLE, LPVOID, DWORD);
HDEVNOTIFY RegisterDeviceNotificationW(HANDLE, LPVOID, DWORD);
BOOL SetProcessDefaultLayout(DWORD);
void SwitchToThisWindow(HWND, BOOL);
BOOL SetLayeredWindowAttributes(HWND, COLORREF, BYTE, DWORD);
BOOL UpdateLayeredWindow(HWND, HDC, POINT*, SIZE*, HDC, POINT*, COLORREF, BLENDFUNCTION*, DWORD);
BOOL UserHandleGrantAccess(HANDLE, HANDLE, BOOL);
}
static if (_WIN32_WINNT >= 0x501) {
UINT GetRawInputBuffer(PRAWINPUT, PUINT, UINT);
UINT GetRawInputData(HRAWINPUT, UINT, LPVOID, PUINT, UINT);
UINT GetRawInputDeviceInfoA(HANDLE, UINT, LPVOID, PUINT);
UINT GetRawInputDeviceInfoW(HANDLE, UINT, LPVOID, PUINT);
UINT GetRawInputDeviceList(PRAWINPUTDEVICELIST, PUINT, UINT);
UINT GetRegisteredRawInputDevices(PRAWINPUTDEVICE, PUINT, UINT);
LRESULT DefRawInputProc(PRAWINPUT*, INT, UINT);
BOOL RegisterRawInputDevices(PCRAWINPUTDEVICE, UINT, UINT);

BOOL IsGUIThread(BOOL);
BOOL IsWinEventHookInstalled(DWORD);
BOOL PrintWindow(HWND, HDC, UINT);
BOOL GetLayeredWindowAttributes(HWND, COLORREF*, BYTE*, DWORD*);
}
static if (WINVER >= 0x410) {
	BOOL EnumDisplayMonitors(HDC, LPCRECT, MONITORENUMPROC, LPARAM);
	BOOL GetMonitorInfoA(HMONITOR, LPMONITORINFO);
	BOOL GetMonitorInfoA(HMONITOR, LPMONITORINFOEXA);
	BOOL GetMonitorInfoW(HMONITOR, LPMONITORINFO);
	BOOL GetMonitorInfoW(HMONITOR, LPMONITORINFOEXW);
	HMONITOR MonitorFromPoint(POINT, DWORD);
	HMONITOR MonitorFromRect(LPCRECT, DWORD);
	HMONITOR MonitorFromWindow(HWND, DWORD);
}
static if (WINVER >= 0x500) {
BOOL GetGUIThreadInfo(DWORD, LPGUITHREADINFO);
void NotifyWinEvent(DWORD, HWND, LONG, LONG);
HWINEVENTHOOK SetWinEventHook(UINT, UINT, HMODULE, WINEVENTPROC, DWORD, DWORD, UINT);
BOOL UnhookWinEvent(HWINEVENTHOOK);
BOOL UnregisterDeviceNotification(HANDLE);
}
static if ((_WIN32_WINNT >= 0x500) || (_WIN32_WINDOWS >= 0x410)) {
BOOL EnumDisplaySettingsExA(LPCSTR, DWORD, LPDEVMODEA, DWORD);
BOOL EnumDisplaySettingsExW(LPCWSTR, DWORD, LPDEVMODEW, DWORD);
BOOL FlashWindowEx(PFLASHWINFO);
DWORD GetClipboardSequenceNumber();
DWORD InSendMessageEx(LPVOID);
}
static if ((_WIN32_WINNT >= 0x500) || (_WIN32_WINDOWS >= 0x490)) {
BOOL AllowSetForegroundWindow(DWORD);
BOOL LockSetForegroundWindow(UINT);
int GetMouseMovePointsEx(UINT, LPMOUSEMOVEPOINT, LPMOUSEMOVEPOINT, int, DWORD);
}

version (Win64) {
LONG_PTR GetWindowLongPtrA(HWND, int);
LONG_PTR GetWindowLongPtrW(HWND, int);
LONG_PTR SetWindowLongPtrA(HWND, int, LONG_PTR);
LONG_PTR SetWindowLongPtrW(HWND, int, LONG_PTR);
} else {
alias GetWindowLongA GetWindowLongPtrA;
alias GetWindowLongW GetWindowLongPtrW;
alias SetWindowLongA SetWindowLongPtrA;
alias SetWindowLongW SetWindowLongPtrW;
}


// -----
// Aliases for Unicode or Ansi
version(Unicode) {

alias EDITWORDBREAKPROCW EDITWORDBREAKPROC;
alias PROPENUMPROCW PROPENUMPROC;
alias PROPENUMPROCEXW PROPENUMPROCEX;
alias DESKTOPENUMPROCW DESKTOPENUMPROC;
alias WINSTAENUMPROCW WINSTAENUMPROC;
alias MAKEINTRESOURCEW MAKEINTRESOURCE;

alias WNDCLASSW WNDCLASS;
alias WNDCLASSEXW WNDCLASSEX;
alias MENUITEMINFOW MENUITEMINFO;
alias LPCMENUITEMINFOW LPCMENUITEMINFO;
alias MSGBOXPARAMSW MSGBOXPARAMS;
alias HIGHCONTRASTW HIGHCONTRAST;
alias SERIALKEYSW SERIALKEYS;
alias SOUNDSENTRYW SOUNDSENTRY;
alias CREATESTRUCTW CREATESTRUCT;
alias CBT_CREATEWNDW CBT_CREATEWND;
alias MDICREATESTRUCTW MDICREATESTRUCT;
alias MULTIKEYHELPW MULTIKEYHELP;
alias MONITORINFOEXW MONITORINFOEX;
alias ICONMETRICSW ICONMETRICS;
alias NONCLIENTMETRICSW NONCLIENTMETRICS;

alias AppendMenuW AppendMenu;
alias BroadcastSystemMessageW BroadcastSystemMessage;
static if (_WIN32_WINNT >= 0x501) {
alias BroadcastSystemMessageExW BroadcastSystemMessageEx;
}
alias CallMsgFilterW CallMsgFilter;
alias CallWindowProcW CallWindowProc;
alias ChangeMenuW ChangeMenu;
alias CharLowerW CharLower;
alias CharLowerBuffW CharLowerBuff;
alias CharNextW CharNext;
alias CharNextExW CharNextEx;
alias CharPrevW CharPrev;
alias CharPrevExW CharPrevEx;
alias CharToOemW CharToOem;
alias CharToOemBuffW CharToOemBuff;
alias CharUpperW CharUpper;
alias CharUpperBuffW CharUpperBuff;
alias CopyAcceleratorTableW CopyAcceleratorTable;
alias CreateAcceleratorTableW CreateAcceleratorTable;
alias CreateDialogW CreateDialog;
alias CreateDialogIndirectW CreateDialogIndirect;
alias CreateDialogIndirectParamW CreateDialogIndirectParam;
alias CreateDialogParamW CreateDialogParam;
alias CreateMDIWindowW CreateMDIWindow;
alias CreateWindowW CreateWindow;
alias CreateWindowExW CreateWindowEx;
alias CreateWindowStationW CreateWindowStation;
alias DefDlgProcW DefDlgProc;
alias DefFrameProcW DefFrameProc;
alias DefMDIChildProcW DefMDIChildProc;
alias DefWindowProcW DefWindowProc;
alias DialogBoxW DialogBox;
alias DialogBoxIndirectW DialogBoxIndirect;
alias DialogBoxIndirectParamW DialogBoxIndirectParam;
alias DialogBoxParamW DialogBoxParam;
alias DispatchMessageW DispatchMessage;
alias DlgDirListW DlgDirList;
alias DlgDirListComboBoxW DlgDirListComboBox;
alias DlgDirSelectComboBoxExW DlgDirSelectComboBoxEx;
alias DlgDirSelectExW DlgDirSelectEx;
alias DrawStateW DrawState;
alias DrawTextW DrawText;
alias DrawTextExW DrawTextEx;
alias EnumDesktopsW EnumDesktops;
alias EnumPropsW EnumProps;
alias EnumPropsExW EnumPropsEx;
alias EnumWindowStationsW EnumWindowStations;
alias FindWindowW FindWindow;
alias FindWindowExW FindWindowEx;
alias GetClassInfoW GetClassInfo;
alias GetClassInfoExW GetClassInfoEx;
alias GetClassLongW GetClassLong;
alias GetClassNameW GetClassName;
alias GetClipboardFormatNameW GetClipboardFormatName;
alias GetDlgItemTextW GetDlgItemText;
alias GetKeyboardLayoutNameW GetKeyboardLayoutName;
alias GetKeyNameTextW GetKeyNameText;
alias GetMenuItemInfoW GetMenuItemInfo;
alias GetMenuStringW GetMenuString;
alias GetMessageW GetMessage;
static if (WINVER >=0x410) {
alias GetMonitorInfoW GetMonitorInfo;
}
alias GetPropW GetProp;
static if (_WIN32_WINNT >= 0x501) {
alias GetRawInputDeviceInfoW GetRawInputDeviceInfo;
}
alias GetTabbedTextExtentW GetTabbedTextExtent;
alias GetUserObjectInformationW GetUserObjectInformation;
alias GetWindowLongW GetWindowLong;
alias GetWindowLongPtrW GetWindowLongPtr;
alias GetWindowTextW GetWindowText;
alias GetWindowTextLengthW GetWindowTextLength;
alias GetAltTabInfoW GetAltTabInfo;
alias GetWindowModuleFileNameW GetWindowModuleFileName;
alias GrayStringW GrayString;
alias InsertMenuW InsertMenu;
alias InsertMenuItemW InsertMenuItem;
alias IsCharAlphaW IsCharAlpha;
alias IsCharAlphaNumericW IsCharAlphaNumeric;
alias IsCharLowerW IsCharLower;
alias IsCharUpperW IsCharUpper;
alias IsDialogMessageW IsDialogMessage;
alias LoadAcceleratorsW LoadAccelerators;
alias LoadBitmapW LoadBitmap;
alias LoadCursorW LoadCursor;
alias LoadCursorFromFileW LoadCursorFromFile;
alias LoadIconW LoadIcon;
alias LoadImageW LoadImage;
alias LoadKeyboardLayoutW LoadKeyboardLayout;
alias LoadMenuW LoadMenu;
alias LoadMenuIndirectW LoadMenuIndirect;
alias LoadStringW LoadString;
alias MapVirtualKeyW MapVirtualKey;
alias MapVirtualKeyExW MapVirtualKeyEx;
alias MessageBoxW MessageBox;
alias MessageBoxExW MessageBoxEx;
alias MessageBoxIndirectW MessageBoxIndirect;
alias ModifyMenuW ModifyMenu;
alias OemToCharW OemToChar;
alias OemToCharBuffW OemToCharBuff;
alias OpenDesktopW OpenDesktop;
alias OpenWindowStationW OpenWindowStation;
alias PeekMessageW PeekMessage;
alias PostMessageW PostMessage;
alias PostThreadMessageW PostThreadMessage;
alias RealGetWindowClassW RealGetWindowClass;
alias RegisterClassW RegisterClass;
alias RegisterClassExW RegisterClassEx;
alias RegisterClipboardFormatW RegisterClipboardFormat;
static if (WINVER >= 0x500) {
alias RegisterDeviceNotificationW RegisterDeviceNotification;
}
alias RegisterWindowMessageW RegisterWindowMessage;
alias RemovePropW RemoveProp;
alias SendDlgItemMessageW SendDlgItemMessage;
alias SendMessageW SendMessage;
alias SendMessageCallbackW SendMessageCallback;
alias SendMessageTimeoutW SendMessageTimeout;
alias SendNotifyMessageW SendNotifyMessage;
alias SetClassLongW SetClassLong;
alias SetDlgItemTextW SetDlgItemText;
alias SetMenuItemInfoW SetMenuItemInfo;
alias SetPropW SetProp;
alias SetUserObjectInformationW SetUserObjectInformation;
alias SetWindowLongW SetWindowLong;
alias SetWindowLongPtrW SetWindowLongPtr;
alias SetWindowsHookW SetWindowsHook;
alias SetWindowsHookExW SetWindowsHookEx;
alias SetWindowTextW SetWindowText;
alias SystemParametersInfoW SystemParametersInfo;
alias TabbedTextOutW TabbedTextOut;
alias TranslateAcceleratorW TranslateAccelerator;
alias UnregisterClassW UnregisterClass;
alias VkKeyScanW VkKeyScan;
alias VkKeyScanExW VkKeyScanEx;
alias WinHelpW WinHelp;
alias wsprintfW wsprintf;
alias wvsprintfW wvsprintf;

alias ChangeDisplaySettingsW ChangeDisplaySettings;
alias ChangeDisplaySettingsExW ChangeDisplaySettingsEx;
alias CreateDesktopW CreateDesktop;
alias EnumDisplaySettingsW EnumDisplaySettings;
static if ((_WIN32_WINNT >= 0x500) || (_WIN32_WINDOWS >= 0x410)) {
alias EnumDisplaySettingsExW EnumDisplaySettingsEx;
}
alias EnumDisplayDevicesW EnumDisplayDevices;

} else { // ANSI

alias EDITWORDBREAKPROCA EDITWORDBREAKPROC;
alias PROPENUMPROCA PROPENUMPROC;
alias PROPENUMPROCEXA PROPENUMPROCEX;
alias DESKTOPENUMPROCA DESKTOPENUMPROC;
alias WINSTAENUMPROCA WINSTAENUMPROC;
alias MAKEINTRESOURCEA MAKEINTRESOURCE;

alias WNDCLASSA WNDCLASS;
alias WNDCLASSEXA WNDCLASSEX;
alias MENUITEMINFOA MENUITEMINFO;
alias LPCMENUITEMINFOA LPCMENUITEMINFO;
alias MSGBOXPARAMSA MSGBOXPARAMS;
alias HIGHCONTRASTA HIGHCONTRAST;
alias SERIALKEYSA SERIALKEYS;
alias SOUNDSENTRYA SOUNDSENTRY;
alias CREATESTRUCTA CREATESTRUCT;
alias CBT_CREATEWNDA CBT_CREATEWND;
alias MDICREATESTRUCTA MDICREATESTRUCT;
alias MULTIKEYHELPA MULTIKEYHELP;
alias MONITORINFOEXA MONITORINFOEX;
alias ICONMETRICSA ICONMETRICS;
alias NONCLIENTMETRICSA NONCLIENTMETRICS;

alias AppendMenuA AppendMenu;
alias BroadcastSystemMessageA BroadcastSystemMessage;
static if (_WIN32_WINNT >= 0x501) {
alias BroadcastSystemMessageExA BroadcastSystemMessageEx;
}
alias CallMsgFilterA CallMsgFilter;
alias CallWindowProcA CallWindowProc;
alias ChangeMenuA ChangeMenu;
alias CharLowerA CharLower;
alias CharLowerBuffA CharLowerBuff;
alias CharNextA CharNext;
alias CharNextExA CharNextEx;
alias CharPrevA CharPrev;
alias CharPrevExA CharPrevEx;
alias CharToOemA CharToOem;
alias CharToOemBuffA CharToOemBuff;
alias CharUpperA CharUpper;
alias CharUpperBuffA CharUpperBuff;
alias CopyAcceleratorTableA CopyAcceleratorTable;
alias CreateAcceleratorTableA CreateAcceleratorTable;
alias CreateDialogA CreateDialog;
alias CreateDialogIndirectA CreateDialogIndirect;
alias CreateDialogIndirectParamA CreateDialogIndirectParam;
alias CreateDialogParamA CreateDialogParam;
alias CreateMDIWindowA CreateMDIWindow;
alias CreateWindowA CreateWindow;
alias CreateWindowExA CreateWindowEx;
alias CreateWindowStationA CreateWindowStation;
alias DefDlgProcA DefDlgProc;
alias DefFrameProcA DefFrameProc;
alias DefMDIChildProcA DefMDIChildProc;
alias DefWindowProcA DefWindowProc;
alias DialogBoxA DialogBox;
alias DialogBoxIndirectA DialogBoxIndirect;
alias DialogBoxIndirectParamA DialogBoxIndirectParam;
alias DialogBoxParamA DialogBoxParam;
alias DispatchMessageA DispatchMessage;
alias DlgDirListA DlgDirList;
alias DlgDirListComboBoxA DlgDirListComboBox;
alias DlgDirSelectComboBoxExA DlgDirSelectComboBoxEx;
alias DlgDirSelectExA DlgDirSelectEx;
alias DrawStateA DrawState;
alias DrawTextA DrawText;
alias DrawTextExA DrawTextEx;
alias EnumDesktopsA EnumDesktops;
alias EnumPropsA EnumProps;
alias EnumPropsExA EnumPropsEx;
alias EnumWindowStationsA EnumWindowStations;
alias FindWindowA FindWindow;
alias FindWindowExA FindWindowEx;
alias GetClassInfoA GetClassInfo;
alias GetClassInfoExA GetClassInfoEx;
alias GetClassLongA GetClassLong;
alias GetClassNameA GetClassName;
alias GetClipboardFormatNameA GetClipboardFormatName;
alias GetDlgItemTextA GetDlgItemText;
alias GetKeyboardLayoutNameA GetKeyboardLayoutName;
alias GetKeyNameTextA GetKeyNameText;
alias GetMenuItemInfoA GetMenuItemInfo;
alias GetMenuStringA GetMenuString;
alias GetMessageA GetMessage;
static if (WINVER >=0x410) {
alias GetMonitorInfoA GetMonitorInfo;
}
alias GetPropA GetProp;
static if (_WIN32_WINNT >= 0x501) {
alias GetRawInputDeviceInfoA GetRawInputDeviceInfo;
}
alias GetTabbedTextExtentA GetTabbedTextExtent;
alias GetUserObjectInformationA GetUserObjectInformation;
alias GetWindowLongA GetWindowLong;
alias GetWindowLongPtrA GetWindowLongPtr;
alias GetWindowTextA GetWindowText;
alias GetWindowTextLengthA GetWindowTextLength;
alias GetAltTabInfoA GetAltTabInfo;
alias GetWindowModuleFileNameA GetWindowModuleFileName;
alias GrayStringA GrayString;
alias InsertMenuA InsertMenu;
alias InsertMenuItemA InsertMenuItem;
alias IsCharAlphaA IsCharAlpha;
alias IsCharAlphaNumericA IsCharAlphaNumeric;
alias IsCharLowerA IsCharLower;
alias IsCharUpperA IsCharUpper;
alias IsDialogMessageA IsDialogMessage;
alias LoadAcceleratorsA LoadAccelerators;
alias LoadBitmapA LoadBitmap;
alias LoadCursorA LoadCursor;
alias LoadIconA LoadIcon;
alias LoadCursorFromFileA LoadCursorFromFile;
alias LoadImageA LoadImage;
alias LoadKeyboardLayoutA LoadKeyboardLayout;
alias LoadMenuA LoadMenu;
alias LoadMenuIndirectA LoadMenuIndirect;
alias LoadStringA LoadString;
alias MapVirtualKeyA MapVirtualKey;
alias MapVirtualKeyExA MapVirtualKeyEx;
alias MessageBoxA MessageBox;
alias MessageBoxExA MessageBoxEx;
alias MessageBoxIndirectA MessageBoxIndirect;
alias ModifyMenuA ModifyMenu;
alias OemToCharA OemToChar;
alias OemToCharBuffA OemToCharBuff;
alias OpenDesktopA OpenDesktop;
alias OpenWindowStationA OpenWindowStation;
alias PeekMessageA PeekMessage;
alias PostMessageA PostMessage;
alias PostThreadMessageA PostThreadMessage;
alias RealGetWindowClassA RealGetWindowClass;
alias RegisterClassA RegisterClass;
alias RegisterClassExA RegisterClassEx;
alias RegisterClipboardFormatA RegisterClipboardFormat;
static if (WINVER >= 0x500) {
alias RegisterDeviceNotificationA RegisterDeviceNotification;
}
alias RegisterWindowMessageA RegisterWindowMessage;
alias RemovePropA RemoveProp;
alias SendDlgItemMessageA SendDlgItemMessage;
alias SendMessageA SendMessage;
alias SendMessageCallbackA SendMessageCallback;
alias SendMessageTimeoutA SendMessageTimeout;
alias SendNotifyMessageA SendNotifyMessage;
alias SetClassLongA SetClassLong;
alias SetDlgItemTextA SetDlgItemText;
alias SetMenuItemInfoA SetMenuItemInfo;
alias SetPropA SetProp;
alias SetUserObjectInformationA SetUserObjectInformation;
alias SetWindowLongA SetWindowLong;
alias SetWindowLongPtrA SetWindowLongPtr;
alias SetWindowsHookA SetWindowsHook;
alias SetWindowsHookExA SetWindowsHookEx;
alias SetWindowTextA SetWindowText;
alias SystemParametersInfoA SystemParametersInfo;
alias TabbedTextOutA TabbedTextOut;
alias TranslateAcceleratorA TranslateAccelerator;
alias UnregisterClassA UnregisterClass;
alias VkKeyScanA VkKeyScan;
alias VkKeyScanExA VkKeyScanEx;
alias WinHelpA WinHelp;
alias wsprintfA wsprintf;
alias wvsprintfA wvsprintf;

alias ChangeDisplaySettingsA ChangeDisplaySettings;
alias ChangeDisplaySettingsExA ChangeDisplaySettingsEx;
alias CreateDesktopA CreateDesktop;
alias EnumDisplaySettingsA EnumDisplaySettings;
static if ((_WIN32_WINNT >= 0x500) || (_WIN32_WINDOWS >= 0x410)) {
	alias EnumDisplaySettingsExA EnumDisplaySettingsEx;
}
	alias EnumDisplayDevicesA EnumDisplayDevices;
}


alias WNDCLASS* LPWNDCLASS, PWNDCLASS;
alias WNDCLASSEX* LPWNDCLASSEX, PWNDCLASSEX;
alias MENUITEMINFO* LPMENUITEMINFO;
alias MSGBOXPARAMS* PMSGBOXPARAMS, LPMSGBOXPARAMS;
alias HIGHCONTRAST* LPHIGHCONTRAST;
alias SERIALKEYS* LPSERIALKEYS;
alias SOUNDSENTRY* LPSOUNDSENTRY;
alias CREATESTRUCT* LPCREATESTRUCT;
alias CBT_CREATEWND* LPCBT_CREATEWND;
alias MDICREATESTRUCT* LPMDICREATESTRUCT;
alias MULTIKEYHELP* PMULTIKEYHELP, LPMULTIKEYHELP;
alias MONITORINFOEX* LPMONITORINFOEX;
alias ICONMETRICS* LPICONMETRICS;
alias NONCLIENTMETRICS* LPNONCLIENTMETRICS;
