/***********************************************************************\
*                               exdisp.d                                *
*                                                                       *
*                       Windows API header module                       *
*                                                                       *
*                 Translated from MinGW Windows headers                 *
*                                                                       *
*                       Placed into public domain                       *
\***********************************************************************/
module win32.exdisp;

import win32.docobj, win32.oaidl, win32.ocidl;
private import win32.basetyps, win32.windef, win32.wtypes;


enum BrowserNavConstants {
	navOpenInNewWindow = 0x01,
	navNoHistory       = 0x02,
	navNoReadFromCache = 0x04,
	navNoWriteTocache  = 0x08,
	navAllowAutosearch = 0x10,
	navBrowserBar      = 0x20,
	navHyperLink       = 0x40
}

extern (C) {
	extern const CLSID CLSID_WebBrowser;
	extern const IID
		DIID_DWebBrowserEvents,
		IID_IWebBrowser,
		IID_IWebBrowserApp,
		IID_IWebBrowser2,
		DIID_DWebBrowserEvents2;
}

interface IWebBrowser : public IDispatch {
	HRESULT GoBack();
	HRESULT GoForward();
	HRESULT GoHome();
	HRESULT GoSearch();
	HRESULT Navigate(BSTR, VARIANT*, VARIANT*, VARIANT*, VARIANT*);
	HRESULT Refresh();
	HRESULT Refresh2(VARIANT*);
	HRESULT Stop();
	HRESULT get_Application(IDispatch**);
	HRESULT get_Parent(IDispatch**);
	HRESULT get_Container(IDispatch**);
	HRESULT get_Document(IDispatch**);
	HRESULT get_TopLevelContainer(VARIANT_BOOL*);
	HRESULT get_Type(BSTR*);
	HRESULT get_Left(long*);
	HRESULT put_Left(long);
	HRESULT get_Top(long*);
	HRESULT put_Top(long);
	HRESULT get_Width(long*);
	HRESULT put_Width(long);
	HRESULT get_Height(long*);
	HRESULT put_Height(long);
	HRESULT get_LocationName(BSTR*);
	HRESULT get_LocationURL(BSTR*);
	HRESULT get_Busy(VARIANT_BOOL*);
}

interface IWebBrowserApp : public IWebBrowser {
	HRESULT Quit();
	HRESULT ClientToWindow(int*, int*);
	HRESULT PutProperty(BSTR, VARIANT);
	HRESULT GetProperty(BSTR, VARIANT*);
	HRESULT get_Name(BSTR*);
	HRESULT get_HWND(long*);
	HRESULT get_FullName(BSTR*);
	HRESULT get_Path(BSTR*);
	HRESULT get_Visible(VARIANT_BOOL*);
	HRESULT put_Visible(VARIANT_BOOL);
	HRESULT get_StatusBar(VARIANT_BOOL*);
	HRESULT put_StatusBar(VARIANT_BOOL);
	HRESULT get_StatusText(BSTR*);
	HRESULT put_StatusText(BSTR);
	HRESULT get_ToolBar(int*);
	HRESULT put_ToolBar(int);
	HRESULT get_MenuBar(VARIANT_BOOL*);
	HRESULT put_MenuBar(VARIANT_BOOL);
	HRESULT get_FullScreen(VARIANT_BOOL*);
	HRESULT put_FullScreen(VARIANT_BOOL);
}

interface IWebBrowser2 : public IWebBrowserApp {
	HRESULT Navigate2(VARIANT*, VARIANT*, VARIANT*, VARIANT*, VARIANT*);
	HRESULT QueryStatusWB(OLECMDID, OLECMDF*);
	HRESULT ExecWB(OLECMDID, OLECMDEXECOPT, VARIANT*, VARIANT*);
	HRESULT ShowBrowserBar(VARIANT*, VARIANT*, VARIANT*);
	HRESULT get_ReadyState(READYSTATE*);
	HRESULT get_Offline(VARIANT_BOOL*);
	HRESULT put_Offline(VARIANT_BOOL);
	HRESULT get_Silent(VARIANT_BOOL*);
	HRESULT put_Silent(VARIANT_BOOL);
	HRESULT get_RegistaerAsBrowser(VARIANT_BOOL*);
	HRESULT put_RegisterAsBrowser(VARIANT_BOOL);
	HRESULT get_RegistaerAsDropTarget(VARIANT_BOOL*);
	HRESULT put_RegisterAsDropTarget(VARIANT_BOOL);
	HRESULT get_TheaterMode(VARIANT_BOOL*);
	HRESULT put_TheaterMode(VARIANT_BOOL);
	HRESULT get_AddressBar(VARIANT_BOOL*);
	HRESULT put_AddressBar(VARIANT_BOOL);
	HRESULT get_Resizable(VARIANT_BOOL*);
	HRESULT put_Resizable(VARIANT_BOOL);
}

interface DWebBrowserEvents2 : public IDispatch {
	void StatusTextChange(BSTR);
	void ProgressChange(long, long);
	void CommandStateChange(long, VARIANT_BOOL);
	void DownloadBegin();
	void DownloadComplete();
	void TitleChange(BSTR);
	void PropertyChange(BSTR);
	void BeforeNavigate2(IDispatch*, VARIANT*, VARIANT*, VARIANT*, VARIANT*, VARIANT*, VARIANT_BOOL*);
	void NewWindow2(IDispatch**, VARIANT_BOOL*);
	void NavigateComplete(IDispatch*, VARIANT*);
	void DocumentComplete(IDispatch*, VARIANT*);
	void OnQuit();
	void OnVisible(VARIANT_BOOL);
	void OnToolBar(VARIANT_BOOL);
	void OnMenuBar(VARIANT_BOOL);
	void OnStatusBar(VARIANT_BOOL);
	void OnFullScreen(VARIANT_BOOL);
	void OnTheaterMode(VARIANT_BOOL);
	void WindowSetResizable(VARIANT_BOOL);
	void WindowSetLeft(long);
	void WindowSetTop(long);
	void WindowSetWidth(long);
	void WindowSetHeight(long);
	void WindowClosing(VARIANT_BOOL, VARIANT_BOOL*);
	void ClientToHostWindow(long*, long*);
	void SetSecureLockIcon(long);
	void FileDownload(VARIANT_BOOL*);
}
