#!/bin/bash
#
# Copyright (C) 2015 popowiki project
#
# ----------------------------------------
#  execute chmod for PopoWiki DATA_HOME
# ----------------------------------------
#
#  usage
#   (1) Linux
#     chmod u+xr tools/popo_web_chmod_777.bash
#     cd web
#     ../tools/popo_web_chmod_777.bash
#   (2) Linux or Other
#     bash  ../tools/popo_web_chmod_777.bash
#
## Debian  : /bin/bash 
## FreeBSD : /usr/local/bin/bash 
## Cygwin  : /bin/bash , /usr/bin/bash
#


list_1=("backup" "diff" "wiki")
list_2=("attach" "cache" "counter")
list_3=("lib" "plugin" "settings" "nbproject")
list_4=("doc" "image" "image/face" "licenses" "skin" "trackback")

echo Current folder is
echo " $PWD"

# check dir
for v in ${list_1[@]}; do
   if ! [ -d "$v" ]; then
      echo 'ERROR: Not DATA_HOME'
      exit 1
   fi
done

# 777
for v in ${list_1[@]} ${list_2[@]}; do
   if [ -d "$v" ]; then
      chmod 777 $v

      case "$v" in
        attach ) find "$v" -type f -name '*.log' -exec chmod 666 {} \;
                 find "$v" -type f -name '[^.]*[_-]*' -exec chmod 666 {} \;
        ;;
        backup ) find "$v" -type f \( -name '*.txt' -or -name '*.gz' \) -exec chmod 666 {} \;
        ;;
        cache  ) find "$v" -type f \( -name '*.dat' -or -name '*.re[fl]' -or -name '*.lock' \) -exec chmod 666 {} \;
        ;;
        *      ) find "$v" -type f -name '*.txt' -exec chmod 666 {} \;
        ;;
      esac

      find $v -type f \( -name '.*' -or -name '*.html' -or -name '*.htm' \) -exec chmod 644 {} \;
   fi
done

# 755
for v in ${list_3[@]} ${list_4[@]}; do
   if [ -d "$v" ]; then
      chmod 755 $v
      find $v -type f -exec chmod 644 {} \;
   fi
done

find . -maxdepth 1 -type f \
   \(    -name '.ht*'  \
     -or -name '*.txt' \
     -or -name '*.php' \
     -or -iregex '.*\.html?$' \
   \) \
  -exec chmod 644 {} \;


echo finished.


###
## -regextype posix-egrep 
##   FreeBSD : find : -regextype: unknown primary or operator
##    
###

