//
//  SyncPreferences.h
//  GalapagosReader
//
//  Created by Yoshitaka Sakamaki on 平成22/02/09.
//  Copyright 2010 MyHOME. All rights reserved.
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//


#import <Cocoa/Cocoa.h>
#import "Preferences.h"
#import "EditManagerGoogle.h"
#import "EditManagerHatena.h"
#import "RefreshManagerGoogle.h"
#import "AccountManager.h"
#import "Database.h"
#import "LoginControllerGoogle.h"
#import "LoginControllerHatena.h"


@interface SyncPreferences : NSWindowController {
	//GoogleReader
	IBOutlet NSTextField *accountNameGoogle;
	IBOutlet NSSecureTextField *passwordGoogle;
	IBOutlet NSButton *syncGoogleChkBtn;
	
	//HatenaBookMark
	IBOutlet NSTextField *accountNameHatena;
	IBOutlet NSSecureTextField *passwordHatena;
	IBOutlet NSButton *useHatenaChkBtn;
	IBOutlet NSButton *articleSyncChkBtn;
}
//GoogleReader
-(IBAction)changeSyncGoogle:(id)sender;
-(IBAction)syncGoogle:(id)sender;
-(IBAction)textFieldDidEndGoogleAccount:(id)sender;
-(IBAction)textFieldDidEndGooglePassword:(id)sender;

//HatenaBookMark
-(IBAction)syncHatena:(id)sender;
-(IBAction)changeUseHatena:(id)sender;
-(IBAction)textFieldDidEndHatenaAccount:(id)sender;
-(IBAction)textFieldDidEndHatenaPassword:(id)sender;


@end
