//
//  StartUpController.m
//  GalapagosReader
//
//  Created by Yoshitaka Sakamaki on 平成22/02/27.
//  Copyright 2010 MyHOME. All rights reserved.
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//

#import "StartUpController.h"
#import "ProgressWindow.h"

@implementation StartUpController
-(id)init
{
	return [super initWithWindowNibName:@"StartUp"];
}

- (void)showWindow:(id)sender
{
	[super showWindow:sender];
	[NSApp runModalForWindow:[self window]];
}

- (void)windowDidLoad
{
	// まず、Googleアカウントの設定パネルを表示
	[box setContentView:googleView];
}

- (IBAction) syncButtonGoogle:(id)sender
{
	// プログレスバーの表示
	ProgressWindow *progress = [[ProgressWindow alloc] init];
	[progress showWindow:self];

	// パスワード・アカウント名の保存
	AccountManager *accountManager = [AccountManager sharedManager];
	[accountManager changeAccountGoogle:[accountNameGoogle stringValue] 
									   :[passwordGoogle stringValue]];
	
	// 同期フラグをONにする
	[[Database sharedDatabase] updateSyncFlagGoogleInfo:MA_Google_SYNC];

	//LoginControllerGoogleへアカウント情報変更を通知
	[[NSNotificationCenter defaultCenter] postNotificationName:@"MA_Notify_ChangeAccountGoogle" object:nil];

	// ログイン
	BOOL loginSuccess = [[LoginControllerGoogle sharedManager] loginGoogle];
	if (YES == loginSuccess)
	{
		// 同期フラグがOFFのFeed(GoogleReaderと同期していない購読リスト)をすべてONにし、GoogleReaderへ通知。
		[[Database sharedDatabase] updateSyncFlagGoogleRssFolders];
		
		// 購読リストの同期
		[[RefreshManagerGoogle sharedManager] syncFoldersAndFeedURLs];
				
	} else {
		//同期フラグをOFFにする。
		[[Database sharedDatabase] updateSyncFlagGoogleInfo:MA_Google_NOT_SYNC];
	}
	
	// 「戻る」ボタンを表示
	[previousButton setHidden:NO];

	// プログレスバーを閉じる
	[progress close];
	[progress release];
	
	// はてなブックマークのアカウント設定パネルを表示
	[box setContentView:hatenaView];
	[[self window] makeFirstResponder:accountNameHatena];
	
	[self setKeyView];
}

- (IBAction) skipButtonGoogle:(id)sender
{
	// 「戻る」ボタンを表示
	[previousButton setHidden:NO];

	// 戻るボタンのnextKeyViewをskipButtonHatenaに設定
	[previousButton setNextKeyView:[skipButtonHatena nextKeyView]];

	// はてなブックマークのアカウント設定パネルを表示
	[box setContentView:hatenaView];
	[[self window] makeFirstResponder:accountNameHatena];
	
	[self setKeyView];
}

- (IBAction) syncButtonHatena:(id)sender
{
	// プログレスバーの表示
	ProgressWindow *progress = [[ProgressWindow alloc] init];
	[progress showWindow:self];
	
	EditManagerHatena *edit = [EditManagerHatena sharedManager];
	LoginControllerHatena *loginControllerHatena = [LoginControllerHatena sharedManager];
	AccountManager *accountManager = [AccountManager sharedManager];
	
	// パスワード・アカウント名の保存
	[accountManager changeAccountHatena:[accountNameHatena stringValue] 
									   :[passwordHatena stringValue]];
	
	// 同期フラグをONにする
	[[Database sharedDatabase] updateUseFlagHatenaInfo:MA_Hatena_USE];
	
	// EditManagerHatenaにUSEフラグ変更を通知
	[[NSNotificationCenter defaultCenter] postNotificationName:@"MA_Notify_UseFlagUpdate_Info" object:nil];

	// LoginControllerHatenaにアカウント情報が変更されたことを通知する。
	[[NSNotificationCenter defaultCenter] postNotificationName:@"MA_Notify_ChangeAccountHatena" object:nil];

	
	/* ログインが成功したら、ブックマークリストをDBに展開する。
	 *  (記事とブックマークのリンクは行わない)
	 */
	BOOL loginSuccess = [loginControllerHatena loginHatena];
	if (YES == loginSuccess)
		[edit syncBookmark:MA_Sync_AllRecord :NO];
	else
		[[Database sharedDatabase] updateUseFlagHatenaInfo:MA_Hatena_NOT_USE];


	//EditManagerHatenaにフラグ変更を通知
	[[NSNotificationCenter defaultCenter] postNotificationName:@"MA_Notify_UseFlagUpdate_Info" object:nil];

	// プログレスバーを閉じる
	[progress close];
	[progress release];
	
	// チュートリアルパネルを表示
	[box setContentView:tutorialView];
	[[self window] makeFirstResponder:showTutorialButton];
	
	[self setKeyView];
}

- (IBAction) exitStartUp:(id)sender
{
	[self close];
	[NSApp abortModal];
}

- (IBAction) skipButtonHatena:(id)sender
{
	// チュートリアルパネルを表示
	[box setContentView:tutorialView];
	[[self window] makeFirstResponder:showTutorialButton];
	[self setKeyView];
}

- (IBAction) skipButtonTutorial:(id)sender
{
	[self close];
	[NSApp abortModal];
}

- (IBAction) previousWindow:(id)sender
{
	if ([[box contentView] isEqualTo:hatenaView])
	{
		// 「戻る」ボタンを非表示
		[previousButton setHidden:YES];
		
		// Googleアカウントの設定パネルを表示
		[box setContentView:googleView];
		[[self window] makeFirstResponder:accountNameGoogle];		
	} else {
		// Hatenaアカウントの設定パネルを表示
		[box setContentView:hatenaView];
		[[self window] makeFirstResponder:accountNameHatena];		
	}
	
	[self setKeyView];
}

/* keyDown
 * ボタン上にフォーカスを合わせてキーダウンすると対象の処理を行うようにしている。
 */
- (void)keyDown:(NSEvent *)theEvent
{
	unichar unicodeKey;
	unicodeKey = [ [ theEvent characters ] characterAtIndex:0 ];
	switch (unicodeKey) {
		case NSCarriageReturnCharacter:
		case NSEnterCharacter:
			if ([[self window] firstResponder] == acceptButtonGoogle) {
				[self syncButtonGoogle:self];
			} else if ([[self window] firstResponder] == acceptButtonHatena) {
				[self syncButtonHatena:self];
			} else if ([[self window] firstResponder] == skipButtonGoogle) {
				[self skipButtonGoogle:self];
			} else if ([[self window] firstResponder] == skipButtonHatena) {
				[self skipButtonHatena:self];
			} else if ([[self window] firstResponder] == previousButton) {
				[self previousWindow:self];
			} else if ([[self window] firstResponder] == exitStartUpButton) {
				[self exitStartUp:self];
			} else {
				[super keyDown:theEvent];
			}

			return;
		default:
			[super keyDown:theEvent];
			return;
	}
}

- (void)setKeyView
{
	if ([[box contentView] isEqualTo:hatenaView])
	{
		[showHatenaAccountButton setNextKeyView:previousButton];
		[previousButton setNextKeyView:skipButtonHatena];
		
	} else if ([[box contentView] isEqualTo:tutorialView]){
		[showTutorialButton setNextKeyView:previousButton];
		[previousButton setNextKeyView:exitStartUpButton];
	}
}

-(void)dealloc
{
	[super dealloc];
}
@end
