//
//  LoginControllerHatena.m
//  GalapagosReader
//
//  Created by Yoshitaka Sakamaki on 平成22/02/27.
//  Copyright 2010 MyHOME. All rights reserved.
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//

#import "LoginControllerHatena.h"


typedef enum {
	MA_LoginRetry = 0,
	MA_Login_NO_Retry
} RetryState;

static LoginControllerHatena *_loginController = nil;
static RetryState retryState;
BOOL changeAccount;
@implementation LoginControllerHatena
-(id)init
{
	//起動時は強制的にログイン処理をさせたいので、YESにしている。
	changeAccount = YES;

	//アカウント情報が変更された際に呼び出される。（AccountManagerから）
	NSNotificationCenter * nc = [NSNotificationCenter defaultCenter];
	[nc addObserver:self selector:@selector(handleChangeAccountHatena:) name:@"MA_Notify_ChangeAccountHatena" object:nil];

	return [super initWithWindowNibName:@"EditAccountHatena"];
}

-(void)windowDidLoad
{
	// アカウント名をテキストフィールドに設定。
	AccountManager *accountManager = [AccountManager sharedManager];
	if ( NO == [[accountManager getAccountNameHatena] isEqualToString:@""])
		[accountNameHatena setStringValue:[accountManager getAccountNameHatena]];
	
	// パスワードをキーチェーンから取得し、テキストフィールドに設定。
	if (NO == [[accountManager getPasswordHatena] isEqualToString:@""])
		[passwordHatena setStringValue:[accountManager getPasswordHatena]];
}

+(LoginControllerHatena *)sharedManager
{
	if (!_loginController)
		_loginController = [[LoginControllerHatena alloc] init];
	//状態をリセット
	retryState = MA_LoginRetry;
	return _loginController;
}

-(BOOL) loginHatena
{
	if (NO == [[Database sharedDatabase] useFlagHatenaInfo])
		return NO;
	
	//アカウント情報が変更されていなければログインの必要がないので、処理を終了する。
	if (NO == changeAccount)
		return YES;
	 
	HttpResult ret = Ret_403NG;
	do {
		//ログイン
		ret = [[EditManagerHatena sharedManager] login];
		if (Ret_200OK == ret)
			break;

		//ネットワーク障害
		if (RetNG == ret) {
			break;
		}
		
		/* 認証失敗→ログイン画面再表示までの動作が早すぎてボタンを押したかどうか
		 * わからなくなる時があるので、２秒sleepさせる。
		 */
		sleep(2);
		
		// アカウント情報の再入力画面表示
		[self setShouldCascadeWindows:NO];
		[[self window] makeKeyAndOrderFront:self];
		[NSApp runModalForWindow:[self window]];							
	} while (Ret_403NG == ret && MA_LoginRetry == retryState);
	
	if (Ret_200OK == ret)
	{
		//有効なアカウントでログイン出来たので、アカウントの状態をリセットする。
		changeAccount = NO;
		return YES;
		
	} else {
		return NO;
	}
}

-(IBAction)acceptLogin:(id)sender
{
	
	// パスワード・アカウント名の保存
	AccountManager *accountManager = [AccountManager sharedManager];
	[accountManager changeAccountHatena:[accountNameHatena stringValue] 
									   :[passwordHatena stringValue]];
	
	// 環境設定パネルのフィールドに変更した情報を反映させる。
	[[NSNotificationCenter defaultCenter] postNotificationName:@"MA_Notify_AccountFieldRefresh" object:nil];

	/*
	//infoテーブルの同期フラグをONにする。
	[[Database sharedDatabase] updateUseFlagHatenaInfo:MA_Hatena_USE];
	*/
	
	[self close];
	[NSApp abortModal];
}

-(IBAction)cancelHatenaLogin:(id)sender
{
	// 環境設定パネルのフィールドに変更した情報を反映させる。
	[[NSNotificationCenter defaultCenter] postNotificationName:@"MA_Notify_AccountFieldRefresh" object:nil];

	retryState = MA_Login_NO_Retry;
	[self close];
	[NSApp abortModal];
}

-(IBAction)textFieldDidEndHatenaAccount:(id)sender
{
	// パスワード・アカウント名の保存
	AccountManager *accountManager = [AccountManager sharedManager];
	[accountManager changeAccountHatena:[accountNameHatena stringValue] 
									   :[passwordHatena stringValue]];
}

-(IBAction)textFieldDidEndHatenaPassword:(id)sender
{
	// パスワード・アカウント名の保存
	AccountManager *accountManager = [AccountManager sharedManager];
	[accountManager changeAccountHatena:[accountNameHatena stringValue] 
									   :[passwordHatena stringValue]];
}

-(void)handleChangeAccountHatena:(NSNotification *)nc
{
		changeAccount = YES;
}

-(BOOL)changeAccount
{
	return changeAccount;
}
@end
