//
//  EditManagerGoogle.m
//  GalapagosReader
//
//  Created by Yoshitaka Sakamaki on 平成22/02/21.
//  Copyright 2010 MyHOME. All rights reserved.
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//

#import "EditManagerGoogle.h"

#define UN_READ_ELEMENT_COUNT 3
#define SEND_UNREAD_COUNT_MAX 10
#define TOKEN_REFRESH_INTERVAL 300.0

NSString * MA_StarItem_String = @"star:";

// Singleton
static EditManagerGoogle * _editManager = nil;
static NSString * token = nil;
static NSString * auth = nil;
static NSURLRequest * sendRequest = nil;

@interface EditManagerGoogle (Private) 
- (void)handleSyncFlagUpdate:(NSNotification *)nc;
- (void)setToken;
@end


@implementation EditManagerGoogle
NSString * LoginURL = @"https://www.google.com/accounts/ClientLogin";
NSString * TokenURL = @"http://www.google.com/reader/api/0/token?client=GalapagosReader";
NSString * SubscriptionURL = @"http://www.google.com/reader/api/0/subscription/list?output=xml";
NSString * UnReadCountURL = @"http://www.google.com/reader/api/0/unread-count?output=xml";
NSString * EditSubscriptionURL = @"http://www.google.com/reader/api/0/subscription/edit?client=GalapagosReader";
NSString * EditFlagURL = @"http://www.google.com/reader/api/0/edit-tag?client=GalapagosReader";
NSString * StarListURL = @"http://www.google.com/"
                         @"reader/api/0/stream/items/ids?"
                         @"s=user/-/state/com.google/starred&n=10000";
NSString * StarItemURL = @"http://www.google.com"
                         @"/reader/atom/user/-/state/com.google/starred?n=10000";
NSString * UnReadFeedURL = @"http://www.google.com/reader/atom/%@?n=%d&ot=518400000";
NSString * ReadItemListURL = @"http://www.google.com"
                             @"/reader/api/0/stream/items/ids?s=user/-/state/com.google/read&n=10000&ot=%@";
NSString * GetReadItemURL = @"http://www.google.com"
                            @"/reader/api/0/stream/items/contents?output=atom";

-(id)init
{
	if ((self = [super init]) != nil)
	{
		NSNotificationCenter * nc = [NSNotificationCenter defaultCenter];
		[nc addObserver:self selector:@selector(handleSyncFlagUpdate:) name:@"MA_Notify_SyncFlagUpdate_Info" object:nil];
		// infoテーブルから同期フラグを取得・設定。
		syncFlagGoogleInfo = [[Database sharedDatabase] syncFlagGoogleInfo];
		
		// タイマの設定。5分置きにトークンをリフレッシュする。
		tokenRefreshTimer = [NSTimer scheduledTimerWithTimeInterval:TOKEN_REFRESH_INTERVAL
															 target:self
														   selector:@selector(setToken)
														   userInfo:nil
															repeats:YES];
	}
	return self;
}

/* sharedManager
 * Returns the single instance of the refresh manager.
 */
+(EditManagerGoogle *)sharedManager
{
	if (!_editManager)
		_editManager = [[EditManagerGoogle alloc] init];
	return _editManager;
}

- (HttpResult)chkStatusCode:(NSHTTPURLResponse*)httpResponse
{
	HttpResult ret = RetNG;
	if ([httpResponse statusCode] == 200)
	{
		ret = Ret_200OK;
	} else if ([httpResponse statusCode] == 400){
		// トークンが期限切れになった。
		[self setToken];
		ret = Ret_400NG;
	} else if ([httpResponse statusCode] == 403){
		// 認証エラー
		ret = Ret_403NG;
	} else {
		ret = RetNG;
	}			
	return ret;
}

/*
 * GoogleReaderへのログイン及び、SID取得設定。
 */
- (HttpResult)login
{
	//NSString *delimiter = @"LSID=";
	NSString *delimiter = @"Auth=";
	// アカウント名とパスワードの設定。
	NSString *email = [[AccountManager sharedManager] getAccountNameGoogle];
	NSString *password = [[AccountManager sharedManager] getPasswordGoogle];	
	NSString* body = [NSString
					  stringWithFormat:
					  @"Email=%@&Passwd=%@&service=reader&source=%@"
					  ,email,password,@"GalapagosReader"];
	
	NSURL* url = [NSURL URLWithString:LoginURL];
	NSData* reciveData;
	
	HttpResult ret;
	ret = [self httpRequest:@"POST" 
						url:url
				 reciveData:&reciveData
					   body:body];
	
	if (Ret_403NG == ret)
	{
		return Ret_403NG;
	} else if (RetNG == ret) {
		return RetNG;
	}
	
	//pick out the "Auth"
	NSString *reciveStringSid = [[NSString alloc] initWithData:reciveData encoding:NSASCIIStringEncoding];
	NSArray *tempArray = [reciveStringSid componentsSeparatedByString:delimiter];
	NSString *tempAuth = [tempArray objectAtIndex:1];
	auth = [[NSString alloc] initWithString:
			[NSString stringWithFormat:@"GoogleLogin auth=%@", [tempAuth substringToIndex:[tempAuth length]-1]]];

	[reciveStringSid release];
	[self setToken];
	
	return Ret_200OK;
}

/*
 * 期限付きトークンの取得設定。
 */
- (void)setToken
{
	if ( NO == syncFlagGoogleInfo)
		return;

	if (token)
		[token release];
	
	NSDictionary *header = [self createHttpHeader];
	NSURL* url = [NSURL URLWithString:TokenURL];
	
	NSData* reciveData;
	HttpResult ret = [self httpRequest:@"GET"
								   url:url
							reciveData:&reciveData
								header:header
					  ];
	
	if(Ret_200OK != ret)
	{
		token = nil;
		return;
	}
	
	token = [[[NSString alloc] initWithData:reciveData encoding:NSUTF8StringEncoding] retain];
	return;
}

/*
 * 現在購読しているFeedリストの取得
 */
- (NSArray*)getFeedList
{
	NSDictionary *header = [self createHttpHeader];
	NSURL* url = [NSURL URLWithString:SubscriptionURL];
	
	NSData* reciveData;
	HttpResult ret = [self httpRequest:@"GET"
								   url:url 
							reciveData:&reciveData
								header:header
					  ];
	
	if(Ret_200OK != ret)
	{
		return nil;
	}
	
	NSMutableArray *result = [NSMutableArray array];
	
	DDXMLDocument *doc = [[[DDXMLDocument alloc] initWithData:reciveData
													  options:0 error:nil] autorelease];
    DDXMLElement *root = [doc rootElement];
	
	/* TODO:FeedListの件数を取得したいんだけど、xpathで"//object/list[1]"を指定すると件数＋１
	 * となってしまう。＋１がどんなのかは以下のログ有効化するとわかる。
	 */
	//NSArray *feedListCount = [root nodesForXPath:@"//object/list/object" error:nil];
	NSArray *feedListCount = [root nodesForXPath:@"//object/list[1]" error:nil];
	//NSLog(@"%@", feedListCount);
	
	int offset = 1;
	int i=0;
	for (;i<[feedListCount count]-1;i++)
	{
		/* TODO:そのうち、１件分のデータをまとめて取得したい。
		 * 暫定的に、個別指定して取得している。
		 */
		NSMutableDictionary *dictList = [[[NSMutableDictionary alloc] init] autorelease];
		
		//id
		NSArray *feedListGoogle = [root nodesForXPath:[NSString stringWithFormat:@"//object[1]/list[1]/object[%d]/string[1]", i+offset] error:nil];
		//[dictList setObject:[[feedListGoogle objectAtIndex:0] stringValue] forKey:@"id"];
		
		NSMutableString *tempFeedId = [[[NSMutableString alloc] initWithString:
										[[feedListGoogle objectAtIndex:0]stringValue]
										] autorelease];
		[tempFeedId deleteCharactersInRange:NSMakeRange(0,5)];// cut string "feed/"
		[dictList setObject:[NSString stringWithString:tempFeedId] forKey:@"id"];
		
		//title
		feedListGoogle = [root nodesForXPath:[NSString stringWithFormat:@"//object[1]/list[1]/object[%d]/string[2]", i+offset] error:nil];
		[dictList setObject:[[feedListGoogle objectAtIndex:0] stringValue] forKey:@"title"];
		
		//sortid
		feedListGoogle = [root nodesForXPath:[NSString stringWithFormat:@"//object[1]/list[1]/object[%d]/string[3]", i+offset] error:nil];
		[dictList setObject:[[feedListGoogle objectAtIndex:0] stringValue] forKey:@"sortid"];
		
		//firstitemmsec
		feedListGoogle = [root nodesForXPath:[NSString stringWithFormat:@"//object[1]/list[1]/object[%d]/number", i+offset] error:nil];
		[dictList setObject:[[feedListGoogle objectAtIndex:0] stringValue] forKey:@"firstitemmsec"];
		
		
		/* categories_id, label は値が無いこともありえる。
		 */
		//categories_id
		feedListGoogle = [root nodesForXPath:[NSString stringWithFormat:@"//object[1]/list[1]/object[%d]/list[1]/object[1]/string[1]", i+offset] error:nil];
		
		if (0 != [feedListGoogle count])
		{
			[dictList setObject:[[feedListGoogle objectAtIndex:0] stringValue] forKey:@"categories_id"];
		}
		
		//label
		feedListGoogle = [root nodesForXPath:[NSString stringWithFormat:@"//object[1]/list[1]/object[%d]/list[1]/object[1]/string[2]", i+offset] error:nil];
		
		if (0 != [feedListGoogle count])
		{
			[dictList setObject:[[feedListGoogle objectAtIndex:0] stringValue] forKey:@"label"];
		}
		
		[result addObject:dictList];
		
	}
	return result;
}

/*
 *未読記事リストの取得
 */
- (NSArray *)getUnReadCount
{
	NSDictionary *header = [self createHttpHeader];
	//未読記事カウントをxmlで取得
	NSURL* url = [NSURL URLWithString:UnReadCountURL];
	
	NSData* reciveData;
	HttpResult ret = [self httpRequest:@"GET"
								   url:url
							reciveData:&reciveData
								header:header
					  ];
	
	if(Ret_200OK != ret)
	{
		return nil;
	}
	
	DDXMLDocument *doc = [[[DDXMLDocument alloc] initWithData:reciveData
													  options:0 error:nil] autorelease];
    DDXMLElement *root = [doc rootElement];
	
	NSArray *listCount = [root nodesForXPath:@"//object/list/object/*" error:nil];	
	NSArray *feed_id = [root nodesForXPath:@"//object/list/object/string" error:nil];
	NSArray *unReadCount = [root nodesForXPath:@"//object/list/object/number[1]" error:nil];
	NSArray *newestItemTimestampUsec = [root nodesForXPath:@"//object/list/object/number[2]" error:nil];
	
	NSMutableArray *result = [NSMutableArray array];
	int recordCount = 0;
	for (; recordCount < [listCount count]/UN_READ_ELEMENT_COUNT; recordCount++)
	{
		
		// 先頭に"user/"がついたアイテムはディレクトリそのものなので、データとしては不要。
		if ([[[feed_id objectAtIndex:recordCount] stringValue] hasPrefix:@"user/"])
		{
			continue;
		}
		
		NSMutableDictionary *dictList = [[[NSMutableDictionary alloc] init] autorelease];
		
		[dictList setObject:[[feed_id objectAtIndex:recordCount] stringValue] forKey:@"id"];
		[dictList setObject:[[unReadCount objectAtIndex:recordCount] stringValue] forKey:@"count"];
		[dictList setObject:[[newestItemTimestampUsec objectAtIndex:recordCount] stringValue] forKey:@"newestItemTimestampUsec"];
		[result addObject:dictList];
	}
	return result;
}

/*
 * HTTPヘッダーの生成
 */
- (NSDictionary *) createHttpHeader
{
	if (httpHeader)
		return httpHeader;
	
	httpHeader = [[NSDictionary dictionaryWithObjectsAndKeys:
			  @"www.google.com", @"Host",
			  @"GalapagosReader", @"User-Agent",
			  @"gzip, deflate", @"Accept-Encoding",
			  auth, @"Authorization",
			  nil
			  ] retain];
	return httpHeader;
}

/*
 * 記事の購読をGoogleReaderへ通知する。
 */
- (void) subscribedFeed:(NSString *)title
					   :(NSString *)feedURL
					   :(NSString *)label
{
	if ( NO == syncFlagGoogleInfo)
		return;
	
	NSDictionary * header = [self createHttpHeader];
	NSURL *url = [NSURL URLWithString:EditSubscriptionURL];
	NSString *body;
	if (nil == label)
	{
		body = [NSString stringWithFormat:
				@"ac=subscribe&t=%@&T=%@&s=feed/%@",
				title,
				token,
				feedURL
				];
		
	} else {
		body = [NSString stringWithFormat:
				@"ac=subscribe&t=%@&T=%@&a=user/-/label/%@&s=feed/%@",
				title,
				token,
				label,
				feedURL
				];
	}
	
	NSData* result;
	[self httpRequest:@"POST"
				  url:url 
		   reciveData:&result
			   header:header
				 body:body
	 ];
	
	return;
}

/*
 * 記事の購読解除をGoogleReaderへ通知する。
 */
- (void) unSubscribedFeed:(NSString *)feedURL
{
	if ( NO == syncFlagGoogleInfo)
		return;
	
	NSDictionary * header = [self createHttpHeader];
	NSURL *url = [NSURL URLWithString:EditSubscriptionURL];
	
	
	NSData* result;
	NSString *body = [NSString stringWithFormat:
					  @"ac=unsubscribe&T=%@&s=feed/%@",
					  token,
					  feedURL
					  ];
	
	[self httpRequest:@"POST"
				  url:url 
		   reciveData:&result
			   header:header
				 body:body
	 ];	
	
	return;
}

/*
 * 既読・未読をGoogleReaderに通知する。
 */
- (void) notifyMarkArticleRead:(NSString *)theGuid
							  :(NSString *)feedURL
							  :(BOOL)isRead
{
	if ( NO == syncFlagGoogleInfo)
		return;
	
	if (YES == [theGuid hasPrefix:@"star:"])
		return;
	
	NSDictionary * header = [self createHttpHeader];
	NSURL *url = [NSURL URLWithString:EditFlagURL];
	NSString *body;
	if (isRead)
	{
		body = [NSString stringWithFormat:
				@"ac=edit-tags&async=true&i=tag:google.com,2005:reader/item/%@&T=%@&a=user/-/state/com.google/read&s=feed/%@",
				theGuid,
				token,
				feedURL
				];
	} else {
		body = [NSString stringWithFormat:
				@"ac=edit-tags&async=true&i=tag:google.com,2005:reader/item/%@&T=%@&r=user/-/state/com.google/read&s=feed/%@",
				theGuid,
				token,
				feedURL
				];
	}
	
	[self httpRequestNotSync:@"POST"
						 url:url
					  header:header
						body:body
						 uid:self];
}

/*
 * folderId配下の未読記事を既読にする。
 */
- (void) notifyMarkArticleReadALL:(Folder *) _folder;
{
	if ( NO == syncFlagGoogleInfo)
		return;
	
	NSDictionary * header = [self createHttpHeader];
	NSURL *url = [NSURL URLWithString:EditFlagURL];
	NSString * aFeedURL = [_folder feedURL];
	NSArray *articlesArray = [_folder articles];
	
	NSMutableString *body = [[NSMutableString alloc] init];
	NSMutableString *guids = [[NSMutableString alloc] init];
	NSMutableString *feedURLs = [[NSMutableString alloc] init];
	
	[body setString:@"ac=edit-tags&async=true"];
	int count = 0;
	//NSData* result;
	// 10件づつ通知する
	for (Article *article in articlesArray)
	{
		//スター記事は処理終了
		if (YES == [[article guid] hasPrefix:@"star:"])
			continue;
		
		//既読記事ではない？
		if (YES == [article isRead])
			continue;
		
		//既読にする。
		[article markRead:YES];
		
		[guids appendString:[NSString stringWithFormat:@"&i=tag:google.com,2005:reader/item/%@", [article guid]]];
		[feedURLs appendString:[NSString stringWithFormat:@"&s=feed/%@", aFeedURL]];
		
		if (++count != SEND_UNREAD_COUNT_MAX)
			continue;
		
		count = 0;
		
		[body appendString:guids];
		[body appendString:[NSString stringWithFormat:@"&T=%@", token]];
		[body appendString:@"&a=user/-/state/com.google/read"];
		[body appendString:feedURLs];
		
		[self httpRequestNotSync:@"POST"
							 url:url
						  header:header
							body:body
							 uid:self];		
		
		[body setString:@"ac=edit-tags&async=true"];
		[guids setString:@""];
		[feedURLs setString:@""];
	}
	
	//端数を通知する
	if (NO == [guids isEqualToString:@""])
	{
		[body appendString:guids];
		[body appendString:[NSString stringWithFormat:@"&T=%@", token]];
		[body appendString:[NSString stringWithFormat:@"&a=user/-/state/com.google/read"]];
		[body appendString:feedURLs];
		
		[self httpRequestNotSync:@"POST"
							 url:url
						  header:header
							body:body
							 uid:self];				
		
	}
	[body release];
	[guids release];
	[feedURLs release];
	
}

/*
 * スターの付与・解除を通知する。
 */
- (void) notifyStarFlag:(NSString *)theGuid
					   :(NSString *)feedURL
					   :(BOOL)isStarAdd
{
	if (NO == syncFlagGoogleInfo)
		return;
		
	NSMutableString * tag = [NSMutableString string];
	if (YES == [theGuid hasPrefix:MA_StarItem_String])
	{
		//"star:"を切り離す。
		[tag setString:[theGuid substringWithRange:NSMakeRange([MA_StarItem_String length],
															  [theGuid length]-[MA_StarItem_String length])]];
	} else {
		[tag setString:theGuid];
	}
	
	
	NSDictionary * header = [self createHttpHeader];
	NSURL *url = [NSURL URLWithString:
				  EditFlagURL];
	
	NSString *body;
	if (isStarAdd)
	{
		body = [NSString stringWithFormat:
				@"ac=edit-tags&async=true&i=tag:google.com,2005:reader/item/%@&T=%@&a=user/-/state/com.google/starred&s=feed/%@",
				tag,
				token,
				feedURL
				];
	} else {
		body = [NSString stringWithFormat:
				@"ac=edit-tags&async=true&i=tag:google.com,2005:reader/item/%@&r=user/-/state/com.google/starred&T=%@&s=feed/%@",
				tag,
				token,
				feedURL
				];
	}
	
	NSData* result;
	[self httpRequest:@"POST"
				  url:url 
		   reciveData:&result
			   header:header
				 body:body
	 ];
	
	return;
	
}

/* handleSyncFlagUpdate
 * infoテーブルの同期フラグに変更があれば、DBから取得し直します。
 */
-(void)handleSyncFlagUpdate:(NSNotification *)nc
{
	syncFlagGoogleInfo = [[Database sharedDatabase] syncFlagGoogleInfo];
}

// 接続が要求に対する URL 応答を構築するのに十分なデータを受けとったとき、送られます。（既読・未読処理用）
-(void)connection:(NSURLConnection *)connection didReceiveResponse:(NSURLResponse *)response
{
	if ([response isKindOfClass:[NSHTTPURLResponse class]])
	{
		NSHTTPURLResponse * httpResponse = (NSHTTPURLResponse *)response;
		
		// Get the HTTP response code and handle appropriately:
		// Code 400 はトークンの期限が切れたことを意味します。
		if ([httpResponse statusCode] == 400)
		{
			[connection cancel];
			
			[self setToken];
			
			// トークンを入れ替えて再送信
			NSURL *url = [NSURL URLWithString:
						  EditFlagURL];
			NSString * tempBody = [[[NSString alloc] initWithData:[sendRequest HTTPBody]
														encoding:NSASCIIStringEncoding] autorelease];
			
			NSRange startRange = [tempBody rangeOfString:@"&T=" options:NSCaseInsensitiveSearch];
			NSRange endRange = [tempBody rangeOfString:@"&a=" options:NSCaseInsensitiveSearch];
			if (endRange.location == NSNotFound)
			{
				endRange = [tempBody rangeOfString:@"&r=" options:NSCaseInsensitiveSearch];
			}
			
			if (startRange.location != NSNotFound && endRange.location != NSNotFound)
			{
				NSString * body = [tempBody stringByReplacingOccurrencesOfString:
								   [tempBody substringWithRange:
									NSMakeRange(startRange.location+3, endRange.location-startRange.location-3)]
																	  withString:token];
				
				[self httpRequestNotSync:@"POST"
									 url:url
								  header:[sendRequest allHTTPHeaderFields]
									body:body
									 uid:self];				
			}
		}
		else if ([httpResponse statusCode] != 200)
		{
			//TODO:レスポンスをダイアログで表示かな。
			//TODO:再度送信するようにしたい。

			[connection cancel];						
		}
	}
}

/*
 * リクエスト送信前に呼ばれる
 */
- (NSURLRequest *)connection:(NSURLConnection *)connection willSendRequest:(NSURLRequest *)request redirectResponse:(NSURLResponse *)response
{
	//リクエストを保持
	sendRequest = request;
	return request;
}

/*
 * ネットワーク障害時に呼び出されるデリゲートメソッド。
 */
- (void)connection:(NSURLConnection *)connection didFailWithError:(NSError *)error
{
	//TODO:ネットワーク接続が再開したら、失敗リクエストを再度送信したい。
	[connection release];
}

/*
 * 通信終了時に呼び出されるデリゲートメソッド。（コネクションをクローズする）
 */
- (void)connectionDidFinishLoading:(NSURLConnection *)connection
{
	[connection release];
}

/*
 * 最終更新時刻以降の既読記事を取得(最大10000件)し、IDのリストを返却する
 */
- (NSArray*)getReadItemList:(NSData*)readItemList
{
	NSMutableArray *result = [NSMutableArray array];
	
	DDXMLDocument *doc = [[[DDXMLDocument alloc] initWithData:readItemList
													  options:0 error:nil] autorelease];
    DDXMLElement *root = [doc rootElement];
	
	NSArray *feedListCount = [root nodesForXPath:@"//object[1]/list[1]/object" error:nil];
	//NSLog(@"%d", [feedListCount count]);
	
	int offset = 1;
	int i=0;
	for (;i<[feedListCount count];i++)
	{
		
		NSMutableDictionary *dict = [[[NSMutableDictionary alloc] init] autorelease]; 

		// id
		NSArray *feedListId = [root nodesForXPath:[NSString stringWithFormat:@"//object[1]/list[1]/object[%d]/number[1]", i+offset] error:nil];
		NSMutableString *tempFeedId = [NSMutableString stringWithFormat:@"%@", 
									   [[feedListId objectAtIndex:0] stringValue]];
		//符号なし64ビット整数 (unsigned long long), 16進数[0-9a-f]として表示。（a-fは小文字）
		[dict setObject:[NSString stringWithFormat:@"%016qx", [tempFeedId longLongValue]]
				 forKey:@"id"];

		// directStreamIds
		NSArray *feedListDSI = [root nodesForXPath:[NSString stringWithFormat:@"//object[1]/list[1]/object[%d]/list[1]/string[1]", i+offset] error:nil];		
		[dict setObject:[[feedListDSI objectAtIndex:0] stringValue] forKey:@"directStreamIds"];
		[result addObject:dict];
		
		//NSLog(@"%@", [root nodesForXPath:[NSString stringWithFormat:@"//object[1]/list[1]/object[%d]/list[1]/string[1]", i+offset] error:nil]);
		//NSLog(@"%@", [NSString stringWithFormat:@"%016qx", [[feedListId objectAtIndex:0] longLongValue]]);
		//NSLog(@"%@", [NSString stringWithFormat:@"%016qx", [tempFeedId longLongValue]]);
	}
	return result;
}

-(NSURL*)getStarListURL
{
	return [NSURL URLWithString:StarListURL];	
}

-(NSURL*)getStarItemURL
{
	return [NSURL URLWithString:StarItemURL];
}

-(NSURL*)getUnreadFeedURL:(NSString*)guid :(int)unReadCount
{
	return [NSURL URLWithString:[NSString stringWithFormat:
								 UnReadFeedURL
								 ,guid
								 ,unReadCount]];	
}
-(NSURL*)getReadItemListURL
{
	/*
	 return [NSURL URLWithString:@"http://www.google.com"
	 @"/reader/api/0/stream/items/ids?s=user/-/state/com.google/read&n=10000"];	
	 */
	return [NSURL URLWithString:[NSString stringWithFormat:ReadItemListURL,
								 [[Database sharedDatabase] getLastRefreshDate]]];	
	
}

-(NSURL*)getReadItemURL
{
	return [NSURL URLWithString:GetReadItemURL];
}

-(NSString*)getReadItemBody:(NSString*)body
{
	return [NSString stringWithFormat:@"%@T=%@", body, token];
}
-(void)dealloc
{
	[token release];
	[auth release];
	[super dealloc];
}

@end

