//
//  EditManagerGoogle.h
//  GalapagosReader
//
//  Created by Yoshitaka Sakamaki on 平成22/02/21.
//  Copyright 2010 MyHOME. All rights reserved.
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//

#import <Cocoa/Cocoa.h>
#import "LoginControllerGoogle.h"
#import "EditManagerBase.h"
#import "AccountManager.h"
#import "Database.h"
extern NSString * MA_StarItem_String;


@interface EditManagerGoogle : EditManagerBase {
	NSTimer *tokenRefreshTimer;
	BOOL syncFlagGoogleInfo;
}
+ (EditManagerGoogle *) sharedManager;
- (HttpResult) login;
- (NSArray *) getUnReadCount;
- (NSArray *) getFeedList;
- (NSDictionary *) createHttpHeader;
- (void) subscribedFeed:(NSString *)title
					   :(NSString *)feedURL
					   :(NSString *)label;
- (void) unSubscribedFeed:(NSString *)feedURL;
- (void) notifyMarkArticleRead:(NSString *)theGuid
							  :(NSString *)feedURL
							  :(BOOL)isRead;
- (void) notifyMarkArticleReadALL:(Folder *) _folder;
- (void) notifyStarFlag:(NSString *)theGuid
					   :(NSString *)feedURL
					   :(BOOL)isStarAdd;
- (NSArray*)getReadItemList:(NSData*)readItemList;
- (NSURL*)getStarListURL;
- (NSURL*)getStarItemURL;
- (NSURL*)getUnreadFeedURL:(NSString*)guid :(int)unReadCount;
- (NSURL*)getReadItemURL;
- (NSString*)getReadItemBody:(NSString*)body;
- (NSURL*)getReadItemListURL;



@end
