//
//  EditManagerBase.m
//  GalapagosReader
//
//  Created by Yoshitaka Sakamaki on 平成22/03/07.
//  Copyright 2010 MyHOME. All rights reserved.
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//

#import "EditManagerBase.h"

@implementation EditManagerBase

- (id)init
{
    if ((self = [super init]) != nil) {
		connector = nil;
		httpHeader = nil;
    }
    return self;
}

- (HttpResult)chkStatusCode:(NSHTTPURLResponse*)httpResponse
{
	HttpResult ret = RetNG;
	if ([httpResponse statusCode] == 200)
	{
		ret = Ret_200OK;
	} else if ([httpResponse statusCode] == 201){
		ret = Ret_201OK;
	} else if ([httpResponse statusCode] == 400){
		ret = Ret_400NG;
	} else if ([httpResponse statusCode] == 403){
		// 認証エラー
		ret = Ret_403NG;
	} else if ([httpResponse statusCode] == 500){
		//はてブと通信しているとたまに返してくる
		ret = Ret_500NG;
	} else {
		ret = RetNG;
	}			
	return ret;
}

- (HttpResult)httpRequest:(NSString *)method
					  url:(NSURL *)url
			   reciveData:(NSData **)result
				   header:(NSDictionary *)header
{	
	NSMutableURLRequest* urlRequest = [[NSMutableURLRequest alloc]initWithURL:url];
	[urlRequest setHTTPMethod:method];
	[urlRequest setAllHTTPHeaderFields:header];
	NSURLResponse* response;
	NSError* error;
	HttpResult ret = RetNG;
	int count = 0;
	do {
		*result = [NSURLConnection sendSynchronousRequest:urlRequest
										returningResponse:&response
													error:&error];
		ret = [self chkStatusCode:(NSHTTPURLResponse *)response];
	} while (Ret_200OK != ret && Ret_403NG != ret && ++count < RETRY_COUNT);
	
	[urlRequest release];
	return ret;
}

- (HttpResult)httpRequest:(NSString *)method
					  url:(NSURL *)url
			   reciveData:(NSData **)result
					 body:(NSString *)body
{
	NSMutableURLRequest *urlRequest = [[NSMutableURLRequest alloc]initWithURL:url];
	[urlRequest setHTTPMethod:method];
	[urlRequest setHTTPBody:[[body stringByURLEncoding:NSUTF8StringEncoding] dataUsingEncoding:NSUTF8StringEncoding]];
	NSURLResponse *response;
	NSError *error;
	*result = [NSURLConnection sendSynchronousRequest:urlRequest
									returningResponse:&response
												error:&error];
	
	HttpResult ret = RetNG;
	ret = [self chkStatusCode:(NSHTTPURLResponse *)response];
	
	[urlRequest release];
	return ret;
	
}

- (HttpResult)httpRequest:(NSString *)method
					  url:(NSURL *)url
			   reciveData:(NSData **)result
				   header:(NSDictionary *)header
					 body:(NSString*)body
{
	NSMutableURLRequest* urlRequest = [[NSMutableURLRequest alloc]initWithURL:url];
	[urlRequest setHTTPMethod:method];
	[urlRequest setHTTPBody:[[body stringByURLEncoding:NSUTF8StringEncoding] dataUsingEncoding:NSUTF8StringEncoding]];
	[urlRequest setAllHTTPHeaderFields:header];
	NSURLResponse* response = nil;
	NSError* error = nil;
	
	HttpResult ret = RetNG;
	int count = 0;
	do {
		*result = [NSURLConnection sendSynchronousRequest:urlRequest
										returningResponse:&response
													error:&error];
		
		ret = [self chkStatusCode:(NSHTTPURLResponse *)response];
	} while (Ret_200OK != ret && Ret_403NG != ret && ++count < RETRY_COUNT);
	
	[urlRequest release];
	return ret;
}

- (HttpResult)httpRequest_NonURLEncoding:(NSString *)method
							  url:(NSURL *)url
					   reciveData:(NSData **)result
						   header:(NSDictionary *)header
							 body:(NSString*)body
{
	NSMutableURLRequest* urlRequest = [[NSMutableURLRequest alloc]initWithURL:url];
	[urlRequest setHTTPMethod:method];
	[urlRequest setHTTPBody:[body dataUsingEncoding:NSUTF8StringEncoding]];
	[urlRequest setAllHTTPHeaderFields:header];
	NSURLResponse* response = nil;
	NSError* error = nil;
	
	HttpResult ret = RetNG;
	int count = 0;
	do {
		*result = [NSURLConnection sendSynchronousRequest:urlRequest
										returningResponse:&response
													error:&error];
		
		ret = [self chkStatusCode:(NSHTTPURLResponse *)response];
	} while ((Ret_200OK != ret && Ret_201OK != ret && Ret_403NG != ret) && ++count < RETRY_COUNT);	
	[urlRequest release];
	return ret;
}

- (HttpResult)httpRequest:(NSString *)method
					  url:(NSURL *)url
			   reciveData:(NSData **)result
				 response:(NSURLResponse **)response
{	
	NSMutableURLRequest* urlRequest = [[NSMutableURLRequest alloc]initWithURL:url];
	[urlRequest setHTTPMethod:method];
	NSError* error;
	HttpResult ret = RetNG;
	int count = 0;
	do {
		*result = [NSURLConnection sendSynchronousRequest:urlRequest
										returningResponse:response
													error:&error];
		ret = [self chkStatusCode:(NSHTTPURLResponse *)*response];
	} while (Ret_200OK != ret && Ret_403NG != ret && ++count < RETRY_COUNT);
	
	[urlRequest release];
	return ret;
}

/*
 * Feedのタイトルを購読対象のサーバから直接取得する。
 */
- (NSString *)getFeedTitle:(NSString*)feedURL
{

	NSURL* url = [NSURL URLWithString:feedURL];
	NSData *reciveData = [NSData dataWithContentsOfURL:url];
	
	if (nil == reciveData)
		return @"";//ADとかをブックマークしようとすると、ここにくる。
	
	/* 2010/04/08 注：ネット情報ではoptionsにNSXMLDocumentTidyHTMLを指定した方がいいとあるが、
	 * 改行＆タブ文字titleに入っていると、文字化けを起こす。（youtubeが実際文字化けした）
	 * しかし、htmlを取得しているのにパース出来ない場合があるので、NSXMLDocumentTidyXMLで取得失敗したら、
	 * NSXMLDocumentTidyHTMLを指定して再度パースを試みる。
	 */
	NSXMLDocument *document = [[[NSXMLDocument alloc] initWithData:reciveData 
														   options:NSXMLDocumentTidyXML 
															 error:NULL] autorelease];
	
	NSArray* nodes;
	NSError* error; 
	
	nodes = [document nodesForXPath:@"//title" error:&error];
	
	//NSLog(@"%@",nodes);
	if (0 == [nodes count])
	{
		document = [[[NSXMLDocument alloc] initWithData:reciveData 
												options:NSXMLDocumentTidyHTML 
												  error:NULL] autorelease];
		nodes = [document nodesForXPath:@"//title" error:&error];
	}
	
	if (0 != [nodes count])
		return [[[NSString alloc] initWithString:[[nodes objectAtIndex:0] stringValue]]autorelease];
	else
		return @"";//ここに来ると、現状どうしようもない。
}

/*
 * FeedのURLを購読対象のサーバから直接取得する。
 * RSSのURLと差分があれば、レスポンスのURLを優先して返却する
 */
- (NSString *)getFeedURL:(NSString *)feedURL
{
	NSMutableString * newURL = [NSMutableString string];
	[newURL setString:feedURL];
	
	NSURL* url = [NSURL URLWithString:feedURL];
	NSData *reciveData;
	NSURLResponse* response;
	
	[self httpRequest:@"GET"
				  url:url
		   reciveData:&reciveData
			 response:&response
	 ];
	
	//NSLog(@"%@",feedURL);
	//NSLog(@"%@",[[response URL] absoluteString]);
	if (response != nil && NO == [feedURL isEqualToString:[[response URL] absoluteString]])
	{
		//URLを書き換える。
		[newURL setString:[[response URL] absoluteString]];
	}
	
	return newURL;
}

- (void)httpRequestNotSync:(NSString *)method
					   url:(NSURL *)url
					header:(NSDictionary *)header
					  body:(NSString*)body
					   uid:(id)sender

{
	NSMutableURLRequest* urlRequest = [[NSMutableURLRequest alloc]initWithURL:url];
	[urlRequest setHTTPMethod:method];
	[urlRequest setHTTPBody:[body dataUsingEncoding:NSUTF8StringEncoding]];
	[urlRequest setAllHTTPHeaderFields:header];
	connector = [[NSURLConnection alloc] initWithRequest:urlRequest delegate:sender];

	[urlRequest release];
	return ;
}

/* cancel
 * Cancel the existing connection.
 */
-(void)cancel
{
	if (!isConnectionComplete)
	{
		isConnectionComplete = YES;
		status = MA_Connect_Cancelled;
		[connector cancel];
	}
	else if (status == MA_Connect_NeedCredentials)
	{
		status = MA_Connect_Cancelled;
		[connector cancel];
	}
}

-(void)dealloc
{
	[httpHeader release];
	[connector release];
	//[responseHeaders release];
	[super dealloc];
}
@end
