//
//  DataExtensions.m
//  GalapagosReader
//
//  Created by Yoshitaka Sakamaki on 平成22/03/06.
//  Copyright 2010 MyHOME. All rights reserved.
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//

#import "DataExtensions.h"
static char *base64 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";


@implementation NSData (EncodingBase64)
//----------------------------------------------------------------------------//
#pragma mark -- Internal --
//----------------------------------------------------------------------------//
- (void)encodeElem:(unsigned long)elem
            length:(NSInteger)length
            result:(NSMutableString *)result
{
	NSInteger i = length;
    for (; i < 2; i++) {
        elem <<= 8;
    }
	
    NSInteger count = 0;
	NSInteger base = 18;
    for (; count < length + 2; count++, base -= 6) {
        char base64string[2];
        base64string[0] = base64[(unsigned long)((elem>>base) & 0x3F)];
        base64string[1] = '\0';
		
        [result appendString:[NSString
							  stringWithCString:base64string
							  encoding:NSASCIIStringEncoding
							  //encoding:NSUTF8StringEncoding
							  ]];
    }
	
	NSInteger j = count;
    for (; j < 4; j++) {
        [result appendString:[NSString
							  stringWithCString:"="
							  encoding:NSASCIIStringEncoding
							  //encoding:NSUTF8StringEncoding
							  ]];
    }
}

//----------------------------------------------------------------------------//
#pragma mark -- APIs --
//----------------------------------------------------------------------------//

- (NSString *)stringByEncodingBase64
{
    NSMutableString *result = [NSMutableString string];
	
    unsigned long elem = (unsigned long)0;
    NSInteger elemLength = 0;
	
    NSInteger length = [self length];
    NSInteger count = 0;
	const unsigned char *source = [self bytes];
    for (;
		 count < length;
		 source++, count++
		 ) {
        elem <<= 8;
        elem |= (unsigned long)*source;
		
        if (elemLength == 2) {
            [self encodeElem:elem length:elemLength result:result];
            elemLength = 0;
            elem = 0;
        } else {
            elemLength++;
        }
    }
	
    if (elemLength) {
        [self encodeElem:elem length:elemLength - 1 result:result];
    }
	
    return result;
}

@end
