//
//  BookmarkFolderWindow.h
//  GalapagosReader
//
//  Created by Yoshitaka Sakamaki on 平成22/04/15.
//  Copyright 2010 MyHOME. All rights reserved.
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//

#import <Cocoa/Cocoa.h>
#import "AppController.h"

extern NSString * MA_Bookmark_TagName;
extern NSString * MA_Bookmark_Count;
extern NSString * MA_Bookmark_Title;
extern NSString * MA_Bookmark_Date;
extern NSString * MA_Bookmark_URL;
extern NSString * MA_Bookmark_Comment;

typedef enum {
	MA_Search_ALL = 0,
	MA_Search_Title,
	MA_Search_Comment,
	MA_Search_URL
} SearchBookmarkKind;


@class TagsTableView;
@class BookmarkTableView;
@interface BookmarkFolderWindow : NSWindowController {
	IBOutlet NSWindow * bookmarkFolderWindow;
	IBOutlet TagsTableView * tagsTable;
	IBOutlet BookmarkTableView * bookmarkTable;
	IBOutlet NSButton * closeButton;
	IBOutlet NSSearchField * searchField;
	IBOutlet NSTextField * urlField;
	IBOutlet NSTextField * commentField;
	
	NSString * link;
	SEL handler;
	id delegate;
}
-(void)showBookmarkFolderSheet:(NSWindow*)window didEndSelector:(SEL)endSelector delegate:(id)theDelegate;
-(NSString *)link;
-(IBAction)closeBookmarkFolder:(id)sender;
-(IBAction)actionDoubleClick:(id)sender;
- (void)updateFilter;
@end

@interface TagsTableView : NSTableView {
}
-(void)reloadTagsFolder;
@end

@interface BookmarkTableView : NSTableView {
}
-(void)reloadBookmarksFolder;
-(void)reloadBookmarksFolder:(NSString*)searchString
							:(SearchBookmarkKind)searchKind;
@end
