//
//  BookmarkFolder.m
//  GalapagosReader
//
//  Created by poi-poi-caqpsule on 平成22/04/08.
//  Copyright 2010 MyHOME. All rights reserved.
//
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//

#import "BookmarkFolder.h"
#import "Database.h"


@implementation BookmarkFolder

-(id)initWithId:(int)newId name:(NSString *)newName type:(int)newType bookmarkCount:(int)count
{
	if ((self = [super init]) != nil)
	{
		itemId = newId;
		bookmarkCount = count;
		type = newType;
		isCached = NO;
		attributes = [[NSMutableDictionary dictionary] retain];
		cachedBookmarkTags = [[NSMutableDictionary dictionary] retain];
		[self setName:newName];
	}
	return self;
}

/* itemId
 * Returns the folder's ID.
 */
-(int)itemId
{
	return itemId;
}

/* bookmarkCount
 */
-(int)bookmarkCount
{
	return bookmarkCount;
}

/* type
 */
-(int)type
{
	return type;
}

/* attributes
 * Return the folder attributes.
 */
-(NSDictionary *)attributes
{
	return attributes;
}

/* name
 * Returns the folder name
 */
-(NSString *)name
{
	return [attributes valueForKey:@"Name"];
}

/* setName
 * Updates the folder name.
 */
-(void)setName:(NSString *)newName
{
	[attributes setValue:newName forKey:@"Name"];
}

/* setType
 * Changes the folder type
 */
-(void)setType:(int)newType
{
	type = newType;
}

/* isTagFolder
 */
-(BOOL)isTagFolder
{
	return IsTagFolder(self);
}

/* isNonTagFolder
 */
-(BOOL)isNonTagFolder
{
	return IsNonTagFolder(self);
}

/* setBookmarkCount
 */
-(void)setBookmarkCount:(int)count
{
	NSAssert1(count >= 0, @"Attempting to set a negative bookmark count on folder %@", [self name]);
	bookmarkCount = count;
}

/* bookmarkTags
 */
-(NSArray*)bookmarkTags
{
	if (!isCached)
		[[Database sharedDatabase] arrayOfBookmarkTag:itemId];
	return [cachedBookmarkTags allValues];
}

/* clearCache
 */
-(void)clearCache
{
	[cachedBookmarkTags removeAllObjects];
	isCached = NO;
}

/* addBookmarkTagsToCache
 */
-(void)addBookmarkTagsToCache:(BookmarkTag *)newBookmarkTag
{
	[cachedBookmarkTags setObject:newBookmarkTag forKey:[newBookmarkTag tagName]];
	isCached = YES;
}

/* dealloc
 * Clean up and release resources.
 */
-(void)dealloc
{
	[attributes release];
	[cachedBookmarkTags release];
	[super dealloc];
}

@end
