//
//  Bookmark.m
//  GalapagosReader
//
//  Created by Yoshitaka Sakamaki on 平成22/04/15.
//  Copyright 2010 MyHOME. All rights reserved.
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//

#import "Bookmark.h"
#import "CalendarExtensions.h"

NSString * MA_B_Field_RowId = @"RowId";
NSString * MA_B_Field_URL = @"URL";
NSString * MA_B_Field_Title = @"Title";
NSString * MA_B_Field_Search = @"Search";
NSString * MA_B_Field_Date = @"Date";
NSString * MA_B_Field_Comment = @"Comment";
NSString * MA_B_Field_CommentAndTag = @"CommentAndTag";

@implementation Bookmark

-(id)init
{
	if ((self = [super init]) != nil)
	{
		rowid = 0;
		bookmarkData = [[NSMutableDictionary dictionary] retain];
	}
	return self;
}

-(void)setBookmarkRowId:(int)theRowid
{
	rowid = theRowid;
}

-(void)setURL:(NSString*)url
{
	[bookmarkData setObject:url forKey:MA_B_Field_URL];
}

-(void)setTitle:(NSString*)title
{
	[bookmarkData setObject:title forKey:MA_B_Field_Title];
}

-(void)setSearch:(NSString*)searchString
{
	[bookmarkData setObject:searchString forKey:MA_B_Field_Search];
}

-(void)setDate:(NSDate*)date
{
	[bookmarkData setObject:date forKey:MA_B_Field_Date];
}

-(void)setComment:(NSString*)commentAndTag :(NSString*)comment
{
	[bookmarkData setObject:commentAndTag forKey:MA_B_Field_CommentAndTag];
	[bookmarkData setObject:comment forKey:MA_B_Field_Comment];
}

-(int)bookmarkRowid
{
	return rowid;
}

-(NSString*)bookmarkUrl {return [bookmarkData objectForKey:MA_B_Field_URL];}
-(NSString*)bookmarkTitle {return [bookmarkData objectForKey:MA_B_Field_Title];}
-(NSString*)searchString {return [bookmarkData objectForKey:MA_B_Field_Search];}
-(NSDate*)bookmarkDate {return [bookmarkData objectForKey:MA_B_Field_Date];}
-(NSString*)bookmarkCommentAndTag {return [bookmarkData objectForKey:MA_B_Field_CommentAndTag];}
-(NSString*)bookmarkComment {return [bookmarkData objectForKey:MA_B_Field_Comment];}

-(NSString*)tagBookmarkDate {
	return [[[self bookmarkDate] dateWithCalendarFormat:nil timeZone:nil] friendlyDescription];
}


/* dealloc
 * Clean up and release resources.
 */
-(void)dealloc
{
	[bookmarkData release];
	[super dealloc];
}

@end
