//
//  BookMarkWindow.h
//  GalapagosReader
//
//  Created by Yoshitaka Sakamaki on 平成22/03/06.
//  Copyright 2010 MyHOME. All rights reserved.
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//

#import <Cocoa/Cocoa.h>
#import "EditManagerHatena.h"
#import "LoginControllerHatena.h"

#define MA_COMMENT_LENGTH_MAX_HATENA 100
typedef enum {
	MA_Bookmark_Article = 0,
	MA_Bookmark_Browser
} BookmarkKind;

@interface BookMarkWindow : NSWindowController {
	IBOutlet NSWindow * bookmarkWindow;
	IBOutlet NSButton * addButton;
	IBOutlet NSButton * cancelButton;
	IBOutlet NSButton * deleteButton;
	IBOutlet NSTextField * titleField;
	IBOutlet NSTextField * urlField;
	IBOutlet NSTextField * bookMarkCountField;
	IBOutlet NSTextField * commentField;
	IBOutlet NSTextField * commentLengthField;
	IBOutlet NSTextField * bookmarkDateField;
	IBOutlet NSTokenField * tagsField;
	IBOutlet NSTokenField * myTagsField;
	IBOutlet NSTokenField * recommendField;
	NSDictionary * myEntryDict;
	Article * article;
	NSString * viewLink;
	BOOL equalToArticleListURL;
	BOOL isArticleListBookmark;
	BOOL isRetryBookmark;
	id delegate;
	SEL handler;
}
-(void)showBookmarkSheet:(NSWindow*)window 
				 article:(Article*)theArticle
				viewLink:(NSString*)theViewLink
		  didEndSelector:(SEL)endSelector 
				delegate:(id)theDelegate
				 isRetry:(BOOL)isRetry;
-(void)completeRequestMyEntry:(NSString*)bookmarkURL;
-(IBAction)addBookMark:(id)sender;
-(IBAction)cancelBookMark:(id)sender;
-(IBAction)deleteBookMark:(id)sender;
@end
