/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xslf.usermodel;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.poi.POIXMLDocumentPart;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.xslf.usermodel.Placeholder;
import org.apache.poi.xslf.usermodel.SlideLayout;
import org.apache.poi.xslf.usermodel.XSLFBackground;
import org.apache.poi.xslf.usermodel.XSLFShape;
import org.apache.poi.xslf.usermodel.XSLFSheet;
import org.apache.poi.xslf.usermodel.XSLFSimpleShape;
import org.apache.poi.xslf.usermodel.XSLFSlide;
import org.apache.poi.xslf.usermodel.XSLFSlideMaster;
import org.apache.poi.xslf.usermodel.XSLFTextShape;
import org.apache.poi.xslf.usermodel.XSLFTheme;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.presentationml.x2006.main.CTBackground;
import org.openxmlformats.schemas.presentationml.x2006.main.CTPlaceholder;
import org.openxmlformats.schemas.presentationml.x2006.main.CTSlideLayout;
import org.openxmlformats.schemas.presentationml.x2006.main.SldLayoutDocument;

public class XSLFSlideLayout
extends XSLFSheet {
    private CTSlideLayout _layout;
    private XSLFSlideMaster _master;

    XSLFSlideLayout() {
        this._layout = CTSlideLayout.Factory.newInstance();
    }

    public XSLFSlideLayout(PackagePart part, PackageRelationship rel) throws IOException, XmlException {
        super(part, rel);
        SldLayoutDocument doc = SldLayoutDocument.Factory.parse((InputStream)this.getPackagePart().getInputStream());
        this._layout = doc.getSldLayout();
        this.setCommonSlideData(this._layout.getCSld());
    }

    public String getName() {
        return this._layout.getCSld().getName();
    }

    public XmlObject getXmlObject() {
        return this._layout;
    }

    protected String getRootElementName() {
        return "sldLayout";
    }

    public XSLFSlideMaster getSlideMaster() {
        if (this._master == null) {
            Iterator iterator = this.getRelations().iterator();
            while (iterator.hasNext()) {
                POIXMLDocumentPart p = (POIXMLDocumentPart)iterator.next();
                if (!(p instanceof XSLFSlideMaster)) continue;
                this._master = (XSLFSlideMaster)p;
            }
        }
        if (this._master == null) {
            throw new IllegalStateException("SlideMaster was not found for " + this.toString());
        }
        return this._master;
    }

    public XSLFSheet getMasterSheet() {
        return this.getSlideMaster();
    }

    public XSLFTheme getTheme() {
        return this.getSlideMaster().getTheme();
    }

    public boolean getFollowMasterGraphics() {
        return !this._layout.isSetShowMasterSp() || this._layout.getShowMasterSp();
    }

    protected boolean canDraw(XSLFShape shape) {
        XSLFSimpleShape txt;
        CTPlaceholder ph;
        return !(shape instanceof XSLFSimpleShape) || (ph = (txt = (XSLFSimpleShape)shape).getCTPlaceholder()) == null;
    }

    public XSLFBackground getBackground() {
        CTBackground bg = this._layout.getCSld().getBg();
        if (bg != null) {
            return new XSLFBackground(bg, (XSLFSheet)this);
        }
        return this.getMasterSheet().getBackground();
    }

    public void copyLayout(XSLFSlide slide) {
        int i = 0;
        while (i < this.getShapes().length) {
            XSLFTextShape tsh;
            Placeholder ph;
            XSLFShape sh = this.getShapes()[i];
            if (sh instanceof XSLFTextShape && (ph = (tsh = (XSLFTextShape)sh).getTextType()) != null && !Placeholder.DATETIME.equals(ph) && !Placeholder.SLIDE_NUMBER.equals(ph) && !Placeholder.FOOTER.equals(ph)) {
                slide.getSpTree().addNewSp().set(tsh.getXmlObject().copy());
            }
            ++i;
        }
    }

    public SlideLayout getType() {
        int ordinal = this._layout.getType().intValue() - 1;
        return SlideLayout.values()[ordinal];
    }
}

