/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xslf.model.geom;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.xslf.model.geom.AdjustValue;
import org.apache.poi.xslf.model.geom.ClosePathCommand;
import org.apache.poi.xslf.model.geom.Guide;
import org.apache.poi.xslf.model.geom.LineToCommand;
import org.apache.poi.xslf.model.geom.MoveToCommand;
import org.apache.poi.xslf.model.geom.Path;
import org.openxmlformats.schemas.drawingml.x2006.main.CTCustomGeometry2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTGeomGuide;
import org.openxmlformats.schemas.drawingml.x2006.main.CTGeomGuideList;
import org.openxmlformats.schemas.drawingml.x2006.main.CTGeomRect;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPath2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPath2DList;
import poi.support.Iterable;

public class CustomGeometry
implements Iterable {
    List adjusts = new ArrayList();
    List guides = new ArrayList();
    List paths = new ArrayList();
    Path textBounds;

    public CustomGeometry(CTCustomGeometry2D geom) {
        CTPath2DList pathLst;
        CTGeomGuideList gdLst;
        CTGeomGuideList avLst = geom.getAvLst();
        if (avLst != null) {
            Iterator<CTGeomGuide> iterator = Arrays.asList(avLst.getGdArray()).iterator();
            while (iterator.hasNext()) {
                CTGeomGuide gd = iterator.next();
                this.adjusts.add(new AdjustValue(gd));
            }
        }
        if ((gdLst = geom.getGdLst()) != null) {
            Iterator<CTGeomGuide> iterator = Arrays.asList(gdLst.getGdArray()).iterator();
            while (iterator.hasNext()) {
                CTGeomGuide gd = iterator.next();
                this.guides.add(new Guide(gd));
            }
        }
        if ((pathLst = geom.getPathLst()) != null) {
            Iterator<CTPath2D> iterator = Arrays.asList(pathLst.getPathArray()).iterator();
            while (iterator.hasNext()) {
                CTPath2D spPath = iterator.next();
                this.paths.add(new Path(spPath));
            }
        }
        if (geom.isSetRect()) {
            CTGeomRect rect = geom.getRect();
            this.textBounds = new Path();
            this.textBounds.addCommand(new MoveToCommand(rect.getL().toString(), rect.getT().toString()));
            this.textBounds.addCommand(new LineToCommand(rect.getR().toString(), rect.getT().toString()));
            this.textBounds.addCommand(new LineToCommand(rect.getR().toString(), rect.getB().toString()));
            this.textBounds.addCommand(new LineToCommand(rect.getL().toString(), rect.getB().toString()));
            this.textBounds.addCommand(new ClosePathCommand());
        }
    }

    public Iterator iterator() {
        return this.paths.iterator();
    }

    public Path getTextBounds() {
        return this.textBounds;
    }
}

