/**
	PlayListMaker Software to create a playlist for Android devices.
	Copyright (C) 2013 KuroBlack.

	This program is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package playlistmaker.command;

import java.awt.BorderLayout;
import java.awt.Container;

import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;

import playlistmaker.application.Application;

/************************************/
/*									*/
/*プロパティ画面を呼び出すコマンド	*/
/*プロパティ画面も作る				*/
/*									*/
/************************************/


public class PropertyCommand extends Command {

	Application app;


	public PropertyCommand(Application app){
		this.app = app;
	}
	
	public void execute() {
		JList list = app.getListBox();
		if(list.isSelectionEmpty()){
			/*もし何も選択されていなければプロパティを開かない*/
		}else{
			/*プロパティ画面生成へ*/
			propertyFrame(app,list);
		}	
	}	
	
	/*プロパティ画面*/
	public void propertyFrame(Application app, JList list){
		JPanel panel = new JPanel();
		
		/*フレーム名とフレームサイズ設定*/
		JFrame frame = new JFrame(list.getSelectedValue()+"のプロパティ");
		frame.setSize(300, 200);
		
		/*(テキストフィールド内のテキスト , 入力フィールドの幅)*/
		/*テキストフィールド内部の文字位置指定*/
		JTextField nameF = new JTextField(""+list.getSelectedValue() ,20);		
		nameF.setHorizontalAlignment(JTextField.LEFT);

		/*表示するものを追加*/
		panel.add(new JLabel("名前:"));
		panel.add(nameF);
		
		/*テキストフィールド作成*/
		Container contentPane = frame.getContentPane();
		contentPane.add(panel, BorderLayout.CENTER);
		frame.setVisible(true);
	}
	
}
