package tamanegisoul.pl.widget;

import java.io.IOException;
import java.util.ArrayList;

import org.apache.http.client.ClientProtocolException;

import tamanegisoul.pl.CacheUtils;
import tamanegisoul.pl.R;
import tamanegisoul.pl.data.AlbumInfo;
import tamanegisoul.pl.data.PhotoInfo;
import tamanegisoul.pl.picasa.Picasa;
import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.DialogInterface.OnCancelListener;
import android.content.res.Resources;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;

public class CacheMenuDialogBuilder implements DialogInterface.OnClickListener, DialogInterface.OnDismissListener, Runnable, OnCancelListener {

    private Context mContext;
    private AlbumInfo mAlbumInfo;
    private ProgressDialog mProgressDialog;
    private int mButtonClicked = AlertDialog.BUTTON_NEUTRAL;
    private Handler mHandler;
    private boolean mCanceled;

    public CacheMenuDialogBuilder(Context context, AlbumInfo info) {
        super();
        mContext = context;
        mAlbumInfo = info;
        mHandler = new Handler(){
            @Override
            public void handleMessage(Message message) {
                mProgressDialog.setMessage(message.getData().getString("message"));
            }
        };
    }

    public void show() {
        Resources r = mContext.getResources();
        AlertDialog alertDialog = new AlertDialog.Builder(mContext).create();
        alertDialog.setIcon(android.R.drawable.ic_dialog_alert);
        alertDialog.setTitle(r.getString(R.string.cache_menu));
        alertDialog.setMessage(r.getString(R.string.cache_menu_text));
        alertDialog.setButton(DialogInterface.BUTTON_POSITIVE, r.getString(R.string.update), this);
        alertDialog.setButton(DialogInterface.BUTTON_NEUTRAL, r.getString(R.string.cancel), this);
        alertDialog.setButton(DialogInterface.BUTTON_NEGATIVE, r.getString(R.string.delete), this);
        alertDialog.setOnDismissListener(this);
        alertDialog.show();
    }

    @Override
    public void onClick(DialogInterface dialog, int which) {
        mButtonClicked = which;
    }

    @Override
    public void onDismiss(DialogInterface dialog) {
        switch (mButtonClicked) {
        case DialogInterface.BUTTON_POSITIVE:
            mCanceled = false;
            mProgressDialog = new ProgressDialog(mContext);
            mProgressDialog.setProgressStyle(ProgressDialog.STYLE_SPINNER);
            mProgressDialog.setMessage(mContext.getResources().getText(R.string.downloading));
            mProgressDialog.setCancelable(true);
            mProgressDialog.setOnCancelListener(this);
            mProgressDialog.show();
            new Thread(this).start();
            break;
        case DialogInterface.BUTTON_NEGATIVE:
            CacheUtils.clearCache(mAlbumInfo.title);
            break;
        default:
            break;
        }
    }

    @Override
    public void run() {
        Picasa picasa = Picasa.getInstance();
        ArrayList<PhotoInfo> photoInfos = picasa.getPhotoList(mAlbumInfo);
        setDownloagindMessage(0, photoInfos.size());
        for(int i = 0; i < photoInfos.size(); i++) {
            if(mCanceled)
                break;
            PhotoInfo photoInfo = photoInfos.get(i);
            try {
                CacheUtils.cache(mAlbumInfo.title, photoInfo.title, picasa.httpGet(photoInfo.link));
                setDownloagindMessage(i + 1, photoInfos.size());
            } catch (ClientProtocolException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            } catch (IOException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
        }

        mProgressDialog.dismiss();
    }

    @Override
    public void onCancel(DialogInterface dialog) {
        mCanceled = true;
    }
    
    private void setDownloagindMessage(int currentIndex, int photoCount) {
        Message message = new Message();
        Bundle bundle = new Bundle();
        message.setData(bundle);
        bundle.putString("message", String.format(mContext.getResources().getString(R.string.f_photo_downloading), currentIndex, photoCount));
        mHandler.sendMessage(message);
    }
}
