package tamanegisoul.pl.widget;

import java.util.List;

import tamanegisoul.pl.CacheUtils;
import tamanegisoul.pl.R;
import tamanegisoul.pl.data.AlbumInfo;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.TextView;

public class AlbumInfoAdapter extends ArrayAdapter<AlbumInfo> {

    private LayoutInflater mInflater;
    private TextView mTitle;
    private TextView mNumPhotos;
    private TextView mCacheSize;

    public AlbumInfoAdapter(Context context, List<AlbumInfo> albumInfos) {
        super(context, R.layout.album_info_row, albumInfos);
        mInflater = (LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
    }

    public View getView(final int position, View convertView, ViewGroup parent) {
        if (convertView == null) {
            convertView = mInflater.inflate(R.layout.album_info_row, null);
        }
        AlbumInfo item = this.getItem(position);
        if (item != null) {
            mTitle = (TextView) convertView.findViewById(R.id.title);
            mTitle.setText(item.title);
            mNumPhotos = (TextView) convertView.findViewById(R.id.numPhotos);
            mNumPhotos.setText(item.numPhotos.toString());
            mCacheSize = (TextView) convertView.findViewById(R.id.cacheSize);
            mCacheSize.setText(String.valueOf(CacheUtils.getSize(item.title)));
        }
        return convertView;
    }

}
