package tamanegisoul.pl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.lang.reflect.Method;

import android.util.Log;

public final class AppUtils {
    
    private static String LOG_FORMAT = "%s(%s) %s";

    public static String getContent(InputStream in, String enc) throws IOException {
        BufferedReader r = new BufferedReader(new InputStreamReader(in, enc));
        StringWriter out = new StringWriter();
        for (String read = r.readLine(); r != null; read = r.readLine()) {
            out.write(read);
        }
        out.flush();
        out.close();
        return out.getBuffer().toString();
    }
    
    public static void d(Class<?> clazz, String message){
        Log.d(AppContext.NAME, String.format(LOG_FORMAT, clazz.getName(), "n/a", message));
    }
    public static void d(Method method, String message){
        Log.d(AppContext.NAME, String.format(LOG_FORMAT, method.getClass().getName(), method.getName(), message));
    }
    public static void d(Throwable e){
        Log.d(AppContext.NAME, "", e);
    }

}
