/***************************************************************
 * MPFSImg2.c
 * Defines an MPFS2 image to be stored in program memory.
 *
 * NOT FOR HAND MODIFICATION
 * This file is automatically generated by the MPFS2 Utility
 * ALL MODIFICATIONS WILL BE OVERWRITTEN BY THE MPFS2 GENERATOR
 * Generated  11 07 2011 09:22:14 
 ***************************************************************/

#define __MPFSIMG2_C

#include "TCPIPConfig.h"
#if !defined(MPFS_USE_EEPROM) && !defined(MPFS_USE_SPI_FLASH)

#include "TCPIP Stack/TCPIP.h"
#if defined(STACK_USE_MPFS2)


/**************************************
 * MPFS2 Image Data
 **************************************/
#define DATACHUNK000000 \
	0x4d,0x50,0x46,0x53,0x02,0x01,0x18,0x00,0x6a,0x55,0x5e,0x2a,0x26,0x4f,0x26,0x2d, /* MPFS....jU^.&O&- */ \
	0x0a,0xa3,0xff,0xff,0x6a,0x83,0xff,0xff,0xea,0x72,0xff,0xff,0x4a,0xe3,0xff,0xff, /* ....j....r..J... */ \
	0x6a,0xe3,0xff,0xff,0xea,0x92,0xff,0xff,0x0a,0x4f,0xff,0xff,0x26,0xb6,0xff,0xff, /* j........O..&... */ \
	0x8a,0xb6,0xff,0xff,0xca,0xb4,0xff,0xff,0x48,0x02,0x00,0x00,0x35,0x03,0x00,0x00, /* ........H...5... */ \
	0x99,0x03,0x00,0x00,0xb3,0x77,0xb0,0x4e,0x00,0x00,0x00,0x00,0x01,0x00,0x53,0x02, /* .....w.N......S. */ \
	0x00,0x00,0xce,0x06,0x00,0x00,0xc2,0x05,0x00,0x00,0x91,0x1b,0x15,0x4e,0x00,0x00, /* .............N.. */ \
	0x00,0x00,0x01,0x00,0x5d,0x02,0x00,0x00,0x90,0x0c,0x00,0x00,0xa0,0x00,0x00,0x00, /* ....]........... */ \
	0xc3,0x42,0x9b,0x4e,0x00,0x00,0x00,0x00,0x00,0x00,0x68,0x02,0x00,0x00,0x30,0x0d, /* .B.N......h...0. */ \
	0x00,0x00,0xf0,0x03,0x00,0x00,0x85,0x24,0xb7,0x4e,0x00,0x00,0x00,0x00,0x00,0x00, /* .......$.N...... */ \
	0x73,0x02,0x00,0x00,0x20,0x11,0x00,0x00,0x1b,0x04,0x00,0x00,0x27,0x7c,0xab,0x4e, /* s... .......'|.N */ \
	0x00,0x00,0x00,0x00,0x02,0x00,0x7d,0x02,0x00,0x00,0x3b,0x15,0x00,0x00,0x68,0x00, /* ......}...;...h. */ \
	0x00,0x00,0x27,0x7c,0xab,0x4e,0x00,0x00,0x00,0x00,0x00,0x00,0x7e,0x02,0x00,0x00, /* ..'|.N......~... */ \
	0xa3,0x15,0x00,0x00,0xcf,0x02,0x00,0x00,0x4a,0xb7,0xa4,0x4e,0x00,0x00,0x00,0x00, /* ........J..N.... */ \
	0x02,0x00,0x89,0x02,0x00,0x00,0x72,0x18,0x00,0x00,0x48,0x00,0x00,0x00,0x4a,0xb7, /* ......r...H...J. */ \
	0xa4,0x4e,0x00,0x00,0x00,0x00,0x00,0x00,0x8a,0x02,0x00,0x00,0xba,0x18,0x00,0x00, /* .N.............. */ \
	0xf8,0x08,0x00,0x00,0xe9,0x38,0xaf,0x4e,0x00,0x00,0x00,0x00,0x02,0x00,0xa1,0x02, /* .....8.N........ */ \
	0x00,0x00,0xb2,0x21,0x00,0x00,0x80,0x00,0x00,0x00,0xe9,0x38,0xaf,0x4e,0x00,0x00, /* ...!.......8.N.. */ \
	0x00,0x00,0x00,0x00,0xa2,0x02,0x00,0x00,0x32,0x22,0x00,0x00,0x03,0x02,0x00,0x00, /* ........2"...... */ \
	0x86,0x22,0xac,0x4e,0x00,0x00,0x00,0x00,0x02,0x00,0xba,0x02,0x00,0x00,0x35,0x24, /* .".N..........5$ */ \
	0x00,0x00,0x20,0x00,0x00,0x00,0x86,0x22,0xac,0x4e,0x00,0x00,0x00,0x00,0x00,0x00, /* .. ....".N...... */ \
	0xbb,0x02,0x00,0x00,0x55,0x24,0x00,0x00,0x9f,0x0a,0x00,0x00,0xd7,0x33,0xb5,0x4e, /* ....U$.......3.N */ \
	0x00,0x00,0x00,0x00,0x02,0x00,0xd3,0x02,0x00,0x00,0xf4,0x2e,0x00,0x00,0xb0,0x00, /* ................ */ \
	0x00,0x00,0xd7,0x33,0xb5,0x4e,0x00,0x00,0x00,0x00,0x00,0x00,0xd4,0x02,0x00,0x00, /* ...3.N.......... */ \
	0xa4,0x2f,0x00,0x00,0xf8,0x0b,0x00,0x00,0x72,0x7f,0xb3,0x4e,0x00,0x00,0x00,0x00, /* ./......r..N.... */ \
	0x02,0x00,0xe7,0x02,0x00,0x00,0x9c,0x3b,0x00,0x00,0xa0,0x00,0x00,0x00,0x72,0x7f, /* .......;......r. */ \
	0xb3,0x4e,0x00,0x00,0x00,0x00,0x00,0x00,0xe8,0x02,0x00,0x00,0x3c,0x3c,0x00,0x00, /* .N..........<<.. */ \
	0xc6,0x03,0x00,0x00,0x91,0x1b,0x15,0x4e,0x00,0x00,0x00,0x00,0x02,0x00,0xfa,0x02, /* .......N........ */ \
	0x00,0x00,0x02,0x40,0x00,0x00,0x18,0x00,0x00,0x00,0x91,0x1b,0x15,0x4e,0x00,0x00, /* ...@.........N.. */ \
	0x00,0x00,0x00,0x00,0xfb,0x02,0x00,0x00,0x1a,0x40,0x00,0x00,0x08,0x00,0x00,0x00, /* .........@...... */ \
	0x91,0x1b,0x15,0x4e,0x00,0x00,0x00,0x00,0x02,0x00,0x0e,0x03,0x00,0x00,0x22,0x40, /* ...N.........."@ */ \
	0x00,0x00,0x08,0x00,0x00,0x00,0x91,0x1b,0x15,0x4e,0x00,0x00,0x00,0x00,0x00,0x00, /* .........N...... */ \
	0x0f,0x03,0x00,0x00,0x2a,0x40,0x00,0x00,0x06,0x02,0x00,0x00,0xcb,0x00,0xb7,0x4e, /* .....@.........N */ \
	0x00,0x00,0x00,0x00,0x02,0x00,0x22,0x03,0x00,0x00,0x30,0x42,0x00,0x00,0x20,0x00, /* ......"...0B.. . */ \
	0x00,0x00,0xcb,0x00,0xb7,0x4e,0x00,0x00,0x00,0x00,0x00,0x00,0x23,0x03,0x00,0x00, /* .....N......#... */ \
	0x50,0x42,0x00,0x00,0x6c,0x03,0x00,0x00,0xc3,0xf2,0xad,0x4e,0x00,0x00,0x00,0x00, /* PB..l......N.... */ \
	0x02,0x00,0x34,0x03,0x00,0x00,0xbc,0x45,0x00,0x00,0x30,0x00,0x00,0x00,0xc3,0xf2, /* ..4....E..0..... */ \
	0xad,0x4e,0x00,0x00,0x00,0x00,0x00,0x00,0x37,0x6d,0x33,0x74,0x6a,0x7a,0x2e,0x63, /* .N......7m3tjz.c */ \
	0x73,0x73,0x00,0x37,0x6d,0x33,0x74,0x6a,0x7a,0x2e,0x6a,0x73,0x00,0x66,0x6f,0x6f, /* ss.7m3tjz.js.foo */ \
	0x74,0x65,0x72,0x2e,0x69,0x6e,0x63,0x00,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69, /* ter.inc.header.i */ \
	0x6e,0x63,0x00,0x69,0x6e,0x64,0x65,0x78,0x2e,0x68,0x74,0x6d,0x00,0x00,0x73,0x74, /* nc.index.htm..st */ \
	0x61,0x74,0x75,0x73,0x2e,0x68,0x74,0x6d,0x00,0x00,0x6e,0x6f,0x64,0x65,0x61,0x64, /* atus.htm..nodead */ \
	0x61,0x70,0x74,0x65,0x72,0x2f,0x63,0x6f,0x6e,0x66,0x69,0x67,0x2e,0x68,0x74,0x6d, /* apter/config.htm */ \
	0x00,0x00,0x6e,0x6f,0x64,0x65,0x61,0x64,0x61,0x70,0x74,0x65,0x72,0x2f,0x63,0x6f, /* ..nodeadapter/co */ \
	0x6e,0x66,0x69,0x67,0x32,0x2e,0x68,0x74,0x6d,0x00,0x00,0x6e,0x6f,0x64,0x65,0x61, /* nfig2.htm..nodea */ \
	0x64,0x61,0x70,0x74,0x65,0x72,0x2f,0x63,0x6f,0x6e,0x66,0x69,0x67,0x33,0x2e,0x68, /* dapter/config3.h */ \
	0x74,0x6d,0x00,0x00,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x63,0x6f,0x6e,0x66, /* tm..protect/conf */ \
	0x69,0x67,0x2e,0x68,0x74,0x6d,0x00,0x00,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f, /* ig.htm..protect/ */ \
	0x69,0x6e,0x64,0x65,0x78,0x2e,0x68,0x74,0x6d,0x00,0x00,0x70,0x72,0x6f,0x74,0x65, /* index.htm..prote */ \
	0x63,0x74,0x2f,0x72,0x65,0x62,0x6f,0x6f,0x74,0x2e,0x63,0x67,0x69,0x00,0x00,0x70, /* ct/reboot.cgi..p */ \
	0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x72,0x65,0x62,0x6f,0x6f,0x74,0x2e,0x68,0x74, /* rotect/reboot.ht */ \
	0x6d,0x00,0x00,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x75,0x73,0x65,0x72,0x2e, /* m..protect/user. */ \
	0x68,0x74,0x6d,0x00,0x00,0x1f,0x8b,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xad, /* htm............. */ \
	0x56,0xc1,0x6e,0xa3,0x30,0x10,0x3d,0x37,0x52,0xfe,0x01,0xa9,0xd7,0x80,0x20,0x84, /* V.n.0.=7R..... . */ \
	0xb4,0xa5,0xa7,0xd5,0xde,0xf7,0xb8,0x77,0x83,0x87,0x60,0xd5,0xc1,0xc8,0x98,0x26, /* .......w..`....& */ \
	0xdd,0x6a,0xff,0x7d,0x6d,0x63,0xb0,0x01,0x27,0xd5,0xae,0xb6,0x48,0x6d,0x31,0x9e, /* .j.}mc..'...Hm1. */ \
	0xf7,0xc6,0x33,0x6f,0x66,0x5c,0x30,0xfc,0x11,0x7c,0x6e,0x37,0x0f,0x15,0x6b,0x44, /* ..3of\0..|n7..kD */ \
	0x58,0xa1,0x33,0xa1,0x1f,0x79,0xf0,0x13,0x38,0x46,0x0d,0xda,0x05,0xdf,0x38,0x41, /* X.3..y..8F....8A */ \
	0x74,0x17,0x74,0xa8,0xe9,0xc2,0x0e,0x38,0xa9,0x5e,0xe5,0xd6,0x02,0x95,0x6f,0x27, /* t.t....8.^....o' */ \
	0xce,0xfa,0x06,0xe7,0xc1,0x63,0x56,0xa8,0x47,0x2d,0x9f,0x11,0x3f,0x91,0x26,0x0f, /* .....cV.G-..?.&. */ \
	0xe2,0xf6,0x1a,0xa0,0x5e,0x30,0xb5,0xd6,0x22,0x8c,0x49,0x73,0x92,0x8b,0xf2,0xd9, /* ....^0..".Is.... */ \
	0xab,0x2f,0xb1,0x5c,0xfe,0xbd,0xdd,0x6c,0x37,0x8f,0x5d,0x8d,0x30,0xbb,0x84,0xac, /* ./.\...l7.].0... */ \
	0x01,0xed,0xc0,0x85,0x60,0x51,0xe7,0xc1,0xd3,0x51,0xee,0xd2,0x2c,0x8c,0x63,0xe0, /* ....`Q...Q..,.c. */ \
	0x79,0x90,0x48,0xa3,0x8e,0x51,0x82,0x25,0x57,0x96,0xd9,0x2f,0xa1,0x60,0x6d,0xae, /* y.H..Q.%W../.`m. */ \
	0xe1,0x7c,0xcc,0xbf,0x2d,0x81,0xb8,0x30,0x4d,0xe0,0x01,0x3c,0x14,0xea,0xf1,0x61  /* .|..-..0M..<...a */
#define DATACHUNK000001 \
	0xba,0xf6,0x35,0x07,0xb8,0x89,0x70,0x38,0x7c,0x61,0x5e,0xb1,0x9e,0xdf,0xb2,0x4e, /* ..5...p8|a^....N */ \
	0x91,0x7a,0x6e,0x00,0x48,0x88,0x16,0x9d,0x6e,0x32,0xa7,0x69,0xba,0x4a,0x46,0x55, /* .zn.H...n2.i.JFU */ \
	0x55,0xde,0x00,0x4d,0x69,0xd8,0x9b,0xe0,0xea,0x6c,0x77,0xe4,0x17,0x48,0xc8,0xb8, /* U..Mi....lw..H.. */ \
	0x15,0x73,0x42,0x81,0xad,0x22,0x3c,0x7b,0x04,0x11,0xd4,0x78,0xe5,0x72,0xc7,0xf2, /* .sB.."<{...x.r.. */ \
	0x67,0xa0,0x9f,0xd8,0x0e,0x0e,0xd9,0x05,0xc8,0xa9,0x16,0x79,0x50,0x30,0x8a,0xd5, /* g..........yP0.. */ \
	0x62,0xc9,0x28,0xe3,0xd6,0xe5,0x21,0x85,0x61,0xc1,0x84,0x60,0x67,0x49,0x98,0x0d, /* b.(...!.a..`gI.. */ \
	0xa6,0xb5,0xb1,0x4a,0x8e,0xfa,0xdd,0x75,0x20,0xe2,0xea,0xd3,0xe0,0x29,0x65,0x48, /* ...J...u ....)eH */ \
	0x6e,0xd2,0x0b,0xaf,0x56,0x4a,0x69,0x6c,0x4e,0x2b,0xe0,0x2a,0x42,0x44,0xc9,0xa9, /* n...VJilN+..BD.. */ \
	0xb1,0x9b,0x06,0xa8,0x33,0x34,0xbd,0x0b,0x41,0xa1,0x72,0x11,0x92,0xcc,0x20,0x98, /* ....34..A.r... . */ \
	0x23,0x85,0x7c,0x70,0xc7,0x84,0xd1,0xc1,0x40,0xae,0x86,0x93,0x83,0x31,0xc3,0xa4, /* #.|p....@....1.. */ \
	0x6b,0x29,0x92,0x05,0x55,0x50,0x56,0xbe,0xad,0xd2,0x65,0x43,0x66,0xa2,0x71,0xa9, /* k)..UPV...eCf.q. */ \
	0x89,0x80,0x59,0x08,0x9f,0xef,0x84,0xd0,0xa4,0x79,0x8a,0x99,0xd5,0x86,0x09,0xaa, /* ..Y......y...... */ \
	0x3e,0x37,0x86,0x92,0x71,0x24,0x08,0x93,0x87,0x6f,0x64,0xb1,0x2d,0xfc,0xce,0x6b, /* >7..q$...od.-..k */ \
	0xf6,0x0e,0x7c,0x9d,0x4e,0xac,0xe5,0x35,0xec,0x2c,0x25,0x3b,0x34,0xc2,0x3d,0x62, /* ..|.N..5.,%;4.=b */ \
	0xb6,0x37,0x19,0x5a,0xc6,0x7e,0x11,0xa9,0xc4,0x8d,0xd4,0x88,0x33,0x04,0x6b,0x54, /* .7.Z.~......3.kT */ \
	0x40,0x19,0xc7,0x5f,0x3b,0x3b,0x99,0x3a,0xfe,0x8e,0x00,0x83,0xab,0x6b,0x00,0x79, /* @.._;;.:.....k.y */ \
	0x10,0xe0,0x94,0x78,0x50,0xea,0x44,0x03,0x18,0xd1,0x0d,0x75,0x62,0xfd,0x8c,0xba, /* ...xP.D....ub... */ \
	0x16,0x95,0x23,0x07,0x05,0xc4,0x55,0xc8,0x45,0x3d,0xa1,0x54,0x8c,0x09,0xf3,0xd9, /* ..#...U.E=.T.... */ \
	0xa9,0x91,0x38,0x7a,0x86,0xb3,0xab,0xec,0xe3,0xf1,0xb8,0x14,0x5f,0x29,0xc9,0x81, /* ..8z........_).. */ \
	0xbb,0x2d,0x4b,0xc5,0x27,0xc8,0x74,0x63,0x0c,0x96,0x62,0xd3,0x7e,0x25,0xb3,0x76, /* .-K.'.tc..b.~%.v */ \
	0x68,0xd6,0xe4,0x76,0x2c,0xb3,0x0e,0x78,0x64,0x31,0x1d,0x55,0x20,0xd1,0x77,0x33, /* h..v,..xd1.U .w3 */ \
	0x25,0x3e,0xdd,0x4f,0x93,0xc5,0x77,0x1d,0x5a,0xb6,0xdf,0x39,0x97,0x57,0x8c,0x33, /* %>.O..w.Z..9.W.3 */ \
	0x07,0x5a,0xed,0xc2,0x44,0x91,0x0d,0xa7,0x93,0xbf,0x13,0xb7,0x20,0x89,0x4c,0x4f, /* .Z..D....... .LO */ \
	0x23,0x11,0xc2,0xa5,0x0b,0x53,0xff,0x8b,0xe0,0x8a,0xce,0x2d,0x85,0x82,0x5d,0x9d, /* #....S.....-..]. */ \
	0x7c,0xe5,0x3a,0x66,0xaa,0xc4,0x82,0xe9,0x3f,0x5f,0xcd,0xf8,0x4e,0x90,0x3a,0x52, /* |.:f....?_..N.:R */ \
	0x19,0x72,0x62,0x53,0xe2,0xc8,0xff,0x11,0xe3,0xe9,0x50,0x51,0xc9,0x30,0xac,0x47, /* .rbS......PQ.0.G */ \
	0xe4,0x77,0xd9,0xd6,0x89,0x54,0xc1,0x0f,0xb8,0xec,0xc6,0x97,0x5d,0x50,0x91,0x2b, /* .w...T......]P.+ */ \
	0xe0,0x50,0x07,0xdf,0xbc,0x38,0x67,0x01,0x5e,0x92,0xce,0xd3,0x39,0x2b,0x78,0x79, /* .P...8g.^...9+xy */ \
	0x5d,0xc4,0xcb,0x69,0x89,0xaa,0x25,0xad,0x64,0x30,0x2c,0xee,0x6d,0xc5,0x43,0x91, /* ]..i..%.d0,.m.C. */ \
	0x5a,0x26,0xce,0x19,0x77,0x05,0x3e,0x87,0x58,0xa5,0x7e,0xee,0x0c,0xc6,0xf7,0x78, /* Z&..w.>.X.~....x */ \
	0x5e,0x62,0x3b,0x9d,0xa6,0x6a,0x3a,0x3a,0x33,0xca,0x51,0x28,0xea,0x6a,0x27,0xe6, /* ^b;..j::3.Q(.j'. */ \
	0x93,0xc0,0xb2,0x85,0x1b,0xf1,0xa2,0xd5,0x3b,0x85,0xe8,0xe4,0xdf,0x0c,0x25,0x27, /* ........;.....%' */ \
	0x73,0x63,0xaf,0x5e,0x76,0x9c,0xcc,0x02,0x54,0x04,0x28,0xee,0x40,0xfc,0x5f,0xf5, /* sc.^v...T.(.@._. */ \
	0xdc,0x10,0xca,0x44,0x86,0xc9,0xfb,0xbc,0x00,0x54,0xfc,0x14,0x97,0xfa,0x3b,0x8e, /* ...D.....T....;. */ \
	0x94,0xb5,0x09,0x45,0x05,0xd0,0x75,0xda,0xc2,0xe4,0xe0,0xeb,0x0b,0xfb,0x61,0x6d, /* ...E..u.......am */ \
	0xac,0xf3,0x63,0x7c,0x67,0x50,0xb4,0xac,0x23,0x43,0x4b,0x44,0x85,0xcc,0x63,0x2f, /* ..c|gP..#CKD..c/ */ \
	0x60,0xe5,0x00,0x69,0xda,0x5e,0xac,0xc9,0xc7,0x96,0x34,0xd2,0xec,0x7d,0xce,0x6b, /* `..i.^....4..}.k */ \
	0xdb,0xa8,0x3b,0xbb,0x8d,0xc7,0x5e,0xc3,0x56,0x1b,0x11,0x4e,0x3c,0x3b,0x6f,0x0f, /* ..;...^.V..N<;o. */ \
	0xe9,0xc9,0xbc,0xe8,0xe5,0xa0,0x6b,0x94,0x7d,0xf1,0x6f,0x00,0x6a,0x07,0xe2,0x30, /* ......k.}.o.j..0 */ \
	0x9b,0xd5,0x7b,0x6f,0x3e,0x46,0x4f,0x53,0x1f,0x91,0x73,0xdd,0xbc,0xcb,0x1b,0x71, /* ..{o>FOS..s....q */ \
	0xe8,0x7a,0x2a,0xb6,0x9b,0xcf,0xed,0xa2,0xe1,0xff,0x9d,0xfc,0xe6,0x17,0x3e,0xff, /* .z............>. */ \
	0x3c,0xf1,0x5f,0x10,0xdc,0xc2,0x06,0x98,0xb2,0xfe,0x10,0xb1,0x37,0x7d,0xb0,0xb1, /* <._.........7}.. */ \
	0x66,0xa7,0x91,0x55,0xe8,0x06,0xbf,0x30,0xac,0xf4,0x95,0x44,0x5a,0x3e,0x28,0xd3, /* f..U...0...DZ>(. */ \
	0x0a,0x11,0xea,0x35,0x2e,0x8e,0x1e,0xe3,0x0a,0x66,0xc6,0x7d,0xe3,0x27,0x2e,0x4b, /* ...5.....f.}.'.K */ \
	0x9f,0x6d,0x85,0x8d,0xed,0x1f,0xa8,0x06,0xc4,0x04,0xa6,0x0c,0x00,0x00,0x1f,0x8b, /* .m.............. */ \
	0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xd5,0x57,0x5d,0x6f,0xdb,0x36,0x14,0x7d, /* .........W]o.6.} */ \
	0x56,0x80,0xfc,0x87,0x3b,0x3f,0x2c,0x32,0xe0,0x38,0x4e,0xb1,0xee,0xa1,0x81,0x3b, /* V...;?,2.8N....; */ \
	0xa4,0x49,0xb1,0x66,0x48,0x97,0x20,0x71,0x87,0x02,0xdb,0x1e,0x68,0x89,0x8e,0xd9, /* .I.fH. q....h... */ \
	0xc8,0xa2,0x4a,0x52,0x76,0x8d,0x22,0x3f,0x68,0xff,0x72,0xe7,0x92,0x94,0x2c,0xbb, /* ..JRv."?h.r...,. */ \
	0x69,0x51,0xac,0x7d,0x59,0x02,0x58,0x1f,0xbc,0xf7,0xf0,0xf2,0xdc,0x4f,0x1d,0x1d, /* iQ.}Y.X......O.. */ \
	0xd1,0x99,0xae,0xd6,0x46,0xdd,0xcd,0x1d,0xfd,0x43,0x4f,0x46,0xa3,0x27,0x87,0x4f, /* ....F....COF.'.O */ \
	0x46,0xc7,0x23,0x7a,0xad,0x32,0xa3,0xb3,0xb9,0xaa,0x68,0x22,0xb3,0x79,0xa9,0x0b, /* F.#z.2....h".y.. */ \
	0x7d,0xb7,0xa6,0x8b,0x32,0x1b,0x12,0x9d,0x16,0x05,0x79,0x05,0x4b,0x46,0x5a,0x69, /* }...2.....y.KFZi */ \
	0x96,0x32,0x1f,0xee,0xef,0x1d,0x1d,0xd1,0xad,0x94,0x5d,0xbd,0xb3,0xeb,0xa3,0x8b, /* .2........]..... */ \
	0x6b,0xba,0x75,0x22,0xbb,0xa7,0x5c,0x67,0xf5,0x42,0x96,0x4e,0x38,0xa5,0x4b,0x9a, /* k.u"..\g.B.N8.K. */ \
	0x69,0x43,0x85,0xca,0x64,0x69,0x25,0xa9,0x12,0x4f,0x0b,0xff,0x1e,0x28,0xfc,0x0f, /* iC..di%..O...(.. */ \
	0xa4,0x73,0xe9,0xa4,0x59,0xa8,0x52,0x5a,0x5a,0xcd,0x65,0x49,0x02,0x3b,0xbd,0xaf, /* .s..Y.RZZ.eI.;.. */ \
	0xa5,0x75,0xa4,0x2c,0x65,0xba,0xb4,0x2a,0x97,0x46,0xe6,0xd4,0x73,0x6a,0x81,0x8b, /* .u.,e....F..sj.. */ \
	0xae,0x5d,0x6f,0x7f,0x6f,0x29,0x0c,0xf1,0xf3,0x55,0xed,0x5e,0xdf,0xd2,0x98,0x9e, /* .]o.o)...U.^.... */ \
	0x8e,0x46,0xa3,0x13,0x3a,0x3a,0x5a,0xd8,0xfd,0x3d,0x0a,0x06,0x3a,0x0d,0x8b,0x81, /* .F..::Z..=..:... */ \
	0x06,0xac,0x5a,0x92,0x9e,0xd1,0xe9,0x6f,0xa7,0x6f,0x49,0x2e,0x61,0x99,0x25,0xa7, /* ..Z....o.oI.a.%. */ \
	0xa9,0x82,0xed,0xd2,0xda,0x80,0x25,0xde,0x89,0x0f,0x97,0x0a,0x7b,0x8e,0xa9,0x94, /* ......%.....{... */ \
	0x2b,0x3a,0x35,0x46,0xac,0xd3,0xfe,0x49,0x34,0xf1,0xa2,0x54,0x4e,0x09,0xe7,0xe1, /* +:5F...I4..TN... */ \
	0xfc,0x32,0x23,0x65,0x7a,0xb1,0x10,0x65,0xce,0x02,0x49,0x6d,0x8a,0x67,0xe4,0xe6  /* .2#ez..e..Im.g.. */
#define DATACHUNK000002 \
	0x92,0x70,0xc3,0xd8,0x22,0x0b,0xd0,0x58,0xc2,0x09,0x9c,0xc0,0xe9,0x4c,0x10,0x68, /* .p.."..X.....L.h */ \
	0xc8,0xa1,0x8b,0x73,0x16,0x9c,0xa9,0xa2,0x18,0x10,0x28,0x12,0x34,0xab,0xcb,0xcc, /* ...s......(.4... */ \
	0x33,0x86,0xd7,0x99,0x00,0xef,0x2b,0xe5,0xe6,0xcc,0x7a,0xa5,0x99,0xbb,0xb7,0xaf, /* 3.....+...z..... */ \
	0x2f,0x29,0xd5,0x15,0x4b,0x88,0xa2,0xef,0xa1,0x8d,0xac,0xa4,0x70,0xc0,0x35,0x38, /* /)..K.......p.58 */ \
	0x20,0xb4,0xc2,0x33,0xb6,0x61,0xe2,0x18,0x41,0x95,0xb9,0x9c,0x29,0x18,0x2f,0x8b, /*  ..3.a..A...)./. */ \
	0xf5,0xae,0x72,0x2e,0x9c,0x78,0x46,0xa2,0xa4,0x37,0x37,0x97,0x24,0xcb,0x4c,0xe7, /* ..r..xF..77.$.L. */ \
	0x20,0xd7,0x3a,0xa3,0xca,0x3b,0xc6,0x9a,0x4a,0xb2,0xf5,0x74,0xa1,0x9c,0xc3,0x6b, /*  .:..;..J..t...k */ \
	0x61,0xe9,0xfa,0xea,0x76,0x42,0xac,0xb3,0x85,0xd3,0xda,0x0c,0x56,0x98,0x94,0xb3, /* a...vB......V... */ \
	0xc0,0x49,0x0a,0x1a,0x06,0xd4,0x9e,0x7c,0x10,0x2d,0x1b,0x78,0x00,0xa8,0x7d,0xdc, /* .I.....|.-.x..}. */ \
	0xdf,0x4b,0x7c,0x0c,0x39,0xaa,0x2b,0x78,0xd4,0x90,0x9e,0xbe,0x93,0x99,0xc3,0x6b, /* .K|.9.+x.......k */ \
	0x76,0x06,0x83,0xc1,0x1f,0xd1,0x17,0x57,0x7e,0xc9,0x3b,0xc3,0xaf,0x82,0xc5,0x09, /* v......W~.;..... */ \
	0x3c,0x6f,0xe2,0xf2,0x39,0xfc,0x12,0x16,0xa3,0xda,0x90,0x7d,0x30,0x66,0x4f,0x74, /* <o..9......}0fOt */ \
	0x5f,0xb6,0xc6,0x60,0xa9,0xbd,0xef,0x0a,0x44,0xf2,0xc6,0xd1,0xd6,0xee,0x12,0x07, /* _..`....D....... */ \
	0xc7,0x8d,0x7c,0xcf,0x1b,0xd6,0x85,0x47,0x0d,0xf6,0x9f,0x19,0x08,0x4a,0x70,0x08, /* ..|....G.....Jp. */ \
	0xe2,0x24,0x7e,0xd8,0xbf,0x31,0x76,0x21,0xa0,0x66,0xe9,0x0a,0x0e,0xd0,0xab,0x21, /* .$~..1v!.f.....! */ \
	0x5c,0xf7,0xca,0xb9,0xea,0x26,0x2c,0xf5,0x09,0xc7,0xa7,0xf8,0xf7,0xc8,0x16,0x38, /* \....&,........8 */ \
	0xd3,0xb6,0x82,0x3f,0xdd,0x67,0x14,0x86,0xba,0x92,0x65,0x9a,0x32,0xaf,0xe3,0x31, /* ...?.g....e.2..1 */ \
	0x5b,0xd7,0xff,0xa5,0xf7,0xeb,0xcb,0x49,0xef,0x59,0x8f,0x1d,0xd6,0x1b,0x50,0x87, /* [......I.Y....P. */ \
	0x94,0x81,0x0f,0x94,0x2f,0x81,0xf1,0x29,0x3c,0x56,0x23,0xc4,0xb1,0x3f,0xa3,0x95, /* ..../..)<V#..?.. */ \
	0x3c,0x30,0x08,0x6d,0xcb,0xa1,0x71,0xf1,0xf2,0x67,0x44,0xc9,0xba,0x90,0x94,0x2e, /* <0.m..q..gD..... */ \
	0xc4,0x1a,0x51,0xf2,0x74,0xf8,0x94,0x53,0xa1,0x42,0x56,0x4f,0x0b,0x0e,0x43,0xdd, /* ..Q.t..S.BVO..C. */ \
	0x0f,0xba,0x0f,0x24,0x0b,0xce,0xf9,0x96,0x86,0x53,0x84,0xca,0x52,0xbe,0x0d,0xfe, /* ...$.....S..R... */ \
	0xfc,0x0a,0x16,0xb6,0xe4,0xd3,0x9e,0xaf,0x36,0x56,0xcf,0x9c,0xe7,0x73,0x32,0xb9, /* ........6V...s2. */ \
	0xee,0x75,0x8f,0x82,0x6d,0x76,0x50,0xb6,0x76,0xf8,0xee,0xd4,0x7d,0x15,0x7d,0x9e, /* .u..mvP.v...}.}. */ \
	0x86,0xc8,0x46,0xb8,0x84,0xdf,0x46,0xb1,0x10,0xd6,0x9d,0x21,0x51,0x91,0x62,0xe3, /* ..F...F....!Q.b. */ \
	0x36,0xae,0x87,0x77,0xd2,0xf1,0x4d,0xeb,0xf6,0xd6,0x15,0xbe,0xa4,0x21,0xa9,0x7d, /* 6..w..M......!.} */ \
	0xc6,0x08,0x2e,0x51,0x61,0xa9,0x29,0x5e,0xc3,0xaa,0xb6,0xf3,0x86,0x06,0xd6,0x7e, /* ...Qa.)^.......~ */ \
	0x88,0xf5,0xeb,0x52,0xeb,0xca,0x92,0x5e,0x22,0xfa,0xb9,0x2c,0xe0,0xdc,0x39,0xfb, /* ...R...^"..,..9. */ \
	0x72,0xa7,0x20,0xe6,0x4d,0x21,0x06,0x99,0x08,0xea,0x35,0xaa,0x98,0xcf,0x6d,0x65, /* r. .M!....5...me */ \
	0x7d,0x54,0x2b,0x14,0xe1,0x4e,0xc6,0x57,0xba,0x28,0x18,0x20,0x05,0xcf,0x49,0x4c, /* }T+..N.W.(. ..IL */ \
	0xcd,0xac,0x36,0xff,0x25,0x71,0x79,0x51,0x16,0xa2,0xb2,0x32,0xdf,0x24,0xd7,0x8d, /* ..6.%qyQ...2.$.. */ \
	0x14,0x28,0xf6,0xb3,0x99,0xcf,0xaa,0xb6,0x3c,0x87,0x3a,0x81,0xb3,0xc0,0xca,0xe9, /* .(......<.:..... */ \
	0x9a,0x2f,0x90,0x46,0x53,0x49,0x15,0x50,0x5b,0x1e,0x0a,0x59,0xde,0xb9,0xf9,0x09, /* ./.FSI.P[..Y.... */ \
	0x29,0x7a,0x4e,0x68,0x0b,0xea,0xf0,0x10,0x31,0x99,0x70,0xd5,0x49,0x36,0x26,0xb6, /* )zNh....1.p.I6&. */ \
	0xd2,0x76,0xae,0x66,0xd1,0x4c,0x4e,0xda,0x1f,0xa2,0x08,0xab,0x24,0xbe,0x7c,0xab, /* .v.f.LN.....$.|. */ \
	0xb2,0x96,0x7e,0x35,0x1a,0xf9,0xa8,0xb3,0xe8,0xb0,0x39,0x7e,0xc7,0xad,0x5e,0x2b, /* ..~5......9~..^+ */ \
	0xe1,0x13,0x25,0x4d,0x2a,0xa1,0xac,0x66,0x52,0xe6,0xcc,0xa5,0xdf,0xae,0x51,0x6a, /* ..%M...fR.....Qj */ \
	0x82,0x08,0x35,0x25,0x5f,0xa3,0x91,0xa2,0xb0,0x8c,0xc7,0xf4,0x13,0xfd,0xf8,0x23, /* ..5%_..........# */ \
	0xed,0x8a,0x58,0xac,0xd6,0x96,0x97,0xd1,0xc3,0x7d,0x98,0x27,0x0d,0xbe,0x72,0x34, /* ..X......}.'..r4 */ \
	0x17,0xdc,0xa6,0x3a,0xc5,0x77,0x65,0xd0,0x00,0x62,0x71,0xb2,0x75,0xe1,0xbc,0x38, /* ...:.we..bq.u..8 */ \
	0x76,0x76,0xeb,0x4a,0xea,0x8d,0x01,0xad,0x46,0x9f,0x91,0x0f,0x1a,0x47,0x1f,0xf4, /* vv.J....F....G.. */ \
	0x03,0x7e,0xf2,0x89,0xdc,0x23,0xa6,0x87,0x5e,0x85,0xfc,0x1c,0x36,0x7d,0xee,0x65, /* .~...#..^...6}.e */ \
	0x21,0xf9,0x12,0xd8,0x4d,0x36,0x35,0xe1,0xcb,0x9b,0x87,0x3e,0x74,0xd0,0x9c,0x2d, /* !...M65....>t..- */ \
	0x69,0xd0,0x98,0xee,0x88,0xf8,0x62,0x7d,0x91,0x3f,0xa2,0x3e,0x54,0x25,0x2e,0xaf, /* i.....b}.?.>T%.. */ \
	0x26,0xe8,0x96,0xe3,0x4f,0x88,0x6b,0x0c,0x9c,0xc8,0x0f,0xae,0x31,0x08,0xbc,0xa5, /* &...O.k.....1... */ \
	0x1a,0xe4,0x98,0x95,0xb2,0xdc,0x9e,0xa9,0xc4,0x13,0x67,0x07,0x0f,0x2e,0x5c,0x16, /* ..........g...\. */ \
	0x68,0x29,0x0a,0x94,0xe1,0x10,0x0e,0xf8,0xe1,0x8c,0x4b,0x76,0x91,0xc5,0x54,0x9b, /* h)........Kv..T. */ \
	0x18,0x43,0x8f,0xad,0x6f,0x5a,0xc7,0x96,0xaf,0x0e,0xac,0x9f,0x76,0xb8,0xdf,0x08, /* .C..oZ......v... */ \
	0x2e,0x9e,0xb1,0x79,0x0c,0xd8,0x59,0x25,0xdb,0x62,0x75,0xe3,0xac,0x06,0x30,0x48, /* ...y..Y%.bu...0H */ \
	0x07,0x63,0x92,0x9d,0xae,0xdb,0xc8,0x84,0xee,0xbb,0x4b,0xcd,0xe6,0x55,0xc4,0x38, /* .c........K..U.8 */ \
	0xf9,0x34,0xc0,0x1f,0xf8,0xa7,0x1b,0xad,0x07,0x4b,0x49,0x2b,0xa1,0x78,0x08,0xf0, /* .4.......KI+.x.. */ \
	0xe5,0xe3,0x18,0x9d,0x0e,0x1a,0x79,0x34,0x11,0xe1,0xdc,0x4e,0x65,0x31,0x9e,0x9b, /* ......y4...Ne1.. */ \
	0x1c,0x79,0xbe,0x99,0xcf,0xba,0x21,0x5a,0x2e,0xf5,0x7d,0x08,0xc6,0x1a,0xe3,0xe4, /* .y....!Z..}..... */ \
	0x66,0xe8,0xf1,0xc3,0x8e,0xa7,0x5b,0x95,0x55,0xfd,0xfd,0x62,0xd4,0x17,0xf6,0xad, /* f.....[.U..b.... */ \
	0xe0,0x8b,0xa2,0x30,0xe6,0xb4,0x90,0xc6,0xb5,0xb6,0x84,0xd7,0x82,0xdf,0xa5,0xbd, /* ...0............ */ \
	0x48,0x29,0xcd,0x84,0x42,0x1a,0x0f,0xff,0x2a,0xcf,0x34,0xe2,0xaa,0x9d,0xcf,0x72, /* H)..B.....4....r */ \
	0x54,0xcd,0x42,0x57,0x7e,0x90,0x9b,0x6a,0x61,0x72,0x90,0x64,0xa9,0xd0,0xa8,0x26, /* T.BW~..jar.d...& */ \
	0xbd,0x66,0x37,0xef,0xeb,0x6f,0x0b,0x96,0x58,0x3a,0xfe,0x1f,0xf1,0x72,0xd5,0x24, /* .f7..o..X:...r.$ */ \
	0xd1,0x80,0xde,0xd5,0x28,0xd5,0xf7,0x52,0x56,0x3e,0x76,0x90,0x4c,0x2c,0xb2,0xdd, /* ....(..RV>v.L,.. */ \
	0xa5,0x9a,0x22,0xcb,0x30,0x0f,0x9b,0x89,0x8a,0xdb,0x13,0xba,0x9b,0x95,0xc5,0x92, /* ..".0........... */ \
	0xa7,0xed,0x3b,0x58,0xc2,0x0d,0xef,0x78,0xc4,0x83,0x7d,0x62,0x43,0xb1,0x45,0xb0, /* ..;X...x..}bC.E. */ \
	0xa5,0xbd,0x4d,0xff,0xe9,0x0d,0x8e,0x47,0xfd,0xd0,0x38,0x1e,0x22,0x67,0x80,0xba, /* ..M....G..8."g.. */ \
	0x16,0x40,0xb1,0xde,0xbb,0x1f,0x16,0xc5,0x4d,0x33,0x46,0x1b,0xe9,0x6a,0x53,0x22, /* .@......M3F..jS" */ \
	0x3e,0xd1,0x3d,0x30,0xfc,0xc6,0x51,0x22,0x4e,0x5a,0xed,0x18,0x8a,0xf9,0x18,0x4a  /* >.=0..Q"NZ.....J */
#define DATACHUNK000003 \
	0xe7,0x7e,0x44,0x8e,0x08,0xfc,0xd0,0x6a,0xfb,0x1d,0x30,0xbc,0xcb,0x22,0x0f,0x02, /* .~D....j..0..".. */ \
	0xfe,0x96,0x23,0xc3,0x4a,0x61,0xb2,0x39,0x17,0x8f,0x4e,0xaf,0x44,0xd5,0xc2,0x46, /* ..#.Ja.9..N.D..F */ \
	0x7f,0x70,0x1d,0x49,0x23,0xd4,0x20,0xa8,0x84,0xd4,0x70,0x66,0x1d,0xc2,0x12,0x8e, /* .p.I#. ...pf.... */ \
	0x8b,0xeb,0x9d,0x4a,0x67,0x5f,0xac,0x27,0xe2,0xee,0x77,0x81,0x2e,0x13,0x74,0xfe, /* ...Jg_.'..w...t. */ \
	0x1c,0xfd,0x3d,0x9c,0x29,0x83,0x26,0x33,0x57,0x45,0x3e,0x2c,0x31,0xba,0x7b,0xec, /* ..=.).&3WE>,1.{. */ \
	0xe0,0xe5,0x60,0x23,0x7d,0x03,0x4e,0xec,0x75,0x56,0x76,0xf1,0x9a,0x90,0x7c,0xc0, /* ..`#}.N.uVv...|. */ \
	0xa7,0x85,0xcb,0xe6,0xa9,0x34,0x48,0xc2,0x8f,0xd4,0x5d,0xe5,0x21,0x27,0x8e,0x1c, /* .....4H...].!'.. */ \
	0xf7,0x0a,0x1f,0x82,0x4d,0xf7,0xf6,0x73,0xc6,0x9b,0x0a,0x93,0x11,0x67,0xd9,0xe7, /* ....M..s.....g.. */ \
	0x9c,0x88,0x4f,0xb8,0xf0,0xc1,0xf5,0x2f,0xde,0xe8,0x9b,0x2d,0xa8,0x0e,0x00,0x00, /* ..O..../...-.... */ \
	0x3c,0x64,0x69,0x76,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x73,0x70,0x61,0x63, /* <div class="spac */ \
	0x65,0x72,0x22,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x64,0x69,0x76,0x3e, /* er">&nbsp;</div> */ \
	0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x66,0x6f,0x6f,0x74,0x65, /* ..<div id="foote */ \
	0x72,0x22,0x3e,0x43,0x6f,0x70,0x79,0x72,0x69,0x67,0x68,0x74,0x20,0x26,0x63,0x6f, /* r">Copyright &co */ \
	0x70,0x79,0x3b,0x20,0x32,0x30,0x31,0x31,0x20,0x53,0x61,0x74,0x6f,0x73,0x68,0x69, /* py; 2011 Satoshi */ \
	0x20,0x59,0x61,0x73,0x75,0x64,0x61,0x20,0x37,0x6d,0x33,0x74,0x6a,0x7a,0x2f,0x61, /*  Yasuda 7m3tjz/a */ \
	0x64,0x36,0x67,0x7a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x2f, /* d6gz</div>....</ */ \
	0x64,0x69,0x76,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e, /* div></div></div> */ \
	0x3c,0x2f,0x64,0x69,0x76,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a, /* </div></div>.... */ \
	0x3c,0x2f,0x62,0x6f,0x64,0x79,0x3e,0x0d,0x0a,0x3c,0x2f,0x68,0x74,0x6d,0x6c,0x3e, /* </body>..</html> */ \
	0x3c,0x21,0x44,0x4f,0x43,0x54,0x59,0x50,0x45,0x20,0x68,0x74,0x6d,0x6c,0x20,0x50, /* <!DOCTYPE html P */ \
	0x55,0x42,0x4c,0x49,0x43,0x20,0x22,0x2d,0x2f,0x2f,0x57,0x33,0x43,0x2f,0x2f,0x44, /* UBLIC "-//W3C//D */ \
	0x54,0x44,0x20,0x58,0x48,0x54,0x4d,0x4c,0x20,0x31,0x2e,0x30,0x20,0x53,0x74,0x72, /* TD XHTML 1.0 Str */ \
	0x69,0x63,0x74,0x2f,0x2f,0x45,0x4e,0x22,0x0d,0x0a,0x20,0x20,0x22,0x68,0x74,0x74, /* ict//EN"..  "htt */ \
	0x70,0x3a,0x2f,0x2f,0x77,0x77,0x77,0x2e,0x77,0x33,0x2e,0x6f,0x72,0x67,0x2f,0x54, /* p://www.w3.org/T */ \
	0x52,0x2f,0x78,0x68,0x74,0x6d,0x6c,0x31,0x2f,0x44,0x54,0x44,0x2f,0x78,0x68,0x74, /* R/xhtml1/DTD/xht */ \
	0x6d,0x6c,0x31,0x2d,0x73,0x74,0x72,0x69,0x63,0x74,0x2e,0x64,0x74,0x64,0x22,0x3e, /* ml1-strict.dtd"> */ \
	0x0d,0x0a,0x3c,0x68,0x74,0x6d,0x6c,0x20,0x78,0x6d,0x6c,0x6e,0x73,0x3d,0x22,0x68, /* ..<html xmlns="h */ \
	0x74,0x74,0x70,0x3a,0x2f,0x2f,0x77,0x77,0x77,0x2e,0x77,0x33,0x2e,0x6f,0x72,0x67, /* ttp://www.w3.org */ \
	0x2f,0x31,0x39,0x39,0x39,0x2f,0x78,0x68,0x74,0x6d,0x6c,0x22,0x20,0x78,0x6d,0x6c, /* /1999/xhtml" xml */ \
	0x3a,0x6c,0x61,0x6e,0x67,0x3d,0x22,0x65,0x6e,0x22,0x20,0x6c,0x61,0x6e,0x67,0x3d, /* :lang="en" lang= */ \
	0x22,0x65,0x6e,0x22,0x3e,0x0d,0x0a,0x3c,0x68,0x65,0x61,0x64,0x3e,0x0d,0x0a,0x3c, /* "en">..<head>..< */ \
	0x74,0x69,0x74,0x6c,0x65,0x3e,0x44,0x2d,0x53,0x54,0x41,0x52,0x20,0x64,0x53,0x71, /* title>D-STAR dSq */ \
	0x75,0x72,0x65,0x20,0x43,0x6c,0x69,0x65,0x6e,0x74,0x20,0x50,0x72,0x6f,0x67,0x72, /* ure Client Progr */ \
	0x61,0x6d,0x3c,0x2f,0x74,0x69,0x74,0x6c,0x65,0x3e,0x0d,0x0a,0x3c,0x6c,0x69,0x6e, /* am</title>..<lin */ \
	0x6b,0x20,0x68,0x72,0x65,0x66,0x3d,0x22,0x2f,0x37,0x6d,0x33,0x74,0x6a,0x7a,0x2e, /* k href="/7m3tjz. */ \
	0x63,0x73,0x73,0x22,0x20,0x72,0x65,0x6c,0x3d,0x22,0x73,0x74,0x79,0x6c,0x65,0x73, /* css" rel="styles */ \
	0x68,0x65,0x65,0x74,0x22,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74, /* heet" type="text */ \
	0x2f,0x63,0x73,0x73,0x22,0x20,0x2f,0x3e,0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69,0x70, /* /css" />..<scrip */ \
	0x74,0x20,0x73,0x72,0x63,0x3d,0x22,0x2f,0x37,0x6d,0x33,0x74,0x6a,0x7a,0x2e,0x6a, /* t src="/7m3tjz.j */ \
	0x73,0x22,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x2f,0x6a,0x61, /* s" type="text/ja */ \
	0x76,0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x3c,0x2f,0x73,0x63,0x72,0x69, /* vascript"></scri */ \
	0x70,0x74,0x3e,0x0d,0x0a,0x3c,0x2f,0x68,0x65,0x61,0x64,0x3e,0x0d,0x0a,0x0d,0x0a, /* pt>..</head>.... */ \
	0x3c,0x62,0x6f,0x64,0x79,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d, /* <body>..<div id= */ \
	0x22,0x73,0x68,0x61,0x64,0x6f,0x77,0x2d,0x6f,0x6e,0x65,0x22,0x3e,0x3c,0x64,0x69, /* "shadow-one"><di */ \
	0x76,0x20,0x69,0x64,0x3d,0x22,0x73,0x68,0x61,0x64,0x6f,0x77,0x2d,0x74,0x77,0x6f, /* v id="shadow-two */ \
	0x22,0x3e,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x73,0x68,0x61,0x64,0x6f, /* "><div id="shado */ \
	0x77,0x2d,0x74,0x68,0x72,0x65,0x65,0x22,0x3e,0x3c,0x64,0x69,0x76,0x20,0x69,0x64, /* w-three"><div id */ \
	0x3d,0x22,0x73,0x68,0x61,0x64,0x6f,0x77,0x2d,0x66,0x6f,0x75,0x72,0x22,0x3e,0x0d, /* ="shadow-four">. */ \
	0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x70,0x61,0x67,0x65,0x22,0x3e, /* .<div id="page"> */ \
	0x0d,0x0a,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x74,0x69,0x74, /* ....<div id="tit */ \
	0x6c,0x65,0x22,0x3e,0x3c,0x64,0x69,0x76,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22, /* le"><div class=" */ \
	0x72,0x69,0x67,0x68,0x74,0x22,0x3e,0x44,0x2d,0x53,0x54,0x41,0x52,0x20,0x64,0x53, /* right">D-STAR dS */ \
	0x71,0x75,0x72,0x65,0x20,0x43,0x6c,0x69,0x65,0x6e,0x74,0x20,0x56,0x30,0x30,0x2e, /* qure Client V00. */ \
	0x31,0x33,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x3c,0x73,0x70,0x61,0x6e,0x20,0x69,0x64, /* 13</div><span id */ \
	0x3d,0x22,0x68,0x65,0x6c,0x6c,0x6f,0x22,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c, /* ="hello">&nbsp;< */ \
	0x2f,0x73,0x70,0x61,0x6e,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a, /* /span></div>.... */ \
	0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x6d,0x65,0x6e,0x75,0x22,0x3e,0x0d, /* <div id="menu">. */ \
	0x0a,0x3c,0x61,0x20,0x68,0x72,0x65,0x66,0x3d,0x22,0x2f,0x69,0x6e,0x64,0x65,0x78, /* .<a href="/index */ \
	0x2e,0x68,0x74,0x6d,0x22,0x3e,0x4f,0x76,0x65,0x72,0x76,0x69,0x65,0x77,0x3c,0x2f, /* .htm">Overview</ */ \
	0x61,0x3e,0x0d,0x0a,0x3c,0x61,0x20,0x68,0x72,0x65,0x66,0x3d,0x22,0x2f,0x70,0x72, /* a>..<a href="/pr */ \
	0x6f,0x74,0x65,0x63,0x74,0x2f,0x63,0x6f,0x6e,0x66,0x69,0x67,0x2e,0x68,0x74,0x6d, /* otect/config.htm */ \
	0x22,0x3e,0x4e,0x65,0x74,0x77,0x6f,0x72,0x6b,0x20,0x43,0x6f,0x6e,0x66,0x69,0x67, /* ">Network Config */ \
	0x75,0x72,0x61,0x74,0x69,0x6f,0x6e,0x3c,0x2f,0x61,0x3e,0x0d,0x0a,0x3c,0x61,0x20, /* uration</a>..<a  */ \
	0x68,0x72,0x65,0x66,0x3d,0x22,0x2f,0x6e,0x6f,0x64,0x65,0x61,0x64,0x61,0x70,0x74  /* href="/nodeadapt */
#define DATACHUNK000004 \
	0x65,0x72,0x2f,0x63,0x6f,0x6e,0x66,0x69,0x67,0x2e,0x68,0x74,0x6d,0x22,0x3e,0x4e, /* er/config.htm">N */ \
	0x6f,0x64,0x65,0x20,0x41,0x64,0x61,0x70,0x74,0x65,0x72,0x20,0x43,0x6f,0x6e,0x66, /* ode Adapter Conf */ \
	0x69,0x67,0x75,0x72,0x61,0x74,0x69,0x6f,0x6e,0x3c,0x2f,0x61,0x3e,0x0d,0x0a,0x3c, /* iguration</a>..< */ \
	0x61,0x20,0x68,0x72,0x65,0x66,0x3d,0x22,0x2f,0x6e,0x6f,0x64,0x65,0x61,0x64,0x61, /* a href="/nodeada */ \
	0x70,0x74,0x65,0x72,0x2f,0x63,0x6f,0x6e,0x66,0x69,0x67,0x32,0x2e,0x68,0x74,0x6d, /* pter/config2.htm */ \
	0x22,0x3e,0x42,0x65,0x61,0x63,0x6f,0x6e,0x20,0x43,0x6f,0x6e,0x66,0x69,0x67,0x75, /* ">Beacon Configu */ \
	0x72,0x61,0x74,0x69,0x6f,0x6e,0x3c,0x2f,0x61,0x3e,0x0d,0x0a,0x3c,0x61,0x20,0x68, /* ration</a>..<a h */ \
	0x72,0x65,0x66,0x3d,0x22,0x2f,0x6e,0x6f,0x64,0x65,0x61,0x64,0x61,0x70,0x74,0x65, /* ref="/nodeadapte */ \
	0x72,0x2f,0x63,0x6f,0x6e,0x66,0x69,0x67,0x33,0x2e,0x68,0x74,0x6d,0x22,0x3e,0x54, /* r/config3.htm">T */ \
	0x58,0x20,0x48,0x65,0x61,0x64,0x65,0x72,0x20,0x52,0x65,0x70,0x6c,0x61,0x63,0x65, /* X Header Replace */ \
	0x20,0x43,0x6f,0x6e,0x66,0x69,0x67,0x75,0x72,0x61,0x74,0x69,0x6f,0x6e,0x3c,0x2f, /*  Configuration</ */ \
	0x61,0x3e,0x0d,0x0a,0x3c,0x61,0x20,0x68,0x72,0x65,0x66,0x3d,0x22,0x2f,0x70,0x72, /* a>..<a href="/pr */ \
	0x6f,0x74,0x65,0x63,0x74,0x2f,0x75,0x73,0x65,0x72,0x2e,0x68,0x74,0x6d,0x22,0x3e, /* otect/user.htm"> */ \
	0x55,0x73,0x65,0x72,0x20,0x49,0x44,0x20,0x26,0x20,0x50,0x61,0x73,0x73,0x77,0x6f, /* User ID & Passwo */ \
	0x72,0x64,0x20,0x73,0x65,0x74,0x74,0x69,0x6e,0x67,0x3c,0x2f,0x61,0x3e,0x0d,0x0a, /* rd setting</a>.. */ \
	0x3c,0x61,0x20,0x68,0x72,0x65,0x66,0x3d,0x22,0x2f,0x73,0x74,0x61,0x74,0x75,0x73, /* <a href="/status */ \
	0x2e,0x68,0x74,0x6d,0x22,0x3e,0x43,0x75,0x72,0x72,0x65,0x6e,0x74,0x20,0x53,0x74, /* .htm">Current St */ \
	0x61,0x74,0x75,0x73,0x3c,0x2f,0x61,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e, /* atus</a>..</div> */ \
	0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e, /* ~inc:header.inc~ */ \
	0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65, /* ..<div id="conte */ \
	0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x44,0x2d,0x53,0x54, /* nt">....<h1>D-ST */ \
	0x41,0x52,0x20,0x64,0x53,0x71,0x75,0x72,0x65,0x20,0x43,0x6c,0x69,0x65,0x6e,0x74, /* AR dSqure Client */ \
	0x3c,0x2f,0x68,0x31,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x74,0x61,0x62,0x6c,0x65,0x20, /* </h1>....<table  */ \
	0x73,0x74,0x79,0x6c,0x65,0x3d,0x22,0x70,0x61,0x64,0x64,0x69,0x6e,0x67,0x2d,0x6c, /* style="padding-l */ \
	0x65,0x66,0x74,0x3a,0x20,0x31,0x30,0x70,0x78,0x3b,0x22,0x3e,0x0d,0x0a,0x3c,0x74, /* eft: 10px;">..<t */ \
	0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x64,0x53,0x71,0x75,0x72,0x65,0x20, /* r><td><b>dSqure  */ \
	0x53,0x65,0x72,0x76,0x65,0x72,0x20,0x44,0x6f,0x6d,0x61,0x69,0x6e,0x20,0x4e,0x61, /* Server Domain Na */ \
	0x6d,0x65,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64, /* me :</b></td><td */ \
	0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e, /* >&nbsp;</td><td> */ \
	0x7e,0x73,0x65,0x72,0x76,0x65,0x72,0x5f,0x6e,0x61,0x6d,0x65,0x7e,0x3c,0x2f,0x74, /* ~server_name~</t */ \
	0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64, /* d></tr>..<tr><td */ \
	0x3e,0x3c,0x62,0x3e,0x4f,0x75,0x74,0x20,0x62,0x6f,0x75,0x6e,0x64,0x20,0x50,0x6f, /* ><b>Out bound Po */ \
	0x72,0x74,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64, /* rt :</b></td><td */ \
	0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e, /* >&nbsp;</td><td> */ \
	0x7e,0x6f,0x75,0x74,0x5f,0x70,0x6f,0x72,0x74,0x7e,0x3c,0x2f,0x74,0x64,0x3e,0x3c, /* ~out_port~</td>< */ \
	0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62, /* /tr>..<tr><td><b */ \
	0x3e,0x49,0x6e,0x20,0x62,0x6f,0x75,0x6e,0x64,0x20,0x50,0x6f,0x72,0x74,0x20,0x3a, /* >In bound Port : */ \
	0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62, /* </b></td><td>&nb */ \
	0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x69,0x6e,0x5f, /* sp;</td><td>~in_ */ \
	0x70,0x6f,0x72,0x74,0x7e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d, /* port~</td></tr>. */ \
	0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x43,0x6f,0x6e,0x66, /* .<tr><td><b>Conf */ \
	0x65,0x72,0x65,0x6e,0x63,0x65,0x20,0x52,0x6f,0x6f,0x6d,0x20,0x4e,0x61,0x6d,0x65, /* erence Room Name */ \
	0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26, /*  :</b></td><td>& */ \
	0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x52, /* nbsp;</td><td>~R */ \
	0x6f,0x6f,0x6d,0x4e,0x61,0x6d,0x65,0x7e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74, /* oomName~</td></t */ \
	0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x4e, /* r>..<tr><td><b>N */ \
	0x6f,0x64,0x65,0x20,0x43,0x61,0x6c,0x6c,0x73,0x69,0x67,0x6e,0x20,0x3a,0x3c,0x2f, /* ode Callsign :</ */ \
	0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73,0x70, /* b></td><td>&nbsp */ \
	0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x4e,0x6f,0x64,0x65,0x4e, /* ;</td><td>~NodeN */ \
	0x61,0x6d,0x65,0x7e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a, /* ame~</td></tr>.. */ \
	0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x41,0x63,0x63,0x65,0x73, /* <tr><td><b>Acces */ \
	0x73,0x20,0x43,0x6f,0x6e,0x74,0x72,0x6f,0x6c,0x20,0x46,0x69,0x6c,0x65,0x20,0x4e, /* s Control File N */ \
	0x61,0x6d,0x65,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74, /* ame :</b></td><t */ \
	0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64, /* d>&nbsp;</td><td */ \
	0x3e,0x7e,0x41,0x63,0x63,0x43,0x74,0x72,0x6c,0x7e,0x3c,0x2f,0x74,0x64,0x3e,0x3c, /* >~AccCtrl~</td>< */ \
	0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62, /* /tr>..<tr><td><b */ \
	0x3e,0x4e,0x54,0x50,0x20,0x53,0x65,0x72,0x76,0x65,0x72,0x20,0x44,0x6f,0x6d,0x61, /* >NTP Server Doma */ \
	0x69,0x6e,0x20,0x4e,0x61,0x6d,0x65,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74, /* in Name :</b></t */ \
	0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64, /* d><td>&nbsp;</td */ \
	0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x4e,0x74,0x70,0x4e,0x61,0x6d,0x65,0x7e,0x3c,0x2f, /* ><td>~NtpName~</ */ \
	0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74, /* td></tr>..<tr><t */ \
	0x64,0x3e,0x3c,0x62,0x3e,0x54,0x69,0x6d,0x65,0x20,0x5a,0x6f,0x6e,0x65,0x20,0x3a, /* d><b>Time Zone : */ \
	0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62, /* </b></td><td>&nb */ \
	0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x54,0x69,0x6d  /* sp;</td><td>~Tim */
#define DATACHUNK000005 \
	0x65,0x5a,0x6f,0x6e,0x65,0x7e,0x20,0x26,0x6e,0x62,0x73,0x70,0x3b,0x68,0x6f,0x75, /* eZone~ &nbsp;hou */ \
	0x72,0x73,0x26,0x6e,0x62,0x73,0x70,0x3b,0x7e,0x54,0x69,0x6d,0x65,0x5a,0x6f,0x6e, /* rs&nbsp;~TimeZon */ \
	0x65,0x4d,0x69,0x6e,0x75,0x74,0x65,0x73,0x7e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x6d, /* eMinutes~&nbsp;m */ \
	0x69,0x6e,0x75,0x74,0x65,0x73,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e, /* inutes</td></tr> */ \
	0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x4a,0x69,0x74, /* ..<tr><td><b>Jit */ \
	0x74,0x65,0x72,0x20,0x42,0x75,0x66,0x66,0x65,0x72,0x20,0x57,0x61,0x69,0x74,0x20, /* ter Buffer Wait  */ \
	0x50,0x61,0x63,0x6b,0x65,0x74,0x73,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64, /* Packets:</b></td */ \
	0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e, /* ><td>&nbsp;</td> */ \
	0x3c,0x74,0x64,0x3e,0x7e,0x4a,0x69,0x74,0x74,0x65,0x72,0x53,0x69,0x7a,0x65,0x7e, /* <td>~JitterSize~ */ \
	0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x2f,0x74,0x61, /* </td></tr>..</ta */ \
	0x62,0x6c,0x65,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a, /* ble>....</div>.. */ \
	0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22, /* ..<script type=" */ \
	0x74,0x65,0x78,0x74,0x2f,0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22, /* text/javascript" */ \
	0x3e,0x0d,0x0a,0x3c,0x21,0x2d,0x2d,0x0d,0x0a,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e, /* >..<!--..documen */ \
	0x74,0x2e,0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64, /* t.getElementById */ \
	0x28,0x27,0x68,0x65,0x6c,0x6c,0x6f,0x27,0x29,0x2e,0x69,0x6e,0x6e,0x65,0x72,0x48, /* ('hello').innerH */ \
	0x54,0x4d,0x4c,0x20,0x3d,0x20,0x22,0x7e,0x68,0x65,0x6c,0x6c,0x6f,0x6d,0x73,0x67, /* TML = "~hellomsg */ \
	0x7e,0x22,0x3b,0x0d,0x0a,0x2f,0x2f,0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63, /* ~";..//-->..</sc */ \
	0x72,0x69,0x70,0x74,0x3e,0x0d,0x0a,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f, /* ript>....~inc:fo */ \
	0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x00,0x00,0x00,0x00,0x33, /* oter.inc~......3 */ \
	0x00,0x00,0x00,0xb0,0x00,0x00,0x00,0x4a,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x4b, /* .......J.......K */ \
	0x00,0x00,0x00,0x4c,0x01,0x00,0x00,0x4c,0x00,0x00,0x00,0x9e,0x01,0x00,0x00,0x4d, /* ...L...L.......M */ \
	0x00,0x00,0x00,0xea,0x01,0x00,0x00,0x4e,0x00,0x00,0x00,0x41,0x02,0x00,0x00,0x5f, /* .......N...A..._ */ \
	0x00,0x00,0x00,0x95,0x02,0x00,0x00,0x60,0x00,0x00,0x00,0xdc,0x02,0x00,0x00,0x61, /* .......`.......a */ \
	0x00,0x00,0x00,0xf8,0x02,0x00,0x00,0x6d,0x00,0x00,0x00,0x64,0x03,0x00,0x00,0x6e, /* .......m...d...n */ \
	0x00,0x00,0x00,0xe7,0x03,0x00,0x00,0x01,0x00,0x00,0x00,0x09,0x04,0x00,0x00,0x02, /* ................ */ \
	0x00,0x00,0x00,0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69, /* ...~inc:header.i */ \
	0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x63,0x6f, /* nc~..<div id="co */ \
	0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x44, /* ntent">....<h1>D */ \
	0x2d,0x53,0x54,0x41,0x52,0x20,0x64,0x53,0x71,0x75,0x72,0x65,0x20,0x53,0x74,0x61, /* -STAR dSqure Sta */ \
	0x74,0x75,0x73,0x3c,0x2f,0x68,0x31,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x74,0x61,0x62, /* tus</h1>....<tab */ \
	0x6c,0x65,0x20,0x73,0x74,0x79,0x6c,0x65,0x3d,0x22,0x70,0x61,0x64,0x64,0x69,0x6e, /* le style="paddin */ \
	0x67,0x2d,0x6c,0x65,0x66,0x74,0x3a,0x20,0x31,0x30,0x70,0x78,0x3b,0x22,0x3e,0x0d, /* g-left: 10px;">. */ \
	0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x44,0x61,0x74,0x65, /* .<tr><td><b>Date */ \
	0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26, /*  :</b></td><td>& */ \
	0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x43, /* nbsp;</td><td>~C */ \
	0x75,0x72,0x44,0x61,0x74,0x65,0x7e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72, /* urDate~</td></tr */ \
	0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x54,0x69, /* >..<tr><td><b>Ti */ \
	0x6d,0x65,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64, /* me :</b></td><td */ \
	0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e, /* >&nbsp;</td><td> */ \
	0x7e,0x43,0x75,0x72,0x54,0x69,0x6d,0x65,0x7e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f, /* ~CurTime~</td></ */ \
	0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e, /* tr>..<tr><td><b> */ \
	0x50,0x54,0x54,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74, /* PTT :</b></td><t */ \
	0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64, /* d>&nbsp;</td><td */ \
	0x3e,0x7e,0x43,0x75,0x72,0x50,0x54,0x54,0x7e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f, /* >~CurPTT~</td></ */ \
	0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e, /* tr>..<tr><td><b> */ \
	0x43,0x4f,0x53,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74, /* COS :</b></td><t */ \
	0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64, /* d>&nbsp;</td><td */ \
	0x3e,0x7e,0x43,0x75,0x72,0x43,0x4f,0x53,0x7e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f, /* >~CurCOS~</td></ */ \
	0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e, /* tr>..<tr><td><b> */ \
	0x4e,0x6f,0x64,0x65,0x20,0x55,0x73,0x65,0x72,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c, /* Node User :</b>< */ \
	0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f, /* /td><td>&nbsp;</ */ \
	0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x43,0x75,0x72,0x55,0x73,0x65,0x72,0x7e, /* td><td>~CurUser~ */ \
	0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e, /* </td></tr>..<tr> */ \
	0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x53,0x53,0x4e,0x20,0x3a,0x3c,0x2f,0x62,0x3e, /* <td><b>SSN :</b> */ \
	0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c, /* </td><td>&nbsp;< */ \
	0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x43,0x75,0x72,0x53,0x53,0x4e,0x7e, /* /td><td>~CurSSN~ */ \
	0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x2f,0x74,0x61, /* </td></tr>..</ta */ \
	0x62,0x6c,0x65,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a, /* ble>....</div>.. */ \
	0x3c,0x2f,0x62,0x6f,0x64,0x79,0x3e,0x0d,0x0a,0x3c,0x6d,0x65,0x74,0x61,0x20,0x68, /* </body>..<meta h */ \
	0x74,0x74,0x70,0x2d,0x65,0x71,0x75,0x69,0x76,0x3d,0x22,0x72,0x65,0x66,0x72,0x65, /* ttp-equiv="refre */ \
	0x73,0x68,0x22,0x20,0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x3d,0x22,0x31,0x30,0x22, /* sh" content="10" */ \
	0x3e,0x0d,0x0a,0x3c,0x62,0x6f,0x64,0x79,0x3e,0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69, /* >..<body>..<scri */ \
	0x70,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x2f,0x6a,0x61  /* pt type="text/ja */
#define DATACHUNK000006 \
	0x76,0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x0d,0x0a,0x3c,0x21,0x2d,0x2d, /* vascript">..<!-- */ \
	0x0d,0x0a,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x67,0x65,0x74,0x45,0x6c, /* ..document.getEl */ \
	0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28,0x27,0x68,0x65,0x6c,0x6c,0x6f, /* ementById('hello */ \
	0x27,0x29,0x2e,0x69,0x6e,0x6e,0x65,0x72,0x48,0x54,0x4d,0x4c,0x20,0x3d,0x20,0x22, /* ').innerHTML = " */ \
	0x7e,0x68,0x65,0x6c,0x6c,0x6f,0x6d,0x73,0x67,0x7e,0x22,0x3b,0x0d,0x0a,0x2f,0x2f, /* ~hellomsg~";..// */ \
	0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70,0x74,0x3e,0x0d,0x0a, /* -->..</script>.. */ \
	0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e, /* ~inc:footer.inc~ */ \
	0x0d,0x0a,0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0x9b,0x00,0x00,0x00,0x63,0x00, /* ......3.......c. */ \
	0x00,0x00,0xdd,0x00,0x00,0x00,0x64,0x00,0x00,0x00,0x1e,0x01,0x00,0x00,0x66,0x00, /* ......d.......f. */ \
	0x00,0x00,0x5e,0x01,0x00,0x00,0x67,0x00,0x00,0x00,0xa4,0x01,0x00,0x00,0x69,0x00, /* ..^...g.......i. */ \
	0x00,0x00,0xe5,0x01,0x00,0x00,0x68,0x00,0x00,0x00,0x9d,0x02,0x00,0x00,0x01,0x00, /* ......h......... */ \
	0x00,0x00,0xbd,0x02,0x00,0x00,0x02,0x00,0x00,0x00,0x7e,0x69,0x6e,0x63,0x3a,0x68, /* ..........~inc:h */ \
	0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76, /* eader.inc~..<div */ \
	0x20,0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a, /*  id="content">.. */ \
	0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x4e,0x6f,0x64,0x65,0x20,0x41,0x64,0x61,0x70,0x74, /* ..<h1>Node Adapt */ \
	0x65,0x72,0x20,0x43,0x6f,0x6e,0x66,0x69,0x67,0x75,0x72,0x61,0x74,0x69,0x6f,0x6e, /* er Configuration */ \
	0x3c,0x2f,0x68,0x31,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x66,0x6f,0x72,0x6d,0x20,0x6d, /* </h1>....<form m */ \
	0x65,0x74,0x68,0x6f,0x64,0x3d,0x22,0x70,0x6f,0x73,0x74,0x22,0x20,0x61,0x63,0x74, /* ethod="post" act */ \
	0x69,0x6f,0x6e,0x3d,0x22,0x2f,0x6e,0x6f,0x64,0x65,0x61,0x64,0x61,0x70,0x74,0x65, /* ion="/nodeadapte */ \
	0x72,0x2f,0x63,0x6f,0x6e,0x66,0x69,0x67,0x2e,0x68,0x74,0x6d,0x22,0x20,0x6e,0x61, /* r/config.htm" na */ \
	0x6d,0x65,0x3d,0x22,0x6e,0x6f,0x64,0x65,0x63,0x66,0x67,0x22,0x3e,0x0d,0x0a,0x3c, /* me="nodecfg">..< */ \
	0x66,0x69,0x65,0x6c,0x64,0x73,0x65,0x74,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e, /* fieldset>..<div> */ \
	0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x54,0x58,0x20,0x44,0x65,0x6c,0x61,0x79,0x20, /* <label>TX Delay  */ \
	0x54,0x69,0x6d,0x65,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c, /* Time:</label>..< */ \
	0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74, /* input type="text */ \
	0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x64,0x65,0x6c,0x79,0x22,0x20,0x76,0x61, /* " name="dely" va */ \
	0x6c,0x75,0x65,0x3d,0x22,0x7e,0x64,0x65,0x6c,0x61,0x79,0x5f,0x74,0x69,0x6d,0x65, /* lue="~delay_time */ \
	0x7e,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x34,0x22,0x20,0x63,0x6c,0x61,0x73, /* ~" size="4" clas */ \
	0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x20,0x2f,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b, /* s="ad1" />&nbsp; */ \
	0x6d,0x53,0x65,0x63,0x2e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69, /* mSec.</div>..<di */ \
	0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x54,0x58,0x20,0x54,0x69,0x6d,0x65, /* v><label>TX Time */ \
	0x20,0x6f,0x75,0x74,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c, /*  out:</label>..< */ \
	0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74, /* input type="text */ \
	0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x74,0x6f,0x75,0x74,0x22,0x20,0x76,0x61, /* " name="tout" va */ \
	0x6c,0x75,0x65,0x3d,0x22,0x7e,0x74,0x69,0x6d,0x65,0x5f,0x6f,0x75,0x74,0x7e,0x22, /* lue="~time_out~" */ \
	0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x34,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d, /*  size="4" class= */ \
	0x22,0x61,0x64,0x31,0x22,0x2f,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x53,0x65,0x63, /* "ad1"/>&nbsp;Sec */ \
	0x2e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c, /* .</div>..<div><l */ \
	0x61,0x62,0x65,0x6c,0x3e,0x52,0x58,0x20,0x4b,0x65,0x65,0x70,0x20,0x41,0x6c,0x69, /* abel>RX Keep Ali */ \
	0x76,0x65,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e, /* ve:</label>..<in */ \
	0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20, /* put type="text"  */ \
	0x6e,0x61,0x6d,0x65,0x3d,0x22,0x6b,0x65,0x65,0x70,0x22,0x20,0x76,0x61,0x6c,0x75, /* name="keep" valu */ \
	0x65,0x3d,0x22,0x7e,0x6b,0x65,0x65,0x70,0x5f,0x61,0x6c,0x69,0x76,0x65,0x7e,0x22, /* e="~keep_alive~" */ \
	0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x34,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d, /*  size="4" class= */ \
	0x22,0x61,0x64,0x31,0x22,0x2f,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x6d,0x53,0x65, /* "ad1"/>&nbsp;mSe */ \
	0x63,0x2e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c, /* c.</div>..<div>< */ \
	0x6c,0x61,0x62,0x65,0x6c,0x3e,0x4a,0x69,0x74,0x74,0x65,0x72,0x20,0x42,0x75,0x66, /* label>Jitter Buf */ \
	0x66,0x65,0x72,0x20,0x73,0x69,0x7a,0x65,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c, /* fer size:</label */ \
	0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22, /* >..<input type=" */ \
	0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x6a,0x69,0x74,0x74, /* text" name="jitt */ \
	0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x6a,0x69,0x74,0x74,0x74,0x65, /* " value="~jittte */ \
	0x72,0x5f,0x73,0x69,0x7a,0x65,0x7e,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x33, /* r_size~" size="3 */ \
	0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x2f,0x3e,0x26, /* " class="ad1"/>& */ \
	0x6e,0x62,0x73,0x70,0x3b,0x30,0x3a,0x20,0x6e,0x6f,0x74,0x20,0x65,0x66,0x66,0x65, /* nbsp;0: not effe */ \
	0x63,0x74,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c, /* ct</div>..<div>< */ \
	0x6c,0x61,0x62,0x65,0x6c,0x3e,0x52,0x58,0x20,0x41,0x75,0x74,0x6f,0x20,0x50,0x6f, /* label>RX Auto Po */ \
	0x6c,0x61,0x72,0x69,0x74,0x79,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d, /* larity:</label>. */ \
	0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68, /* .<input type="ch */ \
	0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x72,0x78, /* eckbox" name="rx */ \
	0x70,0x6c,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x52,0x58, /* pl" value="" ~RX */ \
	0x5f,0x41,0x75,0x74,0x6f,0x50,0x6f,0x6c,0x61,0x72,0x69,0x74,0x79,0x7e,0x20,0x63, /* _AutoPolarity~ c */ \
	0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x2f,0x3e,0x3c,0x2f,0x64,0x69, /* lass="ad1"/></di */ \
	0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e, /* v>..<div><label> */ \
	0x52,0x58,0x20,0x50,0x6f,0x6c,0x61,0x72,0x69,0x74,0x79,0x3a,0x3c,0x2f,0x6c,0x61  /* RX Polarity:</la */
#define DATACHUNK000007 \
	0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70, /* bel>..<input typ */ \
	0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d, /* e="checkbox" nam */ \
	0x65,0x3d,0x22,0x72,0x78,0x70,0x6f,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22, /* e="rxpo" value=" */ \
	0x22,0x20,0x7e,0x52,0x58,0x5f,0x50,0x6f,0x6c,0x61,0x72,0x69,0x74,0x79,0x7e,0x20, /* " ~RX_Polarity~  */ \
	0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x2f,0x3e,0x3c,0x2f, /*  class="ad1"/></ */ \
	0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65, /* div>..<div><labe */ \
	0x6c,0x3e,0x54,0x58,0x20,0x50,0x6f,0x6c,0x61,0x72,0x69,0x74,0x79,0x3a,0x3c,0x2f, /* l>TX Polarity:</ */ \
	0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e,0x70, /* label>..<td><inp */ \
	0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f, /* ut type="checkbo */ \
	0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x74,0x78,0x70,0x6f,0x22,0x20,0x76, /* x" name="txpo" v */ \
	0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x54,0x58,0x5f,0x50,0x6f,0x6c,0x61, /* alue="" ~TX_Pola */ \
	0x72,0x69,0x74,0x79,0x7e,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31, /* rity~ class="ad1 */ \
	0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76, /* " /></div>..<div */ \
	0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x43,0x4f,0x53,0x20,0x43,0x68,0x65,0x63, /* ><label>COS Chec */ \
	0x6b,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e, /* k:</label>..<td> */ \
	0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65, /* <input type="che */ \
	0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x63,0x6f,0x73, /* ckbox" name="cos */ \
	0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x43,0x4f,0x53,0x5f, /* " value="" ~COS_ */ \
	0x43,0x68,0x65,0x63,0x6b,0x7e,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64, /* Check~ class="ad */ \
	0x31,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69, /* 1" /></div>..<di */ \
	0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x53,0x2f,0x4e,0x20,0x53,0x71,0x75, /* v><label>S/N Squ */ \
	0x65,0x6c,0x63,0x68,0x20,0x56,0x61,0x6c,0x75,0x65,0x3a,0x3c,0x2f,0x6c,0x61,0x62, /* elch Value:</lab */ \
	0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20, /* el>..<td><input  */ \
	0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65, /* type="text" name */ \
	0x3d,0x22,0x73,0x6e,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x53,0x4e, /* ="sn" value="~SN */ \
	0x5f,0x53,0x71,0x75,0x65,0x6c,0x63,0x68,0x7e,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d, /* _Squelch~" size= */ \
	0x22,0x35,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x2f, /* "5" class="ad1"/ */ \
	0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x30,0x3a,0x20,0x6e,0x6f,0x74,0x20,0x65,0x66, /* >&nbsp;0: not ef */ \
	0x66,0x65,0x63,0x74,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76, /* fect</div>..<div */ \
	0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x43,0x52,0x43,0x20,0x43,0x68,0x65,0x63, /* ><label>CRC Chec */ \
	0x6b,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e, /* k:</label>..<td> */ \
	0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65, /* <input type="che */ \
	0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x63,0x72,0x63, /* ckbox" name="crc */ \
	0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x43,0x52,0x43,0x5f, /* " value="" ~CRC_ */ \
	0x43,0x68,0x65,0x63,0x6b,0x7e,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64, /* Check~ class="ad */ \
	0x31,0x22,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76, /* 1"/></div>..<div */ \
	0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x4c,0x61,0x73,0x74,0x20,0x46,0x72,0x61, /* ><label>Last Fra */ \
	0x6d,0x65,0x20,0x53,0x65,0x6e,0x64,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e, /* me Send:</label> */ \
	0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70, /* ..<td><input typ */ \
	0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d, /* e="checkbox" nam */ \
	0x65,0x3d,0x22,0x6c,0x61,0x73,0x74,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22, /* e="last" value=" */ \
	0x22,0x20,0x7e,0x4c,0x61,0x73,0x74,0x46,0x72,0x61,0x6d,0x65,0x7e,0x20,0x63,0x6c, /* " ~LastFrame~ cl */ \
	0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69, /* ass="ad1" /></di */ \
	0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e, /* v>..<div><label> */ \
	0x48,0x65,0x61,0x64,0x65,0x72,0x20,0x47,0x65,0x6e,0x65,0x72,0x61,0x74,0x69,0x6f, /* Header Generatio */ \
	0x6e,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e, /* n:</label>..<td> */ \
	0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65, /* <input type="che */ \
	0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x68,0x64,0x72, /* ckbox" name="hdr */ \
	0x67,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x48,0x65,0x61, /* g" value="" ~Hea */ \
	0x64,0x65,0x72,0x47,0x65,0x6e,0x7e,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61, /* derGen~ class="a */ \
	0x64,0x31,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64, /* d1" /></div>..<d */ \
	0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x48,0x65,0x61,0x64,0x65,0x72, /* iv><label>Header */ \
	0x20,0x47,0x65,0x6e,0x2e,0x20,0x54,0x79,0x70,0x65,0x3a,0x3c,0x2f,0x6c,0x61,0x62, /*  Gen. Type:</lab */ \
	0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20, /* el>..<td><input  */ \
	0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20, /* type="checkbox"  */ \
	0x6e,0x61,0x6d,0x65,0x3d,0x22,0x68,0x64,0x72,0x74,0x22,0x20,0x76,0x61,0x6c,0x75, /* name="hdrt" valu */ \
	0x65,0x3d,0x22,0x22,0x20,0x7e,0x48,0x65,0x61,0x64,0x65,0x72,0x47,0x65,0x6e,0x54, /* e="" ~HeaderGenT */ \
	0x79,0x70,0x65,0x7e,0x20,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31, /* ype~  class="ad1 */ \
	0x22,0x2f,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x43,0x68,0x65,0x63,0x6b,0x65,0x64, /* "/>&nbsp;Checked */ \
	0x3a,0x20,0x53,0x70,0x61,0x63,0x65,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c, /* : Space</div>..< */ \
	0x64,0x69,0x76,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b, /* div>&nbsp;&nbsp; */ \
	0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73, /* &nbsp;&nbsp;&nbs */ \
	0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e, /* p;&nbsp;&nbsp;&n */ \
	0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b  /* bsp;&nbsp;&nbsp; */
#define DATACHUNK000008 \
	0x0d,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62, /* .&nbsp;&nbsp;&nb */ \
	0x73,0x70,0x3b,0x0a,0x55,0x6e,0x63,0x68,0x65,0x63,0x6b,0x65,0x64,0x3a,0x20,0x4c, /* sp;.Unchecked: L */ \
	0x61,0x73,0x74,0x20,0x52,0x46,0x20,0x48,0x65,0x61,0x64,0x65,0x72,0x3c,0x2f,0x64, /* ast RF Header</d */ \
	0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c, /* iv>..<div><label */ \
	0x3e,0x48,0x61,0x6c,0x66,0x2f,0x46,0x75,0x6c,0x6c,0x20,0x44,0x75,0x70,0x6c,0x65, /* >Half/Full Duple */ \
	0x78,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e, /* x:</label>..<td> */ \
	0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65, /* <input type="che */ \
	0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x68,0x5f,0x66, /* ckbox" name="h_f */ \
	0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x48,0x61,0x6c,0x66, /* " value="" ~Half */ \
	0x46,0x75,0x6c,0x6c,0x7e,0x20,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64, /* Full~  class="ad */ \
	0x31,0x22,0x2f,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x43,0x68,0x65,0x63,0x6b,0x65, /* 1"/>&nbsp;Checke */ \
	0x64,0x3a,0x26,0x6e,0x62,0x73,0x70,0x3b,0x48,0x61,0x6c,0x66,0x3c,0x2f,0x64,0x69, /* d:&nbsp;Half</di */ \
	0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26, /* v>..<div>&nbsp;& */ \
	0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70, /* nbsp;&nbsp;&nbsp */ \
	0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62, /* ;&nbsp;&nbsp;&nb */ \
	0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26, /* sp;&nbsp;&nbsp;& */ \
	0x6e,0x62,0x73,0x70,0x3b,0x0d,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73, /* nbsp;.&nbsp;&nbs */ \
	0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x0a,0x55,0x6e,0x63,0x68,0x65,0x63,0x6b, /* p;&nbsp;.Uncheck */ \
	0x65,0x64,0x3a,0x20,0x46,0x75,0x6c,0x6c,0x20,0x44,0x75,0x70,0x6c,0x65,0x78,0x3c, /* ed: Full Duplex< */ \
	0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e, /* /div>......<div> */ \
	0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x73,0x75,0x62, /* <input type="sub */ \
	0x6d,0x69,0x74,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x70,0x31,0x22, /* mit" class="ap1" */ \
	0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x53,0x61,0x76,0x65,0x20,0x42,0x61,0x73, /*  value="Save Bas */ \
	0x69,0x63,0x20,0x49,0x6e,0x66,0x6f,0x2e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69, /* ic Info." /></di */ \
	0x76,0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x69,0x65,0x6c,0x64,0x73,0x65,0x74,0x3e,0x0d, /* v>..</fieldset>. */ \
	0x0a,0x3c,0x2f,0x66,0x6f,0x72,0x6d,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e, /* .</form>..</div> */ \
	0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e, /* ..~inc:footer.in */ \
	0x63,0x7e,0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0xeb,0x00,0x00,0x00,0x51,0x00, /* c~....3.......Q. */ \
	0x00,0x00,0x6b,0x01,0x00,0x00,0x52,0x00,0x00,0x00,0xe9,0x01,0x00,0x00,0x53,0x00, /* ..k...R.......S. */ \
	0x00,0x00,0x6f,0x02,0x00,0x00,0x54,0x00,0x00,0x00,0x03,0x03,0x00,0x00,0x55,0x00, /* ..o...T.......U. */ \
	0x00,0x00,0x78,0x03,0x00,0x00,0x5e,0x00,0x00,0x00,0xee,0x03,0x00,0x00,0x56,0x00, /* ..x...^.......V. */ \
	0x00,0x00,0x61,0x04,0x00,0x00,0x57,0x00,0x00,0x00,0xd3,0x04,0x00,0x00,0x58,0x00, /* ..a...W.......X. */ \
	0x00,0x00,0x61,0x05,0x00,0x00,0x59,0x00,0x00,0x00,0xd8,0x05,0x00,0x00,0x5a,0x00, /* ..a...Y.......Z. */ \
	0x00,0x00,0x52,0x06,0x00,0x00,0x5b,0x00,0x00,0x00,0xcb,0x06,0x00,0x00,0x5c,0x00, /* ..R...[.......\. */ \
	0x00,0x00,0xd1,0x07,0x00,0x00,0x5d,0x00,0x00,0x00,0xe8,0x08,0x00,0x00,0x02,0x00, /* ......]......... */ \
	0x00,0x00,0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e, /* ..~inc:header.in */ \
	0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e, /* c~..<div id="con */ \
	0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x42,0x65, /* tent">....<h1>Be */ \
	0x61,0x63,0x6f,0x6e,0x20,0x43,0x6f,0x6e,0x66,0x69,0x67,0x75,0x72,0x61,0x74,0x69, /* acon Configurati */ \
	0x6f,0x6e,0x3c,0x2f,0x68,0x31,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x66,0x6f,0x72,0x6d, /* on</h1>....<form */ \
	0x20,0x6d,0x65,0x74,0x68,0x6f,0x64,0x3d,0x22,0x70,0x6f,0x73,0x74,0x22,0x20,0x61, /*  method="post" a */ \
	0x63,0x74,0x69,0x6f,0x6e,0x3d,0x22,0x2f,0x6e,0x6f,0x64,0x65,0x61,0x64,0x61,0x70, /* ction="/nodeadap */ \
	0x74,0x65,0x72,0x2f,0x63,0x6f,0x6e,0x66,0x69,0x67,0x32,0x2e,0x68,0x74,0x6d,0x22, /* ter/config2.htm" */ \
	0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x62,0x65,0x61,0x63,0x6f,0x6e,0x22,0x3e,0x0d, /*  name="beacon">. */ \
	0x0a,0x3c,0x66,0x69,0x65,0x6c,0x64,0x73,0x65,0x74,0x3e,0x0d,0x0a,0x3c,0x64,0x69, /* .<fieldset>..<di */ \
	0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x42,0x65,0x61,0x63,0x6f,0x6e,0x20, /* v><label>Beacon  */ \
	0x4d,0x65,0x73,0x73,0x61,0x67,0x65,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e, /* Message:</label> */ \
	0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74, /* ..<input type="t */ \
	0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x62,0x65,0x61,0x63,0x22, /* ext" name="beac" */ \
	0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x42,0x65,0x61,0x63,0x6f,0x6e,0x4d, /*  value="~BeaconM */ \
	0x7e,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x32,0x30,0x22,0x20,0x63,0x6c,0x61, /* ~" size="20" cla */ \
	0x73,0x73,0x3d,0x22,0x73,0x6d,0x22,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d, /* ss="sm"/></div>. */ \
	0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x49,0x6e,0x65, /* .<div><label>Ine */ \
	0x72,0x76,0x61,0x6c,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c, /* rval:</label>..< */ \
	0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74, /* input type="text */ \
	0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x69,0x6e,0x74,0x76,0x22,0x20,0x76,0x61, /* " name="intv" va */ \
	0x6c,0x75,0x65,0x3d,0x22,0x7e,0x42,0x65,0x61,0x63,0x6f,0x6e,0x49,0x6e,0x74,0x76, /* lue="~BeaconIntv */ \
	0x7e,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x33,0x22,0x20,0x63,0x6c,0x61,0x73, /* ~" size="3" clas */ \
	0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x2f,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x53, /* s="ad1"/>&nbsp;S */ \
	0x65,0x63,0x2e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x64,0x69, /* ec.</div>....<di */ \
	0x76,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x73, /* v><input type="s */ \
	0x75,0x62,0x6d,0x69,0x74,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x70, /* ubmit" class="ap */ \
	0x31,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x53,0x61,0x76,0x65,0x20,0x42, /* 1" value="Save B */ \
	0x65,0x61,0x63,0x6f,0x6e,0x20,0x49,0x6e,0x66,0x6f,0x2e,0x22,0x20,0x2f,0x3e,0x3c  /* eacon Info." />< */
#define DATACHUNK000009 \
	0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x69,0x65,0x6c,0x64,0x73,0x65, /* /div>..</fieldse */ \
	0x74,0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x6f,0x72,0x6d,0x3e,0x0d,0x0a,0x3c,0x2f,0x64, /* t>..</form>..</d */ \
	0x69,0x76,0x3e,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72, /* iv>..~inc:footer */ \
	0x2e,0x69,0x6e,0x63,0x7e,0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0xe6,0x00,0x00, /* .inc~....3...... */ \
	0x00,0x71,0x00,0x00,0x00,0x53,0x01,0x00,0x00,0x72,0x00,0x00,0x00,0xf3,0x01,0x00, /* .q...S...r...... */ \
	0x00,0x02,0x00,0x00,0x00,0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72, /* .....~inc:header */ \
	0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22, /* .inc~..<div id=" */ \
	0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31, /* content">....<h1 */ \
	0x3e,0x54,0x58,0x20,0x48,0x65,0x61,0x64,0x65,0x72,0x20,0x52,0x65,0x70,0x6c,0x61, /* >TX Header Repla */ \
	0x63,0x65,0x20,0x43,0x6f,0x6e,0x66,0x69,0x67,0x75,0x72,0x61,0x74,0x69,0x6f,0x6e, /* ce Configuration */ \
	0x3c,0x2f,0x68,0x31,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x66,0x6f,0x72,0x6d,0x20,0x6d, /* </h1>....<form m */ \
	0x65,0x74,0x68,0x6f,0x64,0x3d,0x22,0x70,0x6f,0x73,0x74,0x22,0x20,0x61,0x63,0x74, /* ethod="post" act */ \
	0x69,0x6f,0x6e,0x3d,0x22,0x2f,0x6e,0x6f,0x64,0x65,0x61,0x64,0x61,0x70,0x74,0x65, /* ion="/nodeadapte */ \
	0x72,0x2f,0x63,0x6f,0x6e,0x66,0x69,0x67,0x33,0x2e,0x68,0x74,0x6d,0x22,0x20,0x6e, /* r/config3.htm" n */ \
	0x61,0x6d,0x65,0x3d,0x22,0x68,0x65,0x61,0x64,0x65,0x72,0x63,0x66,0x67,0x22,0x3e, /* ame="headercfg"> */ \
	0x0d,0x0a,0x3c,0x66,0x69,0x65,0x6c,0x64,0x73,0x65,0x74,0x3e,0x0d,0x0a,0x3c,0x64, /* ..<fieldset>..<d */ \
	0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x54,0x58,0x20,0x48,0x65,0x61, /* iv><label>TX Hea */ \
	0x64,0x65,0x72,0x20,0x52,0x65,0x70,0x6c,0x61,0x63,0x65,0x3a,0x3c,0x2f,0x6c,0x61, /* der Replace:</la */ \
	0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70, /* bel>..<input typ */ \
	0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d, /* e="checkbox" nam */ \
	0x65,0x3d,0x22,0x74,0x78,0x68,0x72,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22, /* e="txhr" value=" */ \
	0x22,0x20,0x7e,0x48,0x65,0x61,0x64,0x65,0x72,0x52,0x65,0x70,0x7e,0x20,0x63,0x6c, /* " ~HeaderRep~ cl */ \
	0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x20,0x6f,0x6e,0x63,0x6c,0x69,0x63, /* ass="ad1" onclic */ \
	0x6b,0x3d,0x22,0x63,0x6f,0x6e,0x66,0x69,0x67,0x48,0x65,0x61,0x64,0x65,0x72,0x28, /* k="configHeader( */ \
	0x29,0x22,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x62,0x72,0x3e, /* )"/></div>..<br> */ \
	0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x41,0x6c, /* ..<div><label>Al */ \
	0x74,0x65,0x72,0x20,0x4d,0x79,0x43,0x61,0x6c,0x6c,0x3a,0x3c,0x2f,0x6c,0x61,0x62, /* ter MyCall:</lab */ \
	0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65, /* el>..<input type */ \
	0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x6d,0x79, /* ="text" name="my */ \
	0x63,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x61,0x6c,0x74,0x5f,0x6d, /* c" value="~alt_m */ \
	0x79,0x63,0x61,0x6c,0x6c,0x7e,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x38,0x22, /* ycall~" size="8" */ \
	0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x2f,0x3e,0x0d,0x0a, /*  class="ad1"/>.. */ \
	0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65, /* <input type="che */ \
	0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x61,0x6d,0x79, /* ckbox" name="amy */ \
	0x63,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x61,0x5f,0x6d, /* c" value="" ~a_m */ \
	0x79,0x63,0x61,0x6c,0x6c,0x7e,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64, /* ycall~ class="ad */ \
	0x33,0x22,0x20,0x2f,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c, /* 3" />..</div>..< */ \
	0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x41,0x6c,0x74,0x65,0x72, /* div><label>Alter */ \
	0x20,0x4d,0x79,0x43,0x61,0x6c,0x6c,0x32,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c, /*  MyCall2:</label */ \
	0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22, /* >..<input type=" */ \
	0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x6d,0x79,0x63,0x32, /* text" name="myc2 */ \
	0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x61,0x6c,0x74,0x5f,0x6d,0x79, /* " value="~alt_my */ \
	0x63,0x61,0x6c,0x6c,0x32,0x7e,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x34,0x22, /* call2~" size="4" */ \
	0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x2f,0x3e,0x26,0x6e, /*  class="ad1"/>&n */ \
	0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b, /* bsp;&nbsp;&nbsp; */ \
	0x26,0x6e,0x62,0x73,0x70,0x3b,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74, /* &nbsp;..<input t */ \
	0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e, /* ype="checkbox" n */ \
	0x61,0x6d,0x65,0x3d,0x22,0x61,0x6d,0x79,0x32,0x22,0x20,0x76,0x61,0x6c,0x75,0x65, /* ame="amy2" value */ \
	0x3d,0x22,0x22,0x20,0x7e,0x61,0x5f,0x6d,0x79,0x63,0x61,0x6c,0x6c,0x32,0x7e,0x20, /* ="" ~a_mycall2~  */ \
	0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x33,0x22,0x20,0x2f,0x3e,0x0d,0x0a, /* class="ad3" />.. */ \
	0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61, /* </div>..<div><la */ \
	0x62,0x65,0x6c,0x3e,0x41,0x6c,0x74,0x65,0x72,0x20,0x59,0x6f,0x75,0x72,0x43,0x61, /* bel>Alter YourCa */ \
	0x6c,0x6c,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e, /* ll:</label>..<in */ \
	0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20, /* put type="text"  */ \
	0x6e,0x61,0x6d,0x65,0x3d,0x22,0x79,0x72,0x63,0x22,0x20,0x76,0x61,0x6c,0x75,0x65, /* name="yrc" value */ \
	0x3d,0x22,0x7e,0x61,0x6c,0x74,0x5f,0x79,0x6f,0x75,0x72,0x63,0x61,0x6c,0x6c,0x7e, /* ="~alt_yourcall~ */ \
	0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x38,0x22,0x20,0x63,0x6c,0x61,0x73,0x73, /* " size="8" class */ \
	0x3d,0x22,0x61,0x64,0x31,0x22,0x2f,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74, /* ="ad1"/>..<input */ \
	0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22, /*  type="checkbox" */ \
	0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x61,0x79,0x72,0x63,0x22,0x20,0x76,0x61,0x6c, /*  name="ayrc" val */ \
	0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x61,0x5f,0x79,0x6f,0x75,0x72,0x63,0x61,0x6c, /* ue="" ~a_yourcal */ \
	0x6c,0x7e,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x33,0x22,0x20,0x2f, /* l~ class="ad3" / */ \
	0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e, /* >..</div>..<div> */ \
	0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x41,0x6c,0x74,0x65,0x72,0x20,0x52,0x50,0x54  /* <label>Alter RPT */
#define DATACHUNK00000a \
	0x31,0x20,0x43,0x61,0x6c,0x6c,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d, /* 1 Call:</label>. */ \
	0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65, /* .<input type="te */ \
	0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x72,0x70,0x74,0x31,0x22,0x20, /* xt" name="rpt1"  */ \
	0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x61,0x6c,0x74,0x5f,0x72,0x70,0x74,0x31, /* value="~alt_rpt1 */ \
	0x63,0x61,0x6c,0x6c,0x7e,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x38,0x22,0x20, /* call~" size="8"  */ \
	0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x2f,0x3e,0x0d,0x0a,0x3c, /* class="ad1"/>..< */ \
	0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63, /* input type="chec */ \
	0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x61,0x72,0x74,0x31, /* kbox" name="art1 */ \
	0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x61,0x5f,0x72,0x70, /* " value="" ~a_rp */ \
	0x74,0x31,0x63,0x61,0x6c,0x6c,0x7e,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61, /* t1call~ class="a */ \
	0x64,0x33,0x22,0x20,0x2f,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a, /* d3" />..</div>.. */ \
	0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x41,0x6c,0x74,0x65, /* <div><label>Alte */ \
	0x72,0x20,0x52,0x50,0x54,0x32,0x20,0x43,0x61,0x6c,0x6c,0x3a,0x3c,0x2f,0x6c,0x61, /* r RPT2 Call:</la */ \
	0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70, /* bel>..<input typ */ \
	0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x72, /* e="text" name="r */ \
	0x70,0x74,0x32,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x61,0x6c,0x74, /* pt2" value="~alt */ \
	0x5f,0x72,0x70,0x74,0x32,0x63,0x61,0x6c,0x6c,0x7e,0x22,0x20,0x73,0x69,0x7a,0x65, /* _rpt2call~" size */ \
	0x3d,0x22,0x38,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22, /* ="8" class="ad1" */ \
	0x2f,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d, /* />..<input type= */ \
	0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d, /* "checkbox" name= */ \
	0x22,0x61,0x72,0x74,0x32,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20, /* "art2" value=""  */ \
	0x7e,0x61,0x5f,0x72,0x70,0x74,0x32,0x63,0x61,0x6c,0x6c,0x7e,0x20,0x63,0x6c,0x61, /* ~a_rpt2call~ cla */ \
	0x73,0x73,0x3d,0x22,0x61,0x64,0x33,0x22,0x20,0x2f,0x3e,0x0d,0x0a,0x3c,0x2f,0x64, /* ss="ad3" />..</d */ \
	0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62, /* iv>....<div><lab */ \
	0x65,0x6c,0x3e,0x41,0x6c,0x74,0x2e,0x20,0x54,0x58,0x20,0x48,0x65,0x61,0x64,0x65, /* el>Alt. TX Heade */ \
	0x72,0x20,0x46,0x6c,0x61,0x67,0x73,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e, /* r Flags:</label> */ \
	0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63, /* ..<input type="c */ \
	0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x66, /* heckbox" name="f */ \
	0x6c,0x67,0x37,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x66, /* lg7" value="" ~f */ \
	0x6c,0x61,0x67,0x37,0x7e,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31, /* lag7~ class="ad1 */ \
	0x22,0x20,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x2f,0x3e,0x0d,0x0a,0x3c,0x69, /* " disabled/>..<i */ \
	0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b, /* nput type="check */ \
	0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x66,0x6c,0x67,0x36,0x22, /* box" name="flg6" */ \
	0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x66,0x6c,0x61,0x67,0x36, /*  value="" ~flag6 */ \
	0x7e,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x33,0x22,0x20,0x2f,0x3e, /* ~ class="ad3" /> */ \
	0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63, /* ..<input type="c */ \
	0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x66, /* heckbox" name="f */ \
	0x6c,0x67,0x35,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x66, /* lg5" value="" ~f */ \
	0x6c,0x61,0x67,0x35,0x7e,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x33, /* lag5~ class="ad3 */ \
	0x22,0x20,0x2f,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70, /* " />..<input typ */ \
	0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d, /* e="checkbox" nam */ \
	0x65,0x3d,0x22,0x66,0x6c,0x67,0x34,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22, /* e="flg4" value=" */ \
	0x22,0x20,0x7e,0x66,0x6c,0x61,0x67,0x34,0x7e,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d, /* " ~flag4~ class= */ \
	0x22,0x61,0x64,0x33,0x22,0x20,0x2f,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74, /* "ad3" />..<input */ \
	0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22, /*  type="checkbox" */ \
	0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x66,0x6c,0x67,0x33,0x22,0x20,0x76,0x61,0x6c, /*  name="flg3" val */ \
	0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x66,0x6c,0x61,0x67,0x33,0x7e,0x20,0x63,0x6c, /* ue="" ~flag3~ cl */ \
	0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x33,0x22,0x20,0x2f,0x3e,0x0d,0x0a,0x3c,0x69, /* ass="ad3" />..<i */ \
	0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b, /* nput type="check */ \
	0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x66,0x6c,0x67,0x32,0x22, /* box" name="flg2" */ \
	0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x66,0x6c,0x61,0x67,0x32, /*  value="" ~flag2 */ \
	0x7e,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x33,0x22,0x20,0x2f,0x3e, /* ~ class="ad3" /> */ \
	0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63, /* ..<input type="c */ \
	0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x66, /* heckbox" name="f */ \
	0x6c,0x67,0x31,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x66, /* lg1" value="" ~f */ \
	0x6c,0x61,0x67,0x31,0x7e,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x33, /* lag1~ class="ad3 */ \
	0x22,0x20,0x2f,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70, /* " />..<input typ */ \
	0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d, /* e="checkbox" nam */ \
	0x65,0x3d,0x22,0x66,0x6c,0x67,0x30,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22, /* e="flg0" value=" */ \
	0x22,0x20,0x7e,0x66,0x6c,0x61,0x67,0x30,0x7e,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d, /* " ~flag0~ class= */ \
	0x22,0x61,0x64,0x33,0x22,0x20,0x2f,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e, /* "ad3" />&nbsp;&n */ \
	0x62,0x73,0x70,0x3b,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70, /* bsp;..<input typ */ \
	0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d, /* e="checkbox" nam */ \
	0x65,0x3d,0x22,0x61,0x66,0x6c,0x67,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22  /* e="aflg" value=" */
#define DATACHUNK00000b \
	0x22,0x20,0x7e,0x41,0x66,0x6c,0x61,0x67,0x7e,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d, /* " ~Aflag~ class= */ \
	0x22,0x61,0x64,0x33,0x22,0x20,0x2f,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e, /* "ad3" />..</div> */ \
	0x0d,0x0a,0x0d,0x0a,0x0d,0x0a,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x69,0x6e, /* ........<div><in */ \
	0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x73,0x75,0x62,0x6d,0x69,0x74, /* put type="submit */ \
	0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x70,0x31,0x22,0x20,0x6e,0x61, /* " class="ap1" na */ \
	0x6d,0x65,0x3d,0x22,0x68,0x64,0x72,0x73,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d, /* me="hdrs" value= */ \
	0x22,0x53,0x61,0x76,0x65,0x20,0x48,0x65,0x61,0x64,0x65,0x72,0x20,0x49,0x6e,0x66, /* "Save Header Inf */ \
	0x6f,0x2e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x2f, /* o." /></div>..</ */ \
	0x66,0x69,0x65,0x6c,0x64,0x73,0x65,0x74,0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x6f,0x72, /* fieldset>..</for */ \
	0x6d,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x73,0x63,0x72, /* m>..</div>..<scr */ \
	0x69,0x70,0x74,0x20,0x6c,0x61,0x6e,0x67,0x75,0x61,0x67,0x65,0x3d,0x22,0x6a,0x61, /* ipt language="ja */ \
	0x76,0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x0d,0x0a,0x66,0x75,0x6e,0x63, /* vascript">..func */ \
	0x74,0x69,0x6f,0x6e,0x20,0x63,0x6f,0x6e,0x66,0x69,0x67,0x48,0x65,0x61,0x64,0x65, /* tion configHeade */ \
	0x72,0x28,0x29,0x20,0x7b,0x0d,0x0a,0x09,0x65,0x20,0x3d,0x20,0x64,0x6f,0x63,0x75, /* r() {...e = docu */ \
	0x6d,0x65,0x6e,0x74,0x2e,0x66,0x6f,0x72,0x6d,0x73,0x2e,0x68,0x65,0x61,0x64,0x65, /* ment.forms.heade */ \
	0x72,0x63,0x66,0x67,0x3b,0x0d,0x0a,0x09,0x73,0x74,0x20,0x3d,0x20,0x21,0x28,0x65, /* rcfg;...st = !(e */ \
	0x2e,0x74,0x78,0x68,0x72,0x2e,0x63,0x68,0x65,0x63,0x6b,0x65,0x64,0x29,0x3b,0x0d, /* .txhr.checked);. */ \
	0x0a,0x09,0x65,0x2e,0x6d,0x79,0x63,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64, /* ..e.myc.disabled */ \
	0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x6d,0x79,0x63,0x32,0x2e, /*  = st;...e.myc2. */ \
	0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a, /* disabled = st;.. */ \
	0x09,0x65,0x2e,0x79,0x72,0x63,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20, /* .e.yrc.disabled  */ \
	0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x72,0x70,0x74,0x31,0x2e,0x64, /* = st;...e.rpt1.d */ \
	0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a,0x09, /* isabled = st;... */ \
	0x65,0x2e,0x72,0x70,0x74,0x32,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20, /* e.rpt2.disabled  */ \
	0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x66,0x6c,0x67,0x36,0x2e,0x64, /* = st;...e.flg6.d */ \
	0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a,0x09, /* isabled = st;... */ \
	0x65,0x2e,0x66,0x6c,0x67,0x35,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20, /* e.flg5.disabled  */ \
	0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x66,0x6c,0x67,0x34,0x2e,0x64, /* = st;...e.flg4.d */ \
	0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a,0x09, /* isabled = st;... */ \
	0x65,0x2e,0x66,0x6c,0x67,0x33,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20, /* e.flg3.disabled  */ \
	0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x66,0x6c,0x67,0x32,0x2e,0x64, /* = st;...e.flg2.d */ \
	0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a,0x09, /* isabled = st;... */ \
	0x65,0x2e,0x66,0x6c,0x67,0x31,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20, /* e.flg1.disabled  */ \
	0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x66,0x6c,0x67,0x30,0x2e,0x64, /* = st;...e.flg0.d */ \
	0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a,0x09, /* isabled = st;... */ \
	0x65,0x2e,0x61,0x66,0x6c,0x67,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20, /* e.aflg.disabled  */ \
	0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x61,0x6d,0x79,0x63,0x2e,0x64, /* = st;...e.amyc.d */ \
	0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a,0x09, /* isabled = st;... */ \
	0x65,0x2e,0x61,0x6d,0x79,0x32,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20, /* e.amy2.disabled  */ \
	0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x61,0x79,0x72,0x63,0x2e,0x64, /* = st;...e.ayrc.d */ \
	0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a,0x09, /* isabled = st;... */ \
	0x65,0x2e,0x61,0x72,0x74,0x31,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20, /* e.art1.disabled  */ \
	0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x61,0x72,0x74,0x32,0x2e,0x64, /* = st;...e.art2.d */ \
	0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a,0x7d, /* isabled = st;..} */ \
	0x0d,0x0a,0x0d,0x0a,0x63,0x6f,0x6e,0x66,0x69,0x67,0x48,0x65,0x61,0x64,0x65,0x72, /* ....configHeader */ \
	0x28,0x29,0x3b,0x0d,0x0a,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70,0x74,0x3e, /* ();....</script> */ \
	0x0d,0x0a,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e, /* ....~inc:footer. */ \
	0x69,0x6e,0x63,0x7e,0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0xfd,0x00,0x00,0x00, /* inc~....3....... */ \
	0x73,0x00,0x00,0x00,0x85,0x01,0x00,0x00,0x74,0x00,0x00,0x00,0xd7,0x01,0x00,0x00, /* s.......t....... */ \
	0x81,0x00,0x00,0x00,0x44,0x02,0x00,0x00,0x75,0x00,0x00,0x00,0xaf,0x02,0x00,0x00, /* ....D...u....... */ \
	0x82,0x00,0x00,0x00,0x1d,0x03,0x00,0x00,0x76,0x00,0x00,0x00,0x71,0x03,0x00,0x00, /* ........v...q... */ \
	0x83,0x00,0x00,0x00,0xe2,0x03,0x00,0x00,0x77,0x00,0x00,0x00,0x36,0x04,0x00,0x00, /* ........w...6... */ \
	0x84,0x00,0x00,0x00,0xa7,0x04,0x00,0x00,0x78,0x00,0x00,0x00,0xfb,0x04,0x00,0x00, /* ........x....... */ \
	0x85,0x00,0x00,0x00,0x79,0x05,0x00,0x00,0x79,0x00,0x00,0x00,0xc5,0x05,0x00,0x00, /* ....y...y....... */ \
	0x7a,0x00,0x00,0x00,0x09,0x06,0x00,0x00,0x7b,0x00,0x00,0x00,0x4d,0x06,0x00,0x00, /* z.......{...M... */ \
	0x7c,0x00,0x00,0x00,0x91,0x06,0x00,0x00,0x7d,0x00,0x00,0x00,0xd5,0x06,0x00,0x00, /* |.......}....... */ \
	0x7e,0x00,0x00,0x00,0x19,0x07,0x00,0x00,0x7f,0x00,0x00,0x00,0x5d,0x07,0x00,0x00, /* ~...........]... */ \
	0x80,0x00,0x00,0x00,0xad,0x07,0x00,0x00,0x88,0x00,0x00,0x00,0x8f,0x0a,0x00,0x00, /* ................ */ \
	0x02,0x00,0x00,0x00,0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72,0x2e, /* ....~inc:header. */ \
	0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x63, /* inc~..<div id="c */ \
	0x6f,0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31,0x3e, /* ontent">....<h1> */ \
	0x4e,0x65,0x74,0x77,0x6f,0x72,0x6b,0x20,0x43,0x6f,0x6e,0x66,0x69,0x67,0x75,0x72, /* Network Configur */ \
	0x61,0x74,0x69,0x6f,0x6e,0x3c,0x2f,0x68,0x31,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x66, /* ation</h1>....<f */ \
	0x6f,0x72,0x6d,0x20,0x6d,0x65,0x74,0x68,0x6f,0x64,0x3d,0x22,0x70,0x6f,0x73,0x74  /* orm method="post */
#define DATACHUNK00000c \
	0x22,0x20,0x61,0x63,0x74,0x69,0x6f,0x6e,0x3d,0x22,0x2f,0x70,0x72,0x6f,0x74,0x65, /* " action="/prote */ \
	0x63,0x74,0x2f,0x63,0x6f,0x6e,0x66,0x69,0x67,0x2e,0x68,0x74,0x6d,0x22,0x20,0x6e, /* ct/config.htm" n */ \
	0x61,0x6d,0x65,0x3d,0x22,0x63,0x6f,0x6e,0x66,0x69,0x67,0x22,0x3e,0x0d,0x0a,0x3c, /* ame="config">..< */ \
	0x66,0x69,0x65,0x6c,0x64,0x73,0x65,0x74,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e, /* fieldset>..<div> */ \
	0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x4d,0x41,0x43,0x20,0x41,0x64,0x64,0x72,0x65, /* <label>MAC Addre */ \
	0x73,0x73,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e, /* ss:</label>..<in */ \
	0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20, /* put type="text"  */ \
	0x6e,0x61,0x6d,0x65,0x3d,0x22,0x6d,0x61,0x63,0x22,0x20,0x76,0x61,0x6c,0x75,0x65, /* name="mac" value */ \
	0x3d,0x22,0x7e,0x63,0x6f,0x6e,0x66,0x69,0x67,0x5f,0x6d,0x61,0x63,0x7e,0x22,0x20, /* ="~config_mac~"  */ \
	0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c, /* /></div>..<div>< */ \
	0x6c,0x61,0x62,0x65,0x6c,0x3e,0x53,0x65,0x72,0x76,0x65,0x72,0x20,0x4e,0x61,0x6d, /* label>Server Nam */ \
	0x65,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70, /* e:</label>..<inp */ \
	0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e, /* ut type="text" n */ \
	0x61,0x6d,0x65,0x3d,0x22,0x68,0x6f,0x73,0x74,0x22,0x20,0x76,0x61,0x6c,0x75,0x65, /* ame="host" value */ \
	0x3d,0x22,0x7e,0x73,0x65,0x72,0x76,0x65,0x72,0x5f,0x6e,0x61,0x6d,0x65,0x7e,0x22, /* ="~server_name~" */ \
	0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e, /*  /></div>..<div> */ \
	0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x4f,0x75,0x74,0x20,0x42,0x6f,0x75,0x6e,0x64, /* <label>Out Bound */ \
	0x20,0x50,0x6f,0x72,0x74,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a, /*  Port:</label>.. */ \
	0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78, /* <input type="tex */ \
	0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x6f,0x70,0x72,0x74,0x22,0x20,0x76, /* t" name="oprt" v */ \
	0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x6f,0x75,0x74,0x5f,0x70,0x6f,0x72,0x74,0x7e, /* alue="~out_port~ */ \
	0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x20,0x73,0x69, /* " class="ad1" si */ \
	0x7a,0x65,0x3d,0x22,0x35,0x22,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a, /* ze="5"/></div>.. */ \
	0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x49,0x6e,0x20,0x42, /* <div><label>In B */ \
	0x6f,0x75,0x6e,0x64,0x20,0x50,0x6f,0x72,0x74,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65, /* ound Port:</labe */ \
	0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d, /* l>..<input type= */ \
	0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x69,0x70,0x72, /* "text" name="ipr */ \
	0x74,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x69,0x6e,0x5f,0x70,0x6f, /* t" value="~in_po */ \
	0x72,0x74,0x7e,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22, /* rt~" class="ad1" */ \
	0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x35,0x22,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76, /*  size="5"/></div */ \
	0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x52, /* >..<div><label>R */ \
	0x6f,0x6f,0x6d,0x20,0x4e,0x61,0x6d,0x65,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c, /* oom Name:</label */ \
	0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22, /* >..<input type=" */ \
	0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x52,0x6d,0x4e,0x6d, /* text" name="RmNm */ \
	0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x52,0x6f,0x6f,0x6d,0x4e,0x61, /* " value="~RoomNa */ \
	0x6d,0x65,0x7e,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22, /* me~" class="ad1" */ \
	0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x38,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69, /*  size="8" /></di */ \
	0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e, /* v>..<div><label> */ \
	0x4e,0x6f,0x64,0x65,0x20,0x43,0x61,0x6c,0x6c,0x73,0x69,0x67,0x6e,0x3a,0x3c,0x2f, /* Node Callsign:</ */ \
	0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74, /* label>..<input t */ \
	0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d, /* ype="text" name= */ \
	0x22,0x4e,0x64,0x4e,0x6d,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x4e, /* "NdNm" value="~N */ \
	0x6f,0x64,0x65,0x4e,0x61,0x6d,0x65,0x7e,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d, /* odeName~" class= */ \
	0x22,0x61,0x64,0x31,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x38,0x22,0x20,0x2f, /* "ad1" size="8" / */ \
	0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c, /* ></div>..<div><l */ \
	0x61,0x62,0x65,0x6c,0x3e,0x4a,0x69,0x74,0x74,0x65,0x72,0x20,0x42,0x75,0x66,0x66, /* abel>Jitter Buff */ \
	0x65,0x72,0x20,0x57,0x61,0x69,0x74,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e, /* er Wait:</label> */ \
	0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74, /* ..<input type="t */ \
	0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x6a,0x69,0x74,0x74,0x22, /* ext" name="jitt" */ \
	0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x4a,0x69,0x74,0x74,0x65,0x72,0x53, /*  value="~JitterS */ \
	0x69,0x7a,0x65,0x7e,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x32,0x22,0x20,0x63, /* ize~" size="2" c */ \
	0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x2f,0x3e,0x3c,0x2f,0x64,0x69, /* lass="ad1"/></di */ \
	0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e, /* v>..<div><label> */ \
	0x4e,0x54,0x50,0x20,0x53,0x65,0x72,0x76,0x65,0x72,0x20,0x4e,0x61,0x6d,0x65,0x3a, /* NTP Server Name: */ \
	0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e, /* </label>&nbsp;&n */ \
	0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b, /* bsp;&nbsp;&nbsp; */ \
	0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73, /* &nbsp;&nbsp;&nbs */ \
	0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x0d,0x0a, /* p;&nbsp;&nbsp;.. */ \
	0x3c,0x73,0x65,0x6c,0x65,0x63,0x74,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x6e,0x74, /* <select name="nt */ \
	0x70,0x22,0x3e,0x0d,0x0a,0x3c,0x6f,0x70,0x74,0x69,0x6f,0x6e,0x20,0x76,0x61,0x6c, /* p">..<option val */ \
	0x75,0x65,0x3d,0x22,0x70,0x6f,0x6f,0x6c,0x2e,0x6e,0x74,0x70,0x2e,0x6f,0x72,0x67, /* ue="pool.ntp.org */ \
	0x22,0x3e,0x70,0x6f,0x6f,0x6c,0x2e,0x6e,0x74,0x70,0x2e,0x6f,0x72,0x67,0x0d,0x0a, /* ">pool.ntp.org.. */ \
	0x3c,0x6f,0x70,0x74,0x69,0x6f,0x6e,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x65, /* <option value="e */ \
	0x75,0x72,0x6f,0x70,0x65,0x2e,0x70,0x6f,0x6f,0x6c,0x2e,0x6e,0x74,0x70,0x2e,0x6f  /* urope.pool.ntp.o */
#define DATACHUNK00000d \
	0x72,0x67,0x22,0x3e,0x65,0x75,0x72,0x6f,0x70,0x65,0x2e,0x70,0x6f,0x6f,0x6c,0x2e, /* rg">europe.pool. */ \
	0x6e,0x74,0x70,0x2e,0x6f,0x72,0x67,0x0d,0x0a,0x3c,0x6f,0x70,0x74,0x69,0x6f,0x6e, /* ntp.org..<option */ \
	0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x61,0x73,0x69,0x61,0x2e,0x70,0x6f,0x6f, /*  value="asia.poo */ \
	0x6c,0x2e,0x6e,0x74,0x70,0x2e,0x6f,0x72,0x67,0x22,0x3e,0x61,0x73,0x69,0x61,0x2e, /* l.ntp.org">asia. */ \
	0x70,0x6f,0x6f,0x6c,0x2e,0x6e,0x74,0x70,0x2e,0x6f,0x72,0x67,0x0d,0x0a,0x3c,0x6f, /* pool.ntp.org..<o */ \
	0x70,0x74,0x69,0x6f,0x6e,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x6f,0x63,0x65, /* ption value="oce */ \
	0x61,0x6e,0x69,0x61,0x2e,0x70,0x6f,0x6f,0x6c,0x2e,0x6e,0x74,0x70,0x2e,0x6f,0x72, /* ania.pool.ntp.or */ \
	0x67,0x22,0x3e,0x6f,0x63,0x65,0x61,0x6e,0x69,0x61,0x2e,0x70,0x6f,0x6f,0x6c,0x2e, /* g">oceania.pool. */ \
	0x6e,0x74,0x70,0x2e,0x6f,0x72,0x67,0x0d,0x0a,0x3c,0x6f,0x70,0x74,0x69,0x6f,0x6e, /* ntp.org..<option */ \
	0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x6e,0x6f,0x72,0x74,0x68,0x2d,0x61,0x6d, /*  value="north-am */ \
	0x65,0x72,0x69,0x63,0x61,0x2e,0x70,0x6f,0x6f,0x6c,0x2e,0x6e,0x74,0x70,0x2e,0x6f, /* erica.pool.ntp.o */ \
	0x72,0x67,0x22,0x3e,0x6e,0x6f,0x72,0x74,0x68,0x2d,0x61,0x6d,0x65,0x72,0x69,0x63, /* rg">north-americ */ \
	0x61,0x2e,0x70,0x6f,0x6f,0x6c,0x2e,0x6e,0x74,0x70,0x2e,0x6f,0x72,0x67,0x0d,0x0a, /* a.pool.ntp.org.. */ \
	0x3c,0x6f,0x70,0x74,0x69,0x6f,0x6e,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x73, /* <option value="s */ \
	0x6f,0x75,0x74,0x68,0x2d,0x61,0x6d,0x65,0x72,0x69,0x63,0x61,0x2e,0x70,0x6f,0x6f, /* outh-america.poo */ \
	0x6c,0x2e,0x6e,0x74,0x70,0x2e,0x6f,0x72,0x67,0x22,0x3e,0x73,0x6f,0x75,0x74,0x68, /* l.ntp.org">south */ \
	0x2d,0x61,0x6d,0x65,0x72,0x69,0x63,0x61,0x2e,0x70,0x6f,0x6f,0x6c,0x2e,0x6e,0x74, /* -america.pool.nt */ \
	0x70,0x2e,0x6f,0x72,0x67,0x0d,0x0a,0x3c,0x6f,0x70,0x74,0x69,0x6f,0x6e,0x20,0x76, /* p.org..<option v */ \
	0x61,0x6c,0x75,0x65,0x3d,0x22,0x61,0x66,0x72,0x69,0x63,0x61,0x2e,0x70,0x6f,0x6f, /* alue="africa.poo */ \
	0x6c,0x2e,0x6e,0x74,0x70,0x2e,0x6f,0x72,0x67,0x22,0x3e,0x61,0x66,0x72,0x69,0x63, /* l.ntp.org">afric */ \
	0x61,0x2e,0x70,0x6f,0x6f,0x6c,0x2e,0x6e,0x74,0x70,0x2e,0x6f,0x72,0x67,0x0d,0x0a, /* a.pool.ntp.org.. */ \
	0x3c,0x2f,0x73,0x65,0x6c,0x65,0x63,0x74,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76, /* </select>..</div */ \
	0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x54, /* >..<div><label>T */ \
	0x69,0x6d,0x65,0x20,0x5a,0x6f,0x6e,0x65,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c, /* ime Zone:</label */ \
	0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22, /* >..<input type=" */ \
	0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x7a,0x6f,0x6e,0x65, /* text" name="zone */ \
	0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x54,0x69,0x6d,0x65,0x5a,0x6f, /* " value="~TimeZo */ \
	0x6e,0x65,0x7e,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22, /* ne~" class="ad1" */ \
	0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x33,0x22,0x2f,0x3e,0x26,0x6e,0x62,0x73,0x70, /*  size="3"/>&nbsp */ \
	0x3b,0x68,0x6f,0x75,0x72,0x73,0x26,0x6e,0x62,0x73,0x70,0x3b,0x0d,0x0a,0x3c,0x69, /* ;hours&nbsp;..<i */ \
	0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22, /* nput type="text" */ \
	0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x7a,0x6e,0x65,0x4d,0x22,0x20,0x76,0x61,0x6c, /*  name="zneM" val */ \
	0x75,0x65,0x3d,0x22,0x7e,0x54,0x69,0x6d,0x65,0x5a,0x6f,0x6e,0x65,0x4d,0x69,0x6e, /* ue="~TimeZoneMin */ \
	0x75,0x74,0x65,0x73,0x7e,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64, /* utes~" class="ad */ \
	0x33,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x32,0x22,0x2f,0x3e,0x26,0x6e,0x62, /* 3" size="2"/>&nb */ \
	0x73,0x70,0x3b,0x6d,0x69,0x6e,0x75,0x74,0x65,0x73,0x3c,0x2f,0x64,0x69,0x76,0x3e, /* sp;minutes</div> */ \
	0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x52,0x46, /* ..<div><label>RF */ \
	0x20,0x52,0x65,0x70,0x65,0x74,0x65,0x72,0x20,0x43,0x6f,0x6e,0x6e,0x65,0x63,0x74, /*  Repeter Connect */ \
	0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75, /* :</label>..<inpu */ \
	0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78, /* t type="checkbox */ \
	0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x20,0x6e,0x61, /* " class="ad1" na */ \
	0x6d,0x65,0x3d,0x22,0x72,0x65,0x70,0x74,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d, /* me="rept" value= */ \
	0x22,0x31,0x22,0x20,0x20,0x7e,0x72,0x65,0x70,0x65,0x61,0x74,0x65,0x72,0x5f,0x6f, /* "1"  ~repeater_o */ \
	0x6e,0x7e,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69, /* n~ /></div>..<di */ \
	0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x41,0x63,0x63,0x65,0x73,0x73,0x20, /* v><label>Access  */ \
	0x43,0x6f,0x6e,0x74,0x72,0x6f,0x6c,0x20,0x46,0x69,0x6c,0x65,0x20,0x4e,0x61,0x6d, /* Control File Nam */ \
	0x65,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70, /* e:</label>..<inp */ \
	0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e, /* ut type="text" n */ \
	0x61,0x6d,0x65,0x3d,0x22,0x61,0x63,0x74,0x6c,0x22,0x20,0x76,0x61,0x6c,0x75,0x65, /* ame="actl" value */ \
	0x3d,0x22,0x7e,0x41,0x63,0x63,0x43,0x74,0x72,0x6c,0x7e,0x22,0x20,0x2f,0x3e,0x3c, /* ="~AccCtrl~" />< */ \
	0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x26,0x6e,0x62,0x73, /* /div>..<div>&nbs */ \
	0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a, /* p;&nbsp;</div>.. */ \
	0x3c,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79, /* <div>..<input ty */ \
	0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x63,0x6c, /* pe="checkbox" cl */ \
	0x61,0x73,0x73,0x3d,0x22,0x73,0x6d,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x64, /* ass="sm" name="d */ \
	0x68,0x63,0x70,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x31,0x22,0x20,0x6f, /* hcp" value="1" o */ \
	0x6e,0x63,0x6c,0x69,0x63,0x6b,0x3d,0x22,0x63,0x6f,0x6e,0x66,0x69,0x67,0x49,0x50, /* nclick="configIP */ \
	0x42,0x6f,0x78,0x65,0x73,0x28,0x29,0x22,0x20,0x7e,0x63,0x6f,0x6e,0x66,0x69,0x67, /* Boxes()" ~config */ \
	0x5f,0x64,0x68,0x63,0x70,0x63,0x68,0x65,0x63,0x6b,0x65,0x64,0x7e,0x20,0x2f,0x3e, /* _dhcpchecked~ /> */ \
	0x20,0x45,0x6e,0x61,0x62,0x6c,0x65,0x20,0x44,0x48,0x43,0x50,0x3c,0x2f,0x64,0x69, /*  Enable DHCP</di */ \
	0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e, /* v>..<div><label> */ \
	0x49,0x50,0x20,0x41,0x64,0x64,0x72,0x65,0x73,0x73,0x3a,0x3c,0x2f,0x6c,0x61,0x62, /* IP Address:</lab */ \
	0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20, /* el>..<td><input  */ \
	0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65  /* type="text" name */
#define DATACHUNK00000e \
	0x3d,0x22,0x69,0x70,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x63,0x6f, /* ="ip" value="~co */ \
	0x6e,0x66,0x69,0x67,0x5f,0x69,0x70,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69, /* nfig_ip~" /></di */ \
	0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e, /* v>..<div><label> */ \
	0x47,0x61,0x74,0x65,0x77,0x61,0x79,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e, /* Gateway:</label> */ \
	0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70, /* ..<td><input typ */ \
	0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x67, /* e="text" name="g */ \
	0x77,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x63,0x6f,0x6e,0x66,0x69, /* w" value="~confi */ \
	0x67,0x5f,0x67,0x77,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d, /* g_gw~" /></div>. */ \
	0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x53,0x75,0x62, /* .<div><label>Sub */ \
	0x6e,0x65,0x74,0x20,0x4d,0x61,0x73,0x6b,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c, /* net Mask:</label */ \
	0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79, /* >..<td><input ty */ \
	0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22, /* pe="text" name=" */ \
	0x73,0x75,0x62,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x63,0x6f,0x6e, /* sub" value="~con */ \
	0x66,0x69,0x67,0x5f,0x73,0x75,0x62,0x6e,0x65,0x74,0x7e,0x22,0x20,0x2f,0x3e,0x3c, /* fig_subnet~" />< */ \
	0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62, /* /div>..<div><lab */ \
	0x65,0x6c,0x3e,0x50,0x72,0x69,0x6d,0x61,0x72,0x79,0x20,0x44,0x4e,0x53,0x3a,0x3c, /* el>Primary DNS:< */ \
	0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e, /* /label>..<td><in */ \
	0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20, /* put type="text"  */ \
	0x6e,0x61,0x6d,0x65,0x3d,0x22,0x64,0x6e,0x73,0x31,0x22,0x20,0x76,0x61,0x6c,0x75, /* name="dns1" valu */ \
	0x65,0x3d,0x22,0x7e,0x63,0x6f,0x6e,0x66,0x69,0x67,0x5f,0x64,0x6e,0x73,0x31,0x7e, /* e="~config_dns1~ */ \
	0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76, /* " /></div>..<div */ \
	0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x53,0x65,0x63,0x6f,0x6e,0x64,0x61,0x72, /* ><label>Secondar */ \
	0x79,0x20,0x44,0x4e,0x53,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a, /* y DNS:</label>.. */ \
	0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78, /* <input type="tex */ \
	0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x64,0x6e,0x73,0x32,0x22,0x20,0x76, /* t" name="dns2" v */ \
	0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x63,0x6f,0x6e,0x66,0x69,0x67,0x5f,0x64,0x6e, /* alue="~config_dn */ \
	0x73,0x32,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c, /* s2~" /></div>..< */ \
	0x64,0x69,0x76,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d, /* div><input type= */ \
	0x22,0x73,0x75,0x62,0x6d,0x69,0x74,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22, /* "submit" class=" */ \
	0x73,0x6d,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x53,0x61,0x76,0x65,0x20, /* sm" value="Save  */ \
	0x43,0x6f,0x6e,0x66,0x69,0x67,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e, /* Config" /></div> */ \
	0x0d,0x0a,0x3c,0x2f,0x66,0x69,0x65,0x6c,0x64,0x73,0x65,0x74,0x3e,0x0d,0x0a,0x3c, /* ..</fieldset>..< */ \
	0x2f,0x66,0x6f,0x72,0x6d,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a, /* /form>..</div>.. */ \
	0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x6c,0x61,0x6e,0x67,0x75,0x61, /* ..<script langua */ \
	0x67,0x65,0x3d,0x22,0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x3e, /* ge="javascript"> */ \
	0x0d,0x0a,0x3c,0x21,0x2d,0x2d,0x0d,0x0a,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e, /* ..<!--..function */ \
	0x20,0x63,0x6f,0x6e,0x66,0x69,0x67,0x49,0x50,0x42,0x6f,0x78,0x65,0x73,0x28,0x29, /*  configIPBoxes() */ \
	0x20,0x7b,0x0d,0x0a,0x09,0x65,0x20,0x3d,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e, /*  {...e = documen */ \
	0x74,0x2e,0x66,0x6f,0x72,0x6d,0x73,0x2e,0x63,0x6f,0x6e,0x66,0x69,0x67,0x3b,0x0d, /* t.forms.config;. */ \
	0x0a,0x09,0x73,0x74,0x20,0x3d,0x20,0x65,0x2e,0x64,0x68,0x63,0x70,0x2e,0x63,0x68, /* ..st = e.dhcp.ch */ \
	0x65,0x63,0x6b,0x65,0x64,0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x69,0x70,0x2e,0x64,0x69, /* ecked;...e.ip.di */ \
	0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a,0x09,0x65, /* sabled = st;...e */ \
	0x2e,0x67,0x77,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73, /* .gw.disabled = s */ \
	0x74,0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x73,0x75,0x62,0x2e,0x64,0x69,0x73,0x61,0x62, /* t;...e.sub.disab */ \
	0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x64,0x6e, /* led = st;...e.dn */ \
	0x73,0x31,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74, /* s1.disabled = st */ \
	0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x64,0x6e,0x73,0x32,0x2e,0x64,0x69,0x73,0x61,0x62, /* ;...e.dns2.disab */ \
	0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a,0x7d,0x0d,0x0a,0x64,0x6f, /* led = st;..}..do */ \
	0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x66,0x6f,0x72,0x6d,0x73,0x2e,0x63,0x6f,0x6e, /* cument.forms.con */ \
	0x66,0x69,0x67,0x2e,0x6d,0x61,0x63,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64, /* fig.mac.disabled */ \
	0x20,0x3d,0x20,0x74,0x72,0x75,0x65,0x3b,0x0d,0x0a,0x0d,0x0a,0x63,0x6f,0x6e,0x66, /*  = true;....conf */ \
	0x69,0x67,0x49,0x50,0x42,0x6f,0x78,0x65,0x73,0x28,0x29,0x3b,0x0d,0x0a,0x64,0x6f, /* igIPBoxes();..do */ \
	0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e, /* cument.getElemen */ \
	0x74,0x42,0x79,0x49,0x64,0x28,0x27,0x68,0x65,0x6c,0x6c,0x6f,0x27,0x29,0x2e,0x69, /* tById('hello').i */ \
	0x6e,0x6e,0x65,0x72,0x48,0x54,0x4d,0x4c,0x20,0x3d,0x20,0x22,0x7e,0x68,0x65,0x6c, /* nnerHTML = "~hel */ \
	0x6c,0x6f,0x6d,0x73,0x67,0x7e,0x22,0x3b,0x0d,0x0a,0x2f,0x2f,0x2d,0x2d,0x3e,0x0d, /* lomsg~";..//-->. */ \
	0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70,0x74,0x3e,0x0d,0x0a,0x7e,0x69,0x6e,0x63, /* .</script>..~inc */ \
	0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x00,0x00,0x00,0x00, /* :footer.inc~.... */ \
	0x33,0x00,0x00,0x00,0xde,0x00,0x00,0x00,0x25,0x00,0x00,0x00,0x3e,0x01,0x00,0x00, /* 3.......%...>... */ \
	0x4a,0x00,0x00,0x00,0xa2,0x01,0x00,0x00,0x4b,0x00,0x00,0x00,0x16,0x02,0x00,0x00, /* J.......K....... */ \
	0x4c,0x00,0x00,0x00,0x85,0x02,0x00,0x00,0x4d,0x00,0x00,0x00,0xfa,0x02,0x00,0x00, /* L.......M....... */ \
	0x4e,0x00,0x00,0x00,0x74,0x03,0x00,0x00,0x6e,0x00,0x00,0x00,0x05,0x06,0x00,0x00, /* N...t...n....... */ \
	0x61,0x00,0x00,0x00,0x60,0x06,0x00,0x00,0x6d,0x00,0x00,0x00,0x01,0x07,0x00,0x00, /* a...`...m....... */ \
	0x87,0x00,0x00,0x00,0x6e,0x07,0x00,0x00,0x5f,0x00,0x00,0x00,0xf5,0x07,0x00,0x00  /* ....n..._....... */
#define DATACHUNK00000f \
	0x27,0x00,0x00,0x00,0x69,0x08,0x00,0x00,0x28,0x00,0x00,0x00,0xc6,0x08,0x00,0x00, /* '...i...(....... */ \
	0x29,0x00,0x00,0x00,0x28,0x09,0x00,0x00,0x2a,0x00,0x00,0x00,0x8f,0x09,0x00,0x00, /* )...(........... */ \
	0x2b,0x00,0x00,0x00,0xf2,0x09,0x00,0x00,0x2c,0x00,0x00,0x00,0xc8,0x0b,0x00,0x00, /* +.......,....... */ \
	0x01,0x00,0x00,0x00,0xe8,0x0b,0x00,0x00,0x02,0x00,0x00,0x00,0x7e,0x69,0x6e,0x63, /* ............~inc */ \
	0x3a,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x64, /* :header.inc~..<d */ \
	0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e, /* iv id="content"> */ \
	0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x4c,0x6f,0x67,0x69,0x6e,0x20,0x53,0x75, /* ....<h1>Login Su */ \
	0x63,0x63,0x65,0x73,0x73,0x66,0x75,0x6c,0x3c,0x2f,0x68,0x31,0x3e,0x0d,0x0a,0x0d, /* ccessful</h1>... */ \
	0x0a,0x3c,0x70,0x3e,0x59,0x6f,0x75,0x20,0x68,0x61,0x76,0x65,0x20,0x73,0x75,0x63, /* .<p>You have suc */ \
	0x63,0x65,0x73,0x73,0x66,0x75,0x6c,0x6c,0x79,0x20,0x6c,0x6f,0x67,0x67,0x65,0x64, /* cessfully logged */ \
	0x20,0x69,0x6e,0x20,0x74,0x6f,0x20,0x74,0x68,0x65,0x20,0x77,0x65,0x62,0x20,0x73, /*  in to the web s */ \
	0x65,0x72,0x76,0x65,0x72,0x2e,0x20,0x20,0x54,0x68,0x69,0x73,0x20,0x61,0x75,0x74, /* erver.  This aut */ \
	0x68,0x65,0x6e,0x74,0x69,0x63,0x61,0x74,0x69,0x6f,0x6e,0x20,0x0d,0x0a,0x69,0x73, /* hentication ..is */ \
	0x20,0x76,0x61,0x6c,0x69,0x64,0x20,0x75,0x6e,0x74,0x69,0x6c,0x20,0x79,0x6f,0x75, /*  valid until you */ \
	0x20,0x63,0x6c,0x6f,0x73,0x65,0x20,0x79,0x6f,0x75,0x72,0x20,0x62,0x72,0x6f,0x77, /*  close your brow */ \
	0x73,0x65,0x72,0x2e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x3e,0x43, /* ser.</p>....<p>C */ \
	0x72,0x65,0x64,0x65,0x6e,0x74,0x69,0x61,0x6c,0x73,0x20,0x61,0x72,0x65,0x20,0x76, /* redentials are v */ \
	0x65,0x72,0x69,0x66,0x69,0x65,0x64,0x20,0x69,0x6e,0x20,0x79,0x6f,0x75,0x72,0x20, /* erified in your  */ \
	0x6f,0x77,0x6e,0x20,0x63,0x75,0x73,0x74,0x6f,0x6d,0x20,0x63,0x61,0x6c,0x6c,0x62, /* own custom callb */ \
	0x61,0x63,0x6b,0x20,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x20,0x63,0x61,0x6c, /* ack function cal */ \
	0x6c,0x65,0x64,0x20,0x0d,0x0a,0x3c,0x63,0x6f,0x64,0x65,0x3e,0x48,0x54,0x54,0x50, /* led ..<code>HTTP */ \
	0x41,0x75,0x74,0x68,0x65,0x6e,0x74,0x69,0x63,0x61,0x74,0x65,0x3c,0x2f,0x63,0x6f, /* Authenticate</co */ \
	0x64,0x65,0x3e,0x2e,0x20,0x20,0x49,0x6e,0x20,0x68,0x65,0x72,0x65,0x2c,0x20,0x79, /* de>.  In here, y */ \
	0x6f,0x75,0x20,0x63,0x61,0x6e,0x20,0x64,0x65,0x74,0x65,0x72,0x6d,0x69,0x6e,0x65, /* ou can determine */ \
	0x20,0x69,0x66,0x20,0x74,0x68,0x65,0x20,0x73,0x75,0x70,0x70,0x6c,0x69,0x65,0x64, /*  if the supplied */ \
	0x0d,0x0a,0x75,0x73,0x65,0x72,0x20,0x6e,0x61,0x6d,0x65,0x20,0x61,0x6e,0x64,0x20, /* ..user name and  */ \
	0x70,0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x20,0x61,0x72,0x65,0x20,0x76,0x61,0x6c, /* password are val */ \
	0x69,0x64,0x20,0x66,0x6f,0x72,0x20,0x61,0x63,0x63,0x65,0x73,0x73,0x20,0x74,0x6f, /* id for access to */ \
	0x20,0x74,0x68,0x65,0x20,0x72,0x65,0x71,0x75,0x65,0x73,0x74,0x65,0x64,0x20,0x70, /*  the requested p */ \
	0x61,0x67,0x65,0x2e,0x20,0x20,0x59,0x6f,0x75,0x20,0x63,0x61,0x6e,0x20,0x0d,0x0a, /* age.  You can .. */ \
	0x61,0x64,0x64,0x20,0x6d,0x75,0x6c,0x74,0x69,0x70,0x6c,0x65,0x20,0x75,0x73,0x65, /* add multiple use */ \
	0x72,0x73,0x20,0x61,0x6e,0x64,0x20,0x72,0x65,0x73,0x74,0x72,0x69,0x63,0x74,0x20, /* rs and restrict  */ \
	0x64,0x69,0x66,0x66,0x65,0x72,0x65,0x6e,0x74,0x20,0x75,0x73,0x65,0x72,0x73,0x20, /* different users  */ \
	0x74,0x6f,0x20,0x64,0x69,0x66,0x66,0x65,0x72,0x65,0x6e,0x74,0x20,0x70,0x61,0x67, /* to different pag */ \
	0x65,0x73,0x2e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x20,0x63,0x6c, /* es.</p>....<p cl */ \
	0x61,0x73,0x73,0x3d,0x22,0x65,0x78,0x65,0x72,0x63,0x69,0x73,0x65,0x22,0x3e,0x3c, /* ass="exercise">< */ \
	0x62,0x3e,0x45,0x78,0x65,0x72,0x63,0x69,0x73,0x65,0x3a,0x3c,0x2f,0x62,0x3e,0x20, /* b>Exercise:</b>  */ \
	0x43,0x68,0x61,0x6e,0x67,0x65,0x20,0x74,0x68,0x65,0x20,0x75,0x73,0x65,0x72,0x20, /* Change the user  */ \
	0x6e,0x61,0x6d,0x65,0x20,0x61,0x6e,0x64,0x20,0x70,0x61,0x73,0x73,0x77,0x6f,0x72, /* name and passwor */ \
	0x64,0x20,0x69,0x6e,0x0d,0x0a,0x3c,0x63,0x6f,0x64,0x65,0x3e,0x48,0x54,0x54,0x50, /* d in..<code>HTTP */ \
	0x41,0x75,0x74,0x68,0x65,0x6e,0x74,0x69,0x63,0x61,0x74,0x65,0x3c,0x2f,0x63,0x6f, /* Authenticate</co */ \
	0x64,0x65,0x3e,0x20,0x74,0x6f,0x20,0x6f,0x6e,0x65,0x20,0x6f,0x66,0x20,0x79,0x6f, /* de> to one of yo */ \
	0x75,0x72,0x20,0x63,0x68,0x6f,0x6f,0x73,0x69,0x6e,0x67,0x2e,0x20,0x20,0x28,0x54, /* ur choosing.  (T */ \
	0x68,0x65,0x20,0x63,0x61,0x6c,0x6c,0x62,0x61,0x63,0x6b,0x20,0x69,0x73,0x20,0x0d, /* he callback is . */ \
	0x0a,0x6c,0x6f,0x63,0x61,0x74,0x65,0x64,0x20,0x69,0x6e,0x20,0x3c,0x63,0x6f,0x64, /* .located in <cod */ \
	0x65,0x3e,0x43,0x75,0x73,0x74,0x6f,0x6d,0x48,0x54,0x54,0x50,0x41,0x70,0x70,0x2e, /* e>CustomHTTPApp. */ \
	0x63,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x2e,0x29,0x3c,0x2f,0x70,0x3e,0x0d,0x0a, /* c</code>.)</p>.. */ \
	0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x65,0x78, /* ..<div class="ex */ \
	0x61,0x6d,0x70,0x6c,0x65,0x62,0x6f,0x78,0x22,0x3e,0x0d,0x0a,0x57,0x68,0x65,0x6e, /* amplebox">..When */ \
	0x20,0x79,0x6f,0x75,0x20,0x66,0x69,0x6e,0x69,0x73,0x68,0x2c,0x20,0x72,0x65,0x66, /*  you finish, ref */ \
	0x72,0x65,0x73,0x68,0x20,0x74,0x68,0x69,0x73,0x20,0x70,0x61,0x67,0x65,0x20,0x74, /* resh this page t */ \
	0x6f,0x20,0x74,0x65,0x73,0x74,0x20,0x79,0x6f,0x75,0x72,0x20,0x6e,0x65,0x77,0x20, /* o test your new  */ \
	0x75,0x73,0x65,0x72,0x20,0x6e,0x61,0x6d,0x65,0x20,0x61,0x6e,0x64,0x20,0x70,0x61, /* user name and pa */ \
	0x73,0x73,0x77,0x6f,0x72,0x64,0x20,0x0d,0x0a,0x63,0x6f,0x6d,0x62,0x69,0x6e,0x61, /* ssword ..combina */ \
	0x74,0x69,0x6f,0x6e,0x2e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d, /* tion...</div>... */ \
	0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69, /* .</div>....<scri */ \
	0x70,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x2f,0x6a,0x61, /* pt type="text/ja */ \
	0x76,0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x0d,0x0a,0x3c,0x21,0x2d,0x2d, /* vascript">..<!-- */ \
	0x0d,0x0a,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x67,0x65,0x74,0x45,0x6c, /* ..document.getEl */ \
	0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28,0x27,0x68,0x65,0x6c,0x6c,0x6f, /* ementById('hello */ \
	0x27,0x29,0x2e,0x69,0x6e,0x6e,0x65,0x72,0x48,0x54,0x4d,0x4c,0x20,0x3d,0x20,0x22, /* ').innerHTML = " */ \
	0x7e,0x68,0x65,0x6c,0x6c,0x6f,0x6d,0x73,0x67,0x7e,0x22,0x3b,0x0d,0x0a,0x2f,0x2f, /* ~hellomsg~";..// */ \
	0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70,0x74,0x3e,0x0d,0x0a, /* -->..</script>.. */ \
	0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e  /* ..~inc:footer.in */
#define DATACHUNK000010 \
	0x63,0x7e,0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0x94,0x03,0x00,0x00,0x01,0x00, /* c~....3......... */ \
	0x00,0x00,0xb6,0x03,0x00,0x00,0x02,0x00,0x00,0x00,0x7e,0x72,0x65,0x62,0x6f,0x6f, /* ..........~reboo */ \
	0x74,0x7e,0x00,0x00,0x00,0x00,0x2d,0x00,0x00,0x00,0x7e,0x69,0x6e,0x63,0x3a,0x68, /* t~....-...~inc:h */ \
	0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76, /* eader.inc~..<div */ \
	0x20,0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a, /*  id="content">.. */ \
	0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x52,0x65,0x62,0x6f,0x6f,0x74,0x20,0x49,0x6e,0x20, /* ..<h1>Reboot In  */ \
	0x50,0x72,0x6f,0x67,0x72,0x65,0x73,0x73,0x2e,0x2e,0x2e,0x3c,0x2f,0x68,0x31,0x3e, /* Progress...</h1> */ \
	0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x3e,0x59,0x6f,0x75,0x72,0x20,0x73,0x65,0x74,0x74, /* ....<p>Your sett */ \
	0x69,0x6e,0x67,0x73,0x20,0x77,0x65,0x72,0x65,0x20,0x73,0x75,0x63,0x63,0x65,0x73, /* ings were succes */ \
	0x73,0x66,0x75,0x6c,0x6c,0x79,0x20,0x73,0x61,0x76,0x65,0x64,0x2c,0x20,0x61,0x6e, /* sfully saved, an */ \
	0x64,0x20,0x74,0x68,0x65,0x20,0x62,0x6f,0x61,0x72,0x64,0x20,0x69,0x73,0x20,0x6e, /* d the board is n */ \
	0x6f,0x77,0x20,0x72,0x65,0x62,0x6f,0x6f,0x74,0x69,0x6e,0x67,0x20,0x0d,0x0a,0x74, /* ow rebooting ..t */ \
	0x6f,0x20,0x63,0x6f,0x6e,0x66,0x69,0x67,0x75,0x72,0x65,0x20,0x69,0x74,0x73,0x65, /* o configure itse */ \
	0x6c,0x66,0x20,0x77,0x69,0x74,0x68,0x20,0x74,0x68,0x65,0x20,0x6e,0x65,0x77,0x20, /* lf with the new  */ \
	0x73,0x65,0x74,0x74,0x69,0x6e,0x67,0x73,0x2e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d, /* settings.</p>... */ \
	0x0a,0x3c,0x70,0x20,0x61,0x6c,0x69,0x67,0x6e,0x3d,0x22,0x63,0x65,0x6e,0x74,0x65, /* .<p align="cente */ \
	0x72,0x22,0x3e,0x3c,0x62,0x3e,0x59,0x6f,0x75,0x72,0x20,0x62,0x6f,0x61,0x72,0x64, /* r"><b>Your board */ \
	0x20,0x69,0x73,0x20,0x6e,0x6f,0x77,0x20,0x6c,0x6f,0x63,0x61,0x74,0x65,0x64,0x20, /*  is now located  */ \
	0x61,0x74,0x3a,0x20,0x0d,0x0a,0x3c,0x61,0x20,0x68,0x72,0x65,0x66,0x3d,0x22,0x68, /* at: ..<a href="h */ \
	0x74,0x74,0x70,0x3a,0x2f,0x2f,0x7e,0x72,0x65,0x62,0x6f,0x6f,0x74,0x61,0x64,0x64, /* ttp://~rebootadd */ \
	0x72,0x7e,0x2f,0x22,0x3e,0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f,0x7e,0x72,0x65,0x62, /* r~/">http://~reb */ \
	0x6f,0x6f,0x74,0x61,0x64,0x64,0x72,0x7e,0x2f,0x3c,0x2f,0x61,0x3e,0x3c,0x2f,0x62, /* ootaddr~/</a></b */ \
	0x3e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x36,0x3e,0x3c,0x2f,0x68, /* ></p>....<h6></h */ \
	0x36,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a, /* 6>....</div>.... */ \
	0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x6c,0x61,0x6e,0x67,0x75,0x61,0x67,0x65, /* <script language */ \
	0x3d,0x22,0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x0d,0x0a, /* ="javascript">.. */ \
	0x3c,0x21,0x2d,0x2d,0x0d,0x0a,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x20,0x72, /* <!--..function r */ \
	0x65,0x62,0x6f,0x6f,0x74,0x44,0x75,0x6d,0x6d,0x79,0x28,0x78,0x29,0x7b,0x7d,0x0d, /* ebootDummy(x){}. */ \
	0x0a,0x73,0x65,0x74,0x54,0x69,0x6d,0x65,0x6f,0x75,0x74,0x28,0x22,0x6e,0x65,0x77, /* .setTimeout("new */ \
	0x41,0x4a,0x41,0x58,0x43,0x6f,0x6d,0x6d,0x61,0x6e,0x64,0x28,0x27,0x2f,0x70,0x72, /* AJAXCommand('/pr */ \
	0x6f,0x74,0x65,0x63,0x74,0x2f,0x72,0x65,0x62,0x6f,0x6f,0x74,0x2e,0x63,0x67,0x69, /* otect/reboot.cgi */ \
	0x27,0x2c,0x72,0x65,0x62,0x6f,0x6f,0x74,0x44,0x75,0x6d,0x6d,0x79,0x2c,0x66,0x61, /* ',rebootDummy,fa */ \
	0x6c,0x73,0x65,0x29,0x3b,0x22,0x2c,0x35,0x30,0x30,0x29,0x3b,0x0d,0x0a,0x2f,0x2f, /* lse);",500);..// */ \
	0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70,0x74,0x3e,0x0d,0x0a, /* -->..</script>.. */ \
	0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e, /* ~inc:footer.inc~ */ \
	0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0x0c,0x01,0x00,0x00,0x2e,0x00,0x00,0x00, /* ....3........... */ \
	0x22,0x01,0x00,0x00,0x2e,0x00,0x00,0x00,0xf6,0x01,0x00,0x00,0x02,0x00,0x00,0x00, /* "............... */ \
	0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e, /* ~inc:header.inc~ */ \
	0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65, /* ..<div id="conte */ \
	0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x55,0x73,0x65,0x72, /* nt">....<h1>User */ \
	0x20,0x49,0x44,0x20,0x61,0x6e,0x64,0x20,0x50,0x61,0x73,0x73,0x77,0x6f,0x72,0x64, /*  ID and Password */ \
	0x20,0x53,0x65,0x74,0x74,0x69,0x6e,0x67,0x3c,0x2f,0x68,0x31,0x3e,0x0d,0x0a,0x0d, /*  Setting</h1>... */ \
	0x0a,0x3c,0x66,0x6f,0x72,0x6d,0x20,0x6d,0x65,0x74,0x68,0x6f,0x64,0x3d,0x22,0x70, /* .<form method="p */ \
	0x6f,0x73,0x74,0x22,0x20,0x61,0x63,0x74,0x69,0x6f,0x6e,0x3d,0x22,0x2f,0x70,0x72, /* ost" action="/pr */ \
	0x6f,0x74,0x65,0x63,0x74,0x2f,0x75,0x73,0x65,0x72,0x2e,0x68,0x74,0x6d,0x22,0x20, /* otect/user.htm"  */ \
	0x6e,0x61,0x6d,0x65,0x3d,0x22,0x75,0x73,0x65,0x72,0x22,0x3e,0x0d,0x0a,0x3c,0x66, /* name="user">..<f */ \
	0x69,0x65,0x6c,0x64,0x73,0x65,0x74,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c, /* ieldset>..<div>< */ \
	0x6c,0x61,0x62,0x65,0x6c,0x3e,0x55,0x73,0x65,0x72,0x20,0x49,0x44,0x3a,0x3c,0x2f, /* label>User ID:</ */ \
	0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74, /* label>..<input t */ \
	0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d, /* ype="text" name= */ \
	0x22,0x75,0x73,0x65,0x72,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x75, /* "user" value="~u */ \
	0x73,0x65,0x72,0x5f,0x69,0x64,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76, /* ser_id~" /></div */ \
	0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x50, /* >..<div><label>P */ \
	0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e, /* assword:</label> */ \
	0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x70, /* ..<input type="p */ \
	0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x70, /* assword" name="p */ \
	0x77,0x64,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x75,0x73,0x65,0x72, /* wd" value="~user */ \
	0x5f,0x70,0x61,0x73,0x73,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e, /* _pass~" /></div> */ \
	0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x50,0x61, /* ..<div><label>Pa */ \
	0x73,0x73,0x77,0x6f,0x72,0x64,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d, /* ssword:</label>. */ \
	0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x70,0x61, /* .<input type="pa */ \
	0x73,0x73,0x77,0x6f,0x72,0x64,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x70,0x77, /* ssword" name="pw */ \
	0x64,0x43,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x75,0x73,0x65,0x72, /* dC" value="~user */ \
	0x5f,0x70,0x61,0x73,0x73,0x43,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76  /* _passC~" /></div */
#define DATACHUNK000011 \
	0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74, /* >..<div><input t */ \
	0x79,0x70,0x65,0x3d,0x22,0x62,0x75,0x74,0x74,0x6f,0x6e,0x22,0x20,0x20,0x6f,0x6e, /* ype="button"  on */ \
	0x43,0x6c,0x69,0x63,0x6b,0x3d,0x22,0x70,0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x43, /* Click="passwordC */ \
	0x68,0x65,0x63,0x6b,0x28,0x29,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61, /* heck()" class="a */ \
	0x64,0x31,0x62,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x53,0x61,0x76,0x65, /* d1b" value="Save */ \
	0x20,0x49,0x44,0x20,0x26,0x20,0x50,0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x22,0x2f, /*  ID & Password"/ */ \
	0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x69,0x65,0x6c,0x64, /* ></div>..</field */ \
	0x73,0x65,0x74,0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x6f,0x72,0x6d,0x3e,0x0d,0x0a,0x3c, /* set>..</form>..< */ \
	0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74, /* /div>....<script */ \
	0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x2f,0x6a,0x61,0x76,0x61, /*  type="text/java */ \
	0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x0d,0x0a,0x3c,0x21,0x2d,0x2d,0x0d,0x0a, /* script">..<!--.. */ \
	0x2f,0x2f,0x2d,0x2d,0x3e,0x0d,0x0a,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e, /* //-->..document. */ \
	0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28,0x27, /* getElementById(' */ \
	0x68,0x65,0x6c,0x6c,0x6f,0x27,0x29,0x2e,0x69,0x6e,0x6e,0x65,0x72,0x48,0x54,0x4d, /* hello').innerHTM */ \
	0x4c,0x20,0x3d,0x20,0x22,0x7e,0x68,0x65,0x6c,0x6c,0x6f,0x6d,0x73,0x67,0x7e,0x22, /* L = "~hellomsg~" */ \
	0x3b,0x0d,0x0a,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x20,0x70,0x61,0x73,0x73, /* ;..function pass */ \
	0x77,0x6f,0x72,0x64,0x43,0x68,0x65,0x63,0x6b,0x28,0x29,0x0d,0x0a,0x7b,0x0d,0x0a, /* wordCheck()..{.. */ \
	0x09,0x69,0x66,0x20,0x28,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x75,0x73, /* .if (document.us */ \
	0x65,0x72,0x2e,0x70,0x77,0x64,0x2e,0x76,0x61,0x6c,0x75,0x65,0x20,0x21,0x3d,0x20, /* er.pwd.value !=  */ \
	0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x75,0x73,0x65,0x72,0x2e,0x70,0x77, /* document.user.pw */ \
	0x64,0x43,0x2e,0x76,0x61,0x6c,0x75,0x65,0x29,0x0d,0x0a,0x09,0x7b,0x0d,0x0a,0x09, /* dC.value)...{... */ \
	0x09,0x61,0x6c,0x65,0x72,0x74,0x20,0x28,0x22,0x50,0x61,0x73,0x73,0x77,0x6f,0x72, /* .alert ("Passwor */ \
	0x64,0x20,0x6d,0x69,0x73,0x73,0x6d,0x61,0x74,0x63,0x68,0x21,0x22,0x29,0x3b,0x0d, /* d missmatch!");. */ \
	0x0a,0x09,0x09,0x72,0x65,0x74,0x75,0x72,0x6e,0x3b,0x0d,0x0a,0x09,0x7d,0x0d,0x0a, /* ...return;...}.. */ \
	0x09,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x75,0x73,0x65,0x72,0x2e,0x73, /* .document.user.s */ \
	0x75,0x62,0x6d,0x69,0x74,0x28,0x29,0x3b,0x0d,0x0a,0x0d,0x0a,0x7d,0x0d,0x0a,0x3c, /* ubmit();....}..< */ \
	0x2f,0x73,0x63,0x72,0x69,0x70,0x74,0x3e,0x0d,0x0a,0x0d,0x0a,0x7e,0x69,0x6e,0x63, /* /script>....~inc */ \
	0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x00,0x00,0x00,0x00, /* :footer.inc~.... */ \
	0x33,0x00,0x00,0x00,0xde,0x00,0x00,0x00,0x6a,0x00,0x00,0x00,0x3b,0x01,0x00,0x00, /* 3.......j...;... */ \
	0x6b,0x00,0x00,0x00,0x9b,0x01,0x00,0x00,0x6c,0x00,0x00,0x00,0x95,0x02,0x00,0x00, /* k.......l....... */ \
	0x01,0x00,0x00,0x00,0x5c,0x03,0x00,0x00,0x02,0x00,0x00,0x00                      /* ....\.......     */


/**************************************
 * MPFS2 C linkable symbols
 **************************************/
// For C18, these are split into seperate arrays because it speeds up compilation a lot.  
// For other compilers, the entire data array must be defined as a single variable to 
// ensure that the linker does not reorder the data chunks in Flash when compiler 
// optimizations are turned on.
#if defined(__18CXX)
	ROM BYTE MPFS_Start[] = {DATACHUNK000000};
	ROM BYTE MPFS_000001[] = {DATACHUNK000001};
	ROM BYTE MPFS_000002[] = {DATACHUNK000002};
	ROM BYTE MPFS_000003[] = {DATACHUNK000003};
	ROM BYTE MPFS_000004[] = {DATACHUNK000004};
	ROM BYTE MPFS_000005[] = {DATACHUNK000005};
	ROM BYTE MPFS_000006[] = {DATACHUNK000006};
	ROM BYTE MPFS_000007[] = {DATACHUNK000007};
	ROM BYTE MPFS_000008[] = {DATACHUNK000008};
	ROM BYTE MPFS_000009[] = {DATACHUNK000009};
	ROM BYTE MPFS_00000a[] = {DATACHUNK00000a};
	ROM BYTE MPFS_00000b[] = {DATACHUNK00000b};
	ROM BYTE MPFS_00000c[] = {DATACHUNK00000c};
	ROM BYTE MPFS_00000d[] = {DATACHUNK00000d};
	ROM BYTE MPFS_00000e[] = {DATACHUNK00000e};
	ROM BYTE MPFS_00000f[] = {DATACHUNK00000f};
	ROM BYTE MPFS_000010[] = {DATACHUNK000010};
	ROM BYTE MPFS_000011[] = {DATACHUNK000011};
#else
	ROM BYTE MPFS_Start[] = {DATACHUNK000000, DATACHUNK000001, DATACHUNK000002, DATACHUNK000003, DATACHUNK000004, DATACHUNK000005, DATACHUNK000006, DATACHUNK000007, DATACHUNK000008, DATACHUNK000009, DATACHUNK00000a, DATACHUNK00000b, DATACHUNK00000c, DATACHUNK00000d, DATACHUNK00000e, DATACHUNK00000f, DATACHUNK000010, DATACHUNK000011};
#endif


/**************************************************************
 * End of MPFS
 **************************************************************/
#endif // #if defined(STACK_USE_MPFS2)
#endif // #if !defined(MPFS_USE_EEPROM) && !defined(MPFS_USE_SPI_FLASH)
