/***************************************************************
 * MPFSImg2.c
 * Defines an MPFS2 image to be stored in program memory.
 *
 * NOT FOR HAND MODIFICATION
 * This file is automatically generated by the MPFS2 Utility
 * ALL MODIFICATIONS WILL BE OVERWRITTEN BY THE MPFS2 GENERATOR
 * Generated Thu Jun 02 2011 07:01:12 
 ***************************************************************/

#define __MPFSIMG2_C

#include "TCPIPConfig.h"
#if !defined(MPFS_USE_EEPROM) && !defined(MPFS_USE_SPI_FLASH)

#include "TCPIP Stack/TCPIP.h"
#if defined(STACK_USE_MPFS2)


/**************************************
 * MPFS2 Image Data
 **************************************/
#define DATACHUNK000000 \
	0x4d,0x50,0x46,0x53,0x02,0x01,0x24,0x00,0x4a,0xce,0xff,0xff,0xea,0x81,0xff,0xff, /* MPFS..$.J....... */ \
	0x2a,0xba,0xff,0xff,0x26,0x4f,0x6a,0xa6,0xff,0xff,0x26,0x2d,0x0a,0xa3,0xff,0xff, /* ....&Oj...&-.... */ \
	0x46,0xce,0xff,0xff,0x2a,0xcf,0x08,0xcf,0x3e,0x67,0x98,0xdb,0xcc,0x83,0xff,0xff, /* F.......>g...... */ \
	0x0a,0x85,0xff,0xff,0x0a,0x57,0xff,0xff,0x0a,0x2f,0xff,0xff,0xea,0x92,0xff,0xff, /* .....W.../...... */ \
	0x0a,0x4f,0xff,0xff,0x26,0xb6,0xff,0xff,0x8a,0xb6,0xff,0xff,0xea,0x8a,0xff,0xff, /* .O..&........... */ \
	0x68,0x03,0x00,0x00,0x84,0x04,0x00,0x00,0x40,0x05,0x00,0x00,0xc2,0x64,0xde,0x4d, /* h.......@....d.M */ \
	0x00,0x00,0x00,0x00,0x02,0x00,0x71,0x03,0x00,0x00,0xc4,0x09,0x00,0x00,0x18,0x00, /* ......q......... */ \
	0x00,0x00,0xc2,0x64,0xde,0x4d,0x00,0x00,0x00,0x00,0x00,0x00,0x72,0x03,0x00,0x00, /* ...d.M......r... */ \
	0xdc,0x09,0x00,0x00,0x98,0x08,0x00,0x00,0xc2,0x64,0xde,0x4d,0x00,0x00,0x00,0x00, /* .........d.M.... */ \
	0x02,0x00,0x7e,0x03,0x00,0x00,0x74,0x12,0x00,0x00,0x20,0x00,0x00,0x00,0xc2,0x64, /* ..~...t... ....d */ \
	0xde,0x4d,0x00,0x00,0x00,0x00,0x00,0x00,0x7f,0x03,0x00,0x00,0x94,0x12,0x00,0x00, /* .M.............. */ \
	0xf0,0x0a,0x00,0x00,0xc2,0x64,0xde,0x4d,0x00,0x00,0x00,0x00,0x02,0x00,0x8b,0x03, /* .....d.M........ */ \
	0x00,0x00,0x84,0x1d,0x00,0x00,0x98,0x00,0x00,0x00,0xc2,0x64,0xde,0x4d,0x00,0x00, /* ...........d.M.. */ \
	0x00,0x00,0x00,0x00,0x8c,0x03,0x00,0x00,0x1c,0x1e,0x00,0x00,0x9f,0x00,0x00,0x00, /* ................ */ \
	0xc2,0x64,0xde,0x4d,0x00,0x00,0x00,0x00,0x00,0x00,0x97,0x03,0x00,0x00,0xbb,0x1e, /* .d.M............ */ \
	0x00,0x00,0x08,0x0a,0x00,0x00,0xc2,0x64,0xde,0x4d,0x00,0x00,0x00,0x00,0x02,0x00, /* .......d.M...... */ \
	0xa1,0x03,0x00,0x00,0xc3,0x28,0x00,0x00,0x58,0x00,0x00,0x00,0xc2,0x64,0xde,0x4d, /* .....(..X....d.M */ \
	0x00,0x00,0x00,0x00,0x00,0x00,0xa2,0x03,0x00,0x00,0x1b,0x29,0x00,0x00,0x5e,0x04, /* ...........)..^. */ \
	0x00,0x00,0xc2,0x64,0xde,0x4d,0x00,0x00,0x00,0x00,0x00,0x00,0xad,0x03,0x00,0x00, /* ...d.M.......... */ \
	0x79,0x2d,0x00,0x00,0x3e,0x11,0x00,0x00,0xc2,0x64,0xde,0x4d,0x00,0x00,0x00,0x00, /* y-..>....d.M.... */ \
	0x02,0x00,0xb7,0x03,0x00,0x00,0xb7,0x3e,0x00,0x00,0x28,0x00,0x00,0x00,0xc2,0x64, /* .......>..(....d */ \
	0xde,0x4d,0x00,0x00,0x00,0x00,0x00,0x00,0xb8,0x03,0x00,0x00,0xdf,0x3e,0x00,0x00, /* .M...........>.. */ \
	0x11,0x00,0x00,0x00,0xc2,0x64,0xde,0x4d,0x00,0x00,0x00,0x00,0x02,0x00,0xc1,0x03, /* .....d.M........ */ \
	0x00,0x00,0xf0,0x3e,0x00,0x00,0x08,0x00,0x00,0x00,0xc2,0x64,0xde,0x4d,0x00,0x00, /* ...>.......d.M.. */ \
	0x00,0x00,0x00,0x00,0xc2,0x03,0x00,0x00,0xf8,0x3e,0x00,0x00,0x93,0x03,0x00,0x00, /* .........>...... */ \
	0xc2,0x64,0xde,0x4d,0x00,0x00,0x00,0x00,0x01,0x00,0xcb,0x03,0x00,0x00,0x8b,0x42, /* .d.M...........B */ \
	0x00,0x00,0xe2,0x04,0x00,0x00,0xc2,0x64,0xde,0x4d,0x00,0x00,0x00,0x00,0x01,0x00, /* .......d.M...... */ \
	0xd4,0x03,0x00,0x00,0x6d,0x47,0x00,0x00,0xc2,0x05,0x00,0x00,0xc2,0x64,0xde,0x4d, /* ....mG.......d.M */ \
	0x00,0x00,0x00,0x00,0x01,0x00,0xdc,0x03,0x00,0x00,0x2f,0x4d,0x00,0x00,0xb6,0x01, /* ........../M.... */ \
	0x00,0x00,0x81,0x90,0xe7,0x4d,0x00,0x00,0x00,0x00,0x00,0x00,0xe5,0x03,0x00,0x00, /* .....M.......... */ \
	0xe5,0x4e,0x00,0x00,0x41,0x01,0x00,0x00,0xc2,0x64,0xde,0x4d,0x00,0x00,0x00,0x00, /* .N..A....d.M.... */ \
	0x02,0x00,0xf0,0x03,0x00,0x00,0x26,0x50,0x00,0x00,0x68,0x00,0x00,0x00,0xc2,0x64, /* ......&P..h....d */ \
	0xde,0x4d,0x00,0x00,0x00,0x00,0x00,0x00,0xf1,0x03,0x00,0x00,0x8e,0x50,0x00,0x00, /* .M...........P.. */ \
	0xa0,0x03,0x00,0x00,0xc2,0x64,0xde,0x4d,0x00,0x00,0x00,0x00,0x02,0x00,0xfc,0x03, /* .....d.M........ */ \
	0x00,0x00,0x2e,0x54,0x00,0x00,0x20,0x00,0x00,0x00,0xc2,0x64,0xde,0x4d,0x00,0x00, /* ...T.. ....d.M.. */ \
	0x00,0x00,0x00,0x00,0xfd,0x03,0x00,0x00,0x4e,0x54,0x00,0x00,0xb5,0x05,0x00,0x00, /* ........NT...... */ \
	0xc2,0x64,0xde,0x4d,0x00,0x00,0x00,0x00,0x02,0x00,0x0e,0x04,0x00,0x00,0x03,0x5a, /* .d.M...........Z */ \
	0x00,0x00,0x60,0x00,0x00,0x00,0xc2,0x64,0xde,0x4d,0x00,0x00,0x00,0x00,0x00,0x00, /* ..`....d.M...... */ \
	0x0f,0x04,0x00,0x00,0x63,0x5a,0x00,0x00,0x54,0x07,0x00,0x00,0xc1,0x64,0xde,0x4d, /* ....cZ..T....d.M */ \
	0x00,0x00,0x00,0x00,0x02,0x00,0x1f,0x04,0x00,0x00,0xb7,0x61,0x00,0x00,0x30,0x00, /* ...........a..0. */ \
	0x00,0x00,0xc1,0x64,0xde,0x4d,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x04,0x00,0x00, /* ...d.M...... ... */ \
	0xe7,0x61,0x00,0x00,0x49,0x07,0x00,0x00,0xc1,0x64,0xde,0x4d,0x00,0x00,0x00,0x00, /* .a..I....d.M.... */ \
	0x02,0x00,0x33,0x04,0x00,0x00,0x30,0x69,0x00,0x00,0x60,0x00,0x00,0x00,0xc1,0x64, /* ..3...0i..`....d */ \
	0xde,0x4d,0x00,0x00,0x00,0x00,0x00,0x00,0x34,0x04,0x00,0x00,0x90,0x69,0x00,0x00, /* .M......4....i.. */ \
	0xc6,0x03,0x00,0x00,0xc1,0x64,0xde,0x4d,0x00,0x00,0x00,0x00,0x02,0x00,0x46,0x04, /* .....d.M......F. */ \
	0x00,0x00,0x56,0x6d,0x00,0x00,0x18,0x00,0x00,0x00,0xc1,0x64,0xde,0x4d,0x00,0x00, /* ..Vm.......d.M.. */ \
	0x00,0x00,0x00,0x00,0x47,0x04,0x00,0x00,0x6e,0x6d,0x00,0x00,0x08,0x00,0x00,0x00, /* ....G...nm...... */ \
	0xc1,0x64,0xde,0x4d,0x00,0x00,0x00,0x00,0x02,0x00,0x5a,0x04,0x00,0x00,0x76,0x6d, /* .d.M......Z...vm */ \
	0x00,0x00,0x08,0x00,0x00,0x00,0xc1,0x64,0xde,0x4d,0x00,0x00,0x00,0x00,0x00,0x00, /* .......d.M...... */ \
	0x5b,0x04,0x00,0x00,0x7e,0x6d,0x00,0x00,0x85,0x07,0x00,0x00,0xc1,0x64,0xde,0x4d, /* [...~m.......d.M */ \
	0x00,0x00,0x00,0x00,0x02,0x00,0x6e,0x04,0x00,0x00,0x03,0x75,0x00,0x00,0x20,0x00, /* ......n....u.. . */ \
	0x00,0x00,0xc1,0x64,0xde,0x4d,0x00,0x00,0x00,0x00,0x00,0x00,0x6f,0x04,0x00,0x00, /* ...d.M......o... */ \
	0x23,0x75,0x00,0x00,0x3d,0x05,0x00,0x00,0xc2,0x64,0xde,0x4d,0x00,0x00,0x00,0x00, /* #u..=....d.M.... */ \
	0x02,0x00,0x83,0x04,0x00,0x00,0x60,0x7a,0x00,0x00,0x48,0x00,0x00,0x00,0xc2,0x64, /* ......`z..H....d */ \
	0xde,0x4d,0x00,0x00,0x00,0x00,0x00,0x00,0x61,0x75,0x74,0x68,0x2e,0x68,0x74,0x6d, /* .M......auth.htm */ \
	0x00,0x00,0x63,0x6f,0x6f,0x6b,0x69,0x65,0x73,0x2e,0x68,0x74,0x6d,0x00,0x00,0x64, /* ..cookies.htm..d */ \
	0x79,0x6e,0x76,0x61,0x72,0x73,0x2e,0x68,0x74,0x6d,0x00,0x00,0x66,0x6f,0x6f,0x74, /* ynvars.htm..foot */ \
	0x65,0x72,0x2e,0x69,0x6e,0x63,0x00,0x66,0x6f,0x72,0x6d,0x73,0x2e,0x68,0x74,0x6d, /* er.inc.forms.htm */ \
	0x00,0x00,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63,0x00,0x69,0x6e,0x64, /* ..header.inc.ind */ \
	0x65,0x78,0x2e,0x68,0x74,0x6d,0x00,0x00,0x6c,0x65,0x64,0x73,0x2e,0x63,0x67,0x69, /* ex.htm..leds.cgi */ \
	0x00,0x00,0x6d,0x63,0x68,0x70,0x2e,0x63,0x73,0x73,0x00,0x6d,0x63,0x68,0x70,0x2e, /* ..mchp.css.mchp. */ \
	0x67,0x69,0x66,0x00,0x6d,0x63,0x68,0x70,0x2e,0x6a,0x73,0x00,0x73,0x6e,0x6d,0x70, /* gif.mchp.js.snmp */ \
	0x2e,0x62,0x69,0x62,0x00,0x73,0x74,0x61,0x74,0x75,0x73,0x2e,0x78,0x6d,0x6c,0x00, /* .bib.status.xml. */ \
	0x00,0x75,0x70,0x6c,0x6f,0x61,0x64,0x2e,0x68,0x74,0x6d,0x00,0x00,0x64,0x79,0x6e  /* .upload.htm..dyn */
#define DATACHUNK000001 \
	0x64,0x6e,0x73,0x2f,0x69,0x6e,0x64,0x65,0x78,0x2e,0x68,0x74,0x6d,0x00,0x00,0x65, /* dns/index.htm..e */ \
	0x6d,0x61,0x69,0x6c,0x2f,0x69,0x6e,0x64,0x65,0x78,0x2e,0x68,0x74,0x6d,0x00,0x00, /* mail/index.htm.. */ \
	0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x63,0x6f,0x6e,0x66,0x69,0x67,0x2e,0x68, /* protect/config.h */ \
	0x74,0x6d,0x00,0x00,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x69,0x6e,0x64,0x65, /* tm..protect/inde */ \
	0x78,0x2e,0x68,0x74,0x6d,0x00,0x00,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x72, /* x.htm..protect/r */ \
	0x65,0x62,0x6f,0x6f,0x74,0x2e,0x63,0x67,0x69,0x00,0x00,0x70,0x72,0x6f,0x74,0x65, /* eboot.cgi..prote */ \
	0x63,0x74,0x2f,0x72,0x65,0x62,0x6f,0x6f,0x74,0x2e,0x68,0x74,0x6d,0x00,0x00,0x73, /* ct/reboot.htm..s */ \
	0x6e,0x6d,0x70,0x2f,0x73,0x6e,0x6d,0x70,0x63,0x6f,0x6e,0x66,0x69,0x67,0x2e,0x68, /* nmp/snmpconfig.h */ \
	0x74,0x6d,0x00,0x00,0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72,0x2e, /* tm..~inc:header. */ \
	0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x63, /* inc~..<div id="c */ \
	0x6f,0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31,0x3e, /* ontent">....<h1> */ \
	0x41,0x75,0x74,0x68,0x65,0x6e,0x74,0x69,0x63,0x61,0x74,0x69,0x6f,0x6e,0x3c,0x2f, /* Authentication</ */ \
	0x68,0x31,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x3e,0x4d,0x61,0x6e,0x79,0x20,0x61, /* h1>....<p>Many a */ \
	0x70,0x70,0x6c,0x69,0x63,0x61,0x74,0x69,0x6f,0x6e,0x73,0x20,0x6e,0x65,0x65,0x64, /* pplications need */ \
	0x20,0x74,0x6f,0x20,0x72,0x65,0x73,0x74,0x72,0x69,0x63,0x74,0x20,0x61,0x63,0x63, /*  to restrict acc */ \
	0x65,0x73,0x73,0x20,0x74,0x6f,0x20,0x61,0x75,0x74,0x68,0x6f,0x72,0x69,0x7a,0x65, /* ess to authorize */ \
	0x64,0x20,0x75,0x73,0x65,0x72,0x73,0x2e,0x20,0x20,0x54,0x68,0x65,0x20,0x48,0x54, /* d users.  The HT */ \
	0x54,0x50,0x20,0x0d,0x0a,0x73,0x65,0x72,0x76,0x65,0x72,0x20,0x73,0x75,0x70,0x70, /* TP ..server supp */ \
	0x6f,0x72,0x74,0x73,0x20,0x42,0x61,0x73,0x69,0x63,0x20,0x48,0x54,0x54,0x50,0x20, /* orts Basic HTTP  */ \
	0x41,0x75,0x74,0x68,0x65,0x6e,0x74,0x69,0x63,0x61,0x74,0x69,0x6f,0x6e,0x20,0x74, /* Authentication t */ \
	0x6f,0x20,0x70,0x72,0x6f,0x76,0x69,0x64,0x65,0x20,0x74,0x68,0x69,0x73,0x20,0x66, /* o provide this f */ \
	0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x61,0x6c,0x69,0x74,0x79,0x2e,0x3c,0x2f,0x70, /* unctionality.</p */ \
	0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x3e,0x54,0x77,0x6f,0x20,0x66,0x75,0x6e,0x63, /* >....<p>Two func */ \
	0x74,0x69,0x6f,0x6e,0x73,0x20,0x61,0x72,0x65,0x20,0x69,0x6e,0x76,0x6f,0x6c,0x76, /* tions are involv */ \
	0x65,0x64,0x20,0x77,0x69,0x74,0x68,0x20,0x61,0x75,0x74,0x68,0x65,0x6e,0x74,0x69, /* ed with authenti */ \
	0x63,0x61,0x74,0x69,0x6f,0x6e,0x2c,0x20,0x62,0x6f,0x74,0x68,0x20,0x6f,0x66,0x20, /* cation, both of  */ \
	0x77,0x68,0x69,0x63,0x68,0x20,0x73,0x74,0x6f,0x72,0x65,0x20,0x61,0x0d,0x0a,0x72, /* which store a..r */ \
	0x65,0x74,0x75,0x72,0x6e,0x20,0x76,0x61,0x6c,0x75,0x65,0x20,0x69,0x6e,0x20,0x3c, /* eturn value in < */ \
	0x63,0x6f,0x64,0x65,0x3e,0x63,0x75,0x72,0x48,0x54,0x54,0x50,0x2e,0x69,0x73,0x41, /* code>curHTTP.isA */ \
	0x75,0x74,0x68,0x6f,0x72,0x69,0x7a,0x65,0x64,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e, /* uthorized</code> */ \
	0x2e,0x20,0x20,0x54,0x68,0x65,0x20,0x4d,0x53,0x42,0x20,0x6f,0x66,0x20,0x74,0x68, /* .  The MSB of th */ \
	0x69,0x73,0x20,0x76,0x61,0x6c,0x75,0x65,0x0d,0x0a,0x69,0x6e,0x64,0x69,0x63,0x61, /* is value..indica */ \
	0x74,0x65,0x73,0x20,0x77,0x68,0x65,0x74,0x68,0x65,0x72,0x20,0x6f,0x72,0x20,0x6e, /* tes whether or n */ \
	0x6f,0x74,0x20,0x61,0x63,0x63,0x65,0x73,0x73,0x20,0x69,0x73,0x20,0x61,0x6c,0x6c, /* ot access is all */ \
	0x6f,0x77,0x65,0x64,0x2e,0x20,0x20,0x54,0x68,0x65,0x20,0x66,0x69,0x72,0x73,0x74, /* owed.  The first */ \
	0x20,0x63,0x61,0x6c,0x6c,0x62,0x61,0x63,0x6b,0x2c,0x20,0x0d,0x0a,0x3c,0x63,0x6f, /*  callback, ..<co */ \
	0x64,0x65,0x3e,0x48,0x54,0x54,0x50,0x4e,0x65,0x65,0x64,0x73,0x41,0x75,0x74,0x68, /* de>HTTPNeedsAuth */ \
	0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x2c,0x20,0x64,0x65,0x74,0x65,0x72,0x6d,0x69, /* </code>, determi */ \
	0x6e,0x65,0x73,0x20,0x69,0x66,0x20,0x74,0x68,0x65,0x20,0x72,0x65,0x71,0x75,0x65, /* nes if the reque */ \
	0x73,0x74,0x65,0x64,0x20,0x70,0x61,0x67,0x65,0x20,0x72,0x65,0x71,0x75,0x69,0x72, /* sted page requir */ \
	0x65,0x73,0x0d,0x0a,0x76,0x61,0x6c,0x69,0x64,0x20,0x63,0x72,0x65,0x64,0x65,0x6e, /* es..valid creden */ \
	0x74,0x69,0x61,0x6c,0x73,0x20,0x74,0x6f,0x20,0x70,0x72,0x6f,0x63,0x65,0x65,0x64, /* tials to proceed */ \
	0x2e,0x20,0x20,0x52,0x65,0x74,0x75,0x72,0x6e,0x20,0x61,0x20,0x76,0x61,0x6c,0x75, /* .  Return a valu */ \
	0x65,0x20,0x6f,0x66,0x20,0x3c,0x63,0x6f,0x64,0x65,0x3e,0x30,0x78,0x38,0x30,0x3c, /* e of <code>0x80< */ \
	0x2f,0x63,0x6f,0x64,0x65,0x3e,0x20,0x6f,0x72,0x20,0x67,0x72,0x65,0x61,0x74,0x65, /* /code> or greate */ \
	0x72,0x20,0x0d,0x0a,0x74,0x6f,0x20,0x61,0x6c,0x6c,0x6f,0x77,0x20,0x61,0x63,0x63, /* r ..to allow acc */ \
	0x65,0x73,0x73,0x20,0x75,0x6e,0x63,0x6f,0x6e,0x64,0x69,0x74,0x69,0x6f,0x6e,0x61, /* ess unconditiona */ \
	0x6c,0x6c,0x79,0x2e,0x20,0x20,0x52,0x65,0x74,0x75,0x72,0x6e,0x20,0x3c,0x63,0x6f, /* lly.  Return <co */ \
	0x64,0x65,0x3e,0x30,0x78,0x37,0x39,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x20,0x6f, /* de>0x79</code> o */ \
	0x72,0x20,0x6c,0x6f,0x77,0x65,0x72,0x20,0x74,0x6f,0x20,0x72,0x65,0x71,0x75,0x69, /* r lower to requi */ \
	0x72,0x65,0x20,0x0d,0x0a,0x61,0x75,0x74,0x68,0x6f,0x72,0x69,0x7a,0x61,0x74,0x69, /* re ..authorizati */ \
	0x6f,0x6e,0x2e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x54,0x68,0x65,0x20,0x73, /* on.</p>....The s */ \
	0x65,0x63,0x6f,0x6e,0x64,0x2c,0x20,0x3c,0x63,0x6f,0x64,0x65,0x3e,0x48,0x54,0x54, /* econd, <code>HTT */ \
	0x50,0x56,0x65,0x72,0x69,0x66,0x79,0x41,0x75,0x74,0x68,0x3c,0x2f,0x63,0x6f,0x64, /* PVerifyAuth</cod */ \
	0x65,0x3e,0x20,0x64,0x65,0x74,0x65,0x72,0x6d,0x69,0x6e,0x65,0x73,0x20,0x69,0x66, /* e> determines if */ \
	0x20,0x74,0x68,0x65,0x20,0x73,0x75,0x70,0x70,0x6c,0x69,0x65,0x64,0x20,0x63,0x72, /*  the supplied cr */ \
	0x65,0x64,0x65,0x6e,0x74,0x69,0x61,0x6c,0x73,0x20,0x0d,0x0a,0x61,0x72,0x65,0x20, /* edentials ..are  */ \
	0x61,0x63,0x63,0x65,0x70,0x74,0x61,0x62,0x6c,0x65,0x20,0x66,0x6f,0x72,0x20,0x74, /* acceptable for t */ \
	0x68,0x65,0x20,0x72,0x65,0x71,0x75,0x65,0x73,0x74,0x65,0x64,0x20,0x70,0x61,0x67, /* he requested pag */ \
	0x65,0x2e,0x20,0x20,0x59,0x6f,0x75,0x72,0x20,0x61,0x70,0x70,0x6c,0x69,0x63,0x61, /* e.  Your applica */ \
	0x74,0x69,0x6f,0x6e,0x20,0x73,0x68,0x6f,0x75,0x6c,0x64,0x20,0x72,0x65,0x74,0x75, /* tion should retu */ \
	0x72,0x6e,0x20,0x61,0x20,0x76,0x61,0x6c,0x75,0x65,0x20,0x0d,0x0a,0x67,0x72,0x65, /* rn a value ..gre */ \
	0x61,0x74,0x65,0x72,0x20,0x74,0x68,0x61,0x6e,0x20,0x3c,0x63,0x6f,0x64,0x65,0x3e, /* ater than <code> */ \
	0x30,0x78,0x38,0x30,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x20,0x74,0x6f,0x20,0x70  /* 0x80</code> to p */
#define DATACHUNK000002 \
	0x65,0x72,0x6d,0x69,0x74,0x20,0x61,0x63,0x63,0x65,0x73,0x73,0x2c,0x20,0x6f,0x72, /* ermit access, or */ \
	0x20,0x61,0x20,0x76,0x61,0x6c,0x75,0x65,0x20,0x6c,0x65,0x73,0x73,0x20,0x74,0x68, /*  a value less th */ \
	0x61,0x6e,0x20,0x0d,0x0a,0x3c,0x63,0x6f,0x64,0x65,0x3e,0x30,0x78,0x37,0x39,0x3c, /* an ..<code>0x79< */ \
	0x2f,0x63,0x6f,0x64,0x65,0x3e,0x20,0x74,0x6f,0x20,0x72,0x65,0x6a,0x65,0x63,0x74, /* /code> to reject */ \
	0x20,0x74,0x68,0x65,0x20,0x70,0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x20,0x73,0x75, /*  the password su */ \
	0x70,0x70,0x6c,0x69,0x65,0x64,0x2e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c, /* pplied.</p>....< */ \
	0x70,0x3e,0x41,0x73,0x20,0x61,0x6e,0x20,0x65,0x78,0x61,0x6d,0x70,0x6c,0x65,0x2c, /* p>As an example, */ \
	0x20,0x61,0x63,0x63,0x65,0x73,0x73,0x20,0x74,0x68,0x69,0x73,0x20,0x72,0x65,0x73, /*  access this res */ \
	0x74,0x72,0x69,0x63,0x74,0x65,0x64,0x20,0x70,0x61,0x67,0x65,0x3a,0x3c,0x2f,0x70, /* tricted page:</p */ \
	0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d, /* >....<div class= */ \
	0x22,0x65,0x78,0x61,0x6d,0x70,0x6c,0x65,0x62,0x6f,0x78,0x22,0x3e,0x0d,0x0a,0x3c, /* "examplebox">..< */ \
	0x62,0x3e,0x55,0x73,0x65,0x72,0x20,0x4e,0x61,0x6d,0x65,0x3a,0x3c,0x2f,0x62,0x3e, /* b>User Name:</b> */ \
	0x20,0x61,0x64,0x6d,0x69,0x6e,0x20,0x26,0x6e,0x62,0x73,0x70,0x3b,0x20,0x26,0x6e, /*  admin &nbsp; &n */ \
	0x62,0x73,0x70,0x3b,0x20,0x26,0x6e,0x62,0x73,0x70,0x3b,0x20,0x3c,0x62,0x3e,0x50, /* bsp; &nbsp; <b>P */ \
	0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x3a,0x3c,0x2f,0x62,0x3e,0x20,0x6d,0x69,0x63, /* assword:</b> mic */ \
	0x72,0x6f,0x63,0x68,0x69,0x70,0x3c,0x62,0x72,0x20,0x2f,0x3e,0x0d,0x0a,0x3c,0x61, /* rochip<br />..<a */ \
	0x20,0x68,0x72,0x65,0x66,0x3d,0x22,0x2f,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x22, /*  href="/protect" */ \
	0x3e,0x41,0x63,0x63,0x65,0x73,0x73,0x20,0x52,0x65,0x73,0x74,0x72,0x69,0x63,0x74, /* >Access Restrict */ \
	0x65,0x64,0x20,0x50,0x61,0x67,0x65,0x3c,0x2f,0x61,0x3e,0x0d,0x0a,0x3c,0x2f,0x64, /* ed Page</a>..</d */ \
	0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d, /* iv>....</div>... */ \
	0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74, /* .<script type="t */ \
	0x65,0x78,0x74,0x2f,0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x3e, /* ext/javascript"> */ \
	0x0d,0x0a,0x3c,0x21,0x2d,0x2d,0x0d,0x0a,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74, /* ..<!--..document */ \
	0x2e,0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28, /* .getElementById( */ \
	0x27,0x68,0x65,0x6c,0x6c,0x6f,0x27,0x29,0x2e,0x69,0x6e,0x6e,0x65,0x72,0x48,0x54, /* 'hello').innerHT */ \
	0x4d,0x4c,0x20,0x3d,0x20,0x22,0x7e,0x68,0x65,0x6c,0x6c,0x6f,0x6d,0x73,0x67,0x7e, /* ML = "~hellomsg~ */ \
	0x22,0x3b,0x0d,0x0a,0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70, /* ";..-->..</scrip */ \
	0x74,0x3e,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e, /* t>..~inc:footer. */ \
	0x69,0x6e,0x63,0x7e,0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0x12,0x05,0x00,0x00, /* inc~....3....... */ \
	0x01,0x00,0x00,0x00,0x30,0x05,0x00,0x00,0x02,0x00,0x00,0x00,0x7e,0x69,0x6e,0x63, /* ....0.......~inc */ \
	0x3a,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x64, /* :header.inc~..<d */ \
	0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e, /* iv id="content"> */ \
	0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x43,0x6f,0x6f,0x6b,0x69,0x65,0x73,0x3c, /* ....<h1>Cookies< */ \
	0x2f,0x68,0x31,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x3e,0x43,0x6f,0x6f,0x6b,0x69, /* /h1>....<p>Cooki */ \
	0x65,0x73,0x20,0x61,0x72,0x65,0x20,0x73,0x6d,0x61,0x6c,0x6c,0x20,0x74,0x65,0x78, /* es are small tex */ \
	0x74,0x20,0x73,0x74,0x72,0x69,0x6e,0x67,0x73,0x20,0x74,0x68,0x61,0x74,0x20,0x61, /* t strings that a */ \
	0x72,0x65,0x20,0x73,0x74,0x6f,0x72,0x65,0x64,0x20,0x69,0x6e,0x20,0x74,0x68,0x65, /* re stored in the */ \
	0x20,0x62,0x72,0x6f,0x77,0x73,0x65,0x72,0x2e,0x20,0x20,0x54,0x68,0x65,0x73,0x65, /*  browser.  These */ \
	0x20,0x73,0x74,0x72,0x69,0x6e,0x67,0x73,0x20,0x0d,0x0a,0x61,0x72,0x65,0x20,0x73, /*  strings ..are s */ \
	0x65,0x74,0x20,0x62,0x79,0x20,0x74,0x68,0x65,0x20,0x73,0x65,0x72,0x76,0x65,0x72, /* et by the server */ \
	0x2c,0x20,0x61,0x6e,0x64,0x20,0x72,0x65,0x74,0x75,0x72,0x6e,0x65,0x64,0x20,0x61, /* , and returned a */ \
	0x73,0x20,0x70,0x61,0x72,0x61,0x6d,0x65,0x74,0x65,0x72,0x73,0x20,0x66,0x6f,0x72, /* s parameters for */ \
	0x20,0x61,0x6c,0x6c,0x20,0x66,0x75,0x74,0x75,0x72,0x65,0x20,0x72,0x65,0x71,0x75, /*  all future requ */ \
	0x65,0x73,0x74,0x73,0x20,0x75,0x6e,0x74,0x69,0x6c,0x20,0x0d,0x0a,0x74,0x68,0x65, /* ests until ..the */ \
	0x20,0x73,0x65,0x73,0x73,0x69,0x6f,0x6e,0x20,0x65,0x6e,0x64,0x73,0x2e,0x20,0x20, /*  session ends.   */ \
	0x54,0x68,0x65,0x79,0x20,0x63,0x61,0x6e,0x20,0x62,0x65,0x20,0x75,0x73,0x65,0x64, /* They can be used */ \
	0x20,0x74,0x6f,0x20,0x73,0x74,0x6f,0x72,0x65,0x20,0x73,0x65,0x73,0x73,0x69,0x6f, /*  to store sessio */ \
	0x6e,0x20,0x73,0x74,0x61,0x74,0x65,0x20,0x69,0x6e,0x66,0x6f,0x72,0x6d,0x61,0x74, /* n state informat */ \
	0x69,0x6f,0x6e,0x2c,0x20,0x61,0x6e,0x64,0x20,0x61,0x72,0x65,0x20,0x0d,0x0a,0x76, /* ion, and are ..v */ \
	0x61,0x6c,0x69,0x64,0x20,0x75,0x6e,0x74,0x69,0x6c,0x20,0x74,0x68,0x65,0x20,0x62, /* alid until the b */ \
	0x72,0x6f,0x77,0x73,0x65,0x72,0x20,0x69,0x73,0x20,0x63,0x6c,0x6f,0x73,0x65,0x64, /* rowser is closed */ \
	0x2e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x63,0x6c, /* .</p>....<div cl */ \
	0x61,0x73,0x73,0x3d,0x22,0x65,0x78,0x61,0x6d,0x70,0x6c,0x65,0x62,0x6f,0x78,0x22, /* ass="examplebox" */ \
	0x3e,0x0d,0x0a,0x3c,0x74,0x61,0x62,0x6c,0x65,0x20,0x61,0x6c,0x69,0x67,0x6e,0x3d, /* >..<table align= */ \
	0x22,0x63,0x65,0x6e,0x74,0x65,0x72,0x22,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c, /* "center">..<tr>< */ \
	0x74,0x64,0x3e,0x3c,0x62,0x3e,0x4e,0x61,0x6d,0x65,0x3a,0x3c,0x2f,0x62,0x3e,0x3c, /* td><b>Name:</b>< */ \
	0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x63,0x6f,0x6f,0x6b,0x69,0x65,0x6e, /* /td><td>~cookien */ \
	0x61,0x6d,0x65,0x7e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a, /* ame~</td></tr>.. */ \
	0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x46,0x61,0x76,0x6f,0x72, /* <tr><td><b>Favor */ \
	0x69,0x74,0x65,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64, /* ite:</b></td><td */ \
	0x3e,0x6e,0x6f,0x74,0x20,0x69,0x6d,0x70,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x65,0x64, /* >not implemented */ \
	0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x2f,0x74,0x61, /* </td></tr>..</ta */ \
	0x62,0x6c,0x65,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a, /* ble>..</div>.... */ \
	0x3c,0x70,0x3e,0x54,0x68,0x65,0x72,0x65,0x20,0x61,0x72,0x65,0x20,0x6e,0x75,0x6d  /* <p>There are num */
#define DATACHUNK000003 \
	0x65,0x72,0x6f,0x75,0x73,0x20,0x75,0x73,0x65,0x73,0x20,0x66,0x6f,0x72,0x20,0x63, /* erous uses for c */ \
	0x6f,0x6f,0x6b,0x69,0x65,0x73,0x2e,0x20,0x20,0x49,0x6e,0x20,0x74,0x68,0x69,0x73, /* ookies.  In this */ \
	0x20,0x65,0x78,0x61,0x6d,0x70,0x6c,0x65,0x2c,0x20,0x74,0x68,0x65,0x20,0x75,0x73, /*  example, the us */ \
	0x65,0x72,0x27,0x73,0x20,0x6e,0x61,0x6d,0x65,0x20,0x69,0x73,0x20,0x0d,0x0a,0x73, /* er's name is ..s */ \
	0x74,0x6f,0x72,0x65,0x64,0x20,0x61,0x73,0x20,0x61,0x20,0x63,0x6f,0x6f,0x6b,0x69, /* tored as a cooki */ \
	0x65,0x2e,0x20,0x20,0x41,0x6c,0x6c,0x20,0x66,0x75,0x74,0x75,0x72,0x65,0x20,0x70, /* e.  All future p */ \
	0x61,0x67,0x65,0x20,0x6c,0x6f,0x61,0x64,0x73,0x20,0x77,0x69,0x6c,0x6c,0x20,0x73, /* age loads will s */ \
	0x68,0x6f,0x77,0x20,0x74,0x68,0x69,0x73,0x20,0x6e,0x61,0x6d,0x65,0x20,0x69,0x6e, /* how this name in */ \
	0x20,0x74,0x68,0x65,0x20,0x74,0x6f,0x70,0x20,0x6c,0x65,0x66,0x74,0x20,0x0d,0x0a, /*  the top left .. */ \
	0x63,0x6f,0x72,0x6e,0x65,0x72,0x2c,0x20,0x61,0x73,0x20,0x77,0x65,0x6c,0x6c,0x20, /* corner, as well  */ \
	0x61,0x73,0x20,0x69,0x6e,0x20,0x74,0x68,0x65,0x20,0x62,0x6f,0x78,0x20,0x61,0x62, /* as in the box ab */ \
	0x6f,0x76,0x65,0x2e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x66,0x6f,0x72, /* ove.</p>....<for */ \
	0x6d,0x20,0x61,0x63,0x74,0x69,0x6f,0x6e,0x3d,0x22,0x63,0x6f,0x6f,0x6b,0x69,0x65, /* m action="cookie */ \
	0x73,0x2e,0x68,0x74,0x6d,0x22,0x20,0x6d,0x65,0x74,0x68,0x6f,0x64,0x3d,0x22,0x67, /* s.htm" method="g */ \
	0x65,0x74,0x22,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x63,0x6c,0x61,0x73,0x73, /* et">..<div class */ \
	0x3d,0x22,0x65,0x78,0x61,0x6d,0x70,0x6c,0x65,0x62,0x6f,0x78,0x22,0x3e,0x0d,0x0a, /* ="examplebox">.. */ \
	0x3c,0x74,0x61,0x62,0x6c,0x65,0x20,0x61,0x6c,0x69,0x67,0x6e,0x3d,0x22,0x63,0x65, /* <table align="ce */ \
	0x6e,0x74,0x65,0x72,0x22,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e, /* nter">..<tr><td> */ \
	0x3c,0x62,0x3e,0x46,0x69,0x72,0x73,0x74,0x20,0x4e,0x61,0x6d,0x65,0x3a,0x3c,0x2f, /* <b>First Name:</ */ \
	0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75, /* b></td><td><inpu */ \
	0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61, /* t type="text" na */ \
	0x6d,0x65,0x3d,0x22,0x6e,0x61,0x6d,0x65,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22, /* me="name" size=" */ \
	0x32,0x30,0x22,0x20,0x6d,0x61,0x78,0x6c,0x65,0x6e,0x67,0x74,0x68,0x3d,0x22,0x31, /* 20" maxlength="1 */ \
	0x36,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d, /* 6" /></td></tr>. */ \
	0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x46,0x61,0x76,0x6f, /* .<tr><td><b>Favo */ \
	0x72,0x69,0x74,0x65,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74, /* rite:</b></td><t */ \
	0x64,0x3e,0x0d,0x0a,0x3c,0x73,0x65,0x6c,0x65,0x63,0x74,0x20,0x6e,0x61,0x6d,0x65, /* d>..<select name */ \
	0x3d,0x22,0x66,0x61,0x76,0x22,0x3e,0x0d,0x0a,0x3c,0x6f,0x70,0x74,0x69,0x6f,0x6e, /* ="fav">..<option */ \
	0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x50,0x49,0x43,0x31,0x38,0x22,0x3e,0x50, /*  value="PIC18">P */ \
	0x49,0x43,0x31,0x38,0x3c,0x2f,0x6f,0x70,0x74,0x69,0x6f,0x6e,0x3e,0x0d,0x0a,0x3c, /* IC18</option>..< */ \
	0x6f,0x70,0x74,0x69,0x6f,0x6e,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x50,0x49, /* option value="PI */ \
	0x43,0x32,0x34,0x22,0x3e,0x50,0x49,0x43,0x32,0x34,0x3c,0x2f,0x6f,0x70,0x74,0x69, /* C24">PIC24</opti */ \
	0x6f,0x6e,0x3e,0x0d,0x0a,0x3c,0x6f,0x70,0x74,0x69,0x6f,0x6e,0x20,0x76,0x61,0x6c, /* on>..<option val */ \
	0x75,0x65,0x3d,0x22,0x64,0x73,0x50,0x49,0x43,0x22,0x3e,0x64,0x73,0x50,0x49,0x43, /* ue="dsPIC">dsPIC */ \
	0x3c,0x2f,0x6f,0x70,0x74,0x69,0x6f,0x6e,0x3e,0x0d,0x0a,0x3c,0x6f,0x70,0x74,0x69, /* </option>..<opti */ \
	0x6f,0x6e,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x50,0x49,0x43,0x33,0x32,0x22, /* on value="PIC32" */ \
	0x3e,0x50,0x49,0x43,0x33,0x32,0x3c,0x2f,0x6f,0x70,0x74,0x69,0x6f,0x6e,0x3e,0x0d, /* >PIC32</option>. */ \
	0x0a,0x3c,0x2f,0x73,0x65,0x6c,0x65,0x63,0x74,0x3e,0x0d,0x0a,0x3c,0x2f,0x74,0x64, /* .</select>..</td */ \
	0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e, /* ></tr>..<tr><td> */ \
	0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20, /* </td><td><input  */ \
	0x74,0x79,0x70,0x65,0x3d,0x22,0x73,0x75,0x62,0x6d,0x69,0x74,0x22,0x20,0x76,0x61, /* type="submit" va */ \
	0x6c,0x75,0x65,0x3d,0x22,0x53,0x65,0x74,0x20,0x43,0x6f,0x6f,0x6b,0x69,0x65,0x73, /* lue="Set Cookies */ \
	0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a, /* " /></td></tr>.. */ \
	0x3c,0x2f,0x74,0x61,0x62,0x6c,0x65,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e, /* </table>..</div> */ \
	0x0d,0x0a,0x3c,0x2f,0x66,0x6f,0x72,0x6d,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x3e, /* ..</form>....<p> */ \
	0x43,0x6f,0x6f,0x6b,0x69,0x65,0x73,0x20,0x61,0x72,0x65,0x20,0x73,0x65,0x74,0x20, /* Cookies are set  */ \
	0x62,0x79,0x20,0x73,0x74,0x6f,0x72,0x69,0x6e,0x67,0x20,0x6e,0x75,0x6c,0x6c,0x2d, /* by storing null- */ \
	0x74,0x65,0x72,0x6d,0x69,0x6e,0x61,0x74,0x65,0x64,0x20,0x6e,0x61,0x6d,0x65,0x2f, /* terminated name/ */ \
	0x76,0x61,0x6c,0x75,0x65,0x20,0x70,0x61,0x69,0x72,0x73,0x20,0x69,0x6e,0x20,0x3c, /* value pairs in < */ \
	0x63,0x6f,0x64,0x65,0x3e,0x63,0x75,0x72,0x48,0x54,0x54,0x50,0x2e,0x64,0x61,0x74, /* code>curHTTP.dat */ \
	0x61,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x20,0x0d,0x0a,0x61,0x6e,0x64,0x20,0x69, /* a</code> ..and i */ \
	0x6e,0x64,0x69,0x63,0x61,0x74,0x69,0x6e,0x67,0x20,0x68,0x6f,0x77,0x20,0x6d,0x61, /* ndicating how ma */ \
	0x6e,0x79,0x20,0x63,0x6f,0x6f,0x6b,0x69,0x65,0x73,0x20,0x61,0x72,0x65,0x20,0x74, /* ny cookies are t */ \
	0x6f,0x20,0x62,0x65,0x20,0x73,0x65,0x74,0x20,0x69,0x6e,0x20,0x3c,0x63,0x6f,0x64, /* o be set in <cod */ \
	0x65,0x3e,0x63,0x75,0x72,0x48,0x54,0x54,0x50,0x2e,0x68,0x61,0x73,0x41,0x72,0x67, /* e>curHTTP.hasArg */ \
	0x73,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x2e,0x20,0x20,0x54,0x68,0x65,0x79,0x20, /* s</code>.  They  */ \
	0x0d,0x0a,0x63,0x61,0x6e,0x20,0x62,0x65,0x20,0x73,0x65,0x74,0x20,0x69,0x6e,0x20, /* ..can be set in  */ \
	0x65,0x69,0x74,0x68,0x65,0x72,0x20,0x3c,0x63,0x6f,0x64,0x65,0x3e,0x48,0x54,0x54, /* either <code>HTT */ \
	0x50,0x45,0x78,0x65,0x63,0x75,0x74,0x65,0x47,0x65,0x74,0x3c,0x2f,0x63,0x6f,0x64, /* PExecuteGet</cod */ \
	0x65,0x3e,0x20,0x6f,0x72,0x20,0x3c,0x63,0x6f,0x64,0x65,0x3e,0x48,0x54,0x54,0x50, /* e> or <code>HTTP */ \
	0x45,0x78,0x65,0x63,0x75,0x74,0x65,0x50,0x6f,0x73,0x74,0x3c,0x2f,0x63,0x6f,0x64, /* ExecutePost</cod */ \
	0x65,0x3e,0x2e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x3e,0x43,0x6f, /* e>.</p>....<p>Co */ \
	0x6f,0x6b,0x69,0x65,0x73,0x20,0x61,0x72,0x65,0x20,0x72,0x65,0x74,0x72,0x69,0x65, /* okies are retrie */ \
	0x76,0x65,0x64,0x20,0x69,0x6e,0x20,0x74,0x68,0x65,0x20,0x73,0x61,0x6d,0x65,0x20  /* ved in the same  */
#define DATACHUNK000004 \
	0x6d,0x61,0x6e,0x6e,0x65,0x72,0x20,0x61,0x73,0x20,0x47,0x45,0x54,0x20,0x66,0x6f, /* manner as GET fo */ \
	0x72,0x6d,0x20,0x61,0x72,0x67,0x75,0x6d,0x65,0x6e,0x74,0x73,0x2e,0x20,0x20,0x54, /* rm arguments.  T */ \
	0x68,0x65,0x79,0x20,0x61,0x72,0x65,0x20,0x73,0x74,0x6f,0x72,0x65,0x64,0x20,0x0d, /* hey are stored . */ \
	0x0a,0x69,0x6e,0x20,0x3c,0x63,0x6f,0x64,0x65,0x3e,0x63,0x75,0x72,0x48,0x54,0x54, /* .in <code>curHTT */ \
	0x50,0x2e,0x64,0x61,0x74,0x61,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x20,0x61,0x6e, /* P.data</code> an */ \
	0x64,0x20,0x63,0x61,0x6e,0x20,0x62,0x65,0x20,0x6c,0x6f,0x63,0x61,0x74,0x65,0x64, /* d can be located */ \
	0x20,0x75,0x73,0x69,0x6e,0x67,0x20,0x74,0x68,0x65,0x20,0x3c,0x63,0x6f,0x64,0x65, /*  using the <code */ \
	0x3e,0x48,0x54,0x54,0x50,0x47,0x65,0x74,0x41,0x72,0x67,0x3c,0x2f,0x63,0x6f,0x64, /* >HTTPGetArg</cod */ \
	0x65,0x3e,0x20,0x0d,0x0a,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x73,0x2e,0x20, /* e> ..functions.  */ \
	0x20,0x53,0x69,0x6e,0x63,0x65,0x20,0x74,0x68,0x65,0x79,0x20,0x61,0x72,0x65,0x20, /*  Since they are  */ \
	0x73,0x74,0x6f,0x72,0x65,0x64,0x20,0x69,0x6e,0x20,0x74,0x68,0x65,0x20,0x73,0x61, /* stored in the sa */ \
	0x6d,0x65,0x20,0x61,0x72,0x72,0x61,0x79,0x20,0x61,0x73,0x20,0x47,0x45,0x54,0x20, /* me array as GET  */ \
	0x61,0x72,0x67,0x75,0x6d,0x65,0x6e,0x74,0x73,0x2c,0x20,0x74,0x68,0x65,0x20,0x74, /* arguments, the t */ \
	0x6f,0x74,0x61,0x6c,0x20,0x0d,0x0a,0x6c,0x65,0x6e,0x67,0x74,0x68,0x20,0x6f,0x66, /* otal ..length of */ \
	0x20,0x63,0x6f,0x6f,0x6b,0x69,0x65,0x73,0x20,0x61,0x6e,0x64,0x20,0x76,0x61,0x72, /*  cookies and var */ \
	0x69,0x61,0x62,0x6c,0x65,0x20,0x61,0x72,0x67,0x75,0x6d,0x65,0x6e,0x74,0x73,0x20, /* iable arguments  */ \
	0x63,0x61,0x6e,0x6e,0x6f,0x74,0x20,0x65,0x78,0x63,0x65,0x65,0x64,0x20,0x74,0x68, /* cannot exceed th */ \
	0x65,0x20,0x38,0x30,0x20,0x62,0x79,0x74,0x65,0x20,0x62,0x75,0x66,0x66,0x65,0x72, /* e 80 byte buffer */ \
	0x20,0x6c,0x69,0x6d,0x69,0x74,0x2e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c, /*  limit.</p>....< */ \
	0x70,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x65,0x78,0x65,0x72,0x63,0x69,0x73, /* p class="exercis */ \
	0x65,0x22,0x3e,0x3c,0x62,0x3e,0x45,0x78,0x65,0x72,0x63,0x69,0x73,0x65,0x3a,0x3c, /* e"><b>Exercise:< */ \
	0x2f,0x62,0x3e,0x20,0x53,0x65,0x74,0x20,0x61,0x20,0x73,0x65,0x63,0x6f,0x6e,0x64, /* /b> Set a second */ \
	0x20,0x63,0x6f,0x6f,0x6b,0x69,0x65,0x20,0x6e,0x61,0x6d,0x65,0x64,0x20,0x3c,0x63, /*  cookie named <c */ \
	0x6f,0x64,0x65,0x3e,0x66,0x61,0x76,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x20,0x77, /* ode>fav</code> w */ \
	0x69,0x74,0x68,0x20,0x74,0x68,0x65,0x20,0x0d,0x0a,0x76,0x61,0x6c,0x75,0x65,0x20, /* ith the ..value  */ \
	0x6f,0x66,0x20,0x74,0x68,0x65,0x20,0x3c,0x63,0x6f,0x64,0x65,0x3e,0x66,0x61,0x76, /* of the <code>fav */ \
	0x6f,0x72,0x69,0x74,0x65,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x20,0x66,0x69,0x65, /* orite</code> fie */ \
	0x6c,0x64,0x20,0x61,0x6e,0x64,0x20,0x68,0x61,0x76,0x65,0x20,0x69,0x74,0x20,0x64, /* ld and have it d */ \
	0x69,0x73,0x70,0x6c,0x61,0x79,0x65,0x64,0x20,0x69,0x6e,0x20,0x74,0x68,0x65,0x20, /* isplayed in the  */ \
	0x67,0x72,0x61,0x79,0x20,0x62,0x6f,0x78,0x20,0x61,0x62,0x6f,0x76,0x65,0x2e,0x3c, /* gray box above.< */ \
	0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d, /* /p>....</div>... */ \
	0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74, /* .<script type="t */ \
	0x65,0x78,0x74,0x2f,0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x3e, /* ext/javascript"> */ \
	0x0d,0x0a,0x3c,0x21,0x2d,0x2d,0x0d,0x0a,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74, /* ..<!--..document */ \
	0x2e,0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28, /* .getElementById( */ \
	0x27,0x68,0x65,0x6c,0x6c,0x6f,0x27,0x29,0x2e,0x69,0x6e,0x6e,0x65,0x72,0x48,0x54, /* 'hello').innerHT */ \
	0x4d,0x4c,0x20,0x3d,0x20,0x22,0x7e,0x68,0x65,0x6c,0x6c,0x6f,0x6d,0x73,0x67,0x7e, /* ML = "~hellomsg~ */ \
	0x22,0x3b,0x0d,0x0a,0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70, /* ";..-->..</scrip */ \
	0x74,0x3e,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e, /* t>..~inc:footer. */ \
	0x69,0x6e,0x63,0x7e,0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0xac,0x01,0x00,0x00, /* inc~....3....... */ \
	0x03,0x00,0x00,0x00,0x6a,0x08,0x00,0x00,0x01,0x00,0x00,0x00,0x88,0x08,0x00,0x00, /* ....j........... */ \
	0x02,0x00,0x00,0x00,0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72,0x2e, /* ....~inc:header. */ \
	0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x63, /* inc~..<div id="c */ \
	0x6f,0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31,0x3e, /* ontent">....<h1> */ \
	0x44,0x79,0x6e,0x61,0x6d,0x69,0x63,0x20,0x56,0x61,0x72,0x69,0x61,0x62,0x6c,0x65, /* Dynamic Variable */ \
	0x73,0x3c,0x2f,0x68,0x31,0x3e,0x0d,0x0a,0x3c,0x70,0x3e,0x4f,0x6e,0x65,0x20,0x6f, /* s</h1>..<p>One o */ \
	0x66,0x20,0x74,0x68,0x65,0x20,0x6d,0x6f,0x73,0x74,0x20,0x62,0x61,0x73,0x69,0x63, /* f the most basic */ \
	0x20,0x6e,0x65,0x65,0x64,0x73,0x20,0x69,0x73,0x20,0x74,0x6f,0x20,0x70,0x72,0x6f, /*  needs is to pro */ \
	0x76,0x69,0x64,0x65,0x20,0x73,0x74,0x61,0x74,0x75,0x73,0x20,0x69,0x6e,0x66,0x6f, /* vide status info */ \
	0x72,0x6d,0x61,0x74,0x69,0x6f,0x6e,0x20,0x62,0x61,0x63,0x6b,0x20,0x74,0x6f,0x20, /* rmation back to  */ \
	0x74,0x68,0x65,0x20,0x75,0x73,0x65,0x72,0x20,0x6f,0x66,0x20,0x0d,0x0a,0x79,0x6f, /* the user of ..yo */ \
	0x75,0x72,0x20,0x77,0x65,0x62,0x20,0x61,0x70,0x70,0x6c,0x69,0x63,0x61,0x74,0x69, /* ur web applicati */ \
	0x6f,0x6e,0x2e,0x20,0x20,0x54,0x68,0x65,0x20,0x48,0x54,0x54,0x50,0x20,0x73,0x65, /* on.  The HTTP se */ \
	0x72,0x76,0x65,0x72,0x20,0x70,0x72,0x6f,0x76,0x69,0x64,0x65,0x73,0x20,0x66,0x6f, /* rver provides fo */ \
	0x72,0x20,0x74,0x68,0x69,0x73,0x20,0x75,0x73,0x69,0x6e,0x67,0x20,0x3c,0x69,0x3e, /* r this using <i> */ \
	0x64,0x79,0x6e,0x61,0x6d,0x69,0x63,0x20,0x0d,0x0a,0x76,0x61,0x72,0x69,0x61,0x62, /* dynamic ..variab */ \
	0x6c,0x65,0x20,0x73,0x75,0x62,0x73,0x74,0x69,0x74,0x75,0x74,0x69,0x6f,0x6e,0x20, /* le substitution  */ \
	0x63,0x61,0x6c,0x6c,0x62,0x61,0x63,0x6b,0x73,0x3c,0x2f,0x69,0x3e,0x2e,0x20,0x20, /* callbacks</i>.   */ \
	0x54,0x68,0x65,0x73,0x65,0x20,0x63,0x6f,0x6d,0x6d,0x61,0x6e,0x64,0x73,0x20,0x69, /* These commands i */ \
	0x6e,0x20,0x79,0x6f,0x75,0x72,0x20,0x48,0x54,0x4d,0x4c,0x20,0x63,0x6f,0x64,0x65, /* n your HTML code */ \
	0x20,0x77,0x69,0x6c,0x6c,0x0d,0x0a,0x61,0x6c,0x65,0x72,0x74,0x20,0x74,0x68,0x65, /*  will..alert the */ \
	0x20,0x73,0x65,0x72,0x76,0x65,0x72,0x20,0x74,0x6f,0x20,0x65,0x78,0x65,0x63,0x75, /*  server to execu */ \
	0x74,0x65,0x20,0x61,0x20,0x63,0x61,0x6c,0x6c,0x62,0x61,0x63,0x6b,0x20,0x66,0x75, /* te a callback fu */ \
	0x6e,0x63,0x74,0x69,0x6f,0x6e,0x20,0x61,0x74,0x20,0x74,0x68,0x61,0x74,0x20,0x70  /* nction at that p */
#define DATACHUNK000005 \
	0x6f,0x69,0x6e,0x74,0x2e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x3c,0x70,0x3e,0x54,0x6f, /* oint.</p>..<p>To */ \
	0x20,0x69,0x6e,0x73,0x65,0x72,0x74,0x20,0x61,0x20,0x64,0x79,0x6e,0x61,0x6d,0x69, /*  insert a dynami */ \
	0x63,0x20,0x76,0x61,0x72,0x69,0x61,0x62,0x6c,0x65,0x2c,0x20,0x70,0x6c,0x61,0x63, /* c variable, plac */ \
	0x65,0x20,0x74,0x68,0x65,0x20,0x6e,0x61,0x6d,0x65,0x20,0x6f,0x66,0x20,0x74,0x68, /* e the name of th */ \
	0x65,0x20,0x76,0x61,0x72,0x69,0x61,0x62,0x6c,0x65,0x20,0x69,0x6e,0x73,0x69,0x64, /* e variable insid */ \
	0x65,0x20,0x6f,0x66,0x20,0x74,0x68,0x65,0x20,0x74,0x69,0x6c,0x64,0x65,0x0d,0x0a, /* e of the tilde.. */ \
	0x28,0x3c,0x63,0x6f,0x64,0x65,0x3e,0x7e,0x7e,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e, /* (<code>~~</code> */ \
	0x29,0x20,0x63,0x68,0x61,0x72,0x61,0x63,0x74,0x65,0x72,0x2c,0x20,0x6c,0x69,0x6b, /* ) character, lik */ \
	0x65,0x20,0x74,0x68,0x69,0x73,0x3a,0x20,0x3c,0x63,0x6f,0x64,0x65,0x3e,0x7e,0x7e, /* e this: <code>~~ */ \
	0x6d,0x79,0x56,0x61,0x72,0x69,0x61,0x62,0x6c,0x65,0x7e,0x7e,0x3c,0x2f,0x63,0x6f, /* myVariable~~</co */ \
	0x64,0x65,0x3e,0x2e,0x20,0x20,0x57,0x68,0x65,0x6e,0x20,0x74,0x68,0x61,0x74,0x20, /* de>.  When that  */ \
	0x0d,0x0a,0x73,0x65,0x71,0x75,0x65,0x6e,0x63,0x65,0x20,0x69,0x73,0x20,0x66,0x6f, /* ..sequence is fo */ \
	0x75,0x6e,0x64,0x2c,0x20,0x74,0x68,0x65,0x20,0x73,0x65,0x72,0x76,0x65,0x72,0x20, /* und, the server  */ \
	0x77,0x69,0x6c,0x6c,0x20,0x63,0x61,0x6c,0x6c,0x20,0x74,0x68,0x65,0x20,0x66,0x75, /* will call the fu */ \
	0x6e,0x63,0x74,0x69,0x6f,0x6e,0x20,0x3c,0x63,0x6f,0x64,0x65,0x3e,0x48,0x54,0x54, /* nction <code>HTT */ \
	0x50,0x50,0x72,0x69,0x6e,0x74,0x5f,0x6d,0x79,0x56,0x61,0x72,0x69,0x61,0x62,0x6c, /* PPrint_myVariabl */ \
	0x65,0x28,0x29,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x2e,0x3c,0x2f,0x70,0x3e,0x0d, /* e()</code>.</p>. */ \
	0x0a,0x0d,0x0a,0x3c,0x70,0x3e,0x46,0x6f,0x72,0x20,0x65,0x78,0x61,0x6d,0x70,0x6c, /* ...<p>For exampl */ \
	0x65,0x2c,0x20,0x68,0x65,0x72,0x65,0x27,0x73,0x20,0x74,0x68,0x65,0x20,0x62,0x75, /* e, here's the bu */ \
	0x69,0x6c,0x64,0x20,0x64,0x61,0x74,0x65,0x20,0x6f,0x66,0x20,0x74,0x68,0x65,0x20, /* ild date of the  */ \
	0x48,0x45,0x58,0x20,0x66,0x69,0x6c,0x65,0x20,0x70,0x72,0x6f,0x67,0x72,0x61,0x6d, /* HEX file program */ \
	0x6d,0x65,0x64,0x20,0x69,0x6e,0x20,0x79,0x6f,0x75,0x72,0x20,0x70,0x61,0x72,0x74, /* med in your part */ \
	0x3a,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x63,0x6c, /* :</p>....<div cl */ \
	0x61,0x73,0x73,0x3d,0x22,0x65,0x78,0x61,0x6d,0x70,0x6c,0x65,0x62,0x6f,0x78,0x20, /* ass="examplebox  */ \
	0x63,0x6f,0x64,0x65,0x22,0x3e,0x7e,0x62,0x75,0x69,0x6c,0x64,0x64,0x61,0x74,0x65, /* code">~builddate */ \
	0x7e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x3e,0x59,0x6f, /* ~</div>....<p>Yo */ \
	0x75,0x20,0x63,0x61,0x6e,0x20,0x61,0x6c,0x73,0x6f,0x20,0x70,0x61,0x73,0x73,0x20, /* u can also pass  */ \
	0x70,0x61,0x72,0x61,0x6d,0x65,0x74,0x65,0x72,0x73,0x20,0x74,0x6f,0x20,0x64,0x79, /* parameters to dy */ \
	0x6e,0x61,0x6d,0x69,0x63,0x20,0x76,0x61,0x72,0x69,0x61,0x62,0x6c,0x65,0x73,0x20, /* namic variables  */ \
	0x62,0x79,0x20,0x70,0x6c,0x61,0x63,0x69,0x6e,0x67,0x20,0x6e,0x75,0x6d,0x65,0x72, /* by placing numer */ \
	0x69,0x63,0x20,0x76,0x61,0x6c,0x75,0x65,0x73,0x20,0x69,0x6e,0x73,0x69,0x64,0x65, /* ic values inside */ \
	0x20,0x0d,0x0a,0x6f,0x66,0x20,0x70,0x61,0x72,0x65,0x6e,0x74,0x68,0x65,0x73,0x69, /*  ..of parenthesi */ \
	0x73,0x20,0x61,0x66,0x74,0x65,0x72,0x20,0x74,0x68,0x65,0x20,0x76,0x61,0x72,0x69, /* s after the vari */ \
	0x61,0x62,0x6c,0x65,0x20,0x6e,0x61,0x6d,0x65,0x2e,0x20,0x20,0x3c,0x63,0x6f,0x64, /* able name.  <cod */ \
	0x65,0x3e,0x7e,0x7e,0x6c,0x65,0x64,0x28,0x32,0x29,0x7e,0x7e,0x3c,0x2f,0x63,0x6f, /* e>~~led(2)~~</co */ \
	0x64,0x65,0x3e,0x20,0x77,0x69,0x6c,0x6c,0x20,0x70,0x72,0x69,0x6e,0x74,0x20,0x74, /* de> will print t */ \
	0x68,0x65,0x20,0x76,0x61,0x6c,0x75,0x65,0x0d,0x0a,0x6f,0x66,0x20,0x74,0x68,0x65, /* he value..of the */ \
	0x20,0x73,0x65,0x63,0x6f,0x6e,0x64,0x20,0x4c,0x45,0x44,0x2e,0x20,0x20,0x54,0x68, /*  second LED.  Th */ \
	0x65,0x20,0x6e,0x75,0x6d,0x65,0x72,0x69,0x63,0x20,0x76,0x61,0x6c,0x75,0x65,0x73, /* e numeric values */ \
	0x20,0x61,0x72,0x65,0x20,0x70,0x61,0x73,0x73,0x65,0x64,0x20,0x61,0x73,0x20,0x57, /*  are passed as W */ \
	0x4f,0x52,0x44,0x20,0x76,0x61,0x6c,0x75,0x65,0x73,0x20,0x74,0x6f,0x20,0x79,0x6f, /* ORD values to yo */ \
	0x75,0x72,0x20,0x63,0x61,0x6c,0x6c,0x62,0x61,0x63,0x6b,0x20,0x66,0x75,0x6e,0x63, /* ur callback func */ \
	0x74,0x69,0x6f,0x6e,0x2e,0x0d,0x0a,0x59,0x6f,0x75,0x20,0x63,0x61,0x6e,0x20,0x70, /* tion...You can p */ \
	0x61,0x73,0x73,0x20,0x61,0x73,0x20,0x6d,0x61,0x6e,0x79,0x20,0x70,0x61,0x72,0x61, /* ass as many para */ \
	0x6d,0x65,0x74,0x65,0x72,0x73,0x20,0x61,0x73,0x20,0x79,0x6f,0x75,0x20,0x77,0x69, /* meters as you wi */ \
	0x73,0x68,0x20,0x74,0x6f,0x20,0x74,0x68,0x65,0x73,0x65,0x20,0x66,0x75,0x6e,0x63, /* sh to these func */ \
	0x74,0x69,0x6f,0x6e,0x73,0x2c,0x20,0x61,0x6e,0x64,0x20,0x69,0x66,0x20,0x79,0x6f, /* tions, and if yo */ \
	0x75,0x72,0x20,0x43,0x20,0x63,0x6f,0x64,0x65,0x20,0x68,0x61,0x73,0x20,0x0d,0x0a, /* ur C code has .. */ \
	0x63,0x6f,0x6e,0x73,0x74,0x61,0x6e,0x74,0x73,0x20,0x64,0x65,0x66,0x69,0x6e,0x65, /* constants define */ \
	0x64,0x2c,0x20,0x74,0x68,0x6f,0x73,0x65,0x20,0x77,0x69,0x6c,0x6c,0x20,0x62,0x65, /* d, those will be */ \
	0x20,0x70,0x61,0x72,0x73,0x65,0x64,0x20,0x61,0x73,0x20,0x77,0x65,0x6c,0x6c,0x2e, /*  parsed as well. */ \
	0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x3e,0x41,0x73,0x20,0x61,0x6e, /* </p>....<p>As an */ \
	0x20,0x65,0x78,0x61,0x6d,0x70,0x6c,0x65,0x2c,0x20,0x68,0x65,0x72,0x65,0x20,0x69, /*  example, here i */ \
	0x73,0x20,0x61,0x20,0x62,0x69,0x6e,0x61,0x72,0x79,0x20,0x72,0x65,0x70,0x72,0x65, /* s a binary repre */ \
	0x73,0x65,0x6e,0x74,0x61,0x74,0x69,0x6f,0x6e,0x20,0x77,0x68,0x69,0x63,0x68,0x20, /* sentation which  */ \
	0x4c,0x45,0x44,0x73,0x20,0x61,0x72,0x65,0x20,0x6f,0x6e,0x20,0x61,0x6e,0x64,0x20, /* LEDs are on and  */ \
	0x6f,0x66,0x66,0x20,0x6f,0x6e,0x20,0x74,0x68,0x65,0x20,0x62,0x6f,0x61,0x72,0x64, /* off on the board */ \
	0x3a,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x63,0x6c, /* :</p>....<div cl */ \
	0x61,0x73,0x73,0x3d,0x22,0x65,0x78,0x61,0x6d,0x70,0x6c,0x65,0x62,0x6f,0x78,0x20, /* ass="examplebox  */ \
	0x63,0x6f,0x64,0x65,0x22,0x20,0x73,0x74,0x79,0x6c,0x65,0x3d,0x22,0x6c,0x65,0x74, /* code" style="let */ \
	0x74,0x65,0x72,0x2d,0x73,0x70,0x61,0x63,0x69,0x6e,0x67,0x3a,0x20,0x31,0x30,0x70, /* ter-spacing: 10p */ \
	0x78,0x22,0x3e,0x0d,0x0a,0x7e,0x6c,0x65,0x64,0x28,0x37,0x29,0x7e,0x20,0x7e,0x6c, /* x">..~led(7)~ ~l */ \
	0x65,0x64,0x28,0x36,0x29,0x7e,0x20,0x7e,0x6c,0x65,0x64,0x28,0x35,0x29,0x7e,0x20, /* ed(6)~ ~led(5)~  */ \
	0x7e,0x6c,0x65,0x64,0x28,0x34,0x29,0x7e,0x20,0x7e,0x6c,0x65,0x64,0x28,0x33,0x29  /* ~led(4)~ ~led(3) */
#define DATACHUNK000006 \
	0x7e,0x20,0x7e,0x6c,0x65,0x64,0x28,0x32,0x29,0x7e,0x20,0x7e,0x6c,0x65,0x64,0x28, /* ~ ~led(2)~ ~led( */ \
	0x31,0x29,0x7e,0x20,0x3f,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d, /* 1)~ ?..</div>... */ \
	0x0a,0x3c,0x70,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x65,0x78,0x65,0x72,0x63, /* .<p class="exerc */ \
	0x69,0x73,0x65,0x22,0x3e,0x3c,0x62,0x3e,0x45,0x78,0x65,0x72,0x63,0x69,0x73,0x65, /* ise"><b>Exercise */ \
	0x3a,0x3c,0x2f,0x62,0x3e,0x20,0x54,0x72,0x79,0x20,0x74,0x6f,0x20,0x61,0x64,0x64, /* :</b> Try to add */ \
	0x20,0x74,0x68,0x65,0x20,0x6c,0x61,0x73,0x74,0x20,0x28,0x4c,0x53,0x42,0x29,0x20, /*  the last (LSB)  */ \
	0x4c,0x45,0x44,0x20,0x74,0x6f,0x20,0x74,0x68,0x65,0x20,0x6f,0x75,0x74,0x70,0x75, /* LED to the outpu */ \
	0x74,0x20,0x61,0x62,0x6f,0x76,0x65,0x2e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a, /* t above.</p>.... */ \
	0x3c,0x70,0x3e,0x46,0x6f,0x72,0x20,0x73,0x68,0x6f,0x72,0x74,0x20,0x6f,0x75,0x74, /* <p>For short out */ \
	0x70,0x75,0x74,0x73,0x20,0x28,0x6c,0x65,0x73,0x73,0x20,0x74,0x68,0x61,0x6e,0x20, /* puts (less than  */ \
	0x31,0x36,0x20,0x62,0x79,0x74,0x65,0x73,0x29,0x20,0x79,0x6f,0x75,0x20,0x6e,0x65, /* 16 bytes) you ne */ \
	0x65,0x64,0x20,0x6f,0x6e,0x6c,0x79,0x20,0x74,0x6f,0x20,0x63,0x61,0x6c,0x6c,0x20, /* ed only to call  */ \
	0x74,0x68,0x65,0x20,0x61,0x70,0x70,0x72,0x6f,0x70,0x72,0x69,0x61,0x74,0x65,0x20, /* the appropriate  */ \
	0x0d,0x0a,0x3c,0x63,0x6f,0x64,0x65,0x3e,0x54,0x43,0x50,0x50,0x75,0x74,0x3c,0x2f, /* ..<code>TCPPut</ */ \
	0x63,0x6f,0x64,0x65,0x3e,0x20,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x20,0x61, /* code> function a */ \
	0x6e,0x64,0x20,0x72,0x65,0x74,0x75,0x72,0x6e,0x2e,0x20,0x20,0x46,0x6f,0x72,0x20, /* nd return.  For  */ \
	0x6c,0x6f,0x6e,0x67,0x65,0x72,0x20,0x6f,0x75,0x74,0x70,0x75,0x74,0x73,0x20,0x74, /* longer outputs t */ \
	0x68,0x65,0x20,0x6f,0x75,0x74,0x70,0x75,0x74,0x20,0x73,0x74,0x61,0x74,0x65,0x20, /* he output state  */ \
	0x6d,0x75,0x73,0x74,0x20,0x62,0x65,0x20,0x0d,0x0a,0x6d,0x61,0x6e,0x61,0x67,0x65, /* must be ..manage */ \
	0x64,0x20,0x74,0x68,0x72,0x6f,0x75,0x67,0x68,0x20,0x73,0x75,0x63,0x63,0x65,0x73, /* d through succes */ \
	0x73,0x69,0x76,0x65,0x20,0x63,0x61,0x6c,0x6c,0x73,0x2c,0x20,0x77,0x68,0x69,0x63, /* sive calls, whic */ \
	0x68,0x20,0x70,0x72,0x65,0x76,0x65,0x6e,0x74,0x73,0x20,0x74,0x68,0x65,0x20,0x6c, /* h prevents the l */ \
	0x69,0x6d,0x69,0x74,0x65,0x64,0x20,0x62,0x75,0x66,0x66,0x65,0x72,0x20,0x73,0x70, /* imited buffer sp */ \
	0x61,0x63,0x65,0x20,0x66,0x72,0x6f,0x6d,0x20,0x62,0x65,0x69,0x6e,0x67,0x20,0x0d, /* ace from being . */ \
	0x0a,0x6f,0x76,0x65,0x72,0x72,0x75,0x6e,0x2e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x3c, /* .overrun.</p>..< */ \
	0x70,0x3e,0x41,0x73,0x20,0x61,0x6e,0x20,0x65,0x78,0x61,0x6d,0x70,0x6c,0x65,0x2c, /* p>As an example, */ \
	0x20,0x68,0x65,0x72,0x65,0x20,0x69,0x73,0x20,0x74,0x68,0x65,0x20,0x63,0x75,0x72, /*  here is the cur */ \
	0x72,0x65,0x6e,0x74,0x20,0x4c,0x43,0x44,0x20,0x64,0x69,0x73,0x70,0x6c,0x61,0x79, /* rent LCD display */ \
	0x20,0x28,0x77,0x68,0x69,0x63,0x68,0x20,0x75,0x73,0x65,0x73,0x20,0x33,0x32,0x20, /*  (which uses 32  */ \
	0x62,0x79,0x74,0x65,0x73,0x29,0x3a,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c, /* bytes):</p>....< */ \
	0x64,0x69,0x76,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x65,0x78,0x61,0x6d,0x70, /* div class="examp */ \
	0x6c,0x65,0x62,0x6f,0x78,0x20,0x63,0x6f,0x64,0x65,0x22,0x3e,0x7e,0x6c,0x63,0x64, /* lebox code">~lcd */ \
	0x74,0x65,0x78,0x74,0x7e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c, /* text~</div>....< */ \
	0x70,0x3e,0x59,0x6f,0x75,0x20,0x63,0x61,0x6e,0x20,0x61,0x6c,0x73,0x6f,0x20,0x75, /* p>You can also u */ \
	0x73,0x65,0x20,0x64,0x79,0x6e,0x61,0x6d,0x69,0x63,0x20,0x76,0x61,0x72,0x69,0x61, /* se dynamic varia */ \
	0x62,0x6c,0x65,0x73,0x20,0x74,0x6f,0x20,0x69,0x6e,0x63,0x6c,0x75,0x64,0x65,0x20, /* bles to include  */ \
	0x66,0x69,0x6c,0x65,0x73,0x2e,0x20,0x20,0x54,0x68,0x69,0x73,0x20,0x69,0x73,0x20, /* files.  This is  */ \
	0x75,0x73,0x65,0x66,0x75,0x6c,0x20,0x74,0x6f,0x20,0x73,0x61,0x76,0x65,0x20,0x0d, /* useful to save . */ \
	0x0a,0x73,0x74,0x6f,0x72,0x61,0x67,0x65,0x20,0x73,0x70,0x61,0x63,0x65,0x20,0x66, /* .storage space f */ \
	0x6f,0x72,0x20,0x79,0x6f,0x75,0x72,0x20,0x70,0x61,0x67,0x65,0x73,0x2c,0x20,0x73, /* or your pages, s */ \
	0x69,0x6e,0x63,0x65,0x20,0x61,0x20,0x70,0x6f,0x72,0x74,0x69,0x6f,0x6e,0x20,0x6f, /* ince a portion o */ \
	0x66,0x20,0x6d,0x6f,0x73,0x74,0x20,0x70,0x61,0x67,0x65,0x73,0x20,0x28,0x68,0x65, /* f most pages (he */ \
	0x61,0x64,0x65,0x72,0x2c,0x20,0x6d,0x65,0x6e,0x75,0x2c,0x20,0x66,0x6f,0x6f,0x74, /* ader, menu, foot */ \
	0x65,0x72,0x29,0x20,0x0d,0x0a,0x64,0x6f,0x20,0x6e,0x6f,0x74,0x20,0x63,0x68,0x61, /* er) ..do not cha */ \
	0x6e,0x67,0x65,0x2e,0x20,0x20,0x42,0x79,0x20,0x70,0x6c,0x61,0x63,0x69,0x6e,0x67, /* nge.  By placing */ \
	0x20,0x3c,0x63,0x6f,0x64,0x65,0x3e,0x7e,0x7e,0x69,0x6e,0x63,0x26,0x23,0x30,0x35, /*  <code>~~inc&#05 */ \
	0x38,0x3b,0x66,0x69,0x6c,0x65,0x6e,0x61,0x6d,0x65,0x2e,0x69,0x6e,0x63,0x7e,0x7e, /* 8;filename.inc~~ */ \
	0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x20,0x69,0x6e,0x20,0x79,0x6f,0x75,0x72,0x20, /* </code> in your  */ \
	0x48,0x54,0x4d,0x4c,0x20,0x63,0x6f,0x64,0x65,0x2c,0x20,0x0d,0x0a,0x74,0x68,0x65, /* HTML code, ..the */ \
	0x20,0x66,0x69,0x6c,0x65,0x20,0x3c,0x63,0x6f,0x64,0x65,0x3e,0x66,0x69,0x6c,0x65, /*  file <code>file */ \
	0x6e,0x61,0x6d,0x65,0x2e,0x69,0x6e,0x63,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x20, /* name.inc</code>  */ \
	0x77,0x69,0x6c,0x6c,0x20,0x62,0x65,0x20,0x72,0x65,0x61,0x64,0x20,0x61,0x6e,0x64, /* will be read and */ \
	0x20,0x69,0x6e,0x73,0x65,0x72,0x74,0x65,0x64,0x20,0x61,0x74,0x20,0x74,0x68,0x69, /*  inserted at thi */ \
	0x73,0x20,0x6c,0x6f,0x63,0x61,0x74,0x69,0x6f,0x6e,0x2e,0x3c,0x2f,0x70,0x3e,0x0d, /* s location.</p>. */ \
	0x0a,0x3c,0x70,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x65,0x78,0x65,0x72,0x63, /* .<p class="exerc */ \
	0x69,0x73,0x65,0x22,0x3e,0x3c,0x62,0x3e,0x45,0x78,0x65,0x72,0x63,0x69,0x73,0x65, /* ise"><b>Exercise */ \
	0x3a,0x3c,0x2f,0x62,0x3e,0x20,0x4c,0x6f,0x6f,0x6b,0x20,0x61,0x74,0x20,0x63,0x6f, /* :</b> Look at co */ \
	0x64,0x65,0x20,0x66,0x6f,0x72,0x20,0x74,0x68,0x69,0x73,0x20,0x70,0x61,0x67,0x65, /* de for this page */ \
	0x20,0x61,0x6e,0x64,0x20,0x66,0x69,0x6e,0x64,0x20,0x68,0x6f,0x77,0x20,0x0d,0x0a, /*  and find how .. */ \
	0x3c,0x63,0x6f,0x64,0x65,0x3e,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63, /* <code>header.inc */ \
	0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x20,0x61,0x6e,0x64,0x20,0x3c,0x63,0x6f,0x64, /* </code> and <cod */ \
	0x65,0x3e,0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e,0x63,0x3c,0x2f,0x63,0x6f, /* e>footer.inc</co */ \
	0x64,0x65,0x3e,0x20,0x61,0x72,0x65,0x20,0x75,0x73,0x65,0x64,0x2e,0x20,0x20,0x54, /* de> are used.  T */ \
	0x68,0x65,0x73,0x65,0x20,0x66,0x69,0x6c,0x65,0x73,0x20,0x70,0x72,0x6f,0x76,0x69  /* hese files provi */
#define DATACHUNK000007 \
	0x64,0x65,0x20,0x0d,0x0a,0x61,0x20,0x74,0x65,0x6d,0x70,0x6c,0x61,0x74,0x65,0x20, /* de ..a template  */ \
	0x66,0x6f,0x72,0x20,0x74,0x68,0x65,0x20,0x70,0x61,0x67,0x65,0x73,0x20,0x74,0x6f, /* for the pages to */ \
	0x20,0x69,0x6e,0x63,0x6c,0x75,0x64,0x65,0x20,0x74,0x68,0x65,0x20,0x73,0x61,0x6d, /*  include the sam */ \
	0x65,0x20,0x6d,0x65,0x6e,0x75,0x2c,0x20,0x6c,0x61,0x79,0x6f,0x75,0x74,0x2c,0x20, /* e menu, layout,  */ \
	0x61,0x6e,0x64,0x20,0x64,0x65,0x73,0x69,0x67,0x6e,0x20,0x65,0x6c,0x65,0x6d,0x65, /* and design eleme */ \
	0x6e,0x74,0x73,0x2e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x3c,0x70,0x3e,0x3c,0x73,0x6d, /* nts.</p>..<p><sm */ \
	0x61,0x6c,0x6c,0x3e,0x28,0x41,0x74,0x20,0x74,0x68,0x69,0x73,0x20,0x74,0x69,0x6d, /* all>(At this tim */ \
	0x65,0x2c,0x20,0x64,0x79,0x6e,0x61,0x6d,0x69,0x63,0x20,0x76,0x61,0x72,0x69,0x61, /* e, dynamic varia */ \
	0x62,0x6c,0x65,0x73,0x20,0x61,0x72,0x65,0x20,0x6e,0x6f,0x6e,0x2d,0x72,0x65,0x63, /* bles are non-rec */ \
	0x75,0x72,0x73,0x69,0x76,0x65,0x2c,0x20,0x73,0x6f,0x20,0x76,0x61,0x72,0x69,0x61, /* ursive, so varia */ \
	0x62,0x6c,0x65,0x73,0x20,0x6c,0x6f,0x63,0x61,0x74,0x65,0x64,0x20,0x69,0x6e,0x73, /* bles located ins */ \
	0x69,0x64,0x65,0x0d,0x0a,0x66,0x69,0x6c,0x65,0x73,0x3c,0x62,0x72,0x20,0x2f,0x3e, /* ide..files<br /> */ \
	0x20,0x69,0x6e,0x63,0x6c,0x75,0x64,0x65,0x64,0x20,0x69,0x6e,0x20,0x74,0x68,0x69, /*  included in thi */ \
	0x73,0x20,0x6d,0x61,0x6e,0x6e,0x65,0x72,0x20,0x61,0x72,0x65,0x20,0x6e,0x6f,0x74, /* s manner are not */ \
	0x20,0x70,0x61,0x72,0x73,0x65,0x64,0x2e,0x29,0x3c,0x2f,0x73,0x6d,0x61,0x6c,0x6c, /*  parsed.)</small */ \
	0x3e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d, /* ></p>..</div>... */ \
	0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74, /* .<script type="t */ \
	0x65,0x78,0x74,0x2f,0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x3e, /* ext/javascript"> */ \
	0x0d,0x0a,0x3c,0x21,0x2d,0x2d,0x0d,0x0a,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74, /* ..<!--..document */ \
	0x2e,0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28, /* .getElementById( */ \
	0x27,0x68,0x65,0x6c,0x6c,0x6f,0x27,0x29,0x2e,0x69,0x6e,0x6e,0x65,0x72,0x48,0x54, /* 'hello').innerHT */ \
	0x4d,0x4c,0x20,0x3d,0x20,0x22,0x7e,0x68,0x65,0x6c,0x6c,0x6f,0x6d,0x73,0x67,0x7e, /* ML = "~hellomsg~ */ \
	0x22,0x3b,0x0d,0x0a,0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70, /* ";..-->..</scrip */ \
	0x74,0x3e,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e, /* t>..~inc:footer. */ \
	0x69,0x6e,0x63,0x7e,0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0xd3,0x01,0x00,0x00, /* inc~....3....... */ \
	0x04,0x00,0x00,0x00,0xfa,0x01,0x00,0x00,0x04,0x00,0x00,0x00,0x06,0x02,0x00,0x00, /* ................ */ \
	0x04,0x00,0x00,0x00,0xf2,0x02,0x00,0x00,0x05,0x00,0x00,0x00,0x8e,0x03,0x00,0x00, /* ................ */ \
	0x04,0x00,0x00,0x00,0x96,0x03,0x00,0x00,0x04,0x00,0x00,0x00,0x41,0x05,0x00,0x00, /* ............A... */ \
	0x06,0x00,0x00,0x00,0x4a,0x05,0x00,0x00,0x07,0x00,0x00,0x00,0x53,0x05,0x00,0x00, /* ....J.......S... */ \
	0x08,0x00,0x00,0x00,0x5c,0x05,0x00,0x00,0x09,0x00,0x00,0x00,0x65,0x05,0x00,0x00, /* ....\.......e... */ \
	0x0a,0x00,0x00,0x00,0x6e,0x05,0x00,0x00,0x0b,0x00,0x00,0x00,0x77,0x05,0x00,0x00, /* ....n.......w... */ \
	0x0c,0x00,0x00,0x00,0x68,0x07,0x00,0x00,0x0d,0x00,0x00,0x00,0x43,0x08,0x00,0x00, /* ....h.......C... */ \
	0x04,0x00,0x00,0x00,0x5a,0x08,0x00,0x00,0x04,0x00,0x00,0x00,0xc2,0x0a,0x00,0x00, /* ....Z........... */ \
	0x01,0x00,0x00,0x00,0xe0,0x0a,0x00,0x00,0x02,0x00,0x00,0x00,0x3c,0x64,0x69,0x76, /* ............<div */ \
	0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x73,0x70,0x61,0x63,0x65,0x72,0x22,0x3e, /*  class="spacer"> */ \
	0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64, /* &nbsp;</div>..<d */ \
	0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x66,0x6f,0x6f,0x74,0x65,0x72,0x22,0x3e,0x43, /* iv id="footer">C */ \
	0x6f,0x70,0x79,0x72,0x69,0x67,0x68,0x74,0x20,0x26,0x63,0x6f,0x70,0x79,0x3b,0x20, /* opyright &copy;  */ \
	0x32,0x30,0x31,0x30,0x20,0x4d,0x69,0x63,0x72,0x6f,0x63,0x68,0x69,0x70,0x20,0x54, /* 2010 Microchip T */ \
	0x65,0x63,0x68,0x6e,0x6f,0x6c,0x6f,0x67,0x79,0x2c,0x20,0x49,0x6e,0x63,0x2e,0x3c, /* echnology, Inc.< */ \
	0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x3c, /* /div>....</div>< */ \
	0x2f,0x64,0x69,0x76,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x3c,0x2f,0x64,0x69,0x76, /* /div></div></div */ \
	0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x2f,0x62,0x6f,0x64, /* ></div>....</bod */ \
	0x79,0x3e,0x0d,0x0a,0x3c,0x2f,0x68,0x74,0x6d,0x6c,0x3e,0x7e,0x69,0x6e,0x63,0x3a, /* y>..</html>~inc: */ \
	0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69, /* header.inc~..<di */ \
	0x76,0x20,0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d, /* v id="content">. */ \
	0x0a,0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x46,0x6f,0x72,0x6d,0x20,0x50,0x72,0x6f,0x63, /* ...<h1>Form Proc */ \
	0x65,0x73,0x73,0x69,0x6e,0x67,0x3c,0x2f,0x68,0x31,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c, /* essing</h1>....< */ \
	0x70,0x3e,0x59,0x6f,0x75,0x72,0x20,0x61,0x70,0x70,0x6c,0x69,0x63,0x61,0x74,0x69, /* p>Your applicati */ \
	0x6f,0x6e,0x20,0x77,0x69,0x6c,0x6c,0x20,0x6c,0x69,0x6b,0x65,0x6c,0x79,0x20,0x6e, /* on will likely n */ \
	0x65,0x65,0x64,0x20,0x74,0x6f,0x20,0x61,0x63,0x63,0x65,0x70,0x74,0x20,0x64,0x61, /* eed to accept da */ \
	0x74,0x61,0x20,0x66,0x72,0x6f,0x6d,0x20,0x74,0x68,0x65,0x20,0x75,0x73,0x65,0x72, /* ta from the user */ \
	0x2e,0x20,0x20,0x46,0x6f,0x72,0x6d,0x73,0x20,0x61,0x6c,0x6c,0x6f,0x77,0x0d,0x0a, /* .  Forms allow.. */ \
	0x79,0x6f,0x75,0x20,0x74,0x6f,0x20,0x64,0x6f,0x20,0x6a,0x75,0x73,0x74,0x20,0x74, /* you to do just t */ \
	0x68,0x61,0x74,0x2e,0x20,0x20,0x46,0x6f,0x72,0x6d,0x73,0x20,0x63,0x61,0x6e,0x20, /* hat.  Forms can  */ \
	0x62,0x65,0x20,0x73,0x75,0x62,0x6d,0x69,0x74,0x74,0x65,0x64,0x20,0x69,0x6e,0x20, /* be submitted in  */ \
	0x6f,0x6e,0x65,0x20,0x6f,0x66,0x20,0x74,0x77,0x6f,0x20,0x6d,0x65,0x74,0x68,0x6f, /* one of two metho */ \
	0x64,0x73,0x20,0x28,0x3c,0x69,0x3e,0x47,0x45,0x54,0x3c,0x2f,0x69,0x3e,0x20,0x61, /* ds (<i>GET</i> a */ \
	0x6e,0x64,0x20,0x0d,0x0a,0x3c,0x69,0x3e,0x50,0x4f,0x53,0x54,0x3c,0x2f,0x69,0x3e, /* nd ..<i>POST</i> */ \
	0x29,0x2c,0x20,0x61,0x6e,0x64,0x20,0x74,0x68,0x69,0x73,0x20,0x73,0x65,0x72,0x76, /* ), and this serv */ \
	0x65,0x72,0x20,0x73,0x75,0x70,0x70,0x6f,0x72,0x74,0x73,0x20,0x62,0x6f,0x74,0x68, /* er supports both */ \
	0x2e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x36,0x3e,0x3c,0x2f,0x68, /* .</p>....<h6></h */ \
	0x36,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x3e,0x54,0x68,0x65,0x20,0x3c,0x62,0x3e, /* 6>....<p>The <b> */ \
	0x47,0x45,0x54,0x3c,0x2f,0x62,0x3e,0x20,0x6d,0x65,0x74,0x68,0x6f,0x64,0x20,0x61  /* GET</b> method a */
#define DATACHUNK000008 \
	0x70,0x70,0x65,0x6e,0x64,0x73,0x20,0x74,0x68,0x65,0x20,0x64,0x61,0x74,0x61,0x20, /* ppends the data  */ \
	0x74,0x6f,0x20,0x74,0x68,0x65,0x20,0x65,0x6e,0x64,0x20,0x6f,0x66,0x20,0x74,0x68, /* to the end of th */ \
	0x65,0x20,0x55,0x52,0x49,0x2e,0x20,0x20,0x59,0x6f,0x75,0x27,0x6c,0x6c,0x20,0x73, /* e URI.  You'll s */ \
	0x65,0x65,0x20,0x74,0x68,0x69,0x73,0x20,0x0d,0x0a,0x64,0x61,0x74,0x61,0x20,0x66, /* ee this ..data f */ \
	0x6f,0x6c,0x6c,0x6f,0x77,0x69,0x6e,0x67,0x20,0x74,0x68,0x65,0x20,0x71,0x75,0x65, /* ollowing the que */ \
	0x73,0x74,0x69,0x6f,0x6e,0x20,0x6d,0x61,0x72,0x6b,0x20,0x28,0x3f,0x29,0x20,0x69, /* stion mark (?) i */ \
	0x6e,0x20,0x79,0x6f,0x75,0x72,0x20,0x62,0x72,0x6f,0x77,0x73,0x65,0x72,0x27,0x73, /* n your browser's */ \
	0x20,0x61,0x64,0x64,0x72,0x65,0x73,0x73,0x20,0x62,0x61,0x72,0x2e,0x20,0x20,0x46, /*  address bar.  F */ \
	0x6f,0x72,0x20,0x4d,0x69,0x63,0x72,0x6f,0x63,0x68,0x69,0x70,0x27,0x73,0x20,0x0d, /* or Microchip's . */ \
	0x0a,0x65,0x6d,0x62,0x65,0x64,0x64,0x65,0x64,0x20,0x73,0x65,0x72,0x76,0x65,0x72, /* .embedded server */ \
	0x2c,0x20,0x74,0x68,0x69,0x73,0x20,0x64,0x61,0x74,0x61,0x20,0x69,0x73,0x20,0x6c, /* , this data is l */ \
	0x69,0x6d,0x69,0x74,0x65,0x64,0x20,0x74,0x6f,0x20,0x61,0x72,0x6f,0x75,0x6e,0x64, /* imited to around */ \
	0x20,0x38,0x30,0x20,0x62,0x79,0x74,0x65,0x73,0x2e,0x20,0x20,0x48,0x6f,0x77,0x65, /*  80 bytes.  Howe */ \
	0x76,0x65,0x72,0x2c,0x20,0x74,0x68,0x69,0x73,0x20,0x73,0x6f,0x72,0x74,0x20,0x6f, /* ver, this sort o */ \
	0x66,0x20,0x0d,0x0a,0x73,0x75,0x62,0x6d,0x69,0x73,0x73,0x69,0x6f,0x6e,0x20,0x69, /* f ..submission i */ \
	0x73,0x20,0x67,0x65,0x6e,0x65,0x72,0x61,0x6c,0x6c,0x79,0x20,0x65,0x61,0x73,0x69, /* s generally easi */ \
	0x65,0x72,0x20,0x74,0x6f,0x20,0x70,0x72,0x6f,0x63,0x65,0x73,0x73,0x2e,0x20,0x44, /* er to process. D */ \
	0x61,0x74,0x61,0x20,0x73,0x65,0x6e,0x74,0x20,0x76,0x69,0x61,0x20,0x47,0x45,0x54, /* ata sent via GET */ \
	0x20,0x69,0x73,0x20,0x61,0x75,0x74,0x6f,0x6d,0x61,0x74,0x69,0x63,0x61,0x6c,0x6c, /*  is automaticall */ \
	0x79,0x20,0x0d,0x0a,0x64,0x65,0x63,0x6f,0x64,0x65,0x64,0x2c,0x20,0x61,0x6e,0x64, /* y ..decoded, and */ \
	0x20,0x73,0x74,0x6f,0x72,0x65,0x64,0x20,0x69,0x6e,0x20,0x74,0x68,0x65,0x20,0x61, /*  stored in the a */ \
	0x72,0x72,0x61,0x79,0x20,0x3c,0x63,0x6f,0x64,0x65,0x3e,0x63,0x75,0x72,0x48,0x54, /* rray <code>curHT */ \
	0x54,0x50,0x2e,0x64,0x61,0x74,0x61,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x2e,0x20, /* TP.data</code>.  */ \
	0x20,0x59,0x6f,0x75,0x72,0x20,0x61,0x70,0x70,0x6c,0x69,0x63,0x61,0x74,0x69,0x6f, /*  Your applicatio */ \
	0x6e,0x20,0x77,0x69,0x6c,0x6c,0x0d,0x0a,0x68,0x61,0x6e,0x64,0x6c,0x65,0x20,0x74, /* n will..handle t */ \
	0x68,0x65,0x20,0x64,0x61,0x74,0x61,0x20,0x69,0x6e,0x20,0x74,0x68,0x65,0x20,0x3c, /* he data in the < */ \
	0x63,0x6f,0x64,0x65,0x3e,0x48,0x54,0x54,0x50,0x45,0x78,0x65,0x63,0x75,0x74,0x65, /* code>HTTPExecute */ \
	0x47,0x65,0x74,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x20,0x63,0x61,0x6c,0x6c,0x62, /* Get</code> callb */ \
	0x61,0x63,0x6b,0x2e,0x20,0x20,0x54,0x68,0x65,0x20,0x66,0x75,0x6e,0x63,0x74,0x69, /* ack.  The functi */ \
	0x6f,0x6e,0x73,0x20,0x0d,0x0a,0x3c,0x63,0x6f,0x64,0x65,0x3e,0x48,0x54,0x54,0x50, /* ons ..<code>HTTP */ \
	0x47,0x65,0x74,0x41,0x72,0x67,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x20,0x61,0x6e, /* GetArg</code> an */ \
	0x64,0x20,0x3c,0x63,0x6f,0x64,0x65,0x3e,0x48,0x54,0x54,0x50,0x47,0x65,0x74,0x52, /* d <code>HTTPGetR */ \
	0x4f,0x4d,0x41,0x72,0x67,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x20,0x70,0x72,0x6f, /* OMArg</code> pro */ \
	0x76,0x69,0x64,0x65,0x20,0x61,0x6e,0x20,0x65,0x61,0x73,0x79,0x20,0x0d,0x0a,0x6d, /* vide an easy ..m */ \
	0x65,0x74,0x68,0x6f,0x64,0x20,0x74,0x6f,0x20,0x72,0x65,0x74,0x72,0x69,0x65,0x76, /* ethod to retriev */ \
	0x65,0x20,0x73,0x75,0x62,0x6d,0x69,0x74,0x74,0x65,0x64,0x20,0x76,0x61,0x6c,0x75, /* e submitted valu */ \
	0x65,0x73,0x20,0x66,0x6f,0x72,0x20,0x70,0x72,0x6f,0x63,0x65,0x73,0x73,0x69,0x6e, /* es for processin */ \
	0x67,0x2e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x3e,0x41,0x73,0x20, /* g.</p>....<p>As  */ \
	0x61,0x6e,0x20,0x65,0x78,0x61,0x6d,0x70,0x6c,0x65,0x2c,0x20,0x74,0x68,0x69,0x73, /* an example, this */ \
	0x20,0x47,0x45,0x54,0x20,0x66,0x6f,0x72,0x6d,0x20,0x63,0x6f,0x6e,0x74,0x72,0x6f, /*  GET form contro */ \
	0x6c,0x73,0x20,0x73,0x65,0x76,0x65,0x72,0x61,0x6c,0x20,0x4c,0x45,0x44,0x73,0x20, /* ls several LEDs  */ \
	0x6f,0x6e,0x20,0x74,0x68,0x65,0x20,0x64,0x65,0x6d,0x6f,0x20,0x62,0x6f,0x61,0x72, /* on the demo boar */ \
	0x64,0x3a,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x66,0x6f,0x72,0x6d,0x20, /* d:</p>....<form  */ \
	0x6d,0x65,0x74,0x68,0x6f,0x64,0x3d,0x22,0x67,0x65,0x74,0x22,0x20,0x61,0x63,0x74, /* method="get" act */ \
	0x69,0x6f,0x6e,0x3d,0x22,0x66,0x6f,0x72,0x6d,0x73,0x2e,0x68,0x74,0x6d,0x22,0x3e, /* ion="forms.htm"> */ \
	0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x65,0x78, /* ..<div class="ex */ \
	0x61,0x6d,0x70,0x6c,0x65,0x62,0x6f,0x78,0x22,0x3e,0x0d,0x0a,0x3c,0x62,0x3e,0x34, /* amplebox">..<b>4 */ \
	0x3a,0x3c,0x2f,0x62,0x3e,0x20,0x3c,0x73,0x65,0x6c,0x65,0x63,0x74,0x20,0x6e,0x61, /* :</b> <select na */ \
	0x6d,0x65,0x3d,0x22,0x6c,0x65,0x64,0x34,0x22,0x3e,0x3c,0x6f,0x70,0x74,0x69,0x6f, /* me="led4"><optio */ \
	0x6e,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x31,0x22,0x20,0x7e,0x6c,0x65,0x64, /* n value="1" ~led */ \
	0x53,0x65,0x6c,0x65,0x63,0x74,0x65,0x64,0x28,0x34,0x2c,0x54,0x52,0x55,0x45,0x29, /* Selected(4,TRUE) */ \
	0x7e,0x3e,0x4f,0x6e,0x3c,0x2f,0x6f,0x70,0x74,0x69,0x6f,0x6e,0x3e,0x3c,0x6f,0x70, /* ~>On</option><op */ \
	0x74,0x69,0x6f,0x6e,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x30,0x22,0x20,0x7e, /* tion value="0" ~ */ \
	0x6c,0x65,0x64,0x53,0x65,0x6c,0x65,0x63,0x74,0x65,0x64,0x28,0x34,0x2c,0x46,0x41, /* ledSelected(4,FA */ \
	0x4c,0x53,0x45,0x29,0x7e,0x3e,0x4f,0x66,0x66,0x3c,0x2f,0x6f,0x70,0x74,0x69,0x6f, /* LSE)~>Off</optio */ \
	0x6e,0x3e,0x3c,0x2f,0x73,0x65,0x6c,0x65,0x63,0x74,0x3e,0x26,0x6e,0x62,0x73,0x70, /* n></select>&nbsp */ \
	0x3b,0x20,0x0d,0x0a,0x3c,0x62,0x3e,0x33,0x3a,0x3c,0x2f,0x62,0x3e,0x20,0x3c,0x73, /* ; ..<b>3:</b> <s */ \
	0x65,0x6c,0x65,0x63,0x74,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x6c,0x65,0x64,0x33, /* elect name="led3 */ \
	0x22,0x3e,0x3c,0x6f,0x70,0x74,0x69,0x6f,0x6e,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d, /* "><option value= */ \
	0x22,0x31,0x22,0x20,0x7e,0x6c,0x65,0x64,0x53,0x65,0x6c,0x65,0x63,0x74,0x65,0x64, /* "1" ~ledSelected */ \
	0x28,0x33,0x2c,0x54,0x52,0x55,0x45,0x29,0x7e,0x3e,0x4f,0x6e,0x3c,0x2f,0x6f,0x70, /* (3,TRUE)~>On</op */ \
	0x74,0x69,0x6f,0x6e,0x3e,0x3c,0x6f,0x70,0x74,0x69,0x6f,0x6e,0x20,0x76,0x61,0x6c, /* tion><option val */ \
	0x75,0x65,0x3d,0x22,0x30,0x22,0x20,0x7e,0x6c,0x65,0x64,0x53,0x65,0x6c,0x65,0x63, /* ue="0" ~ledSelec */ \
	0x74,0x65,0x64,0x28,0x33,0x2c,0x46,0x41,0x4c,0x53,0x45,0x29,0x7e,0x3e,0x4f,0x66  /* ted(3,FALSE)~>Of */
#define DATACHUNK000009 \
	0x66,0x3c,0x2f,0x6f,0x70,0x74,0x69,0x6f,0x6e,0x3e,0x3c,0x2f,0x73,0x65,0x6c,0x65, /* f</option></sele */ \
	0x63,0x74,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x20,0x0d,0x0a,0x3c,0x62,0x3e,0x32, /* ct>&nbsp; ..<b>2 */ \
	0x3a,0x3c,0x2f,0x62,0x3e,0x20,0x3c,0x73,0x65,0x6c,0x65,0x63,0x74,0x20,0x6e,0x61, /* :</b> <select na */ \
	0x6d,0x65,0x3d,0x22,0x6c,0x65,0x64,0x32,0x22,0x3e,0x3c,0x6f,0x70,0x74,0x69,0x6f, /* me="led2"><optio */ \
	0x6e,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x31,0x22,0x20,0x7e,0x6c,0x65,0x64, /* n value="1" ~led */ \
	0x53,0x65,0x6c,0x65,0x63,0x74,0x65,0x64,0x28,0x32,0x2c,0x54,0x52,0x55,0x45,0x29, /* Selected(2,TRUE) */ \
	0x7e,0x3e,0x4f,0x6e,0x3c,0x2f,0x6f,0x70,0x74,0x69,0x6f,0x6e,0x3e,0x3c,0x6f,0x70, /* ~>On</option><op */ \
	0x74,0x69,0x6f,0x6e,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x30,0x22,0x20,0x7e, /* tion value="0" ~ */ \
	0x6c,0x65,0x64,0x53,0x65,0x6c,0x65,0x63,0x74,0x65,0x64,0x28,0x32,0x2c,0x46,0x41, /* ledSelected(2,FA */ \
	0x4c,0x53,0x45,0x29,0x7e,0x3e,0x4f,0x66,0x66,0x3c,0x2f,0x6f,0x70,0x74,0x69,0x6f, /* LSE)~>Off</optio */ \
	0x6e,0x3e,0x3c,0x2f,0x73,0x65,0x6c,0x65,0x63,0x74,0x3e,0x26,0x6e,0x62,0x73,0x70, /* n></select>&nbsp */ \
	0x3b,0x20,0x0d,0x0a,0x3c,0x62,0x3e,0x31,0x3a,0x3c,0x2f,0x62,0x3e,0x20,0x3c,0x73, /* ; ..<b>1:</b> <s */ \
	0x65,0x6c,0x65,0x63,0x74,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x6c,0x65,0x64,0x31, /* elect name="led1 */ \
	0x22,0x3e,0x3c,0x6f,0x70,0x74,0x69,0x6f,0x6e,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d, /* "><option value= */ \
	0x22,0x31,0x22,0x20,0x7e,0x6c,0x65,0x64,0x53,0x65,0x6c,0x65,0x63,0x74,0x65,0x64, /* "1" ~ledSelected */ \
	0x28,0x31,0x2c,0x54,0x52,0x55,0x45,0x29,0x7e,0x3e,0x4f,0x6e,0x3c,0x2f,0x6f,0x70, /* (1,TRUE)~>On</op */ \
	0x74,0x69,0x6f,0x6e,0x3e,0x3c,0x6f,0x70,0x74,0x69,0x6f,0x6e,0x20,0x76,0x61,0x6c, /* tion><option val */ \
	0x75,0x65,0x3d,0x22,0x30,0x22,0x20,0x7e,0x6c,0x65,0x64,0x53,0x65,0x6c,0x65,0x63, /* ue="0" ~ledSelec */ \
	0x74,0x65,0x64,0x28,0x31,0x2c,0x46,0x41,0x4c,0x53,0x45,0x29,0x7e,0x3e,0x4f,0x66, /* ted(1,FALSE)~>Of */ \
	0x66,0x3c,0x2f,0x6f,0x70,0x74,0x69,0x6f,0x6e,0x3e,0x3c,0x2f,0x73,0x65,0x6c,0x65, /* f</option></sele */ \
	0x63,0x74,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x20,0x0d,0x0a,0x3c,0x62,0x72,0x20, /* ct>&nbsp; ..<br  */ \
	0x2f,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x73, /* /><input type="s */ \
	0x75,0x62,0x6d,0x69,0x74,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x53,0x61, /* ubmit" value="Sa */ \
	0x76,0x65,0x22,0x20,0x73,0x74,0x79,0x6c,0x65,0x3d,0x22,0x6d,0x61,0x72,0x67,0x69, /* ve" style="margi */ \
	0x6e,0x2d,0x74,0x6f,0x70,0x3a,0x35,0x70,0x78,0x3b,0x22,0x3e,0x0d,0x0a,0x3c,0x2f, /* n-top:5px;">..</ */ \
	0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x6f,0x72,0x6d,0x3e,0x0d,0x0a,0x0d, /* div>..</form>... */ \
	0x0a,0x3c,0x70,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x65,0x78,0x65,0x72,0x63, /* .<p class="exerc */ \
	0x69,0x73,0x65,0x22,0x3e,0x3c,0x62,0x3e,0x45,0x78,0x65,0x72,0x63,0x69,0x73,0x65, /* ise"><b>Exercise */ \
	0x3a,0x3c,0x2f,0x62,0x3e,0x20,0x4d,0x6f,0x64,0x69,0x66,0x79,0x20,0x74,0x68,0x69, /* :</b> Modify thi */ \
	0x73,0x20,0x66,0x6f,0x72,0x6d,0x20,0x74,0x6f,0x20,0x73,0x75,0x70,0x70,0x6f,0x72, /* s form to suppor */ \
	0x74,0x20,0x4c,0x45,0x44,0x20,0x35,0x2e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a, /* t LED 5.</p>.... */ \
	0x3c,0x68,0x36,0x3e,0x3c,0x2f,0x68,0x36,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x3e, /* <h6></h6>....<p> */ \
	0x54,0x68,0x65,0x20,0x3c,0x62,0x3e,0x50,0x4f,0x53,0x54,0x3c,0x2f,0x62,0x3e,0x20, /* The <b>POST</b>  */ \
	0x6d,0x65,0x74,0x68,0x6f,0x64,0x20,0x73,0x75,0x62,0x6d,0x69,0x74,0x73,0x20,0x74, /* method submits t */ \
	0x68,0x65,0x20,0x64,0x61,0x74,0x61,0x20,0x61,0x66,0x74,0x65,0x72,0x20,0x74,0x68, /* he data after th */ \
	0x65,0x20,0x72,0x65,0x71,0x75,0x65,0x73,0x74,0x20,0x68,0x65,0x61,0x64,0x65,0x72, /* e request header */ \
	0x73,0x20,0x61,0x72,0x65,0x20,0x0d,0x0a,0x73,0x65,0x6e,0x74,0x2e,0x20,0x20,0x54, /* s are ..sent.  T */ \
	0x68,0x69,0x73,0x20,0x61,0x6c,0x6c,0x6f,0x77,0x73,0x20,0x74,0x68,0x65,0x20,0x64, /* his allows the d */ \
	0x61,0x74,0x61,0x20,0x74,0x6f,0x20,0x62,0x65,0x20,0x76,0x69,0x72,0x74,0x75,0x61, /* ata to be virtua */ \
	0x6c,0x6c,0x79,0x20,0x75,0x6e,0x6c,0x69,0x6d,0x69,0x74,0x65,0x64,0x20,0x69,0x6e, /* lly unlimited in */ \
	0x20,0x6c,0x65,0x6e,0x67,0x74,0x68,0x2c,0x20,0x61,0x73,0x20,0x6c,0x6f,0x6e,0x67, /*  length, as long */ \
	0x20,0x61,0x73,0x20,0x79,0x6f,0x75,0x72,0x20,0x0d,0x0a,0x61,0x70,0x70,0x6c,0x69, /*  as your ..appli */ \
	0x63,0x61,0x74,0x69,0x6f,0x6e,0x20,0x63,0x61,0x6e,0x20,0x70,0x72,0x6f,0x63,0x65, /* cation can proce */ \
	0x73,0x73,0x20,0x69,0x74,0x20,0x69,0x6e,0x20,0x63,0x68,0x75,0x6e,0x6b,0x73,0x2e, /* ss it in chunks. */ \
	0x20,0x20,0x48,0x6f,0x77,0x65,0x76,0x65,0x72,0x2c,0x20,0x79,0x6f,0x75,0x72,0x20, /*   However, your  */ \
	0x61,0x70,0x70,0x6c,0x69,0x63,0x61,0x74,0x69,0x6f,0x6e,0x20,0x6d,0x75,0x73,0x74, /* application must */ \
	0x20,0x6d,0x61,0x6e,0x61,0x67,0x65,0x20,0x0d,0x0a,0x74,0x68,0x65,0x20,0x72,0x65, /*  manage ..the re */ \
	0x63,0x65,0x69,0x70,0x74,0x20,0x6f,0x66,0x20,0x64,0x61,0x74,0x61,0x2c,0x20,0x73, /* ceipt of data, s */ \
	0x6f,0x20,0x69,0x74,0x20,0x69,0x73,0x20,0x67,0x65,0x6e,0x65,0x72,0x61,0x6c,0x6c, /* o it is generall */ \
	0x79,0x20,0x6d,0x6f,0x72,0x65,0x20,0x63,0x6f,0x6d,0x70,0x6c,0x69,0x63,0x61,0x74, /* y more complicat */ \
	0x65,0x64,0x2e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x3e,0x41,0x73, /* ed.</p>....<p>As */ \
	0x20,0x61,0x6e,0x20,0x65,0x78,0x61,0x6d,0x70,0x6c,0x65,0x2c,0x20,0x74,0x68,0x69, /*  an example, thi */ \
	0x73,0x20,0x50,0x4f,0x53,0x54,0x20,0x66,0x6f,0x72,0x6d,0x20,0x73,0x65,0x74,0x73, /* s POST form sets */ \
	0x20,0x74,0x68,0x65,0x20,0x74,0x65,0x78,0x74,0x20,0x73,0x68,0x6f,0x77,0x6e,0x20, /*  the text shown  */ \
	0x6f,0x6e,0x20,0x74,0x68,0x65,0x20,0x4c,0x43,0x44,0x20,0x64,0x69,0x73,0x70,0x6c, /* on the LCD displ */ \
	0x61,0x79,0x3a,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x66,0x6f,0x72,0x6d, /* ay:</p>....<form */ \
	0x20,0x6d,0x65,0x74,0x68,0x6f,0x64,0x3d,0x22,0x70,0x6f,0x73,0x74,0x22,0x20,0x61, /*  method="post" a */ \
	0x63,0x74,0x69,0x6f,0x6e,0x3d,0x22,0x66,0x6f,0x72,0x6d,0x73,0x2e,0x68,0x74,0x6d, /* ction="forms.htm */ \
	0x22,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22, /* ">..<div class=" */ \
	0x65,0x78,0x61,0x6d,0x70,0x6c,0x65,0x62,0x6f,0x78,0x22,0x3e,0x0d,0x0a,0x3c,0x62, /* examplebox">..<b */ \
	0x3e,0x4c,0x43,0x44,0x3a,0x3c,0x2f,0x62,0x3e,0x20,0x3c,0x69,0x6e,0x70,0x75,0x74, /* >LCD:</b> <input */ \
	0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d, /*  type="text" nam */ \
	0x65,0x3d,0x22,0x6c,0x63,0x64,0x22,0x20,0x6d,0x61,0x78,0x6c,0x65,0x6e,0x67,0x74, /* e="lcd" maxlengt */ \
	0x68,0x3d,0x22,0x33,0x32,0x22,0x3e,0x20,0x26,0x6e,0x62,0x73,0x70,0x3b,0x20,0x3c  /* h="32"> &nbsp; < */
#define DATACHUNK00000a \
	0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x73,0x75,0x62,0x6d, /* input type="subm */ \
	0x69,0x74,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x53,0x61,0x76,0x65,0x22, /* it" value="Save" */ \
	0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x6f,0x72, /* >..</div>..</for */ \
	0x6d,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a, /* m>....</div>.... */ \
	0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65, /* <script type="te */ \
	0x78,0x74,0x2f,0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x0d, /* xt/javascript">. */ \
	0x0a,0x3c,0x21,0x2d,0x2d,0x0d,0x0a,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e, /* .<!--..document. */ \
	0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28,0x27, /* getElementById(' */ \
	0x68,0x65,0x6c,0x6c,0x6f,0x27,0x29,0x2e,0x69,0x6e,0x6e,0x65,0x72,0x48,0x54,0x4d, /* hello').innerHTM */ \
	0x4c,0x20,0x3d,0x20,0x22,0x7e,0x68,0x65,0x6c,0x6c,0x6f,0x6d,0x73,0x67,0x7e,0x22, /* L = "~hellomsg~" */ \
	0x3b,0x0d,0x0a,0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70,0x74, /* ;..-->..</script */ \
	0x3e,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69, /* >..~inc:footer.i */ \
	0x6e,0x63,0x7e,0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0x61,0x04,0x00,0x00,0x0e, /* nc~....3...a.... */ \
	0x00,0x00,0x00,0x94,0x04,0x00,0x00,0x0f,0x00,0x00,0x00,0xf9,0x04,0x00,0x00,0x10, /* ................ */ \
	0x00,0x00,0x00,0x2c,0x05,0x00,0x00,0x11,0x00,0x00,0x00,0x91,0x05,0x00,0x00,0x12, /* ...,............ */ \
	0x00,0x00,0x00,0xc4,0x05,0x00,0x00,0x13,0x00,0x00,0x00,0x29,0x06,0x00,0x00,0x14, /* ...........).... */ \
	0x00,0x00,0x00,0x5c,0x06,0x00,0x00,0x15,0x00,0x00,0x00,0xda,0x09,0x00,0x00,0x01, /* ...\............ */ \
	0x00,0x00,0x00,0xf8,0x09,0x00,0x00,0x02,0x00,0x00,0x00,0x3c,0x21,0x44,0x4f,0x43, /* ...........<!DOC */ \
	0x54,0x59,0x50,0x45,0x20,0x68,0x74,0x6d,0x6c,0x20,0x50,0x55,0x42,0x4c,0x49,0x43, /* TYPE html PUBLIC */ \
	0x20,0x22,0x2d,0x2f,0x2f,0x57,0x33,0x43,0x2f,0x2f,0x44,0x54,0x44,0x20,0x58,0x48, /*  "-//W3C//DTD XH */ \
	0x54,0x4d,0x4c,0x20,0x31,0x2e,0x30,0x20,0x53,0x74,0x72,0x69,0x63,0x74,0x2f,0x2f, /* TML 1.0 Strict// */ \
	0x45,0x4e,0x22,0x0d,0x0a,0x20,0x20,0x22,0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f,0x77, /* EN"..  "http://w */ \
	0x77,0x77,0x2e,0x77,0x33,0x2e,0x6f,0x72,0x67,0x2f,0x54,0x52,0x2f,0x78,0x68,0x74, /* ww.w3.org/TR/xht */ \
	0x6d,0x6c,0x31,0x2f,0x44,0x54,0x44,0x2f,0x78,0x68,0x74,0x6d,0x6c,0x31,0x2d,0x73, /* ml1/DTD/xhtml1-s */ \
	0x74,0x72,0x69,0x63,0x74,0x2e,0x64,0x74,0x64,0x22,0x3e,0x0d,0x0a,0x3c,0x68,0x74, /* trict.dtd">..<ht */ \
	0x6d,0x6c,0x20,0x78,0x6d,0x6c,0x6e,0x73,0x3d,0x22,0x68,0x74,0x74,0x70,0x3a,0x2f, /* ml xmlns="http:/ */ \
	0x2f,0x77,0x77,0x77,0x2e,0x77,0x33,0x2e,0x6f,0x72,0x67,0x2f,0x31,0x39,0x39,0x39, /* /www.w3.org/1999 */ \
	0x2f,0x78,0x68,0x74,0x6d,0x6c,0x22,0x20,0x78,0x6d,0x6c,0x3a,0x6c,0x61,0x6e,0x67, /* /xhtml" xml:lang */ \
	0x3d,0x22,0x65,0x6e,0x22,0x20,0x6c,0x61,0x6e,0x67,0x3d,0x22,0x65,0x6e,0x22,0x3e, /* ="en" lang="en"> */ \
	0x0d,0x0a,0x3c,0x68,0x65,0x61,0x64,0x3e,0x0d,0x0a,0x3c,0x74,0x69,0x74,0x6c,0x65, /* ..<head>..<title */ \
	0x3e,0x4d,0x69,0x63,0x72,0x6f,0x63,0x68,0x69,0x70,0x20,0x54,0x43,0x50,0x2f,0x49, /* >Microchip TCP/I */ \
	0x50,0x20,0x53,0x74,0x61,0x63,0x6b,0x20,0x44,0x65,0x6d,0x6f,0x20,0x41,0x70,0x70, /* P Stack Demo App */ \
	0x3c,0x2f,0x74,0x69,0x74,0x6c,0x65,0x3e,0x0d,0x0a,0x3c,0x6c,0x69,0x6e,0x6b,0x20, /* </title>..<link  */ \
	0x68,0x72,0x65,0x66,0x3d,0x22,0x2f,0x6d,0x63,0x68,0x70,0x2e,0x63,0x73,0x73,0x22, /* href="/mchp.css" */ \
	0x20,0x72,0x65,0x6c,0x3d,0x22,0x73,0x74,0x79,0x6c,0x65,0x73,0x68,0x65,0x65,0x74, /*  rel="stylesheet */ \
	0x22,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x2f,0x63,0x73,0x73, /* " type="text/css */ \
	0x22,0x20,0x2f,0x3e,0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x73,0x72, /* " />..<script sr */ \
	0x63,0x3d,0x22,0x2f,0x6d,0x63,0x68,0x70,0x2e,0x6a,0x73,0x22,0x20,0x74,0x79,0x70, /* c="/mchp.js" typ */ \
	0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x2f,0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69, /* e="text/javascri */ \
	0x70,0x74,0x22,0x3e,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70,0x74,0x3e,0x0d,0x0a,0x3c, /* pt"></script>..< */ \
	0x2f,0x68,0x65,0x61,0x64,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x62,0x6f,0x64,0x79,0x3e, /* /head>....<body> */ \
	0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x73,0x68,0x61,0x64,0x6f, /* ..<div id="shado */ \
	0x77,0x2d,0x6f,0x6e,0x65,0x22,0x3e,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22, /* w-one"><div id=" */ \
	0x73,0x68,0x61,0x64,0x6f,0x77,0x2d,0x74,0x77,0x6f,0x22,0x3e,0x3c,0x64,0x69,0x76, /* shadow-two"><div */ \
	0x20,0x69,0x64,0x3d,0x22,0x73,0x68,0x61,0x64,0x6f,0x77,0x2d,0x74,0x68,0x72,0x65, /*  id="shadow-thre */ \
	0x65,0x22,0x3e,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x73,0x68,0x61,0x64, /* e"><div id="shad */ \
	0x6f,0x77,0x2d,0x66,0x6f,0x75,0x72,0x22,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20, /* ow-four">..<div  */ \
	0x69,0x64,0x3d,0x22,0x70,0x61,0x67,0x65,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x64, /* id="page">....<d */ \
	0x69,0x76,0x20,0x73,0x74,0x79,0x6c,0x65,0x3d,0x22,0x70,0x61,0x64,0x64,0x69,0x6e, /* iv style="paddin */ \
	0x67,0x3a,0x30,0x20,0x30,0x20,0x35,0x70,0x78,0x20,0x35,0x70,0x78,0x22,0x3e,0x3c, /* g:0 0 5px 5px">< */ \
	0x69,0x6d,0x67,0x20,0x73,0x72,0x63,0x3d,0x22,0x2f,0x6d,0x63,0x68,0x70,0x2e,0x67, /* img src="/mchp.g */ \
	0x69,0x66,0x22,0x20,0x61,0x6c,0x74,0x3d,0x22,0x4d,0x69,0x63,0x72,0x6f,0x63,0x68, /* if" alt="Microch */ \
	0x69,0x70,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a, /* ip" /></div>.... */ \
	0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x74,0x69,0x74,0x6c,0x65,0x22,0x3e, /* <div id="title"> */ \
	0x3c,0x64,0x69,0x76,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x72,0x69,0x67,0x68, /* <div class="righ */ \
	0x74,0x22,0x3e,0x54,0x43,0x50,0x2f,0x49,0x50,0x20,0x53,0x74,0x61,0x63,0x6b,0x20, /* t">TCP/IP Stack  */ \
	0x44,0x65,0x6d,0x6f,0x20,0x41,0x70,0x70,0x6c,0x69,0x63,0x61,0x74,0x69,0x6f,0x6e, /* Demo Application */ \
	0x3c,0x2f,0x64,0x69,0x76,0x3e,0x3c,0x73,0x70,0x61,0x6e,0x20,0x69,0x64,0x3d,0x22, /* </div><span id=" */ \
	0x68,0x65,0x6c,0x6c,0x6f,0x22,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x73, /* hello">&nbsp;</s */ \
	0x70,0x61,0x6e,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x64, /* pan></div>....<d */ \
	0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x6d,0x65,0x6e,0x75,0x22,0x3e,0x0d,0x0a,0x3c, /* iv id="menu">..< */ \
	0x61,0x20,0x68,0x72,0x65,0x66,0x3d,0x22,0x2f,0x69,0x6e,0x64,0x65,0x78,0x2e,0x68, /* a href="/index.h */ \
	0x74,0x6d,0x22,0x3e,0x4f,0x76,0x65,0x72,0x76,0x69,0x65,0x77,0x3c,0x2f,0x61,0x3e, /* tm">Overview</a> */ \
	0x0d,0x0a,0x3c,0x61,0x20,0x68,0x72,0x65,0x66,0x3d,0x22,0x2f,0x64,0x79,0x6e,0x76  /* ..<a href="/dynv */
#define DATACHUNK00000b \
	0x61,0x72,0x73,0x2e,0x68,0x74,0x6d,0x22,0x3e,0x44,0x79,0x6e,0x61,0x6d,0x69,0x63, /* ars.htm">Dynamic */ \
	0x20,0x56,0x61,0x72,0x69,0x61,0x62,0x6c,0x65,0x73,0x3c,0x2f,0x61,0x3e,0x0d,0x0a, /*  Variables</a>.. */ \
	0x3c,0x61,0x20,0x68,0x72,0x65,0x66,0x3d,0x22,0x2f,0x66,0x6f,0x72,0x6d,0x73,0x2e, /* <a href="/forms. */ \
	0x68,0x74,0x6d,0x22,0x3e,0x46,0x6f,0x72,0x6d,0x20,0x50,0x72,0x6f,0x63,0x65,0x73, /* htm">Form Proces */ \
	0x73,0x69,0x6e,0x67,0x3c,0x2f,0x61,0x3e,0x0d,0x0a,0x3c,0x61,0x20,0x68,0x72,0x65, /* sing</a>..<a hre */ \
	0x66,0x3d,0x22,0x2f,0x61,0x75,0x74,0x68,0x2e,0x68,0x74,0x6d,0x22,0x3e,0x41,0x75, /* f="/auth.htm">Au */ \
	0x74,0x68,0x65,0x6e,0x74,0x69,0x63,0x61,0x74,0x69,0x6f,0x6e,0x3c,0x2f,0x61,0x3e, /* thentication</a> */ \
	0x0d,0x0a,0x3c,0x61,0x20,0x68,0x72,0x65,0x66,0x3d,0x22,0x2f,0x63,0x6f,0x6f,0x6b, /* ..<a href="/cook */ \
	0x69,0x65,0x73,0x2e,0x68,0x74,0x6d,0x22,0x3e,0x43,0x6f,0x6f,0x6b,0x69,0x65,0x73, /* ies.htm">Cookies */ \
	0x3c,0x2f,0x61,0x3e,0x0d,0x0a,0x3c,0x61,0x20,0x68,0x72,0x65,0x66,0x3d,0x22,0x2f, /* </a>..<a href="/ */ \
	0x75,0x70,0x6c,0x6f,0x61,0x64,0x2e,0x68,0x74,0x6d,0x22,0x3e,0x46,0x69,0x6c,0x65, /* upload.htm">File */ \
	0x20,0x55,0x70,0x6c,0x6f,0x61,0x64,0x73,0x3c,0x2f,0x61,0x3e,0x0d,0x0a,0x3c,0x61, /*  Uploads</a>..<a */ \
	0x20,0x68,0x72,0x65,0x66,0x3d,0x22,0x2f,0x65,0x6d,0x61,0x69,0x6c,0x22,0x3e,0x53, /*  href="/email">S */ \
	0x65,0x6e,0x64,0x20,0x45,0x2d,0x6d,0x61,0x69,0x6c,0x3c,0x2f,0x61,0x3e,0x0d,0x0a, /* end E-mail</a>.. */ \
	0x3c,0x61,0x20,0x68,0x72,0x65,0x66,0x3d,0x22,0x2f,0x64,0x79,0x6e,0x64,0x6e,0x73, /* <a href="/dyndns */ \
	0x22,0x3e,0x44,0x79,0x6e,0x61,0x6d,0x69,0x63,0x20,0x44,0x4e,0x53,0x3c,0x2f,0x61, /* ">Dynamic DNS</a */ \
	0x3e,0x0d,0x0a,0x3c,0x61,0x20,0x68,0x72,0x65,0x66,0x3d,0x22,0x2f,0x70,0x72,0x6f, /* >..<a href="/pro */ \
	0x74,0x65,0x63,0x74,0x2f,0x63,0x6f,0x6e,0x66,0x69,0x67,0x2e,0x68,0x74,0x6d,0x22, /* tect/config.htm" */ \
	0x3e,0x4e,0x65,0x74,0x77,0x6f,0x72,0x6b,0x20,0x43,0x6f,0x6e,0x66,0x69,0x67,0x75, /* >Network Configu */ \
	0x72,0x61,0x74,0x69,0x6f,0x6e,0x3c,0x2f,0x61,0x3e,0x0d,0x0a,0x3c,0x61,0x20,0x68, /* ration</a>..<a h */ \
	0x72,0x65,0x66,0x3d,0x22,0x2f,0x73,0x6e,0x6d,0x70,0x2f,0x73,0x6e,0x6d,0x70,0x63, /* ref="/snmp/snmpc */ \
	0x6f,0x6e,0x66,0x69,0x67,0x2e,0x68,0x74,0x6d,0x22,0x3e,0x53,0x4e,0x4d,0x50,0x20, /* onfig.htm">SNMP  */ \
	0x43,0x6f,0x6e,0x66,0x69,0x67,0x75,0x72,0x61,0x74,0x69,0x6f,0x6e,0x3c,0x2f,0x61, /* Configuration</a */ \
	0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65, /* >..</div>~inc:he */ \
	0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20, /* ader.inc~..<div  */ \
	0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d, /* id="content">... */ \
	0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x73,0x74,0x61,0x74,0x75,0x73, /* .<div id="status */ \
	0x22,0x3e,0x0d,0x0a,0x09,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x6c,0x6f, /* ">...<div id="lo */ \
	0x61,0x64,0x69,0x6e,0x67,0x22,0x20,0x73,0x74,0x79,0x6c,0x65,0x3d,0x22,0x64,0x69, /* ading" style="di */ \
	0x73,0x70,0x6c,0x61,0x79,0x3a,0x6e,0x6f,0x6e,0x65,0x22,0x3e,0x45,0x72,0x72,0x6f, /* splay:none">Erro */ \
	0x72,0x3a,0x3c,0x62,0x72,0x20,0x2f,0x3e,0x43,0x6f,0x6e,0x6e,0x65,0x63,0x74,0x69, /* r:<br />Connecti */ \
	0x6f,0x6e,0x20,0x74,0x6f,0x20,0x64,0x65,0x6d,0x6f,0x20,0x62,0x6f,0x61,0x72,0x64, /* on to demo board */ \
	0x20,0x77,0x61,0x73,0x20,0x6c,0x6f,0x73,0x74,0x2e,0x3c,0x2f,0x64,0x69,0x76,0x3e, /*  was lost.</div> */ \
	0x0d,0x0a,0x09,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x64,0x69,0x73,0x70, /* ...<div id="disp */ \
	0x6c,0x61,0x79,0x22,0x3e,0x0d,0x0a,0x09,0x09,0x3c,0x73,0x70,0x61,0x6e,0x20,0x73, /* lay">....<span s */ \
	0x74,0x79,0x6c,0x65,0x3d,0x22,0x66,0x6c,0x6f,0x61,0x74,0x3a,0x72,0x69,0x67,0x68, /* tyle="float:righ */ \
	0x74,0x3b,0x66,0x6f,0x6e,0x74,0x2d,0x73,0x69,0x7a,0x65,0x3a,0x39,0x70,0x78,0x3b, /* t;font-size:9px; */ \
	0x66,0x6f,0x6e,0x74,0x2d,0x77,0x65,0x69,0x67,0x68,0x74,0x3a,0x6e,0x6f,0x72,0x6d, /* font-weight:norm */ \
	0x61,0x6c,0x3b,0x70,0x61,0x64,0x64,0x69,0x6e,0x67,0x2d,0x74,0x6f,0x70,0x3a,0x38, /* al;padding-top:8 */ \
	0x70,0x78,0x3b,0x74,0x65,0x78,0x74,0x2d,0x69,0x6e,0x64,0x65,0x6e,0x74,0x3a,0x30, /* px;text-indent:0 */ \
	0x70,0x78,0x22,0x3e,0x28,0x63,0x6c,0x69,0x63,0x6b,0x20,0x74,0x6f,0x20,0x74,0x6f, /* px">(click to to */ \
	0x67,0x67,0x6c,0x65,0x29,0x3c,0x2f,0x73,0x70,0x61,0x6e,0x3e,0x0d,0x0a,0x09,0x09, /* ggle)</span>.... */ \
	0x3c,0x70,0x3e,0x4c,0x45,0x44,0x73,0x3a,0x3c,0x62,0x72,0x20,0x2f,0x3e,0x3c,0x73, /* <p>LEDs:<br /><s */ \
	0x70,0x61,0x6e,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x6c,0x65,0x64,0x73,0x22, /* pan class="leds" */ \
	0x3e,0x0d,0x0a,0x09,0x09,0x3c,0x61,0x20,0x69,0x64,0x3d,0x22,0x6c,0x65,0x64,0x37, /* >....<a id="led7 */ \
	0x22,0x20,0x6f,0x6e,0x63,0x6c,0x69,0x63,0x6b,0x3d,0x22,0x6e,0x65,0x77,0x41,0x4a, /* " onclick="newAJ */ \
	0x41,0x58,0x43,0x6f,0x6d,0x6d,0x61,0x6e,0x64,0x28,0x27,0x6c,0x65,0x64,0x73,0x2e, /* AXCommand('leds. */ \
	0x63,0x67,0x69,0x3f,0x6c,0x65,0x64,0x3d,0x37,0x27,0x29,0x3b,0x22,0x3e,0x26,0x62, /* cgi?led=7');">&b */ \
	0x75,0x6c,0x6c,0x3b,0x3c,0x2f,0x61,0x3e,0x0d,0x0a,0x09,0x09,0x3c,0x61,0x20,0x69, /* ull;</a>....<a i */ \
	0x64,0x3d,0x22,0x6c,0x65,0x64,0x36,0x22,0x20,0x6f,0x6e,0x63,0x6c,0x69,0x63,0x6b, /* d="led6" onclick */ \
	0x3d,0x22,0x6e,0x65,0x77,0x41,0x4a,0x41,0x58,0x43,0x6f,0x6d,0x6d,0x61,0x6e,0x64, /* ="newAJAXCommand */ \
	0x28,0x27,0x6c,0x65,0x64,0x73,0x2e,0x63,0x67,0x69,0x3f,0x6c,0x65,0x64,0x3d,0x36, /* ('leds.cgi?led=6 */ \
	0x27,0x29,0x3b,0x22,0x3e,0x26,0x62,0x75,0x6c,0x6c,0x3b,0x3c,0x2f,0x61,0x3e,0x0d, /* ');">&bull;</a>. */ \
	0x0a,0x09,0x09,0x3c,0x61,0x20,0x69,0x64,0x3d,0x22,0x6c,0x65,0x64,0x35,0x22,0x20, /* ...<a id="led5"  */ \
	0x6f,0x6e,0x63,0x6c,0x69,0x63,0x6b,0x3d,0x22,0x6e,0x65,0x77,0x41,0x4a,0x41,0x58, /* onclick="newAJAX */ \
	0x43,0x6f,0x6d,0x6d,0x61,0x6e,0x64,0x28,0x27,0x6c,0x65,0x64,0x73,0x2e,0x63,0x67, /* Command('leds.cg */ \
	0x69,0x3f,0x6c,0x65,0x64,0x3d,0x35,0x27,0x29,0x3b,0x22,0x3e,0x26,0x62,0x75,0x6c, /* i?led=5');">&bul */ \
	0x6c,0x3b,0x3c,0x2f,0x61,0x3e,0x0d,0x0a,0x09,0x09,0x3c,0x61,0x20,0x69,0x64,0x3d, /* l;</a>....<a id= */ \
	0x22,0x6c,0x65,0x64,0x34,0x22,0x20,0x6f,0x6e,0x63,0x6c,0x69,0x63,0x6b,0x3d,0x22, /* "led4" onclick=" */ \
	0x6e,0x65,0x77,0x41,0x4a,0x41,0x58,0x43,0x6f,0x6d,0x6d,0x61,0x6e,0x64,0x28,0x27, /* newAJAXCommand(' */ \
	0x6c,0x65,0x64,0x73,0x2e,0x63,0x67,0x69,0x3f,0x6c,0x65,0x64,0x3d,0x34,0x27,0x29, /* leds.cgi?led=4') */ \
	0x3b,0x22,0x3e,0x26,0x62,0x75,0x6c,0x6c,0x3b,0x3c,0x2f,0x61,0x3e,0x0d,0x0a,0x09, /* ;">&bull;</a>... */ \
	0x09,0x3c,0x61,0x20,0x69,0x64,0x3d,0x22,0x6c,0x65,0x64,0x33,0x22,0x20,0x6f,0x6e, /* .<a id="led3" on */ \
	0x63,0x6c,0x69,0x63,0x6b,0x3d,0x22,0x6e,0x65,0x77,0x41,0x4a,0x41,0x58,0x43,0x6f  /* click="newAJAXCo */
#define DATACHUNK00000c \
	0x6d,0x6d,0x61,0x6e,0x64,0x28,0x27,0x6c,0x65,0x64,0x73,0x2e,0x63,0x67,0x69,0x3f, /* mmand('leds.cgi? */ \
	0x6c,0x65,0x64,0x3d,0x33,0x27,0x29,0x3b,0x22,0x3e,0x26,0x62,0x75,0x6c,0x6c,0x3b, /* led=3');">&bull; */ \
	0x3c,0x2f,0x61,0x3e,0x0d,0x0a,0x09,0x09,0x3c,0x61,0x20,0x69,0x64,0x3d,0x22,0x6c, /* </a>....<a id="l */ \
	0x65,0x64,0x32,0x22,0x20,0x6f,0x6e,0x63,0x6c,0x69,0x63,0x6b,0x3d,0x22,0x6e,0x65, /* ed2" onclick="ne */ \
	0x77,0x41,0x4a,0x41,0x58,0x43,0x6f,0x6d,0x6d,0x61,0x6e,0x64,0x28,0x27,0x6c,0x65, /* wAJAXCommand('le */ \
	0x64,0x73,0x2e,0x63,0x67,0x69,0x3f,0x6c,0x65,0x64,0x3d,0x32,0x27,0x29,0x3b,0x22, /* ds.cgi?led=2');" */ \
	0x3e,0x26,0x62,0x75,0x6c,0x6c,0x3b,0x3c,0x2f,0x61,0x3e,0x0d,0x0a,0x09,0x09,0x3c, /* >&bull;</a>....< */ \
	0x61,0x20,0x69,0x64,0x3d,0x22,0x6c,0x65,0x64,0x31,0x22,0x20,0x6f,0x6e,0x63,0x6c, /* a id="led1" oncl */ \
	0x69,0x63,0x6b,0x3d,0x22,0x6e,0x65,0x77,0x41,0x4a,0x41,0x58,0x43,0x6f,0x6d,0x6d, /* ick="newAJAXComm */ \
	0x61,0x6e,0x64,0x28,0x27,0x6c,0x65,0x64,0x73,0x2e,0x63,0x67,0x69,0x3f,0x6c,0x65, /* and('leds.cgi?le */ \
	0x64,0x3d,0x31,0x27,0x29,0x3b,0x22,0x3e,0x26,0x62,0x75,0x6c,0x6c,0x3b,0x3c,0x2f, /* d=1');">&bull;</ */ \
	0x61,0x3e,0x0d,0x0a,0x09,0x09,0x3c,0x61,0x20,0x69,0x64,0x3d,0x22,0x6c,0x65,0x64, /* a>....<a id="led */ \
	0x30,0x22,0x3e,0x26,0x62,0x75,0x6c,0x6c,0x3b,0x3c,0x2f,0x61,0x3e,0x0d,0x0a,0x09, /* 0">&bull;</a>... */ \
	0x09,0x3c,0x2f,0x73,0x70,0x61,0x6e,0x3e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x09,0x09, /* .</span></p>.... */ \
	0x3c,0x70,0x3e,0x42,0x75,0x74,0x74,0x6f,0x6e,0x73,0x3a,0x3c,0x62,0x72,0x20,0x2f, /* <p>Buttons:<br / */ \
	0x3e,0x0d,0x0a,0x09,0x09,0x3c,0x73,0x70,0x61,0x6e,0x20,0x69,0x64,0x3d,0x22,0x62, /* >....<span id="b */ \
	0x74,0x6e,0x33,0x22,0x3e,0x3f,0x3c,0x2f,0x73,0x70,0x61,0x6e,0x3e,0x20,0x26,0x6e, /* tn3">?</span> &n */ \
	0x62,0x73,0x70,0x3b,0x0d,0x0a,0x09,0x09,0x3c,0x73,0x70,0x61,0x6e,0x20,0x69,0x64, /* bsp;....<span id */ \
	0x3d,0x22,0x62,0x74,0x6e,0x32,0x22,0x3e,0x3f,0x3c,0x2f,0x73,0x70,0x61,0x6e,0x3e, /* ="btn2">?</span> */ \
	0x20,0x26,0x6e,0x62,0x73,0x70,0x3b,0x0d,0x0a,0x09,0x09,0x3c,0x73,0x70,0x61,0x6e, /*  &nbsp;....<span */ \
	0x20,0x69,0x64,0x3d,0x22,0x62,0x74,0x6e,0x31,0x22,0x3e,0x3f,0x3c,0x2f,0x73,0x70, /*  id="btn1">?</sp */ \
	0x61,0x6e,0x3e,0x20,0x26,0x6e,0x62,0x73,0x70,0x3b,0x0d,0x0a,0x09,0x09,0x3c,0x73, /* an> &nbsp;....<s */ \
	0x70,0x61,0x6e,0x20,0x69,0x64,0x3d,0x22,0x62,0x74,0x6e,0x30,0x22,0x3e,0x3f,0x3c, /* pan id="btn0">?< */ \
	0x2f,0x73,0x70,0x61,0x6e,0x3e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x09,0x09,0x3c,0x70, /* /span></p>....<p */ \
	0x3e,0x50,0x6f,0x74,0x65,0x6e,0x74,0x69,0x6f,0x6d,0x65,0x74,0x65,0x72,0x3a,0x20, /* >Potentiometer:  */ \
	0x3c,0x73,0x70,0x61,0x6e,0x20,0x69,0x64,0x3d,0x22,0x70,0x6f,0x74,0x30,0x22,0x20, /* <span id="pot0"  */ \
	0x73,0x74,0x79,0x6c,0x65,0x3d,0x22,0x66,0x6f,0x6e,0x74,0x2d,0x77,0x65,0x69,0x67, /* style="font-weig */ \
	0x68,0x74,0x3a,0x6e,0x6f,0x72,0x6d,0x61,0x6c,0x22,0x3e,0x3f,0x3c,0x2f,0x73,0x70, /* ht:normal">?</sp */ \
	0x61,0x6e,0x3e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x09,0x3c,0x2f,0x64,0x69,0x76,0x3e, /* an></p>...</div> */ \
	0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31,0x3e, /* ..</div>....<h1> */ \
	0x57,0x65,0x6c,0x63,0x6f,0x6d,0x65,0x21,0x3c,0x2f,0x68,0x31,0x3e,0x0d,0x0a,0x0d, /* Welcome!</h1>... */ \
	0x0a,0x3c,0x74,0x61,0x62,0x6c,0x65,0x20,0x73,0x74,0x79,0x6c,0x65,0x3d,0x22,0x70, /* .<table style="p */ \
	0x61,0x64,0x64,0x69,0x6e,0x67,0x2d,0x6c,0x65,0x66,0x74,0x3a,0x20,0x31,0x30,0x70, /* adding-left: 10p */ \
	0x78,0x3b,0x22,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62, /* x;">..<tr><td><b */ \
	0x3e,0x53,0x74,0x61,0x63,0x6b,0x20,0x56,0x65,0x72,0x73,0x69,0x6f,0x6e,0x3a,0x3c, /* >Stack Version:< */ \
	0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73, /* /b></td><td>&nbs */ \
	0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x76,0x65,0x72,0x73, /* p;</td><td>~vers */ \
	0x69,0x6f,0x6e,0x7e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a, /* ion~</td></tr>.. */ \
	0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x42,0x75,0x69,0x6c,0x64, /* <tr><td><b>Build */ \
	0x20,0x44,0x61,0x74,0x65,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c, /*  Date:</b></td>< */ \
	0x74,0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74, /* td>&nbsp;</td><t */ \
	0x64,0x3e,0x7e,0x62,0x75,0x69,0x6c,0x64,0x64,0x61,0x74,0x65,0x7e,0x3c,0x2f,0x74, /* d>~builddate~</t */ \
	0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x2f,0x74,0x61,0x62,0x6c,0x65, /* d></tr>..</table */ \
	0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x3e,0x54,0x68,0x69,0x73,0x20,0x73,0x69,0x74, /* >....<p>This sit */ \
	0x65,0x20,0x64,0x65,0x6d,0x6f,0x6e,0x73,0x74,0x72,0x61,0x74,0x65,0x73,0x20,0x74, /* e demonstrates t */ \
	0x68,0x65,0x20,0x70,0x6f,0x77,0x65,0x72,0x2c,0x20,0x66,0x6c,0x65,0x78,0x69,0x62, /* he power, flexib */ \
	0x69,0x6c,0x69,0x74,0x79,0x2c,0x20,0x61,0x6e,0x64,0x20,0x73,0x63,0x61,0x6c,0x61, /* ility, and scala */ \
	0x62,0x69,0x6c,0x69,0x74,0x79,0x20,0x6f,0x66,0x20,0x61,0x6e,0x20,0x38,0x2c,0x20, /* bility of an 8,  */ \
	0x31,0x36,0x2c,0x20,0x6f,0x72,0x20,0x33,0x32,0x2d,0x62,0x69,0x74,0x20,0x65,0x6d, /* 16, or 32-bit em */ \
	0x62,0x65,0x64,0x64,0x65,0x64,0x0d,0x0a,0x77,0x65,0x62,0x20,0x73,0x65,0x72,0x76, /* bedded..web serv */ \
	0x65,0x72,0x2e,0x20,0x20,0x45,0x76,0x65,0x72,0x79,0x74,0x68,0x69,0x6e,0x67,0x20, /* er.  Everything  */ \
	0x79,0x6f,0x75,0x20,0x73,0x65,0x65,0x20,0x69,0x73,0x20,0x70,0x6f,0x77,0x65,0x72, /* you see is power */ \
	0x65,0x64,0x20,0x62,0x79,0x20,0x61,0x20,0x4d,0x69,0x63,0x72,0x6f,0x63,0x68,0x69, /* ed by a Microchi */ \
	0x70,0x20,0x50,0x49,0x43,0x20,0x6d,0x69,0x63,0x72,0x6f,0x63,0x6f,0x6e,0x74,0x72, /* p PIC microcontr */ \
	0x6f,0x6c,0x6c,0x65,0x72,0x0d,0x0a,0x72,0x75,0x6e,0x6e,0x69,0x6e,0x67,0x20,0x74, /* oller..running t */ \
	0x68,0x65,0x20,0x4d,0x69,0x63,0x72,0x6f,0x63,0x68,0x69,0x70,0x20,0x54,0x43,0x50, /* he Microchip TCP */ \
	0x2f,0x49,0x50,0x20,0x53,0x74,0x61,0x63,0x6b,0x2e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a, /* /IP Stack.</p>.. */ \
	0x0d,0x0a,0x3c,0x70,0x3e,0x4f,0x6e,0x20,0x74,0x68,0x65,0x20,0x72,0x69,0x67,0x68, /* ..<p>On the righ */ \
	0x74,0x20,0x79,0x6f,0x75,0x27,0x6c,0x6c,0x20,0x73,0x65,0x65,0x20,0x74,0x68,0x65, /* t you'll see the */ \
	0x20,0x63,0x75,0x72,0x72,0x65,0x6e,0x74,0x20,0x73,0x74,0x61,0x74,0x75,0x73,0x20, /*  current status  */ \
	0x6f,0x66,0x20,0x74,0x68,0x65,0x20,0x64,0x65,0x6d,0x6f,0x20,0x62,0x6f,0x61,0x72, /* of the demo boar */ \
	0x64,0x2e,0x20,0x20,0x46,0x6f,0x72,0x20,0x61,0x20,0x71,0x75,0x69,0x63,0x6b,0x0d, /* d.  For a quick. */ \
	0x0a,0x65,0x78,0x61,0x6d,0x70,0x6c,0x65,0x2c,0x20,0x63,0x6c,0x69,0x63,0x6b,0x20, /* .example, click  */ \
	0x74,0x68,0x65,0x20,0x4c,0x45,0x44,0x73,0x20,0x74,0x6f,0x20,0x74,0x6f,0x67,0x67  /* the LEDs to togg */
#define DATACHUNK00000d \
	0x6c,0x65,0x20,0x74,0x68,0x65,0x20,0x6c,0x69,0x67,0x68,0x74,0x73,0x20,0x6f,0x6e, /* le the lights on */ \
	0x20,0x74,0x68,0x65,0x20,0x62,0x6f,0x61,0x72,0x64,0x2e,0x20,0x20,0x50,0x72,0x65, /*  the board.  Pre */ \
	0x73,0x73,0x20,0x74,0x68,0x65,0x20,0x70,0x75,0x73,0x68,0x0d,0x0a,0x62,0x75,0x74, /* ss the push..but */ \
	0x74,0x6f,0x6e,0x73,0x20,0x28,0x65,0x78,0x63,0x65,0x70,0x74,0x20,0x4d,0x43,0x4c, /* tons (except MCL */ \
	0x52,0x21,0x29,0x20,0x6f,0x72,0x20,0x74,0x75,0x72,0x6e,0x20,0x74,0x68,0x65,0x20, /* R!) or turn the  */ \
	0x70,0x6f,0x74,0x65,0x6e,0x74,0x69,0x6f,0x6d,0x65,0x74,0x65,0x72,0x20,0x61,0x6e, /* potentiometer an */ \
	0x64,0x20,0x79,0x6f,0x75,0x27,0x6c,0x6c,0x20,0x73,0x65,0x65,0x20,0x74,0x68,0x65, /* d you'll see the */ \
	0x20,0x73,0x74,0x61,0x74,0x75,0x73,0x0d,0x0a,0x75,0x70,0x64,0x61,0x74,0x65,0x20, /*  status..update  */ \
	0x69,0x6d,0x6d,0x65,0x64,0x69,0x61,0x74,0x65,0x6c,0x79,0x2e,0x20,0x20,0x54,0x68, /* immediately.  Th */ \
	0x69,0x73,0x20,0x65,0x78,0x61,0x6d,0x70,0x6c,0x65,0x73,0x20,0x75,0x73,0x65,0x73, /* is examples uses */ \
	0x20,0x41,0x4a,0x41,0x58,0x20,0x74,0x65,0x63,0x68,0x6e,0x69,0x71,0x75,0x65,0x73, /*  AJAX techniques */ \
	0x20,0x74,0x6f,0x20,0x70,0x72,0x6f,0x76,0x69,0x64,0x65,0x20,0x72,0x65,0x61,0x6c, /*  to provide real */ \
	0x2d,0x74,0x69,0x6d,0x65,0x0d,0x0a,0x66,0x65,0x65,0x64,0x62,0x61,0x63,0x6b,0x2e, /* -time..feedback. */ \
	0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x3e,0x54,0x68,0x69,0x73,0x20, /* </p>....<p>This  */ \
	0x73,0x69,0x74,0x65,0x20,0x69,0x73,0x20,0x70,0x72,0x6f,0x76,0x69,0x64,0x65,0x64, /* site is provided */ \
	0x20,0x61,0x73,0x20,0x61,0x20,0x74,0x75,0x74,0x6f,0x72,0x69,0x61,0x6c,0x20,0x66, /*  as a tutorial f */ \
	0x6f,0x72,0x20,0x74,0x68,0x65,0x20,0x76,0x61,0x72,0x69,0x6f,0x75,0x73,0x20,0x66, /* or the various f */ \
	0x65,0x61,0x74,0x75,0x72,0x65,0x73,0x20,0x6f,0x66,0x20,0x74,0x68,0x65,0x20,0x48, /* eatures of the H */ \
	0x54,0x54,0x50,0x0d,0x0a,0x77,0x65,0x62,0x20,0x73,0x65,0x72,0x76,0x65,0x72,0x2c, /* TTP..web server, */ \
	0x20,0x69,0x6e,0x63,0x6c,0x75,0x64,0x69,0x6e,0x67,0x3a,0x3c,0x2f,0x70,0x3e,0x0d, /*  including:</p>. */ \
	0x0a,0x0d,0x0a,0x3c,0x75,0x6c,0x3e,0x0d,0x0a,0x3c,0x6c,0x69,0x3e,0x3c,0x62,0x3e, /* ...<ul>..<li><b> */ \
	0x44,0x79,0x6e,0x61,0x6d,0x69,0x63,0x20,0x56,0x61,0x72,0x69,0x61,0x62,0x6c,0x65, /* Dynamic Variable */ \
	0x20,0x53,0x75,0x62,0x73,0x74,0x69,0x74,0x75,0x74,0x69,0x6f,0x6e,0x3c,0x2f,0x62, /*  Substitution</b */ \
	0x3e,0x20,0x2d,0x20,0x64,0x69,0x73,0x70,0x6c,0x61,0x79,0x20,0x72,0x65,0x61,0x6c, /* > - display real */ \
	0x2d,0x74,0x69,0x6d,0x65,0x20,0x64,0x61,0x74,0x61,0x3c,0x2f,0x6c,0x69,0x3e,0x0d, /* -time data</li>. */ \
	0x0a,0x3c,0x6c,0x69,0x3e,0x3c,0x62,0x3e,0x46,0x6f,0x72,0x6d,0x20,0x50,0x72,0x6f, /* .<li><b>Form Pro */ \
	0x63,0x65,0x73,0x73,0x69,0x6e,0x67,0x3c,0x2f,0x62,0x3e,0x20,0x2d,0x20,0x68,0x61, /* cessing</b> - ha */ \
	0x6e,0x64,0x6c,0x65,0x20,0x69,0x6e,0x70,0x75,0x74,0x20,0x66,0x72,0x6f,0x6d,0x20, /* ndle input from  */ \
	0x74,0x68,0x65,0x20,0x63,0x6c,0x69,0x65,0x6e,0x74,0x3c,0x2f,0x6c,0x69,0x3e,0x0d, /* the client</li>. */ \
	0x0a,0x3c,0x6c,0x69,0x3e,0x3c,0x62,0x3e,0x41,0x75,0x74,0x68,0x65,0x6e,0x74,0x69, /* .<li><b>Authenti */ \
	0x63,0x61,0x74,0x69,0x6f,0x6e,0x3c,0x2f,0x62,0x3e,0x20,0x2d,0x20,0x72,0x65,0x71, /* cation</b> - req */ \
	0x75,0x69,0x72,0x65,0x20,0x61,0x20,0x75,0x73,0x65,0x72,0x20,0x6e,0x61,0x6d,0x65, /* uire a user name */ \
	0x20,0x61,0x6e,0x64,0x20,0x70,0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x3c,0x2f,0x6c, /*  and password</l */ \
	0x69,0x3e,0x0d,0x0a,0x3c,0x6c,0x69,0x3e,0x3c,0x62,0x3e,0x43,0x6f,0x6f,0x6b,0x69, /* i>..<li><b>Cooki */ \
	0x65,0x73,0x3c,0x2f,0x62,0x3e,0x20,0x2d,0x20,0x73,0x74,0x6f,0x72,0x65,0x20,0x73, /* es</b> - store s */ \
	0x65,0x73,0x73,0x69,0x6f,0x6e,0x20,0x73,0x74,0x61,0x74,0x65,0x20,0x69,0x6e,0x66, /* ession state inf */ \
	0x6f,0x72,0x6d,0x61,0x74,0x69,0x6f,0x6e,0x20,0x66,0x6f,0x72,0x20,0x72,0x69,0x63, /* ormation for ric */ \
	0x68,0x65,0x72,0x20,0x61,0x70,0x70,0x6c,0x69,0x63,0x61,0x74,0x69,0x6f,0x6e,0x73, /* her applications */ \
	0x3c,0x2f,0x6c,0x69,0x3e,0x0d,0x0a,0x3c,0x6c,0x69,0x3e,0x3c,0x62,0x3e,0x46,0x69, /* </li>..<li><b>Fi */ \
	0x6c,0x65,0x20,0x55,0x70,0x6c,0x6f,0x61,0x64,0x73,0x3c,0x2f,0x62,0x3e,0x20,0x2d, /* le Uploads</b> - */ \
	0x20,0x70,0x61,0x72,0x73,0x65,0x20,0x66,0x69,0x6c,0x65,0x73,0x20,0x66,0x6f,0x72, /*  parse files for */ \
	0x20,0x63,0x6f,0x6e,0x66,0x69,0x67,0x75,0x72,0x61,0x74,0x69,0x6f,0x6e,0x20,0x73, /*  configuration s */ \
	0x65,0x74,0x74,0x69,0x6e,0x67,0x73,0x20,0x61,0x6e,0x64,0x20,0x6d,0x6f,0x72,0x65, /* ettings and more */ \
	0x3c,0x2f,0x6c,0x69,0x3e,0x0d,0x0a,0x3c,0x2f,0x75,0x6c,0x3e,0x0d,0x0a,0x0d,0x0a, /* </li>..</ul>.... */ \
	0x3c,0x70,0x3e,0x53,0x65,0x76,0x65,0x72,0x61,0x6c,0x20,0x65,0x78,0x61,0x6d,0x70, /* <p>Several examp */ \
	0x6c,0x65,0x20,0x61,0x70,0x70,0x6c,0x69,0x63,0x61,0x74,0x69,0x6f,0x6e,0x73,0x20, /* le applications  */ \
	0x61,0x72,0x65,0x20,0x61,0x6c,0x73,0x6f,0x20,0x70,0x72,0x6f,0x76,0x69,0x64,0x65, /* are also provide */ \
	0x64,0x20,0x66,0x6f,0x72,0x20,0x75,0x70,0x64,0x61,0x74,0x69,0x6e,0x67,0x20,0x63, /* d for updating c */ \
	0x6f,0x6e,0x66,0x69,0x67,0x75,0x72,0x61,0x74,0x69,0x6f,0x6e,0x0d,0x0a,0x70,0x61, /* onfiguration..pa */ \
	0x72,0x61,0x6d,0x65,0x74,0x65,0x72,0x73,0x2c,0x20,0x73,0x65,0x6e,0x64,0x69,0x6e, /* rameters, sendin */ \
	0x67,0x20,0x65,0x2d,0x6d,0x61,0x69,0x6c,0x73,0x2c,0x20,0x61,0x6e,0x64,0x20,0x63, /* g e-mails, and c */ \
	0x6f,0x6e,0x74,0x72,0x6f,0x6c,0x6c,0x69,0x6e,0x67,0x20,0x74,0x68,0x65,0x20,0x44, /* ontrolling the D */ \
	0x79,0x6e,0x61,0x6d,0x69,0x63,0x20,0x44,0x4e,0x53,0x20,0x63,0x6c,0x69,0x65,0x6e, /* ynamic DNS clien */ \
	0x74,0x2e,0x20,0x20,0x54,0x68,0x61,0x6e,0x6b,0x73,0x20,0x74,0x6f,0x0d,0x0a,0x62, /* t.  Thanks to..b */ \
	0x75,0x69,0x6c,0x74,0x2d,0x69,0x6e,0x20,0x47,0x5a,0x49,0x50,0x20,0x63,0x6f,0x6d, /* uilt-in GZIP com */ \
	0x70,0x72,0x65,0x73,0x73,0x69,0x6f,0x6e,0x20,0x73,0x75,0x70,0x70,0x6f,0x72,0x74, /* pression support */ \
	0x2c,0x20,0x61,0x6c,0x6c,0x20,0x74,0x68,0x65,0x73,0x65,0x20,0x74,0x75,0x74,0x6f, /* , all these tuto */ \
	0x72,0x69,0x61,0x6c,0x73,0x20,0x61,0x6e,0x64,0x20,0x65,0x78,0x61,0x6d,0x70,0x6c, /* rials and exampl */ \
	0x65,0x73,0x20,0x66,0x69,0x74,0x20,0x69,0x6e,0x20,0x74,0x68,0x65,0x0d,0x0a,0x33, /* es fit in the..3 */ \
	0x32,0x6b,0x42,0x20,0x6f,0x6e,0x2d,0x62,0x6f,0x61,0x72,0x64,0x20,0x45,0x45,0x50, /* 2kB on-board EEP */ \
	0x52,0x4f,0x4d,0x21,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x3e,0x54, /* ROM!</p>....<p>T */ \
	0x68,0x65,0x72,0x65,0x20,0x69,0x73,0x20,0x61,0x6c,0x73,0x6f,0x20,0x61,0x6e,0x20, /* here is also an  */ \
	0x49,0x43,0x4d,0x50,0x20,0x63,0x6c,0x69,0x65,0x6e,0x74,0x20,0x65,0x78,0x61,0x6d, /* ICMP client exam */ \
	0x70,0x6c,0x65,0x20,0x72,0x75,0x6e,0x6e,0x69,0x6e,0x67,0x20,0x6f,0x6e,0x0d,0x0a  /* ple running on.. */
#define DATACHUNK00000e \
	0x74,0x68,0x65,0x20,0x64,0x65,0x6d,0x6f,0x20,0x62,0x6f,0x61,0x72,0x64,0x2e,0x20, /* the demo board.  */ \
	0x20,0x50,0x72,0x65,0x73,0x73,0x69,0x6e,0x67,0x20,0x74,0x68,0x65,0x20,0x72,0x69, /*  Pressing the ri */ \
	0x67,0x68,0x74,0x6d,0x6f,0x73,0x74,0x20,0x62,0x75,0x74,0x74,0x6f,0x6e,0x20,0x77, /* ghtmost button w */ \
	0x69,0x6c,0x6c,0x20,0x63,0x61,0x75,0x73,0x65,0x20,0x74,0x68,0x65,0x20,0x62,0x6f, /* ill cause the bo */ \
	0x61,0x72,0x64,0x20,0x74,0x6f,0x0d,0x0a,0x73,0x65,0x6e,0x64,0x20,0x61,0x6e,0x20, /* ard to..send an  */ \
	0x49,0x43,0x4d,0x50,0x20,0x45,0x63,0x68,0x6f,0x20,0x52,0x65,0x71,0x75,0x65,0x73, /* ICMP Echo Reques */ \
	0x74,0x20,0x28,0x61,0x20,0x70,0x69,0x6e,0x67,0x29,0x20,0x74,0x6f,0x20,0x61,0x20, /* t (a ping) to a  */ \
	0x4d,0x69,0x63,0x72,0x6f,0x63,0x68,0x69,0x70,0x20,0x77,0x65,0x62,0x20,0x73,0x65, /* Microchip web se */ \
	0x72,0x76,0x65,0x72,0x2e,0x20,0x20,0x49,0x66,0x20,0x74,0x68,0x65,0x0d,0x0a,0x70, /* rver.  If the..p */ \
	0x69,0x6e,0x67,0x20,0x77,0x61,0x73,0x20,0x72,0x65,0x63,0x65,0x69,0x76,0x65,0x64, /* ing was received */ \
	0x20,0x61,0x6e,0x64,0x20,0x65,0x63,0x68,0x6f,0x65,0x64,0x20,0x73,0x75,0x63,0x63, /*  and echoed succ */ \
	0x65,0x73,0x73,0x66,0x75,0x6c,0x6c,0x79,0x2c,0x20,0x74,0x68,0x65,0x20,0x72,0x65, /* essfully, the re */ \
	0x73,0x70,0x6f,0x6e,0x73,0x65,0x20,0x74,0x69,0x6d,0x65,0x20,0x77,0x69,0x6c,0x6c, /* sponse time will */ \
	0x20,0x62,0x65,0x0d,0x0a,0x64,0x69,0x73,0x70,0x6c,0x61,0x79,0x65,0x64,0x20,0x6f, /*  be..displayed o */ \
	0x6e,0x20,0x74,0x68,0x65,0x20,0x4c,0x43,0x44,0x2e,0x20,0x20,0x41,0x6e,0x20,0x65, /* n the LCD.  An e */ \
	0x72,0x72,0x6f,0x72,0x20,0x6d,0x65,0x73,0x73,0x61,0x67,0x65,0x20,0x77,0x69,0x6c, /* rror message wil */ \
	0x6c,0x20,0x62,0x65,0x20,0x64,0x69,0x73,0x70,0x6c,0x61,0x79,0x65,0x64,0x20,0x77, /* l be displayed w */ \
	0x68,0x65,0x6e,0x20,0x61,0x74,0x74,0x65,0x6d,0x70,0x74,0x69,0x6e,0x67,0x0d,0x0a, /* hen attempting.. */ \
	0x74,0x6f,0x20,0x75,0x73,0x65,0x20,0x74,0x68,0x69,0x73,0x20,0x64,0x65,0x6d,0x6f, /* to use this demo */ \
	0x20,0x69,0x66,0x20,0x74,0x68,0x65,0x20,0x62,0x6f,0x61,0x72,0x64,0x20,0x69,0x73, /*  if the board is */ \
	0x6e,0x27,0x74,0x20,0x61,0x62,0x6c,0x65,0x20,0x74,0x6f,0x20,0x63,0x6f,0x6e,0x6e, /* n't able to conn */ \
	0x65,0x63,0x74,0x20,0x74,0x6f,0x20,0x74,0x68,0x65,0x20,0x49,0x6e,0x74,0x65,0x72, /* ect to the Inter */ \
	0x6e,0x65,0x74,0x2e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x3e,0x46, /* net.</p>....<p>F */ \
	0x6f,0x72,0x20,0x6d,0x6f,0x72,0x65,0x20,0x69,0x6e,0x66,0x6f,0x72,0x6d,0x61,0x74, /* or more informat */ \
	0x69,0x6f,0x6e,0x20,0x6f,0x6e,0x20,0x74,0x68,0x65,0x20,0x4d,0x69,0x63,0x72,0x6f, /* ion on the Micro */ \
	0x63,0x68,0x69,0x70,0x20,0x54,0x43,0x50,0x2f,0x49,0x50,0x20,0x53,0x74,0x61,0x63, /* chip TCP/IP Stac */ \
	0x6b,0x2c,0x20,0x70,0x6c,0x65,0x61,0x73,0x65,0x20,0x72,0x65,0x66,0x65,0x72,0x20, /* k, please refer  */ \
	0x74,0x6f,0x0d,0x0a,0x74,0x68,0x65,0x20,0x54,0x43,0x50,0x2f,0x49,0x50,0x20,0x53, /* to..the TCP/IP S */ \
	0x74,0x61,0x63,0x6b,0x20,0x41,0x50,0x49,0x20,0x69,0x6e,0x73,0x74,0x61,0x6c,0x6c, /* tack API install */ \
	0x65,0x64,0x20,0x77,0x69,0x74,0x68,0x20,0x74,0x68,0x65,0x20,0x73,0x74,0x61,0x63, /* ed with the stac */ \
	0x6b,0x2e,0x20,0x20,0x54,0x68,0x69,0x73,0x20,0x6d,0x61,0x6e,0x75,0x61,0x6c,0x20, /* k.  This manual  */ \
	0x63,0x61,0x6e,0x20,0x62,0x65,0x0d,0x0a,0x6c,0x61,0x75,0x6e,0x63,0x68,0x65,0x64, /* can be..launched */ \
	0x20,0x66,0x72,0x6f,0x6d,0x20,0x79,0x6f,0x75,0x72,0x20,0x57,0x69,0x6e,0x64,0x6f, /*  from your Windo */ \
	0x77,0x73,0x20,0x53,0x74,0x61,0x72,0x74,0x20,0x6d,0x65,0x6e,0x75,0x2e,0x3c,0x2f, /* ws Start menu.</ */ \
	0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a, /* p>....</div>.... */ \
	0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65, /* <script type="te */ \
	0x78,0x74,0x2f,0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x0d, /* xt/javascript">. */ \
	0x0a,0x3c,0x21,0x2d,0x2d,0x0d,0x0a,0x2f,0x2f,0x20,0x50,0x61,0x72,0x73,0x65,0x73, /* .<!--..// Parses */ \
	0x20,0x74,0x68,0x65,0x20,0x78,0x6d,0x6c,0x52,0x65,0x73,0x70,0x6f,0x6e,0x73,0x65, /*  the xmlResponse */ \
	0x20,0x66,0x72,0x6f,0x6d,0x20,0x73,0x74,0x61,0x74,0x75,0x73,0x2e,0x78,0x6d,0x6c, /*  from status.xml */ \
	0x20,0x61,0x6e,0x64,0x20,0x75,0x70,0x64,0x61,0x74,0x65,0x73,0x20,0x74,0x68,0x65, /*  and updates the */ \
	0x20,0x73,0x74,0x61,0x74,0x75,0x73,0x20,0x62,0x6f,0x78,0x0d,0x0a,0x66,0x75,0x6e, /*  status box..fun */ \
	0x63,0x74,0x69,0x6f,0x6e,0x20,0x75,0x70,0x64,0x61,0x74,0x65,0x53,0x74,0x61,0x74, /* ction updateStat */ \
	0x75,0x73,0x28,0x78,0x6d,0x6c,0x44,0x61,0x74,0x61,0x29,0x20,0x7b,0x0d,0x0a,0x09, /* us(xmlData) {... */ \
	0x76,0x61,0x72,0x20,0x6d,0x61,0x69,0x6e,0x73,0x74,0x61,0x74,0x20,0x3d,0x20,0x64, /* var mainstat = d */ \
	0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65, /* ocument.getEleme */ \
	0x6e,0x74,0x42,0x79,0x49,0x64,0x28,0x27,0x64,0x69,0x73,0x70,0x6c,0x61,0x79,0x27, /* ntById('display' */ \
	0x29,0x2e,0x73,0x74,0x79,0x6c,0x65,0x2e,0x64,0x69,0x73,0x70,0x6c,0x61,0x79,0x3b, /* ).style.display; */ \
	0x0d,0x0a,0x09,0x76,0x61,0x72,0x20,0x6c,0x6f,0x61,0x64,0x73,0x74,0x61,0x74,0x20, /* ...var loadstat  */ \
	0x3d,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x67,0x65,0x74,0x45,0x6c, /* = document.getEl */ \
	0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28,0x27,0x6c,0x6f,0x61,0x64,0x69, /* ementById('loadi */ \
	0x6e,0x67,0x27,0x29,0x2e,0x73,0x74,0x79,0x6c,0x65,0x2e,0x64,0x69,0x73,0x70,0x6c, /* ng').style.displ */ \
	0x61,0x79,0x3b,0x0d,0x0a,0x0d,0x0a,0x09,0x2f,0x2f,0x20,0x43,0x68,0x65,0x63,0x6b, /* ay;.....// Check */ \
	0x20,0x69,0x66,0x20,0x61,0x20,0x74,0x69,0x6d,0x65,0x6f,0x75,0x74,0x20,0x6f,0x63, /*  if a timeout oc */ \
	0x63,0x75,0x72,0x72,0x65,0x64,0x0d,0x0a,0x09,0x69,0x66,0x28,0x21,0x78,0x6d,0x6c, /* curred...if(!xml */ \
	0x44,0x61,0x74,0x61,0x29,0x0d,0x0a,0x09,0x7b,0x0d,0x0a,0x09,0x09,0x6d,0x61,0x69, /* Data)...{....mai */ \
	0x6e,0x73,0x74,0x61,0x74,0x20,0x3d,0x20,0x27,0x6e,0x6f,0x6e,0x65,0x27,0x3b,0x0d, /* nstat = 'none';. */ \
	0x0a,0x09,0x09,0x6c,0x6f,0x61,0x64,0x73,0x74,0x61,0x74,0x20,0x3d,0x20,0x27,0x69, /* ...loadstat = 'i */ \
	0x6e,0x6c,0x69,0x6e,0x65,0x27,0x3b,0x0d,0x0a,0x09,0x09,0x72,0x65,0x74,0x75,0x72, /* nline';....retur */ \
	0x6e,0x3b,0x0d,0x0a,0x09,0x7d,0x0d,0x0a,0x0d,0x0a,0x09,0x2f,0x2f,0x20,0x4d,0x61, /* n;...}.....// Ma */ \
	0x6b,0x65,0x20,0x73,0x75,0x72,0x65,0x20,0x77,0x65,0x27,0x72,0x65,0x20,0x64,0x69, /* ke sure we're di */ \
	0x73,0x70,0x6c,0x61,0x79,0x69,0x6e,0x67,0x20,0x74,0x68,0x65,0x20,0x73,0x74,0x61, /* splaying the sta */ \
	0x74,0x75,0x73,0x20,0x64,0x69,0x73,0x70,0x6c,0x61,0x79,0x0d,0x0a,0x09,0x6d,0x61, /* tus display...ma */ \
	0x69,0x6e,0x73,0x74,0x61,0x74,0x20,0x3d,0x20,0x27,0x69,0x6e,0x6c,0x69,0x6e,0x65  /* instat = 'inline */
#define DATACHUNK00000f \
	0x27,0x3b,0x0d,0x0a,0x09,0x6c,0x6f,0x61,0x64,0x73,0x74,0x61,0x74,0x20,0x3d,0x20, /* ';...loadstat =  */ \
	0x27,0x6e,0x6f,0x6e,0x65,0x27,0x3b,0x0d,0x0a,0x0d,0x0a,0x09,0x2f,0x2f,0x20,0x4c, /* 'none';.....// L */ \
	0x6f,0x6f,0x70,0x20,0x6f,0x76,0x65,0x72,0x20,0x61,0x6c,0x6c,0x20,0x74,0x68,0x65, /* oop over all the */ \
	0x20,0x4c,0x45,0x44,0x73,0x0d,0x0a,0x09,0x66,0x6f,0x72,0x28,0x69,0x20,0x3d,0x20, /*  LEDs...for(i =  */ \
	0x30,0x3b,0x20,0x69,0x20,0x3c,0x20,0x38,0x3b,0x20,0x69,0x2b,0x2b,0x29,0x0d,0x0a, /* 0; i < 8; i++).. */ \
	0x09,0x09,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x67,0x65,0x74,0x45,0x6c, /* ..document.getEl */ \
	0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28,0x27,0x6c,0x65,0x64,0x27,0x20, /* ementById('led'  */ \
	0x2b,0x20,0x69,0x29,0x2e,0x73,0x74,0x79,0x6c,0x65,0x2e,0x63,0x6f,0x6c,0x6f,0x72, /* + i).style.color */ \
	0x20,0x3d,0x20,0x28,0x67,0x65,0x74,0x58,0x4d,0x4c,0x56,0x61,0x6c,0x75,0x65,0x28, /*  = (getXMLValue( */ \
	0x78,0x6d,0x6c,0x44,0x61,0x74,0x61,0x2c,0x20,0x27,0x6c,0x65,0x64,0x27,0x20,0x2b, /* xmlData, 'led' + */ \
	0x20,0x69,0x29,0x20,0x3d,0x3d,0x20,0x27,0x31,0x27,0x29,0x20,0x3f,0x20,0x27,0x23, /*  i) == '1') ? '# */ \
	0x30,0x39,0x30,0x27,0x20,0x3a,0x20,0x27,0x23,0x64,0x64,0x64,0x27,0x3b,0x0d,0x0a, /* 090' : '#ddd';.. */ \
	0x0d,0x0a,0x09,0x2f,0x2f,0x20,0x4c,0x6f,0x6f,0x70,0x20,0x6f,0x76,0x65,0x72,0x20, /* ...// Loop over  */ \
	0x61,0x6c,0x6c,0x20,0x74,0x68,0x65,0x20,0x62,0x75,0x74,0x74,0x6f,0x6e,0x73,0x0d, /* all the buttons. */ \
	0x0a,0x09,0x66,0x6f,0x72,0x28,0x69,0x20,0x3d,0x20,0x30,0x3b,0x20,0x69,0x20,0x3c, /* ..for(i = 0; i < */ \
	0x20,0x34,0x3b,0x20,0x69,0x2b,0x2b,0x29,0x0d,0x0a,0x09,0x09,0x64,0x6f,0x63,0x75, /*  4; i++)....docu */ \
	0x6d,0x65,0x6e,0x74,0x2e,0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42, /* ment.getElementB */ \
	0x79,0x49,0x64,0x28,0x27,0x62,0x74,0x6e,0x27,0x20,0x2b,0x20,0x69,0x29,0x2e,0x69, /* yId('btn' + i).i */ \
	0x6e,0x6e,0x65,0x72,0x48,0x54,0x4d,0x4c,0x20,0x3d,0x20,0x28,0x67,0x65,0x74,0x58, /* nnerHTML = (getX */ \
	0x4d,0x4c,0x56,0x61,0x6c,0x75,0x65,0x28,0x78,0x6d,0x6c,0x44,0x61,0x74,0x61,0x2c, /* MLValue(xmlData, */ \
	0x20,0x27,0x62,0x74,0x6e,0x27,0x20,0x2b,0x20,0x69,0x29,0x20,0x3d,0x3d,0x20,0x27, /*  'btn' + i) == ' */ \
	0x75,0x70,0x27,0x29,0x20,0x3f,0x20,0x27,0x26,0x4c,0x61,0x6d,0x62,0x64,0x61,0x3b, /* up') ? '&Lambda; */ \
	0x27,0x20,0x3a,0x20,0x27,0x56,0x27,0x3b,0x0d,0x0a,0x0d,0x0a,0x09,0x2f,0x2f,0x20, /* ' : 'V';.....//  */ \
	0x55,0x70,0x64,0x61,0x74,0x65,0x20,0x74,0x68,0x65,0x20,0x50,0x4f,0x54,0x20,0x76, /* Update the POT v */ \
	0x61,0x6c,0x75,0x65,0x0d,0x0a,0x09,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e, /* alue...document. */ \
	0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28,0x27, /* getElementById(' */ \
	0x70,0x6f,0x74,0x30,0x27,0x29,0x2e,0x69,0x6e,0x6e,0x65,0x72,0x48,0x54,0x4d,0x4c, /* pot0').innerHTML */ \
	0x20,0x3d,0x20,0x67,0x65,0x74,0x58,0x4d,0x4c,0x56,0x61,0x6c,0x75,0x65,0x28,0x78, /*  = getXMLValue(x */ \
	0x6d,0x6c,0x44,0x61,0x74,0x61,0x2c,0x20,0x27,0x70,0x6f,0x74,0x30,0x27,0x29,0x3b, /* mlData, 'pot0'); */ \
	0x0d,0x0a,0x7d,0x0d,0x0a,0x73,0x65,0x74,0x54,0x69,0x6d,0x65,0x6f,0x75,0x74,0x28, /* ..}..setTimeout( */ \
	0x22,0x6e,0x65,0x77,0x41,0x4a,0x41,0x58,0x43,0x6f,0x6d,0x6d,0x61,0x6e,0x64,0x28, /* "newAJAXCommand( */ \
	0x27,0x73,0x74,0x61,0x74,0x75,0x73,0x2e,0x78,0x6d,0x6c,0x27,0x2c,0x20,0x75,0x70, /* 'status.xml', up */ \
	0x64,0x61,0x74,0x65,0x53,0x74,0x61,0x74,0x75,0x73,0x2c,0x20,0x74,0x72,0x75,0x65, /* dateStatus, true */ \
	0x29,0x22,0x2c,0x35,0x30,0x30,0x29,0x3b,0x0d,0x0a,0x2f,0x2f,0x2d,0x2d,0x3e,0x0d, /* )",500);..//-->. */ \
	0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70,0x74,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x73, /* .</script>....<s */ \
	0x63,0x72,0x69,0x70,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74, /* cript type="text */ \
	0x2f,0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x0d,0x0a,0x3c, /* /javascript">..< */ \
	0x21,0x2d,0x2d,0x0d,0x0a,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x67,0x65, /* !--..document.ge */ \
	0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28,0x27,0x68,0x65, /* tElementById('he */ \
	0x6c,0x6c,0x6f,0x27,0x29,0x2e,0x69,0x6e,0x6e,0x65,0x72,0x48,0x54,0x4d,0x4c,0x20, /* llo').innerHTML  */ \
	0x3d,0x20,0x22,0x7e,0x68,0x65,0x6c,0x6c,0x6f,0x6d,0x73,0x67,0x7e,0x22,0x3b,0x0d, /* = "~hellomsg~";. */ \
	0x0a,0x2f,0x2f,0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70,0x74, /* .//-->..</script */ \
	0x3e,0x0d,0x0a,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72, /* >....~inc:footer */ \
	0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0xd2, /* .inc~......3.... */ \
	0x04,0x00,0x00,0x16,0x00,0x00,0x00,0x19,0x05,0x00,0x00,0x05,0x00,0x00,0x00,0x0a, /* ................ */ \
	0x11,0x00,0x00,0x01,0x00,0x00,0x00,0x2c,0x11,0x00,0x00,0x02,0x00,0x00,0x00,0x53, /* .......,.......S */ \
	0x75,0x63,0x63,0x65,0x73,0x73,0x21,0x20,0x7e,0x6c,0x65,0x64,0x28,0x30,0x29,0x7e, /* uccess! ~led(0)~ */ \
	0x09,0x00,0x00,0x00,0x17,0x00,0x00,0x00,0x1f,0x8b,0x08,0x00,0x00,0x00,0x00,0x00, /* ................ */ \
	0x00,0x00,0xad,0x56,0x4d,0x8f,0x9b,0x30,0x10,0x3d,0x6f,0xa4,0xfc,0x07,0xa4,0xbd, /* ...VM..0.=o..... */ \
	0x2e,0x08,0x92,0x90,0xdd,0x65,0x4f,0x55,0xef,0x3d,0xf6,0x6e,0xf0,0x10,0xac,0x75, /* .....eOU.=.n...u */ \
	0x30,0xb2,0xcd,0x26,0xdb,0x55,0xff,0x7b,0xfd,0x05,0x18,0x70,0x52,0x55,0xaa,0x90, /* 0..&.U.{...pRU.. */ \
	0xda,0xc5,0xcc,0xbc,0x37,0x9e,0x79,0x33,0x93,0x92,0xe1,0xcf,0xe8,0x6b,0xbb,0x79, /* ....7.y3.....k.y */ \
	0xa8,0x59,0x2b,0xe3,0x1a,0x9d,0x09,0xfd,0x2c,0xa2,0x9f,0xc0,0x31,0x6a,0xd1,0x53, /* .Y+.....,...1j.S */ \
	0xf4,0x8d,0x13,0x44,0x9f,0x22,0x81,0x5a,0x11,0x0b,0xe0,0xa4,0x7e,0x53,0xa6,0x25, /* ...D.".Z....~S.% */ \
	0xaa,0xde,0x4f,0x9c,0xf5,0x2d,0x2e,0xa2,0xc7,0xbc,0xd4,0x8f,0x3e,0x3e,0x23,0x7e, /* ..O..-......>>#~ */ \
	0x22,0x6d,0x11,0xa5,0xdd,0x35,0x42,0xbd,0x64,0xfa,0xac,0x43,0x18,0x93,0xf6,0xa4, /* "m...5B.d..C.... */ \
	0x0e,0xd5,0xb3,0xd3,0x5f,0x52,0x75,0xfc,0x7b,0xbb,0xd9,0x6e,0x1e,0x45,0x83,0x30, /* ...._Ru.{..n.E.0 */ \
	0xbb,0xc4,0xac,0x05,0x13,0xc0,0x85,0x60,0xd9,0x14,0xd1,0xf3,0x51,0x59,0x19,0x16, /* .......`....QY.. */ \
	0xc6,0x31,0xf0,0x22,0xca,0x94,0x93,0x60,0x94,0x60,0xc5,0x95,0xe7,0xd3,0x97,0x58, /* .1."...`.`.....X */ \
	0xb2,0xae,0x30,0x70,0x21,0xe6,0xdf,0x13,0x81,0xbc,0x30,0x43,0x10,0x00,0x3c,0x94, /* ..0p!.....0C..<. */ \
	0xfa,0x09,0x61,0xfa,0xfe,0x0d,0x07,0xb8,0x89,0x70,0x38,0xfc,0xc5,0xbd,0x66,0x3d, /* ..a......p8...f= */ \
	0xbf,0xe5,0xbd,0x47,0xfa,0xb9,0x01,0xa0,0x20,0x3a,0x74,0xba,0xc9,0xbc,0xdf,0xef, /* ...G.... :t..... */ \
	0x57,0xc5,0xa8,0xeb,0x3a,0x98,0xa0,0xb1,0x0c,0x3b,0x97,0x5c,0x53,0x6d,0x41,0x7e, /* W...:....;.\SmA~ */ \
	0x81,0x82,0x4c,0x3b,0x39,0x27,0x94,0x78,0x52,0x44,0xc0,0x46,0x12,0x49,0x5d,0x54  /* ..L;9'.xRD.F.I]T */
#define DATACHUNK000010 \
	0x3e,0x77,0x95,0xce,0xa9,0x0e,0x1e,0xd3,0x05,0xc8,0xa9,0x91,0x45,0x54,0x32,0x8a, /* >w..........ET2. */ \
	0xf5,0x61,0xc5,0x28,0xe3,0x53,0xbc,0xb6,0x7e,0x71,0xc9,0xa4,0x64,0x67,0xc5,0x96, /* .a.(.S..~q..dg.. */ \
	0x5b,0xd7,0xc6,0x79,0x65,0x47,0xf3,0xee,0xb3,0x27,0x5c,0x7f,0xb2,0x61,0x52,0x86, /* [..yeG...'\..aR. */ \
	0x94,0x91,0x39,0x78,0x9b,0x74,0xb4,0x4f,0xdd,0x55,0x25,0x5c,0x65,0x8c,0x28,0x39, /* ..9x.t.O.U%\e.(9 */ \
	0xb5,0x93,0x91,0x85,0x3a,0x43,0xdb,0xfb,0x10,0x14,0x6a,0x1f,0x21,0xcb,0x1d,0x82, /* ....:C....j.!... */ \
	0xbb,0x52,0xcc,0x6d,0x38,0x2e,0x87,0x1e,0x06,0xf2,0x05,0x9c,0x1d,0x9c,0x1b,0x26, /* .R.m8..........& */ \
	0xa2,0xa3,0x48,0x75,0x53,0x49,0x59,0xf5,0xbe,0xaa,0x95,0xcb,0x97,0x4b,0xc5,0xa5, /* ..HuSIY......K.. */ \
	0x21,0x12,0x66,0xf9,0x7b,0xb9,0x93,0x3f,0x57,0xe0,0x31,0x61,0x93,0x2a,0x5c,0x46, /* !.f.{..?W.1a..\F */ \
	0xcd,0xa5,0x31,0x54,0x8c,0x23,0x49,0x98,0xba,0x79,0xab,0xda,0x6c,0x11,0x74,0xd1, /* ..1T.#I..y..l.t. */ \
	0xb0,0x0f,0xe0,0xeb,0x42,0x62,0x23,0x2c,0x6b,0x59,0x29,0x76,0x68,0xa5,0x7f,0xbf, /* ....Bb#,kY)vh... */ \
	0x7c,0xe7,0xca,0xb3,0x4c,0xfc,0x22,0x4d,0x99,0x9f,0xa6,0x01,0xc7,0x66,0x6a,0x28, /* |...L."M.....fj( */ \
	0xbf,0x4b,0xc1,0xfd,0x60,0x47,0x57,0x2f,0xde,0x01,0xc0,0x86,0xba,0x06,0x50,0x17, /* .K..`GW/......P. */ \
	0x01,0x4e,0x49,0x00,0xa5,0xc9,0x0c,0x80,0x53,0x9c,0xed,0x90,0x29,0xce,0x44,0x74, /* .NI.....S...).Dt */ \
	0xa8,0x1a,0x38,0x28,0x20,0xae,0x53,0x2e,0x9b,0x11,0xa5,0x66,0x4c,0xba,0xcf,0x5e, /* ..8( .S....fL..^ */ \
	0x77,0xa4,0xc9,0x0b,0x9c,0x7d,0x59,0x1f,0x8f,0xc7,0xa5,0xf2,0x2a,0x45,0x0e,0xdc, /* w....}Y......E.. */ \
	0x1f,0x56,0x3a,0x3f,0x51,0x6e,0x46,0x62,0xb4,0x54,0x9a,0x89,0x2b,0x9b,0x0d,0x42, /* .V:?QnFb.T..+..B */ \
	0x77,0xa6,0xcc,0xb1,0xaa,0x3a,0xe0,0x81,0xc5,0xcd,0x52,0x89,0x64,0x2f,0x66,0x32, /* w....:....R.d/f2 */ \
	0x7c,0xbe,0x5f,0xa6,0x09,0xdf,0x0f,0x68,0x39,0x78,0xe7,0x5c,0x41,0x31,0xce,0x02, /* |._....h9x.\A1.. */ \
	0xe8,0x4c,0x08,0x23,0x45,0x6e,0x6f,0xa7,0xfe,0xcd,0xfc,0x6e,0x24,0xaa,0x3c,0xad, /* .L.#Eno....n$.<. */ \
	0x42,0x88,0x97,0x21,0xa4,0x4b,0xbc,0x84,0x02,0x16,0xab,0x69,0x74,0xf0,0xa6,0xd1, /* B..!.K.....it... */ \
	0xcc,0x70,0x2e,0x2f,0x8c,0xed,0xb0,0xe9,0xb9,0xd0,0xef,0x1d,0x23,0xae,0x06,0x21, /* .p./........#..! */ \
	0xcf,0x90,0xba,0xac,0xff,0x5d,0x79,0x26,0x70,0x45,0xe7,0x8e,0x42,0xc9,0xae,0x9e, /* .....]y&pE..B... */ \
	0xb0,0x0a,0x53,0x5c,0x3d,0x08,0xa2,0xf1,0xaf,0x50,0x73,0x87,0x52,0xbd,0xf7,0x34, /* ..S\=....Ps.R..4 */ \
	0x6d,0xc5,0x33,0x69,0xc7,0xeb,0x53,0x17,0x9d,0x0d,0xa2,0x62,0x18,0xd6,0x5b,0xfc, /* m.3i..S....b..[. */ \
	0xbb,0xda,0x3c,0x44,0xdd,0xe9,0x07,0x5c,0x9e,0x86,0x97,0xa7,0xa8,0x26,0x57,0xc0, /* ..<D...\.....&W. */ \
	0xb1,0x51,0x89,0x7b,0xf1,0xee,0x02,0xbc,0x22,0x22,0x30,0xdc,0x6b,0x78,0x7d,0x5b, /* .Q.{....""0.kx}[ */ \
	0x14,0xd6,0x1b,0xdc,0x7a,0x70,0xae,0xf4,0x6a,0x0f,0x77,0xd3,0x68,0x82,0x72,0x3f, /* ....zp..j.w.h.r? */ \
	0x31,0x71,0xce,0xb8,0xdf,0x89,0x73,0x88,0x95,0x46,0xe7,0xc1,0x60,0x7c,0x8f,0xe7, /* 1q....s..F..`|.. */ \
	0x35,0x9d,0x64,0x34,0xb6,0xfd,0xd1,0x5b,0xa3,0x5e,0x2b,0x21,0xd1,0x78,0x39,0x1f, /* 5.d4...[.^+!.x9. */ \
	0x3b,0x21,0x5f,0x84,0x91,0x2e,0x16,0x92,0x37,0x31,0xbc,0xfa,0xbb,0xbd,0xe9,0x55, /* ;!_.....71.....U */ \
	0x6e,0xd8,0x28,0xcb,0xd1,0x98,0x4f,0x00,0x35,0x01,0x8a,0x05,0xc8,0xff,0xab,0x9e, /* n.(...O.5....... */ \
	0x1b,0x42,0x19,0xc9,0x30,0xf9,0x98,0x77,0xaa,0xce,0x9f,0xe6,0xd2,0xff,0x0f,0x8b, /* .B..0..w........ */ \
	0x6f,0xed,0x42,0x51,0x09,0x74,0x5d,0xb6,0x38,0x3b,0x84,0x06,0xd8,0xce,0x9e,0x0d, /* o.BQ.t].8;...... */ \
	0x03,0x69,0x9f,0xdf,0xd9,0x68,0x1d,0x13,0xc4,0x76,0x17,0x2a,0x55,0x1d,0x7b,0x09, /* .i...h...v..U.{. */ \
	0xab,0x00,0x48,0xdb,0xf5,0xb3,0x4d,0xb4,0x0b,0xc6,0x69,0xcc,0x12,0x71,0xf6,0x2d, /* ..H...M...i..q.- */ \
	0xa7,0x1f,0x85,0x9e,0xa1,0xae,0x13,0xe2,0x80,0x6e,0x42,0x26,0x1c,0x44,0x4f,0xe5, /* .........nB&.DO. */ \
	0x76,0xf3,0xb5,0x5d,0x8c,0xed,0x7f,0xab,0xcd,0xfc,0x07,0x5b,0x78,0x2b,0x84,0xd7, /* v..].......[x+.. */ \
	0xbc,0xaf,0x7a,0x80,0x31,0x25,0x0f,0x09,0x7b,0x37,0x51,0x0f,0x82,0x1e,0x17,0x4f, /* ..z.1%..{7Q....O */ \
	0x69,0xc6,0xf4,0xc2,0xb1,0x36,0x3f,0x2c,0x94,0xe7,0x83,0x76,0xad,0x11,0xa1,0x41, /* i....6?,...v...A */ \
	0xe7,0xf2,0x18,0x70,0xae,0x61,0xe6,0xdc,0xb7,0x61,0xe2,0xaa,0x0a,0xf9,0xd6,0xd8, /* ...p.a...a...... */ \
	0xf9,0xfe,0x01,0x31,0x7c,0xd6,0xd0,0x66,0x0c,0x00,0x00,0x1f,0x8b,0x08,0x00,0x00, /* ...1|..f........ */ \
	0x00,0x00,0x00,0x00,0x00,0xad,0x8f,0xf9,0x4f,0x93,0x07,0x00,0x40,0xbf,0x1e,0x94, /* ........O...@... */ \
	0x72,0x14,0x5a,0xb4,0xd0,0x72,0xd9,0x53,0x59,0x45,0x43,0x98,0x28,0xe0,0xd5,0xd2, /* r.Z..r.SYEC.(... */ \
	0xd2,0x43,0x18,0xf9,0xc8,0x40,0x04,0x06,0x16,0x42,0x8b,0x32,0xc0,0x82,0x58,0x04, /* .C...@...B.2..X. */ \
	0xa7,0x2d,0x50,0x11,0xb9,0x2a,0x47,0x05,0x0a,0x52,0x50,0xca,0x74,0x14,0x8b,0x12, /* .-P...G..RP.t... */ \
	0x04,0x65,0x0a,0xca,0xa1,0x96,0xab,0xae,0x20,0x90,0x62,0x00,0x15,0x5c,0x16,0xae, /* .e...... .b..\.. */ \
	0xb9,0x45,0xdd,0x70,0xfd,0x16,0xb3,0x7f,0x61,0xef,0x87,0x97,0xbc,0x1f,0x1f,0x4f, /* .E.p....a......O */ \
	0xc0,0xf5,0x0f,0x48,0xa8,0x05,0x18,0xc0,0x14,0x0d,0x90,0xc9,0x64,0x7d,0x7d,0x7d, /* ...H........d}}} */ \
	0x16,0xac,0x1b,0xb4,0xbe,0x01,0x4d,0xbc,0x58,0x5f,0x5f,0x97,0x48,0x24,0x13,0x13, /* ......M.X__.H$.. */ \
	0x13,0xd0,0xfc,0x22,0x16,0x8b,0xb5,0x90,0x18,0x16,0x9f,0x40,0x8d,0x46,0x03,0x82, /* ...".......@.F.. */ \
	0xa0,0x85,0x29,0x10,0x0a,0x85,0x24,0x12,0x49,0xa9,0x54,0xce,0xcf,0xcf,0x43,0xf2, /* ..)...$.I.T...C. */ \
	0x42,0xbd,0x5e,0xef,0xe3,0xe3,0x63,0x91,0x5d,0x84,0x34,0x2d,0x50,0xdf,0x13,0x0b, /* B.^...c.].4-P... */ \
	0x78,0xcc,0x22,0x91,0x5a,0x84,0xc9,0x90,0xb2,0x1a,0x52,0xaa,0x20,0x7d,0xa7,0x45, /* x.".Z.....R. }.E */ \
	0x92,0xcd,0x64,0x32,0x2d,0x80,0x3d,0x04,0x41,0x00,0x00,0xfc,0xe7,0xff,0x17,0xf2, /* ..d2-.=.A....... */ \
	0x5f,0x48,0x18,0x00,0xd0,0x00,0xef,0x2f,0xf1,0xe5,0x09,0x40,0x41,0xcc,0x4a,0x09, /* _H...../...@A.J. */ \
	0xdf,0xdb,0x55,0xf9,0xac,0x25,0xf3,0x79,0x6a,0xa0,0xc6,0x78,0x33,0xeb,0x48,0x7b, /* ..U..%.yj..x3.H{ */ \
	0x8c,0x7e,0x46,0x27,0x1d,0x59,0xcd,0xbd,0x84,0x2c,0x61,0x63,0x19,0x35,0x56,0x0e, /* .~F'.Y...,ac.5V. */ \
	0x0e,0xaf,0x47,0xd2,0x7b,0xcb,0x10,0x25,0x4f,0x42,0xf5,0x97,0xdc,0x91,0x64,0x20, /* ..G.{..%OB....d  */ \
	0xf1,0xec,0x26,0x14,0xe1,0x9c,0x24,0x55,0x88,0x6c,0x11,0x34,0x94,0x0d,0x46,0x5e, /* ..&...$U.l.4..F^ */ \
	0x56,0x2e,0x40,0xdb,0x5d,0xac,0x12,0x39,0xd3,0x30,0x78,0x92,0xb2,0xbe,0x1e,0x59, /* V.@.]..9.0x....Y */ \
	0x50,0x5d,0x95,0x03,0xb3,0x6a,0xd0,0xca,0x1a,0x9b,0x9a,0xec,0x5a,0x75,0xa7,0x6e, /* P]...j......Zu.n */ \
	0xde,0x6a,0x72,0xff,0xc6,0x8a,0x44,0x25,0x59,0xf3,0xac,0x30,0xf7,0x5a,0xda,0x75, /* .jr...D%Y..0.Z.u */ \
	0x88,0xd3,0x52,0x17,0x8a,0x5b,0x95,0x1d,0x5a,0x0f,0xff,0x3e,0x04,0x47,0x1d,0x57, /* ..R..[..Z..>.G.W */ \
	0x73,0x1d,0xc7,0xa9,0xe7,0x1f,0xb5,0x6e,0x53,0x6c,0xa1,0x98,0x2b,0xa5,0x06,0x33  /* s......nSl..+..3 */
#define DATACHUNK000011 \
	0x41,0xec,0x10,0x8a,0x32,0x51,0x9d,0x82,0xad,0x96,0x8d,0x2f,0xeb,0xd1,0x0a,0x3b, /* A...2Q...../...; */ \
	0xb3,0x19,0xa9,0x18,0x78,0x4f,0x14,0x7b,0x86,0x74,0x99,0xa6,0xd8,0x63,0xa6,0x99, /* ....xO.{.t...c.. */ \
	0xae,0xd3,0x11,0xba,0xf1,0x7d,0x39,0x94,0xed,0x93,0xcf,0xe5,0xe0,0xa0,0x9c,0x05, /* .....}9......... */ \
	0xc7,0xd2,0x17,0xdf,0x79,0xb3,0x70,0xe8,0x65,0x2e,0x3a,0x00,0xb8,0xfe,0xa6,0xaf, /* ....y.p.e.:..... */ \
	0x9c,0xc4,0x3a,0x44,0xc2,0xdf,0x4d,0x42,0xa0,0xd8,0xb6,0x04,0xaf,0xd9,0x3b,0x2c, /* ..:D..MB......;, */ \
	0x79,0xf5,0xce,0xe8,0xfc,0x22,0x66,0x3e,0x15,0x2d,0x0b,0x22,0x64,0x71,0x88,0x5b, /* y...."f>.-."dq.[ */ \
	0xb4,0xa3,0x50,0xb9,0xa3,0xd7,0x15,0x02,0xa8,0x6f,0x1e,0x10,0x92,0x29,0xae,0x0f, /* ..P......o...).. */ \
	0x85,0xe2,0x82,0xca,0x52,0x2a,0x68,0x6b,0x03,0x9c,0xf9,0x6d,0x0f,0xb9,0xb7,0x29, /* ....R.hk...m...) */ \
	0x8c,0x7d,0x6b,0xca,0xdd,0x00,0xc7,0x3f,0x08,0x3c,0x17,0x0d,0xdc,0x98,0x81,0x47, /* .}k....?.<.....G */ \
	0xa4,0xe1,0x61,0x0b,0xf6,0x80,0xcd,0x85,0xf4,0xa1,0xc0,0x1b,0xfd,0x93,0x4d,0xe1, /* ..a...........M. */ \
	0x12,0x71,0xe0,0x1c,0x7e,0xb1,0xdf,0xbe,0x90,0x06,0xce,0x0a,0x46,0x8a,0x76,0xb6, /* .q..~.......F.v. */ \
	0x73,0x6d,0x32,0x79,0x83,0xaa,0xb6,0xcb,0xac,0x44,0x6e,0xf9,0x12,0x8a,0xbf,0xf3, /* sm2y.....Dn..... */ \
	0x0a,0x32,0x76,0xe8,0x94,0xb9,0x92,0x6f,0x0f,0xd3,0x78,0xa4,0x65,0xdb,0x31,0xfc, /* .2v....o..x.e.1. */ \
	0x8a,0x85,0xc6,0x66,0xaa,0x75,0x2b,0xbd,0xb6,0x30,0xec,0xda,0xd7,0x9d,0xd4,0x78, /* ...f.u+..0.....x */ \
	0xd7,0xed,0x2c,0xf2,0xef,0x89,0xb1,0xe4,0xc8,0xd8,0xa3,0x18,0xdf,0x95,0xa9,0xc7, /* ..,............. */ \
	0x89,0x3b,0x0e,0xc7,0xb6,0x11,0xd7,0x96,0x93,0xef,0xff,0x48,0x6e,0x67,0x2f,0xac, /* .;.........Hng/. */ \
	0x0d,0xf8,0xda,0xaf,0x33,0x74,0x59,0x83,0x3e,0xcc,0x14,0xda,0xed,0xe3,0x2e,0x81, /* ....3tY.>....... */ \
	0x9b,0x99,0xf0,0x2c,0xfe,0x6d,0x27,0xd6,0x8a,0x77,0x67,0x0c,0x65,0x7a,0xac,0xe0, /* ...,.m'..wg.ez.. */ \
	0x57,0x91,0xc2,0x37,0x63,0x74,0x78,0xc8,0x91,0x7c,0xf8,0xfa,0xb8,0xe2,0x51,0xf6, /* W..7ctx..|....Q. */ \
	0x87,0xdc,0x8d,0xde,0xee,0xd8,0xa2,0x03,0xc1,0x93,0x47,0x1b,0xa3,0x9d,0x1f,0xa3, /* ..........G..... */ \
	0xae,0x8a,0x5f,0x61,0xac,0x8f,0xe5,0x04,0x7f,0x27,0x9a,0x3b,0xeb,0x90,0x52,0xa8, /* .._a.....'.;..R. */ \
	0x48,0x88,0xbb,0x8f,0xdf,0x56,0xc0,0x09,0x65,0xf3,0x0e,0x68,0x55,0xcd,0xd0,0x74, /* H....V..e..hU..t */ \
	0xdc,0x27,0x8f,0x4c,0x97,0x83,0x22,0xdd,0xfb,0x46,0xee,0x92,0x3f,0x62,0x0e,0xb1, /* .'.L.."..F..?b.. */ \
	0x7c,0x5f,0xb5,0x90,0xb3,0x58,0xe6,0x37,0x9b,0x04,0x44,0x1a,0xaf,0xe3,0x70,0x89, /* |_...X.7..D...p. */ \
	0x7b,0x9b,0xd3,0xf6,0x19,0xba,0x2b,0x0a,0x93,0x49,0x1d,0x63,0x59,0xd6,0x7e,0x93, /* {.....+..I.cY.~. */ \
	0x09,0x68,0xd7,0x15,0x6d,0x1e,0xf1,0x2e,0x36,0x83,0x88,0xa4,0x19,0x93,0xcb,0xc1, /* .h..m...6....... */ \
	0xcf,0x27,0xde,0x27,0x8a,0x30,0x86,0xa1,0xd7,0x05,0xc4,0xab,0x4f,0x45,0xe7,0x0e, /* .'.'.0......OE.. */ \
	0xc4,0x7b,0xd5,0x10,0x3f,0x48,0x10,0xaf,0xe2,0x3d,0x6a,0x5f,0x34,0x84,0xf7,0x23, /* .{..?H...=j_4..# */ \
	0x05,0x1c,0x55,0x10,0xf8,0xa7,0x1a,0xfb,0x55,0x4c,0xce,0x94,0xe8,0x98,0x74,0x76, /* ..U.....UL....tv */ \
	0x2a,0x7b,0x9f,0xd3,0xa2,0x9a,0x7b,0xdc,0xb9,0xe2,0x28,0x9c,0x5e,0x27,0x6a,0x16, /* .{....{...(.^'j. */ \
	0x5f,0x8e,0x04,0x87,0x51,0x98,0x0a,0x42,0xbe,0xf5,0x3f,0xaa,0x9e,0x28,0x7f,0xd1, /* _...Q..B..?..(.. */ \
	0x67,0x3f,0x64,0x03,0x8d,0xb3,0xb7,0x2c,0xb6,0xb7,0x4c,0xf8,0xa2,0x04,0xdc,0xed, /* g?d....,..L..... */ \
	0xf5,0xf2,0x2a,0x03,0x55,0x4b,0x2d,0xd9,0xff,0xe4,0x26,0x2f,0xa3,0xc8,0x10,0x9c, /* ....UK-...&/.... */ \
	0x07,0xa7,0xec,0xe5,0xbc,0x05,0xa8,0x6a,0x98,0x3a,0xbc,0x51,0x40,0x1b,0x4c,0x99, /* .......j.:.Q@.L. */ \
	0xa9,0x00,0x01,0xfd,0xb8,0x3c,0xbb,0x8e,0xdb,0x79,0x52,0x6d,0x13,0x72,0x3e,0xd5, /* .....<...yRm.r>. */ \
	0xb6,0xff,0x2e,0x90,0xa4,0x15,0x14,0x53,0xdd,0xcd,0xb8,0x8e,0x1a,0x24,0xcd,0x04, /* .......S.....$.. */ \
	0x5b,0x0b,0x78,0xce,0x10,0x1b,0x7c,0x7b,0x57,0x42,0x88,0xba,0x93,0x2d,0x44,0xc1, /* [.x...|{WB...-D. */ \
	0x11,0x97,0x96,0xd3,0x70,0xaf,0x2b,0x90,0xb6,0x9c,0x06,0x3c,0xe5,0x87,0x99,0x9a, /* ....p.+....<.... */ \
	0xce,0x44,0xa6,0x64,0xd2,0x4b,0x9a,0x23,0x53,0xe2,0xa6,0x55,0xdb,0xff,0x4e,0xa1, /* .D.d.K.#S..U..N. */ \
	0x37,0xfc,0x74,0xcd,0xd3,0xb0,0xfa,0x30,0xd8,0x98,0x1b,0xa5,0xfe,0x7c,0x87,0x58, /* 7.t....0.....|.X */ \
	0x8a,0x38,0x17,0x27,0xc9,0xd3,0xd4,0xb7,0x6e,0x75,0x46,0xf6,0x2c,0xb8,0x99,0x53, /* .8.'....nuF.,..S */ \
	0x97,0x23,0xcf,0x36,0x70,0x39,0x3d,0x1f,0xdb,0xda,0xc2,0xe1,0x6d,0xf8,0x7b,0xb6, /* .#.6p9=.....m.{. */ \
	0x0e,0x19,0x75,0xfd,0xdd,0xf4,0x3b,0xd3,0x15,0x85,0xa5,0x9f,0x04,0x75,0x5c,0x5c, /* ..u...;......u\\ */ \
	0x82,0x69,0x57,0xc8,0xe8,0x0f,0xfd,0xa3,0x41,0x5b,0x37,0xe4,0xcf,0x4c,0x7b,0x98, /* .iW.....A[7..L{. */ \
	0x95,0x3c,0xdf,0xec,0x88,0x31,0x58,0xb4,0x28,0x22,0x0f,0x74,0xc3,0xa7,0x85,0xc1, /* .<...1X.(".t.... */ \
	0xcf,0xcf,0x28,0xbe,0x6d,0xdd,0x4f,0x77,0xf2,0xe3,0x1f,0x99,0x5b,0xd2,0xb4,0x73, /* ..(.m.Ow....[..s */ \
	0xe3,0x0e,0xc6,0xb0,0x11,0x67,0x56,0x15,0xe1,0x21,0x4e,0x94,0xf4,0x20,0x29,0xe7, /* .....gV..!N.. ). */ \
	0x69,0xd7,0xf4,0x89,0xa8,0x5d,0x8e,0xda,0x8d,0x67,0x6f,0x4e,0x78,0x10,0x1a,0xae, /* i....]...goNx... */ \
	0x7d,0x98,0xe3,0xa5,0xfe,0x31,0x47,0xcb,0xed,0x12,0xf0,0x75,0x14,0xe3,0x6a,0x37, /* }....1G....u..j7 */ \
	0xce,0xbc,0xc0,0xbb,0x8c,0x8a,0x32,0x87,0xa7,0xcf,0xcb,0x76,0xec,0x46,0x8e,0x74, /* ......2....v.F.t */ \
	0x28,0xf2,0x7b,0x5e,0x17,0xf7,0xfd,0xe2,0x4f,0x86,0x03,0xe8,0x80,0xb7,0x15,0xa1, /* (.{^....O....... */ \
	0xe9,0x97,0x10,0x0f,0xe2,0x2f,0x04,0x58,0x6b,0xf6,0xec,0x66,0x56,0x35,0xd6,0x1c, /* ...../.Xk..fV5.. */ \
	0xaa,0x76,0xef,0xf0,0x12,0xb2,0xde,0xb5,0xd6,0x7b,0x0e,0x13,0x50,0x01,0xc2,0xbc, /* .v.......{..P... */ \
	0xa5,0xf6,0xe9,0x74,0xfb,0xcd,0xd5,0x9e,0x77,0xb7,0x37,0xd7,0x7e,0xfe,0xe8,0x19, /* ...t....w.7.~... */ \
	0x8c,0x05,0xf6,0xff,0x0b,0xa6,0x2b,0xee,0xb4,0xef,0x04,0x00,0x00,0x1f,0x8b,0x08, /* ......+......... */ \
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xd5,0x57,0x5d,0x6f,0xdb,0x36,0x14,0x7d,0x56, /* ........W]o.6.}V */ \
	0x80,0xfc,0x87,0x3b,0x3f,0x2c,0x32,0xe0,0x38,0x4e,0xb1,0xee,0xa1,0x81,0x3b,0xa4, /* ...;?,2.8N....;. */ \
	0x49,0xb1,0x66,0x48,0x97,0x20,0x71,0x87,0x02,0xdb,0x1e,0x68,0x89,0x8e,0xd9,0xc8, /* I.fH. q....h.... */ \
	0xa2,0x4a,0x52,0x76,0x8d,0x22,0x3f,0x68,0xff,0x72,0xe7,0x92,0x94,0x2c,0xbb,0x69, /* .JRv."?h.r...,.i */ \
	0x51,0xac,0x7d,0x59,0x02,0x58,0x1f,0xbc,0xf7,0xf0,0xf2,0xdc,0x4f,0x1d,0x1d,0xd1, /* Q.}Y.X......O... */ \
	0x99,0xae,0xd6,0x46,0xdd,0xcd,0x1d,0xfd,0x43,0x4f,0x46,0xa3,0x27,0x87,0x4f,0x46, /* ...F....COF.'.OF */ \
	0xc7,0x23,0x7a,0xad,0x32,0xa3,0xb3,0xb9,0xaa,0x68,0x22,0xb3,0x79,0xa9,0x0b,0x7d, /* .#z.2....h".y..} */ \
	0xb7,0xa6,0x8b,0x32,0x1b,0x12,0x9d,0x16,0x05,0x79,0x05,0x4b,0x46,0x5a,0x69,0x96, /* ...2.....y.KFZi. */ \
	0x32,0x1f,0xee,0xef,0x1d,0x1d,0xd1,0xad,0x94,0x5d,0xbd,0xb3,0xeb,0xa3,0x8b,0x6b  /* 2........].....k */
#define DATACHUNK000012 \
	0xba,0x75,0x22,0xbb,0xa7,0x5c,0x67,0xf5,0x42,0x96,0x4e,0x38,0xa5,0x4b,0x9a,0x69, /* .u"..\g.B.N8.K.i */ \
	0x43,0x85,0xca,0x64,0x69,0x25,0xa9,0x12,0x4f,0x0b,0xff,0x1e,0x28,0xfc,0x0f,0xa4, /* C..di%..O...(... */ \
	0x73,0xe9,0xa4,0x59,0xa8,0x52,0x5a,0x5a,0xcd,0x65,0x49,0x02,0x3b,0xbd,0xaf,0xa5, /* s..Y.RZZ.eI.;... */ \
	0x75,0xa4,0x2c,0x65,0xba,0xb4,0x2a,0x97,0x46,0xe6,0xd4,0x73,0x6a,0x81,0x8b,0xae, /* u.,e....F..sj... */ \
	0x5d,0x6f,0x7f,0x6f,0x29,0x0c,0xf1,0xf3,0x55,0xed,0x5e,0xdf,0xd2,0x98,0x9e,0x8e, /* ]o.o)...U.^..... */ \
	0x46,0xa3,0x13,0x3a,0x3a,0x5a,0xd8,0xfd,0x3d,0x0a,0x06,0x3a,0x0d,0x8b,0x81,0x06, /* F..::Z..=..:.... */ \
	0xac,0x5a,0x92,0x9e,0xd1,0xe9,0x6f,0xa7,0x6f,0x49,0x2e,0x61,0x99,0x25,0xa7,0xa9, /* .Z....o.oI.a.%.. */ \
	0x82,0xed,0xd2,0xda,0x80,0x25,0xde,0x89,0x0f,0x97,0x0a,0x7b,0x8e,0xa9,0x94,0x2b, /* .....%.....{...+ */ \
	0x3a,0x35,0x46,0xac,0xd3,0xfe,0x49,0x34,0xf1,0xa2,0x54,0x4e,0x09,0xe7,0xe1,0xfc, /* :5F...I4..TN.... */ \
	0x32,0x23,0x65,0x7a,0xb1,0x10,0x65,0xce,0x02,0x49,0x6d,0x8a,0x67,0xe4,0xe6,0x92, /* 2#ez..e..Im.g... */ \
	0x70,0xc3,0xd8,0x22,0x0b,0xd0,0x58,0xc2,0x09,0x9c,0xc0,0xe9,0x4c,0x10,0x68,0xc8, /* p.."..X.....L.h. */ \
	0xa1,0x8b,0x73,0x16,0x9c,0xa9,0xa2,0x18,0x10,0x28,0x12,0x34,0xab,0xcb,0xcc,0x33, /* ..s......(.4...3 */ \
	0x86,0xd7,0x99,0x00,0xef,0x2b,0xe5,0xe6,0xcc,0x7a,0xa5,0x99,0xbb,0xb7,0xaf,0x2f, /* .....+...z...../ */ \
	0x29,0xd5,0x15,0x4b,0x88,0xa2,0xef,0xa1,0x8d,0xac,0xa4,0x70,0xc0,0x35,0x38,0x20, /* )..K.......p.58  */ \
	0xb4,0xc2,0x33,0xb6,0x61,0xe2,0x18,0x41,0x95,0xb9,0x9c,0x29,0x18,0x2f,0x8b,0xf5, /* ..3.a..A...)./.. */ \
	0xae,0x72,0x2e,0x9c,0x78,0x46,0xa2,0xa4,0x37,0x37,0x97,0x24,0xcb,0x4c,0xe7,0x20, /* .r..xF..77.$.L.  */ \
	0xd7,0x3a,0xa3,0xca,0x3b,0xc6,0x9a,0x4a,0xb2,0xf5,0x74,0xa1,0x9c,0xc3,0x6b,0x61, /* .:..;..J..t...ka */ \
	0xe9,0xfa,0xea,0x76,0x42,0xac,0xb3,0x85,0xd3,0xda,0x0c,0x56,0x98,0x94,0xb3,0xc0, /* ...vB......V.... */ \
	0x49,0x0a,0x1a,0x06,0xd4,0x9e,0x7c,0x10,0x2d,0x1b,0x78,0x00,0xa8,0x7d,0xdc,0xdf, /* I.....|.-.x..}.. */ \
	0x4b,0x7c,0x0c,0x39,0xaa,0x2b,0x78,0xd4,0x90,0x9e,0xbe,0x93,0x99,0xc3,0x6b,0x76, /* K|.9.+x.......kv */ \
	0x06,0x83,0xc1,0x1f,0xd1,0x17,0x57,0x7e,0xc9,0x3b,0xc3,0xaf,0x82,0xc5,0x09,0x3c, /* ......W~.;.....< */ \
	0x6f,0xe2,0xf2,0x39,0xfc,0x12,0x16,0xa3,0xda,0x90,0x7d,0x30,0x66,0x4f,0x74,0x5f, /* o..9......}0fOt_ */ \
	0xb6,0xc6,0x60,0xa9,0xbd,0xef,0x0a,0x44,0xf2,0xc6,0xd1,0xd6,0xee,0x12,0x07,0xc7, /* ..`....D........ */ \
	0x8d,0x7c,0xcf,0x1b,0xd6,0x85,0x47,0x0d,0xf6,0x9f,0x19,0x08,0x4a,0x70,0x08,0xe2, /* .|....G.....Jp.. */ \
	0x24,0x7e,0xd8,0xbf,0x31,0x76,0x21,0xa0,0x66,0xe9,0x0a,0x0e,0xd0,0xab,0x21,0x5c, /* $~..1v!.f.....!\ */ \
	0xf7,0xca,0xb9,0xea,0x26,0x2c,0xf5,0x09,0xc7,0xa7,0xf8,0xf7,0xc8,0x16,0x38,0xd3, /* ....&,........8. */ \
	0xb6,0x82,0x3f,0xdd,0x67,0x14,0x86,0xba,0x92,0x65,0x9a,0x32,0xaf,0xe3,0x31,0x5b, /* ..?.g....e.2..1[ */ \
	0xd7,0xff,0xa5,0xf7,0xeb,0xcb,0x49,0xef,0x59,0x8f,0x1d,0xd6,0x1b,0x50,0x87,0x94, /* ......I.Y....P.. */ \
	0x81,0x0f,0x94,0x2f,0x81,0xf1,0x29,0x3c,0x56,0x23,0xc4,0xb1,0x3f,0xa3,0x95,0x3c, /* .../..)<V#..?..< */ \
	0x30,0x08,0x6d,0xcb,0xa1,0x71,0xf1,0xf2,0x67,0x44,0xc9,0xba,0x90,0x94,0x2e,0xc4, /* 0.m..q..gD...... */ \
	0x1a,0x51,0xf2,0x74,0xf8,0x94,0x53,0xa1,0x42,0x56,0x4f,0x0b,0x0e,0x43,0xdd,0x0f, /* .Q.t..S.BVO..C.. */ \
	0xba,0x0f,0x24,0x0b,0xce,0xf9,0x96,0x86,0x53,0x84,0xca,0x52,0xbe,0x0d,0xfe,0xfc, /* ..$.....S..R.... */ \
	0x0a,0x16,0xb6,0xe4,0xd3,0x9e,0xaf,0x36,0x56,0xcf,0x9c,0xe7,0x73,0x32,0xb9,0xee, /* .......6V...s2.. */ \
	0x75,0x8f,0x82,0x6d,0x76,0x50,0xb6,0x76,0xf8,0xee,0xd4,0x7d,0x15,0x7d,0x9e,0x86, /* u..mvP.v...}.}.. */ \
	0xc8,0x46,0xb8,0x84,0xdf,0x46,0xb1,0x10,0xd6,0x9d,0x21,0x51,0x91,0x62,0xe3,0x36, /* .F...F....!Q.b.6 */ \
	0xae,0x87,0x77,0xd2,0xf1,0x4d,0xeb,0xf6,0xd6,0x15,0xbe,0xa4,0x21,0xa9,0x7d,0xc6, /* ..w..M......!.}. */ \
	0x08,0x2e,0x51,0x61,0xa9,0x29,0x5e,0xc3,0xaa,0xb6,0xf3,0x86,0x06,0xd6,0x7e,0x88, /* ..Qa.)^.......~. */ \
	0xf5,0xeb,0x52,0xeb,0xca,0x92,0x5e,0x22,0xfa,0xb9,0x2c,0xe0,0xdc,0x39,0xfb,0x72, /* ..R...^"..,..9.r */ \
	0xa7,0x20,0xe6,0x4d,0x21,0x06,0x99,0x08,0xea,0x35,0xaa,0x98,0xcf,0x6d,0x65,0x7d, /* . .M!....5...me} */ \
	0x54,0x2b,0x14,0xe1,0x4e,0xc6,0x57,0xba,0x28,0x18,0x20,0x05,0xcf,0x49,0x4c,0xcd, /* T+..N.W.(. ..IL. */ \
	0xac,0x36,0xff,0x25,0x71,0x79,0x51,0x16,0xa2,0xb2,0x32,0xdf,0x24,0xd7,0x8d,0x14, /* .6.%qyQ...2.$... */ \
	0x28,0xf6,0xb3,0x99,0xcf,0xaa,0xb6,0x3c,0x87,0x3a,0x81,0xb3,0xc0,0xca,0xe9,0x9a, /* (......<.:...... */ \
	0x2f,0x90,0x46,0x53,0x49,0x15,0x50,0x5b,0x1e,0x0a,0x59,0xde,0xb9,0xf9,0x09,0x29, /* /.FSI.P[..Y....) */ \
	0x7a,0x4e,0x68,0x0b,0xea,0xf0,0x10,0x31,0x99,0x70,0xd5,0x49,0x36,0x26,0xb6,0xd2, /* zNh....1.p.I6&.. */ \
	0x76,0xae,0x66,0xd1,0x4c,0x4e,0xda,0x1f,0xa2,0x08,0xab,0x24,0xbe,0x7c,0xab,0xb2, /* v.f.LN.....$.|.. */ \
	0x96,0x7e,0x35,0x1a,0xf9,0xa8,0xb3,0xe8,0xb0,0x39,0x7e,0xc7,0xad,0x5e,0x2b,0xe1, /* .~5......9~..^+. */ \
	0x13,0x25,0x4d,0x2a,0xa1,0xac,0x66,0x52,0xe6,0xcc,0xa5,0xdf,0xae,0x51,0x6a,0x82, /* .%M...fR.....Qj. */ \
	0x08,0x35,0x25,0x5f,0xa3,0x91,0xa2,0xb0,0x8c,0xc7,0xf4,0x13,0xfd,0xf8,0x23,0xed, /* .5%_..........#. */ \
	0x8a,0x58,0xac,0xd6,0x96,0x97,0xd1,0xc3,0x7d,0x98,0x27,0x0d,0xbe,0x72,0x34,0x17, /* .X......}.'..r4. */ \
	0xdc,0xa6,0x3a,0xc5,0x77,0x65,0xd0,0x00,0x62,0x71,0xb2,0x75,0xe1,0xbc,0x38,0x76, /* ..:.we..bq.u..8v */ \
	0x76,0xeb,0x4a,0xea,0x8d,0x01,0xad,0x46,0x9f,0x91,0x0f,0x1a,0x47,0x1f,0xf4,0x03, /* v.J....F....G... */ \
	0x7e,0xf2,0x89,0xdc,0x23,0xa6,0x87,0x5e,0x85,0xfc,0x1c,0x36,0x7d,0xee,0x65,0x21, /* ~...#..^...6}.e! */ \
	0xf9,0x12,0xd8,0x4d,0x36,0x35,0xe1,0xcb,0x9b,0x87,0x3e,0x74,0xd0,0x9c,0x2d,0x69, /* ...M65....>t..-i */ \
	0xd0,0x98,0xee,0x88,0xf8,0x62,0x7d,0x91,0x3f,0xa2,0x3e,0x54,0x25,0x2e,0xaf,0x26, /* .....b}.?.>T%..& */ \
	0xe8,0x96,0xe3,0x4f,0x88,0x6b,0x0c,0x9c,0xc8,0x0f,0xae,0x31,0x08,0xbc,0xa5,0x1a, /* ...O.k.....1.... */ \
	0xe4,0x98,0x95,0xb2,0xdc,0x9e,0xa9,0xc4,0x13,0x67,0x07,0x0f,0x2e,0x5c,0x16,0x68, /* .........g...\.h */ \
	0x29,0x0a,0x94,0xe1,0x10,0x0e,0xf8,0xe1,0x8c,0x4b,0x76,0x91,0xc5,0x54,0x9b,0x18, /* )........Kv..T.. */ \
	0x43,0x8f,0xad,0x6f,0x5a,0xc7,0x96,0xaf,0x0e,0xac,0x9f,0x76,0xb8,0xdf,0x08,0x2e, /* C..oZ......v.... */ \
	0x9e,0xb1,0x79,0x0c,0xd8,0x59,0x25,0xdb,0x62,0x75,0xe3,0xac,0x06,0x30,0x48,0x07, /* ..y..Y%.bu...0H. */ \
	0x63,0x92,0x9d,0xae,0xdb,0xc8,0x84,0xee,0xbb,0x4b,0xcd,0xe6,0x55,0xc4,0x38,0xf9, /* c........K..U.8. */ \
	0x34,0xc0,0x1f,0xf8,0xa7,0x1b,0xad,0x07,0x4b,0x49,0x2b,0xa1,0x78,0x08,0xf0,0xe5, /* 4.......KI+.x... */ \
	0xe3,0x18,0x9d,0x0e,0x1a,0x79,0x34,0x11,0xe1,0xdc,0x4e,0x65,0x31,0x9e,0x9b,0x1c, /* .....y4...Ne1... */ \
	0x79,0xbe,0x99,0xcf,0xba,0x21,0x5a,0x2e,0xf5,0x7d,0x08,0xc6,0x1a,0xe3,0xe4,0x66, /* y....!Z..}.....f */ \
	0xe8,0xf1,0xc3,0x8e,0xa7,0x5b,0x95,0x55,0xfd,0xfd,0x62,0xd4,0x17,0xf6,0xad,0xe0  /* .....[.U..b..... */
#define DATACHUNK000013 \
	0x8b,0xa2,0x30,0xe6,0xb4,0x90,0xc6,0xb5,0xb6,0x84,0xd7,0x82,0xdf,0xa5,0xbd,0x48, /* ..0............H */ \
	0x29,0xcd,0x84,0x42,0x1a,0x0f,0xff,0x2a,0xcf,0x34,0xe2,0xaa,0x9d,0xcf,0x72,0x54, /* )..B.....4....rT */ \
	0xcd,0x42,0x57,0x7e,0x90,0x9b,0x6a,0x61,0x72,0x90,0x64,0xa9,0xd0,0xa8,0x26,0xbd, /* .BW~..jar.d...&. */ \
	0x66,0x37,0xef,0xeb,0x6f,0x0b,0x96,0x58,0x3a,0xfe,0x1f,0xf1,0x72,0xd5,0x24,0xd1, /* f7..o..X:...r.$. */ \
	0x80,0xde,0xd5,0x28,0xd5,0xf7,0x52,0x56,0x3e,0x76,0x90,0x4c,0x2c,0xb2,0xdd,0xa5, /* ...(..RV>v.L,... */ \
	0x9a,0x22,0xcb,0x30,0x0f,0x9b,0x89,0x8a,0xdb,0x13,0xba,0x9b,0x95,0xc5,0x92,0xa7, /* .".0............ */ \
	0xed,0x3b,0x58,0xc2,0x0d,0xef,0x78,0xc4,0x83,0x7d,0x62,0x43,0xb1,0x45,0xb0,0xa5, /* .;X...x..}bC.E.. */ \
	0xbd,0x4d,0xff,0xe9,0x0d,0x8e,0x47,0xfd,0xd0,0x38,0x1e,0x22,0x67,0x80,0xba,0x16, /* .M....G..8."g... */ \
	0x40,0xb1,0xde,0xbb,0x1f,0x16,0xc5,0x4d,0x33,0x46,0x1b,0xe9,0x6a,0x53,0x22,0x3e, /* @......M3F..jS"> */ \
	0xd1,0x3d,0x30,0xfc,0xc6,0x51,0x22,0x4e,0x5a,0xed,0x18,0x8a,0xf9,0x18,0x4a,0xe7, /* .=0..Q"NZ.....J. */ \
	0x7e,0x44,0x8e,0x08,0xfc,0xd0,0x6a,0xfb,0x1d,0x30,0xbc,0xcb,0x22,0x0f,0x02,0xfe, /* ~D....j..0.."... */ \
	0x96,0x23,0xc3,0x4a,0x61,0xb2,0x39,0x17,0x8f,0x4e,0xaf,0x44,0xd5,0xc2,0x46,0x7f, /* .#.Ja.9..N.D..F. */ \
	0x70,0x1d,0x49,0x23,0xd4,0x20,0xa8,0x84,0xd4,0x70,0x66,0x1d,0xc2,0x12,0x8e,0x8b, /* p.I#. ...pf..... */ \
	0xeb,0x9d,0x4a,0x67,0x5f,0xac,0x27,0xe2,0xee,0x77,0x81,0x2e,0x13,0x74,0xfe,0x1c, /* ..Jg_.'..w...t.. */ \
	0xfd,0x3d,0x9c,0x29,0x83,0x26,0x33,0x57,0x45,0x3e,0x2c,0x31,0xba,0x7b,0xec,0xe0, /* .=.).&3WE>,1.{.. */ \
	0xe5,0x60,0x23,0x7d,0x03,0x4e,0xec,0x75,0x56,0x76,0xf1,0x9a,0x90,0x7c,0xc0,0xa7, /* .`#}.N.uVv...|.. */ \
	0x85,0xcb,0xe6,0xa9,0x34,0x48,0xc2,0x8f,0xd4,0x5d,0xe5,0x21,0x27,0x8e,0x1c,0xf7, /* ....4H...].!'... */ \
	0x0a,0x1f,0x82,0x4d,0xf7,0xf6,0x73,0xc6,0x9b,0x0a,0x93,0x11,0x67,0xd9,0xe7,0x9c, /* ...M..s.....g... */ \
	0x88,0x4f,0xb8,0xf0,0xc1,0xf5,0x2f,0xde,0xe8,0x9b,0x2d,0xa8,0x0e,0x00,0x00,0x2b, /* .O..../...-....+ */ \
	0x10,0x06,0x10,0x01,0x10,0x02,0x18,0x5b,0x00,0x01,0x10,0x01,0x10,0x01,0x0a,0x17, /* .......[........ */ \
	0x00,0x03,0x03,0x50,0x49,0x43,0x02,0xca,0x01,0xff,0x27,0x00,0x09,0x08,0x2b,0x06, /* ...PIC....'...+. */ \
	0x01,0x04,0x01,0x81,0x85,0x47,0x03,0x88,0x01,0xfa,0x2e,0x00,0x07,0x04,0x0a,0x39, /* .....G.........9 */ \
	0x00,0x03,0x05,0x61,0x64,0x6d,0x69,0x6e,0x05,0x0a,0x48,0x00,0x03,0x09,0x4d,0x69, /* ...admin..H...Mi */ \
	0x63,0x72,0x6f,0x63,0x68,0x69,0x70,0x06,0x0a,0x54,0x00,0x03,0x06,0x6f,0x66,0x66, /* crochip..T...off */ \
	0x69,0x63,0x65,0x07,0x03,0x6d,0x00,0x00,0x01,0x07,0x04,0x18,0x92,0x01,0x01,0x10, /* ice..m.......... */ \
	0x81,0x10,0x85,0x10,0x47,0x10,0x01,0x10,0x01,0x18,0x95,0x00,0x01,0x0a,0x7e,0x00, /* ....G.........~. */ \
	0x03,0x0b,0x53,0x4e,0x4d,0x50,0x76,0x33,0x41,0x67,0x65,0x6e,0x74,0x02,0x0a,0x89, /* ..SNMPv3Agent... */ \
	0x00,0x03,0x05,0x76,0x35,0x2e,0x33,0x31,0x03,0x03,0x9d,0x00,0x03,0x06,0x4f,0x63, /* ...v5.31......Oc */ \
	0x74,0x20,0x31,0x30,0x02,0x18,0xcd,0x00,0x01,0x10,0x01,0x10,0x01,0xac,0x01,0x01, /* t 10............ */ \
	0xa9,0x00,0x00,0x01,0x01,0x01,0x01,0x00,0x02,0xac,0x01,0x02,0xb5,0x00,0x00,0x01, /* ................ */ \
	0x01,0x01,0x01,0x00,0x03,0xac,0x01,0x03,0xc1,0x00,0x05,0x01,0x01,0x01,0x01,0x00, /* ................ */ \
	0x04,0xa5,0x01,0x04,0xd1,0x00,0x04,0x01,0x01,0x01,0x01,0x00,0x03,0x18,0xf4,0x00, /* ................ */ \
	0x01,0xa8,0x01,0x05,0xd8,0x00,0x00,0x02,0xa8,0x01,0x06,0xdf,0x00,0x00,0x03,0x88, /* ................ */ \
	0x01,0x07,0xe6,0x00,0x00,0x04,0x88,0x01,0x08,0xed,0x00,0x01,0x06,0xa1,0x01,0x0a, /* ................ */ \
	0xfc,0x00,0x04,0x04,0x18,0x44,0x01,0x01,0x10,0x01,0x10,0x01,0x8c,0x01,0x0b,0x08, /* .....D.......... */ \
	0x01,0x00,0x01,0x01,0x01,0x0b,0x00,0x02,0xac,0x01,0x0c,0x14,0x01,0x04,0x01,0x01, /* ................ */ \
	0x01,0x0b,0x00,0x03,0xac,0x01,0x0d,0x20,0x01,0x00,0x01,0x01,0x01,0x0b,0x00,0x04, /* ....... ........ */ \
	0xac,0x01,0x0e,0x2c,0x01,0x04,0x01,0x01,0x01,0x0b,0x00,0x05,0xac,0x01,0x0f,0x38, /* ...,...........8 */ \
	0x01,0x00,0x01,0x01,0x01,0x0b,0x00,0x06,0xa5,0x01,0x10,0x4c,0x01,0x04,0x01,0x01, /* ...........L.... */ \
	0x01,0x0b,0x00,0x05,0x18,0x88,0x01,0x01,0x10,0x01,0x10,0x01,0x8c,0x01,0x11,0x58, /* ...............X */ \
	0x01,0x00,0x01,0x01,0x01,0x11,0x00,0x02,0xac,0x01,0x12,0x64,0x01,0x00,0x01,0x01, /* ...........d.... */ \
	0x01,0x11,0x00,0x03,0xac,0x01,0x13,0x70,0x01,0x00,0x01,0x01,0x01,0x11,0x00,0x04, /* .......p........ */ \
	0xac,0x01,0x14,0x7c,0x01,0x04,0x01,0x01,0x01,0x11,0x00,0x05,0xa5,0x01,0x15,0x8a, /* ...|............ */ \
	0x01,0x00,0x01,0x01,0x01,0x11,0x00,0x07,0x10,0x01,0x81,0x02,0x01,0xf4,0x9c,0x01, /* ................ */ \
	0x00,0x06,0x10,0x03,0x10,0x0a,0x10,0x02,0x10,0x01,0x10,0x01,0x88,0x01,0xf9,0xa3, /* ................ */ \
	0x01,0x04,0x02,0x88,0x01,0xf8,0xaa,0x01,0x02,0x03,0x88,0x01,0xf7,0xb1,0x01,0x02, /* ................ */ \
	0x04,0x80,0x01,0xf6,0x01,0x3c,0x72,0x65,0x73,0x70,0x6f,0x6e,0x73,0x65,0x3e,0x0d, /* .....<response>. */ \
	0x0a,0x3c,0x6c,0x65,0x64,0x30,0x3e,0x7e,0x6c,0x65,0x64,0x28,0x30,0x29,0x7e,0x3c, /* .<led0>~led(0)~< */ \
	0x2f,0x6c,0x65,0x64,0x30,0x3e,0x0d,0x0a,0x3c,0x6c,0x65,0x64,0x31,0x3e,0x7e,0x6c, /* /led0>..<led1>~l */ \
	0x65,0x64,0x28,0x31,0x29,0x7e,0x3c,0x2f,0x6c,0x65,0x64,0x31,0x3e,0x0d,0x0a,0x3c, /* ed(1)~</led1>..< */ \
	0x6c,0x65,0x64,0x32,0x3e,0x7e,0x6c,0x65,0x64,0x28,0x32,0x29,0x7e,0x3c,0x2f,0x6c, /* led2>~led(2)~</l */ \
	0x65,0x64,0x32,0x3e,0x0d,0x0a,0x3c,0x6c,0x65,0x64,0x33,0x3e,0x7e,0x6c,0x65,0x64, /* ed2>..<led3>~led */ \
	0x28,0x33,0x29,0x7e,0x3c,0x2f,0x6c,0x65,0x64,0x33,0x3e,0x0d,0x0a,0x3c,0x6c,0x65, /* (3)~</led3>..<le */ \
	0x64,0x34,0x3e,0x7e,0x6c,0x65,0x64,0x28,0x34,0x29,0x7e,0x3c,0x2f,0x6c,0x65,0x64, /* d4>~led(4)~</led */ \
	0x34,0x3e,0x0d,0x0a,0x3c,0x6c,0x65,0x64,0x35,0x3e,0x7e,0x6c,0x65,0x64,0x28,0x35, /* 4>..<led5>~led(5 */ \
	0x29,0x7e,0x3c,0x2f,0x6c,0x65,0x64,0x35,0x3e,0x0d,0x0a,0x3c,0x6c,0x65,0x64,0x36, /* )~</led5>..<led6 */ \
	0x3e,0x7e,0x6c,0x65,0x64,0x28,0x36,0x29,0x7e,0x3c,0x2f,0x6c,0x65,0x64,0x36,0x3e, /* >~led(6)~</led6> */ \
	0x0d,0x0a,0x3c,0x6c,0x65,0x64,0x37,0x3e,0x7e,0x6c,0x65,0x64,0x28,0x37,0x29,0x7e, /* ..<led7>~led(7)~ */ \
	0x3c,0x2f,0x6c,0x65,0x64,0x37,0x3e,0x0d,0x0a,0x3c,0x62,0x74,0x6e,0x30,0x3e,0x7e, /* </led7>..<btn0>~ */ \
	0x62,0x74,0x6e,0x28,0x30,0x29,0x7e,0x3c,0x2f,0x62,0x74,0x6e,0x30,0x3e,0x0d,0x0a, /* btn(0)~</btn0>.. */ \
	0x3c,0x62,0x74,0x6e,0x31,0x3e,0x7e,0x62,0x74,0x6e,0x28,0x31,0x29,0x7e,0x3c,0x2f, /* <btn1>~btn(1)~</ */ \
	0x62,0x74,0x6e,0x31,0x3e,0x0d,0x0a,0x3c,0x62,0x74,0x6e,0x32,0x3e,0x7e,0x62,0x74, /* btn1>..<btn2>~bt */ \
	0x6e,0x28,0x32,0x29,0x7e,0x3c,0x2f,0x62,0x74,0x6e,0x32,0x3e,0x0d,0x0a,0x3c,0x62, /* n(2)~</btn2>..<b */ \
	0x74,0x6e,0x33,0x3e,0x7e,0x62,0x74,0x6e,0x28,0x33,0x29,0x7e,0x3c,0x2f,0x62,0x74  /* tn3>~btn(3)~</bt */
#define DATACHUNK000014 \
	0x6e,0x33,0x3e,0x0d,0x0a,0x3c,0x70,0x6f,0x74,0x30,0x3e,0x7e,0x70,0x6f,0x74,0x7e, /* n3>..<pot0>~pot~ */ \
	0x3c,0x2f,0x70,0x6f,0x74,0x30,0x3e,0x0d,0x0a,0x3c,0x2f,0x72,0x65,0x73,0x70,0x6f, /* </pot0>..</respo */ \
	0x6e,0x73,0x65,0x3e,0x0d,0x0a,0x12,0x00,0x00,0x00,0x17,0x00,0x00,0x00,0x29,0x00, /* nse>..........). */ \
	0x00,0x00,0x0c,0x00,0x00,0x00,0x40,0x00,0x00,0x00,0x0b,0x00,0x00,0x00,0x57,0x00, /* ......@.......W. */ \
	0x00,0x00,0x0a,0x00,0x00,0x00,0x6e,0x00,0x00,0x00,0x09,0x00,0x00,0x00,0x85,0x00, /* ......n......... */ \
	0x00,0x00,0x08,0x00,0x00,0x00,0x9c,0x00,0x00,0x00,0x07,0x00,0x00,0x00,0xb3,0x00, /* ................ */ \
	0x00,0x00,0x06,0x00,0x00,0x00,0xca,0x00,0x00,0x00,0x18,0x00,0x00,0x00,0xe1,0x00, /* ................ */ \
	0x00,0x00,0x19,0x00,0x00,0x00,0xf8,0x00,0x00,0x00,0x1a,0x00,0x00,0x00,0x0f,0x01, /* ................ */ \
	0x00,0x00,0x1b,0x00,0x00,0x00,0x26,0x01,0x00,0x00,0x1c,0x00,0x00,0x00,0x7e,0x69, /* ......&.......~i */ \
	0x6e,0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a, /* nc:header.inc~.. */ \
	0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74, /* <div id="content */ \
	0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x46,0x69,0x6c,0x65,0x20,0x55, /* ">....<h1>File U */ \
	0x70,0x6c,0x6f,0x61,0x64,0x73,0x3c,0x2f,0x68,0x31,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c, /* ploads</h1>....< */ \
	0x70,0x3e,0x54,0x68,0x65,0x20,0x48,0x54,0x54,0x50,0x20,0x73,0x65,0x72,0x76,0x65, /* p>The HTTP serve */ \
	0x72,0x20,0x63,0x61,0x6e,0x20,0x61,0x63,0x63,0x65,0x70,0x74,0x20,0x66,0x69,0x6c, /* r can accept fil */ \
	0x65,0x20,0x75,0x70,0x6c,0x6f,0x61,0x64,0x73,0x20,0x76,0x69,0x61,0x20,0x50,0x4f, /* e uploads via PO */ \
	0x53,0x54,0x2e,0x20,0x20,0x54,0x68,0x69,0x73,0x20,0x63,0x61,0x6e,0x20,0x62,0x65, /* ST.  This can be */ \
	0x20,0x75,0x73,0x65,0x64,0x20,0x66,0x6f,0x72,0x20,0x0d,0x0a,0x6d,0x61,0x6e,0x79, /*  used for ..many */ \
	0x20,0x61,0x70,0x70,0x6c,0x69,0x63,0x61,0x74,0x69,0x6f,0x6e,0x73,0x20,0x73,0x75, /*  applications su */ \
	0x63,0x68,0x20,0x61,0x73,0x20,0x61,0x6c,0x6c,0x6f,0x77,0x69,0x6e,0x67,0x20,0x75, /* ch as allowing u */ \
	0x73,0x65,0x72,0x73,0x20,0x74,0x6f,0x20,0x75,0x70,0x6c,0x6f,0x61,0x64,0x20,0x63, /* sers to upload c */ \
	0x6f,0x6e,0x66,0x69,0x67,0x75,0x72,0x61,0x74,0x69,0x6f,0x6e,0x20,0x73,0x65,0x74, /* onfiguration set */ \
	0x74,0x69,0x6e,0x67,0x73,0x20,0x66,0x69,0x6c,0x65,0x73,0x2e,0x0d,0x0a,0x45,0x61, /* tings files...Ea */ \
	0x63,0x68,0x20,0x61,0x70,0x70,0x6c,0x69,0x63,0x61,0x74,0x69,0x6f,0x6e,0x20,0x6d, /* ch application m */ \
	0x75,0x73,0x74,0x20,0x69,0x6d,0x70,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x20,0x69,0x74, /* ust implement it */ \
	0x73,0x20,0x6f,0x77,0x6e,0x20,0x66,0x69,0x6c,0x65,0x20,0x70,0x72,0x6f,0x63,0x65, /* s own file proce */ \
	0x73,0x73,0x6f,0x72,0x2e,0x20,0x20,0x54,0x68,0x69,0x73,0x20,0x65,0x78,0x61,0x6d, /* ssor.  This exam */ \
	0x70,0x6c,0x65,0x20,0x0d,0x0a,0x63,0x61,0x6c,0x63,0x75,0x6c,0x61,0x74,0x65,0x73, /* ple ..calculates */ \
	0x20,0x74,0x68,0x65,0x20,0x4d,0x44,0x35,0x20,0x68,0x61,0x73,0x68,0x20,0x6f,0x66, /*  the MD5 hash of */ \
	0x20,0x61,0x6e,0x79,0x20,0x66,0x69,0x6c,0x65,0x2e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a, /*  any file.</p>.. */ \
	0x0d,0x0a,0x3c,0x66,0x6f,0x72,0x6d,0x20,0x61,0x63,0x74,0x69,0x6f,0x6e,0x3d,0x22, /* ..<form action=" */ \
	0x75,0x70,0x6c,0x6f,0x61,0x64,0x2e,0x68,0x74,0x6d,0x22,0x20,0x6d,0x65,0x74,0x68, /* upload.htm" meth */ \
	0x6f,0x64,0x3d,0x22,0x70,0x6f,0x73,0x74,0x22,0x20,0x65,0x6e,0x63,0x74,0x79,0x70, /* od="post" enctyp */ \
	0x65,0x3d,0x22,0x6d,0x75,0x6c,0x74,0x69,0x70,0x61,0x72,0x74,0x2f,0x66,0x6f,0x72, /* e="multipart/for */ \
	0x6d,0x2d,0x64,0x61,0x74,0x61,0x22,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x63, /* m-data">..<div c */ \
	0x6c,0x61,0x73,0x73,0x3d,0x22,0x65,0x78,0x61,0x6d,0x70,0x6c,0x65,0x62,0x6f,0x78, /* lass="examplebox */ \
	0x22,0x3e,0x0d,0x0a,0x7e,0x75,0x70,0x6c,0x6f,0x61,0x64,0x65,0x64,0x6d,0x64,0x35, /* ">..~uploadedmd5 */ \
	0x7e,0x0d,0x0a,0x3c,0x70,0x20,0x73,0x74,0x79,0x6c,0x65,0x3d,0x22,0x6d,0x61,0x72, /* ~..<p style="mar */ \
	0x67,0x69,0x6e,0x2d,0x62,0x6f,0x74,0x74,0x6f,0x6d,0x3a,0x20,0x32,0x70,0x78,0x22, /* gin-bottom: 2px" */ \
	0x3e,0x3c,0x62,0x3e,0x46,0x69,0x6c,0x65,0x3a,0x20,0x3c,0x2f,0x62,0x3e,0x26,0x6e, /* ><b>File: </b>&n */ \
	0x62,0x73,0x70,0x3b,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70, /* bsp;..<input typ */ \
	0x65,0x3d,0x22,0x66,0x69,0x6c,0x65,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x6d, /* e="file" name="m */ \
	0x64,0x35,0x66,0x69,0x6c,0x65,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x33,0x30, /* d5file" size="30 */ \
	0x22,0x20,0x2f,0x3e,0x20,0x26,0x6e,0x62,0x73,0x70,0x3b,0x0d,0x0a,0x3c,0x69,0x6e, /* " /> &nbsp;..<in */ \
	0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x73,0x75,0x62,0x6d,0x69,0x74, /* put type="submit */ \
	0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x47,0x65,0x74,0x20,0x4d,0x44,0x35, /* " value="Get MD5 */ \
	0x22,0x20,0x2f,0x3e,0x0d,0x0a,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69, /* " />..</p>..</di */ \
	0x76,0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x6f,0x72,0x6d,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c, /* v>..</form>....< */ \
	0x70,0x3e,0x54,0x68,0x69,0x73,0x20,0x69,0x73,0x20,0x61,0x6e,0x20,0x61,0x64,0x76, /* p>This is an adv */ \
	0x61,0x6e,0x63,0x65,0x64,0x20,0x66,0x65,0x61,0x74,0x75,0x72,0x65,0x2e,0x20,0x20, /* anced feature.   */ \
	0x46,0x6f,0x72,0x20,0x6d,0x6f,0x72,0x65,0x20,0x69,0x6e,0x66,0x6f,0x72,0x6d,0x61, /* For more informa */ \
	0x74,0x69,0x6f,0x6e,0x2c,0x20,0x70,0x6c,0x65,0x61,0x73,0x65,0x20,0x72,0x65,0x66, /* tion, please ref */ \
	0x65,0x72,0x20,0x74,0x6f,0x20,0x74,0x68,0x65,0x20,0x0d,0x0a,0x69,0x6d,0x70,0x6c, /* er to the ..impl */ \
	0x65,0x6d,0x65,0x6e,0x74,0x61,0x74,0x69,0x6f,0x6e,0x20,0x69,0x6e,0x20,0x3c,0x63, /* ementation in <c */ \
	0x6f,0x64,0x65,0x3e,0x43,0x75,0x73,0x74,0x6f,0x6d,0x48,0x54,0x54,0x50,0x41,0x70, /* ode>CustomHTTPAp */ \
	0x70,0x2e,0x63,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x20,0x66,0x6f,0x72,0x20,0x63, /* p.c</code> for c */ \
	0x6f,0x6d,0x6d,0x65,0x6e,0x74,0x73,0x20,0x61,0x6e,0x64,0x20,0x65,0x78,0x70,0x6c, /* omments and expl */ \
	0x61,0x69,0x6e,0x61,0x74,0x69,0x6f,0x6e,0x2e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d, /* aination.</p>... */ \
	0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69, /* .</div>....<scri */ \
	0x70,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x2f,0x6a,0x61, /* pt type="text/ja */ \
	0x76,0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x0d,0x0a,0x3c,0x21,0x2d,0x2d, /* vascript">..<!-- */ \
	0x0d,0x0a,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x67,0x65,0x74,0x45,0x6c, /* ..document.getEl */ \
	0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28,0x27,0x68,0x65,0x6c,0x6c,0x6f, /* ementById('hello */ \
	0x27,0x29,0x2e,0x69,0x6e,0x6e,0x65,0x72,0x48,0x54,0x4d,0x4c,0x20,0x3d,0x20,0x22  /* ').innerHTML = " */
#define DATACHUNK000015 \
	0x7e,0x68,0x65,0x6c,0x6c,0x6f,0x6d,0x73,0x67,0x7e,0x22,0x3b,0x0d,0x0a,0x2d,0x2d, /* ~hellomsg~";..-- */ \
	0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70,0x74,0x3e,0x0d,0x0a,0x7e,0x69, /* >..</script>..~i */ \
	0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x00,0x00, /* nc:footer.inc~.. */ \
	0x00,0x00,0x33,0x00,0x00,0x00,0xb6,0x01,0x00,0x00,0x1d,0x00,0x00,0x00,0x72,0x03, /* ..3...........r. */ \
	0x00,0x00,0x01,0x00,0x00,0x00,0x90,0x03,0x00,0x00,0x02,0x00,0x00,0x00,0x7e,0x69, /* ..............~i */ \
	0x6e,0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a, /* nc:header.inc~.. */ \
	0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74, /* <div id="content */ \
	0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x44,0x79,0x6e,0x61,0x6d,0x69, /* ">....<h1>Dynami */ \
	0x63,0x20,0x44,0x4e,0x53,0x3c,0x2f,0x68,0x31,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76, /* c DNS</h1>..<div */ \
	0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x72,0x65,0x73,0x75,0x6c,0x74,0x20,0x6f, /*  class="result o */ \
	0x6b,0x22,0x20,0x73,0x74,0x79,0x6c,0x65,0x3d,0x22,0x64,0x69,0x73,0x70,0x6c,0x61, /* k" style="displa */ \
	0x79,0x3a,0x7e,0x73,0x74,0x61,0x74,0x75,0x73,0x5f,0x6f,0x6b,0x7e,0x22,0x3e,0x0d, /* y:~status_ok~">. */ \
	0x0a,0x59,0x6f,0x75,0x72,0x20,0x73,0x65,0x74,0x74,0x69,0x6e,0x67,0x73,0x20,0x68, /* .Your settings h */ \
	0x61,0x76,0x65,0x20,0x62,0x65,0x65,0x6e,0x20,0x73,0x61,0x76,0x65,0x64,0x2e,0x0d, /* ave been saved.. */ \
	0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20, /* .</div>....<div  */ \
	0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x72,0x65,0x73,0x75,0x6c,0x74,0x20,0x7e,0x64, /* class="result ~d */ \
	0x64,0x6e,0x73,0x5f,0x73,0x74,0x61,0x74,0x75,0x73,0x7e,0x22,0x3e,0x0d,0x0a,0x7e, /* dns_status~">..~ */ \
	0x64,0x64,0x6e,0x73,0x5f,0x73,0x74,0x61,0x74,0x75,0x73,0x5f,0x6d,0x73,0x67,0x7e, /* ddns_status_msg~ */ \
	0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x3e,0x54, /* ..</div>....<p>T */ \
	0x68,0x65,0x20,0x44,0x79,0x6e,0x61,0x6d,0x69,0x63,0x20,0x44,0x4e,0x53,0x20,0x6d, /* he Dynamic DNS m */ \
	0x6f,0x64,0x75,0x6c,0x65,0x20,0x61,0x6c,0x6c,0x6f,0x77,0x73,0x20,0x74,0x68,0x65, /* odule allows the */ \
	0x20,0x73,0x74,0x61,0x63,0x6b,0x20,0x74,0x6f,0x20,0x75,0x70,0x64,0x61,0x74,0x65, /*  stack to update */ \
	0x20,0x74,0x68,0x65,0x20,0x62,0x6f,0x61,0x72,0x64,0x27,0x73,0x20,0x67,0x6c,0x6f, /*  the board's glo */ \
	0x62,0x61,0x6c,0x20,0x49,0x50,0x20,0x0d,0x0a,0x61,0x64,0x64,0x72,0x65,0x73,0x73, /* bal IP ..address */ \
	0x20,0x74,0x6f,0x20,0x76,0x61,0x72,0x69,0x6f,0x75,0x73,0x20,0x44,0x79,0x6e,0x61, /*  to various Dyna */ \
	0x6d,0x69,0x63,0x20,0x44,0x4e,0x53,0x20,0x73,0x65,0x72,0x76,0x69,0x63,0x65,0x73, /* mic DNS services */ \
	0x2e,0x20,0x20,0x54,0x68,0x69,0x73,0x20,0x66,0x65,0x61,0x74,0x75,0x72,0x65,0x2c, /* .  This feature, */ \
	0x20,0x61,0x6c,0x6f,0x6e,0x67,0x20,0x77,0x69,0x74,0x68,0x20,0x70,0x72,0x6f,0x70, /*  along with prop */ \
	0x65,0x72,0x0d,0x0a,0x70,0x6f,0x72,0x74,0x20,0x66,0x6f,0x72,0x77,0x61,0x72,0x64, /* er..port forward */ \
	0x69,0x6e,0x67,0x20,0x69,0x6e,0x20,0x70,0x6c,0x61,0x63,0x65,0x20,0x61,0x74,0x20, /* ing in place at  */ \
	0x74,0x68,0x65,0x20,0x72,0x6f,0x75,0x74,0x65,0x72,0x2c,0x20,0x63,0x61,0x6e,0x20, /* the router, can  */ \
	0x65,0x6e,0x61,0x62,0x6c,0x65,0x20,0x67,0x6c,0x6f,0x62,0x61,0x6c,0x20,0x61,0x63, /* enable global ac */ \
	0x63,0x65,0x73,0x73,0x20,0x74,0x6f,0x20,0x61,0x20,0x0d,0x0a,0x64,0x65,0x76,0x69, /* cess to a ..devi */ \
	0x63,0x65,0x20,0x62,0x65,0x68,0x69,0x6e,0x64,0x20,0x61,0x20,0x4e,0x41,0x54,0x20, /* ce behind a NAT  */ \
	0x72,0x6f,0x75,0x74,0x65,0x72,0x20,0x6f,0x72,0x20,0x66,0x69,0x72,0x65,0x77,0x61, /* router or firewa */ \
	0x6c,0x6c,0x2e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x3e,0x45,0x6e, /* ll.</p>....<p>En */ \
	0x74,0x65,0x72,0x20,0x74,0x68,0x65,0x20,0x73,0x65,0x74,0x74,0x69,0x6e,0x67,0x73, /* ter the settings */ \
	0x20,0x69,0x6e,0x20,0x74,0x68,0x65,0x20,0x66,0x69,0x65,0x6c,0x64,0x73,0x20,0x62, /*  in the fields b */ \
	0x65,0x6c,0x6f,0x77,0x3a,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x66,0x6f, /* elow:</p>....<fo */ \
	0x72,0x6d,0x20,0x6d,0x65,0x74,0x68,0x6f,0x64,0x3d,0x22,0x70,0x6f,0x73,0x74,0x22, /* rm method="post" */ \
	0x20,0x61,0x63,0x74,0x69,0x6f,0x6e,0x3d,0x22,0x2f,0x64,0x79,0x6e,0x64,0x6e,0x73, /*  action="/dyndns */ \
	0x2f,0x69,0x6e,0x64,0x65,0x78,0x2e,0x68,0x74,0x6d,0x22,0x3e,0x0d,0x0a,0x3c,0x66, /* /index.htm">..<f */ \
	0x69,0x65,0x6c,0x64,0x73,0x65,0x74,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c, /* ieldset>..<div>< */ \
	0x6c,0x61,0x62,0x65,0x6c,0x3e,0x44,0x44,0x4e,0x53,0x20,0x53,0x65,0x72,0x76,0x69, /* label>DDNS Servi */ \
	0x63,0x65,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x73,0x65, /* ce:</label>..<se */ \
	0x6c,0x65,0x63,0x74,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x73,0x65,0x72,0x76,0x69, /* lect name="servi */ \
	0x63,0x65,0x22,0x3e,0x0d,0x0a,0x3c,0x6f,0x70,0x74,0x69,0x6f,0x6e,0x20,0x76,0x61, /* ce">..<option va */ \
	0x6c,0x75,0x65,0x3d,0x22,0x30,0x22,0x20,0x7e,0x64,0x64,0x6e,0x73,0x5f,0x73,0x65, /* lue="0" ~ddns_se */ \
	0x72,0x76,0x69,0x63,0x65,0x28,0x30,0x29,0x7e,0x3e,0x44,0x79,0x6e,0x44,0x4e,0x53, /* rvice(0)~>DynDNS */ \
	0x20,0x28,0x77,0x77,0x77,0x2e,0x64,0x79,0x6e,0x64,0x6e,0x73,0x2e,0x63,0x6f,0x6d, /*  (www.dyndns.com */ \
	0x29,0x3c,0x2f,0x6f,0x70,0x74,0x69,0x6f,0x6e,0x3e,0x0d,0x0a,0x3c,0x6f,0x70,0x74, /* )</option>..<opt */ \
	0x69,0x6f,0x6e,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x31,0x22,0x20,0x7e,0x64, /* ion value="1" ~d */ \
	0x64,0x6e,0x73,0x5f,0x73,0x65,0x72,0x76,0x69,0x63,0x65,0x28,0x31,0x29,0x7e,0x3e, /* dns_service(1)~> */ \
	0x4e,0x6f,0x2d,0x49,0x50,0x20,0x28,0x77,0x77,0x77,0x2e,0x6e,0x6f,0x2d,0x69,0x70, /* No-IP (www.no-ip */ \
	0x2e,0x63,0x6f,0x6d,0x29,0x3c,0x2f,0x6f,0x70,0x74,0x69,0x6f,0x6e,0x3e,0x0d,0x0a, /* .com)</option>.. */ \
	0x3c,0x6f,0x70,0x74,0x69,0x6f,0x6e,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x32, /* <option value="2 */ \
	0x22,0x20,0x7e,0x64,0x64,0x6e,0x73,0x5f,0x73,0x65,0x72,0x76,0x69,0x63,0x65,0x28, /* " ~ddns_service( */ \
	0x32,0x29,0x7e,0x3e,0x44,0x4e,0x53,0x2d,0x4f,0x2d,0x4d,0x61,0x74,0x69,0x63,0x20, /* 2)~>DNS-O-Matic  */ \
	0x28,0x77,0x77,0x77,0x2e,0x64,0x6e,0x73,0x6f,0x6d,0x61,0x74,0x69,0x63,0x2e,0x63, /* (www.dnsomatic.c */ \
	0x6f,0x6d,0x29,0x3c,0x2f,0x6f,0x70,0x74,0x69,0x6f,0x6e,0x3e,0x0d,0x0a,0x3c,0x2f, /* om)</option>..</ */ \
	0x73,0x65,0x6c,0x65,0x63,0x74,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d, /* select>..</div>. */ \
	0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x55,0x73,0x65, /* .<div><label>Use */ \
	0x72,0x20,0x4e,0x61,0x6d,0x65,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d, /* r Name:</label>. */ \
	0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65  /* .<input type="te */
#define DATACHUNK000016 \
	0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x75,0x73,0x65,0x72,0x22,0x20, /* xt" name="user"  */ \
	0x6d,0x61,0x78,0x6c,0x65,0x6e,0x67,0x74,0x68,0x3d,0x22,0x34,0x30,0x22,0x20,0x76, /* maxlength="40" v */ \
	0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x64,0x64,0x6e,0x73,0x5f,0x75,0x73,0x65,0x72, /* alue="~ddns_user */ \
	0x7e,0x22,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76, /* ~"/></div>..<div */ \
	0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x50,0x61,0x73,0x73,0x77,0x6f,0x72,0x64, /* ><label>Password */ \
	0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75, /* :</label>..<inpu */ \
	0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x70,0x61,0x73,0x73,0x77,0x6f,0x72,0x64, /* t type="password */ \
	0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x70,0x61,0x73,0x73,0x22,0x20,0x6d,0x61, /* " name="pass" ma */ \
	0x78,0x6c,0x65,0x6e,0x67,0x74,0x68,0x3d,0x22,0x32,0x34,0x22,0x20,0x76,0x61,0x6c, /* xlength="24" val */ \
	0x75,0x65,0x3d,0x22,0x7e,0x64,0x64,0x6e,0x73,0x5f,0x70,0x61,0x73,0x73,0x7e,0x22, /* ue="~ddns_pass~" */ \
	0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c, /* /></div>..<div>< */ \
	0x6c,0x61,0x62,0x65,0x6c,0x3e,0x48,0x6f,0x73,0x74,0x3a,0x3c,0x2f,0x6c,0x61,0x62, /* label>Host:</lab */ \
	0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65, /* el>..<input type */ \
	0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x68,0x6f, /* ="text" name="ho */ \
	0x73,0x74,0x22,0x20,0x6d,0x61,0x78,0x6c,0x65,0x6e,0x67,0x74,0x68,0x3d,0x22,0x34, /* st" maxlength="4 */ \
	0x38,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x64,0x64,0x6e,0x73,0x5f, /* 8" value="~ddns_ */ \
	0x68,0x6f,0x73,0x74,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d, /* host~" /></div>. */ \
	0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70, /* .<div><input typ */ \
	0x65,0x3d,0x22,0x73,0x75,0x62,0x6d,0x69,0x74,0x22,0x20,0x63,0x6c,0x61,0x73,0x73, /* e="submit" class */ \
	0x3d,0x22,0x73,0x6d,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x53,0x65,0x74, /* ="sm" value="Set */ \
	0x20,0x44,0x44,0x4e,0x53,0x20,0x43,0x6f,0x6e,0x66,0x69,0x67,0x75,0x72,0x61,0x74, /*  DDNS Configurat */ \
	0x69,0x6f,0x6e,0x22,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x2f, /* ion"/></div>..</ */ \
	0x66,0x69,0x65,0x6c,0x64,0x73,0x65,0x74,0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x6f,0x72, /* fieldset>..</for */ \
	0x6d,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x73, /* m>..</div>....<s */ \
	0x63,0x72,0x69,0x70,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74, /* cript type="text */ \
	0x2f,0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x0d,0x0a,0x3c, /* /javascript">..< */ \
	0x21,0x2d,0x2d,0x0d,0x0a,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x67,0x65, /* !--..document.ge */ \
	0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28,0x27,0x68,0x65, /* tElementById('he */ \
	0x6c,0x6c,0x6f,0x27,0x29,0x2e,0x69,0x6e,0x6e,0x65,0x72,0x48,0x54,0x4d,0x4c,0x20, /* llo').innerHTML  */ \
	0x3d,0x20,0x22,0x7e,0x68,0x65,0x6c,0x6c,0x6f,0x6d,0x73,0x67,0x7e,0x22,0x3b,0x0d, /* = "~hellomsg~";. */ \
	0x0a,0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70,0x74,0x3e,0x0d, /* .-->..</script>. */ \
	0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e,0x63, /* .~inc:footer.inc */ \
	0x7e,0x0d,0x0a,0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0x64,0x00,0x00,0x00,0x1e, /* ~......3...d.... */ \
	0x00,0x00,0x00,0xb0,0x00,0x00,0x00,0x1f,0x00,0x00,0x00,0xc1,0x00,0x00,0x00,0x20, /* ...............  */ \
	0x00,0x00,0x00,0xaa,0x02,0x00,0x00,0x2f,0x00,0x00,0x00,0xf0,0x02,0x00,0x00,0x30, /* ......./.......0 */ \
	0x00,0x00,0x00,0x34,0x03,0x00,0x00,0x31,0x00,0x00,0x00,0xd8,0x03,0x00,0x00,0x21, /* ...4...1.......! */ \
	0x00,0x00,0x00,0x46,0x04,0x00,0x00,0x22,0x00,0x00,0x00,0xac,0x04,0x00,0x00,0x23, /* ...F...".......# */ \
	0x00,0x00,0x00,0x85,0x05,0x00,0x00,0x01,0x00,0x00,0x00,0xa3,0x05,0x00,0x00,0x02, /* ................ */ \
	0x00,0x00,0x00,0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69, /* ...~inc:header.i */ \
	0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x63,0x6f, /* nc~..<div id="co */ \
	0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x53, /* ntent">....<h1>S */ \
	0x65,0x6e,0x64,0x20,0x45,0x2d,0x4d,0x61,0x69,0x6c,0x3c,0x2f,0x68,0x31,0x3e,0x0d, /* end E-Mail</h1>. */ \
	0x0a,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x72, /* ...<div class="r */ \
	0x65,0x73,0x75,0x6c,0x74,0x20,0x6f,0x6b,0x22,0x20,0x73,0x74,0x79,0x6c,0x65,0x3d, /* esult ok" style= */ \
	0x22,0x64,0x69,0x73,0x70,0x6c,0x61,0x79,0x3a,0x7e,0x73,0x74,0x61,0x74,0x75,0x73, /* "display:~status */ \
	0x5f,0x6f,0x6b,0x7e,0x22,0x3e,0x0d,0x0a,0x59,0x6f,0x75,0x72,0x20,0x6d,0x65,0x73, /* _ok~">..Your mes */ \
	0x73,0x61,0x67,0x65,0x20,0x68,0x61,0x73,0x20,0x62,0x65,0x65,0x6e,0x20,0x73,0x65, /* sage has been se */ \
	0x6e,0x74,0x2e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69, /* nt...</div>..<di */ \
	0x76,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x72,0x65,0x73,0x75,0x6c,0x74,0x20, /* v class="result  */ \
	0x66,0x61,0x69,0x6c,0x22,0x20,0x73,0x74,0x79,0x6c,0x65,0x3d,0x22,0x64,0x69,0x73, /* fail" style="dis */ \
	0x70,0x6c,0x61,0x79,0x3a,0x7e,0x73,0x74,0x61,0x74,0x75,0x73,0x5f,0x66,0x61,0x69, /* play:~status_fai */ \
	0x6c,0x7e,0x22,0x3e,0x0d,0x0a,0x45,0x52,0x52,0x4f,0x52,0x3a,0x20,0x59,0x6f,0x75, /* l~">..ERROR: You */ \
	0x72,0x20,0x6d,0x65,0x73,0x73,0x61,0x67,0x65,0x20,0x63,0x6f,0x75,0x6c,0x64,0x20, /* r message could  */ \
	0x6e,0x6f,0x74,0x20,0x62,0x65,0x20,0x73,0x65,0x6e,0x74,0x2e,0x3c,0x62,0x72,0x20, /* not be sent.<br  */ \
	0x2f,0x3e,0x0d,0x0a,0x43,0x68,0x65,0x63,0x6b,0x20,0x79,0x6f,0x75,0x72,0x20,0x53, /* />..Check your S */ \
	0x4d,0x54,0x50,0x20,0x73,0x65,0x72,0x76,0x65,0x72,0x20,0x73,0x65,0x74,0x74,0x69, /* MTP server setti */ \
	0x6e,0x67,0x73,0x20,0x61,0x6e,0x64,0x20,0x74,0x72,0x79,0x20,0x61,0x67,0x61,0x69, /* ngs and try agai */ \
	0x6e,0x2e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70, /* n...</div>....<p */ \
	0x3e,0x42,0x79,0x20,0x63,0x6f,0x6d,0x62,0x69,0x6e,0x69,0x6e,0x67,0x20,0x74,0x68, /* >By combining th */ \
	0x65,0x20,0x53,0x4d,0x54,0x50,0x20,0x63,0x6c,0x69,0x65,0x6e,0x74,0x20,0x69,0x6e, /* e SMTP client in */ \
	0x74,0x6f,0x20,0x61,0x6e,0x20,0x48,0x54,0x54,0x50,0x32,0x20,0x50,0x4f,0x53,0x54, /* to an HTTP2 POST */ \
	0x20,0x63,0x61,0x6c,0x6c,0x62,0x61,0x63,0x6b,0x2c,0x20,0x61,0x20,0x66,0x6f,0x72, /*  callback, a for */ \
	0x6d,0x20,0x0d,0x0a,0x63,0x61,0x6e,0x20,0x62,0x65,0x20,0x64,0x65,0x76,0x65,0x6c, /* m ..can be devel */ \
	0x6f,0x70,0x65,0x64,0x20,0x74,0x68,0x61,0x74,0x20,0x73,0x65,0x6e,0x64,0x73,0x20  /* oped that sends  */
#define DATACHUNK000017 \
	0x61,0x6e,0x20,0x65,0x2d,0x6d,0x61,0x69,0x6c,0x20,0x74,0x6f,0x20,0x61,0x6e,0x20, /* an e-mail to an  */ \
	0x61,0x64,0x6d,0x69,0x6e,0x69,0x73,0x74,0x72,0x61,0x74,0x6f,0x72,0x2e,0x20,0x20, /* administrator.   */ \
	0x46,0x6f,0x72,0x20,0x6d,0x6f,0x72,0x65,0x0d,0x0a,0x64,0x65,0x74,0x61,0x69,0x6c, /* For more..detail */ \
	0x73,0x20,0x6f,0x6e,0x20,0x74,0x68,0x65,0x20,0x53,0x4d,0x54,0x50,0x20,0x43,0x6c, /* s on the SMTP Cl */ \
	0x69,0x65,0x6e,0x74,0x20,0x6d,0x6f,0x64,0x75,0x6c,0x65,0x2c,0x20,0x70,0x6c,0x65, /* ient module, ple */ \
	0x61,0x73,0x65,0x20,0x73,0x65,0x65,0x20,0x74,0x68,0x65,0x20,0x54,0x43,0x50,0x49, /* ase see the TCPI */ \
	0x50,0x20,0x53,0x74,0x61,0x63,0x6b,0x20,0x55,0x73,0x65,0x72,0x27,0x73,0x0d,0x0a, /* P Stack User's.. */ \
	0x47,0x75,0x69,0x64,0x65,0x2e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70, /* Guide.</p>....<p */ \
	0x3e,0x45,0x6e,0x74,0x65,0x72,0x20,0x74,0x68,0x65,0x20,0x61,0x70,0x70,0x72,0x6f, /* >Enter the appro */ \
	0x70,0x72,0x69,0x61,0x74,0x65,0x20,0x73,0x65,0x74,0x74,0x69,0x6e,0x67,0x73,0x20, /* priate settings  */ \
	0x69,0x6e,0x20,0x74,0x68,0x65,0x20,0x66,0x69,0x65,0x6c,0x64,0x73,0x20,0x62,0x65, /* in the fields be */ \
	0x6c,0x6f,0x77,0x3a,0x0d,0x0a,0x3c,0x62,0x72,0x20,0x2f,0x3e,0x28,0x59,0x6f,0x75, /* low:..<br />(You */ \
	0x72,0x20,0x53,0x4d,0x54,0x50,0x20,0x73,0x65,0x72,0x76,0x65,0x72,0x20,0x6d,0x61, /* r SMTP server ma */ \
	0x79,0x20,0x6e,0x6f,0x74,0x20,0x72,0x65,0x71,0x75,0x69,0x72,0x65,0x20,0x61,0x20, /* y not require a  */ \
	0x75,0x73,0x65,0x72,0x20,0x6e,0x61,0x6d,0x65,0x20,0x6f,0x72,0x20,0x70,0x61,0x73, /* user name or pas */ \
	0x73,0x77,0x6f,0x72,0x64,0x2e,0x29,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c, /* sword.)</p>....< */ \
	0x66,0x6f,0x72,0x6d,0x20,0x6d,0x65,0x74,0x68,0x6f,0x64,0x3d,0x22,0x70,0x6f,0x73, /* form method="pos */ \
	0x74,0x22,0x20,0x61,0x63,0x74,0x69,0x6f,0x6e,0x3d,0x22,0x2f,0x65,0x6d,0x61,0x69, /* t" action="/emai */ \
	0x6c,0x2f,0x69,0x6e,0x64,0x65,0x78,0x2e,0x68,0x74,0x6d,0x22,0x20,0x6f,0x6e,0x73, /* l/index.htm" ons */ \
	0x75,0x62,0x6d,0x69,0x74,0x3d,0x22,0x62,0x74,0x6e,0x3d,0x64,0x6f,0x63,0x75,0x6d, /* ubmit="btn=docum */ \
	0x65,0x6e,0x74,0x2e,0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79, /* ent.getElementBy */ \
	0x49,0x64,0x28,0x27,0x62,0x74,0x6e,0x53,0x75,0x62,0x6d,0x69,0x74,0x27,0x29,0x3b, /* Id('btnSubmit'); */ \
	0x20,0x62,0x74,0x6e,0x2e,0x76,0x61,0x6c,0x75,0x65,0x3d,0x27,0x28,0x70,0x6c,0x65, /*  btn.value='(ple */ \
	0x61,0x73,0x65,0x20,0x77,0x61,0x69,0x74,0x29,0x27,0x3b,0x20,0x62,0x74,0x6e,0x2e, /* ase wait)'; btn. */ \
	0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x74,0x72,0x75,0x65,0x3b, /* disabled = true; */ \
	0x22,0x3e,0x0d,0x0a,0x3c,0x66,0x69,0x65,0x6c,0x64,0x73,0x65,0x74,0x3e,0x0d,0x0a, /* ">..<fieldset>.. */ \
	0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x53,0x4d,0x54,0x50, /* <div><label>SMTP */ \
	0x20,0x53,0x65,0x72,0x76,0x65,0x72,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e, /*  Server:</label> */ \
	0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74, /* ..<input type="t */ \
	0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x73,0x65,0x72,0x76,0x65, /* ext" name="serve */ \
	0x72,0x22,0x20,0x73,0x74,0x79,0x6c,0x65,0x3d,0x22,0x77,0x69,0x64,0x74,0x68,0x3a, /* r" style="width: */ \
	0x31,0x36,0x35,0x70,0x78,0x22,0x2f,0x3e,0x0d,0x0a,0x26,0x6e,0x62,0x73,0x70,0x3b, /* 165px"/>..&nbsp; */ \
	0x3c,0x62,0x3e,0x50,0x6f,0x72,0x74,0x3a,0x3c,0x2f,0x62,0x3e,0x26,0x6e,0x62,0x73, /* <b>Port:</b>&nbs */ \
	0x70,0x3b,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d, /* p;..<input type= */ \
	0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x70,0x6f,0x72, /* "text" name="por */ \
	0x74,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x32,0x35,0x22,0x20,0x73,0x74, /* t" value="25" st */ \
	0x79,0x6c,0x65,0x3d,0x22,0x77,0x69,0x64,0x74,0x68,0x3a,0x32,0x35,0x70,0x78,0x3b, /* yle="width:25px; */ \
	0x22,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20, /* "/></div>..<div  */ \
	0x73,0x74,0x79,0x6c,0x65,0x3d,0x22,0x64,0x69,0x73,0x70,0x6c,0x61,0x79,0x3a,0x7e, /* style="display:~ */ \
	0x73,0x6d,0x74,0x70,0x73,0x5f,0x65,0x6e,0x7e,0x22,0x3e,0x3c,0x69,0x6e,0x70,0x75, /* smtps_en~"><inpu */ \
	0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78, /* t type="checkbox */ \
	0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x73,0x73,0x6c,0x22,0x20,0x76,0x61,0x6c, /* " name="ssl" val */ \
	0x75,0x65,0x3d,0x22,0x31,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x73,0x6d, /* ue="1" class="sm */ \
	0x22,0x2f,0x3e,0x20,0x55,0x73,0x65,0x20,0x53,0x53,0x4c,0x20,0x28,0x75,0x73,0x75, /* "/> Use SSL (usu */ \
	0x61,0x6c,0x6c,0x79,0x20,0x70,0x6f,0x72,0x74,0x20,0x34,0x36,0x35,0x29,0x3c,0x2f, /* ally port 465)</ */ \
	0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65, /* div>..<div><labe */ \
	0x6c,0x3e,0x55,0x73,0x65,0x72,0x20,0x4e,0x61,0x6d,0x65,0x3a,0x3c,0x2f,0x6c,0x61, /* l>User Name:</la */ \
	0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70, /* bel>..<input typ */ \
	0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x75, /* e="text" name="u */ \
	0x73,0x65,0x72,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c, /* ser" /></div>..< */ \
	0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x50,0x61,0x73,0x73,0x77, /* div><label>Passw */ \
	0x6f,0x72,0x64,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69, /* ord:</label>..<i */ \
	0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x70,0x61,0x73,0x73,0x77, /* nput type="passw */ \
	0x6f,0x72,0x64,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x70,0x61,0x73,0x73,0x22, /* ord" name="pass" */ \
	0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e, /*  /></div>..<div> */ \
	0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a, /* &nbsp;</div>.... */ \
	0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x54,0x6f,0x3a,0x3c, /* <div><label>To:< */ \
	0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20, /* /label>..<input  */ \
	0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65, /* type="text" name */ \
	0x3d,0x22,0x74,0x6f,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a, /* ="to" /></div>.. */ \
	0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x4d,0x65,0x73,0x73, /* <div><label>Mess */ \
	0x61,0x67,0x65,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74, /* age:</label>..<t */ \
	0x65,0x78,0x74,0x61,0x72,0x65,0x61,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x6d,0x73, /* extarea name="ms */ \
	0x67,0x22,0x20,0x72,0x6f,0x77,0x73,0x3d,0x22,0x36,0x22,0x3e,0x54,0x68,0x69,0x73  /* g" rows="6">This */
#define DATACHUNK000018 \
	0x20,0x6d,0x65,0x73,0x73,0x61,0x67,0x65,0x20,0x77,0x61,0x73,0x20,0x73,0x65,0x6e, /*  message was sen */ \
	0x74,0x20,0x62,0x79,0x20,0x74,0x68,0x65,0x20,0x4d,0x69,0x63,0x72,0x6f,0x63,0x68, /* t by the Microch */ \
	0x69,0x70,0x20,0x54,0x43,0x50,0x2f,0x49,0x50,0x20,0x53,0x74,0x61,0x63,0x6b,0x2e, /* ip TCP/IP Stack. */ \
	0x20,0x20,0x53,0x65,0x65,0x20,0x74,0x68,0x65,0x20,0x61,0x74,0x74,0x61,0x63,0x68, /*   See the attach */ \
	0x65,0x64,0x20,0x66,0x69,0x6c,0x65,0x20,0x66,0x6f,0x72,0x20,0x63,0x75,0x72,0x72, /* ed file for curr */ \
	0x65,0x6e,0x74,0x20,0x73,0x79,0x73,0x74,0x65,0x6d,0x20,0x73,0x74,0x61,0x74,0x75, /* ent system statu */ \
	0x73,0x20,0x69,0x6e,0x66,0x6f,0x72,0x6d,0x61,0x74,0x69,0x6f,0x6e,0x2e,0x20,0x20, /* s information.   */ \
	0x54,0x68,0x65,0x20,0x61,0x74,0x74,0x61,0x63,0x68,0x65,0x64,0x20,0x43,0x53,0x56, /* The attached CSV */ \
	0x20,0x66,0x69,0x6c,0x65,0x20,0x77,0x69,0x6c,0x6c,0x20,0x6f,0x70,0x65,0x6e,0x20, /*  file will open  */ \
	0x69,0x6e,0x20,0x61,0x6e,0x79,0x20,0x73,0x70,0x72,0x65,0x61,0x64,0x73,0x68,0x65, /* in any spreadshe */ \
	0x65,0x74,0x20,0x70,0x72,0x6f,0x67,0x72,0x61,0x6d,0x2e,0x3c,0x2f,0x74,0x65,0x78, /* et program.</tex */ \
	0x74,0x61,0x72,0x65,0x61,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a, /* tarea>..</div>.. */ \
	0x3c,0x64,0x69,0x76,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x69,0x64,0x3d,0x22, /* <div><input id=" */ \
	0x62,0x74,0x6e,0x53,0x75,0x62,0x6d,0x69,0x74,0x22,0x20,0x74,0x79,0x70,0x65,0x3d, /* btnSubmit" type= */ \
	0x22,0x73,0x75,0x62,0x6d,0x69,0x74,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22, /* "submit" class=" */ \
	0x73,0x6d,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x53,0x65,0x6e,0x64,0x20, /* sm" value="Send  */ \
	0x4d,0x65,0x73,0x73,0x61,0x67,0x65,0x22,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e, /* Message"/></div> */ \
	0x0d,0x0a,0x3c,0x2f,0x66,0x69,0x65,0x6c,0x64,0x73,0x65,0x74,0x3e,0x0d,0x0a,0x3c, /* ..</fieldset>..< */ \
	0x2f,0x66,0x6f,0x72,0x6d,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a, /* /form>..</div>.. */ \
	0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22, /* ..<script type=" */ \
	0x74,0x65,0x78,0x74,0x2f,0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22, /* text/javascript" */ \
	0x3e,0x0d,0x0a,0x3c,0x21,0x2d,0x2d,0x0d,0x0a,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e, /* >..<!--..documen */ \
	0x74,0x2e,0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64, /* t.getElementById */ \
	0x28,0x27,0x68,0x65,0x6c,0x6c,0x6f,0x27,0x29,0x2e,0x69,0x6e,0x6e,0x65,0x72,0x48, /* ('hello').innerH */ \
	0x54,0x4d,0x4c,0x20,0x3d,0x20,0x22,0x7e,0x68,0x65,0x6c,0x6c,0x6f,0x6d,0x73,0x67, /* TML = "~hellomsg */ \
	0x7e,0x22,0x3b,0x0d,0x0a,0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69, /* ~";..-->..</scri */ \
	0x70,0x74,0x3e,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72, /* pt>..~inc:footer */ \
	0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0x66, /* .inc~......3...f */ \
	0x00,0x00,0x00,0x1e,0x00,0x00,0x00,0xc2,0x00,0x00,0x00,0x24,0x00,0x00,0x00,0x0c, /* ...........$.... */ \
	0x04,0x00,0x00,0x48,0x00,0x00,0x00,0x24,0x07,0x00,0x00,0x01,0x00,0x00,0x00,0x42, /* ...H...$.......B */ \
	0x07,0x00,0x00,0x02,0x00,0x00,0x00,0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65,0x61,0x64, /* .......~inc:head */ \
	0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64, /* er.inc~..<div id */ \
	0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c, /* ="content">....< */ \
	0x68,0x31,0x3e,0x42,0x6f,0x61,0x72,0x64,0x20,0x43,0x6f,0x6e,0x66,0x69,0x67,0x75, /* h1>Board Configu */ \
	0x72,0x61,0x74,0x69,0x6f,0x6e,0x3c,0x2f,0x68,0x31,0x3e,0x0d,0x0a,0x3c,0x70,0x3e, /* ration</h1>..<p> */ \
	0x54,0x68,0x69,0x73,0x20,0x70,0x61,0x67,0x65,0x20,0x61,0x6c,0x6c,0x6f,0x77,0x73, /* This page allows */ \
	0x20,0x74,0x68,0x65,0x20,0x63,0x6f,0x6e,0x66,0x69,0x67,0x75,0x72,0x61,0x74,0x69, /*  the configurati */ \
	0x6f,0x6e,0x20,0x6f,0x66,0x20,0x74,0x68,0x65,0x20,0x62,0x6f,0x61,0x72,0x64,0x27, /* on of the board' */ \
	0x73,0x20,0x6e,0x65,0x74,0x77,0x6f,0x72,0x6b,0x20,0x73,0x65,0x74,0x74,0x69,0x6e, /* s network settin */ \
	0x67,0x73,0x2e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x63,0x6c, /* gs.</p>..<div cl */ \
	0x61,0x73,0x73,0x3d,0x22,0x72,0x65,0x73,0x75,0x6c,0x74,0x20,0x66,0x61,0x69,0x6c, /* ass="result fail */ \
	0x22,0x20,0x73,0x74,0x79,0x6c,0x65,0x3d,0x22,0x64,0x69,0x73,0x70,0x6c,0x61,0x79, /* " style="display */ \
	0x3a,0x7e,0x73,0x74,0x61,0x74,0x75,0x73,0x5f,0x66,0x61,0x69,0x6c,0x7e,0x22,0x3e, /* :~status_fail~"> */ \
	0x0d,0x0a,0x45,0x52,0x52,0x4f,0x52,0x3a,0x20,0x41,0x20,0x66,0x69,0x65,0x6c,0x64, /* ..ERROR: A field */ \
	0x20,0x77,0x61,0x73,0x20,0x75,0x6e,0x70,0x61,0x72,0x73,0x61,0x62,0x6c,0x65,0x20, /*  was unparsable  */ \
	0x6f,0x72,0x20,0x74,0x6f,0x6f,0x20,0x6d,0x75,0x63,0x68,0x20,0x64,0x61,0x74,0x61, /* or too much data */ \
	0x20,0x77,0x61,0x73,0x20,0x50,0x4f,0x53,0x54,0x65,0x64,0x2e,0x20,0x20,0x54,0x72, /*  was POSTed.  Tr */ \
	0x79,0x20,0x61,0x67,0x61,0x69,0x6e,0x2e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e, /* y again...</div> */ \
	0x0d,0x0a,0x3c,0x70,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x65,0x72,0x72,0x6f, /* ..<p class="erro */ \
	0x72,0x22,0x3e,0x0d,0x0a,0x3c,0x62,0x3e,0x43,0x41,0x55,0x54,0x49,0x4f,0x4e,0x3a, /* r">..<b>CAUTION: */ \
	0x3c,0x2f,0x62,0x3e,0x20,0x49,0x6e,0x63,0x6f,0x72,0x72,0x65,0x63,0x74,0x20,0x73, /* </b> Incorrect s */ \
	0x65,0x74,0x74,0x69,0x6e,0x67,0x73,0x20,0x6d,0x61,0x79,0x20,0x63,0x61,0x75,0x73, /* ettings may caus */ \
	0x65,0x20,0x74,0x68,0x65,0x20,0x62,0x6f,0x61,0x72,0x64,0x20,0x74,0x6f,0x20,0x6c, /* e the board to l */ \
	0x6f,0x73,0x65,0x20,0x6e,0x65,0x74,0x77,0x6f,0x72,0x6b,0x20,0x0d,0x0a,0x63,0x6f, /* ose network ..co */ \
	0x6e,0x6e,0x65,0x63,0x74,0x69,0x76,0x69,0x74,0x79,0x2e,0x20,0x20,0x52,0x65,0x63, /* nnectivity.  Rec */ \
	0x6f,0x76,0x65,0x72,0x79,0x20,0x6f,0x70,0x74,0x69,0x6f,0x6e,0x73,0x20,0x77,0x69, /* overy options wi */ \
	0x6c,0x6c,0x20,0x62,0x65,0x20,0x70,0x72,0x6f,0x76,0x69,0x64,0x65,0x64,0x20,0x6f, /* ll be provided o */ \
	0x6e,0x20,0x74,0x68,0x65,0x20,0x6e,0x65,0x78,0x74,0x20,0x70,0x61,0x67,0x65,0x2e, /* n the next page. */ \
	0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x3c,0x70,0x3e,0x45,0x6e,0x74,0x65,0x72,0x20,0x74, /* </p>..<p>Enter t */ \
	0x68,0x65,0x20,0x6e,0x65,0x77,0x20,0x73,0x65,0x74,0x74,0x69,0x6e,0x67,0x73,0x20, /* he new settings  */ \
	0x66,0x6f,0x72,0x20,0x74,0x68,0x65,0x20,0x62,0x6f,0x61,0x72,0x64,0x20,0x62,0x65, /* for the board be */ \
	0x6c,0x6f,0x77,0x3a,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x66,0x6f,0x72, /* low:</p>....<for */ \
	0x6d,0x20,0x6d,0x65,0x74,0x68,0x6f,0x64,0x3d,0x22,0x70,0x6f,0x73,0x74,0x22,0x20, /* m method="post"  */ \
	0x61,0x63,0x74,0x69,0x6f,0x6e,0x3d,0x22,0x2f,0x70,0x72,0x6f,0x74,0x65,0x63,0x74  /* action="/protect */
#define DATACHUNK000019 \
	0x2f,0x63,0x6f,0x6e,0x66,0x69,0x67,0x2e,0x68,0x74,0x6d,0x22,0x20,0x6e,0x61,0x6d, /* /config.htm" nam */ \
	0x65,0x3d,0x22,0x63,0x6f,0x6e,0x66,0x69,0x67,0x22,0x3e,0x0d,0x0a,0x3c,0x66,0x69, /* e="config">..<fi */ \
	0x65,0x6c,0x64,0x73,0x65,0x74,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c, /* eldset>..<div><l */ \
	0x61,0x62,0x65,0x6c,0x3e,0x4d,0x41,0x43,0x20,0x41,0x64,0x64,0x72,0x65,0x73,0x73, /* abel>MAC Address */ \
	0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75, /* :</label>..<inpu */ \
	0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61, /* t type="text" na */ \
	0x6d,0x65,0x3d,0x22,0x6d,0x61,0x63,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22, /* me="mac" value=" */ \
	0x7e,0x63,0x6f,0x6e,0x66,0x69,0x67,0x5f,0x6d,0x61,0x63,0x7e,0x22,0x20,0x2f,0x3e, /* ~config_mac~" /> */ \
	0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61, /* </div>..<div><la */ \
	0x62,0x65,0x6c,0x3e,0x48,0x6f,0x73,0x74,0x20,0x4e,0x61,0x6d,0x65,0x3a,0x3c,0x2f, /* bel>Host Name:</ */ \
	0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74, /* label>..<input t */ \
	0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d, /* ype="text" name= */ \
	0x22,0x68,0x6f,0x73,0x74,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x63, /* "host" value="~c */ \
	0x6f,0x6e,0x66,0x69,0x67,0x5f,0x68,0x6f,0x73,0x74,0x6e,0x61,0x6d,0x65,0x7e,0x22, /* onfig_hostname~" */ \
	0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e, /*  /></div>..<div> */ \
	0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a, /* &nbsp;</div>.... */ \
	0x3c,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79, /* <div>..<input ty */ \
	0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x63,0x6c, /* pe="checkbox" cl */ \
	0x61,0x73,0x73,0x3d,0x22,0x73,0x6d,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x64, /* ass="sm" name="d */ \
	0x68,0x63,0x70,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x31,0x22,0x20,0x6f, /* hcp" value="1" o */ \
	0x6e,0x63,0x6c,0x69,0x63,0x6b,0x3d,0x22,0x63,0x6f,0x6e,0x66,0x69,0x67,0x49,0x50, /* nclick="configIP */ \
	0x42,0x6f,0x78,0x65,0x73,0x28,0x29,0x22,0x20,0x7e,0x63,0x6f,0x6e,0x66,0x69,0x67, /* Boxes()" ~config */ \
	0x5f,0x64,0x68,0x63,0x70,0x63,0x68,0x65,0x63,0x6b,0x65,0x64,0x7e,0x20,0x2f,0x3e, /* _dhcpchecked~ /> */ \
	0x20,0x45,0x6e,0x61,0x62,0x6c,0x65,0x20,0x44,0x48,0x43,0x50,0x3c,0x2f,0x64,0x69, /*  Enable DHCP</di */ \
	0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e, /* v>..<div><label> */ \
	0x49,0x50,0x20,0x41,0x64,0x64,0x72,0x65,0x73,0x73,0x3a,0x3c,0x2f,0x6c,0x61,0x62, /* IP Address:</lab */ \
	0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20, /* el>..<td><input  */ \
	0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65, /* type="text" name */ \
	0x3d,0x22,0x69,0x70,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x63,0x6f, /* ="ip" value="~co */ \
	0x6e,0x66,0x69,0x67,0x5f,0x69,0x70,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69, /* nfig_ip~" /></di */ \
	0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e, /* v>..<div><label> */ \
	0x47,0x61,0x74,0x65,0x77,0x61,0x79,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e, /* Gateway:</label> */ \
	0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70, /* ..<td><input typ */ \
	0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x67, /* e="text" name="g */ \
	0x77,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x63,0x6f,0x6e,0x66,0x69, /* w" value="~confi */ \
	0x67,0x5f,0x67,0x77,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d, /* g_gw~" /></div>. */ \
	0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x53,0x75,0x62, /* .<div><label>Sub */ \
	0x6e,0x65,0x74,0x20,0x4d,0x61,0x73,0x6b,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c, /* net Mask:</label */ \
	0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79, /* >..<td><input ty */ \
	0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22, /* pe="text" name=" */ \
	0x73,0x75,0x62,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x63,0x6f,0x6e, /* sub" value="~con */ \
	0x66,0x69,0x67,0x5f,0x73,0x75,0x62,0x6e,0x65,0x74,0x7e,0x22,0x20,0x2f,0x3e,0x3c, /* fig_subnet~" />< */ \
	0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62, /* /div>..<div><lab */ \
	0x65,0x6c,0x3e,0x50,0x72,0x69,0x6d,0x61,0x72,0x79,0x20,0x44,0x4e,0x53,0x3a,0x3c, /* el>Primary DNS:< */ \
	0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e, /* /label>..<td><in */ \
	0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20, /* put type="text"  */ \
	0x6e,0x61,0x6d,0x65,0x3d,0x22,0x64,0x6e,0x73,0x31,0x22,0x20,0x76,0x61,0x6c,0x75, /* name="dns1" valu */ \
	0x65,0x3d,0x22,0x7e,0x63,0x6f,0x6e,0x66,0x69,0x67,0x5f,0x64,0x6e,0x73,0x31,0x7e, /* e="~config_dns1~ */ \
	0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76, /* " /></div>..<div */ \
	0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x53,0x65,0x63,0x6f,0x6e,0x64,0x61,0x72, /* ><label>Secondar */ \
	0x79,0x20,0x44,0x4e,0x53,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a, /* y DNS:</label>.. */ \
	0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78, /* <input type="tex */ \
	0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x64,0x6e,0x73,0x32,0x22,0x20,0x76, /* t" name="dns2" v */ \
	0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x63,0x6f,0x6e,0x66,0x69,0x67,0x5f,0x64,0x6e, /* alue="~config_dn */ \
	0x73,0x32,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c, /* s2~" /></div>..< */ \
	0x64,0x69,0x76,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d, /* div><input type= */ \
	0x22,0x73,0x75,0x62,0x6d,0x69,0x74,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22, /* "submit" class=" */ \
	0x73,0x6d,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x53,0x61,0x76,0x65,0x20, /* sm" value="Save  */ \
	0x43,0x6f,0x6e,0x66,0x69,0x67,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e, /* Config" /></div> */ \
	0x0d,0x0a,0x3c,0x2f,0x66,0x69,0x65,0x6c,0x64,0x73,0x65,0x74,0x3e,0x0d,0x0a,0x3c, /* ..</fieldset>..< */ \
	0x2f,0x66,0x6f,0x72,0x6d,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a, /* /form>..</div>.. */ \
	0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x6c,0x61,0x6e,0x67,0x75,0x61, /* ..<script langua */ \
	0x67,0x65,0x3d,0x22,0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x3e, /* ge="javascript"> */ \
	0x0d,0x0a,0x3c,0x21,0x2d,0x2d,0x0d,0x0a,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e  /* ..<!--..function */
#define DATACHUNK00001a \
	0x20,0x63,0x6f,0x6e,0x66,0x69,0x67,0x49,0x50,0x42,0x6f,0x78,0x65,0x73,0x28,0x29, /*  configIPBoxes() */ \
	0x20,0x7b,0x0d,0x0a,0x09,0x65,0x20,0x3d,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e, /*  {...e = documen */ \
	0x74,0x2e,0x66,0x6f,0x72,0x6d,0x73,0x2e,0x63,0x6f,0x6e,0x66,0x69,0x67,0x3b,0x0d, /* t.forms.config;. */ \
	0x0a,0x09,0x73,0x74,0x20,0x3d,0x20,0x65,0x2e,0x64,0x68,0x63,0x70,0x2e,0x63,0x68, /* ..st = e.dhcp.ch */ \
	0x65,0x63,0x6b,0x65,0x64,0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x69,0x70,0x2e,0x64,0x69, /* ecked;...e.ip.di */ \
	0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a,0x09,0x65, /* sabled = st;...e */ \
	0x2e,0x67,0x77,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73, /* .gw.disabled = s */ \
	0x74,0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x73,0x75,0x62,0x2e,0x64,0x69,0x73,0x61,0x62, /* t;...e.sub.disab */ \
	0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x64,0x6e, /* led = st;...e.dn */ \
	0x73,0x31,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74, /* s1.disabled = st */ \
	0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x64,0x6e,0x73,0x32,0x2e,0x64,0x69,0x73,0x61,0x62, /* ;...e.dns2.disab */ \
	0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a,0x7d,0x0d,0x0a,0x0d,0x0a, /* led = st;..}.... */ \
	0x63,0x6f,0x6e,0x66,0x69,0x67,0x49,0x50,0x42,0x6f,0x78,0x65,0x73,0x28,0x29,0x3b, /* configIPBoxes(); */ \
	0x0d,0x0a,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x67,0x65,0x74,0x45,0x6c, /* ..document.getEl */ \
	0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28,0x27,0x68,0x65,0x6c,0x6c,0x6f, /* ementById('hello */ \
	0x27,0x29,0x2e,0x69,0x6e,0x6e,0x65,0x72,0x48,0x54,0x4d,0x4c,0x20,0x3d,0x20,0x22, /* ').innerHTML = " */ \
	0x7e,0x68,0x65,0x6c,0x6c,0x6f,0x6d,0x73,0x67,0x7e,0x22,0x3b,0x0d,0x0a,0x2f,0x2f, /* ~hellomsg~";..// */ \
	0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70,0x74,0x3e,0x0d,0x0a, /* -->..</script>.. */ \
	0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e, /* ~inc:footer.inc~ */ \
	0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0xba,0x00,0x00,0x00,0x24,0x00,0x00,0x00, /* ....3.......$... */ \
	0x89,0x02,0x00,0x00,0x25,0x00,0x00,0x00,0xe7,0x02,0x00,0x00,0x26,0x00,0x00,0x00, /* ....%.......&... */ \
	0x72,0x03,0x00,0x00,0x27,0x00,0x00,0x00,0xe6,0x03,0x00,0x00,0x28,0x00,0x00,0x00, /* r...'.......(... */ \
	0x43,0x04,0x00,0x00,0x29,0x00,0x00,0x00,0xa5,0x04,0x00,0x00,0x2a,0x00,0x00,0x00, /* C...)........... */ \
	0x0c,0x05,0x00,0x00,0x2b,0x00,0x00,0x00,0x6f,0x05,0x00,0x00,0x2c,0x00,0x00,0x00, /* ....+...o...,... */ \
	0x19,0x07,0x00,0x00,0x01,0x00,0x00,0x00,0x39,0x07,0x00,0x00,0x02,0x00,0x00,0x00, /* ........9....... */ \
	0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e, /* ~inc:header.inc~ */ \
	0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65, /* ..<div id="conte */ \
	0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x4c,0x6f,0x67,0x69, /* nt">....<h1>Logi */ \
	0x6e,0x20,0x53,0x75,0x63,0x63,0x65,0x73,0x73,0x66,0x75,0x6c,0x3c,0x2f,0x68,0x31, /* n Successful</h1 */ \
	0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x3e,0x59,0x6f,0x75,0x20,0x68,0x61,0x76,0x65, /* >....<p>You have */ \
	0x20,0x73,0x75,0x63,0x63,0x65,0x73,0x73,0x66,0x75,0x6c,0x6c,0x79,0x20,0x6c,0x6f, /*  successfully lo */ \
	0x67,0x67,0x65,0x64,0x20,0x69,0x6e,0x20,0x74,0x6f,0x20,0x74,0x68,0x65,0x20,0x77, /* gged in to the w */ \
	0x65,0x62,0x20,0x73,0x65,0x72,0x76,0x65,0x72,0x2e,0x20,0x20,0x54,0x68,0x69,0x73, /* eb server.  This */ \
	0x20,0x61,0x75,0x74,0x68,0x65,0x6e,0x74,0x69,0x63,0x61,0x74,0x69,0x6f,0x6e,0x20, /*  authentication  */ \
	0x0d,0x0a,0x69,0x73,0x20,0x76,0x61,0x6c,0x69,0x64,0x20,0x75,0x6e,0x74,0x69,0x6c, /* ..is valid until */ \
	0x20,0x79,0x6f,0x75,0x20,0x63,0x6c,0x6f,0x73,0x65,0x20,0x79,0x6f,0x75,0x72,0x20, /*  you close your  */ \
	0x62,0x72,0x6f,0x77,0x73,0x65,0x72,0x2e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a, /* browser.</p>.... */ \
	0x3c,0x70,0x3e,0x43,0x72,0x65,0x64,0x65,0x6e,0x74,0x69,0x61,0x6c,0x73,0x20,0x61, /* <p>Credentials a */ \
	0x72,0x65,0x20,0x76,0x65,0x72,0x69,0x66,0x69,0x65,0x64,0x20,0x69,0x6e,0x20,0x79, /* re verified in y */ \
	0x6f,0x75,0x72,0x20,0x6f,0x77,0x6e,0x20,0x63,0x75,0x73,0x74,0x6f,0x6d,0x20,0x63, /* our own custom c */ \
	0x61,0x6c,0x6c,0x62,0x61,0x63,0x6b,0x20,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e, /* allback function */ \
	0x20,0x63,0x61,0x6c,0x6c,0x65,0x64,0x20,0x0d,0x0a,0x3c,0x63,0x6f,0x64,0x65,0x3e, /*  called ..<code> */ \
	0x48,0x54,0x54,0x50,0x41,0x75,0x74,0x68,0x65,0x6e,0x74,0x69,0x63,0x61,0x74,0x65, /* HTTPAuthenticate */ \
	0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x2e,0x20,0x20,0x49,0x6e,0x20,0x68,0x65,0x72, /* </code>.  In her */ \
	0x65,0x2c,0x20,0x79,0x6f,0x75,0x20,0x63,0x61,0x6e,0x20,0x64,0x65,0x74,0x65,0x72, /* e, you can deter */ \
	0x6d,0x69,0x6e,0x65,0x20,0x69,0x66,0x20,0x74,0x68,0x65,0x20,0x73,0x75,0x70,0x70, /* mine if the supp */ \
	0x6c,0x69,0x65,0x64,0x0d,0x0a,0x75,0x73,0x65,0x72,0x20,0x6e,0x61,0x6d,0x65,0x20, /* lied..user name  */ \
	0x61,0x6e,0x64,0x20,0x70,0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x20,0x61,0x72,0x65, /* and password are */ \
	0x20,0x76,0x61,0x6c,0x69,0x64,0x20,0x66,0x6f,0x72,0x20,0x61,0x63,0x63,0x65,0x73, /*  valid for acces */ \
	0x73,0x20,0x74,0x6f,0x20,0x74,0x68,0x65,0x20,0x72,0x65,0x71,0x75,0x65,0x73,0x74, /* s to the request */ \
	0x65,0x64,0x20,0x70,0x61,0x67,0x65,0x2e,0x20,0x20,0x59,0x6f,0x75,0x20,0x63,0x61, /* ed page.  You ca */ \
	0x6e,0x20,0x0d,0x0a,0x61,0x64,0x64,0x20,0x6d,0x75,0x6c,0x74,0x69,0x70,0x6c,0x65, /* n ..add multiple */ \
	0x20,0x75,0x73,0x65,0x72,0x73,0x20,0x61,0x6e,0x64,0x20,0x72,0x65,0x73,0x74,0x72, /*  users and restr */ \
	0x69,0x63,0x74,0x20,0x64,0x69,0x66,0x66,0x65,0x72,0x65,0x6e,0x74,0x20,0x75,0x73, /* ict different us */ \
	0x65,0x72,0x73,0x20,0x74,0x6f,0x20,0x64,0x69,0x66,0x66,0x65,0x72,0x65,0x6e,0x74, /* ers to different */ \
	0x20,0x70,0x61,0x67,0x65,0x73,0x2e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c, /*  pages.</p>....< */ \
	0x70,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x65,0x78,0x65,0x72,0x63,0x69,0x73, /* p class="exercis */ \
	0x65,0x22,0x3e,0x3c,0x62,0x3e,0x45,0x78,0x65,0x72,0x63,0x69,0x73,0x65,0x3a,0x3c, /* e"><b>Exercise:< */ \
	0x2f,0x62,0x3e,0x20,0x43,0x68,0x61,0x6e,0x67,0x65,0x20,0x74,0x68,0x65,0x20,0x75, /* /b> Change the u */ \
	0x73,0x65,0x72,0x20,0x6e,0x61,0x6d,0x65,0x20,0x61,0x6e,0x64,0x20,0x70,0x61,0x73, /* ser name and pas */ \
	0x73,0x77,0x6f,0x72,0x64,0x20,0x69,0x6e,0x0d,0x0a,0x3c,0x63,0x6f,0x64,0x65,0x3e, /* sword in..<code> */ \
	0x48,0x54,0x54,0x50,0x41,0x75,0x74,0x68,0x65,0x6e,0x74,0x69,0x63,0x61,0x74,0x65, /* HTTPAuthenticate */ \
	0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x20,0x74,0x6f,0x20,0x6f,0x6e,0x65,0x20,0x6f, /* </code> to one o */ \
	0x66,0x20,0x79,0x6f,0x75,0x72,0x20,0x63,0x68,0x6f,0x6f,0x73,0x69,0x6e,0x67,0x2e  /* f your choosing. */
#define DATACHUNK00001b \
	0x20,0x20,0x28,0x54,0x68,0x65,0x20,0x63,0x61,0x6c,0x6c,0x62,0x61,0x63,0x6b,0x20, /*   (The callback  */ \
	0x69,0x73,0x20,0x0d,0x0a,0x6c,0x6f,0x63,0x61,0x74,0x65,0x64,0x20,0x69,0x6e,0x20, /* is ..located in  */ \
	0x3c,0x63,0x6f,0x64,0x65,0x3e,0x43,0x75,0x73,0x74,0x6f,0x6d,0x48,0x54,0x54,0x50, /* <code>CustomHTTP */ \
	0x41,0x70,0x70,0x2e,0x63,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x2e,0x29,0x3c,0x2f, /* App.c</code>.)</ */ \
	0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x63,0x6c,0x61,0x73,0x73, /* p>....<div class */ \
	0x3d,0x22,0x65,0x78,0x61,0x6d,0x70,0x6c,0x65,0x62,0x6f,0x78,0x22,0x3e,0x0d,0x0a, /* ="examplebox">.. */ \
	0x57,0x68,0x65,0x6e,0x20,0x79,0x6f,0x75,0x20,0x66,0x69,0x6e,0x69,0x73,0x68,0x2c, /* When you finish, */ \
	0x20,0x72,0x65,0x66,0x72,0x65,0x73,0x68,0x20,0x74,0x68,0x69,0x73,0x20,0x70,0x61, /*  refresh this pa */ \
	0x67,0x65,0x20,0x74,0x6f,0x20,0x74,0x65,0x73,0x74,0x20,0x79,0x6f,0x75,0x72,0x20, /* ge to test your  */ \
	0x6e,0x65,0x77,0x20,0x75,0x73,0x65,0x72,0x20,0x6e,0x61,0x6d,0x65,0x20,0x61,0x6e, /* new user name an */ \
	0x64,0x20,0x70,0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x20,0x0d,0x0a,0x63,0x6f,0x6d, /* d password ..com */ \
	0x62,0x69,0x6e,0x61,0x74,0x69,0x6f,0x6e,0x2e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76, /* bination...</div */ \
	0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c, /* >....</div>....< */ \
	0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78, /* script type="tex */ \
	0x74,0x2f,0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x0d,0x0a, /* t/javascript">.. */ \
	0x3c,0x21,0x2d,0x2d,0x0d,0x0a,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x67, /* <!--..document.g */ \
	0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28,0x27,0x68, /* etElementById('h */ \
	0x65,0x6c,0x6c,0x6f,0x27,0x29,0x2e,0x69,0x6e,0x6e,0x65,0x72,0x48,0x54,0x4d,0x4c, /* ello').innerHTML */ \
	0x20,0x3d,0x20,0x22,0x7e,0x68,0x65,0x6c,0x6c,0x6f,0x6d,0x73,0x67,0x7e,0x22,0x3b, /*  = "~hellomsg~"; */ \
	0x0d,0x0a,0x2f,0x2f,0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70, /* ..//-->..</scrip */ \
	0x74,0x3e,0x0d,0x0a,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65, /* t>....~inc:foote */ \
	0x72,0x2e,0x69,0x6e,0x63,0x7e,0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0x94,0x03, /* r.inc~....3..... */ \
	0x00,0x00,0x01,0x00,0x00,0x00,0xb6,0x03,0x00,0x00,0x02,0x00,0x00,0x00,0x7e,0x72, /* ..............~r */ \
	0x65,0x62,0x6f,0x6f,0x74,0x7e,0x00,0x00,0x00,0x00,0x2d,0x00,0x00,0x00,0x7e,0x69, /* eboot~....-...~i */ \
	0x6e,0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a, /* nc:header.inc~.. */ \
	0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74, /* <div id="content */ \
	0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x52,0x65,0x62,0x6f,0x6f,0x74, /* ">....<h1>Reboot */ \
	0x20,0x49,0x6e,0x20,0x50,0x72,0x6f,0x67,0x72,0x65,0x73,0x73,0x2e,0x2e,0x2e,0x3c, /*  In Progress...< */ \
	0x2f,0x68,0x31,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x3e,0x59,0x6f,0x75,0x72,0x20, /* /h1>....<p>Your  */ \
	0x73,0x65,0x74,0x74,0x69,0x6e,0x67,0x73,0x20,0x77,0x65,0x72,0x65,0x20,0x73,0x75, /* settings were su */ \
	0x63,0x63,0x65,0x73,0x73,0x66,0x75,0x6c,0x6c,0x79,0x20,0x73,0x61,0x76,0x65,0x64, /* ccessfully saved */ \
	0x2c,0x20,0x61,0x6e,0x64,0x20,0x74,0x68,0x65,0x20,0x62,0x6f,0x61,0x72,0x64,0x20, /* , and the board  */ \
	0x69,0x73,0x20,0x6e,0x6f,0x77,0x20,0x72,0x65,0x62,0x6f,0x6f,0x74,0x69,0x6e,0x67, /* is now rebooting */ \
	0x20,0x0d,0x0a,0x74,0x6f,0x20,0x63,0x6f,0x6e,0x66,0x69,0x67,0x75,0x72,0x65,0x20, /*  ..to configure  */ \
	0x69,0x74,0x73,0x65,0x6c,0x66,0x20,0x77,0x69,0x74,0x68,0x20,0x74,0x68,0x65,0x20, /* itself with the  */ \
	0x6e,0x65,0x77,0x20,0x73,0x65,0x74,0x74,0x69,0x6e,0x67,0x73,0x2e,0x3c,0x2f,0x70, /* new settings.</p */ \
	0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x20,0x61,0x6c,0x69,0x67,0x6e,0x3d,0x22,0x63, /* >....<p align="c */ \
	0x65,0x6e,0x74,0x65,0x72,0x22,0x3e,0x3c,0x62,0x3e,0x59,0x6f,0x75,0x72,0x20,0x62, /* enter"><b>Your b */ \
	0x6f,0x61,0x72,0x64,0x20,0x69,0x73,0x20,0x6e,0x6f,0x77,0x20,0x6c,0x6f,0x63,0x61, /* oard is now loca */ \
	0x74,0x65,0x64,0x20,0x61,0x74,0x3a,0x20,0x0d,0x0a,0x3c,0x61,0x20,0x68,0x72,0x65, /* ted at: ..<a hre */ \
	0x66,0x3d,0x22,0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f,0x7e,0x72,0x65,0x62,0x6f,0x6f, /* f="http://~reboo */ \
	0x74,0x61,0x64,0x64,0x72,0x7e,0x2f,0x22,0x3e,0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f, /* taddr~/">http:// */ \
	0x7e,0x72,0x65,0x62,0x6f,0x6f,0x74,0x61,0x64,0x64,0x72,0x7e,0x2f,0x3c,0x2f,0x61, /* ~rebootaddr~/</a */ \
	0x3e,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x36, /* ></b></p>....<h6 */ \
	0x3e,0x3c,0x2f,0x68,0x36,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x33,0x3e,0x52,0x65, /* ></h6>....<h3>Re */ \
	0x63,0x6f,0x6e,0x6e,0x65,0x63,0x74,0x69,0x6f,0x6e,0x20,0x49,0x6e,0x73,0x74,0x72, /* connection Instr */ \
	0x75,0x63,0x74,0x69,0x6f,0x6e,0x73,0x3c,0x2f,0x68,0x33,0x3e,0x0d,0x0a,0x0d,0x0a, /* uctions</h3>.... */ \
	0x3c,0x6f,0x6c,0x3e,0x0d,0x0a,0x3c,0x6c,0x69,0x20,0x73,0x74,0x79,0x6c,0x65,0x3d, /* <ol>..<li style= */ \
	0x22,0x6d,0x61,0x72,0x67,0x69,0x6e,0x2d,0x62,0x6f,0x74,0x74,0x6f,0x6d,0x3a,0x31, /* "margin-bottom:1 */ \
	0x30,0x70,0x78,0x22,0x3e,0x3c,0x62,0x3e,0x44,0x69,0x64,0x20,0x79,0x6f,0x75,0x20, /* 0px"><b>Did you  */ \
	0x63,0x68,0x61,0x6e,0x67,0x65,0x20,0x74,0x68,0x65,0x20,0x68,0x6f,0x73,0x74,0x6e, /* change the hostn */ \
	0x61,0x6d,0x65,0x2c,0x20,0x49,0x50,0x20,0x6f,0x72,0x20,0x4d,0x41,0x43,0x20,0x61, /* ame, IP or MAC a */ \
	0x64,0x64,0x72,0x65,0x73,0x73,0x3f,0x3c,0x2f,0x62,0x3e,0x3c,0x62,0x72,0x20,0x2f, /* ddress?</b><br / */ \
	0x3e,0x0d,0x0a,0x09,0x49,0x74,0x20,0x69,0x73,0x20,0x6e,0x65,0x63,0x65,0x73,0x73, /* >...It is necess */ \
	0x61,0x72,0x79,0x20,0x74,0x6f,0x20,0x63,0x6c,0x65,0x61,0x72,0x20,0x74,0x68,0x65, /* ary to clear the */ \
	0x20,0x61,0x64,0x64,0x72,0x65,0x73,0x73,0x20,0x63,0x61,0x63,0x68,0x65,0x73,0x20, /*  address caches  */ \
	0x69,0x6e,0x20,0x79,0x6f,0x75,0x72,0x20,0x77,0x65,0x62,0x20,0x62,0x72,0x6f,0x77, /* in your web brow */ \
	0x73,0x65,0x72,0x20,0x61,0x6e,0x64,0x20,0x4f,0x53,0x2e,0x0d,0x0a,0x09,0x46,0x72, /* ser and OS....Fr */ \
	0x6f,0x6d,0x20,0x74,0x68,0x65,0x20,0x63,0x6f,0x6d,0x6d,0x61,0x6e,0x64,0x20,0x70, /* om the command p */ \
	0x72,0x6f,0x6d,0x70,0x74,0x20,0x69,0x6e,0x20,0x57,0x69,0x6e,0x64,0x6f,0x77,0x73, /* rompt in Windows */ \
	0x2c,0x20,0x65,0x6e,0x74,0x65,0x72,0x20,0x22,0x6e,0x62,0x74,0x73,0x74,0x61,0x74, /* , enter "nbtstat */ \
	0x26,0x6e,0x62,0x73,0x70,0x3b,0x2d,0x52,0x22,0x20,0x74,0x6f,0x20,0x63,0x6c,0x65, /* &nbsp;-R" to cle */ \
	0x61,0x72,0x20,0x74,0x68,0x65,0x20,0x68,0x6f,0x73,0x74,0x6e,0x61,0x6d,0x65,0x20, /* ar the hostname  */ \
	0x63,0x61,0x63,0x68,0x65,0x2c,0x20,0x0d,0x0a,0x09,0x63,0x6c,0x6f,0x73,0x65,0x20  /* cache, ...close  */
#define DATACHUNK00001c \
	0x79,0x6f,0x75,0x72,0x20,0x63,0x75,0x72,0x72,0x65,0x6e,0x74,0x20,0x77,0x65,0x62, /* your current web */ \
	0x20,0x62,0x72,0x6f,0x77,0x73,0x65,0x72,0x2c,0x20,0x6f,0x70,0x65,0x6e,0x20,0x61, /*  browser, open a */ \
	0x20,0x6e,0x65,0x77,0x20,0x77,0x65,0x62,0x20,0x62,0x72,0x6f,0x77,0x73,0x65,0x72, /*  new web browser */ \
	0x2c,0x20,0x61,0x6e,0x64,0x20,0x74,0x68,0x65,0x6e,0x20,0x74,0x72,0x79,0x20,0x74, /* , and then try t */ \
	0x6f,0x20,0x61,0x63,0x63,0x65,0x73,0x73,0x20,0x74,0x68,0x65,0x20,0x77,0x65,0x62, /* o access the web */ \
	0x20,0x61,0x64,0x64,0x72,0x65,0x73,0x73,0x20,0x61,0x62,0x6f,0x76,0x65,0x2e,0x3c, /*  address above.< */ \
	0x2f,0x6c,0x69,0x3e,0x0d,0x0a,0x3c,0x6c,0x69,0x20,0x73,0x74,0x79,0x6c,0x65,0x3d, /* /li>..<li style= */ \
	0x22,0x6d,0x61,0x72,0x67,0x69,0x6e,0x2d,0x62,0x6f,0x74,0x74,0x6f,0x6d,0x3a,0x31, /* "margin-bottom:1 */ \
	0x30,0x70,0x78,0x22,0x3e,0x3c,0x62,0x3e,0x44,0x69,0x64,0x20,0x79,0x6f,0x75,0x20, /* 0px"><b>Did you  */ \
	0x74,0x72,0x79,0x20,0x74,0x68,0x65,0x20,0x49,0x50,0x20,0x61,0x64,0x64,0x72,0x65, /* try the IP addre */ \
	0x73,0x73,0x3f,0x3c,0x2f,0x62,0x3e,0x3c,0x62,0x72,0x20,0x2f,0x3e,0x0d,0x0a,0x09, /* ss?</b><br />... */ \
	0x54,0x72,0x79,0x20,0x61,0x63,0x63,0x65,0x73,0x73,0x69,0x6e,0x67,0x20,0x74,0x68, /* Try accessing th */ \
	0x65,0x20,0x62,0x6f,0x61,0x72,0x64,0x20,0x64,0x69,0x72,0x65,0x63,0x74,0x6c,0x79, /* e board directly */ \
	0x20,0x61,0x74,0x20,0x74,0x68,0x65,0x20,0x49,0x50,0x20,0x61,0x64,0x64,0x72,0x65, /*  at the IP addre */ \
	0x73,0x73,0x20,0x73,0x68,0x6f,0x77,0x6e,0x20,0x6f,0x6e,0x20,0x74,0x68,0x65,0x20, /* ss shown on the  */ \
	0x4c,0x43,0x44,0x20,0x73,0x63,0x72,0x65,0x65,0x6e,0x2e,0x0d,0x0a,0x09,0x28,0x65, /* LCD screen....(e */ \
	0x78,0x3a,0x20,0x65,0x6e,0x74,0x65,0x72,0x20,0x22,0x68,0x74,0x74,0x70,0x3a,0x2f, /* x: enter "http:/ */ \
	0x2f,0x31,0x39,0x32,0x2e,0x31,0x36,0x38,0x2e,0x35,0x2e,0x32,0x33,0x2f,0x22,0x20, /* /192.168.5.23/"  */ \
	0x69,0x6e,0x74,0x6f,0x20,0x79,0x6f,0x75,0x72,0x20,0x62,0x72,0x6f,0x77,0x73,0x65, /* into your browse */ \
	0x72,0x29,0x2e,0x20,0x20,0x49,0x66,0x20,0x74,0x68,0x69,0x73,0x20,0x66,0x61,0x69, /* r).  If this fai */ \
	0x6c,0x73,0x2c,0x20,0x74,0x68,0x65,0x6e,0x20,0x0d,0x0a,0x09,0x74,0x68,0x65,0x20, /* ls, then ...the  */ \
	0x49,0x50,0x20,0x61,0x64,0x64,0x72,0x65,0x73,0x73,0x20,0x79,0x6f,0x75,0x20,0x73, /* IP address you s */ \
	0x65,0x74,0x20,0x69,0x73,0x20,0x6e,0x6f,0x74,0x20,0x72,0x65,0x61,0x63,0x68,0x61, /* et is not reacha */ \
	0x62,0x6c,0x65,0x2e,0x20,0x20,0x54,0x72,0x79,0x20,0x74,0x68,0x65,0x20,0x73,0x74, /* ble.  Try the st */ \
	0x65,0x70,0x20,0x62,0x65,0x6c,0x6f,0x77,0x2e,0x3c,0x2f,0x6c,0x69,0x3e,0x0d,0x0a, /* ep below.</li>.. */ \
	0x3c,0x6c,0x69,0x3e,0x3c,0x62,0x3e,0x53,0x74,0x69,0x6c,0x6c,0x20,0x6e,0x6f,0x74, /* <li><b>Still not */ \
	0x20,0x77,0x6f,0x72,0x6b,0x69,0x6e,0x67,0x3f,0x3c,0x2f,0x62,0x3e,0x3c,0x62,0x72, /*  working?</b><br */ \
	0x20,0x2f,0x3e,0x0d,0x0a,0x09,0x59,0x6f,0x75,0x20,0x63,0x61,0x6e,0x20,0x72,0x65, /*  />...You can re */ \
	0x73,0x74,0x6f,0x72,0x65,0x20,0x63,0x6f,0x6d,0x70,0x69,0x6c,0x65,0x2d,0x74,0x69, /* store compile-ti */ \
	0x6d,0x65,0x20,0x73,0x65,0x74,0x74,0x69,0x6e,0x67,0x73,0x20,0x62,0x79,0x20,0x63, /* me settings by c */ \
	0x6c,0x65,0x61,0x72,0x69,0x6e,0x67,0x20,0x74,0x68,0x65,0x20,0x62,0x6f,0x61,0x72, /* learing the boar */ \
	0x64,0x27,0x73,0x20,0x45,0x45,0x50,0x52,0x4f,0x4d,0x2e,0x20,0x48,0x6f,0x6c,0x64, /* d's EEPROM. Hold */ \
	0x0d,0x0a,0x09,0x42,0x54,0x4e,0x30,0x20,0x28,0x72,0x69,0x67,0x68,0x74,0x20,0x6d, /* ...BTN0 (right m */ \
	0x6f,0x73,0x74,0x20,0x62,0x75,0x74,0x74,0x6f,0x6e,0x20,0x6f,0x6e,0x20,0x50,0x49, /* ost button on PI */ \
	0x43,0x44,0x45,0x4d,0x2e,0x6e,0x65,0x74,0x3c,0x73,0x75,0x70,0x3e,0x54,0x4d,0x3c, /* CDEM.net<sup>TM< */ \
	0x2f,0x73,0x75,0x70,0x3e,0x20,0x32,0x20,0x61,0x6e,0x64,0x20,0x45,0x78,0x70,0x6c, /* /sup> 2 and Expl */ \
	0x6f,0x72,0x65,0x72,0x20,0x31,0x36,0x29,0x20,0x61,0x6e,0x64,0x20,0x70,0x72,0x65, /* orer 16) and pre */ \
	0x73,0x73,0x20,0x4d,0x43,0x4c,0x52,0x2e,0x20,0x0d,0x0a,0x09,0x43,0x6f,0x6e,0x74, /* ss MCLR. ...Cont */ \
	0x69,0x6e,0x75,0x65,0x20,0x68,0x6f,0x6c,0x64,0x69,0x6e,0x67,0x20,0x42,0x54,0x4e, /* inue holding BTN */ \
	0x30,0x20,0x75,0x6e,0x74,0x69,0x6c,0x20,0x74,0x68,0x65,0x20,0x4c,0x45,0x44,0x73, /* 0 until the LEDs */ \
	0x20,0x66,0x6c,0x61,0x73,0x68,0x2e,0x20,0x20,0x52,0x65,0x6c,0x65,0x61,0x73,0x65, /*  flash.  Release */ \
	0x20,0x42,0x54,0x4e,0x30,0x20,0x61,0x6e,0x64,0x20,0x70,0x72,0x65,0x73,0x73,0x20, /*  BTN0 and press  */ \
	0x4d,0x43,0x4c,0x52,0x20,0x61,0x67,0x61,0x69,0x6e,0x2e,0x20,0x0d,0x0a,0x09,0x54, /* MCLR again. ...T */ \
	0x68,0x69,0x73,0x20,0x70,0x72,0x6f,0x63,0x65,0x64,0x75,0x72,0x65,0x20,0x72,0x65, /* his procedure re */ \
	0x73,0x74,0x6f,0x72,0x65,0x73,0x20,0x74,0x68,0x65,0x20,0x63,0x6f,0x6e,0x66,0x69, /* stores the confi */ \
	0x67,0x75,0x72,0x61,0x74,0x69,0x6f,0x6e,0x20,0x73,0x65,0x74,0x74,0x69,0x6e,0x67, /* guration setting */ \
	0x73,0x20,0x69,0x6e,0x20,0x3c,0x63,0x6f,0x64,0x65,0x3e,0x54,0x43,0x50,0x49,0x50, /* s in <code>TCPIP */ \
	0x43,0x6f,0x6e,0x66,0x69,0x67,0x2e,0x68,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x2e, /* Config.h</code>. */ \
	0x20,0x0d,0x0a,0x09,0x59,0x6f,0x75,0x27,0x6c,0x6c,0x20,0x62,0x65,0x20,0x61,0x62, /*  ...You'll be ab */ \
	0x6c,0x65,0x20,0x74,0x6f,0x20,0x61,0x63,0x63,0x65,0x73,0x73,0x20,0x74,0x68,0x65, /* le to access the */ \
	0x20,0x62,0x6f,0x61,0x72,0x64,0x20,0x61,0x73,0x20,0x79,0x6f,0x75,0x20,0x64,0x69, /*  board as you di */ \
	0x64,0x20,0x77,0x68,0x65,0x6e,0x20,0x66,0x69,0x72,0x73,0x74,0x20,0x63,0x6f,0x6e, /* d when first con */ \
	0x6e,0x65,0x63,0x74,0x69,0x6e,0x67,0x2e,0x20,0x20,0x53,0x65,0x65,0x20,0x74,0x68, /* necting.  See th */ \
	0x65,0x20,0x0d,0x0a,0x09,0x4d,0x69,0x63,0x72,0x6f,0x63,0x68,0x69,0x70,0x20,0x54, /* e ...Microchip T */ \
	0x43,0x50,0x2f,0x49,0x50,0x20,0x53,0x74,0x61,0x63,0x6b,0x20,0x48,0x65,0x6c,0x70, /* CP/IP Stack Help */ \
	0x20,0x64,0x69,0x73,0x74,0x72,0x69,0x62,0x75,0x74,0x65,0x64,0x20,0x77,0x69,0x74, /*  distributed wit */ \
	0x68,0x20,0x74,0x68,0x65,0x20,0x73,0x74,0x61,0x63,0x6b,0x20,0x66,0x6f,0x72,0x20, /* h the stack for  */ \
	0x69,0x6e,0x73,0x74,0x72,0x75,0x63,0x74,0x69,0x6f,0x6e,0x73,0x2e,0x0d,0x0a,0x09, /* instructions.... */ \
	0x28,0x49,0x66,0x20,0x79,0x6f,0x75,0x20,0x61,0x72,0x65,0x20,0x75,0x73,0x69,0x6e, /* (If you are usin */ \
	0x67,0x20,0x61,0x6e,0x20,0x4d,0x50,0x4c,0x41,0x42,0x20,0x49,0x43,0x44,0x20,0x33, /* g an MPLAB ICD 3 */ \
	0x20,0x6f,0x72,0x20,0x4d,0x50,0x4c,0x41,0x42,0x20,0x52,0x45,0x41,0x4c,0x20,0x49, /*  or MPLAB REAL I */ \
	0x43,0x45,0x3c,0x73,0x75,0x70,0x3e,0x54,0x4d,0x3c,0x2f,0x73,0x75,0x70,0x3e,0x20, /* CE<sup>TM</sup>  */ \
	0x69,0x6e,0x20,0x64,0x65,0x62,0x75,0x67,0x20,0x6d,0x6f,0x64,0x65,0x2c,0x20,0x0d, /* in debug mode, . */ \
	0x0a,0x09,0x4d,0x43,0x4c,0x52,0x20,0x77,0x69,0x6c,0x6c,0x20,0x6e,0x6f,0x74,0x20  /* ..MCLR will not  */
#define DATACHUNK00001d \
	0x77,0x6f,0x72,0x6b,0x20,0x61,0x6e,0x64,0x20,0x79,0x6f,0x75,0x27,0x6c,0x6c,0x20, /* work and you'll  */ \
	0x6e,0x65,0x65,0x64,0x20,0x74,0x6f,0x20,0x72,0x65,0x73,0x65,0x74,0x20,0x74,0x68, /* need to reset th */ \
	0x65,0x20,0x62,0x6f,0x61,0x72,0x64,0x20,0x76,0x69,0x61,0x20,0x74,0x68,0x65,0x20, /* e board via the  */ \
	0x4d,0x50,0x4c,0x41,0x42,0x20,0x49,0x44,0x45,0x2e,0x29,0x3c,0x2f,0x6c,0x69,0x3e, /* MPLAB IDE.)</li> */ \
	0x0d,0x0a,0x3c,0x2f,0x6f,0x6c,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d, /* ..</ol>..</div>. */ \
	0x0a,0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x6c,0x61,0x6e,0x67,0x75, /* ...<script langu */ \
	0x61,0x67,0x65,0x3d,0x22,0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22, /* age="javascript" */ \
	0x3e,0x0d,0x0a,0x3c,0x21,0x2d,0x2d,0x0d,0x0a,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f, /* >..<!--..functio */ \
	0x6e,0x20,0x72,0x65,0x62,0x6f,0x6f,0x74,0x44,0x75,0x6d,0x6d,0x79,0x28,0x78,0x29, /* n rebootDummy(x) */ \
	0x7b,0x7d,0x0d,0x0a,0x73,0x65,0x74,0x54,0x69,0x6d,0x65,0x6f,0x75,0x74,0x28,0x22, /* {}..setTimeout(" */ \
	0x6e,0x65,0x77,0x41,0x4a,0x41,0x58,0x43,0x6f,0x6d,0x6d,0x61,0x6e,0x64,0x28,0x27, /* newAJAXCommand(' */ \
	0x2f,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x72,0x65,0x62,0x6f,0x6f,0x74,0x2e, /* /protect/reboot. */ \
	0x63,0x67,0x69,0x27,0x2c,0x72,0x65,0x62,0x6f,0x6f,0x74,0x44,0x75,0x6d,0x6d,0x79, /* cgi',rebootDummy */ \
	0x2c,0x66,0x61,0x6c,0x73,0x65,0x29,0x3b,0x22,0x2c,0x35,0x30,0x30,0x29,0x3b,0x0d, /* ,false);",500);. */ \
	0x0a,0x2f,0x2f,0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70,0x74, /* .//-->..</script */ \
	0x3e,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69, /* >..~inc:footer.i */ \
	0x6e,0x63,0x7e,0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0x0c,0x01,0x00,0x00,0x2e, /* nc~....3........ */ \
	0x00,0x00,0x00,0x22,0x01,0x00,0x00,0x2e,0x00,0x00,0x00,0x75,0x07,0x00,0x00,0x02, /* ...".......u.... */ \
	0x00,0x00,0x00,0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69, /* ...~inc:header.i */ \
	0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x63,0x6f, /* nc~..<div id="co */ \
	0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x53, /* ntent">....<h1>S */ \
	0x4e,0x4d,0x50,0x20,0x43,0x6f,0x6d,0x6d,0x75,0x6e,0x69,0x74,0x79,0x20,0x43,0x6f, /* NMP Community Co */ \
	0x6e,0x66,0x69,0x67,0x75,0x72,0x61,0x74,0x69,0x6f,0x6e,0x3c,0x2f,0x68,0x31,0x3e, /* nfiguration</h1> */ \
	0x0d,0x0a,0x3c,0x70,0x3e,0x52,0x65,0x61,0x64,0x2f,0x57,0x72,0x69,0x74,0x65,0x20, /* ..<p>Read/Write  */ \
	0x43,0x6f,0x6d,0x6d,0x75,0x6e,0x69,0x74,0x79,0x20,0x53,0x74,0x72,0x69,0x6e,0x67, /* Community String */ \
	0x20,0x63,0x6f,0x6e,0x66,0x69,0x67,0x75,0x72,0x61,0x74,0x69,0x6f,0x6e,0x20,0x66, /*  configuration f */ \
	0x6f,0x72,0x20,0x53,0x4e,0x4d,0x50,0x76,0x32,0x63,0x20,0x41,0x67,0x65,0x6e,0x74, /* or SNMPv2c Agent */ \
	0x2e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x63,0x6c,0x61,0x73, /* .</p>..<div clas */ \
	0x73,0x3d,0x22,0x72,0x65,0x73,0x75,0x6c,0x74,0x20,0x66,0x61,0x69,0x6c,0x22,0x20, /* s="result fail"  */ \
	0x73,0x74,0x79,0x6c,0x65,0x3d,0x22,0x64,0x69,0x73,0x70,0x6c,0x61,0x79,0x3a,0x7e, /* style="display:~ */ \
	0x73,0x6e,0x6d,0x70,0x5f,0x65,0x6e,0x7e,0x22,0x3e,0x0d,0x0a,0x53,0x54,0x41,0x43, /* snmp_en~">..STAC */ \
	0x4b,0x5f,0x55,0x53,0x45,0x5f,0x53,0x4e,0x4d,0x50,0x5f,0x53,0x45,0x52,0x56,0x45, /* K_USE_SNMP_SERVE */ \
	0x52,0x20,0x69,0x73,0x20,0x75,0x6e,0x64,0x65,0x66,0x69,0x6e,0x65,0x64,0x2e,0x20, /* R is undefined.  */ \
	0x20,0x53,0x4e,0x4d,0x50,0x20,0x69,0x73,0x20,0x75,0x6e,0x61,0x76,0x61,0x69,0x6c, /*  SNMP is unavail */ \
	0x61,0x62,0x6c,0x65,0x2e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d, /* able...</div>... */ \
	0x0a,0x3c,0x70,0x3e,0x43,0x6f,0x6e,0x66,0x69,0x67,0x75,0x72,0x65,0x20,0x6d,0x75, /* .<p>Configure mu */ \
	0x6c,0x74,0x69,0x70,0x6c,0x65,0x20,0x63,0x6f,0x6d,0x6d,0x75,0x6e,0x69,0x74,0x79, /* ltiple community */ \
	0x20,0x6e,0x61,0x6d,0x65,0x73,0x20,0x69,0x66,0x20,0x79,0x6f,0x75,0x20,0x77,0x61, /*  names if you wa */ \
	0x6e,0x74,0x20,0x74,0x68,0x65,0x20,0x53,0x4e,0x4d,0x50,0x20,0x61,0x67,0x65,0x6e, /* nt the SNMP agen */ \
	0x74,0x20,0x0d,0x0a,0x74,0x6f,0x20,0x72,0x65,0x73,0x70,0x6f,0x6e,0x64,0x20,0x74, /* t ..to respond t */ \
	0x6f,0x20,0x74,0x68,0x65,0x20,0x4e,0x4d,0x53,0x2f,0x53,0x4e,0x4d,0x50,0x20,0x6d, /* o the NMS/SNMP m */ \
	0x61,0x6e,0x61,0x67,0x65,0x72,0x20,0x77,0x69,0x74,0x68,0x20,0x64,0x69,0x66,0x66, /* anager with diff */ \
	0x65,0x72,0x65,0x6e,0x74,0x20,0x72,0x65,0x61,0x64,0x20,0x61,0x6e,0x64,0x20,0x77, /* erent read and w */ \
	0x72,0x69,0x74,0x65,0x20,0x0d,0x0a,0x63,0x6f,0x6d,0x6d,0x75,0x6e,0x69,0x74,0x79, /* rite ..community */ \
	0x20,0x6e,0x61,0x6d,0x65,0x73,0x2e,0x20,0x49,0x66,0x20,0x6c,0x65,0x73,0x73,0x20, /*  names. If less  */ \
	0x74,0x68,0x61,0x6e,0x20,0x74,0x68,0x72,0x65,0x65,0x20,0x63,0x6f,0x6d,0x6d,0x75, /* than three commu */ \
	0x6e,0x69,0x74,0x69,0x65,0x73,0x20,0x61,0x72,0x65,0x20,0x6e,0x65,0x65,0x64,0x65, /* nities are neede */ \
	0x64,0x2c,0x20,0x6c,0x65,0x61,0x76,0x65,0x20,0x0d,0x0a,0x65,0x78,0x74,0x72,0x61, /* d, leave ..extra */ \
	0x20,0x66,0x69,0x65,0x6c,0x64,0x73,0x20,0x62,0x6c,0x61,0x6e,0x6b,0x20,0x74,0x6f, /*  fields blank to */ \
	0x20,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x20,0x74,0x68,0x65,0x6d,0x2e,0x3c,0x2f, /*  disable them.</ */ \
	0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x0d,0x0a,0x3c,0x66,0x6f,0x72,0x6d,0x20,0x6d,0x65, /* p>......<form me */ \
	0x74,0x68,0x6f,0x64,0x3d,0x22,0x70,0x6f,0x73,0x74,0x22,0x20,0x61,0x63,0x74,0x69, /* thod="post" acti */ \
	0x6f,0x6e,0x3d,0x22,0x2f,0x73,0x6e,0x6d,0x70,0x2f,0x73,0x6e,0x6d,0x70,0x63,0x6f, /* on="/snmp/snmpco */ \
	0x6e,0x66,0x69,0x67,0x2e,0x68,0x74,0x6d,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22, /* nfig.htm" name=" */ \
	0x63,0x6f,0x6e,0x66,0x69,0x67,0x22,0x3e,0x0d,0x0a,0x3c,0x66,0x69,0x65,0x6c,0x64, /* config">..<field */ \
	0x73,0x65,0x74,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61, /* set>....<div><la */ \
	0x62,0x65,0x6c,0x3e,0x52,0x65,0x61,0x64,0x20,0x43,0x6f,0x6d,0x6d,0x31,0x20,0x3a, /* bel>Read Comm1 : */ \
	0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74, /* </label>..<input */ \
	0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d, /*  type="text" nam */ \
	0x65,0x3d,0x22,0x72,0x63,0x6d,0x30,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22, /* e="rcm0" value=" */ \
	0x7e,0x72,0x65,0x61,0x64,0x5f,0x63,0x6f,0x6d,0x6d,0x28,0x30,0x29,0x7e,0x22,0x20, /* ~read_comm(0)~"  */ \
	0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c, /* /></div>..<div>< */ \
	0x6c,0x61,0x62,0x65,0x6c,0x3e,0x52,0x65,0x61,0x64,0x20,0x43,0x6f,0x6d,0x6d,0x32, /* label>Read Comm2 */ \
	0x20,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70  /*  :</label>..<inp */
#define DATACHUNK00001e \
	0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e, /* ut type="text" n */ \
	0x61,0x6d,0x65,0x3d,0x22,0x72,0x63,0x6d,0x31,0x22,0x20,0x76,0x61,0x6c,0x75,0x65, /* ame="rcm1" value */ \
	0x3d,0x22,0x7e,0x72,0x65,0x61,0x64,0x5f,0x63,0x6f,0x6d,0x6d,0x28,0x31,0x29,0x7e, /* ="~read_comm(1)~ */ \
	0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76, /* " /></div>..<div */ \
	0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x52,0x65,0x61,0x64,0x20,0x43,0x6f,0x6d, /* ><label>Read Com */ \
	0x6d,0x33,0x20,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69, /* m3 :</label>..<i */ \
	0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22, /* nput type="text" */ \
	0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x72,0x63,0x6d,0x32,0x22,0x20,0x76,0x61,0x6c, /*  name="rcm2" val */ \
	0x75,0x65,0x3d,0x22,0x7e,0x72,0x65,0x61,0x64,0x5f,0x63,0x6f,0x6d,0x6d,0x28,0x32, /* ue="~read_comm(2 */ \
	0x29,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a, /* )~" /></div>.... */ \
	0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x57,0x72, /* ..<div><label>Wr */ \
	0x69,0x74,0x65,0x20,0x43,0x6f,0x6d,0x6d,0x31,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65, /* ite Comm1:</labe */ \
	0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d, /* l>..<input type= */ \
	0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x77,0x63,0x6d, /* "text" name="wcm */ \
	0x30,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x77,0x72,0x69,0x74,0x65, /* 0" value="~write */ \
	0x5f,0x63,0x6f,0x6d,0x6d,0x28,0x30,0x29,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64, /* _comm(0)~" /></d */ \
	0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c, /* iv>..<div><label */ \
	0x3e,0x57,0x72,0x69,0x74,0x65,0x20,0x43,0x6f,0x6d,0x6d,0x32,0x3a,0x3c,0x2f,0x6c, /* >Write Comm2:</l */ \
	0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79, /* abel>..<input ty */ \
	0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22, /* pe="text" name=" */ \
	0x77,0x63,0x6d,0x31,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x77,0x72, /* wcm1" value="~wr */ \
	0x69,0x74,0x65,0x5f,0x63,0x6f,0x6d,0x6d,0x28,0x31,0x29,0x7e,0x22,0x20,0x2f,0x3e, /* ite_comm(1)~" /> */ \
	0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61, /* </div>..<div><la */ \
	0x62,0x65,0x6c,0x3e,0x57,0x72,0x69,0x74,0x65,0x20,0x43,0x6f,0x6d,0x6d,0x33,0x3a, /* bel>Write Comm3: */ \
	0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74, /* </label>..<input */ \
	0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d, /*  type="text" nam */ \
	0x65,0x3d,0x22,0x77,0x63,0x6d,0x32,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22, /* e="wcm2" value=" */ \
	0x7e,0x77,0x72,0x69,0x74,0x65,0x5f,0x63,0x6f,0x6d,0x6d,0x28,0x32,0x29,0x7e,0x22, /* ~write_comm(2)~" */ \
	0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x64,0x69, /*  /></div>....<di */ \
	0x76,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a, /* v>&nbsp;</div>.. */ \
	0x3c,0x64,0x69,0x76,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65, /* <div><input type */ \
	0x3d,0x22,0x73,0x75,0x62,0x6d,0x69,0x74,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d, /* ="submit" class= */ \
	0x22,0x73,0x6d,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x53,0x61,0x76,0x65, /* "sm" value="Save */ \
	0x20,0x43,0x6f,0x6e,0x66,0x69,0x67,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76, /*  Config" /></div */ \
	0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x2f,0x66,0x69,0x65,0x6c,0x64,0x73,0x65,0x74,0x3e, /* >....</fieldset> */ \
	0x0d,0x0a,0x3c,0x2f,0x66,0x6f,0x72,0x6d,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76, /* ..</form>..</div */ \
	0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70,0x74,0x3e,0x0d,0x0a, /* >....</script>.. */ \
	0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e, /* ~inc:footer.inc~ */ \
	0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0xbc,0x00,0x00,0x00,0x49,0x00,0x00,0x00, /* ....3.......I... */ \
	0x9d,0x02,0x00,0x00,0x42,0x00,0x00,0x00,0xff,0x02,0x00,0x00,0x43,0x00,0x00,0x00, /* ....B.......C... */ \
	0x61,0x03,0x00,0x00,0x44,0x00,0x00,0x00,0xc7,0x03,0x00,0x00,0x45,0x00,0x00,0x00, /* a...D.......E... */ \
	0x2a,0x04,0x00,0x00,0x46,0x00,0x00,0x00,0x8d,0x04,0x00,0x00,0x47,0x00,0x00,0x00, /* ....F.......G... */ \
	0x2d,0x05,0x00,0x00,0x02,0x00,0x00,0x00                                          /* -.......         */


/**************************************
 * MPFS2 C linkable symbols
 **************************************/
// For C18, these are split into seperate arrays because it speeds up compilation a lot.  
// For other compilers, the entire data array must be defined as a single variable to 
// ensure that the linker does not reorder the data chunks in Flash when compiler 
// optimizations are turned on.
#if defined(__18CXX)
	ROM BYTE MPFS_Start[] = {DATACHUNK000000};
	ROM BYTE MPFS_000001[] = {DATACHUNK000001};
	ROM BYTE MPFS_000002[] = {DATACHUNK000002};
	ROM BYTE MPFS_000003[] = {DATACHUNK000003};
	ROM BYTE MPFS_000004[] = {DATACHUNK000004};
	ROM BYTE MPFS_000005[] = {DATACHUNK000005};
	ROM BYTE MPFS_000006[] = {DATACHUNK000006};
	ROM BYTE MPFS_000007[] = {DATACHUNK000007};
	ROM BYTE MPFS_000008[] = {DATACHUNK000008};
	ROM BYTE MPFS_000009[] = {DATACHUNK000009};
	ROM BYTE MPFS_00000a[] = {DATACHUNK00000a};
	ROM BYTE MPFS_00000b[] = {DATACHUNK00000b};
	ROM BYTE MPFS_00000c[] = {DATACHUNK00000c};
	ROM BYTE MPFS_00000d[] = {DATACHUNK00000d};
	ROM BYTE MPFS_00000e[] = {DATACHUNK00000e};
	ROM BYTE MPFS_00000f[] = {DATACHUNK00000f};
	ROM BYTE MPFS_000010[] = {DATACHUNK000010};
	ROM BYTE MPFS_000011[] = {DATACHUNK000011};
	ROM BYTE MPFS_000012[] = {DATACHUNK000012};
	ROM BYTE MPFS_000013[] = {DATACHUNK000013};
	ROM BYTE MPFS_000014[] = {DATACHUNK000014};
	ROM BYTE MPFS_000015[] = {DATACHUNK000015};
	ROM BYTE MPFS_000016[] = {DATACHUNK000016};
	ROM BYTE MPFS_000017[] = {DATACHUNK000017};
	ROM BYTE MPFS_000018[] = {DATACHUNK000018};
	ROM BYTE MPFS_000019[] = {DATACHUNK000019};
	ROM BYTE MPFS_00001a[] = {DATACHUNK00001a};
	ROM BYTE MPFS_00001b[] = {DATACHUNK00001b};
	ROM BYTE MPFS_00001c[] = {DATACHUNK00001c};
	ROM BYTE MPFS_00001d[] = {DATACHUNK00001d};
	ROM BYTE MPFS_00001e[] = {DATACHUNK00001e};
#else
	ROM BYTE MPFS_Start[] = {DATACHUNK000000, DATACHUNK000001, DATACHUNK000002, DATACHUNK000003, DATACHUNK000004, DATACHUNK000005, DATACHUNK000006, DATACHUNK000007, DATACHUNK000008, DATACHUNK000009, DATACHUNK00000a, DATACHUNK00000b, DATACHUNK00000c, DATACHUNK00000d, DATACHUNK00000e, DATACHUNK00000f, DATACHUNK000010, DATACHUNK000011, DATACHUNK000012, DATACHUNK000013, DATACHUNK000014, DATACHUNK000015, DATACHUNK000016, DATACHUNK000017, DATACHUNK000018, DATACHUNK000019, DATACHUNK00001a, DATACHUNK00001b, DATACHUNK00001c, DATACHUNK00001d, DATACHUNK00001e};
#endif


/**************************************************************
 * End of MPFS
 **************************************************************/
#endif // #if defined(STACK_USE_MPFS2)
#endif // #if !defined(MPFS_USE_EEPROM) && !defined(MPFS_USE_SPI_FLASH)
