/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOError;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;

public class TCPHashCalculatorUI
extends JFrame {
    private JButton btnCalc;
    private JButton btnQuit;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JTextField txtCRCHash;
    private JTextField txtDestMAC;

    public TCPHashCalculatorUI() {
        this.initComponents();
        this.setLocationRelativeTo(null);
        ImageIcon icon = new ImageIcon(this.getClass().getResource("Microchip.gif"));
        this.setIconImage(icon.getImage());
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.btnCalc = new JButton();
        this.jLabel2 = new JLabel();
        this.btnQuit = new JButton();
        this.txtDestMAC = new JTextField();
        this.txtCRCHash = new JTextField();
        this.jLabel3 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel6 = new JLabel();
        this.setDefaultCloseOperation(3);
        this.setTitle("Microchip Hash Table Filter Entry Calculator v1.01");
        this.setCursor(new Cursor(0));
        this.setResizable(false);
        this.jLabel1.setText("Destination MAC address:");
        this.btnCalc.setText("Calculate");
        this.btnCalc.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TCPHashCalculatorUI.this.btnCalcActionPerformed(evt);
            }
        });
        this.jLabel2.setText("CRC - Hash Table Settings:");
        this.btnQuit.setText("Quit");
        this.btnQuit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TCPHashCalculatorUI.this.btnQuitActionPerformed(evt);
            }
        });
        this.txtDestMAC.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TCPHashCalculatorUI.this.btnCalcActionPerformed(evt);
            }
        });
        this.txtCRCHash.setEditable(false);
        this.jLabel3.setText("CRC Polynomial (Reversed) - 0x4C11DB7");
        this.jLabel5.setText("Initial CRC Value - 0xFFFFFFFF");
        this.jLabel4.setText("This tool is used to calculate the CRC and register bit values for the Hash Table Receive");
        this.jLabel6.setText("Filter used by the PIC18FXXJ60, ENC28J60, and ENCX24J600 Ethernet controllers.");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel6).addComponent(this.jLabel4).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3).addGap(18, 18, 18).addComponent(this.jLabel5)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addGap(166, 166, 166)).addComponent(this.jLabel1).addComponent(this.txtDestMAC, -1, 333, Short.MAX_VALUE).addComponent(this.txtCRCHash, GroupLayout.Alignment.TRAILING, -1, 333, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.btnQuit, -1, -1, Short.MAX_VALUE).addComponent(this.btnCalc)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel6).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel1, -2, 15, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtDestMAC, -2, -1, -2).addComponent(this.btnCalc)).addGap(9, 9, 9).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtCRCHash, -2, -1, -2).addComponent(this.btnQuit)).addContainerGap()));
        this.pack();
    }

    private void btnCalcActionPerformed(ActionEvent evt) {
        try {
            VariableCRC32 checksum = new VariableCRC32(79764919, -1);
            String input = this.txtDestMAC.getText();
            String[] parsedInput = input.split(":");
            if (parsedInput.length != 6) {
                if (input.length() != 12) {
                    throw new IOError(null);
                }
                parsedInput = new String[6];
                for (int i = 0; i < 6; ++i) {
                    parsedInput[i] = input.substring(i << 1, (i << 1) + 2);
                }
            }
            for (int x = 0; x < 6; ++x) {
                int value = Integer.parseInt(parsedInput[x], 16);
                if (value > 255) {
                    throw new IOError(null);
                }
                checksum.addByte(value);
            }
            char bit = (char)(checksum.getValue() >> 23 & 0x3FL);
            this.txtCRCHash.setText("CRC: " + Long.toHexString(checksum.getValue()).toUpperCase() + "h; bit" + Integer.toString(bit % 8) + " of EHT" + Integer.toString(bit / 8));
        }
        catch (Exception e) {
            try {
                JOptionPane.showMessageDialog(this, "The MAC address must have the form \"12:34:56:78:9A:BC\"", "Input Error", 0);
            }
            catch (Exception ex) {
                System.exit(0);
            }
        }
        catch (Error er) {
            try {
                JOptionPane.showMessageDialog(this, "The MAC address must have the form \"12:34:56:78:9A:BC\"", "Input Error", 0);
            }
            catch (Exception ex) {
                System.exit(0);
            }
        }
    }

    private void btnQuitActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            System.exit(0);
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new TCPHashCalculatorUI().setVisible(true);
            }
        });
    }
}

