/*
 * Decompiled with CFR 0.152.
 */
package mib2bib;

import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import mib2bib.mib2bib;

public class SnmpCommand {
    public int MAX_DATA_LEN = 256;
    public int MAX_INDEX_LEN = 255;
    public final int MAX_DYNAMIC_ID_SIZE = 1024;
    public int INDEX_CONSTANT = 0;
    public int INDEX_OID = 1;
    String[] dataTypeTable = new String[]{"BYTE", "WORD", "DWORD", "OCTET_STRING", "ASCII_STRING", "IP_ADDRESS", "COUNTER32", "TIME_TICKS", "GAUGE32", "OID"};
    String[] oidTypes = new String[]{"SINGLE", "SEQUENCE"};
    public int OID_TYPES_COUNT = 2;
    String[] oidAccessDictionary = new String[]{"READONLY", "READWRITE"};
    public int OID_STRING_LEN = 256;
    mib2bib mainMib2bib;
    Map<String, DATA_TYPE> dataTypeInfoMap;
    HashMap<String, OID_TYPE> NodeTypeMap;
    HashMap<String, OID_ACCESS> AccessTypeMap;
    Map<DATA_TYPE, Byte> dataTypeMapWithVal = new HashMap<DATA_TYPE, Byte>();
    public OID_NODE mibRoot;
    public List<OID_NODE> newOidNode;

    public SnmpCommand() {
        System.out.println("Snmp mib");
    }

    public SnmpCommand(mib2bib parent) {
        this.mainMib2bib = parent;
        this.dataTypeInfoMap = new HashMap<String, DATA_TYPE>();
        this.dataTypeInfoMap.put("BYTE", DATA_TYPE.INT8_VAL);
        this.dataTypeInfoMap.put("WORD", DATA_TYPE.INT16_VAL);
        this.dataTypeInfoMap.put("DWORD", DATA_TYPE.INT32_VAL);
        this.dataTypeInfoMap.put("OCTET_STRING", DATA_TYPE.OCTET_STRING);
        this.dataTypeInfoMap.put("ASCII_STRING", DATA_TYPE.ASCII_STRING);
        this.dataTypeInfoMap.put("IP_ADDRESS", DATA_TYPE.IP_ADDRESS);
        this.dataTypeInfoMap.put("COUNTER32", DATA_TYPE.COUNTER32);
        this.dataTypeInfoMap.put("TIME_TICKS", DATA_TYPE.TIME_TICKS);
        this.dataTypeInfoMap.put("GAUGE32", DATA_TYPE.GAUGE32);
        this.dataTypeInfoMap.put("OID", DATA_TYPE.OID_VAL);
        this.NodeTypeMap = new HashMap();
        this.NodeTypeMap.put("SINGLE", OID_TYPE.SINGLE);
        this.NodeTypeMap.put("SEQUENCE", OID_TYPE.SEQUENCE);
        this.AccessTypeMap = new HashMap();
        this.AccessTypeMap.put("READONLY", OID_ACCESS.OID_ACCESS_RO);
        this.AccessTypeMap.put("READWRITE", OID_ACCESS.OID_ACCESS_RW);
        this.dataTypeMapWithVal.put(DATA_TYPE.INT8_VAL, (byte)0);
        this.dataTypeMapWithVal.put(DATA_TYPE.INT16_VAL, (byte)1);
        this.dataTypeMapWithVal.put(DATA_TYPE.INT32_VAL, (byte)2);
        this.dataTypeMapWithVal.put(DATA_TYPE.OCTET_STRING, (byte)3);
        this.dataTypeMapWithVal.put(DATA_TYPE.ASCII_STRING, (byte)4);
        this.dataTypeMapWithVal.put(DATA_TYPE.IP_ADDRESS, (byte)5);
        this.dataTypeMapWithVal.put(DATA_TYPE.COUNTER32, (byte)6);
        this.dataTypeMapWithVal.put(DATA_TYPE.TIME_TICKS, (byte)7);
        this.dataTypeMapWithVal.put(DATA_TYPE.GAUGE32, (byte)8);
        this.dataTypeMapWithVal.put(DATA_TYPE.OID_VAL, (byte)9);
    }

    short setOidInfo(OID_INFO oidInfo, short oid_info_val) {
        switch (oidInfo) {
            case bIsDistantSibling: {
                oid_info_val = (short)(oid_info_val | 1);
                break;
            }
            case bIsConstant: {
                oid_info_val = (short)(oid_info_val | 2);
                break;
            }
            case bIsSequence: {
                oid_info_val = (short)(oid_info_val | 4);
                break;
            }
            case bIsSibling: {
                oid_info_val = (short)(oid_info_val | 8);
                break;
            }
            case bIsParent: {
                oid_info_val = (short)(oid_info_val | 0x10);
                break;
            }
            case bIsEditable: {
                oid_info_val = (short)(oid_info_val | 0x20);
                break;
            }
            case bIsAgentID: {
                oid_info_val = (short)(oid_info_val | 0x40);
                break;
            }
            case bIsIDPresent: {
                oid_info_val = (short)(oid_info_val | 0x80);
            }
        }
        return oid_info_val;
    }

    void clearOidInfo(OID_INFO oidInfo, byte oid_info_val) {
        switch (oidInfo) {
            case bIsDistantSibling: {
                oid_info_val = (byte)(oid_info_val & 0xFFFFFFFE);
                break;
            }
            case bIsConstant: {
                oid_info_val = (byte)(oid_info_val & 0xFFFFFFFD);
                break;
            }
            case bIsSequence: {
                oid_info_val = (byte)(oid_info_val & 0xFFFFFFFB);
                break;
            }
            case bIsSibling: {
                oid_info_val = (byte)(oid_info_val & 0xFFFFFFF7);
                break;
            }
            case bIsParent: {
                oid_info_val = (byte)(oid_info_val & 0xFFFFFFEF);
                break;
            }
            case bIsEditable: {
                oid_info_val = (byte)(oid_info_val & 0xFFFFFFDF);
                break;
            }
            case bIsAgentID: {
                oid_info_val = (byte)(oid_info_val & 0xFFFFFFBF);
                break;
            }
            case bIsIDPresent: {
                oid_info_val = (byte)(oid_info_val & 0xFFFFFF7F);
            }
        }
    }

    boolean getOidInfo(OID_INFO oidInfo, short oid_info_val) {
        boolean oidInfoVal = true;
        switch (oidInfo) {
            case bIsDistantSibling: {
                oidInfoVal = (oid_info_val & 1) != 0;
                break;
            }
            case bIsConstant: {
                oidInfoVal = (oid_info_val & 2) != 0;
                break;
            }
            case bIsSequence: {
                oidInfoVal = (oid_info_val & 4) != 0;
                break;
            }
            case bIsSibling: {
                oidInfoVal = (oid_info_val & 8) != 0;
                break;
            }
            case bIsParent: {
                oidInfoVal = (oid_info_val & 0x10) != 0;
                break;
            }
            case bIsEditable: {
                oidInfoVal = (oid_info_val & 0x20) != 0;
                break;
            }
            case bIsAgentID: {
                oidInfoVal = (oid_info_val & 0x40) != 0;
                break;
            }
            case bIsIDPresent: {
                oidInfoVal = (oid_info_val & 0x80) != 0;
            }
        }
        return oidInfoVal;
    }

    int IsThisParent(OID_NODE r) {
        return r.pChilds.size();
    }

    boolean IsThisSibling(OID_NODE r) {
        OID_NODE p = r.pParent;
        if (p != null) {
            for (int i = 0; i < p.pChilds.size(); ++i) {
                if (p.pChilds.get(i) != r || i >= p.pChilds.size() - 1) continue;
                return true;
            }
        }
        return false;
    }

    boolean IsValidName(String name) {
        int len = name.length();
        --len;
        boolean i = false;
        while (len >= 0) {
            if (len == 0 && Character.isDigit(name.charAt(len))) {
                return false;
            }
            if (name.charAt(len) == ' ' || name.charAt(len) == '+' || name.charAt(len) == '?' || name.charAt(len) == '-' || name.charAt(len) == '.' || name.charAt(len) == '\\' || name.charAt(len) == '/') {
                return false;
            }
            --len;
        }
        return true;
    }

    DATA_TYPE GetDataType(String type) {
        DATA_TYPE dataType = this.dataTypeInfoMap.get(type);
        if (dataType != null) {
            return dataType;
        }
        return DATA_TYPE.DATA_TYPE_UNKNOWN;
    }

    OID_TYPE GetNodeType(String typeString) {
        OID_TYPE oidType = this.NodeTypeMap.get(typeString);
        if (oidType != null) {
            return oidType;
        }
        return OID_TYPE.OID_TYPE_UNKNOWN;
    }

    OID_ACCESS GetOIDAccess(String accessString) {
        OID_ACCESS accessType = this.AccessTypeMap.get(accessString);
        if (accessType != null) {
            return accessType;
        }
        return OID_ACCESS.OID_ACCESS_UNKNOWN;
    }

    int ParseOIDString(String oidString, byte[] oid, int oidLen) {
        byte[] adjustedOID = new byte[10];
        int j = 0;
        oidLen = 0;
        String delimiters = "[.]";
        String[] tokens = oidString.split(delimiters);
        for (int i = 0; i < tokens.length; ++i) {
            int len = tokens[i].length();
            while (j < len) {
                if (!Character.isDigit(tokens[i].charAt(j))) {
                    return 0;
                }
                ++j;
            }
            long tempOID = Integer.decode(tokens[i]).intValue();
            if (tempOID <= 127L) {
                oid[oidLen++] = (byte)tempOID;
                continue;
            }
            long d = tempOID;
            int tempOidlen = 0;
            do {
                if (d > 127L) {
                    adjustedOID[tempOidlen] = tempOidlen == 0 ? (byte)(d % 128L) : (byte)(d % 128L + 128L);
                    ++tempOidlen;
                    continue;
                }
                adjustedOID[tempOidlen++] = (byte)(d + 128L);
            } while ((d /= 128L) > 0L);
            while (tempOidlen > 0) {
                oid[oidLen++] = adjustedOID[--tempOidlen];
            }
        }
        return oidLen;
    }

    OID_NODE AddRoot(byte oid) {
        if (this.mibRoot == null) {
            this.mibRoot = new OID_NODE();
            this.mibRoot.oid = oid;
            this.mibRoot.pChilds = new LinkedList<OID_NODE>();
            this.mibRoot.pIndex = new ArrayList<String>();
        } else if (this.mibRoot.oid != oid) {
            return null;
        }
        this.mibRoot.id = Integer.MAX_VALUE;
        this.mibRoot.oid_info_val = 0;
        this.mibRoot.oid_info_val = this.setOidInfo(OID_INFO.bIsParent, this.mibRoot.oid_info_val);
        this.mibRoot.siblingOffset = 0L;
        this.mibRoot.dataLen = 0;
        this.mibRoot.indexLen = 0;
        this.mibRoot.indexBytes = 0;
        this.mibRoot.oidType = OID_TYPE.OID_TYPE_UNKNOWN;
        this.mibRoot.recordOffset = 0L;
        return this.mibRoot;
    }

    OID_NODE AddChild(OID_NODE root, byte oid, boolean bIsDuplicate) {
        OID_NODE t;
        int i;
        bIsDuplicate = false;
        if (root == null) {
            return null;
        }
        if (root.pChilds == null) {
            return null;
        }
        for (i = 0; i < root.pChilds.size(); ++i) {
            t = root.pChilds.get(i);
            if (t == null) {
                return null;
            }
            if (oid < t.oid) break;
            if (t.oid != oid) continue;
            bIsDuplicate = true;
            return t;
        }
        if (!this.getOidInfo(OID_INFO.bIsParent, root.oid_info_val)) {
            return null;
        }
        if (root.pParent != null && ((OID_NODE)root).pParent.name != null) {
            return null;
        }
        t = new OID_NODE();
        t.pChilds = new LinkedList<OID_NODE>();
        t.pIndex = new ArrayList<String>();
        t.id = Integer.MAX_VALUE;
        t.oid_info_val = 0;
        t.oid_info_val = this.setOidInfo(OID_INFO.bIsParent, t.oid_info_val);
        t.siblingOffset = 0L;
        t.dataLen = 0;
        t.indexLen = 0;
        t.indexBytes = 0;
        t.oidType = OID_TYPE.OID_TYPE_UNKNOWN;
        t.recordOffset = 0L;
        t.oid = oid;
        t.pParent = root;
        if (i < root.pChilds.size()) {
            root.pChilds.add(i, t);
        } else {
            root.pChilds.add(t);
        }
        return t;
    }

    OID_NODE AddNode(String name, DATA_TYPE type, OID_TYPE oidType, OID_ACCESS access, byte[] oidBytes, int oidLen) {
        boolean lbIsDuplicate = false;
        OID_NODE root = this.AddRoot(oidBytes[0]);
        if (root == null) {
            return null;
        }
        for (int i = 1; i < oidLen; ++i) {
            if ((root = this.AddChild(root, oidBytes[i], lbIsDuplicate)) != null) continue;
            return null;
        }
        if (lbIsDuplicate) {
            return null;
        }
        root.oid_info_val = 0;
        root.dataType = type;
        if (oidType == OID_TYPE.SEQUENCE) {
            root.oid_info_val = this.setOidInfo(OID_INFO.bIsSequence, root.oid_info_val);
        }
        if (access == OID_ACCESS.OID_ACCESS_RW) {
            root.oid_info_val = this.setOidInfo(OID_INFO.bIsEditable, root.oid_info_val);
        }
        root.siblingOffset = 0L;
        root.dataLen = 0;
        root.indexLen = 0;
        root.indexBytes = 0;
        root.id = Integer.MAX_VALUE;
        root.name = name;
        root.oidType = oidType;
        return root;
    }

    OID_NODE LookupOIDName(OID_NODE root, String name) {
        OID_NODE t = new OID_NODE();
        if (root == null) {
            return null;
        }
        if (root.pChilds != null) {
            for (int i = 0; i < root.pChilds.size(); ++i) {
                t = this.LookupOIDName(root.pChilds.get(i), name);
                if (t == null) continue;
                return t;
            }
        }
        if (root.name != null && root.name.compareTo(name) == 0) {
            return root;
        }
        return null;
    }

    int intSwap(short val) {
        return val << 8 + (val >> 8 & 0xFF);
    }

    long intSwap(int val) {
        byte[] p = new byte[]{(byte)(val & 0xFF), (byte)(val >> 8 & 0xFF), (byte)(val >> 16 & 0xFF), (byte)(val >> 24 & 0xFF)};
        return ((long)p[0] << 24) + ((long)p[1] << 16) + ((long)p[2] << 8) + (long)p[3];
    }

    OID_NODE LookupID(OID_NODE r, long id) {
        if (r == null) {
            return null;
        }
        for (int i = 0; i < r.pChilds.size(); ++i) {
            OID_NODE t = this.LookupID(r.pChilds.get(i), id);
            if (t == null) continue;
            return t;
        }
        if (r.id == id) {
            return r;
        }
        return null;
    }

    int ValidateFile(String file) {
        File hFile = new File(file);
        if (this.mibRoot == null) {
            System.out.println(hFile.getName() + ": No MIB was created.\n");
            return 1;
        }
        return this.ValidateMIB(hFile, this.mibRoot);
    }

    int ValidateMIB(File file, OID_NODE r) {
        int liResult = 0;
        if (r == null) {
            return 1;
        }
        for (int i = 0; i < r.pChilds.size(); ++i) {
            liResult += this.ValidateMIB(file, r.pChilds.get(i));
        }
        if (this.getOidInfo(OID_INFO.bIsParent, r.oid_info_val)) {
            return liResult;
        }
        if (!this.getOidInfo(OID_INFO.bIsConstant, r.oid_info_val) && r.id > 1024L) {
            this.mainMib2bib.ShowError(file, r.line, mib2bib.FILE_ERROR_CODE.OID_DATA_SCOPE_UNKNOWN);
            ++liResult;
        }
        if (this.getOidInfo(OID_INFO.bIsConstant, r.oid_info_val) && r.dataLen == 0) {
            this.mainMib2bib.ShowError(file, r.line, mib2bib.FILE_ERROR_CODE.NO_OID_STATIC_VALUE);
            ++liResult;
        }
        if (this.getOidInfo(OID_INFO.bIsSequence, r.oid_info_val) && r.indexLen == 0) {
            this.mainMib2bib.ShowError(file, r.line, mib2bib.FILE_ERROR_CODE.NO_OID_INDEX);
            ++liResult;
        }
        return liResult;
    }

    boolean ProcessFile(String binFile, String incFile, boolean bOverwrite) {
        boolean lbResult = true;
        File hBinOutput = new File(binFile);
        File hIncOutput = new File(incFile);
        MIB_STATISTICS stat = new MIB_STATISTICS();
        if (this.mibRoot == null) {
            System.out.println("No MIB database was created.\n");
            return false;
        }
        if (hBinOutput.exists() && !bOverwrite) {
            System.out.println("Output BIB file " + hBinOutput.getName() + " already exists.\n");
            return false;
        }
        if (hIncOutput.exists() && !bOverwrite) {
            System.out.println("Output Inc file " + hIncOutput.getName() + " already exists.\n");
            return false;
        }
        try {
            FileOutputStream bin_file_output = new FileOutputStream(binFile);
            if (bin_file_output == null) {
                System.out.println("Error opening output BIB file " + hBinOutput.getName() + " for Write.\n");
                return false;
            }
            FileOutputStream inc_file_output = new FileOutputStream(incFile);
            DataOutputStream data_out = new DataOutputStream(inc_file_output);
            BufferedWriter fincout = new BufferedWriter(new OutputStreamWriter(data_out));
            if (fincout == null) {
                bin_file_output.close();
                System.out.println("Error opening output inc file" + hIncOutput.getName() + " for Write.\n");
                return false;
            }
            Date date = new Date();
            SimpleDateFormat sdf = new SimpleDateFormat("E MMM dd yyyy hh:mm:ss");
            fincout.write("/*\n * This file was automatically generated on " + sdf.format(date) + "\n" + " * by mib2bib utility.\n\n" + " * This file contains 'C' defines for dynamic OIDs and AgentID only.\n" + " * Do not modify this file manually.\n" + " * Include this file in your application source file that handles SNMP callbacks and TRAP.\n" + " */\n");
            this.PreprocessOutput(this.mibRoot, 0L);
            this.AssignOffset(this.mibRoot);
            lbResult = this.GenerateOutput(bin_file_output, fincout, this.mibRoot, stat);
            if (stat.totalAgentIDs < 1L) {
                System.out.println("Warning: No AgentID was defined.  Without AgentID, TRAP functionality is not available.\n");
            }
            if (lbResult) {
                System.out.println("BIB File Statistics: ");
                System.out.println("    Total Static OIDs         : " + stat.totalStaticOIDs);
                System.out.println("    Total Static data bytes   : " + stat.totalDataBytes);
                System.out.println("    Total Dynamic OIDs        : " + stat.totalDynamicOIDs);
                System.out.println("    (" + hIncOutput.getName() + "   entries)");
                System.out.println("    Total Read-Only OIDs      : " + stat.totalReadOnlyOIDs);
                System.out.println("    Total Read-Write OIDs     : " + stat.totalReadWriteOIDs);
                System.out.println("-------------------------------------------");
                System.out.println("    Total OIDs                : " + (stat.totalStaticOIDs + stat.totalDynamicOIDs));
                System.out.println("");
                System.out.println("    Total Sequence OIDs       : " + stat.totalSequenceOIDs);
                System.out.println("    Total AgentIDs            : " + stat.totalAgentIDs);
                System.out.println("===========================================");
                System.out.println("    Total MIB bytes           : " + stat.totalBytes);
                System.out.println("    (" + hBinOutput.getName() + "   size)\n");
            }
            bin_file_output.close();
            fincout.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        this.DeleteMIBTree(this.mibRoot);
        return lbResult;
    }

    int PreprocessOutput(OID_NODE r, long currentOffset) {
        r.recordOffset = currentOffset++;
        ++currentOffset;
        if (this.IsThisParent(r) == 0) {
            if (this.getOidInfo(OID_INFO.bIsIDPresent, r.oid_info_val)) {
                ++currentOffset;
                if (r.id <= 255L) {
                    ++currentOffset;
                } else if (r.id > 255L && r.id < 65535L) {
                    ++currentOffset;
                    ++currentOffset;
                }
            }
        } else {
            r.oid_info_val = this.setOidInfo(OID_INFO.bIsParent, r.oid_info_val);
        }
        if (this.GetSibling(r) != null) {
            r.oid_info_val = this.setOidInfo(OID_INFO.bIsSibling, r.oid_info_val);
            currentOffset += 2L;
        } else if (this.IsThisParent(r) == 0 && this.GetDistantSibling(r) != null) {
            r.oid_info_val = this.setOidInfo(OID_INFO.bIsDistantSibling, r.oid_info_val);
            currentOffset += 2L;
        }
        if (!this.getOidInfo(OID_INFO.bIsParent, r.oid_info_val)) {
            ++currentOffset;
        }
        if (r.dataLen > 0) {
            ++currentOffset;
            currentOffset += (long)r.dataLen;
        }
        if (r.indexBytes > 0) {
            ++currentOffset;
            currentOffset += (long)r.indexBytes;
        }
        for (int i = 0; i < r.pChilds.size(); ++i) {
            currentOffset = this.PreprocessOutput(r.pChilds.get(i), currentOffset);
        }
        return (int)currentOffset;
    }

    long GetDistantSiblingOffset(OID_NODE n) {
        OID_NODE s = this.GetDistantSibling(n);
        if (s != null) {
            return s.recordOffset;
        }
        return 0L;
    }

    OID_NODE GetFirstChildLeaf(OID_NODE n) {
        if (n.pChilds.size() > 0) {
            return this.GetFirstChildLeaf(n.pChilds.get(0));
        }
        return n;
    }

    OID_NODE GetDistantSibling(OID_NODE n) {
        OID_NODE p = n.pParent;
        if (p == null) {
            return null;
        }
        OID_NODE s = this.GetSibling(p);
        if (s == null) {
            return this.GetDistantSibling(p);
        }
        if (this.getOidInfo(OID_INFO.bIsParent, s.oid_info_val)) {
            return this.GetFirstChildLeaf(s);
        }
        return s;
    }

    long GetSiblingOffset(OID_NODE n) {
        OID_NODE s = this.GetSibling(n);
        if (s != null) {
            return s.recordOffset;
        }
        return 0L;
    }

    OID_NODE GetSibling(OID_NODE n) {
        OID_NODE p = n.pParent;
        if (p == null) {
            return null;
        }
        boolean lbLocated = false;
        for (int i = 0; i < p.pChilds.size(); ++i) {
            if (p.pChilds.get(i) == n) {
                lbLocated = true;
                continue;
            }
            if (!lbLocated) continue;
            return p.pChilds.get(i);
        }
        return null;
    }

    boolean AssignOffset(OID_NODE r) {
        if (this.getOidInfo(OID_INFO.bIsSibling, r.oid_info_val)) {
            r.siblingOffset = this.GetSiblingOffset(r);
            if (r.siblingOffset > 65535L) {
                return false;
            }
        }
        if (this.getOidInfo(OID_INFO.bIsDistantSibling, r.oid_info_val)) {
            r.distantSiblingOffset = this.GetDistantSiblingOffset(r);
            if (r.distantSiblingOffset > 65535L) {
                return false;
            }
        }
        for (int i = 0; i < r.pChilds.size(); ++i) {
            boolean lbReturn = this.AssignOffset(r.pChilds.get(i));
            if (lbReturn) continue;
            return false;
        }
        return true;
    }

    boolean GenerateOutput(FileOutputStream hBinOutput, BufferedWriter hIncOutput, OID_NODE r, MIB_STATISTICS stat) {
        byte[] oidRecord = new byte[512];
        int index = 0;
        oidRecord[index++] = r.oid;
        oidRecord[index++] = (byte)r.oid_info_val;
        try {
            int i;
            if (r.pChilds.size() == 0 && this.getOidInfo(OID_INFO.bIsIDPresent, r.oid_info_val)) {
                hIncOutput.write("#define " + r.name.toString() + "      " + r.id);
                if (this.getOidInfo(OID_INFO.bIsAgentID, r.oid_info_val)) {
                    ++stat.totalAgentIDs;
                    hIncOutput.write("\t\t// This is an Agent ID for use in SNMPNotify() only.\n");
                } else {
                    ++stat.totalDynamicOIDs;
                    hIncOutput.write("\t\t\t//" + r.oidASCIIString.toString() + " :  ");
                    if (this.getOidInfo(OID_INFO.bIsEditable, r.oid_info_val)) {
                        ++stat.totalReadWriteOIDs;
                        hIncOutput.write("READWRITE ");
                    } else {
                        ++stat.totalReadOnlyOIDs;
                        hIncOutput.write("READONLY ");
                    }
                    hIncOutput.write(r.dataTypeString + ".\n");
                }
                if (r.id <= 255L) {
                    oidRecord[index++] = 1;
                    oidRecord[index++] = (byte)r.id;
                } else if (r.id > 255L && r.id < 65535L) {
                    oidRecord[index++] = 2;
                    for (int j = 0; j < 2; ++j) {
                        int offset = (1 - j) * 8;
                        oidRecord[index++] = (byte)(r.id >> (byte)offset & 0xFFFFFFFFFFFFFFFFL);
                    }
                }
            }
            if (this.getOidInfo(OID_INFO.bIsSibling, r.oid_info_val)) {
                oidRecord[index++] = (byte)(r.siblingOffset & 0xFFL);
                oidRecord[index++] = (byte)(r.siblingOffset >> 8 & 0xFFL);
            }
            if (this.getOidInfo(OID_INFO.bIsDistantSibling, r.oid_info_val)) {
                oidRecord[index++] = (byte)(r.distantSiblingOffset & 0xFFL);
                oidRecord[index++] = (byte)(r.distantSiblingOffset >> 8 & 0xFFL);
            }
            if (!this.getOidInfo(OID_INFO.bIsParent, r.oid_info_val)) {
                Byte test = this.dataTypeMapWithVal.get((Object)r.dataType);
                oidRecord[index++] = test;
            }
            if (this.getOidInfo(OID_INFO.bIsConstant, r.oid_info_val)) {
                ++stat.totalStaticOIDs;
                oidRecord[index++] = (byte)r.dataLen;
                for (i = 0; i < r.dataLen; ++i) {
                    ++stat.totalDataBytes;
                    oidRecord[index++] = r.data[i];
                }
            }
            if (this.getOidInfo(OID_INFO.bIsSequence, r.oid_info_val)) {
                ++stat.totalSequenceOIDs;
                oidRecord[index++] = (byte)r.indexLen;
                for (i = 0; i < r.indexLen; ++i) {
                    oidRecord[index++] = (byte)r.idx[i].indexType;
                    if (r.idx[i].indexType == this.INDEX_CONSTANT) {
                        oidRecord[index++] = r.idx[i].constant;
                        continue;
                    }
                    if (r.idx[i].id <= 255L) {
                        oidRecord[index++] = 1;
                        oidRecord[index++] = (byte)r.idx[i].id;
                    } else if (r.idx[i].id > 255L && r.idx[i].id < 65535L) {
                        oidRecord[index++] = 2;
                        oidRecord[index++] = (byte)(r.idx[i].id >> 8 & 0xFFL);
                        oidRecord[index++] = (byte)(r.idx[i].id & 0xFFL);
                    }
                    Byte test = this.dataTypeMapWithVal.get((Object)r.idx[i].dataType);
                    oidRecord[index++] = test;
                }
            }
            hBinOutput.write(oidRecord, 0, index);
            stat.totalBytes += (long)index;
            for (i = 0; i < r.pChilds.size(); ++i) {
                boolean lbReturn = this.GenerateOutput(hBinOutput, hIncOutput, r.pChilds.get(i), stat);
                if (lbReturn) continue;
                return false;
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        return true;
    }

    void DeleteMIBTree(OID_NODE root) {
        if (root == null) {
            return;
        }
        if (root.pChilds != null) {
            for (int i = 0; i < root.pChilds.size(); ++i) {
                this.DeleteMIBTree(root.pChilds.get(i));
                if (root.pChilds != null && root.pChilds.size() > 0) {
                    root.pChilds.remove(i);
                }
                if (root.pIndex == null || root.pIndex.size() <= 0) continue;
                root.pIndex.remove(i);
            }
        }
    }

    class sequenceVar {
        public int MAX_NO_OF_INDEX = 1;

        sequenceVar() {
        }

        boolean HandleSequenceVar(List pList, File file, int line) {
            if (pList.size() != this.MAX_NO_OF_INDEX + 2) {
                SnmpCommand.this.mainMib2bib.ShowError(file, line, mib2bib.FILE_ERROR_CODE.SEQUENCE_OID_INVALID_ARGS);
                return false;
            }
            OID_NODE matchingNode = SnmpCommand.this.LookupOIDName(SnmpCommand.this.mibRoot, pList.get(1).toString());
            if (matchingNode == null) {
                SnmpCommand.this.mainMib2bib.ShowError(file, line, mib2bib.FILE_ERROR_CODE.OID_NOT_DEFINED);
                return false;
            }
            matchingNode.indexLen = 0;
            matchingNode.indexBytes = 0;
            for (int i = 2; i < pList.size(); ++i) {
                if (matchingNode.indexLen >= SnmpCommand.this.MAX_INDEX_LEN) {
                    SnmpCommand.this.mainMib2bib.ShowError(file, line, mib2bib.FILE_ERROR_CODE.INVALID_INDEX_COUNT);
                    return false;
                }
                OID_NODE matchingIndex = SnmpCommand.this.LookupOIDName(SnmpCommand.this.mibRoot, pList.get(i).toString());
                matchingNode.oid_info_val = SnmpCommand.this.setOidInfo(OID_INFO.bIsSequence, matchingNode.oid_info_val);
                if (matchingIndex == null) {
                    SnmpCommand.this.mainMib2bib.ShowError(file, line, mib2bib.FILE_ERROR_CODE.OID_NOT_DEFINED);
                    return false;
                }
                if (matchingIndex.dataType != DATA_TYPE.INT8_VAL) {
                    SnmpCommand.this.mainMib2bib.ShowError(file, line, mib2bib.FILE_ERROR_CODE.INVALID_INDEX_DEFINED);
                    return false;
                }
                matchingNode.idx[matchingNode.indexLen].indexType = (byte)SnmpCommand.this.INDEX_OID;
                matchingNode.idx[matchingNode.indexLen].id = matchingIndex.id;
                matchingNode.idx[matchingNode.indexLen].dataType = matchingIndex.dataType;
                if (matchingIndex.id <= 255L) {
                    matchingNode.indexBytes = (short)(matchingNode.indexBytes + 4);
                } else if (matchingIndex.id > 255L && matchingIndex.id < 65535L) {
                    matchingNode.indexBytes = (short)(matchingNode.indexBytes + 5);
                }
                matchingNode.indexLen = (short)(matchingNode.indexLen + 1);
            }
            return true;
        }
    }

    class agentID {
        agentID() {
        }

        int GetAgentIDCount(OID_NODE r) {
            int count = 0;
            if (r == null) {
                return 0;
            }
            for (int i = 0; i < r.pChilds.size(); ++i) {
                count += this.GetAgentIDCount(r.pChilds.get(i));
            }
            if (SnmpCommand.this.getOidInfo(OID_INFO.bIsAgentID, r.oid_info_val)) {
                return 1;
            }
            return 0;
        }

        boolean HandleAgentID(List pList, File file, int line) {
            if (pList.size() != 3) {
                SnmpCommand.this.mainMib2bib.ShowError(file, line, mib2bib.FILE_ERROR_CODE.AGENT_ID_INVALID_ARGS);
                return false;
            }
            OID_NODE matchingNode = SnmpCommand.this.LookupOIDName(SnmpCommand.this.mibRoot, pList.get(1).toString());
            if (matchingNode == null) {
                SnmpCommand.this.mainMib2bib.ShowError(file, line, mib2bib.FILE_ERROR_CODE.OID_NOT_DEFINED);
                return false;
            }
            if (matchingNode.dataType != DATA_TYPE.OID_VAL) {
                SnmpCommand.this.mainMib2bib.ShowError(file, line, mib2bib.FILE_ERROR_CODE.NOT_OID_DATA_TYPE);
                return false;
            }
            if (!SnmpCommand.this.getOidInfo(OID_INFO.bIsConstant, matchingNode.oid_info_val) || matchingNode.dataLen == 0) {
                SnmpCommand.this.mainMib2bib.ShowError(file, line, mib2bib.FILE_ERROR_CODE.NOT_A_CONSTANT_DATA_TYPE);
                return false;
            }
            long id = Integer.decode(pList.get(2).toString()).intValue();
            if (id > 1024L) {
                SnmpCommand.this.mainMib2bib.ShowError(file, line, mib2bib.FILE_ERROR_CODE.INVALID_OID_ID);
                return false;
            }
            OID_NODE duplicateIDRec = SnmpCommand.this.LookupID(SnmpCommand.this.mibRoot, id);
            if (duplicateIDRec != null) {
                SnmpCommand.this.mainMib2bib.ShowError(file, line, mib2bib.FILE_ERROR_CODE.OID_ID_DUPLICATE);
                return false;
            }
            if (SnmpCommand.this.getOidInfo(OID_INFO.bIsAgentID, matchingNode.oid_info_val)) {
                SnmpCommand.this.mainMib2bib.ShowError(file, line, mib2bib.FILE_ERROR_CODE.ALREADY_AN_AGENT_ID);
                return false;
            }
            if (this.GetAgentIDCount(SnmpCommand.this.mibRoot) > 0) {
                SnmpCommand.this.mainMib2bib.ShowError(file, line, mib2bib.FILE_ERROR_CODE.AGENT_ID_ALREADY_DEFINED);
                return false;
            }
            matchingNode.oid_info_val = SnmpCommand.this.setOidInfo(OID_INFO.bIsAgentID, matchingNode.oid_info_val);
            matchingNode.id = id;
            matchingNode.oid_info_val = SnmpCommand.this.setOidInfo(OID_INFO.bIsIDPresent, matchingNode.oid_info_val);
            return true;
        }
    }

    class staticVar {
        staticVar() {
        }

        boolean HandleStaticVar(List pList, File file, int line) {
            if (pList.size() < 3) {
                SnmpCommand.this.mainMib2bib.ShowError(file, line, mib2bib.FILE_ERROR_CODE.STATIC_OID_INVALID_ARGS);
                return false;
            }
            OID_NODE matchingNode = SnmpCommand.this.LookupOIDName(SnmpCommand.this.mibRoot, pList.get(1).toString());
            if (matchingNode == null) {
                SnmpCommand.this.mainMib2bib.ShowError(file, line, mib2bib.FILE_ERROR_CODE.OID_NOT_DEFINED);
                return false;
            }
            if (SnmpCommand.this.getOidInfo(OID_INFO.bIsSequence, matchingNode.oid_info_val)) {
                SnmpCommand.this.mainMib2bib.ShowError(file, line, mib2bib.FILE_ERROR_CODE.STATIC_SEQUENCE_OID);
                return false;
            }
            if (matchingNode.id <= 1024L) {
                SnmpCommand.this.mainMib2bib.ShowError(file, line, mib2bib.FILE_ERROR_CODE.ALREADY_DYNAMIC);
                return false;
            }
            if (SnmpCommand.this.getOidInfo(OID_INFO.bIsConstant, matchingNode.oid_info_val)) {
                SnmpCommand.this.mainMib2bib.ShowError(file, line, mib2bib.FILE_ERROR_CODE.OID_VALUE_ASSIGNED);
                return false;
            }
            if (SnmpCommand.this.getOidInfo(OID_INFO.bIsEditable, matchingNode.oid_info_val)) {
                SnmpCommand.this.mainMib2bib.ShowError(file, line, mib2bib.FILE_ERROR_CODE.OID_WITH_READWRITE_ACCESS);
                return false;
            }
            switch (matchingNode.dataType) {
                case INT8_VAL: {
                    if (pList.size() != 3) {
                        SnmpCommand.this.mainMib2bib.ShowError(file, line, mib2bib.FILE_ERROR_CODE.STATIC_OID_INVALID_ARGS);
                        return false;
                    }
                    long i = Integer.decode(pList.get(2).toString()).intValue();
                    if (i > 255L) {
                        SnmpCommand.this.mainMib2bib.ShowWarning(file, line, mib2bib.FILE_ERROR_CODE.VALUE_TRUNCATED);
                    }
                    matchingNode.Byte = (byte)i;
                    matchingNode.dataLen = 1;
                    for (long j = 0L; j < (long)matchingNode.dataLen; ++j) {
                        int offset = (int)((long)(matchingNode.dataLen - 1) - j) * 8;
                        matchingNode.data[(int)j] = (byte)(matchingNode.Byte >> (byte)offset & 0xFFFFFFFF);
                    }
                    break;
                }
                case INT16_VAL: {
                    if (pList.size() != 3) {
                        SnmpCommand.this.mainMib2bib.ShowError(file, line, mib2bib.FILE_ERROR_CODE.STATIC_OID_INVALID_ARGS);
                        return false;
                    }
                    long i = Integer.decode(pList.get(2).toString()).intValue();
                    if (i > 65535L) {
                        SnmpCommand.this.mainMib2bib.ShowWarning(file, line, mib2bib.FILE_ERROR_CODE.VALUE_TRUNCATED);
                    }
                    matchingNode.int16 = SnmpCommand.this.intSwap((short)i);
                    matchingNode.dataLen = (short)2;
                    for (long j = 0L; j < (long)matchingNode.dataLen; ++j) {
                        int offset = (int)((long)(matchingNode.dataLen - 1) - j) * 8;
                        matchingNode.data[(int)j] = (byte)(matchingNode.int16 >> (byte)offset & 0xFFFFFFFF);
                    }
                    break;
                }
                case INT32_VAL: 
                case COUNTER32: 
                case GAUGE32: 
                case TIME_TICKS: {
                    if (pList.size() != 3) {
                        SnmpCommand.this.mainMib2bib.ShowError(file, line, mib2bib.FILE_ERROR_CODE.STATIC_OID_INVALID_ARGS);
                        return false;
                    }
                    matchingNode.int32 = SnmpCommand.this.intSwap(Integer.decode(pList.get(2).toString()));
                    matchingNode.dataLen = (short)4;
                    for (long j = 0L; j < (long)matchingNode.dataLen; ++j) {
                        int offset = (int)((long)(matchingNode.dataLen - 1) - j) * 8;
                        matchingNode.data[(int)j] = (byte)(matchingNode.int32 >> (byte)offset & 0xFFFFFFFFFFFFFFFFL);
                    }
                    break;
                }
                case ASCII_STRING: {
                    if (pList.size() != 3) {
                        SnmpCommand.this.mainMib2bib.ShowError(file, line, mib2bib.FILE_ERROR_CODE.STATIC_OID_INVALID_ARGS);
                        return false;
                    }
                    long i = pList.get(2).toString().length();
                    if (i > 127L) {
                        SnmpCommand.this.mainMib2bib.ShowError(file, line, mib2bib.FILE_ERROR_CODE.TOO_LONG_STRING);
                        return false;
                    }
                    matchingNode.dataLen = (byte)i;
                    matchingNode.octets = pList.get(2).toString().getBytes();
                    matchingNode.dataType = DATA_TYPE.OCTET_STRING;
                    matchingNode.data = matchingNode.octets;
                    break;
                }
                case OID_VAL: {
                    if (pList.size() != 3) {
                        SnmpCommand.this.mainMib2bib.ShowError(file, line, mib2bib.FILE_ERROR_CODE.STATIC_OID_INVALID_ARGS);
                        return false;
                    }
                    int temp = 0;
                    temp = SnmpCommand.this.ParseOIDString(pList.get(2).toString(), matchingNode.oidString, temp);
                    if (temp == 0) {
                        SnmpCommand.this.mainMib2bib.ShowError(file, line, mib2bib.FILE_ERROR_CODE.STATIC_OID_INVALID_ARGS);
                        return false;
                    }
                    matchingNode.dataLen = (byte)temp;
                    matchingNode.dataType = DATA_TYPE.OID_VAL;
                    matchingNode.data = matchingNode.oidString;
                    break;
                }
                case IP_ADDRESS: {
                    if (pList.size() != 3) {
                        SnmpCommand.this.mainMib2bib.ShowError(file, line, mib2bib.FILE_ERROR_CODE.STATIC_OID_INVALID_ARGS);
                        return false;
                    }
                    matchingNode.dataLen = (byte)pList.get(2).toString().length();
                    String delimiters = "[.]";
                    String[] ipString = pList.get(2).toString().split(delimiters);
                    long b1 = Integer.decode(ipString[0]).intValue();
                    long b2 = Integer.decode(ipString[1]).intValue();
                    long b3 = Integer.decode(ipString[2]).intValue();
                    long b4 = Integer.decode(ipString[3]).intValue();
                    matchingNode.dataLen = (byte)ipString.length;
                    if (matchingNode.dataLen != 4) {
                        SnmpCommand.this.mainMib2bib.ShowError(file, line, mib2bib.FILE_ERROR_CODE.INVALID_DATA);
                        return false;
                    }
                    if (b1 > 255L || b1 < 0L || b2 > 255L || b2 < 0L || b3 > 255L || b3 < 0L || b4 > 255L || b4 < 0L) {
                        SnmpCommand.this.mainMib2bib.ShowError(file, line, mib2bib.FILE_ERROR_CODE.INVALID_DATA);
                        return false;
                    }
                    matchingNode.ipAddress[0] = (byte)b4;
                    matchingNode.ipAddress[1] = (byte)b3;
                    matchingNode.ipAddress[2] = (byte)b2;
                    matchingNode.ipAddress[3] = (byte)b1;
                    matchingNode.data = matchingNode.ipAddress;
                    break;
                }
                case OCTET_STRING: {
                    if (pList.size() < 3) {
                        SnmpCommand.this.mainMib2bib.ShowError(file, line, mib2bib.FILE_ERROR_CODE.STATIC_OID_INVALID_ARGS);
                        return false;
                    }
                    long i = pList.size() - 2;
                    if (i > 127L) {
                        SnmpCommand.this.mainMib2bib.ShowError(file, line, mib2bib.FILE_ERROR_CODE.TOO_LONG_STRING);
                        return false;
                    }
                    long j = 0L;
                    i = 2L;
                    while (i < (long)pList.size()) {
                        int temp = Integer.decode(pList.get((int)i).toString());
                        if (temp > 255) {
                            SnmpCommand.this.mainMib2bib.ShowError(file, line, mib2bib.FILE_ERROR_CODE.INVALID_DATA);
                            return false;
                        }
                        matchingNode.octets[(int)j] = (byte)temp;
                        ++i;
                        ++j;
                    }
                    matchingNode.dataLen = (byte)j;
                    matchingNode.data = matchingNode.octets;
                }
            }
            matchingNode.oid_info_val = SnmpCommand.this.setOidInfo(OID_INFO.bIsConstant, matchingNode.oid_info_val);
            matchingNode.id = Integer.MAX_VALUE;
            return true;
        }
    }

    class dynamicVar {
        public int DynamicOIDCount = 0;

        dynamicVar() {
        }

        boolean HandleDynamicVar(List pList, File file, int line) {
            if (this.DynamicOIDCount > 1024) {
                SnmpCommand.this.mainMib2bib.ShowError(file, line, mib2bib.FILE_ERROR_CODE.TOO_MANY_DYNAMIC_OIDS);
                return false;
            }
            if (pList.size() != 3) {
                SnmpCommand.this.mainMib2bib.ShowError(file, line, mib2bib.FILE_ERROR_CODE.DYNAMIC_OID_INVALID_ARGS);
                return false;
            }
            OID_NODE matchingNode = SnmpCommand.this.LookupOIDName(SnmpCommand.this.mibRoot, pList.get(1).toString());
            if (matchingNode == null) {
                SnmpCommand.this.mainMib2bib.ShowError(file, line, mib2bib.FILE_ERROR_CODE.OID_NOT_DEFINED);
                return false;
            }
            if (SnmpCommand.this.getOidInfo(OID_INFO.bIsConstant, matchingNode.oid_info_val)) {
                SnmpCommand.this.mainMib2bib.ShowError(file, line, mib2bib.FILE_ERROR_CODE.ALREADY_STATIC);
                return false;
            }
            if (matchingNode.dataType == DATA_TYPE.OID_VAL) {
                SnmpCommand.this.mainMib2bib.ShowError(file, line, mib2bib.FILE_ERROR_CODE.DYNAMIC_OID_TYPE);
                return false;
            }
            if (matchingNode.id <= 1024L) {
                SnmpCommand.this.mainMib2bib.ShowError(file, line, mib2bib.FILE_ERROR_CODE.OID_ID_ASSIGNED);
                return false;
            }
            long id = Integer.decode(pList.get(2).toString()).intValue();
            if (id > 1024L) {
                SnmpCommand.this.mainMib2bib.ShowError(file, line, mib2bib.FILE_ERROR_CODE.INVALID_OID_ID);
                return false;
            }
            OID_NODE duplicateIDRec = SnmpCommand.this.LookupID(SnmpCommand.this.mibRoot, id);
            if (duplicateIDRec != null) {
                SnmpCommand.this.mainMib2bib.ShowError(file, line, mib2bib.FILE_ERROR_CODE.OID_ID_DUPLICATE);
                return false;
            }
            matchingNode.id = id;
            matchingNode.oid_info_val = SnmpCommand.this.setOidInfo(OID_INFO.bIsIDPresent, matchingNode.oid_info_val);
            ++this.DynamicOIDCount;
            return true;
        }
    }

    class declareVar {
        public boolean lbIsAlreadyWarned = false;

        declareVar() {
        }

        boolean HandleDeclareVar(List pList, File file, int line) {
            byte[] oidBytes = new byte[SnmpCommand.this.OID_STRING_LEN];
            int oidLen = 0;
            if (pList.size() != 6) {
                SnmpCommand.this.mainMib2bib.ShowError(file, line, mib2bib.FILE_ERROR_CODE.DEFINE_INVALID_ARGS);
                return false;
            }
            if (!SnmpCommand.this.IsValidName((String)pList.get(1))) {
                SnmpCommand.this.mainMib2bib.ShowError(file, line, mib2bib.FILE_ERROR_CODE.INVALID_OID_NAME);
                return false;
            }
            DATA_TYPE dataType = SnmpCommand.this.GetDataType((String)pList.get(2));
            if (dataType == DATA_TYPE.DATA_TYPE_UNKNOWN) {
                SnmpCommand.this.mainMib2bib.ShowError(file, line, mib2bib.FILE_ERROR_CODE.UNKNOWN_DATA_TYPE);
                return false;
            }
            OID_TYPE oidType = SnmpCommand.this.GetNodeType((String)pList.get(3));
            if (oidType == OID_TYPE.OID_TYPE_UNKNOWN) {
                SnmpCommand.this.mainMib2bib.ShowError(file, line, mib2bib.FILE_ERROR_CODE.UNKNOWN_OID_TYPE);
                return false;
            }
            OID_ACCESS oidAccess = SnmpCommand.this.GetOIDAccess((String)pList.get(4));
            if (oidAccess == OID_ACCESS.OID_ACCESS_UNKNOWN) {
                SnmpCommand.this.mainMib2bib.ShowError(file, line, mib2bib.FILE_ERROR_CODE.UNKNOWN_OID_ACCESS);
                return false;
            }
            String tempString = (String)pList.get(5);
            oidLen = SnmpCommand.this.ParseOIDString((String)pList.get(5), oidBytes, oidLen);
            if (oidLen == 0) {
                SnmpCommand.this.mainMib2bib.ShowError(file, line, mib2bib.FILE_ERROR_CODE.INVALID_OID_LEN);
                return false;
            }
            if (SnmpCommand.this.LookupOIDName(SnmpCommand.this.mibRoot, (String)pList.get(1)) == null) {
                OID_NODE r = SnmpCommand.this.AddNode(pList.get(1).toString(), dataType, oidType, oidAccess, oidBytes, oidLen);
                if (r == null) {
                    SnmpCommand.this.mainMib2bib.ShowError(file, line, mib2bib.FILE_ERROR_CODE.ROOT_NOT_SAME_OR_DUPLICATE);
                    return false;
                }
            } else {
                SnmpCommand.this.mainMib2bib.ShowError(file, line, mib2bib.FILE_ERROR_CODE.DUPLICATE_DEFINE);
                return false;
            }
            if (SnmpCommand.this.mibRoot.oid != 43 && !this.lbIsAlreadyWarned) {
                this.lbIsAlreadyWarned = true;
                SnmpCommand.this.mainMib2bib.ShowError(file, line, mib2bib.FILE_ERROR_CODE.NOT_AN_INTERNET_ROOT);
            }
            r.oidASCIIString = tempString;
            r.dataTypeString = pList.get(2).toString();
            r.line = line;
            return true;
        }
    }

    public class OID_NODE {
        String name;
        String oidASCIIString;
        String dataTypeString;
        long id;
        byte oid;
        DATA_TYPE dataType;
        long siblingOffset;
        long distantSiblingOffset;
        short dataLen;
        short oid_info_val = 0;
        long int32;
        long counter32;
        long gauge32;
        long timeTicks;
        byte[] octets;
        byte[] ipAddress;
        int int16;
        byte Byte;
        byte[] oidString;
        byte[] data;
        short indexLen;
        short indexBytes;
        OID_TYPE oidType;
        List<OID_NODE> pChilds;
        List<String> pIndex;
        private OID_NODE pParent;
        long recordOffset;
        INDEX[] idx;
        int line;

        public OID_NODE() {
            this.octets = new byte[SnmpCommand.this.MAX_DATA_LEN];
            this.ipAddress = new byte[4];
            this.oidString = new byte[SnmpCommand.this.MAX_DATA_LEN];
            this.data = new byte[SnmpCommand.this.MAX_DATA_LEN];
            this.idx = new INDEX[SnmpCommand.this.MAX_INDEX_LEN];
            for (int i = 0; i < SnmpCommand.this.MAX_INDEX_LEN; ++i) {
                this.idx[i] = new INDEX();
            }
        }

        public class INDEX {
            short indexType;
            String indexName;
            byte constant;
            long id;
            DATA_TYPE dataType;
        }
    }

    class MIB_STATISTICS {
        long totalBytes;
        long totalStaticOIDs;
        long totalDynamicOIDs;
        long totalSequenceOIDs;
        long totalAgentIDs;
        long totalReadOnlyOIDs;
        long totalReadWriteOIDs;
        long totalDataBytes;

        MIB_STATISTICS() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum OID_INFO {
        bIsDistantSibling,
        bIsConstant,
        bIsSequence,
        bIsSibling,
        bIsParent,
        bIsEditable,
        bIsAgentID,
        bIsIDPresent;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OID_ACCESS {
        OID_ACCESS_RO,
        OID_ACCESS_RW,
        OID_ACCESS_UNKNOWN;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OID_TYPE {
        SINGLE,
        SEQUENCE,
        OID_TYPE_UNKNOWN;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DATA_TYPE {
        INT8_VAL,
        INT16_VAL,
        INT32_VAL,
        OCTET_STRING,
        ASCII_STRING,
        IP_ADDRESS,
        COUNTER32,
        TIME_TICKS,
        GAUGE32,
        OID_VAL,
        DATA_TYPE_UNKNOWN;

    }
}

