/***************************************************************
 * MPFSImg2.c
 * Defines an MPFS2 image to be stored in program memory.
 *
 * NOT FOR HAND MODIFICATION
 * This file is automatically generated by the MPFS2 Utility
 * ALL MODIFICATIONS WILL BE OVERWRITTEN BY THE MPFS2 GENERATOR
 * Generated  10 17 2011 01:29:51 
 ***************************************************************/

#define __MPFSIMG2_C

#include "TCPIPConfig.h"
#if !defined(MPFS_USE_EEPROM) && !defined(MPFS_USE_SPI_FLASH)

#include "TCPIP Stack/TCPIP.h"
#if defined(STACK_USE_MPFS2)


/**************************************
 * MPFS2 Image Data
 **************************************/
#define DATACHUNK000000 \
	0x4d,0x50,0x46,0x53,0x02,0x01,0x1d,0x00,0x6a,0x55,0x5e,0x2a,0x4a,0xce,0xff,0xff, /* MPFS....jU^.J... */ \
	0xea,0x81,0xff,0xff,0x2a,0xba,0xff,0xff,0x26,0x4f,0x26,0x2d,0x0a,0xa3,0xff,0xff, /* ........&O&-.... */ \
	0x98,0xdb,0x0a,0x85,0xff,0xff,0x0a,0x2f,0xff,0xff,0x0a,0x3f,0xff,0xff,0xea,0x92, /* ......./...?.... */ \
	0xff,0xff,0x0a,0x4f,0xff,0xff,0x26,0xb6,0xff,0xff,0x8a,0xb6,0xff,0xff,0xea,0x8a, /* ...O..&......... */ \
	0xff,0xff,0xc0,0x02,0x00,0x00,0xbb,0x03,0x00,0x00,0x95,0x03,0x00,0x00,0x83,0x5a, /* ...............Z */ \
	0x9b,0x4e,0x00,0x00,0x00,0x00,0x01,0x00,0xcb,0x02,0x00,0x00,0x50,0x07,0x00,0x00, /* .N..........P... */ \
	0xc2,0x05,0x00,0x00,0x91,0x1b,0x15,0x4e,0x00,0x00,0x00,0x00,0x01,0x00,0xd5,0x02, /* .......N........ */ \
	0x00,0x00,0x12,0x0d,0x00,0x00,0x40,0x05,0x00,0x00,0x91,0x1b,0x15,0x4e,0x00,0x00, /* ......@......N.. */ \
	0x00,0x00,0x02,0x00,0xde,0x02,0x00,0x00,0x52,0x12,0x00,0x00,0x18,0x00,0x00,0x00, /* ........R....... */ \
	0x91,0x1b,0x15,0x4e,0x00,0x00,0x00,0x00,0x00,0x00,0xdf,0x02,0x00,0x00,0x6a,0x12, /* ...N..........j. */ \
	0x00,0x00,0x98,0x08,0x00,0x00,0x91,0x1b,0x15,0x4e,0x00,0x00,0x00,0x00,0x02,0x00, /* .........N...... */ \
	0xeb,0x02,0x00,0x00,0x02,0x1b,0x00,0x00,0x20,0x00,0x00,0x00,0x91,0x1b,0x15,0x4e, /* ........ ......N */ \
	0x00,0x00,0x00,0x00,0x00,0x00,0xec,0x02,0x00,0x00,0x22,0x1b,0x00,0x00,0xf8,0x03, /* .........."..... */ \
	0x00,0x00,0xe2,0xa2,0x9b,0x4e,0x00,0x00,0x00,0x00,0x02,0x00,0xf8,0x02,0x00,0x00, /* .....N.......... */ \
	0x1a,0x1f,0x00,0x00,0x20,0x00,0x00,0x00,0xe2,0xa2,0x9b,0x4e,0x00,0x00,0x00,0x00, /* .... ......N.... */ \
	0x00,0x00,0xf9,0x02,0x00,0x00,0x3a,0x1f,0x00,0x00,0xa0,0x00,0x00,0x00,0xc3,0x42, /* ......:........B */ \
	0x9b,0x4e,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x03,0x00,0x00,0xda,0x1f,0x00,0x00, /* .N.............. */ \
	0xbc,0x02,0x00,0x00,0x2d,0xaf,0x9b,0x4e,0x00,0x00,0x00,0x00,0x00,0x00,0x0f,0x03, /* ....-..N........ */ \
	0x00,0x00,0x96,0x22,0x00,0x00,0xa7,0x02,0x00,0x00,0xc9,0xea,0x9a,0x4e,0x00,0x00, /* ...".........N.. */ \
	0x00,0x00,0x02,0x00,0x19,0x03,0x00,0x00,0x3d,0x25,0x00,0x00,0x40,0x00,0x00,0x00, /* ........=%..@... */ \
	0xc9,0xea,0x9a,0x4e,0x00,0x00,0x00,0x00,0x00,0x00,0x1a,0x03,0x00,0x00,0x7d,0x25, /* ...N..........}% */ \
	0x00,0x00,0xb6,0x01,0x00,0x00,0x91,0x1b,0x15,0x4e,0x00,0x00,0x00,0x00,0x00,0x00, /* .........N...... */ \
	0x23,0x03,0x00,0x00,0x33,0x27,0x00,0x00,0xa0,0x03,0x00,0x00,0x91,0x1b,0x15,0x4e, /* #...3'.........N */ \
	0x00,0x00,0x00,0x00,0x02,0x00,0x2e,0x03,0x00,0x00,0xd3,0x2a,0x00,0x00,0x20,0x00, /* .............. . */ \
	0x00,0x00,0x91,0x1b,0x15,0x4e,0x00,0x00,0x00,0x00,0x00,0x00,0x2f,0x03,0x00,0x00, /* .....N....../... */ \
	0xf3,0x2a,0x00,0x00,0x54,0x07,0x00,0x00,0x91,0x1b,0x15,0x4e,0x00,0x00,0x00,0x00, /* ....T......N.... */ \
	0x02,0x00,0x3f,0x03,0x00,0x00,0x47,0x32,0x00,0x00,0x30,0x00,0x00,0x00,0x91,0x1b, /* ..?...G2..0..... */ \
	0x15,0x4e,0x00,0x00,0x00,0x00,0x00,0x00,0x40,0x03,0x00,0x00,0x77,0x32,0x00,0x00, /* .N......@...w2.. */ \
	0xc6,0x03,0x00,0x00,0x91,0x1b,0x15,0x4e,0x00,0x00,0x00,0x00,0x02,0x00,0x56,0x03, /* .......N......V. */ \
	0x00,0x00,0x3d,0x36,0x00,0x00,0x18,0x00,0x00,0x00,0x91,0x1b,0x15,0x4e,0x00,0x00, /* ..=6.........N.. */ \
	0x00,0x00,0x00,0x00,0x57,0x03,0x00,0x00,0x55,0x36,0x00,0x00,0x42,0x07,0x00,0x00, /* ....W...U6..B... */ \
	0xaa,0x95,0x9b,0x4e,0x00,0x00,0x00,0x00,0x02,0x00,0x6a,0x03,0x00,0x00,0x97,0x3d, /* ...N......j....= */ \
	0x00,0x00,0x78,0x00,0x00,0x00,0xaa,0x95,0x9b,0x4e,0x00,0x00,0x00,0x00,0x00,0x00, /* ..x......N...... */ \
	0x6b,0x03,0x00,0x00,0x0f,0x3e,0x00,0x00,0xc6,0x03,0x00,0x00,0x91,0x1b,0x15,0x4e, /* k....>.........N */ \
	0x00,0x00,0x00,0x00,0x02,0x00,0x7d,0x03,0x00,0x00,0xd5,0x41,0x00,0x00,0x18,0x00, /* ......}....A.... */ \
	0x00,0x00,0x91,0x1b,0x15,0x4e,0x00,0x00,0x00,0x00,0x00,0x00,0x7e,0x03,0x00,0x00, /* .....N......~... */ \
	0xed,0x41,0x00,0x00,0x08,0x00,0x00,0x00,0x91,0x1b,0x15,0x4e,0x00,0x00,0x00,0x00, /* .A.........N.... */ \
	0x02,0x00,0x91,0x03,0x00,0x00,0xf5,0x41,0x00,0x00,0x08,0x00,0x00,0x00,0x91,0x1b, /* .......A........ */ \
	0x15,0x4e,0x00,0x00,0x00,0x00,0x00,0x00,0x92,0x03,0x00,0x00,0xfd,0x41,0x00,0x00, /* .N...........A.. */ \
	0x06,0x02,0x00,0x00,0xd6,0x84,0x9b,0x4e,0x00,0x00,0x00,0x00,0x02,0x00,0xa5,0x03, /* .......N........ */ \
	0x00,0x00,0x03,0x44,0x00,0x00,0x20,0x00,0x00,0x00,0xd6,0x84,0x9b,0x4e,0x00,0x00, /* ...D.. ......N.. */ \
	0x00,0x00,0x00,0x00,0xa6,0x03,0x00,0x00,0x23,0x44,0x00,0x00,0x3d,0x05,0x00,0x00, /* ........#D..=... */ \
	0x91,0x1b,0x15,0x4e,0x00,0x00,0x00,0x00,0x02,0x00,0xba,0x03,0x00,0x00,0x60,0x49, /* ...N..........`I */ \
	0x00,0x00,0x48,0x00,0x00,0x00,0x91,0x1b,0x15,0x4e,0x00,0x00,0x00,0x00,0x00,0x00, /* ..H......N...... */ \
	0x37,0x6d,0x33,0x74,0x6a,0x7a,0x2e,0x63,0x73,0x73,0x00,0x37,0x6d,0x33,0x74,0x6a, /* 7m3tjz.css.7m3tj */ \
	0x7a,0x2e,0x6a,0x73,0x00,0x61,0x75,0x74,0x68,0x2e,0x68,0x74,0x6d,0x00,0x00,0x63, /* z.js.auth.htm..c */ \
	0x6f,0x6f,0x6b,0x69,0x65,0x73,0x2e,0x68,0x74,0x6d,0x00,0x00,0x64,0x79,0x6e,0x76, /* ookies.htm..dynv */ \
	0x61,0x72,0x73,0x2e,0x68,0x74,0x6d,0x00,0x00,0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e, /* ars.htm..footer. */ \
	0x69,0x6e,0x63,0x00,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63,0x00,0x69, /* inc.header.inc.i */ \
	0x6e,0x64,0x65,0x78,0x2e,0x68,0x74,0x6d,0x00,0x00,0x73,0x6e,0x6d,0x70,0x2e,0x62, /* ndex.htm..snmp.b */ \
	0x69,0x62,0x00,0x75,0x70,0x6c,0x6f,0x61,0x64,0x2e,0x68,0x74,0x6d,0x00,0x00,0x65, /* ib.upload.htm..e */ \
	0x6d,0x61,0x69,0x6c,0x2f,0x69,0x6e,0x64,0x65,0x78,0x2e,0x68,0x74,0x6d,0x00,0x00, /* mail/index.htm.. */ \
	0x6e,0x6f,0x64,0x65,0x61,0x64,0x61,0x70,0x74,0x65,0x72,0x2f,0x69,0x6e,0x64,0x65, /* nodeadapter/inde */ \
	0x78,0x2e,0x68,0x74,0x6d,0x00,0x00,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x63, /* x.htm..protect/c */ \
	0x6f,0x6e,0x66,0x69,0x67,0x2e,0x68,0x74,0x6d,0x00,0x00,0x70,0x72,0x6f,0x74,0x65, /* onfig.htm..prote */ \
	0x63,0x74,0x2f,0x69,0x6e,0x64,0x65,0x78,0x2e,0x68,0x74,0x6d,0x00,0x00,0x70,0x72, /* ct/index.htm..pr */ \
	0x6f,0x74,0x65,0x63,0x74,0x2f,0x72,0x65,0x62,0x6f,0x6f,0x74,0x2e,0x63,0x67,0x69, /* otect/reboot.cgi */ \
	0x00,0x00,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x72,0x65,0x62,0x6f,0x6f,0x74, /* ..protect/reboot */ \
	0x2e,0x68,0x74,0x6d,0x00,0x00,0x73,0x6e,0x6d,0x70,0x2f,0x73,0x6e,0x6d,0x70,0x63, /* .htm..snmp/snmpc */ \
	0x6f,0x6e,0x66,0x69,0x67,0x2e,0x68,0x74,0x6d,0x00,0x00,0x1f,0x8b,0x08,0x00,0x00, /* onfig.htm....... */ \
	0x00,0x00,0x00,0x00,0x00,0xad,0x56,0x4d,0x6f,0xa3,0x30,0x10,0x3d,0x37,0x52,0xfe, /* ......VMo.0.=7R. */ \
	0x03,0x52,0xaf,0x21,0x82,0x24,0xa4,0x2d,0x3d,0xad,0xf6,0xbe,0xc7,0xbd,0x1b,0x3c, /* .R.!.$.-=......< */ \
	0x04,0xab,0x0e,0x46,0xb6,0x69,0xd2,0xad,0xfa,0xdf,0xd7,0x5f,0x80,0x01,0x27,0xd5, /* ...F.i....._..'. */ \
	0x4a,0x2b,0xa4,0xdd,0x62,0x66,0xde,0x1b,0xcf,0xbc,0x99,0x49,0xc1,0xf0,0x47,0xf4  /* J+..bf.....I..G. */
#define DATACHUNK000001 \
	0xb9,0x5e,0x3d,0x54,0xac,0x91,0x71,0x85,0xce,0x84,0x7e,0xe4,0xd1,0x6f,0xe0,0x18, /* .^=T..q...~..o.. */ \
	0x35,0x68,0x13,0xfd,0xe0,0x04,0xd1,0x4d,0x24,0x50,0x23,0x62,0x01,0x9c,0x54,0xaf, /* 5h.....M$P#b..T. */ \
	0xca,0xb4,0x40,0xe5,0xdb,0x89,0xb3,0xae,0xc1,0x79,0xf4,0x98,0x15,0xfa,0xd1,0xc7, /* ..@......y...... */ \
	0x67,0xc4,0x4f,0xa4,0xc9,0xa3,0xa4,0xbd,0x46,0xa8,0x93,0x4c,0x9f,0xb5,0x08,0x63, /* g.O.....F..L...c */ \
	0xd2,0x9c,0xd4,0xa1,0x7a,0x76,0xfa,0x4b,0xa2,0x8e,0xbf,0xd6,0xab,0xf5,0xea,0x51, /* ....zv.K.......Q */ \
	0xd4,0x08,0xb3,0x4b,0xcc,0x1a,0x30,0x01,0x5c,0x08,0x96,0x75,0x1e,0x3d,0x1d,0x95, /* ...K..0.\..u.=.. */ \
	0x95,0x61,0x61,0x1c,0x03,0xcf,0xa3,0x54,0x39,0x09,0x46,0x09,0x56,0x5c,0x59,0x36, /* .aa....T9.F.V\Y6 */ \
	0x7e,0x89,0x25,0x6b,0x73,0x03,0x17,0x62,0xfe,0x1a,0x09,0xe4,0x85,0x19,0x82,0x00, /* ~.%ks..b........ */ \
	0xe0,0xa1,0xd0,0x4f,0x08,0xd3,0xf7,0xaf,0x39,0xc0,0x4d,0x84,0xc3,0xe1,0x1b,0xf7, /* ...O....9.M..... */ \
	0x8a,0x75,0xfc,0x96,0xf7,0x1e,0xe9,0xe7,0x06,0x80,0x82,0x68,0xd1,0xe9,0x26,0xf3, /* .u.........h..&. */ \
	0x7e,0xbf,0x5f,0x14,0xa3,0xaa,0xaa,0x60,0x82,0x86,0x32,0xec,0x5c,0x72,0x4d,0xb5, /* ~._....`..2.\rM. */ \
	0x05,0xf9,0x03,0x0a,0x32,0x69,0xe5,0x94,0x50,0xe2,0x51,0x11,0x01,0x1b,0x49,0x24, /* ....2i..P.Q...I$ */ \
	0x75,0x51,0xf9,0xdc,0x49,0x92,0x38,0xfa,0x81,0xed,0xe0,0x91,0x5d,0x80,0x9c,0x6a, /* uQ..I.8.....]..j */ \
	0x99,0x47,0x05,0xa3,0x58,0x1f,0x96,0x8c,0x32,0x3e,0x86,0x6c,0x4b,0x18,0x17,0x4c, /* .G..X...2>.lK..L */ \
	0x4a,0x76,0x56,0x84,0x99,0x75,0xad,0x9d,0x57,0x7a,0x34,0xef,0x7e,0x00,0x5b,0xae, /* JvV..u..Wz4.~.[. */ \
	0x3f,0xd9,0x48,0x29,0x43,0xca,0xc8,0x1c,0xbc,0x8e,0x52,0xda,0x27,0xee,0xb6,0x12, /* ?.H)C.....R.'... */ \
	0xae,0x32,0x46,0x94,0x9c,0x9a,0xd1,0xc8,0x42,0x9d,0xa1,0xe9,0x7c,0x08,0x0a,0x95, /* .2F.....B...|... */ \
	0x8f,0x90,0x66,0x0e,0xc1,0x5d,0x29,0xe6,0x36,0x1c,0x97,0x46,0x0f,0x03,0xf9,0x1a, /* ..f..]).6..F.... */ \
	0x4e,0x0f,0xce,0x0d,0x13,0xd1,0x52,0xa4,0x1a,0xaa,0xa0,0xac,0x7c,0x5b,0x94,0x6b, /* N.....R.....|[.k */ \
	0x4c,0x99,0xcb,0xc6,0xa5,0x26,0x12,0x26,0x29,0x7c,0xbe,0x93,0x42,0x57,0xe6,0x21, /* L....&.&)|..BW.! */ \
	0x67,0xa3,0x36,0x1c,0xaa,0xb9,0x37,0x86,0x92,0x71,0x24,0x09,0x53,0x97,0x6f,0x54, /* g.6...7..q$.S.oT */ \
	0xb3,0xcd,0xe2,0xce,0x6b,0xf6,0x0e,0x7c,0x59,0x4e,0x6c,0xe4,0x65,0x2d,0x4b,0xc5, /* ....k..|YNl.e-K. */ \
	0x0e,0x8d,0xf4,0xaf,0x98,0xed,0x5c,0x85,0xe6,0xb9,0x9f,0x65,0x2a,0xf5,0x33,0xd5, /* ......\....e..3. */ \
	0xe3,0xd8,0x64,0xf5,0x0a,0x28,0x93,0xe4,0xfb,0x60,0x07,0x57,0x2f,0xde,0x1e,0xc0, /* ..d..(...`.W/... */ \
	0x86,0xba,0x04,0x50,0x17,0x01,0x4e,0x49,0x00,0xa5,0x4e,0x0d,0x80,0x13,0x9d,0xed, /* ...P..NI..N..... */ \
	0x93,0x31,0xce,0xad,0x68,0x51,0xd9,0x73,0x50,0x40,0x5c,0xa7,0x5c,0xd6,0x03,0x4a, /* .1..hQ.sP@\.\..J */ \
	0xc5,0x98,0x74,0x9f,0xbd,0x1e,0x49,0xb6,0xcf,0x70,0xf6,0x95,0x7d,0x3c,0x1e,0xe7, /* ..t...I..p..}<.. */ \
	0xe2,0x2b,0x15,0x39,0x70,0x7f,0x64,0xe9,0xfc,0x44,0x99,0x19,0x8c,0xd1,0x5c,0x6c, /* .+.9p.d..D....\l */ \
	0x26,0xae,0x74,0x32,0x0e,0xdd,0x99,0x32,0xc7,0xaa,0xea,0x80,0x7b,0x16,0x37,0x51, /* &.t2...2....{.7Q */ \
	0x25,0x92,0x9d,0x98,0x28,0xf1,0xe9,0x7e,0x99,0x46,0x7c,0x3f,0xa0,0xf9,0xf8,0x9d, /* %...(..~.F|?.... */ \
	0x72,0x05,0xc5,0x38,0x09,0xa0,0x35,0x21,0x0c,0x14,0x99,0xbd,0x9d,0xfa,0x37,0xf5, /* r..8..5!......7. */ \
	0x1b,0x92,0xa8,0xf2,0x34,0x0a,0x21,0x9e,0x87,0x90,0xcc,0xf1,0xb6,0x14,0xb0,0x58, /* ....4.!........X */ \
	0xcc,0xa4,0x83,0x37,0x93,0x26,0x86,0x53,0x79,0x61,0x6c,0xe7,0x4d,0xc7,0x85,0x7e, /* ...7.&.Syal.M..~ */ \
	0x6f,0x19,0x71,0x35,0x08,0x79,0x86,0xd4,0x65,0xfd,0xef,0xca,0x73,0x0b,0x57,0x74, /* o.q5.y..e...s.Wt */ \
	0x6e,0x29,0x14,0xec,0xea,0x09,0x2b,0x37,0xc5,0xd5,0xb3,0x20,0x1a,0xfe,0x0a,0x35, /* n)....+7... ...5 */ \
	0x77,0x28,0xd5,0x7b,0x4f,0xd3,0x56,0x3c,0xa3,0x76,0xbc,0x3e,0x75,0xd1,0xd9,0x20, /* w(.{O.V<.v.>u..  */ \
	0x4a,0x86,0x61,0xb9,0xcb,0x7f,0xaa,0xfd,0x43,0xd4,0x9d,0x7e,0xc1,0x65,0xd3,0xbf, /* J.a.....C..~.e.. */ \
	0x6c,0xa2,0x8a,0x5c,0x01,0xc7,0x46,0x25,0xee,0xc5,0xbb,0x0b,0xf0,0x92,0x88,0xc0, /* l..\..F%........ */ \
	0x88,0xaf,0xe0,0xe5,0x75,0x56,0x58,0x6f,0x76,0xeb,0xd9,0xb9,0xd0,0xab,0x3d,0xdc, /* ....uVXov.....=. */ \
	0x8d,0xa3,0x09,0x8a,0xfd,0xc8,0xc4,0x39,0xe3,0x7e,0x27,0x4e,0x21,0x16,0x1a,0x9d, /* .......9.~'N!... */ \
	0x06,0x83,0xf1,0x3d,0x9e,0x97,0x64,0x94,0xd1,0xd0,0xf6,0x47,0x6f,0x99,0x7a,0xad, /* ...=..d....Go.z. */ \
	0x84,0x44,0xed,0xe5,0x7c,0xe8,0x84,0x6c,0x16,0x46,0x32,0xdb,0x49,0xde,0xc4,0xf0, /* .D..|..l.F2.I... */ \
	0xea,0xef,0xb6,0xa7,0x57,0xb9,0x7e,0xa9,0xcc,0x47,0x63,0x36,0x02,0x54,0x04,0x28, /* ....W.~..Gc6.T.( */ \
	0x16,0x20,0xff,0xaf,0x7a,0x6e,0x08,0x65,0x20,0xc3,0xe4,0x7d,0xda,0xa9,0x3a,0x7f, /* . ..zn.e ..}..:. */ \
	0x9a,0x4b,0xff,0xdf,0xef,0xbe,0xa5,0x0b,0x45,0x05,0xd0,0x65,0xd9,0xe2,0xf4,0x10, /* .K......E..e.... */ \
	0x1a,0x60,0x3b,0x7b,0xd6,0x0f,0xa4,0x7d,0x76,0x67,0xa3,0xb5,0x4c,0x10,0xdb,0x5d, /* .`;{...}vg..L..] */ \
	0xa8,0x50,0x75,0xec,0x24,0x2c,0x02,0x20,0x4d,0xdb,0x4d,0x36,0xd1,0x2e,0x18,0xa7, /* .Pu.$,. M.M6.... */ \
	0x31,0xdb,0x8a,0xb3,0x6f,0x39,0xfe,0x34,0xf4,0x0c,0x75,0x9d,0x10,0x07,0x74,0x13, /* 1...o9.4..u...t. */ \
	0x72,0xcb,0x41,0x74,0x54,0xae,0x57,0x9f,0xeb,0xd9,0xd8,0xfe,0xb7,0xda,0x4c,0x7f, /* r.AtT.W.......L. */ \
	0xb6,0x85,0xb7,0x42,0x78,0xcd,0xfb,0xaa,0x07,0x18,0x52,0xf2,0xb0,0x65,0x6f,0x26, /* ...Bx.....R..eo& */ \
	0xea,0x5e,0xd0,0xc3,0xe2,0x29,0xcc,0x98,0x9e,0x39,0x56,0xe6,0x87,0x85,0xf2,0x7c, /* .^...)...9V....| */ \
	0xd0,0xae,0x15,0x22,0x34,0xe8,0x5c,0x1c,0x03,0xce,0x15,0x4c,0x9c,0xbb,0x26,0x4c, /* ..."4.\....L..&L */ \
	0x5c,0x96,0x21,0xdf,0x0a,0x3b,0xdf,0xbf,0xf3,0xdd,0x79,0x3f,0x6c,0x0c,0x00,0x00, /* \.!..;....y?l... */ \
	0x1f,0x8b,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xd5,0x57,0x5d,0x6f,0xdb,0x36, /* ...........W]o.6 */ \
	0x14,0x7d,0x56,0x80,0xfc,0x87,0x3b,0x3f,0x2c,0x32,0xe0,0x38,0x4e,0xb1,0xee,0xa1, /* .}V...;?,2.8N... */ \
	0x81,0x3b,0xa4,0x49,0xb1,0x66,0x48,0x97,0x20,0x71,0x87,0x02,0xdb,0x1e,0x68,0x89, /* .;.I.fH. q....h. */ \
	0x8e,0xd9,0xc8,0xa2,0x4a,0x52,0x76,0x8d,0x22,0x3f,0x68,0xff,0x72,0xe7,0x92,0x94, /* ....JRv."?h.r... */ \
	0x2c,0xbb,0x69,0x51,0xac,0x7d,0x59,0x02,0x58,0x1f,0xbc,0xf7,0xf0,0xf2,0xdc,0x4f, /* ,.iQ.}Y.X......O */ \
	0x1d,0x1d,0xd1,0x99,0xae,0xd6,0x46,0xdd,0xcd,0x1d,0xfd,0x43,0x4f,0x46,0xa3,0x27, /* ......F....COF.' */ \
	0x87,0x4f,0x46,0xc7,0x23,0x7a,0xad,0x32,0xa3,0xb3,0xb9,0xaa,0x68,0x22,0xb3,0x79, /* .OF.#z.2....h".y */ \
	0xa9,0x0b,0x7d,0xb7,0xa6,0x8b,0x32,0x1b,0x12,0x9d,0x16,0x05,0x79,0x05,0x4b,0x46, /* ..}...2.....y.KF */ \
	0x5a,0x69,0x96,0x32,0x1f,0xee,0xef,0x1d,0x1d,0xd1,0xad,0x94,0x5d,0xbd,0xb3,0xeb, /* Zi.2........]... */ \
	0xa3,0x8b,0x6b,0xba,0x75,0x22,0xbb,0xa7,0x5c,0x67,0xf5,0x42,0x96,0x4e,0x38,0xa5, /* ..k.u"..\g.B.N8. */ \
	0x4b,0x9a,0x69,0x43,0x85,0xca,0x64,0x69,0x25,0xa9,0x12,0x4f,0x0b,0xff,0x1e,0x28  /* K.iC..di%..O...( */
#define DATACHUNK000002 \
	0xfc,0x0f,0xa4,0x73,0xe9,0xa4,0x59,0xa8,0x52,0x5a,0x5a,0xcd,0x65,0x49,0x02,0x3b, /* ...s..Y.RZZ.eI.; */ \
	0xbd,0xaf,0xa5,0x75,0xa4,0x2c,0x65,0xba,0xb4,0x2a,0x97,0x46,0xe6,0xd4,0x73,0x6a, /* ...u.,e....F..sj */ \
	0x81,0x8b,0xae,0x5d,0x6f,0x7f,0x6f,0x29,0x0c,0xf1,0xf3,0x55,0xed,0x5e,0xdf,0xd2, /* ...]o.o)...U.^.. */ \
	0x98,0x9e,0x8e,0x46,0xa3,0x13,0x3a,0x3a,0x5a,0xd8,0xfd,0x3d,0x0a,0x06,0x3a,0x0d, /* ...F..::Z..=..:. */ \
	0x8b,0x81,0x06,0xac,0x5a,0x92,0x9e,0xd1,0xe9,0x6f,0xa7,0x6f,0x49,0x2e,0x61,0x99, /* ....Z....o.oI.a. */ \
	0x25,0xa7,0xa9,0x82,0xed,0xd2,0xda,0x80,0x25,0xde,0x89,0x0f,0x97,0x0a,0x7b,0x8e, /* %.......%.....{. */ \
	0xa9,0x94,0x2b,0x3a,0x35,0x46,0xac,0xd3,0xfe,0x49,0x34,0xf1,0xa2,0x54,0x4e,0x09, /* ..+:5F...I4..TN. */ \
	0xe7,0xe1,0xfc,0x32,0x23,0x65,0x7a,0xb1,0x10,0x65,0xce,0x02,0x49,0x6d,0x8a,0x67, /* ...2#ez..e..Im.g */ \
	0xe4,0xe6,0x92,0x70,0xc3,0xd8,0x22,0x0b,0xd0,0x58,0xc2,0x09,0x9c,0xc0,0xe9,0x4c, /* ...p.."..X.....L */ \
	0x10,0x68,0xc8,0xa1,0x8b,0x73,0x16,0x9c,0xa9,0xa2,0x18,0x10,0x28,0x12,0x34,0xab, /* .h...s......(.4. */ \
	0xcb,0xcc,0x33,0x86,0xd7,0x99,0x00,0xef,0x2b,0xe5,0xe6,0xcc,0x7a,0xa5,0x99,0xbb, /* ..3.....+...z... */ \
	0xb7,0xaf,0x2f,0x29,0xd5,0x15,0x4b,0x88,0xa2,0xef,0xa1,0x8d,0xac,0xa4,0x70,0xc0, /* ../)..K.......p. */ \
	0x35,0x38,0x20,0xb4,0xc2,0x33,0xb6,0x61,0xe2,0x18,0x41,0x95,0xb9,0x9c,0x29,0x18, /* 58 ..3.a..A...). */ \
	0x2f,0x8b,0xf5,0xae,0x72,0x2e,0x9c,0x78,0x46,0xa2,0xa4,0x37,0x37,0x97,0x24,0xcb, /* /...r..xF..77.$. */ \
	0x4c,0xe7,0x20,0xd7,0x3a,0xa3,0xca,0x3b,0xc6,0x9a,0x4a,0xb2,0xf5,0x74,0xa1,0x9c, /* L. .:..;..J..t.. */ \
	0xc3,0x6b,0x61,0xe9,0xfa,0xea,0x76,0x42,0xac,0xb3,0x85,0xd3,0xda,0x0c,0x56,0x98, /* .ka...vB......V. */ \
	0x94,0xb3,0xc0,0x49,0x0a,0x1a,0x06,0xd4,0x9e,0x7c,0x10,0x2d,0x1b,0x78,0x00,0xa8, /* ...I.....|.-.x.. */ \
	0x7d,0xdc,0xdf,0x4b,0x7c,0x0c,0x39,0xaa,0x2b,0x78,0xd4,0x90,0x9e,0xbe,0x93,0x99, /* }..K|.9.+x...... */ \
	0xc3,0x6b,0x76,0x06,0x83,0xc1,0x1f,0xd1,0x17,0x57,0x7e,0xc9,0x3b,0xc3,0xaf,0x82, /* .kv......W~.;... */ \
	0xc5,0x09,0x3c,0x6f,0xe2,0xf2,0x39,0xfc,0x12,0x16,0xa3,0xda,0x90,0x7d,0x30,0x66, /* ..<o..9......}0f */ \
	0x4f,0x74,0x5f,0xb6,0xc6,0x60,0xa9,0xbd,0xef,0x0a,0x44,0xf2,0xc6,0xd1,0xd6,0xee, /* Ot_..`....D..... */ \
	0x12,0x07,0xc7,0x8d,0x7c,0xcf,0x1b,0xd6,0x85,0x47,0x0d,0xf6,0x9f,0x19,0x08,0x4a, /* ....|....G.....J */ \
	0x70,0x08,0xe2,0x24,0x7e,0xd8,0xbf,0x31,0x76,0x21,0xa0,0x66,0xe9,0x0a,0x0e,0xd0, /* p..$~..1v!.f.... */ \
	0xab,0x21,0x5c,0xf7,0xca,0xb9,0xea,0x26,0x2c,0xf5,0x09,0xc7,0xa7,0xf8,0xf7,0xc8, /* .!\....&,....... */ \
	0x16,0x38,0xd3,0xb6,0x82,0x3f,0xdd,0x67,0x14,0x86,0xba,0x92,0x65,0x9a,0x32,0xaf, /* .8...?.g....e.2. */ \
	0xe3,0x31,0x5b,0xd7,0xff,0xa5,0xf7,0xeb,0xcb,0x49,0xef,0x59,0x8f,0x1d,0xd6,0x1b, /* .1[......I.Y.... */ \
	0x50,0x87,0x94,0x81,0x0f,0x94,0x2f,0x81,0xf1,0x29,0x3c,0x56,0x23,0xc4,0xb1,0x3f, /* P...../..)<V#..? */ \
	0xa3,0x95,0x3c,0x30,0x08,0x6d,0xcb,0xa1,0x71,0xf1,0xf2,0x67,0x44,0xc9,0xba,0x90, /* ..<0.m..q..gD... */ \
	0x94,0x2e,0xc4,0x1a,0x51,0xf2,0x74,0xf8,0x94,0x53,0xa1,0x42,0x56,0x4f,0x0b,0x0e, /* ....Q.t..S.BVO.. */ \
	0x43,0xdd,0x0f,0xba,0x0f,0x24,0x0b,0xce,0xf9,0x96,0x86,0x53,0x84,0xca,0x52,0xbe, /* C....$.....S..R. */ \
	0x0d,0xfe,0xfc,0x0a,0x16,0xb6,0xe4,0xd3,0x9e,0xaf,0x36,0x56,0xcf,0x9c,0xe7,0x73, /* ..........6V...s */ \
	0x32,0xb9,0xee,0x75,0x8f,0x82,0x6d,0x76,0x50,0xb6,0x76,0xf8,0xee,0xd4,0x7d,0x15, /* 2..u..mvP.v...}. */ \
	0x7d,0x9e,0x86,0xc8,0x46,0xb8,0x84,0xdf,0x46,0xb1,0x10,0xd6,0x9d,0x21,0x51,0x91, /* }...F...F....!Q. */ \
	0x62,0xe3,0x36,0xae,0x87,0x77,0xd2,0xf1,0x4d,0xeb,0xf6,0xd6,0x15,0xbe,0xa4,0x21, /* b.6..w..M......! */ \
	0xa9,0x7d,0xc6,0x08,0x2e,0x51,0x61,0xa9,0x29,0x5e,0xc3,0xaa,0xb6,0xf3,0x86,0x06, /* .}...Qa.)^...... */ \
	0xd6,0x7e,0x88,0xf5,0xeb,0x52,0xeb,0xca,0x92,0x5e,0x22,0xfa,0xb9,0x2c,0xe0,0xdc, /* .~...R...^"..,.. */ \
	0x39,0xfb,0x72,0xa7,0x20,0xe6,0x4d,0x21,0x06,0x99,0x08,0xea,0x35,0xaa,0x98,0xcf, /* 9.r. .M!....5... */ \
	0x6d,0x65,0x7d,0x54,0x2b,0x14,0xe1,0x4e,0xc6,0x57,0xba,0x28,0x18,0x20,0x05,0xcf, /* me}T+..N.W.(. .. */ \
	0x49,0x4c,0xcd,0xac,0x36,0xff,0x25,0x71,0x79,0x51,0x16,0xa2,0xb2,0x32,0xdf,0x24, /* IL..6.%qyQ...2.$ */ \
	0xd7,0x8d,0x14,0x28,0xf6,0xb3,0x99,0xcf,0xaa,0xb6,0x3c,0x87,0x3a,0x81,0xb3,0xc0, /* ...(......<.:... */ \
	0xca,0xe9,0x9a,0x2f,0x90,0x46,0x53,0x49,0x15,0x50,0x5b,0x1e,0x0a,0x59,0xde,0xb9, /* .../.FSI.P[..Y.. */ \
	0xf9,0x09,0x29,0x7a,0x4e,0x68,0x0b,0xea,0xf0,0x10,0x31,0x99,0x70,0xd5,0x49,0x36, /* ..)zNh....1.p.I6 */ \
	0x26,0xb6,0xd2,0x76,0xae,0x66,0xd1,0x4c,0x4e,0xda,0x1f,0xa2,0x08,0xab,0x24,0xbe, /* &..v.f.LN.....$. */ \
	0x7c,0xab,0xb2,0x96,0x7e,0x35,0x1a,0xf9,0xa8,0xb3,0xe8,0xb0,0x39,0x7e,0xc7,0xad, /* |...~5......9~.. */ \
	0x5e,0x2b,0xe1,0x13,0x25,0x4d,0x2a,0xa1,0xac,0x66,0x52,0xe6,0xcc,0xa5,0xdf,0xae, /* ^+..%M...fR..... */ \
	0x51,0x6a,0x82,0x08,0x35,0x25,0x5f,0xa3,0x91,0xa2,0xb0,0x8c,0xc7,0xf4,0x13,0xfd, /* Qj..5%_......... */ \
	0xf8,0x23,0xed,0x8a,0x58,0xac,0xd6,0x96,0x97,0xd1,0xc3,0x7d,0x98,0x27,0x0d,0xbe, /* .#..X......}.'.. */ \
	0x72,0x34,0x17,0xdc,0xa6,0x3a,0xc5,0x77,0x65,0xd0,0x00,0x62,0x71,0xb2,0x75,0xe1, /* r4...:.we..bq.u. */ \
	0xbc,0x38,0x76,0x76,0xeb,0x4a,0xea,0x8d,0x01,0xad,0x46,0x9f,0x91,0x0f,0x1a,0x47, /* .8vv.J....F....G */ \
	0x1f,0xf4,0x03,0x7e,0xf2,0x89,0xdc,0x23,0xa6,0x87,0x5e,0x85,0xfc,0x1c,0x36,0x7d, /* ...~...#..^...6} */ \
	0xee,0x65,0x21,0xf9,0x12,0xd8,0x4d,0x36,0x35,0xe1,0xcb,0x9b,0x87,0x3e,0x74,0xd0, /* .e!...M65....>t. */ \
	0x9c,0x2d,0x69,0xd0,0x98,0xee,0x88,0xf8,0x62,0x7d,0x91,0x3f,0xa2,0x3e,0x54,0x25, /* .-i.....b}.?.>T% */ \
	0x2e,0xaf,0x26,0xe8,0x96,0xe3,0x4f,0x88,0x6b,0x0c,0x9c,0xc8,0x0f,0xae,0x31,0x08, /* ..&...O.k.....1. */ \
	0xbc,0xa5,0x1a,0xe4,0x98,0x95,0xb2,0xdc,0x9e,0xa9,0xc4,0x13,0x67,0x07,0x0f,0x2e, /* ............g... */ \
	0x5c,0x16,0x68,0x29,0x0a,0x94,0xe1,0x10,0x0e,0xf8,0xe1,0x8c,0x4b,0x76,0x91,0xc5, /* \.h)........Kv.. */ \
	0x54,0x9b,0x18,0x43,0x8f,0xad,0x6f,0x5a,0xc7,0x96,0xaf,0x0e,0xac,0x9f,0x76,0xb8, /* T..C..oZ......v. */ \
	0xdf,0x08,0x2e,0x9e,0xb1,0x79,0x0c,0xd8,0x59,0x25,0xdb,0x62,0x75,0xe3,0xac,0x06, /* .....y..Y%.bu... */ \
	0x30,0x48,0x07,0x63,0x92,0x9d,0xae,0xdb,0xc8,0x84,0xee,0xbb,0x4b,0xcd,0xe6,0x55, /* 0H.c........K..U */ \
	0xc4,0x38,0xf9,0x34,0xc0,0x1f,0xf8,0xa7,0x1b,0xad,0x07,0x4b,0x49,0x2b,0xa1,0x78, /* .8.4.......KI+.x */ \
	0x08,0xf0,0xe5,0xe3,0x18,0x9d,0x0e,0x1a,0x79,0x34,0x11,0xe1,0xdc,0x4e,0x65,0x31, /* ........y4...Ne1 */ \
	0x9e,0x9b,0x1c,0x79,0xbe,0x99,0xcf,0xba,0x21,0x5a,0x2e,0xf5,0x7d,0x08,0xc6,0x1a, /* ...y....!Z..}... */ \
	0xe3,0xe4,0x66,0xe8,0xf1,0xc3,0x8e,0xa7,0x5b,0x95,0x55,0xfd,0xfd,0x62,0xd4,0x17, /* ..f.....[.U..b.. */ \
	0xf6,0xad,0xe0,0x8b,0xa2,0x30,0xe6,0xb4,0x90,0xc6,0xb5,0xb6,0x84,0xd7,0x82,0xdf, /* .....0.......... */ \
	0xa5,0xbd,0x48,0x29,0xcd,0x84,0x42,0x1a,0x0f,0xff,0x2a,0xcf,0x34,0xe2,0xaa,0x9d  /* ..H)..B.....4... */
#define DATACHUNK000003 \
	0xcf,0x72,0x54,0xcd,0x42,0x57,0x7e,0x90,0x9b,0x6a,0x61,0x72,0x90,0x64,0xa9,0xd0, /* .rT.BW~..jar.d.. */ \
	0xa8,0x26,0xbd,0x66,0x37,0xef,0xeb,0x6f,0x0b,0x96,0x58,0x3a,0xfe,0x1f,0xf1,0x72, /* .&.f7..o..X:...r */ \
	0xd5,0x24,0xd1,0x80,0xde,0xd5,0x28,0xd5,0xf7,0x52,0x56,0x3e,0x76,0x90,0x4c,0x2c, /* .$....(..RV>v.L, */ \
	0xb2,0xdd,0xa5,0x9a,0x22,0xcb,0x30,0x0f,0x9b,0x89,0x8a,0xdb,0x13,0xba,0x9b,0x95, /* ....".0......... */ \
	0xc5,0x92,0xa7,0xed,0x3b,0x58,0xc2,0x0d,0xef,0x78,0xc4,0x83,0x7d,0x62,0x43,0xb1, /* ....;X...x..}bC. */ \
	0x45,0xb0,0xa5,0xbd,0x4d,0xff,0xe9,0x0d,0x8e,0x47,0xfd,0xd0,0x38,0x1e,0x22,0x67, /* E...M....G..8."g */ \
	0x80,0xba,0x16,0x40,0xb1,0xde,0xbb,0x1f,0x16,0xc5,0x4d,0x33,0x46,0x1b,0xe9,0x6a, /* ...@......M3F..j */ \
	0x53,0x22,0x3e,0xd1,0x3d,0x30,0xfc,0xc6,0x51,0x22,0x4e,0x5a,0xed,0x18,0x8a,0xf9, /* S">.=0..Q"NZ.... */ \
	0x18,0x4a,0xe7,0x7e,0x44,0x8e,0x08,0xfc,0xd0,0x6a,0xfb,0x1d,0x30,0xbc,0xcb,0x22, /* .J.~D....j..0.." */ \
	0x0f,0x02,0xfe,0x96,0x23,0xc3,0x4a,0x61,0xb2,0x39,0x17,0x8f,0x4e,0xaf,0x44,0xd5, /* ....#.Ja.9..N.D. */ \
	0xc2,0x46,0x7f,0x70,0x1d,0x49,0x23,0xd4,0x20,0xa8,0x84,0xd4,0x70,0x66,0x1d,0xc2, /* .F.p.I#. ...pf.. */ \
	0x12,0x8e,0x8b,0xeb,0x9d,0x4a,0x67,0x5f,0xac,0x27,0xe2,0xee,0x77,0x81,0x2e,0x13, /* .....Jg_.'..w... */ \
	0x74,0xfe,0x1c,0xfd,0x3d,0x9c,0x29,0x83,0x26,0x33,0x57,0x45,0x3e,0x2c,0x31,0xba, /* t...=.).&3WE>,1. */ \
	0x7b,0xec,0xe0,0xe5,0x60,0x23,0x7d,0x03,0x4e,0xec,0x75,0x56,0x76,0xf1,0x9a,0x90, /* {...`#}.N.uVv... */ \
	0x7c,0xc0,0xa7,0x85,0xcb,0xe6,0xa9,0x34,0x48,0xc2,0x8f,0xd4,0x5d,0xe5,0x21,0x27, /* |......4H...].!' */ \
	0x8e,0x1c,0xf7,0x0a,0x1f,0x82,0x4d,0xf7,0xf6,0x73,0xc6,0x9b,0x0a,0x93,0x11,0x67, /* ......M..s.....g */ \
	0xd9,0xe7,0x9c,0x88,0x4f,0xb8,0xf0,0xc1,0xf5,0x2f,0xde,0xe8,0x9b,0x2d,0xa8,0x0e, /* ....O..../...-.. */ \
	0x00,0x00,0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e, /* ..~inc:header.in */ \
	0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e, /* c~..<div id="con */ \
	0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x41,0x75, /* tent">....<h1>Au */ \
	0x74,0x68,0x65,0x6e,0x74,0x69,0x63,0x61,0x74,0x69,0x6f,0x6e,0x3c,0x2f,0x68,0x31, /* thentication</h1 */ \
	0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x3e,0x4d,0x61,0x6e,0x79,0x20,0x61,0x70,0x70, /* >....<p>Many app */ \
	0x6c,0x69,0x63,0x61,0x74,0x69,0x6f,0x6e,0x73,0x20,0x6e,0x65,0x65,0x64,0x20,0x74, /* lications need t */ \
	0x6f,0x20,0x72,0x65,0x73,0x74,0x72,0x69,0x63,0x74,0x20,0x61,0x63,0x63,0x65,0x73, /* o restrict acces */ \
	0x73,0x20,0x74,0x6f,0x20,0x61,0x75,0x74,0x68,0x6f,0x72,0x69,0x7a,0x65,0x64,0x20, /* s to authorized  */ \
	0x75,0x73,0x65,0x72,0x73,0x2e,0x20,0x20,0x54,0x68,0x65,0x20,0x48,0x54,0x54,0x50, /* users.  The HTTP */ \
	0x20,0x0d,0x0a,0x73,0x65,0x72,0x76,0x65,0x72,0x20,0x73,0x75,0x70,0x70,0x6f,0x72, /*  ..server suppor */ \
	0x74,0x73,0x20,0x42,0x61,0x73,0x69,0x63,0x20,0x48,0x54,0x54,0x50,0x20,0x41,0x75, /* ts Basic HTTP Au */ \
	0x74,0x68,0x65,0x6e,0x74,0x69,0x63,0x61,0x74,0x69,0x6f,0x6e,0x20,0x74,0x6f,0x20, /* thentication to  */ \
	0x70,0x72,0x6f,0x76,0x69,0x64,0x65,0x20,0x74,0x68,0x69,0x73,0x20,0x66,0x75,0x6e, /* provide this fun */ \
	0x63,0x74,0x69,0x6f,0x6e,0x61,0x6c,0x69,0x74,0x79,0x2e,0x3c,0x2f,0x70,0x3e,0x0d, /* ctionality.</p>. */ \
	0x0a,0x0d,0x0a,0x3c,0x70,0x3e,0x54,0x77,0x6f,0x20,0x66,0x75,0x6e,0x63,0x74,0x69, /* ...<p>Two functi */ \
	0x6f,0x6e,0x73,0x20,0x61,0x72,0x65,0x20,0x69,0x6e,0x76,0x6f,0x6c,0x76,0x65,0x64, /* ons are involved */ \
	0x20,0x77,0x69,0x74,0x68,0x20,0x61,0x75,0x74,0x68,0x65,0x6e,0x74,0x69,0x63,0x61, /*  with authentica */ \
	0x74,0x69,0x6f,0x6e,0x2c,0x20,0x62,0x6f,0x74,0x68,0x20,0x6f,0x66,0x20,0x77,0x68, /* tion, both of wh */ \
	0x69,0x63,0x68,0x20,0x73,0x74,0x6f,0x72,0x65,0x20,0x61,0x0d,0x0a,0x72,0x65,0x74, /* ich store a..ret */ \
	0x75,0x72,0x6e,0x20,0x76,0x61,0x6c,0x75,0x65,0x20,0x69,0x6e,0x20,0x3c,0x63,0x6f, /* urn value in <co */ \
	0x64,0x65,0x3e,0x63,0x75,0x72,0x48,0x54,0x54,0x50,0x2e,0x69,0x73,0x41,0x75,0x74, /* de>curHTTP.isAut */ \
	0x68,0x6f,0x72,0x69,0x7a,0x65,0x64,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x2e,0x20, /* horized</code>.  */ \
	0x20,0x54,0x68,0x65,0x20,0x4d,0x53,0x42,0x20,0x6f,0x66,0x20,0x74,0x68,0x69,0x73, /*  The MSB of this */ \
	0x20,0x76,0x61,0x6c,0x75,0x65,0x0d,0x0a,0x69,0x6e,0x64,0x69,0x63,0x61,0x74,0x65, /*  value..indicate */ \
	0x73,0x20,0x77,0x68,0x65,0x74,0x68,0x65,0x72,0x20,0x6f,0x72,0x20,0x6e,0x6f,0x74, /* s whether or not */ \
	0x20,0x61,0x63,0x63,0x65,0x73,0x73,0x20,0x69,0x73,0x20,0x61,0x6c,0x6c,0x6f,0x77, /*  access is allow */ \
	0x65,0x64,0x2e,0x20,0x20,0x54,0x68,0x65,0x20,0x66,0x69,0x72,0x73,0x74,0x20,0x63, /* ed.  The first c */ \
	0x61,0x6c,0x6c,0x62,0x61,0x63,0x6b,0x2c,0x20,0x0d,0x0a,0x3c,0x63,0x6f,0x64,0x65, /* allback, ..<code */ \
	0x3e,0x48,0x54,0x54,0x50,0x4e,0x65,0x65,0x64,0x73,0x41,0x75,0x74,0x68,0x3c,0x2f, /* >HTTPNeedsAuth</ */ \
	0x63,0x6f,0x64,0x65,0x3e,0x2c,0x20,0x64,0x65,0x74,0x65,0x72,0x6d,0x69,0x6e,0x65, /* code>, determine */ \
	0x73,0x20,0x69,0x66,0x20,0x74,0x68,0x65,0x20,0x72,0x65,0x71,0x75,0x65,0x73,0x74, /* s if the request */ \
	0x65,0x64,0x20,0x70,0x61,0x67,0x65,0x20,0x72,0x65,0x71,0x75,0x69,0x72,0x65,0x73, /* ed page requires */ \
	0x0d,0x0a,0x76,0x61,0x6c,0x69,0x64,0x20,0x63,0x72,0x65,0x64,0x65,0x6e,0x74,0x69, /* ..valid credenti */ \
	0x61,0x6c,0x73,0x20,0x74,0x6f,0x20,0x70,0x72,0x6f,0x63,0x65,0x65,0x64,0x2e,0x20, /* als to proceed.  */ \
	0x20,0x52,0x65,0x74,0x75,0x72,0x6e,0x20,0x61,0x20,0x76,0x61,0x6c,0x75,0x65,0x20, /*  Return a value  */ \
	0x6f,0x66,0x20,0x3c,0x63,0x6f,0x64,0x65,0x3e,0x30,0x78,0x38,0x30,0x3c,0x2f,0x63, /* of <code>0x80</c */ \
	0x6f,0x64,0x65,0x3e,0x20,0x6f,0x72,0x20,0x67,0x72,0x65,0x61,0x74,0x65,0x72,0x20, /* ode> or greater  */ \
	0x0d,0x0a,0x74,0x6f,0x20,0x61,0x6c,0x6c,0x6f,0x77,0x20,0x61,0x63,0x63,0x65,0x73, /* ..to allow acces */ \
	0x73,0x20,0x75,0x6e,0x63,0x6f,0x6e,0x64,0x69,0x74,0x69,0x6f,0x6e,0x61,0x6c,0x6c, /* s unconditionall */ \
	0x79,0x2e,0x20,0x20,0x52,0x65,0x74,0x75,0x72,0x6e,0x20,0x3c,0x63,0x6f,0x64,0x65, /* y.  Return <code */ \
	0x3e,0x30,0x78,0x37,0x39,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x20,0x6f,0x72,0x20, /* >0x79</code> or  */ \
	0x6c,0x6f,0x77,0x65,0x72,0x20,0x74,0x6f,0x20,0x72,0x65,0x71,0x75,0x69,0x72,0x65, /* lower to require */ \
	0x20,0x0d,0x0a,0x61,0x75,0x74,0x68,0x6f,0x72,0x69,0x7a,0x61,0x74,0x69,0x6f,0x6e, /*  ..authorization */ \
	0x2e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x54,0x68,0x65,0x20,0x73,0x65,0x63, /* .</p>....The sec */ \
	0x6f,0x6e,0x64,0x2c,0x20,0x3c,0x63,0x6f,0x64,0x65,0x3e,0x48,0x54,0x54,0x50,0x56, /* ond, <code>HTTPV */ \
	0x65,0x72,0x69,0x66,0x79,0x41,0x75,0x74,0x68,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e, /* erifyAuth</code> */ \
	0x20,0x64,0x65,0x74,0x65,0x72,0x6d,0x69,0x6e,0x65,0x73,0x20,0x69,0x66,0x20,0x74  /*  determines if t */
#define DATACHUNK000004 \
	0x68,0x65,0x20,0x73,0x75,0x70,0x70,0x6c,0x69,0x65,0x64,0x20,0x63,0x72,0x65,0x64, /* he supplied cred */ \
	0x65,0x6e,0x74,0x69,0x61,0x6c,0x73,0x20,0x0d,0x0a,0x61,0x72,0x65,0x20,0x61,0x63, /* entials ..are ac */ \
	0x63,0x65,0x70,0x74,0x61,0x62,0x6c,0x65,0x20,0x66,0x6f,0x72,0x20,0x74,0x68,0x65, /* ceptable for the */ \
	0x20,0x72,0x65,0x71,0x75,0x65,0x73,0x74,0x65,0x64,0x20,0x70,0x61,0x67,0x65,0x2e, /*  requested page. */ \
	0x20,0x20,0x59,0x6f,0x75,0x72,0x20,0x61,0x70,0x70,0x6c,0x69,0x63,0x61,0x74,0x69, /*   Your applicati */ \
	0x6f,0x6e,0x20,0x73,0x68,0x6f,0x75,0x6c,0x64,0x20,0x72,0x65,0x74,0x75,0x72,0x6e, /* on should return */ \
	0x20,0x61,0x20,0x76,0x61,0x6c,0x75,0x65,0x20,0x0d,0x0a,0x67,0x72,0x65,0x61,0x74, /*  a value ..great */ \
	0x65,0x72,0x20,0x74,0x68,0x61,0x6e,0x20,0x3c,0x63,0x6f,0x64,0x65,0x3e,0x30,0x78, /* er than <code>0x */ \
	0x38,0x30,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x20,0x74,0x6f,0x20,0x70,0x65,0x72, /* 80</code> to per */ \
	0x6d,0x69,0x74,0x20,0x61,0x63,0x63,0x65,0x73,0x73,0x2c,0x20,0x6f,0x72,0x20,0x61, /* mit access, or a */ \
	0x20,0x76,0x61,0x6c,0x75,0x65,0x20,0x6c,0x65,0x73,0x73,0x20,0x74,0x68,0x61,0x6e, /*  value less than */ \
	0x20,0x0d,0x0a,0x3c,0x63,0x6f,0x64,0x65,0x3e,0x30,0x78,0x37,0x39,0x3c,0x2f,0x63, /*  ..<code>0x79</c */ \
	0x6f,0x64,0x65,0x3e,0x20,0x74,0x6f,0x20,0x72,0x65,0x6a,0x65,0x63,0x74,0x20,0x74, /* ode> to reject t */ \
	0x68,0x65,0x20,0x70,0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x20,0x73,0x75,0x70,0x70, /* he password supp */ \
	0x6c,0x69,0x65,0x64,0x2e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x3e, /* lied.</p>....<p> */ \
	0x41,0x73,0x20,0x61,0x6e,0x20,0x65,0x78,0x61,0x6d,0x70,0x6c,0x65,0x2c,0x20,0x61, /* As an example, a */ \
	0x63,0x63,0x65,0x73,0x73,0x20,0x74,0x68,0x69,0x73,0x20,0x72,0x65,0x73,0x74,0x72, /* ccess this restr */ \
	0x69,0x63,0x74,0x65,0x64,0x20,0x70,0x61,0x67,0x65,0x3a,0x3c,0x2f,0x70,0x3e,0x0d, /* icted page:</p>. */ \
	0x0a,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x65, /* ...<div class="e */ \
	0x78,0x61,0x6d,0x70,0x6c,0x65,0x62,0x6f,0x78,0x22,0x3e,0x0d,0x0a,0x3c,0x62,0x3e, /* xamplebox">..<b> */ \
	0x55,0x73,0x65,0x72,0x20,0x4e,0x61,0x6d,0x65,0x3a,0x3c,0x2f,0x62,0x3e,0x20,0x61, /* User Name:</b> a */ \
	0x64,0x6d,0x69,0x6e,0x20,0x26,0x6e,0x62,0x73,0x70,0x3b,0x20,0x26,0x6e,0x62,0x73, /* dmin &nbsp; &nbs */ \
	0x70,0x3b,0x20,0x26,0x6e,0x62,0x73,0x70,0x3b,0x20,0x3c,0x62,0x3e,0x50,0x61,0x73, /* p; &nbsp; <b>Pas */ \
	0x73,0x77,0x6f,0x72,0x64,0x3a,0x3c,0x2f,0x62,0x3e,0x20,0x6d,0x69,0x63,0x72,0x6f, /* sword:</b> micro */ \
	0x63,0x68,0x69,0x70,0x3c,0x62,0x72,0x20,0x2f,0x3e,0x0d,0x0a,0x3c,0x61,0x20,0x68, /* chip<br />..<a h */ \
	0x72,0x65,0x66,0x3d,0x22,0x2f,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x22,0x3e,0x41, /* ref="/protect">A */ \
	0x63,0x63,0x65,0x73,0x73,0x20,0x52,0x65,0x73,0x74,0x72,0x69,0x63,0x74,0x65,0x64, /* ccess Restricted */ \
	0x20,0x50,0x61,0x67,0x65,0x3c,0x2f,0x61,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76, /*  Page</a>..</div */ \
	0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c, /* >....</div>....< */ \
	0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78, /* script type="tex */ \
	0x74,0x2f,0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x0d,0x0a, /* t/javascript">.. */ \
	0x3c,0x21,0x2d,0x2d,0x0d,0x0a,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x67, /* <!--..document.g */ \
	0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28,0x27,0x68, /* etElementById('h */ \
	0x65,0x6c,0x6c,0x6f,0x27,0x29,0x2e,0x69,0x6e,0x6e,0x65,0x72,0x48,0x54,0x4d,0x4c, /* ello').innerHTML */ \
	0x20,0x3d,0x20,0x22,0x7e,0x68,0x65,0x6c,0x6c,0x6f,0x6d,0x73,0x67,0x7e,0x22,0x3b, /*  = "~hellomsg~"; */ \
	0x0d,0x0a,0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70,0x74,0x3e, /* ..-->..</script> */ \
	0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e, /* ..~inc:footer.in */ \
	0x63,0x7e,0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0x12,0x05,0x00,0x00,0x01,0x00, /* c~....3......... */ \
	0x00,0x00,0x30,0x05,0x00,0x00,0x02,0x00,0x00,0x00,0x7e,0x69,0x6e,0x63,0x3a,0x68, /* ..0.......~inc:h */ \
	0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76, /* eader.inc~..<div */ \
	0x20,0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a, /*  id="content">.. */ \
	0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x43,0x6f,0x6f,0x6b,0x69,0x65,0x73,0x3c,0x2f,0x68, /* ..<h1>Cookies</h */ \
	0x31,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x3e,0x43,0x6f,0x6f,0x6b,0x69,0x65,0x73, /* 1>....<p>Cookies */ \
	0x20,0x61,0x72,0x65,0x20,0x73,0x6d,0x61,0x6c,0x6c,0x20,0x74,0x65,0x78,0x74,0x20, /*  are small text  */ \
	0x73,0x74,0x72,0x69,0x6e,0x67,0x73,0x20,0x74,0x68,0x61,0x74,0x20,0x61,0x72,0x65, /* strings that are */ \
	0x20,0x73,0x74,0x6f,0x72,0x65,0x64,0x20,0x69,0x6e,0x20,0x74,0x68,0x65,0x20,0x62, /*  stored in the b */ \
	0x72,0x6f,0x77,0x73,0x65,0x72,0x2e,0x20,0x20,0x54,0x68,0x65,0x73,0x65,0x20,0x73, /* rowser.  These s */ \
	0x74,0x72,0x69,0x6e,0x67,0x73,0x20,0x0d,0x0a,0x61,0x72,0x65,0x20,0x73,0x65,0x74, /* trings ..are set */ \
	0x20,0x62,0x79,0x20,0x74,0x68,0x65,0x20,0x73,0x65,0x72,0x76,0x65,0x72,0x2c,0x20, /*  by the server,  */ \
	0x61,0x6e,0x64,0x20,0x72,0x65,0x74,0x75,0x72,0x6e,0x65,0x64,0x20,0x61,0x73,0x20, /* and returned as  */ \
	0x70,0x61,0x72,0x61,0x6d,0x65,0x74,0x65,0x72,0x73,0x20,0x66,0x6f,0x72,0x20,0x61, /* parameters for a */ \
	0x6c,0x6c,0x20,0x66,0x75,0x74,0x75,0x72,0x65,0x20,0x72,0x65,0x71,0x75,0x65,0x73, /* ll future reques */ \
	0x74,0x73,0x20,0x75,0x6e,0x74,0x69,0x6c,0x20,0x0d,0x0a,0x74,0x68,0x65,0x20,0x73, /* ts until ..the s */ \
	0x65,0x73,0x73,0x69,0x6f,0x6e,0x20,0x65,0x6e,0x64,0x73,0x2e,0x20,0x20,0x54,0x68, /* ession ends.  Th */ \
	0x65,0x79,0x20,0x63,0x61,0x6e,0x20,0x62,0x65,0x20,0x75,0x73,0x65,0x64,0x20,0x74, /* ey can be used t */ \
	0x6f,0x20,0x73,0x74,0x6f,0x72,0x65,0x20,0x73,0x65,0x73,0x73,0x69,0x6f,0x6e,0x20, /* o store session  */ \
	0x73,0x74,0x61,0x74,0x65,0x20,0x69,0x6e,0x66,0x6f,0x72,0x6d,0x61,0x74,0x69,0x6f, /* state informatio */ \
	0x6e,0x2c,0x20,0x61,0x6e,0x64,0x20,0x61,0x72,0x65,0x20,0x0d,0x0a,0x76,0x61,0x6c, /* n, and are ..val */ \
	0x69,0x64,0x20,0x75,0x6e,0x74,0x69,0x6c,0x20,0x74,0x68,0x65,0x20,0x62,0x72,0x6f, /* id until the bro */ \
	0x77,0x73,0x65,0x72,0x20,0x69,0x73,0x20,0x63,0x6c,0x6f,0x73,0x65,0x64,0x2e,0x3c, /* wser is closed.< */ \
	0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x63,0x6c,0x61,0x73, /* /p>....<div clas */ \
	0x73,0x3d,0x22,0x65,0x78,0x61,0x6d,0x70,0x6c,0x65,0x62,0x6f,0x78,0x22,0x3e,0x0d, /* s="examplebox">. */ \
	0x0a,0x3c,0x74,0x61,0x62,0x6c,0x65,0x20,0x61,0x6c,0x69,0x67,0x6e,0x3d,0x22,0x63, /* .<table align="c */ \
	0x65,0x6e,0x74,0x65,0x72,0x22,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64  /* enter">..<tr><td */
#define DATACHUNK000005 \
	0x3e,0x3c,0x62,0x3e,0x4e,0x61,0x6d,0x65,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74, /* ><b>Name:</b></t */ \
	0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x63,0x6f,0x6f,0x6b,0x69,0x65,0x6e,0x61,0x6d, /* d><td>~cookienam */ \
	0x65,0x7e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x74, /* e~</td></tr>..<t */ \
	0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x46,0x61,0x76,0x6f,0x72,0x69,0x74, /* r><td><b>Favorit */ \
	0x65,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x6e, /* e:</b></td><td>n */ \
	0x6f,0x74,0x20,0x69,0x6d,0x70,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x65,0x64,0x3c,0x2f, /* ot implemented</ */ \
	0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x2f,0x74,0x61,0x62,0x6c, /* td></tr>..</tabl */ \
	0x65,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70, /* e>..</div>....<p */ \
	0x3e,0x54,0x68,0x65,0x72,0x65,0x20,0x61,0x72,0x65,0x20,0x6e,0x75,0x6d,0x65,0x72, /* >There are numer */ \
	0x6f,0x75,0x73,0x20,0x75,0x73,0x65,0x73,0x20,0x66,0x6f,0x72,0x20,0x63,0x6f,0x6f, /* ous uses for coo */ \
	0x6b,0x69,0x65,0x73,0x2e,0x20,0x20,0x49,0x6e,0x20,0x74,0x68,0x69,0x73,0x20,0x65, /* kies.  In this e */ \
	0x78,0x61,0x6d,0x70,0x6c,0x65,0x2c,0x20,0x74,0x68,0x65,0x20,0x75,0x73,0x65,0x72, /* xample, the user */ \
	0x27,0x73,0x20,0x6e,0x61,0x6d,0x65,0x20,0x69,0x73,0x20,0x0d,0x0a,0x73,0x74,0x6f, /* 's name is ..sto */ \
	0x72,0x65,0x64,0x20,0x61,0x73,0x20,0x61,0x20,0x63,0x6f,0x6f,0x6b,0x69,0x65,0x2e, /* red as a cookie. */ \
	0x20,0x20,0x41,0x6c,0x6c,0x20,0x66,0x75,0x74,0x75,0x72,0x65,0x20,0x70,0x61,0x67, /*   All future pag */ \
	0x65,0x20,0x6c,0x6f,0x61,0x64,0x73,0x20,0x77,0x69,0x6c,0x6c,0x20,0x73,0x68,0x6f, /* e loads will sho */ \
	0x77,0x20,0x74,0x68,0x69,0x73,0x20,0x6e,0x61,0x6d,0x65,0x20,0x69,0x6e,0x20,0x74, /* w this name in t */ \
	0x68,0x65,0x20,0x74,0x6f,0x70,0x20,0x6c,0x65,0x66,0x74,0x20,0x0d,0x0a,0x63,0x6f, /* he top left ..co */ \
	0x72,0x6e,0x65,0x72,0x2c,0x20,0x61,0x73,0x20,0x77,0x65,0x6c,0x6c,0x20,0x61,0x73, /* rner, as well as */ \
	0x20,0x69,0x6e,0x20,0x74,0x68,0x65,0x20,0x62,0x6f,0x78,0x20,0x61,0x62,0x6f,0x76, /*  in the box abov */ \
	0x65,0x2e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x66,0x6f,0x72,0x6d,0x20, /* e.</p>....<form  */ \
	0x61,0x63,0x74,0x69,0x6f,0x6e,0x3d,0x22,0x63,0x6f,0x6f,0x6b,0x69,0x65,0x73,0x2e, /* action="cookies. */ \
	0x68,0x74,0x6d,0x22,0x20,0x6d,0x65,0x74,0x68,0x6f,0x64,0x3d,0x22,0x67,0x65,0x74, /* htm" method="get */ \
	0x22,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22, /* ">..<div class=" */ \
	0x65,0x78,0x61,0x6d,0x70,0x6c,0x65,0x62,0x6f,0x78,0x22,0x3e,0x0d,0x0a,0x3c,0x74, /* examplebox">..<t */ \
	0x61,0x62,0x6c,0x65,0x20,0x61,0x6c,0x69,0x67,0x6e,0x3d,0x22,0x63,0x65,0x6e,0x74, /* able align="cent */ \
	0x65,0x72,0x22,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62, /* er">..<tr><td><b */ \
	0x3e,0x46,0x69,0x72,0x73,0x74,0x20,0x4e,0x61,0x6d,0x65,0x3a,0x3c,0x2f,0x62,0x3e, /* >First Name:</b> */ \
	0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20, /* </td><td><input  */ \
	0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65, /* type="text" name */ \
	0x3d,0x22,0x6e,0x61,0x6d,0x65,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x32,0x30, /* ="name" size="20 */ \
	0x22,0x20,0x6d,0x61,0x78,0x6c,0x65,0x6e,0x67,0x74,0x68,0x3d,0x22,0x31,0x36,0x22, /* " maxlength="16" */ \
	0x20,0x2f,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c, /*  /></td></tr>..< */ \
	0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x46,0x61,0x76,0x6f,0x72,0x69, /* tr><td><b>Favori */ \
	0x74,0x65,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e, /* te:</b></td><td> */ \
	0x0d,0x0a,0x3c,0x73,0x65,0x6c,0x65,0x63,0x74,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22, /* ..<select name=" */ \
	0x66,0x61,0x76,0x22,0x3e,0x0d,0x0a,0x3c,0x6f,0x70,0x74,0x69,0x6f,0x6e,0x20,0x76, /* fav">..<option v */ \
	0x61,0x6c,0x75,0x65,0x3d,0x22,0x50,0x49,0x43,0x31,0x38,0x22,0x3e,0x50,0x49,0x43, /* alue="PIC18">PIC */ \
	0x31,0x38,0x3c,0x2f,0x6f,0x70,0x74,0x69,0x6f,0x6e,0x3e,0x0d,0x0a,0x3c,0x6f,0x70, /* 18</option>..<op */ \
	0x74,0x69,0x6f,0x6e,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x50,0x49,0x43,0x32, /* tion value="PIC2 */ \
	0x34,0x22,0x3e,0x50,0x49,0x43,0x32,0x34,0x3c,0x2f,0x6f,0x70,0x74,0x69,0x6f,0x6e, /* 4">PIC24</option */ \
	0x3e,0x0d,0x0a,0x3c,0x6f,0x70,0x74,0x69,0x6f,0x6e,0x20,0x76,0x61,0x6c,0x75,0x65, /* >..<option value */ \
	0x3d,0x22,0x64,0x73,0x50,0x49,0x43,0x22,0x3e,0x64,0x73,0x50,0x49,0x43,0x3c,0x2f, /* ="dsPIC">dsPIC</ */ \
	0x6f,0x70,0x74,0x69,0x6f,0x6e,0x3e,0x0d,0x0a,0x3c,0x6f,0x70,0x74,0x69,0x6f,0x6e, /* option>..<option */ \
	0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x50,0x49,0x43,0x33,0x32,0x22,0x3e,0x50, /*  value="PIC32">P */ \
	0x49,0x43,0x33,0x32,0x3c,0x2f,0x6f,0x70,0x74,0x69,0x6f,0x6e,0x3e,0x0d,0x0a,0x3c, /* IC32</option>..< */ \
	0x2f,0x73,0x65,0x6c,0x65,0x63,0x74,0x3e,0x0d,0x0a,0x3c,0x2f,0x74,0x64,0x3e,0x3c, /* /select>..</td>< */ \
	0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x2f, /* /tr>..<tr><td></ */ \
	0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79, /* td><td><input ty */ \
	0x70,0x65,0x3d,0x22,0x73,0x75,0x62,0x6d,0x69,0x74,0x22,0x20,0x76,0x61,0x6c,0x75, /* pe="submit" valu */ \
	0x65,0x3d,0x22,0x53,0x65,0x74,0x20,0x43,0x6f,0x6f,0x6b,0x69,0x65,0x73,0x22,0x20, /* e="Set Cookies"  */ \
	0x2f,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x2f, /* /></td></tr>..</ */ \
	0x74,0x61,0x62,0x6c,0x65,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a, /* table>..</div>.. */ \
	0x3c,0x2f,0x66,0x6f,0x72,0x6d,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x3e,0x43,0x6f, /* </form>....<p>Co */ \
	0x6f,0x6b,0x69,0x65,0x73,0x20,0x61,0x72,0x65,0x20,0x73,0x65,0x74,0x20,0x62,0x79, /* okies are set by */ \
	0x20,0x73,0x74,0x6f,0x72,0x69,0x6e,0x67,0x20,0x6e,0x75,0x6c,0x6c,0x2d,0x74,0x65, /*  storing null-te */ \
	0x72,0x6d,0x69,0x6e,0x61,0x74,0x65,0x64,0x20,0x6e,0x61,0x6d,0x65,0x2f,0x76,0x61, /* rminated name/va */ \
	0x6c,0x75,0x65,0x20,0x70,0x61,0x69,0x72,0x73,0x20,0x69,0x6e,0x20,0x3c,0x63,0x6f, /* lue pairs in <co */ \
	0x64,0x65,0x3e,0x63,0x75,0x72,0x48,0x54,0x54,0x50,0x2e,0x64,0x61,0x74,0x61,0x3c, /* de>curHTTP.data< */ \
	0x2f,0x63,0x6f,0x64,0x65,0x3e,0x20,0x0d,0x0a,0x61,0x6e,0x64,0x20,0x69,0x6e,0x64, /* /code> ..and ind */ \
	0x69,0x63,0x61,0x74,0x69,0x6e,0x67,0x20,0x68,0x6f,0x77,0x20,0x6d,0x61,0x6e,0x79, /* icating how many */ \
	0x20,0x63,0x6f,0x6f,0x6b,0x69,0x65,0x73,0x20,0x61,0x72,0x65,0x20,0x74,0x6f,0x20, /*  cookies are to  */ \
	0x62,0x65,0x20,0x73,0x65,0x74,0x20,0x69,0x6e,0x20,0x3c,0x63,0x6f,0x64,0x65,0x3e, /* be set in <code> */ \
	0x63,0x75,0x72,0x48,0x54,0x54,0x50,0x2e,0x68,0x61,0x73,0x41,0x72,0x67,0x73,0x3c  /* curHTTP.hasArgs< */
#define DATACHUNK000006 \
	0x2f,0x63,0x6f,0x64,0x65,0x3e,0x2e,0x20,0x20,0x54,0x68,0x65,0x79,0x20,0x0d,0x0a, /* /code>.  They .. */ \
	0x63,0x61,0x6e,0x20,0x62,0x65,0x20,0x73,0x65,0x74,0x20,0x69,0x6e,0x20,0x65,0x69, /* can be set in ei */ \
	0x74,0x68,0x65,0x72,0x20,0x3c,0x63,0x6f,0x64,0x65,0x3e,0x48,0x54,0x54,0x50,0x45, /* ther <code>HTTPE */ \
	0x78,0x65,0x63,0x75,0x74,0x65,0x47,0x65,0x74,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e, /* xecuteGet</code> */ \
	0x20,0x6f,0x72,0x20,0x3c,0x63,0x6f,0x64,0x65,0x3e,0x48,0x54,0x54,0x50,0x45,0x78, /*  or <code>HTTPEx */ \
	0x65,0x63,0x75,0x74,0x65,0x50,0x6f,0x73,0x74,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e, /* ecutePost</code> */ \
	0x2e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x3e,0x43,0x6f,0x6f,0x6b, /* .</p>....<p>Cook */ \
	0x69,0x65,0x73,0x20,0x61,0x72,0x65,0x20,0x72,0x65,0x74,0x72,0x69,0x65,0x76,0x65, /* ies are retrieve */ \
	0x64,0x20,0x69,0x6e,0x20,0x74,0x68,0x65,0x20,0x73,0x61,0x6d,0x65,0x20,0x6d,0x61, /* d in the same ma */ \
	0x6e,0x6e,0x65,0x72,0x20,0x61,0x73,0x20,0x47,0x45,0x54,0x20,0x66,0x6f,0x72,0x6d, /* nner as GET form */ \
	0x20,0x61,0x72,0x67,0x75,0x6d,0x65,0x6e,0x74,0x73,0x2e,0x20,0x20,0x54,0x68,0x65, /*  arguments.  The */ \
	0x79,0x20,0x61,0x72,0x65,0x20,0x73,0x74,0x6f,0x72,0x65,0x64,0x20,0x0d,0x0a,0x69, /* y are stored ..i */ \
	0x6e,0x20,0x3c,0x63,0x6f,0x64,0x65,0x3e,0x63,0x75,0x72,0x48,0x54,0x54,0x50,0x2e, /* n <code>curHTTP. */ \
	0x64,0x61,0x74,0x61,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x20,0x61,0x6e,0x64,0x20, /* data</code> and  */ \
	0x63,0x61,0x6e,0x20,0x62,0x65,0x20,0x6c,0x6f,0x63,0x61,0x74,0x65,0x64,0x20,0x75, /* can be located u */ \
	0x73,0x69,0x6e,0x67,0x20,0x74,0x68,0x65,0x20,0x3c,0x63,0x6f,0x64,0x65,0x3e,0x48, /* sing the <code>H */ \
	0x54,0x54,0x50,0x47,0x65,0x74,0x41,0x72,0x67,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e, /* TTPGetArg</code> */ \
	0x20,0x0d,0x0a,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x73,0x2e,0x20,0x20,0x53, /*  ..functions.  S */ \
	0x69,0x6e,0x63,0x65,0x20,0x74,0x68,0x65,0x79,0x20,0x61,0x72,0x65,0x20,0x73,0x74, /* ince they are st */ \
	0x6f,0x72,0x65,0x64,0x20,0x69,0x6e,0x20,0x74,0x68,0x65,0x20,0x73,0x61,0x6d,0x65, /* ored in the same */ \
	0x20,0x61,0x72,0x72,0x61,0x79,0x20,0x61,0x73,0x20,0x47,0x45,0x54,0x20,0x61,0x72, /*  array as GET ar */ \
	0x67,0x75,0x6d,0x65,0x6e,0x74,0x73,0x2c,0x20,0x74,0x68,0x65,0x20,0x74,0x6f,0x74, /* guments, the tot */ \
	0x61,0x6c,0x20,0x0d,0x0a,0x6c,0x65,0x6e,0x67,0x74,0x68,0x20,0x6f,0x66,0x20,0x63, /* al ..length of c */ \
	0x6f,0x6f,0x6b,0x69,0x65,0x73,0x20,0x61,0x6e,0x64,0x20,0x76,0x61,0x72,0x69,0x61, /* ookies and varia */ \
	0x62,0x6c,0x65,0x20,0x61,0x72,0x67,0x75,0x6d,0x65,0x6e,0x74,0x73,0x20,0x63,0x61, /* ble arguments ca */ \
	0x6e,0x6e,0x6f,0x74,0x20,0x65,0x78,0x63,0x65,0x65,0x64,0x20,0x74,0x68,0x65,0x20, /* nnot exceed the  */ \
	0x38,0x30,0x20,0x62,0x79,0x74,0x65,0x20,0x62,0x75,0x66,0x66,0x65,0x72,0x20,0x6c, /* 80 byte buffer l */ \
	0x69,0x6d,0x69,0x74,0x2e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x20, /* imit.</p>....<p  */ \
	0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x65,0x78,0x65,0x72,0x63,0x69,0x73,0x65,0x22, /* class="exercise" */ \
	0x3e,0x3c,0x62,0x3e,0x45,0x78,0x65,0x72,0x63,0x69,0x73,0x65,0x3a,0x3c,0x2f,0x62, /* ><b>Exercise:</b */ \
	0x3e,0x20,0x53,0x65,0x74,0x20,0x61,0x20,0x73,0x65,0x63,0x6f,0x6e,0x64,0x20,0x63, /* > Set a second c */ \
	0x6f,0x6f,0x6b,0x69,0x65,0x20,0x6e,0x61,0x6d,0x65,0x64,0x20,0x3c,0x63,0x6f,0x64, /* ookie named <cod */ \
	0x65,0x3e,0x66,0x61,0x76,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x20,0x77,0x69,0x74, /* e>fav</code> wit */ \
	0x68,0x20,0x74,0x68,0x65,0x20,0x0d,0x0a,0x76,0x61,0x6c,0x75,0x65,0x20,0x6f,0x66, /* h the ..value of */ \
	0x20,0x74,0x68,0x65,0x20,0x3c,0x63,0x6f,0x64,0x65,0x3e,0x66,0x61,0x76,0x6f,0x72, /*  the <code>favor */ \
	0x69,0x74,0x65,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x20,0x66,0x69,0x65,0x6c,0x64, /* ite</code> field */ \
	0x20,0x61,0x6e,0x64,0x20,0x68,0x61,0x76,0x65,0x20,0x69,0x74,0x20,0x64,0x69,0x73, /*  and have it dis */ \
	0x70,0x6c,0x61,0x79,0x65,0x64,0x20,0x69,0x6e,0x20,0x74,0x68,0x65,0x20,0x67,0x72, /* played in the gr */ \
	0x61,0x79,0x20,0x62,0x6f,0x78,0x20,0x61,0x62,0x6f,0x76,0x65,0x2e,0x3c,0x2f,0x70, /* ay box above.</p */ \
	0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c, /* >....</div>....< */ \
	0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78, /* script type="tex */ \
	0x74,0x2f,0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x0d,0x0a, /* t/javascript">.. */ \
	0x3c,0x21,0x2d,0x2d,0x0d,0x0a,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x67, /* <!--..document.g */ \
	0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28,0x27,0x68, /* etElementById('h */ \
	0x65,0x6c,0x6c,0x6f,0x27,0x29,0x2e,0x69,0x6e,0x6e,0x65,0x72,0x48,0x54,0x4d,0x4c, /* ello').innerHTML */ \
	0x20,0x3d,0x20,0x22,0x7e,0x68,0x65,0x6c,0x6c,0x6f,0x6d,0x73,0x67,0x7e,0x22,0x3b, /*  = "~hellomsg~"; */ \
	0x0d,0x0a,0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70,0x74,0x3e, /* ..-->..</script> */ \
	0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e, /* ..~inc:footer.in */ \
	0x63,0x7e,0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0xac,0x01,0x00,0x00,0x03,0x00, /* c~....3......... */ \
	0x00,0x00,0x6a,0x08,0x00,0x00,0x01,0x00,0x00,0x00,0x88,0x08,0x00,0x00,0x02,0x00, /* ..j............. */ \
	0x00,0x00,0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e, /* ..~inc:header.in */ \
	0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e, /* c~..<div id="con */ \
	0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x44,0x79, /* tent">....<h1>Dy */ \
	0x6e,0x61,0x6d,0x69,0x63,0x20,0x56,0x61,0x72,0x69,0x61,0x62,0x6c,0x65,0x73,0x3c, /* namic Variables< */ \
	0x2f,0x68,0x31,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x3e,0x46,0x6f,0x72,0x20,0x73, /* /h1>....<p>For s */ \
	0x68,0x6f,0x72,0x74,0x20,0x6f,0x75,0x74,0x70,0x75,0x74,0x73,0x20,0x28,0x6c,0x65, /* hort outputs (le */ \
	0x73,0x73,0x20,0x74,0x68,0x61,0x6e,0x20,0x31,0x36,0x20,0x62,0x79,0x74,0x65,0x73, /* ss than 16 bytes */ \
	0x29,0x20,0x79,0x6f,0x75,0x20,0x6e,0x65,0x65,0x64,0x20,0x6f,0x6e,0x6c,0x79,0x20, /* ) you need only  */ \
	0x74,0x6f,0x20,0x63,0x61,0x6c,0x6c,0x20,0x74,0x68,0x65,0x20,0x61,0x70,0x70,0x72, /* to call the appr */ \
	0x6f,0x70,0x72,0x69,0x61,0x74,0x65,0x20,0x0d,0x0a,0x3c,0x63,0x6f,0x64,0x65,0x3e, /* opriate ..<code> */ \
	0x54,0x43,0x50,0x50,0x75,0x74,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x20,0x66,0x75, /* TCPPut</code> fu */ \
	0x6e,0x63,0x74,0x69,0x6f,0x6e,0x20,0x61,0x6e,0x64,0x20,0x72,0x65,0x74,0x75,0x72, /* nction and retur */ \
	0x6e,0x2e,0x20,0x20,0x46,0x6f,0x72,0x20,0x6c,0x6f,0x6e,0x67,0x65,0x72,0x20,0x6f, /* n.  For longer o */ \
	0x75,0x74,0x70,0x75,0x74,0x73,0x20,0x74,0x68,0x65,0x20,0x6f,0x75,0x74,0x70,0x75  /* utputs the outpu */
#define DATACHUNK000007 \
	0x74,0x20,0x73,0x74,0x61,0x74,0x65,0x20,0x6d,0x75,0x73,0x74,0x20,0x62,0x65,0x20, /* t state must be  */ \
	0x0d,0x0a,0x6d,0x61,0x6e,0x61,0x67,0x65,0x64,0x20,0x74,0x68,0x72,0x6f,0x75,0x67, /* ..managed throug */ \
	0x68,0x20,0x73,0x75,0x63,0x63,0x65,0x73,0x73,0x69,0x76,0x65,0x20,0x63,0x61,0x6c, /* h successive cal */ \
	0x6c,0x73,0x2c,0x20,0x77,0x68,0x69,0x63,0x68,0x20,0x70,0x72,0x65,0x76,0x65,0x6e, /* ls, which preven */ \
	0x74,0x73,0x20,0x74,0x68,0x65,0x20,0x6c,0x69,0x6d,0x69,0x74,0x65,0x64,0x20,0x62, /* ts the limited b */ \
	0x75,0x66,0x66,0x65,0x72,0x20,0x73,0x70,0x61,0x63,0x65,0x20,0x66,0x72,0x6f,0x6d, /* uffer space from */ \
	0x20,0x62,0x65,0x69,0x6e,0x67,0x20,0x0d,0x0a,0x6f,0x76,0x65,0x72,0x72,0x75,0x6e, /*  being ..overrun */ \
	0x2e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x3c,0x70,0x3e,0x41,0x73,0x20,0x61,0x6e,0x20, /* .</p>..<p>As an  */ \
	0x65,0x78,0x61,0x6d,0x70,0x6c,0x65,0x2c,0x20,0x68,0x65,0x72,0x65,0x20,0x69,0x73, /* example, here is */ \
	0x20,0x74,0x68,0x65,0x20,0x63,0x75,0x72,0x72,0x65,0x6e,0x74,0x20,0x4c,0x43,0x44, /*  the current LCD */ \
	0x20,0x64,0x69,0x73,0x70,0x6c,0x61,0x79,0x20,0x28,0x77,0x68,0x69,0x63,0x68,0x20, /*  display (which  */ \
	0x75,0x73,0x65,0x73,0x20,0x33,0x32,0x20,0x62,0x79,0x74,0x65,0x73,0x29,0x3a,0x3c, /* uses 32 bytes):< */ \
	0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x63,0x6c,0x61,0x73, /* /p>....<div clas */ \
	0x73,0x3d,0x22,0x65,0x78,0x61,0x6d,0x70,0x6c,0x65,0x62,0x6f,0x78,0x20,0x63,0x6f, /* s="examplebox co */ \
	0x64,0x65,0x22,0x3e,0x7e,0x6c,0x63,0x64,0x74,0x65,0x78,0x74,0x7e,0x3c,0x2f,0x64, /* de">~lcdtext~</d */ \
	0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d, /* iv>....<p class= */ \
	0x22,0x65,0x78,0x65,0x72,0x63,0x69,0x73,0x65,0x22,0x3e,0x3c,0x62,0x3e,0x45,0x78, /* "exercise"><b>Ex */ \
	0x65,0x72,0x63,0x69,0x73,0x65,0x3a,0x3c,0x2f,0x62,0x3e,0x20,0x4c,0x6f,0x6f,0x6b, /* ercise:</b> Look */ \
	0x20,0x61,0x74,0x20,0x63,0x6f,0x64,0x65,0x20,0x66,0x6f,0x72,0x20,0x74,0x68,0x69, /*  at code for thi */ \
	0x73,0x20,0x70,0x61,0x67,0x65,0x20,0x61,0x6e,0x64,0x20,0x66,0x69,0x6e,0x64,0x20, /* s page and find  */ \
	0x68,0x6f,0x77,0x20,0x0d,0x0a,0x3c,0x63,0x6f,0x64,0x65,0x3e,0x68,0x65,0x61,0x64, /* how ..<code>head */ \
	0x65,0x72,0x2e,0x69,0x6e,0x63,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x20,0x61,0x6e, /* er.inc</code> an */ \
	0x64,0x20,0x3c,0x63,0x6f,0x64,0x65,0x3e,0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69, /* d <code>footer.i */ \
	0x6e,0x63,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x20,0x61,0x72,0x65,0x20,0x75,0x73, /* nc</code> are us */ \
	0x65,0x64,0x2e,0x20,0x20,0x54,0x68,0x65,0x73,0x65,0x20,0x66,0x69,0x6c,0x65,0x73, /* ed.  These files */ \
	0x20,0x70,0x72,0x6f,0x76,0x69,0x64,0x65,0x20,0x0d,0x0a,0x61,0x20,0x74,0x65,0x6d, /*  provide ..a tem */ \
	0x70,0x6c,0x61,0x74,0x65,0x20,0x66,0x6f,0x72,0x20,0x74,0x68,0x65,0x20,0x70,0x61, /* plate for the pa */ \
	0x67,0x65,0x73,0x20,0x74,0x6f,0x20,0x69,0x6e,0x63,0x6c,0x75,0x64,0x65,0x20,0x74, /* ges to include t */ \
	0x68,0x65,0x20,0x73,0x61,0x6d,0x65,0x20,0x6d,0x65,0x6e,0x75,0x2c,0x20,0x6c,0x61, /* he same menu, la */ \
	0x79,0x6f,0x75,0x74,0x2c,0x20,0x61,0x6e,0x64,0x20,0x64,0x65,0x73,0x69,0x67,0x6e, /* yout, and design */ \
	0x20,0x65,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x73,0x2e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a, /*  elements.</p>.. */ \
	0x3c,0x70,0x3e,0x3c,0x73,0x6d,0x61,0x6c,0x6c,0x3e,0x28,0x41,0x74,0x20,0x74,0x68, /* <p><small>(At th */ \
	0x69,0x73,0x20,0x74,0x69,0x6d,0x65,0x2c,0x20,0x64,0x79,0x6e,0x61,0x6d,0x69,0x63, /* is time, dynamic */ \
	0x20,0x76,0x61,0x72,0x69,0x61,0x62,0x6c,0x65,0x73,0x20,0x61,0x72,0x65,0x20,0x6e, /*  variables are n */ \
	0x6f,0x6e,0x2d,0x72,0x65,0x63,0x75,0x72,0x73,0x69,0x76,0x65,0x2c,0x20,0x73,0x6f, /* on-recursive, so */ \
	0x20,0x76,0x61,0x72,0x69,0x61,0x62,0x6c,0x65,0x73,0x20,0x6c,0x6f,0x63,0x61,0x74, /*  variables locat */ \
	0x65,0x64,0x20,0x69,0x6e,0x73,0x69,0x64,0x65,0x0d,0x0a,0x66,0x69,0x6c,0x65,0x73, /* ed inside..files */ \
	0x3c,0x62,0x72,0x20,0x2f,0x3e,0x20,0x69,0x6e,0x63,0x6c,0x75,0x64,0x65,0x64,0x20, /* <br /> included  */ \
	0x69,0x6e,0x20,0x74,0x68,0x69,0x73,0x20,0x6d,0x61,0x6e,0x6e,0x65,0x72,0x20,0x61, /* in this manner a */ \
	0x72,0x65,0x20,0x6e,0x6f,0x74,0x20,0x70,0x61,0x72,0x73,0x65,0x64,0x2e,0x29,0x3c, /* re not parsed.)< */ \
	0x2f,0x73,0x6d,0x61,0x6c,0x6c,0x3e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x3c,0x2f,0x64, /* /small></p>..</d */ \
	0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x74, /* iv>....<script t */ \
	0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x2f,0x6a,0x61,0x76,0x61,0x73,0x63, /* ype="text/javasc */ \
	0x72,0x69,0x70,0x74,0x22,0x3e,0x0d,0x0a,0x3c,0x21,0x2d,0x2d,0x0d,0x0a,0x64,0x6f, /* ript">..<!--..do */ \
	0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e, /* cument.getElemen */ \
	0x74,0x42,0x79,0x49,0x64,0x28,0x27,0x68,0x65,0x6c,0x6c,0x6f,0x27,0x29,0x2e,0x69, /* tById('hello').i */ \
	0x6e,0x6e,0x65,0x72,0x48,0x54,0x4d,0x4c,0x20,0x3d,0x20,0x22,0x7e,0x68,0x65,0x6c, /* nnerHTML = "~hel */ \
	0x6c,0x6f,0x6d,0x73,0x67,0x7e,0x22,0x3b,0x0d,0x0a,0x2d,0x2d,0x3e,0x0d,0x0a,0x3c, /* lomsg~";..-->..< */ \
	0x2f,0x73,0x63,0x72,0x69,0x70,0x74,0x3e,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66, /* /script>..~inc:f */ \
	0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x00,0x00,0x00,0x00,0x33,0x00, /* ooter.inc~....3. */ \
	0x00,0x00,0xc2,0x01,0x00,0x00,0x0d,0x00,0x00,0x00,0xca,0x03,0x00,0x00,0x01,0x00, /* ................ */ \
	0x00,0x00,0xe8,0x03,0x00,0x00,0x02,0x00,0x00,0x00,0x3c,0x64,0x69,0x76,0x20,0x63, /* ..........<div c */ \
	0x6c,0x61,0x73,0x73,0x3d,0x22,0x73,0x70,0x61,0x63,0x65,0x72,0x22,0x3e,0x26,0x6e, /* lass="spacer">&n */ \
	0x62,0x73,0x70,0x3b,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76, /* bsp;</div>..<div */ \
	0x20,0x69,0x64,0x3d,0x22,0x66,0x6f,0x6f,0x74,0x65,0x72,0x22,0x3e,0x43,0x6f,0x70, /*  id="footer">Cop */ \
	0x79,0x72,0x69,0x67,0x68,0x74,0x20,0x26,0x63,0x6f,0x70,0x79,0x3b,0x20,0x32,0x30, /* yright &copy; 20 */ \
	0x31,0x31,0x20,0x53,0x61,0x74,0x6f,0x73,0x68,0x69,0x20,0x59,0x61,0x73,0x75,0x64, /* 11 Satoshi Yasud */ \
	0x61,0x20,0x37,0x6d,0x33,0x74,0x6a,0x7a,0x2f,0x61,0x64,0x36,0x67,0x7a,0x3c,0x2f, /* a 7m3tjz/ad6gz</ */ \
	0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x3c,0x2f, /* div>....</div></ */ \
	0x64,0x69,0x76,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e, /* div></div></div> */ \
	0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x2f,0x62,0x6f,0x64,0x79, /* </div>....</body */ \
	0x3e,0x0d,0x0a,0x3c,0x2f,0x68,0x74,0x6d,0x6c,0x3e,0x3c,0x21,0x44,0x4f,0x43,0x54, /* >..</html><!DOCT */ \
	0x59,0x50,0x45,0x20,0x68,0x74,0x6d,0x6c,0x20,0x50,0x55,0x42,0x4c,0x49,0x43,0x20, /* YPE html PUBLIC  */ \
	0x22,0x2d,0x2f,0x2f,0x57,0x33,0x43,0x2f,0x2f,0x44,0x54,0x44,0x20,0x58,0x48,0x54  /* "-//W3C//DTD XHT */
#define DATACHUNK000008 \
	0x4d,0x4c,0x20,0x31,0x2e,0x30,0x20,0x53,0x74,0x72,0x69,0x63,0x74,0x2f,0x2f,0x45, /* ML 1.0 Strict//E */ \
	0x4e,0x22,0x0d,0x0a,0x20,0x20,0x22,0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f,0x77,0x77, /* N"..  "http://ww */ \
	0x77,0x2e,0x77,0x33,0x2e,0x6f,0x72,0x67,0x2f,0x54,0x52,0x2f,0x78,0x68,0x74,0x6d, /* w.w3.org/TR/xhtm */ \
	0x6c,0x31,0x2f,0x44,0x54,0x44,0x2f,0x78,0x68,0x74,0x6d,0x6c,0x31,0x2d,0x73,0x74, /* l1/DTD/xhtml1-st */ \
	0x72,0x69,0x63,0x74,0x2e,0x64,0x74,0x64,0x22,0x3e,0x0d,0x0a,0x3c,0x68,0x74,0x6d, /* rict.dtd">..<htm */ \
	0x6c,0x20,0x78,0x6d,0x6c,0x6e,0x73,0x3d,0x22,0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f, /* l xmlns="http:// */ \
	0x77,0x77,0x77,0x2e,0x77,0x33,0x2e,0x6f,0x72,0x67,0x2f,0x31,0x39,0x39,0x39,0x2f, /* www.w3.org/1999/ */ \
	0x78,0x68,0x74,0x6d,0x6c,0x22,0x20,0x78,0x6d,0x6c,0x3a,0x6c,0x61,0x6e,0x67,0x3d, /* xhtml" xml:lang= */ \
	0x22,0x65,0x6e,0x22,0x20,0x6c,0x61,0x6e,0x67,0x3d,0x22,0x65,0x6e,0x22,0x3e,0x0d, /* "en" lang="en">. */ \
	0x0a,0x3c,0x68,0x65,0x61,0x64,0x3e,0x0d,0x0a,0x3c,0x74,0x69,0x74,0x6c,0x65,0x3e, /* .<head>..<title> */ \
	0x44,0x2d,0x53,0x54,0x41,0x52,0x20,0x64,0x53,0x71,0x75,0x72,0x65,0x20,0x43,0x6c, /* D-STAR dSqure Cl */ \
	0x69,0x65,0x6e,0x74,0x20,0x50,0x72,0x6f,0x67,0x72,0x61,0x6d,0x3c,0x2f,0x74,0x69, /* ient Program</ti */ \
	0x74,0x6c,0x65,0x3e,0x0d,0x0a,0x3c,0x6c,0x69,0x6e,0x6b,0x20,0x68,0x72,0x65,0x66, /* tle>..<link href */ \
	0x3d,0x22,0x2f,0x37,0x6d,0x33,0x74,0x6a,0x7a,0x2e,0x63,0x73,0x73,0x22,0x20,0x72, /* ="/7m3tjz.css" r */ \
	0x65,0x6c,0x3d,0x22,0x73,0x74,0x79,0x6c,0x65,0x73,0x68,0x65,0x65,0x74,0x22,0x20, /* el="stylesheet"  */ \
	0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x2f,0x63,0x73,0x73,0x22,0x20, /* type="text/css"  */ \
	0x2f,0x3e,0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x73,0x72,0x63,0x3d, /* />..<script src= */ \
	0x22,0x2f,0x37,0x6d,0x33,0x74,0x6a,0x7a,0x2e,0x6a,0x73,0x22,0x20,0x74,0x79,0x70, /* "/7m3tjz.js" typ */ \
	0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x2f,0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69, /* e="text/javascri */ \
	0x70,0x74,0x22,0x3e,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70,0x74,0x3e,0x0d,0x0a,0x3c, /* pt"></script>..< */ \
	0x2f,0x68,0x65,0x61,0x64,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x62,0x6f,0x64,0x79,0x3e, /* /head>....<body> */ \
	0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x73,0x68,0x61,0x64,0x6f, /* ..<div id="shado */ \
	0x77,0x2d,0x6f,0x6e,0x65,0x22,0x3e,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22, /* w-one"><div id=" */ \
	0x73,0x68,0x61,0x64,0x6f,0x77,0x2d,0x74,0x77,0x6f,0x22,0x3e,0x3c,0x64,0x69,0x76, /* shadow-two"><div */ \
	0x20,0x69,0x64,0x3d,0x22,0x73,0x68,0x61,0x64,0x6f,0x77,0x2d,0x74,0x68,0x72,0x65, /*  id="shadow-thre */ \
	0x65,0x22,0x3e,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x73,0x68,0x61,0x64, /* e"><div id="shad */ \
	0x6f,0x77,0x2d,0x66,0x6f,0x75,0x72,0x22,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20, /* ow-four">..<div  */ \
	0x69,0x64,0x3d,0x22,0x70,0x61,0x67,0x65,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x64, /* id="page">....<d */ \
	0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x74,0x69,0x74,0x6c,0x65,0x22,0x3e,0x3c,0x64, /* iv id="title"><d */ \
	0x69,0x76,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x72,0x69,0x67,0x68,0x74,0x22, /* iv class="right" */ \
	0x3e,0x44,0x2d,0x53,0x54,0x41,0x52,0x20,0x64,0x53,0x71,0x75,0x72,0x65,0x20,0x43, /* >D-STAR dSqure C */ \
	0x6c,0x69,0x65,0x6e,0x74,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x3c,0x73,0x70,0x61,0x6e, /* lient</div><span */ \
	0x20,0x69,0x64,0x3d,0x22,0x68,0x65,0x6c,0x6c,0x6f,0x22,0x3e,0x26,0x6e,0x62,0x73, /*  id="hello">&nbs */ \
	0x70,0x3b,0x3c,0x2f,0x73,0x70,0x61,0x6e,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d, /* p;</span></div>. */ \
	0x0a,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x6d,0x65,0x6e,0x75, /* ...<div id="menu */ \
	0x22,0x3e,0x0d,0x0a,0x3c,0x61,0x20,0x68,0x72,0x65,0x66,0x3d,0x22,0x2f,0x69,0x6e, /* ">..<a href="/in */ \
	0x64,0x65,0x78,0x2e,0x68,0x74,0x6d,0x22,0x3e,0x4f,0x76,0x65,0x72,0x76,0x69,0x65, /* dex.htm">Overvie */ \
	0x77,0x3c,0x2f,0x61,0x3e,0x0d,0x0a,0x3c,0x61,0x20,0x68,0x72,0x65,0x66,0x3d,0x22, /* w</a>..<a href=" */ \
	0x2f,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x63,0x6f,0x6e,0x66,0x69,0x67,0x2e, /* /protect/config. */ \
	0x68,0x74,0x6d,0x22,0x3e,0x4e,0x65,0x74,0x77,0x6f,0x72,0x6b,0x20,0x43,0x6f,0x6e, /* htm">Network Con */ \
	0x66,0x69,0x67,0x75,0x72,0x61,0x74,0x69,0x6f,0x6e,0x3c,0x2f,0x61,0x3e,0x0d,0x0a, /* figuration</a>.. */ \
	0x3c,0x2f,0x64,0x69,0x76,0x3e,0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65,0x61,0x64,0x65, /* </div>~inc:heade */ \
	0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d, /* r.inc~..<div id= */ \
	0x22,0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68, /* "content">....<h */ \
	0x31,0x3e,0x44,0x2d,0x53,0x54,0x41,0x52,0x20,0x64,0x53,0x71,0x75,0x72,0x65,0x20, /* 1>D-STAR dSqure  */ \
	0x43,0x6c,0x69,0x65,0x6e,0x74,0x20,0x50,0x72,0x6f,0x67,0x72,0x61,0x6d,0x3c,0x2f, /* Client Program</ */ \
	0x68,0x31,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x74,0x61,0x62,0x6c,0x65,0x20,0x73,0x74, /* h1>....<table st */ \
	0x79,0x6c,0x65,0x3d,0x22,0x70,0x61,0x64,0x64,0x69,0x6e,0x67,0x2d,0x6c,0x65,0x66, /* yle="padding-lef */ \
	0x74,0x3a,0x20,0x31,0x30,0x70,0x78,0x3b,0x22,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e, /* t: 10px;">..<tr> */ \
	0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x64,0x53,0x71,0x75,0x72,0x65,0x20,0x53,0x65, /* <td><b>dSqure Se */ \
	0x72,0x76,0x65,0x72,0x20,0x44,0x6f,0x6d,0x61,0x69,0x6e,0x20,0x4e,0x61,0x6d,0x65, /* rver Domain Name */ \
	0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26, /*  :</b></td><td>& */ \
	0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x73, /* nbsp;</td><td>~s */ \
	0x65,0x72,0x76,0x65,0x72,0x5f,0x6e,0x61,0x6d,0x65,0x7e,0x3c,0x2f,0x74,0x64,0x3e, /* erver_name~</td> */ \
	0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c, /* </tr>..<tr><td>< */ \
	0x62,0x3e,0x4f,0x75,0x74,0x20,0x62,0x6f,0x75,0x6e,0x64,0x20,0x50,0x6f,0x72,0x74, /* b>Out bound Port */ \
	0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26, /*  :</b></td><td>& */ \
	0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x6f, /* nbsp;</td><td>~o */ \
	0x75,0x74,0x5f,0x70,0x6f,0x72,0x74,0x7e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74, /* ut_port~</td></t */ \
	0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x49, /* r>..<tr><td><b>I */ \
	0x6e,0x20,0x62,0x6f,0x75,0x6e,0x64,0x20,0x50,0x6f,0x72,0x74,0x20,0x3a,0x3c,0x2f, /* n bound Port :</ */ \
	0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73,0x70, /* b></td><td>&nbsp */ \
	0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x69,0x6e,0x5f,0x70,0x6f, /* ;</td><td>~in_po */ \
	0x72,0x74,0x7e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c  /* rt~</td></tr>..< */
#define DATACHUNK000009 \
	0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x43,0x6f,0x6e,0x66,0x65,0x72, /* tr><td><b>Confer */ \
	0x65,0x6e,0x63,0x65,0x20,0x52,0x6f,0x6f,0x6d,0x20,0x4e,0x61,0x6d,0x65,0x20,0x3a, /* ence Room Name : */ \
	0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62, /* </b></td><td>&nb */ \
	0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x52,0x6f,0x6f, /* sp;</td><td>~Roo */ \
	0x6d,0x4e,0x61,0x6d,0x65,0x7e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e, /* mName~</td></tr> */ \
	0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x4e,0x6f,0x64, /* ..<tr><td><b>Nod */ \
	0x65,0x20,0x43,0x61,0x6c,0x6c,0x73,0x69,0x67,0x6e,0x20,0x3a,0x3c,0x2f,0x62,0x3e, /* e Callsign :</b> */ \
	0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c, /* </td><td>&nbsp;< */ \
	0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x4e,0x6f,0x64,0x65,0x4e,0x61,0x6d, /* /td><td>~NodeNam */ \
	0x65,0x7e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x2f, /* e~</td></tr>..</ */ \
	0x74,0x61,0x62,0x6c,0x65,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e, /* table>....</div> */ \
	0x0d,0x0a,0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x74,0x79,0x70,0x65, /* ....<script type */ \
	0x3d,0x22,0x74,0x65,0x78,0x74,0x2f,0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70, /* ="text/javascrip */ \
	0x74,0x22,0x3e,0x0d,0x0a,0x3c,0x21,0x2d,0x2d,0x0d,0x0a,0x64,0x6f,0x63,0x75,0x6d, /* t">..<!--..docum */ \
	0x65,0x6e,0x74,0x2e,0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79, /* ent.getElementBy */ \
	0x49,0x64,0x28,0x27,0x68,0x65,0x6c,0x6c,0x6f,0x27,0x29,0x2e,0x69,0x6e,0x6e,0x65, /* Id('hello').inne */ \
	0x72,0x48,0x54,0x4d,0x4c,0x20,0x3d,0x20,0x22,0x7e,0x68,0x65,0x6c,0x6c,0x6f,0x6d, /* rHTML = "~hellom */ \
	0x73,0x67,0x7e,0x22,0x3b,0x0d,0x0a,0x2f,0x2f,0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f, /* sg~";..//-->..</ */ \
	0x73,0x63,0x72,0x69,0x70,0x74,0x3e,0x0d,0x0a,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a, /* script>....~inc: */ \
	0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x00,0x00,0x00, /* footer.inc~..... */ \
	0x00,0x33,0x00,0x00,0x00,0xb8,0x00,0x00,0x00,0x4a,0x00,0x00,0x00,0x08,0x01,0x00, /* .3.......J...... */ \
	0x00,0x4b,0x00,0x00,0x00,0x54,0x01,0x00,0x00,0x4c,0x00,0x00,0x00,0xa6,0x01,0x00, /* .K...T...L...... */ \
	0x00,0x4d,0x00,0x00,0x00,0xf2,0x01,0x00,0x00,0x4e,0x00,0x00,0x00,0x73,0x02,0x00, /* .M.......N...s.. */ \
	0x00,0x01,0x00,0x00,0x00,0x95,0x02,0x00,0x00,0x02,0x00,0x00,0x00,0x2b,0x10,0x06, /* .............+.. */ \
	0x10,0x01,0x10,0x02,0x18,0x5b,0x00,0x01,0x10,0x01,0x10,0x01,0x0a,0x17,0x00,0x03, /* .....[.......... */ \
	0x03,0x50,0x49,0x43,0x02,0xca,0x01,0xff,0x27,0x00,0x09,0x08,0x2b,0x06,0x01,0x04, /* .PIC....'...+... */ \
	0x01,0x81,0x85,0x47,0x03,0x88,0x01,0xfa,0x2e,0x00,0x07,0x04,0x0a,0x39,0x00,0x03, /* ...G.........9.. */ \
	0x05,0x61,0x64,0x6d,0x69,0x6e,0x05,0x0a,0x48,0x00,0x03,0x09,0x4d,0x69,0x63,0x72, /* .admin..H...Micr */ \
	0x6f,0x63,0x68,0x69,0x70,0x06,0x0a,0x54,0x00,0x03,0x06,0x6f,0x66,0x66,0x69,0x63, /* ochip..T...offic */ \
	0x65,0x07,0x03,0x6d,0x00,0x00,0x01,0x07,0x04,0x18,0x92,0x01,0x01,0x10,0x81,0x10, /* e..m............ */ \
	0x85,0x10,0x47,0x10,0x01,0x10,0x01,0x18,0x95,0x00,0x01,0x0a,0x7e,0x00,0x03,0x0b, /* ..G.........~... */ \
	0x53,0x4e,0x4d,0x50,0x76,0x33,0x41,0x67,0x65,0x6e,0x74,0x02,0x0a,0x89,0x00,0x03, /* SNMPv3Agent..... */ \
	0x05,0x76,0x35,0x2e,0x33,0x31,0x03,0x03,0x9d,0x00,0x03,0x06,0x4f,0x63,0x74,0x20, /* .v5.31......Oct  */ \
	0x31,0x30,0x02,0x18,0xcd,0x00,0x01,0x10,0x01,0x10,0x01,0xac,0x01,0x01,0xa9,0x00, /* 10.............. */ \
	0x00,0x01,0x01,0x01,0x01,0x00,0x02,0xac,0x01,0x02,0xb5,0x00,0x00,0x01,0x01,0x01, /* ................ */ \
	0x01,0x00,0x03,0xac,0x01,0x03,0xc1,0x00,0x05,0x01,0x01,0x01,0x01,0x00,0x04,0xa5, /* ................ */ \
	0x01,0x04,0xd1,0x00,0x04,0x01,0x01,0x01,0x01,0x00,0x03,0x18,0xf4,0x00,0x01,0xa8, /* ................ */ \
	0x01,0x05,0xd8,0x00,0x00,0x02,0xa8,0x01,0x06,0xdf,0x00,0x00,0x03,0x88,0x01,0x07, /* ................ */ \
	0xe6,0x00,0x00,0x04,0x88,0x01,0x08,0xed,0x00,0x01,0x06,0xa1,0x01,0x0a,0xfc,0x00, /* ................ */ \
	0x04,0x04,0x18,0x44,0x01,0x01,0x10,0x01,0x10,0x01,0x8c,0x01,0x0b,0x08,0x01,0x00, /* ...D............ */ \
	0x01,0x01,0x01,0x0b,0x00,0x02,0xac,0x01,0x0c,0x14,0x01,0x04,0x01,0x01,0x01,0x0b, /* ................ */ \
	0x00,0x03,0xac,0x01,0x0d,0x20,0x01,0x00,0x01,0x01,0x01,0x0b,0x00,0x04,0xac,0x01, /* ..... .......... */ \
	0x0e,0x2c,0x01,0x04,0x01,0x01,0x01,0x0b,0x00,0x05,0xac,0x01,0x0f,0x38,0x01,0x00, /* .,...........8.. */ \
	0x01,0x01,0x01,0x0b,0x00,0x06,0xa5,0x01,0x10,0x4c,0x01,0x04,0x01,0x01,0x01,0x0b, /* .........L...... */ \
	0x00,0x05,0x18,0x88,0x01,0x01,0x10,0x01,0x10,0x01,0x8c,0x01,0x11,0x58,0x01,0x00, /* .............X.. */ \
	0x01,0x01,0x01,0x11,0x00,0x02,0xac,0x01,0x12,0x64,0x01,0x00,0x01,0x01,0x01,0x11, /* .........d...... */ \
	0x00,0x03,0xac,0x01,0x13,0x70,0x01,0x00,0x01,0x01,0x01,0x11,0x00,0x04,0xac,0x01, /* .....p.......... */ \
	0x14,0x7c,0x01,0x04,0x01,0x01,0x01,0x11,0x00,0x05,0xa5,0x01,0x15,0x8a,0x01,0x00, /* .|.............. */ \
	0x01,0x01,0x01,0x11,0x00,0x07,0x10,0x01,0x81,0x02,0x01,0xf4,0x9c,0x01,0x00,0x06, /* ................ */ \
	0x10,0x03,0x10,0x0a,0x10,0x02,0x10,0x01,0x10,0x01,0x88,0x01,0xf9,0xa3,0x01,0x04, /* ................ */ \
	0x02,0x88,0x01,0xf8,0xaa,0x01,0x02,0x03,0x88,0x01,0xf7,0xb1,0x01,0x02,0x04,0x80, /* ................ */ \
	0x01,0xf6,0x01,0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69, /* ...~inc:header.i */ \
	0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x63,0x6f, /* nc~..<div id="co */ \
	0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x46, /* ntent">....<h1>F */ \
	0x69,0x6c,0x65,0x20,0x55,0x70,0x6c,0x6f,0x61,0x64,0x73,0x3c,0x2f,0x68,0x31,0x3e, /* ile Uploads</h1> */ \
	0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x3e,0x54,0x68,0x65,0x20,0x48,0x54,0x54,0x50,0x20, /* ....<p>The HTTP  */ \
	0x73,0x65,0x72,0x76,0x65,0x72,0x20,0x63,0x61,0x6e,0x20,0x61,0x63,0x63,0x65,0x70, /* server can accep */ \
	0x74,0x20,0x66,0x69,0x6c,0x65,0x20,0x75,0x70,0x6c,0x6f,0x61,0x64,0x73,0x20,0x76, /* t file uploads v */ \
	0x69,0x61,0x20,0x50,0x4f,0x53,0x54,0x2e,0x20,0x20,0x54,0x68,0x69,0x73,0x20,0x63, /* ia POST.  This c */ \
	0x61,0x6e,0x20,0x62,0x65,0x20,0x75,0x73,0x65,0x64,0x20,0x66,0x6f,0x72,0x20,0x0d, /* an be used for . */ \
	0x0a,0x6d,0x61,0x6e,0x79,0x20,0x61,0x70,0x70,0x6c,0x69,0x63,0x61,0x74,0x69,0x6f, /* .many applicatio */ \
	0x6e,0x73,0x20,0x73,0x75,0x63,0x68,0x20,0x61,0x73,0x20,0x61,0x6c,0x6c,0x6f,0x77, /* ns such as allow */ \
	0x69,0x6e,0x67,0x20,0x75,0x73,0x65,0x72,0x73,0x20,0x74,0x6f,0x20,0x75,0x70,0x6c, /* ing users to upl */ \
	0x6f,0x61,0x64,0x20,0x63,0x6f,0x6e,0x66,0x69,0x67,0x75,0x72,0x61,0x74,0x69,0x6f  /* oad configuratio */
#define DATACHUNK00000a \
	0x6e,0x20,0x73,0x65,0x74,0x74,0x69,0x6e,0x67,0x73,0x20,0x66,0x69,0x6c,0x65,0x73, /* n settings files */ \
	0x2e,0x0d,0x0a,0x45,0x61,0x63,0x68,0x20,0x61,0x70,0x70,0x6c,0x69,0x63,0x61,0x74, /* ...Each applicat */ \
	0x69,0x6f,0x6e,0x20,0x6d,0x75,0x73,0x74,0x20,0x69,0x6d,0x70,0x6c,0x65,0x6d,0x65, /* ion must impleme */ \
	0x6e,0x74,0x20,0x69,0x74,0x73,0x20,0x6f,0x77,0x6e,0x20,0x66,0x69,0x6c,0x65,0x20, /* nt its own file  */ \
	0x70,0x72,0x6f,0x63,0x65,0x73,0x73,0x6f,0x72,0x2e,0x20,0x20,0x54,0x68,0x69,0x73, /* processor.  This */ \
	0x20,0x65,0x78,0x61,0x6d,0x70,0x6c,0x65,0x20,0x0d,0x0a,0x63,0x61,0x6c,0x63,0x75, /*  example ..calcu */ \
	0x6c,0x61,0x74,0x65,0x73,0x20,0x74,0x68,0x65,0x20,0x4d,0x44,0x35,0x20,0x68,0x61, /* lates the MD5 ha */ \
	0x73,0x68,0x20,0x6f,0x66,0x20,0x61,0x6e,0x79,0x20,0x66,0x69,0x6c,0x65,0x2e,0x3c, /* sh of any file.< */ \
	0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x66,0x6f,0x72,0x6d,0x20,0x61,0x63,0x74, /* /p>....<form act */ \
	0x69,0x6f,0x6e,0x3d,0x22,0x75,0x70,0x6c,0x6f,0x61,0x64,0x2e,0x68,0x74,0x6d,0x22, /* ion="upload.htm" */ \
	0x20,0x6d,0x65,0x74,0x68,0x6f,0x64,0x3d,0x22,0x70,0x6f,0x73,0x74,0x22,0x20,0x65, /*  method="post" e */ \
	0x6e,0x63,0x74,0x79,0x70,0x65,0x3d,0x22,0x6d,0x75,0x6c,0x74,0x69,0x70,0x61,0x72, /* nctype="multipar */ \
	0x74,0x2f,0x66,0x6f,0x72,0x6d,0x2d,0x64,0x61,0x74,0x61,0x22,0x3e,0x0d,0x0a,0x3c, /* t/form-data">..< */ \
	0x64,0x69,0x76,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x65,0x78,0x61,0x6d,0x70, /* div class="examp */ \
	0x6c,0x65,0x62,0x6f,0x78,0x22,0x3e,0x0d,0x0a,0x7e,0x75,0x70,0x6c,0x6f,0x61,0x64, /* lebox">..~upload */ \
	0x65,0x64,0x6d,0x64,0x35,0x7e,0x0d,0x0a,0x3c,0x70,0x20,0x73,0x74,0x79,0x6c,0x65, /* edmd5~..<p style */ \
	0x3d,0x22,0x6d,0x61,0x72,0x67,0x69,0x6e,0x2d,0x62,0x6f,0x74,0x74,0x6f,0x6d,0x3a, /* ="margin-bottom: */ \
	0x20,0x32,0x70,0x78,0x22,0x3e,0x3c,0x62,0x3e,0x46,0x69,0x6c,0x65,0x3a,0x20,0x3c, /*  2px"><b>File: < */ \
	0x2f,0x62,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75, /* /b>&nbsp;..<inpu */ \
	0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x66,0x69,0x6c,0x65,0x22,0x20,0x6e,0x61, /* t type="file" na */ \
	0x6d,0x65,0x3d,0x22,0x6d,0x64,0x35,0x66,0x69,0x6c,0x65,0x22,0x20,0x73,0x69,0x7a, /* me="md5file" siz */ \
	0x65,0x3d,0x22,0x33,0x30,0x22,0x20,0x2f,0x3e,0x20,0x26,0x6e,0x62,0x73,0x70,0x3b, /* e="30" /> &nbsp; */ \
	0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x73, /* ..<input type="s */ \
	0x75,0x62,0x6d,0x69,0x74,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x47,0x65, /* ubmit" value="Ge */ \
	0x74,0x20,0x4d,0x44,0x35,0x22,0x20,0x2f,0x3e,0x0d,0x0a,0x3c,0x2f,0x70,0x3e,0x0d, /* t MD5" />..</p>. */ \
	0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x6f,0x72,0x6d,0x3e, /* .</div>..</form> */ \
	0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x3e,0x54,0x68,0x69,0x73,0x20,0x69,0x73,0x20,0x61, /* ....<p>This is a */ \
	0x6e,0x20,0x61,0x64,0x76,0x61,0x6e,0x63,0x65,0x64,0x20,0x66,0x65,0x61,0x74,0x75, /* n advanced featu */ \
	0x72,0x65,0x2e,0x20,0x20,0x46,0x6f,0x72,0x20,0x6d,0x6f,0x72,0x65,0x20,0x69,0x6e, /* re.  For more in */ \
	0x66,0x6f,0x72,0x6d,0x61,0x74,0x69,0x6f,0x6e,0x2c,0x20,0x70,0x6c,0x65,0x61,0x73, /* formation, pleas */ \
	0x65,0x20,0x72,0x65,0x66,0x65,0x72,0x20,0x74,0x6f,0x20,0x74,0x68,0x65,0x20,0x0d, /* e refer to the . */ \
	0x0a,0x69,0x6d,0x70,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x61,0x74,0x69,0x6f,0x6e,0x20, /* .implementation  */ \
	0x69,0x6e,0x20,0x3c,0x63,0x6f,0x64,0x65,0x3e,0x43,0x75,0x73,0x74,0x6f,0x6d,0x48, /* in <code>CustomH */ \
	0x54,0x54,0x50,0x41,0x70,0x70,0x2e,0x63,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x20, /* TTPApp.c</code>  */ \
	0x66,0x6f,0x72,0x20,0x63,0x6f,0x6d,0x6d,0x65,0x6e,0x74,0x73,0x20,0x61,0x6e,0x64, /* for comments and */ \
	0x20,0x65,0x78,0x70,0x6c,0x61,0x69,0x6e,0x61,0x74,0x69,0x6f,0x6e,0x2e,0x3c,0x2f, /*  explaination.</ */ \
	0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a, /* p>....</div>.... */ \
	0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65, /* <script type="te */ \
	0x78,0x74,0x2f,0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x0d, /* xt/javascript">. */ \
	0x0a,0x3c,0x21,0x2d,0x2d,0x0d,0x0a,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e, /* .<!--..document. */ \
	0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28,0x27, /* getElementById(' */ \
	0x68,0x65,0x6c,0x6c,0x6f,0x27,0x29,0x2e,0x69,0x6e,0x6e,0x65,0x72,0x48,0x54,0x4d, /* hello').innerHTM */ \
	0x4c,0x20,0x3d,0x20,0x22,0x7e,0x68,0x65,0x6c,0x6c,0x6f,0x6d,0x73,0x67,0x7e,0x22, /* L = "~hellomsg~" */ \
	0x3b,0x0d,0x0a,0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70,0x74, /* ;..-->..</script */ \
	0x3e,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69, /* >..~inc:footer.i */ \
	0x6e,0x63,0x7e,0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0xb6,0x01,0x00,0x00,0x1d, /* nc~....3........ */ \
	0x00,0x00,0x00,0x72,0x03,0x00,0x00,0x01,0x00,0x00,0x00,0x90,0x03,0x00,0x00,0x02, /* ...r............ */ \
	0x00,0x00,0x00,0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69, /* ...~inc:header.i */ \
	0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x63,0x6f, /* nc~..<div id="co */ \
	0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x53, /* ntent">....<h1>S */ \
	0x65,0x6e,0x64,0x20,0x45,0x2d,0x4d,0x61,0x69,0x6c,0x3c,0x2f,0x68,0x31,0x3e,0x0d, /* end E-Mail</h1>. */ \
	0x0a,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x72, /* ...<div class="r */ \
	0x65,0x73,0x75,0x6c,0x74,0x20,0x6f,0x6b,0x22,0x20,0x73,0x74,0x79,0x6c,0x65,0x3d, /* esult ok" style= */ \
	0x22,0x64,0x69,0x73,0x70,0x6c,0x61,0x79,0x3a,0x7e,0x73,0x74,0x61,0x74,0x75,0x73, /* "display:~status */ \
	0x5f,0x6f,0x6b,0x7e,0x22,0x3e,0x0d,0x0a,0x59,0x6f,0x75,0x72,0x20,0x6d,0x65,0x73, /* _ok~">..Your mes */ \
	0x73,0x61,0x67,0x65,0x20,0x68,0x61,0x73,0x20,0x62,0x65,0x65,0x6e,0x20,0x73,0x65, /* sage has been se */ \
	0x6e,0x74,0x2e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69, /* nt...</div>..<di */ \
	0x76,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x72,0x65,0x73,0x75,0x6c,0x74,0x20, /* v class="result  */ \
	0x66,0x61,0x69,0x6c,0x22,0x20,0x73,0x74,0x79,0x6c,0x65,0x3d,0x22,0x64,0x69,0x73, /* fail" style="dis */ \
	0x70,0x6c,0x61,0x79,0x3a,0x7e,0x73,0x74,0x61,0x74,0x75,0x73,0x5f,0x66,0x61,0x69, /* play:~status_fai */ \
	0x6c,0x7e,0x22,0x3e,0x0d,0x0a,0x45,0x52,0x52,0x4f,0x52,0x3a,0x20,0x59,0x6f,0x75, /* l~">..ERROR: You */ \
	0x72,0x20,0x6d,0x65,0x73,0x73,0x61,0x67,0x65,0x20,0x63,0x6f,0x75,0x6c,0x64,0x20, /* r message could  */ \
	0x6e,0x6f,0x74,0x20,0x62,0x65,0x20,0x73,0x65,0x6e,0x74,0x2e,0x3c,0x62,0x72,0x20, /* not be sent.<br  */ \
	0x2f,0x3e,0x0d,0x0a,0x43,0x68,0x65,0x63,0x6b,0x20,0x79,0x6f,0x75,0x72,0x20,0x53  /* />..Check your S */
#define DATACHUNK00000b \
	0x4d,0x54,0x50,0x20,0x73,0x65,0x72,0x76,0x65,0x72,0x20,0x73,0x65,0x74,0x74,0x69, /* MTP server setti */ \
	0x6e,0x67,0x73,0x20,0x61,0x6e,0x64,0x20,0x74,0x72,0x79,0x20,0x61,0x67,0x61,0x69, /* ngs and try agai */ \
	0x6e,0x2e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70, /* n...</div>....<p */ \
	0x3e,0x42,0x79,0x20,0x63,0x6f,0x6d,0x62,0x69,0x6e,0x69,0x6e,0x67,0x20,0x74,0x68, /* >By combining th */ \
	0x65,0x20,0x53,0x4d,0x54,0x50,0x20,0x63,0x6c,0x69,0x65,0x6e,0x74,0x20,0x69,0x6e, /* e SMTP client in */ \
	0x74,0x6f,0x20,0x61,0x6e,0x20,0x48,0x54,0x54,0x50,0x32,0x20,0x50,0x4f,0x53,0x54, /* to an HTTP2 POST */ \
	0x20,0x63,0x61,0x6c,0x6c,0x62,0x61,0x63,0x6b,0x2c,0x20,0x61,0x20,0x66,0x6f,0x72, /*  callback, a for */ \
	0x6d,0x20,0x0d,0x0a,0x63,0x61,0x6e,0x20,0x62,0x65,0x20,0x64,0x65,0x76,0x65,0x6c, /* m ..can be devel */ \
	0x6f,0x70,0x65,0x64,0x20,0x74,0x68,0x61,0x74,0x20,0x73,0x65,0x6e,0x64,0x73,0x20, /* oped that sends  */ \
	0x61,0x6e,0x20,0x65,0x2d,0x6d,0x61,0x69,0x6c,0x20,0x74,0x6f,0x20,0x61,0x6e,0x20, /* an e-mail to an  */ \
	0x61,0x64,0x6d,0x69,0x6e,0x69,0x73,0x74,0x72,0x61,0x74,0x6f,0x72,0x2e,0x20,0x20, /* administrator.   */ \
	0x46,0x6f,0x72,0x20,0x6d,0x6f,0x72,0x65,0x0d,0x0a,0x64,0x65,0x74,0x61,0x69,0x6c, /* For more..detail */ \
	0x73,0x20,0x6f,0x6e,0x20,0x74,0x68,0x65,0x20,0x53,0x4d,0x54,0x50,0x20,0x43,0x6c, /* s on the SMTP Cl */ \
	0x69,0x65,0x6e,0x74,0x20,0x6d,0x6f,0x64,0x75,0x6c,0x65,0x2c,0x20,0x70,0x6c,0x65, /* ient module, ple */ \
	0x61,0x73,0x65,0x20,0x73,0x65,0x65,0x20,0x74,0x68,0x65,0x20,0x54,0x43,0x50,0x49, /* ase see the TCPI */ \
	0x50,0x20,0x53,0x74,0x61,0x63,0x6b,0x20,0x55,0x73,0x65,0x72,0x27,0x73,0x0d,0x0a, /* P Stack User's.. */ \
	0x47,0x75,0x69,0x64,0x65,0x2e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70, /* Guide.</p>....<p */ \
	0x3e,0x45,0x6e,0x74,0x65,0x72,0x20,0x74,0x68,0x65,0x20,0x61,0x70,0x70,0x72,0x6f, /* >Enter the appro */ \
	0x70,0x72,0x69,0x61,0x74,0x65,0x20,0x73,0x65,0x74,0x74,0x69,0x6e,0x67,0x73,0x20, /* priate settings  */ \
	0x69,0x6e,0x20,0x74,0x68,0x65,0x20,0x66,0x69,0x65,0x6c,0x64,0x73,0x20,0x62,0x65, /* in the fields be */ \
	0x6c,0x6f,0x77,0x3a,0x0d,0x0a,0x3c,0x62,0x72,0x20,0x2f,0x3e,0x28,0x59,0x6f,0x75, /* low:..<br />(You */ \
	0x72,0x20,0x53,0x4d,0x54,0x50,0x20,0x73,0x65,0x72,0x76,0x65,0x72,0x20,0x6d,0x61, /* r SMTP server ma */ \
	0x79,0x20,0x6e,0x6f,0x74,0x20,0x72,0x65,0x71,0x75,0x69,0x72,0x65,0x20,0x61,0x20, /* y not require a  */ \
	0x75,0x73,0x65,0x72,0x20,0x6e,0x61,0x6d,0x65,0x20,0x6f,0x72,0x20,0x70,0x61,0x73, /* user name or pas */ \
	0x73,0x77,0x6f,0x72,0x64,0x2e,0x29,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c, /* sword.)</p>....< */ \
	0x66,0x6f,0x72,0x6d,0x20,0x6d,0x65,0x74,0x68,0x6f,0x64,0x3d,0x22,0x70,0x6f,0x73, /* form method="pos */ \
	0x74,0x22,0x20,0x61,0x63,0x74,0x69,0x6f,0x6e,0x3d,0x22,0x2f,0x65,0x6d,0x61,0x69, /* t" action="/emai */ \
	0x6c,0x2f,0x69,0x6e,0x64,0x65,0x78,0x2e,0x68,0x74,0x6d,0x22,0x20,0x6f,0x6e,0x73, /* l/index.htm" ons */ \
	0x75,0x62,0x6d,0x69,0x74,0x3d,0x22,0x62,0x74,0x6e,0x3d,0x64,0x6f,0x63,0x75,0x6d, /* ubmit="btn=docum */ \
	0x65,0x6e,0x74,0x2e,0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79, /* ent.getElementBy */ \
	0x49,0x64,0x28,0x27,0x62,0x74,0x6e,0x53,0x75,0x62,0x6d,0x69,0x74,0x27,0x29,0x3b, /* Id('btnSubmit'); */ \
	0x20,0x62,0x74,0x6e,0x2e,0x76,0x61,0x6c,0x75,0x65,0x3d,0x27,0x28,0x70,0x6c,0x65, /*  btn.value='(ple */ \
	0x61,0x73,0x65,0x20,0x77,0x61,0x69,0x74,0x29,0x27,0x3b,0x20,0x62,0x74,0x6e,0x2e, /* ase wait)'; btn. */ \
	0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x74,0x72,0x75,0x65,0x3b, /* disabled = true; */ \
	0x22,0x3e,0x0d,0x0a,0x3c,0x66,0x69,0x65,0x6c,0x64,0x73,0x65,0x74,0x3e,0x0d,0x0a, /* ">..<fieldset>.. */ \
	0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x53,0x4d,0x54,0x50, /* <div><label>SMTP */ \
	0x20,0x53,0x65,0x72,0x76,0x65,0x72,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e, /*  Server:</label> */ \
	0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74, /* ..<input type="t */ \
	0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x73,0x65,0x72,0x76,0x65, /* ext" name="serve */ \
	0x72,0x22,0x20,0x73,0x74,0x79,0x6c,0x65,0x3d,0x22,0x77,0x69,0x64,0x74,0x68,0x3a, /* r" style="width: */ \
	0x31,0x36,0x35,0x70,0x78,0x22,0x2f,0x3e,0x0d,0x0a,0x26,0x6e,0x62,0x73,0x70,0x3b, /* 165px"/>..&nbsp; */ \
	0x3c,0x62,0x3e,0x50,0x6f,0x72,0x74,0x3a,0x3c,0x2f,0x62,0x3e,0x26,0x6e,0x62,0x73, /* <b>Port:</b>&nbs */ \
	0x70,0x3b,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d, /* p;..<input type= */ \
	0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x70,0x6f,0x72, /* "text" name="por */ \
	0x74,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x32,0x35,0x22,0x20,0x73,0x74, /* t" value="25" st */ \
	0x79,0x6c,0x65,0x3d,0x22,0x77,0x69,0x64,0x74,0x68,0x3a,0x32,0x35,0x70,0x78,0x3b, /* yle="width:25px; */ \
	0x22,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20, /* "/></div>..<div  */ \
	0x73,0x74,0x79,0x6c,0x65,0x3d,0x22,0x64,0x69,0x73,0x70,0x6c,0x61,0x79,0x3a,0x7e, /* style="display:~ */ \
	0x73,0x6d,0x74,0x70,0x73,0x5f,0x65,0x6e,0x7e,0x22,0x3e,0x3c,0x69,0x6e,0x70,0x75, /* smtps_en~"><inpu */ \
	0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78, /* t type="checkbox */ \
	0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x73,0x73,0x6c,0x22,0x20,0x76,0x61,0x6c, /* " name="ssl" val */ \
	0x75,0x65,0x3d,0x22,0x31,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x73,0x6d, /* ue="1" class="sm */ \
	0x22,0x2f,0x3e,0x20,0x55,0x73,0x65,0x20,0x53,0x53,0x4c,0x20,0x28,0x75,0x73,0x75, /* "/> Use SSL (usu */ \
	0x61,0x6c,0x6c,0x79,0x20,0x70,0x6f,0x72,0x74,0x20,0x34,0x36,0x35,0x29,0x3c,0x2f, /* ally port 465)</ */ \
	0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65, /* div>..<div><labe */ \
	0x6c,0x3e,0x55,0x73,0x65,0x72,0x20,0x4e,0x61,0x6d,0x65,0x3a,0x3c,0x2f,0x6c,0x61, /* l>User Name:</la */ \
	0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70, /* bel>..<input typ */ \
	0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x75, /* e="text" name="u */ \
	0x73,0x65,0x72,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c, /* ser" /></div>..< */ \
	0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x50,0x61,0x73,0x73,0x77, /* div><label>Passw */ \
	0x6f,0x72,0x64,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69, /* ord:</label>..<i */ \
	0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x70,0x61,0x73,0x73,0x77, /* nput type="passw */ \
	0x6f,0x72,0x64,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x70,0x61,0x73,0x73,0x22, /* ord" name="pass" */ \
	0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e  /*  /></div>..<div> */
#define DATACHUNK00000c \
	0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a, /* &nbsp;</div>.... */ \
	0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x54,0x6f,0x3a,0x3c, /* <div><label>To:< */ \
	0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20, /* /label>..<input  */ \
	0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65, /* type="text" name */ \
	0x3d,0x22,0x74,0x6f,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a, /* ="to" /></div>.. */ \
	0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x4d,0x65,0x73,0x73, /* <div><label>Mess */ \
	0x61,0x67,0x65,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74, /* age:</label>..<t */ \
	0x65,0x78,0x74,0x61,0x72,0x65,0x61,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x6d,0x73, /* extarea name="ms */ \
	0x67,0x22,0x20,0x72,0x6f,0x77,0x73,0x3d,0x22,0x36,0x22,0x3e,0x54,0x68,0x69,0x73, /* g" rows="6">This */ \
	0x20,0x6d,0x65,0x73,0x73,0x61,0x67,0x65,0x20,0x77,0x61,0x73,0x20,0x73,0x65,0x6e, /*  message was sen */ \
	0x74,0x20,0x62,0x79,0x20,0x74,0x68,0x65,0x20,0x4d,0x69,0x63,0x72,0x6f,0x63,0x68, /* t by the Microch */ \
	0x69,0x70,0x20,0x54,0x43,0x50,0x2f,0x49,0x50,0x20,0x53,0x74,0x61,0x63,0x6b,0x2e, /* ip TCP/IP Stack. */ \
	0x20,0x20,0x53,0x65,0x65,0x20,0x74,0x68,0x65,0x20,0x61,0x74,0x74,0x61,0x63,0x68, /*   See the attach */ \
	0x65,0x64,0x20,0x66,0x69,0x6c,0x65,0x20,0x66,0x6f,0x72,0x20,0x63,0x75,0x72,0x72, /* ed file for curr */ \
	0x65,0x6e,0x74,0x20,0x73,0x79,0x73,0x74,0x65,0x6d,0x20,0x73,0x74,0x61,0x74,0x75, /* ent system statu */ \
	0x73,0x20,0x69,0x6e,0x66,0x6f,0x72,0x6d,0x61,0x74,0x69,0x6f,0x6e,0x2e,0x20,0x20, /* s information.   */ \
	0x54,0x68,0x65,0x20,0x61,0x74,0x74,0x61,0x63,0x68,0x65,0x64,0x20,0x43,0x53,0x56, /* The attached CSV */ \
	0x20,0x66,0x69,0x6c,0x65,0x20,0x77,0x69,0x6c,0x6c,0x20,0x6f,0x70,0x65,0x6e,0x20, /*  file will open  */ \
	0x69,0x6e,0x20,0x61,0x6e,0x79,0x20,0x73,0x70,0x72,0x65,0x61,0x64,0x73,0x68,0x65, /* in any spreadshe */ \
	0x65,0x74,0x20,0x70,0x72,0x6f,0x67,0x72,0x61,0x6d,0x2e,0x3c,0x2f,0x74,0x65,0x78, /* et program.</tex */ \
	0x74,0x61,0x72,0x65,0x61,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a, /* tarea>..</div>.. */ \
	0x3c,0x64,0x69,0x76,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x69,0x64,0x3d,0x22, /* <div><input id=" */ \
	0x62,0x74,0x6e,0x53,0x75,0x62,0x6d,0x69,0x74,0x22,0x20,0x74,0x79,0x70,0x65,0x3d, /* btnSubmit" type= */ \
	0x22,0x73,0x75,0x62,0x6d,0x69,0x74,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22, /* "submit" class=" */ \
	0x73,0x6d,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x53,0x65,0x6e,0x64,0x20, /* sm" value="Send  */ \
	0x4d,0x65,0x73,0x73,0x61,0x67,0x65,0x22,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e, /* Message"/></div> */ \
	0x0d,0x0a,0x3c,0x2f,0x66,0x69,0x65,0x6c,0x64,0x73,0x65,0x74,0x3e,0x0d,0x0a,0x3c, /* ..</fieldset>..< */ \
	0x2f,0x66,0x6f,0x72,0x6d,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a, /* /form>..</div>.. */ \
	0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22, /* ..<script type=" */ \
	0x74,0x65,0x78,0x74,0x2f,0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22, /* text/javascript" */ \
	0x3e,0x0d,0x0a,0x3c,0x21,0x2d,0x2d,0x0d,0x0a,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e, /* >..<!--..documen */ \
	0x74,0x2e,0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64, /* t.getElementById */ \
	0x28,0x27,0x68,0x65,0x6c,0x6c,0x6f,0x27,0x29,0x2e,0x69,0x6e,0x6e,0x65,0x72,0x48, /* ('hello').innerH */ \
	0x54,0x4d,0x4c,0x20,0x3d,0x20,0x22,0x7e,0x68,0x65,0x6c,0x6c,0x6f,0x6d,0x73,0x67, /* TML = "~hellomsg */ \
	0x7e,0x22,0x3b,0x0d,0x0a,0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69, /* ~";..-->..</scri */ \
	0x70,0x74,0x3e,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72, /* pt>..~inc:footer */ \
	0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0x66, /* .inc~......3...f */ \
	0x00,0x00,0x00,0x1e,0x00,0x00,0x00,0xc2,0x00,0x00,0x00,0x24,0x00,0x00,0x00,0x0c, /* ...........$.... */ \
	0x04,0x00,0x00,0x48,0x00,0x00,0x00,0x24,0x07,0x00,0x00,0x01,0x00,0x00,0x00,0x42, /* ...H...$.......B */ \
	0x07,0x00,0x00,0x02,0x00,0x00,0x00,0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65,0x61,0x64, /* .......~inc:head */ \
	0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64, /* er.inc~..<div id */ \
	0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c, /* ="content">....< */ \
	0x68,0x31,0x3e,0x4c,0x6f,0x67,0x69,0x6e,0x20,0x53,0x75,0x63,0x63,0x65,0x73,0x73, /* h1>Login Success */ \
	0x66,0x75,0x6c,0x3c,0x2f,0x68,0x31,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x3e,0x59, /* ful</h1>....<p>Y */ \
	0x6f,0x75,0x20,0x68,0x61,0x76,0x65,0x20,0x73,0x75,0x63,0x63,0x65,0x73,0x73,0x66, /* ou have successf */ \
	0x75,0x6c,0x6c,0x79,0x20,0x6c,0x6f,0x67,0x67,0x65,0x64,0x20,0x69,0x6e,0x20,0x74, /* ully logged in t */ \
	0x6f,0x20,0x74,0x68,0x65,0x20,0x77,0x65,0x62,0x20,0x73,0x65,0x72,0x76,0x65,0x72, /* o the web server */ \
	0x2e,0x20,0x20,0x54,0x68,0x69,0x73,0x20,0x61,0x75,0x74,0x68,0x65,0x6e,0x74,0x69, /* .  This authenti */ \
	0x63,0x61,0x74,0x69,0x6f,0x6e,0x20,0x0d,0x0a,0x69,0x73,0x20,0x76,0x61,0x6c,0x69, /* cation ..is vali */ \
	0x64,0x20,0x75,0x6e,0x74,0x69,0x6c,0x20,0x79,0x6f,0x75,0x20,0x63,0x6c,0x6f,0x73, /* d until you clos */ \
	0x65,0x20,0x79,0x6f,0x75,0x72,0x20,0x62,0x72,0x6f,0x77,0x73,0x65,0x72,0x2e,0x3c, /* e your browser.< */ \
	0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x3e,0x43,0x72,0x65,0x64,0x65,0x6e, /* /p>....<p>Creden */ \
	0x74,0x69,0x61,0x6c,0x73,0x20,0x61,0x72,0x65,0x20,0x76,0x65,0x72,0x69,0x66,0x69, /* tials are verifi */ \
	0x65,0x64,0x20,0x69,0x6e,0x20,0x79,0x6f,0x75,0x72,0x20,0x6f,0x77,0x6e,0x20,0x63, /* ed in your own c */ \
	0x75,0x73,0x74,0x6f,0x6d,0x20,0x63,0x61,0x6c,0x6c,0x62,0x61,0x63,0x6b,0x20,0x66, /* ustom callback f */ \
	0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x20,0x63,0x61,0x6c,0x6c,0x65,0x64,0x20,0x0d, /* unction called . */ \
	0x0a,0x3c,0x63,0x6f,0x64,0x65,0x3e,0x48,0x54,0x54,0x50,0x41,0x75,0x74,0x68,0x65, /* .<code>HTTPAuthe */ \
	0x6e,0x74,0x69,0x63,0x61,0x74,0x65,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x2e,0x20, /* nticate</code>.  */ \
	0x20,0x49,0x6e,0x20,0x68,0x65,0x72,0x65,0x2c,0x20,0x79,0x6f,0x75,0x20,0x63,0x61, /*  In here, you ca */ \
	0x6e,0x20,0x64,0x65,0x74,0x65,0x72,0x6d,0x69,0x6e,0x65,0x20,0x69,0x66,0x20,0x74, /* n determine if t */ \
	0x68,0x65,0x20,0x73,0x75,0x70,0x70,0x6c,0x69,0x65,0x64,0x0d,0x0a,0x75,0x73,0x65, /* he supplied..use */ \
	0x72,0x20,0x6e,0x61,0x6d,0x65,0x20,0x61,0x6e,0x64,0x20,0x70,0x61,0x73,0x73,0x77, /* r name and passw */ \
	0x6f,0x72,0x64,0x20,0x61,0x72,0x65,0x20,0x76,0x61,0x6c,0x69,0x64,0x20,0x66,0x6f, /* ord are valid fo */ \
	0x72,0x20,0x61,0x63,0x63,0x65,0x73,0x73,0x20,0x74,0x6f,0x20,0x74,0x68,0x65,0x20  /* r access to the  */
#define DATACHUNK00000d \
	0x72,0x65,0x71,0x75,0x65,0x73,0x74,0x65,0x64,0x20,0x70,0x61,0x67,0x65,0x2e,0x20, /* requested page.  */ \
	0x20,0x59,0x6f,0x75,0x20,0x63,0x61,0x6e,0x20,0x0d,0x0a,0x61,0x64,0x64,0x20,0x6d, /*  You can ..add m */ \
	0x75,0x6c,0x74,0x69,0x70,0x6c,0x65,0x20,0x75,0x73,0x65,0x72,0x73,0x20,0x61,0x6e, /* ultiple users an */ \
	0x64,0x20,0x72,0x65,0x73,0x74,0x72,0x69,0x63,0x74,0x20,0x64,0x69,0x66,0x66,0x65, /* d restrict diffe */ \
	0x72,0x65,0x6e,0x74,0x20,0x75,0x73,0x65,0x72,0x73,0x20,0x74,0x6f,0x20,0x64,0x69, /* rent users to di */ \
	0x66,0x66,0x65,0x72,0x65,0x6e,0x74,0x20,0x70,0x61,0x67,0x65,0x73,0x2e,0x3c,0x2f, /* fferent pages.</ */ \
	0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22, /* p>....<p class=" */ \
	0x65,0x78,0x65,0x72,0x63,0x69,0x73,0x65,0x22,0x3e,0x3c,0x62,0x3e,0x45,0x78,0x65, /* exercise"><b>Exe */ \
	0x72,0x63,0x69,0x73,0x65,0x3a,0x3c,0x2f,0x62,0x3e,0x20,0x43,0x68,0x61,0x6e,0x67, /* rcise:</b> Chang */ \
	0x65,0x20,0x74,0x68,0x65,0x20,0x75,0x73,0x65,0x72,0x20,0x6e,0x61,0x6d,0x65,0x20, /* e the user name  */ \
	0x61,0x6e,0x64,0x20,0x70,0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x20,0x69,0x6e,0x0d, /* and password in. */ \
	0x0a,0x3c,0x63,0x6f,0x64,0x65,0x3e,0x48,0x54,0x54,0x50,0x41,0x75,0x74,0x68,0x65, /* .<code>HTTPAuthe */ \
	0x6e,0x74,0x69,0x63,0x61,0x74,0x65,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x20,0x74, /* nticate</code> t */ \
	0x6f,0x20,0x6f,0x6e,0x65,0x20,0x6f,0x66,0x20,0x79,0x6f,0x75,0x72,0x20,0x63,0x68, /* o one of your ch */ \
	0x6f,0x6f,0x73,0x69,0x6e,0x67,0x2e,0x20,0x20,0x28,0x54,0x68,0x65,0x20,0x63,0x61, /* oosing.  (The ca */ \
	0x6c,0x6c,0x62,0x61,0x63,0x6b,0x20,0x69,0x73,0x20,0x0d,0x0a,0x6c,0x6f,0x63,0x61, /* llback is ..loca */ \
	0x74,0x65,0x64,0x20,0x69,0x6e,0x20,0x3c,0x63,0x6f,0x64,0x65,0x3e,0x43,0x75,0x73, /* ted in <code>Cus */ \
	0x74,0x6f,0x6d,0x48,0x54,0x54,0x50,0x41,0x70,0x70,0x2e,0x63,0x3c,0x2f,0x63,0x6f, /* tomHTTPApp.c</co */ \
	0x64,0x65,0x3e,0x2e,0x29,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x64,0x69, /* de>.)</p>....<di */ \
	0x76,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x65,0x78,0x61,0x6d,0x70,0x6c,0x65, /* v class="example */ \
	0x62,0x6f,0x78,0x22,0x3e,0x0d,0x0a,0x57,0x68,0x65,0x6e,0x20,0x79,0x6f,0x75,0x20, /* box">..When you  */ \
	0x66,0x69,0x6e,0x69,0x73,0x68,0x2c,0x20,0x72,0x65,0x66,0x72,0x65,0x73,0x68,0x20, /* finish, refresh  */ \
	0x74,0x68,0x69,0x73,0x20,0x70,0x61,0x67,0x65,0x20,0x74,0x6f,0x20,0x74,0x65,0x73, /* this page to tes */ \
	0x74,0x20,0x79,0x6f,0x75,0x72,0x20,0x6e,0x65,0x77,0x20,0x75,0x73,0x65,0x72,0x20, /* t your new user  */ \
	0x6e,0x61,0x6d,0x65,0x20,0x61,0x6e,0x64,0x20,0x70,0x61,0x73,0x73,0x77,0x6f,0x72, /* name and passwor */ \
	0x64,0x20,0x0d,0x0a,0x63,0x6f,0x6d,0x62,0x69,0x6e,0x61,0x74,0x69,0x6f,0x6e,0x2e, /* d ..combination. */ \
	0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x2f,0x64,0x69, /* ..</div>....</di */ \
	0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x74,0x79, /* v>....<script ty */ \
	0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x2f,0x6a,0x61,0x76,0x61,0x73,0x63,0x72, /* pe="text/javascr */ \
	0x69,0x70,0x74,0x22,0x3e,0x0d,0x0a,0x3c,0x21,0x2d,0x2d,0x0d,0x0a,0x64,0x6f,0x63, /* ipt">..<!--..doc */ \
	0x75,0x6d,0x65,0x6e,0x74,0x2e,0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74, /* ument.getElement */ \
	0x42,0x79,0x49,0x64,0x28,0x27,0x68,0x65,0x6c,0x6c,0x6f,0x27,0x29,0x2e,0x69,0x6e, /* ById('hello').in */ \
	0x6e,0x65,0x72,0x48,0x54,0x4d,0x4c,0x20,0x3d,0x20,0x22,0x7e,0x68,0x65,0x6c,0x6c, /* nerHTML = "~hell */ \
	0x6f,0x6d,0x73,0x67,0x7e,0x22,0x3b,0x0d,0x0a,0x2f,0x2f,0x2d,0x2d,0x3e,0x0d,0x0a, /* omsg~";..//-->.. */ \
	0x3c,0x2f,0x73,0x63,0x72,0x69,0x70,0x74,0x3e,0x0d,0x0a,0x0d,0x0a,0x7e,0x69,0x6e, /* </script>....~in */ \
	0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x00,0x00,0x00, /* c:footer.inc~... */ \
	0x00,0x33,0x00,0x00,0x00,0x94,0x03,0x00,0x00,0x01,0x00,0x00,0x00,0xb6,0x03,0x00, /* .3.............. */ \
	0x00,0x02,0x00,0x00,0x00,0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72, /* .....~inc:header */ \
	0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22, /* .inc~..<div id=" */ \
	0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31, /* content">....<h1 */ \
	0x3e,0x4e,0x65,0x74,0x77,0x6f,0x72,0x6b,0x20,0x43,0x6f,0x6e,0x66,0x69,0x67,0x75, /* >Network Configu */ \
	0x72,0x61,0x74,0x69,0x6f,0x6e,0x3c,0x2f,0x68,0x31,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c, /* ration</h1>....< */ \
	0x66,0x6f,0x72,0x6d,0x20,0x6d,0x65,0x74,0x68,0x6f,0x64,0x3d,0x22,0x70,0x6f,0x73, /* form method="pos */ \
	0x74,0x22,0x20,0x61,0x63,0x74,0x69,0x6f,0x6e,0x3d,0x22,0x2f,0x70,0x72,0x6f,0x74, /* t" action="/prot */ \
	0x65,0x63,0x74,0x2f,0x63,0x6f,0x6e,0x66,0x69,0x67,0x2e,0x68,0x74,0x6d,0x22,0x20, /* ect/config.htm"  */ \
	0x6e,0x61,0x6d,0x65,0x3d,0x22,0x63,0x6f,0x6e,0x66,0x69,0x67,0x22,0x3e,0x0d,0x0a, /* name="config">.. */ \
	0x3c,0x66,0x69,0x65,0x6c,0x64,0x73,0x65,0x74,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76, /* <fieldset>..<div */ \
	0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x4d,0x41,0x43,0x20,0x41,0x64,0x64,0x72, /* ><label>MAC Addr */ \
	0x65,0x73,0x73,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69, /* ess:</label>..<i */ \
	0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22, /* nput type="text" */ \
	0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x6d,0x61,0x63,0x22,0x20,0x76,0x61,0x6c,0x75, /*  name="mac" valu */ \
	0x65,0x3d,0x22,0x7e,0x63,0x6f,0x6e,0x66,0x69,0x67,0x5f,0x6d,0x61,0x63,0x7e,0x22, /* e="~config_mac~" */ \
	0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e, /*  /></div>..<div> */ \
	0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x53,0x65,0x72,0x76,0x65,0x72,0x20,0x4e,0x61, /* <label>Server Na */ \
	0x6d,0x65,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e, /* me:</label>..<in */ \
	0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20, /* put type="text"  */ \
	0x6e,0x61,0x6d,0x65,0x3d,0x22,0x68,0x6f,0x73,0x74,0x22,0x20,0x76,0x61,0x6c,0x75, /* name="host" valu */ \
	0x65,0x3d,0x22,0x7e,0x73,0x65,0x72,0x76,0x65,0x72,0x5f,0x6e,0x61,0x6d,0x65,0x7e, /* e="~server_name~ */ \
	0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76, /* " /></div>..<div */ \
	0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x4f,0x75,0x74,0x20,0x42,0x6f,0x75,0x6e, /* ><label>Out Boun */ \
	0x64,0x20,0x50,0x6f,0x72,0x74,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d, /* d Port:</label>. */ \
	0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65, /* .<input type="te */ \
	0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x6f,0x70,0x72,0x74,0x22,0x20, /* xt" name="oprt"  */ \
	0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x6f,0x75,0x74,0x5f,0x70,0x6f,0x72,0x74  /* value="~out_port */
#define DATACHUNK00000e \
	0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69, /* ~" /></div>..<di */ \
	0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x49,0x6e,0x20,0x42,0x6f,0x75,0x6e, /* v><label>In Boun */ \
	0x64,0x20,0x50,0x6f,0x72,0x74,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d, /* d Port:</label>. */ \
	0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65, /* .<input type="te */ \
	0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x69,0x70,0x72,0x74,0x22,0x20, /* xt" name="iprt"  */ \
	0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x69,0x6e,0x5f,0x70,0x6f,0x72,0x74,0x7e, /* value="~in_port~ */ \
	0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76, /* " /></div>..<div */ \
	0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x52,0x6f,0x6f,0x6d,0x20,0x4e,0x61,0x6d, /* ><label>Room Nam */ \
	0x65,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70, /* e:</label>..<inp */ \
	0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e, /* ut type="text" n */ \
	0x61,0x6d,0x65,0x3d,0x22,0x52,0x6d,0x4e,0x6d,0x22,0x20,0x76,0x61,0x6c,0x75,0x65, /* ame="RmNm" value */ \
	0x3d,0x22,0x7e,0x52,0x6f,0x6f,0x6d,0x4e,0x61,0x6d,0x65,0x7e,0x22,0x20,0x2f,0x3e, /* ="~RoomName~" /> */ \
	0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61, /* </div>..<div><la */ \
	0x62,0x65,0x6c,0x3e,0x4e,0x6f,0x64,0x65,0x20,0x43,0x61,0x6c,0x6c,0x73,0x69,0x67, /* bel>Node Callsig */ \
	0x6e,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70, /* n:</label>..<inp */ \
	0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e, /* ut type="text" n */ \
	0x61,0x6d,0x65,0x3d,0x22,0x4e,0x64,0x4e,0x6d,0x22,0x20,0x76,0x61,0x6c,0x75,0x65, /* ame="NdNm" value */ \
	0x3d,0x22,0x7e,0x4e,0x6f,0x64,0x65,0x4e,0x61,0x6d,0x65,0x7e,0x22,0x20,0x2f,0x3e, /* ="~NodeName~" /> */ \
	0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x26,0x6e,0x62, /* </div>..<div>&nb */ \
	0x73,0x70,0x3b,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e, /* sp;</div>..<div> */ \
	0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63, /* ..<input type="c */ \
	0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22, /* heckbox" class=" */ \
	0x73,0x6d,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x64,0x68,0x63,0x70,0x22,0x20, /* sm" name="dhcp"  */ \
	0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x31,0x22,0x20,0x6f,0x6e,0x63,0x6c,0x69,0x63, /* value="1" onclic */ \
	0x6b,0x3d,0x22,0x63,0x6f,0x6e,0x66,0x69,0x67,0x49,0x50,0x42,0x6f,0x78,0x65,0x73, /* k="configIPBoxes */ \
	0x28,0x29,0x22,0x20,0x7e,0x63,0x6f,0x6e,0x66,0x69,0x67,0x5f,0x64,0x68,0x63,0x70, /* ()" ~config_dhcp */ \
	0x63,0x68,0x65,0x63,0x6b,0x65,0x64,0x7e,0x20,0x2f,0x3e,0x20,0x45,0x6e,0x61,0x62, /* checked~ /> Enab */ \
	0x6c,0x65,0x20,0x44,0x48,0x43,0x50,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c, /* le DHCP</div>..< */ \
	0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x49,0x50,0x20,0x41,0x64, /* div><label>IP Ad */ \
	0x64,0x72,0x65,0x73,0x73,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a, /* dress:</label>.. */ \
	0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d, /* <td><input type= */ \
	0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x69,0x70,0x22, /* "text" name="ip" */ \
	0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x63,0x6f,0x6e,0x66,0x69,0x67,0x5f, /*  value="~config_ */ \
	0x69,0x70,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c, /* ip~" /></div>..< */ \
	0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x47,0x61,0x74,0x65,0x77, /* div><label>Gatew */ \
	0x61,0x79,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74,0x64, /* ay:</label>..<td */ \
	0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65, /* ><input type="te */ \
	0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x67,0x77,0x22,0x20,0x76,0x61, /* xt" name="gw" va */ \
	0x6c,0x75,0x65,0x3d,0x22,0x7e,0x63,0x6f,0x6e,0x66,0x69,0x67,0x5f,0x67,0x77,0x7e, /* lue="~config_gw~ */ \
	0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76, /* " /></div>..<div */ \
	0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x53,0x75,0x62,0x6e,0x65,0x74,0x20,0x4d, /* ><label>Subnet M */ \
	0x61,0x73,0x6b,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74, /* ask:</label>..<t */ \
	0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74, /* d><input type="t */ \
	0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x73,0x75,0x62,0x22,0x20, /* ext" name="sub"  */ \
	0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x63,0x6f,0x6e,0x66,0x69,0x67,0x5f,0x73, /* value="~config_s */ \
	0x75,0x62,0x6e,0x65,0x74,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e, /* ubnet~" /></div> */ \
	0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x50,0x72, /* ..<div><label>Pr */ \
	0x69,0x6d,0x61,0x72,0x79,0x20,0x44,0x4e,0x53,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65, /* imary DNS:</labe */ \
	0x6c,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74, /* l>..<td><input t */ \
	0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d, /* ype="text" name= */ \
	0x22,0x64,0x6e,0x73,0x31,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x63, /* "dns1" value="~c */ \
	0x6f,0x6e,0x66,0x69,0x67,0x5f,0x64,0x6e,0x73,0x31,0x7e,0x22,0x20,0x2f,0x3e,0x3c, /* onfig_dns1~" />< */ \
	0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62, /* /div>..<div><lab */ \
	0x65,0x6c,0x3e,0x53,0x65,0x63,0x6f,0x6e,0x64,0x61,0x72,0x79,0x20,0x44,0x4e,0x53, /* el>Secondary DNS */ \
	0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75, /* :</label>..<inpu */ \
	0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61, /* t type="text" na */ \
	0x6d,0x65,0x3d,0x22,0x64,0x6e,0x73,0x32,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d, /* me="dns2" value= */ \
	0x22,0x7e,0x63,0x6f,0x6e,0x66,0x69,0x67,0x5f,0x64,0x6e,0x73,0x32,0x7e,0x22,0x20, /* "~config_dns2~"  */ \
	0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c, /* /></div>..<div>< */ \
	0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x73,0x75,0x62,0x6d, /* input type="subm */ \
	0x69,0x74,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x73,0x6d,0x22,0x20,0x76, /* it" class="sm" v */ \
	0x61,0x6c,0x75,0x65,0x3d,0x22,0x53,0x61,0x76,0x65,0x20,0x43,0x6f,0x6e,0x66,0x69, /* alue="Save Confi */ \
	0x67,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x2f,0x66, /* g" /></div>..</f */ \
	0x69,0x65,0x6c,0x64,0x73,0x65,0x74,0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x6f,0x72,0x6d  /* ieldset>..</form */
#define DATACHUNK00000f \
	0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x73,0x63, /* >..</div>....<sc */ \
	0x72,0x69,0x70,0x74,0x20,0x6c,0x61,0x6e,0x67,0x75,0x61,0x67,0x65,0x3d,0x22,0x6a, /* ript language="j */ \
	0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x0d,0x0a,0x3c,0x21,0x2d, /* avascript">..<!- */ \
	0x2d,0x0d,0x0a,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x20,0x63,0x6f,0x6e,0x66, /* -..function conf */ \
	0x69,0x67,0x49,0x50,0x42,0x6f,0x78,0x65,0x73,0x28,0x29,0x20,0x7b,0x0d,0x0a,0x09, /* igIPBoxes() {... */ \
	0x65,0x20,0x3d,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x66,0x6f,0x72, /* e = document.for */ \
	0x6d,0x73,0x2e,0x63,0x6f,0x6e,0x66,0x69,0x67,0x3b,0x0d,0x0a,0x09,0x73,0x74,0x20, /* ms.config;...st  */ \
	0x3d,0x20,0x65,0x2e,0x64,0x68,0x63,0x70,0x2e,0x63,0x68,0x65,0x63,0x6b,0x65,0x64, /* = e.dhcp.checked */ \
	0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x69,0x70,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65, /* ;...e.ip.disable */ \
	0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x67,0x77,0x2e,0x64, /* d = st;...e.gw.d */ \
	0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a,0x09, /* isabled = st;... */ \
	0x65,0x2e,0x73,0x75,0x62,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d, /* e.sub.disabled = */ \
	0x20,0x73,0x74,0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x64,0x6e,0x73,0x31,0x2e,0x64,0x69, /*  st;...e.dns1.di */ \
	0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a,0x09,0x65, /* sabled = st;...e */ \
	0x2e,0x64,0x6e,0x73,0x32,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d, /* .dns2.disabled = */ \
	0x20,0x73,0x74,0x3b,0x0d,0x0a,0x7d,0x0d,0x0a,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e, /*  st;..}..documen */ \
	0x74,0x2e,0x66,0x6f,0x72,0x6d,0x73,0x2e,0x63,0x6f,0x6e,0x66,0x69,0x67,0x2e,0x6d, /* t.forms.config.m */ \
	0x61,0x63,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x74,0x72, /* ac.disabled = tr */ \
	0x75,0x65,0x3b,0x0d,0x0a,0x0d,0x0a,0x63,0x6f,0x6e,0x66,0x69,0x67,0x49,0x50,0x42, /* ue;....configIPB */ \
	0x6f,0x78,0x65,0x73,0x28,0x29,0x3b,0x0d,0x0a,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e, /* oxes();..documen */ \
	0x74,0x2e,0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64, /* t.getElementById */ \
	0x28,0x27,0x68,0x65,0x6c,0x6c,0x6f,0x27,0x29,0x2e,0x69,0x6e,0x6e,0x65,0x72,0x48, /* ('hello').innerH */ \
	0x54,0x4d,0x4c,0x20,0x3d,0x20,0x22,0x7e,0x68,0x65,0x6c,0x6c,0x6f,0x6d,0x73,0x67, /* TML = "~hellomsg */ \
	0x7e,0x22,0x3b,0x0d,0x0a,0x2f,0x2f,0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63, /* ~";..//-->..</sc */ \
	0x72,0x69,0x70,0x74,0x3e,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74, /* ript>..~inc:foot */ \
	0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0xde, /* er.inc~....3.... */ \
	0x00,0x00,0x00,0x25,0x00,0x00,0x00,0x3e,0x01,0x00,0x00,0x4a,0x00,0x00,0x00,0xa2, /* ...%...>...J.... */ \
	0x01,0x00,0x00,0x4b,0x00,0x00,0x00,0x02,0x02,0x00,0x00,0x4c,0x00,0x00,0x00,0x5d, /* ...K.......L...] */ \
	0x02,0x00,0x00,0x4d,0x00,0x00,0x00,0xbd,0x02,0x00,0x00,0x4e,0x00,0x00,0x00,0x3f, /* ...M.......N...? */ \
	0x03,0x00,0x00,0x27,0x00,0x00,0x00,0xb3,0x03,0x00,0x00,0x28,0x00,0x00,0x00,0x10, /* ...'.......(.... */ \
	0x04,0x00,0x00,0x29,0x00,0x00,0x00,0x72,0x04,0x00,0x00,0x2a,0x00,0x00,0x00,0xd9, /* ...)...r........ */ \
	0x04,0x00,0x00,0x2b,0x00,0x00,0x00,0x3c,0x05,0x00,0x00,0x2c,0x00,0x00,0x00,0x12, /* ...+...<...,.... */ \
	0x07,0x00,0x00,0x01,0x00,0x00,0x00,0x32,0x07,0x00,0x00,0x02,0x00,0x00,0x00,0x7e, /* .......2.......~ */ \
	0x69,0x6e,0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d, /* inc:header.inc~. */ \
	0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65,0x6e, /* .<div id="conten */ \
	0x74,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x4c,0x6f,0x67,0x69,0x6e, /* t">....<h1>Login */ \
	0x20,0x53,0x75,0x63,0x63,0x65,0x73,0x73,0x66,0x75,0x6c,0x3c,0x2f,0x68,0x31,0x3e, /*  Successful</h1> */ \
	0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x3e,0x59,0x6f,0x75,0x20,0x68,0x61,0x76,0x65,0x20, /* ....<p>You have  */ \
	0x73,0x75,0x63,0x63,0x65,0x73,0x73,0x66,0x75,0x6c,0x6c,0x79,0x20,0x6c,0x6f,0x67, /* successfully log */ \
	0x67,0x65,0x64,0x20,0x69,0x6e,0x20,0x74,0x6f,0x20,0x74,0x68,0x65,0x20,0x77,0x65, /* ged in to the we */ \
	0x62,0x20,0x73,0x65,0x72,0x76,0x65,0x72,0x2e,0x20,0x20,0x54,0x68,0x69,0x73,0x20, /* b server.  This  */ \
	0x61,0x75,0x74,0x68,0x65,0x6e,0x74,0x69,0x63,0x61,0x74,0x69,0x6f,0x6e,0x20,0x0d, /* authentication . */ \
	0x0a,0x69,0x73,0x20,0x76,0x61,0x6c,0x69,0x64,0x20,0x75,0x6e,0x74,0x69,0x6c,0x20, /* .is valid until  */ \
	0x79,0x6f,0x75,0x20,0x63,0x6c,0x6f,0x73,0x65,0x20,0x79,0x6f,0x75,0x72,0x20,0x62, /* you close your b */ \
	0x72,0x6f,0x77,0x73,0x65,0x72,0x2e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c, /* rowser.</p>....< */ \
	0x70,0x3e,0x43,0x72,0x65,0x64,0x65,0x6e,0x74,0x69,0x61,0x6c,0x73,0x20,0x61,0x72, /* p>Credentials ar */ \
	0x65,0x20,0x76,0x65,0x72,0x69,0x66,0x69,0x65,0x64,0x20,0x69,0x6e,0x20,0x79,0x6f, /* e verified in yo */ \
	0x75,0x72,0x20,0x6f,0x77,0x6e,0x20,0x63,0x75,0x73,0x74,0x6f,0x6d,0x20,0x63,0x61, /* ur own custom ca */ \
	0x6c,0x6c,0x62,0x61,0x63,0x6b,0x20,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x20, /* llback function  */ \
	0x63,0x61,0x6c,0x6c,0x65,0x64,0x20,0x0d,0x0a,0x3c,0x63,0x6f,0x64,0x65,0x3e,0x48, /* called ..<code>H */ \
	0x54,0x54,0x50,0x41,0x75,0x74,0x68,0x65,0x6e,0x74,0x69,0x63,0x61,0x74,0x65,0x3c, /* TTPAuthenticate< */ \
	0x2f,0x63,0x6f,0x64,0x65,0x3e,0x2e,0x20,0x20,0x49,0x6e,0x20,0x68,0x65,0x72,0x65, /* /code>.  In here */ \
	0x2c,0x20,0x79,0x6f,0x75,0x20,0x63,0x61,0x6e,0x20,0x64,0x65,0x74,0x65,0x72,0x6d, /* , you can determ */ \
	0x69,0x6e,0x65,0x20,0x69,0x66,0x20,0x74,0x68,0x65,0x20,0x73,0x75,0x70,0x70,0x6c, /* ine if the suppl */ \
	0x69,0x65,0x64,0x0d,0x0a,0x75,0x73,0x65,0x72,0x20,0x6e,0x61,0x6d,0x65,0x20,0x61, /* ied..user name a */ \
	0x6e,0x64,0x20,0x70,0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x20,0x61,0x72,0x65,0x20, /* nd password are  */ \
	0x76,0x61,0x6c,0x69,0x64,0x20,0x66,0x6f,0x72,0x20,0x61,0x63,0x63,0x65,0x73,0x73, /* valid for access */ \
	0x20,0x74,0x6f,0x20,0x74,0x68,0x65,0x20,0x72,0x65,0x71,0x75,0x65,0x73,0x74,0x65, /*  to the requeste */ \
	0x64,0x20,0x70,0x61,0x67,0x65,0x2e,0x20,0x20,0x59,0x6f,0x75,0x20,0x63,0x61,0x6e, /* d page.  You can */ \
	0x20,0x0d,0x0a,0x61,0x64,0x64,0x20,0x6d,0x75,0x6c,0x74,0x69,0x70,0x6c,0x65,0x20, /*  ..add multiple  */ \
	0x75,0x73,0x65,0x72,0x73,0x20,0x61,0x6e,0x64,0x20,0x72,0x65,0x73,0x74,0x72,0x69, /* users and restri */ \
	0x63,0x74,0x20,0x64,0x69,0x66,0x66,0x65,0x72,0x65,0x6e,0x74,0x20,0x75,0x73,0x65, /* ct different use */ \
	0x72,0x73,0x20,0x74,0x6f,0x20,0x64,0x69,0x66,0x66,0x65,0x72,0x65,0x6e,0x74,0x20, /* rs to different  */ \
	0x70,0x61,0x67,0x65,0x73,0x2e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70  /* pages.</p>....<p */
#define DATACHUNK000010 \
	0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x65,0x78,0x65,0x72,0x63,0x69,0x73,0x65, /*  class="exercise */ \
	0x22,0x3e,0x3c,0x62,0x3e,0x45,0x78,0x65,0x72,0x63,0x69,0x73,0x65,0x3a,0x3c,0x2f, /* "><b>Exercise:</ */ \
	0x62,0x3e,0x20,0x43,0x68,0x61,0x6e,0x67,0x65,0x20,0x74,0x68,0x65,0x20,0x75,0x73, /* b> Change the us */ \
	0x65,0x72,0x20,0x6e,0x61,0x6d,0x65,0x20,0x61,0x6e,0x64,0x20,0x70,0x61,0x73,0x73, /* er name and pass */ \
	0x77,0x6f,0x72,0x64,0x20,0x69,0x6e,0x0d,0x0a,0x3c,0x63,0x6f,0x64,0x65,0x3e,0x48, /* word in..<code>H */ \
	0x54,0x54,0x50,0x41,0x75,0x74,0x68,0x65,0x6e,0x74,0x69,0x63,0x61,0x74,0x65,0x3c, /* TTPAuthenticate< */ \
	0x2f,0x63,0x6f,0x64,0x65,0x3e,0x20,0x74,0x6f,0x20,0x6f,0x6e,0x65,0x20,0x6f,0x66, /* /code> to one of */ \
	0x20,0x79,0x6f,0x75,0x72,0x20,0x63,0x68,0x6f,0x6f,0x73,0x69,0x6e,0x67,0x2e,0x20, /*  your choosing.  */ \
	0x20,0x28,0x54,0x68,0x65,0x20,0x63,0x61,0x6c,0x6c,0x62,0x61,0x63,0x6b,0x20,0x69, /*  (The callback i */ \
	0x73,0x20,0x0d,0x0a,0x6c,0x6f,0x63,0x61,0x74,0x65,0x64,0x20,0x69,0x6e,0x20,0x3c, /* s ..located in < */ \
	0x63,0x6f,0x64,0x65,0x3e,0x43,0x75,0x73,0x74,0x6f,0x6d,0x48,0x54,0x54,0x50,0x41, /* code>CustomHTTPA */ \
	0x70,0x70,0x2e,0x63,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x2e,0x29,0x3c,0x2f,0x70, /* pp.c</code>.)</p */ \
	0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d, /* >....<div class= */ \
	0x22,0x65,0x78,0x61,0x6d,0x70,0x6c,0x65,0x62,0x6f,0x78,0x22,0x3e,0x0d,0x0a,0x57, /* "examplebox">..W */ \
	0x68,0x65,0x6e,0x20,0x79,0x6f,0x75,0x20,0x66,0x69,0x6e,0x69,0x73,0x68,0x2c,0x20, /* hen you finish,  */ \
	0x72,0x65,0x66,0x72,0x65,0x73,0x68,0x20,0x74,0x68,0x69,0x73,0x20,0x70,0x61,0x67, /* refresh this pag */ \
	0x65,0x20,0x74,0x6f,0x20,0x74,0x65,0x73,0x74,0x20,0x79,0x6f,0x75,0x72,0x20,0x6e, /* e to test your n */ \
	0x65,0x77,0x20,0x75,0x73,0x65,0x72,0x20,0x6e,0x61,0x6d,0x65,0x20,0x61,0x6e,0x64, /* ew user name and */ \
	0x20,0x70,0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x20,0x0d,0x0a,0x63,0x6f,0x6d,0x62, /*  password ..comb */ \
	0x69,0x6e,0x61,0x74,0x69,0x6f,0x6e,0x2e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e, /* ination...</div> */ \
	0x0d,0x0a,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x73, /* ....</div>....<s */ \
	0x63,0x72,0x69,0x70,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74, /* cript type="text */ \
	0x2f,0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x0d,0x0a,0x3c, /* /javascript">..< */ \
	0x21,0x2d,0x2d,0x0d,0x0a,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x67,0x65, /* !--..document.ge */ \
	0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28,0x27,0x68,0x65, /* tElementById('he */ \
	0x6c,0x6c,0x6f,0x27,0x29,0x2e,0x69,0x6e,0x6e,0x65,0x72,0x48,0x54,0x4d,0x4c,0x20, /* llo').innerHTML  */ \
	0x3d,0x20,0x22,0x7e,0x68,0x65,0x6c,0x6c,0x6f,0x6d,0x73,0x67,0x7e,0x22,0x3b,0x0d, /* = "~hellomsg~";. */ \
	0x0a,0x2f,0x2f,0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70,0x74, /* .//-->..</script */ \
	0x3e,0x0d,0x0a,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72, /* >....~inc:footer */ \
	0x2e,0x69,0x6e,0x63,0x7e,0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0x94,0x03,0x00, /* .inc~....3...... */ \
	0x00,0x01,0x00,0x00,0x00,0xb6,0x03,0x00,0x00,0x02,0x00,0x00,0x00,0x7e,0x72,0x65, /* .............~re */ \
	0x62,0x6f,0x6f,0x74,0x7e,0x00,0x00,0x00,0x00,0x2d,0x00,0x00,0x00,0x7e,0x69,0x6e, /* boot~....-...~in */ \
	0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x3c, /* c:header.inc~..< */ \
	0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x22, /* div id="content" */ \
	0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x52,0x65,0x62,0x6f,0x6f,0x74,0x20, /* >....<h1>Reboot  */ \
	0x49,0x6e,0x20,0x50,0x72,0x6f,0x67,0x72,0x65,0x73,0x73,0x2e,0x2e,0x2e,0x3c,0x2f, /* In Progress...</ */ \
	0x68,0x31,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x3e,0x59,0x6f,0x75,0x72,0x20,0x73, /* h1>....<p>Your s */ \
	0x65,0x74,0x74,0x69,0x6e,0x67,0x73,0x20,0x77,0x65,0x72,0x65,0x20,0x73,0x75,0x63, /* ettings were suc */ \
	0x63,0x65,0x73,0x73,0x66,0x75,0x6c,0x6c,0x79,0x20,0x73,0x61,0x76,0x65,0x64,0x2c, /* cessfully saved, */ \
	0x20,0x61,0x6e,0x64,0x20,0x74,0x68,0x65,0x20,0x62,0x6f,0x61,0x72,0x64,0x20,0x69, /*  and the board i */ \
	0x73,0x20,0x6e,0x6f,0x77,0x20,0x72,0x65,0x62,0x6f,0x6f,0x74,0x69,0x6e,0x67,0x20, /* s now rebooting  */ \
	0x0d,0x0a,0x74,0x6f,0x20,0x63,0x6f,0x6e,0x66,0x69,0x67,0x75,0x72,0x65,0x20,0x69, /* ..to configure i */ \
	0x74,0x73,0x65,0x6c,0x66,0x20,0x77,0x69,0x74,0x68,0x20,0x74,0x68,0x65,0x20,0x6e, /* tself with the n */ \
	0x65,0x77,0x20,0x73,0x65,0x74,0x74,0x69,0x6e,0x67,0x73,0x2e,0x3c,0x2f,0x70,0x3e, /* ew settings.</p> */ \
	0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x20,0x61,0x6c,0x69,0x67,0x6e,0x3d,0x22,0x63,0x65, /* ....<p align="ce */ \
	0x6e,0x74,0x65,0x72,0x22,0x3e,0x3c,0x62,0x3e,0x59,0x6f,0x75,0x72,0x20,0x62,0x6f, /* nter"><b>Your bo */ \
	0x61,0x72,0x64,0x20,0x69,0x73,0x20,0x6e,0x6f,0x77,0x20,0x6c,0x6f,0x63,0x61,0x74, /* ard is now locat */ \
	0x65,0x64,0x20,0x61,0x74,0x3a,0x20,0x0d,0x0a,0x3c,0x61,0x20,0x68,0x72,0x65,0x66, /* ed at: ..<a href */ \
	0x3d,0x22,0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f,0x7e,0x72,0x65,0x62,0x6f,0x6f,0x74, /* ="http://~reboot */ \
	0x61,0x64,0x64,0x72,0x7e,0x2f,0x22,0x3e,0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f,0x7e, /* addr~/">http://~ */ \
	0x72,0x65,0x62,0x6f,0x6f,0x74,0x61,0x64,0x64,0x72,0x7e,0x2f,0x3c,0x2f,0x61,0x3e, /* rebootaddr~/</a> */ \
	0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x36,0x3e, /* </b></p>....<h6> */ \
	0x3c,0x2f,0x68,0x36,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d, /* </h6>....</div>. */ \
	0x0a,0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x6c,0x61,0x6e,0x67,0x75, /* ...<script langu */ \
	0x61,0x67,0x65,0x3d,0x22,0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22, /* age="javascript" */ \
	0x3e,0x0d,0x0a,0x3c,0x21,0x2d,0x2d,0x0d,0x0a,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f, /* >..<!--..functio */ \
	0x6e,0x20,0x72,0x65,0x62,0x6f,0x6f,0x74,0x44,0x75,0x6d,0x6d,0x79,0x28,0x78,0x29, /* n rebootDummy(x) */ \
	0x7b,0x7d,0x0d,0x0a,0x73,0x65,0x74,0x54,0x69,0x6d,0x65,0x6f,0x75,0x74,0x28,0x22, /* {}..setTimeout(" */ \
	0x6e,0x65,0x77,0x41,0x4a,0x41,0x58,0x43,0x6f,0x6d,0x6d,0x61,0x6e,0x64,0x28,0x27, /* newAJAXCommand(' */ \
	0x2f,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x72,0x65,0x62,0x6f,0x6f,0x74,0x2e, /* /protect/reboot. */ \
	0x63,0x67,0x69,0x27,0x2c,0x72,0x65,0x62,0x6f,0x6f,0x74,0x44,0x75,0x6d,0x6d,0x79, /* cgi',rebootDummy */ \
	0x2c,0x66,0x61,0x6c,0x73,0x65,0x29,0x3b,0x22,0x2c,0x35,0x30,0x30,0x29,0x3b,0x0d, /* ,false);",500);. */ \
	0x0a,0x2f,0x2f,0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70,0x74, /* .//-->..</script */ \
	0x3e,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69  /* >..~inc:footer.i */
#define DATACHUNK000011 \
	0x6e,0x63,0x7e,0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0x0c,0x01,0x00,0x00,0x2e, /* nc~....3........ */ \
	0x00,0x00,0x00,0x22,0x01,0x00,0x00,0x2e,0x00,0x00,0x00,0xf6,0x01,0x00,0x00,0x02, /* ..."............ */ \
	0x00,0x00,0x00,0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69, /* ...~inc:header.i */ \
	0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x63,0x6f, /* nc~..<div id="co */ \
	0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x53, /* ntent">....<h1>S */ \
	0x4e,0x4d,0x50,0x20,0x43,0x6f,0x6d,0x6d,0x75,0x6e,0x69,0x74,0x79,0x20,0x43,0x6f, /* NMP Community Co */ \
	0x6e,0x66,0x69,0x67,0x75,0x72,0x61,0x74,0x69,0x6f,0x6e,0x3c,0x2f,0x68,0x31,0x3e, /* nfiguration</h1> */ \
	0x0d,0x0a,0x3c,0x70,0x3e,0x52,0x65,0x61,0x64,0x2f,0x57,0x72,0x69,0x74,0x65,0x20, /* ..<p>Read/Write  */ \
	0x43,0x6f,0x6d,0x6d,0x75,0x6e,0x69,0x74,0x79,0x20,0x53,0x74,0x72,0x69,0x6e,0x67, /* Community String */ \
	0x20,0x63,0x6f,0x6e,0x66,0x69,0x67,0x75,0x72,0x61,0x74,0x69,0x6f,0x6e,0x20,0x66, /*  configuration f */ \
	0x6f,0x72,0x20,0x53,0x4e,0x4d,0x50,0x76,0x32,0x63,0x20,0x41,0x67,0x65,0x6e,0x74, /* or SNMPv2c Agent */ \
	0x2e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x63,0x6c,0x61,0x73, /* .</p>..<div clas */ \
	0x73,0x3d,0x22,0x72,0x65,0x73,0x75,0x6c,0x74,0x20,0x66,0x61,0x69,0x6c,0x22,0x20, /* s="result fail"  */ \
	0x73,0x74,0x79,0x6c,0x65,0x3d,0x22,0x64,0x69,0x73,0x70,0x6c,0x61,0x79,0x3a,0x7e, /* style="display:~ */ \
	0x73,0x6e,0x6d,0x70,0x5f,0x65,0x6e,0x7e,0x22,0x3e,0x0d,0x0a,0x53,0x54,0x41,0x43, /* snmp_en~">..STAC */ \
	0x4b,0x5f,0x55,0x53,0x45,0x5f,0x53,0x4e,0x4d,0x50,0x5f,0x53,0x45,0x52,0x56,0x45, /* K_USE_SNMP_SERVE */ \
	0x52,0x20,0x69,0x73,0x20,0x75,0x6e,0x64,0x65,0x66,0x69,0x6e,0x65,0x64,0x2e,0x20, /* R is undefined.  */ \
	0x20,0x53,0x4e,0x4d,0x50,0x20,0x69,0x73,0x20,0x75,0x6e,0x61,0x76,0x61,0x69,0x6c, /*  SNMP is unavail */ \
	0x61,0x62,0x6c,0x65,0x2e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d, /* able...</div>... */ \
	0x0a,0x3c,0x70,0x3e,0x43,0x6f,0x6e,0x66,0x69,0x67,0x75,0x72,0x65,0x20,0x6d,0x75, /* .<p>Configure mu */ \
	0x6c,0x74,0x69,0x70,0x6c,0x65,0x20,0x63,0x6f,0x6d,0x6d,0x75,0x6e,0x69,0x74,0x79, /* ltiple community */ \
	0x20,0x6e,0x61,0x6d,0x65,0x73,0x20,0x69,0x66,0x20,0x79,0x6f,0x75,0x20,0x77,0x61, /*  names if you wa */ \
	0x6e,0x74,0x20,0x74,0x68,0x65,0x20,0x53,0x4e,0x4d,0x50,0x20,0x61,0x67,0x65,0x6e, /* nt the SNMP agen */ \
	0x74,0x20,0x0d,0x0a,0x74,0x6f,0x20,0x72,0x65,0x73,0x70,0x6f,0x6e,0x64,0x20,0x74, /* t ..to respond t */ \
	0x6f,0x20,0x74,0x68,0x65,0x20,0x4e,0x4d,0x53,0x2f,0x53,0x4e,0x4d,0x50,0x20,0x6d, /* o the NMS/SNMP m */ \
	0x61,0x6e,0x61,0x67,0x65,0x72,0x20,0x77,0x69,0x74,0x68,0x20,0x64,0x69,0x66,0x66, /* anager with diff */ \
	0x65,0x72,0x65,0x6e,0x74,0x20,0x72,0x65,0x61,0x64,0x20,0x61,0x6e,0x64,0x20,0x77, /* erent read and w */ \
	0x72,0x69,0x74,0x65,0x20,0x0d,0x0a,0x63,0x6f,0x6d,0x6d,0x75,0x6e,0x69,0x74,0x79, /* rite ..community */ \
	0x20,0x6e,0x61,0x6d,0x65,0x73,0x2e,0x20,0x49,0x66,0x20,0x6c,0x65,0x73,0x73,0x20, /*  names. If less  */ \
	0x74,0x68,0x61,0x6e,0x20,0x74,0x68,0x72,0x65,0x65,0x20,0x63,0x6f,0x6d,0x6d,0x75, /* than three commu */ \
	0x6e,0x69,0x74,0x69,0x65,0x73,0x20,0x61,0x72,0x65,0x20,0x6e,0x65,0x65,0x64,0x65, /* nities are neede */ \
	0x64,0x2c,0x20,0x6c,0x65,0x61,0x76,0x65,0x20,0x0d,0x0a,0x65,0x78,0x74,0x72,0x61, /* d, leave ..extra */ \
	0x20,0x66,0x69,0x65,0x6c,0x64,0x73,0x20,0x62,0x6c,0x61,0x6e,0x6b,0x20,0x74,0x6f, /*  fields blank to */ \
	0x20,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x20,0x74,0x68,0x65,0x6d,0x2e,0x3c,0x2f, /*  disable them.</ */ \
	0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x0d,0x0a,0x3c,0x66,0x6f,0x72,0x6d,0x20,0x6d,0x65, /* p>......<form me */ \
	0x74,0x68,0x6f,0x64,0x3d,0x22,0x70,0x6f,0x73,0x74,0x22,0x20,0x61,0x63,0x74,0x69, /* thod="post" acti */ \
	0x6f,0x6e,0x3d,0x22,0x2f,0x73,0x6e,0x6d,0x70,0x2f,0x73,0x6e,0x6d,0x70,0x63,0x6f, /* on="/snmp/snmpco */ \
	0x6e,0x66,0x69,0x67,0x2e,0x68,0x74,0x6d,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22, /* nfig.htm" name=" */ \
	0x63,0x6f,0x6e,0x66,0x69,0x67,0x22,0x3e,0x0d,0x0a,0x3c,0x66,0x69,0x65,0x6c,0x64, /* config">..<field */ \
	0x73,0x65,0x74,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61, /* set>....<div><la */ \
	0x62,0x65,0x6c,0x3e,0x52,0x65,0x61,0x64,0x20,0x43,0x6f,0x6d,0x6d,0x31,0x20,0x3a, /* bel>Read Comm1 : */ \
	0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74, /* </label>..<input */ \
	0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d, /*  type="text" nam */ \
	0x65,0x3d,0x22,0x72,0x63,0x6d,0x30,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22, /* e="rcm0" value=" */ \
	0x7e,0x72,0x65,0x61,0x64,0x5f,0x63,0x6f,0x6d,0x6d,0x28,0x30,0x29,0x7e,0x22,0x20, /* ~read_comm(0)~"  */ \
	0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c, /* /></div>..<div>< */ \
	0x6c,0x61,0x62,0x65,0x6c,0x3e,0x52,0x65,0x61,0x64,0x20,0x43,0x6f,0x6d,0x6d,0x32, /* label>Read Comm2 */ \
	0x20,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70, /*  :</label>..<inp */ \
	0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e, /* ut type="text" n */ \
	0x61,0x6d,0x65,0x3d,0x22,0x72,0x63,0x6d,0x31,0x22,0x20,0x76,0x61,0x6c,0x75,0x65, /* ame="rcm1" value */ \
	0x3d,0x22,0x7e,0x72,0x65,0x61,0x64,0x5f,0x63,0x6f,0x6d,0x6d,0x28,0x31,0x29,0x7e, /* ="~read_comm(1)~ */ \
	0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76, /* " /></div>..<div */ \
	0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x52,0x65,0x61,0x64,0x20,0x43,0x6f,0x6d, /* ><label>Read Com */ \
	0x6d,0x33,0x20,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69, /* m3 :</label>..<i */ \
	0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22, /* nput type="text" */ \
	0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x72,0x63,0x6d,0x32,0x22,0x20,0x76,0x61,0x6c, /*  name="rcm2" val */ \
	0x75,0x65,0x3d,0x22,0x7e,0x72,0x65,0x61,0x64,0x5f,0x63,0x6f,0x6d,0x6d,0x28,0x32, /* ue="~read_comm(2 */ \
	0x29,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a, /* )~" /></div>.... */ \
	0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x57,0x72, /* ..<div><label>Wr */ \
	0x69,0x74,0x65,0x20,0x43,0x6f,0x6d,0x6d,0x31,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65, /* ite Comm1:</labe */ \
	0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d, /* l>..<input type= */ \
	0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x77,0x63,0x6d, /* "text" name="wcm */ \
	0x30,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x77,0x72,0x69,0x74,0x65, /* 0" value="~write */ \
	0x5f,0x63,0x6f,0x6d,0x6d,0x28,0x30,0x29,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64  /* _comm(0)~" /></d */
#define DATACHUNK000012 \
	0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c, /* iv>..<div><label */ \
	0x3e,0x57,0x72,0x69,0x74,0x65,0x20,0x43,0x6f,0x6d,0x6d,0x32,0x3a,0x3c,0x2f,0x6c, /* >Write Comm2:</l */ \
	0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79, /* abel>..<input ty */ \
	0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22, /* pe="text" name=" */ \
	0x77,0x63,0x6d,0x31,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x77,0x72, /* wcm1" value="~wr */ \
	0x69,0x74,0x65,0x5f,0x63,0x6f,0x6d,0x6d,0x28,0x31,0x29,0x7e,0x22,0x20,0x2f,0x3e, /* ite_comm(1)~" /> */ \
	0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61, /* </div>..<div><la */ \
	0x62,0x65,0x6c,0x3e,0x57,0x72,0x69,0x74,0x65,0x20,0x43,0x6f,0x6d,0x6d,0x33,0x3a, /* bel>Write Comm3: */ \
	0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74, /* </label>..<input */ \
	0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d, /*  type="text" nam */ \
	0x65,0x3d,0x22,0x77,0x63,0x6d,0x32,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22, /* e="wcm2" value=" */ \
	0x7e,0x77,0x72,0x69,0x74,0x65,0x5f,0x63,0x6f,0x6d,0x6d,0x28,0x32,0x29,0x7e,0x22, /* ~write_comm(2)~" */ \
	0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x64,0x69, /*  /></div>....<di */ \
	0x76,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a, /* v>&nbsp;</div>.. */ \
	0x3c,0x64,0x69,0x76,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65, /* <div><input type */ \
	0x3d,0x22,0x73,0x75,0x62,0x6d,0x69,0x74,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d, /* ="submit" class= */ \
	0x22,0x73,0x6d,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x53,0x61,0x76,0x65, /* "sm" value="Save */ \
	0x20,0x43,0x6f,0x6e,0x66,0x69,0x67,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76, /*  Config" /></div */ \
	0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x2f,0x66,0x69,0x65,0x6c,0x64,0x73,0x65,0x74,0x3e, /* >....</fieldset> */ \
	0x0d,0x0a,0x3c,0x2f,0x66,0x6f,0x72,0x6d,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76, /* ..</form>..</div */ \
	0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70,0x74,0x3e,0x0d,0x0a, /* >....</script>.. */ \
	0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e, /* ~inc:footer.inc~ */ \
	0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0xbc,0x00,0x00,0x00,0x49,0x00,0x00,0x00, /* ....3.......I... */ \
	0x9d,0x02,0x00,0x00,0x42,0x00,0x00,0x00,0xff,0x02,0x00,0x00,0x43,0x00,0x00,0x00, /* ....B.......C... */ \
	0x61,0x03,0x00,0x00,0x44,0x00,0x00,0x00,0xc7,0x03,0x00,0x00,0x45,0x00,0x00,0x00, /* a...D.......E... */ \
	0x2a,0x04,0x00,0x00,0x46,0x00,0x00,0x00,0x8d,0x04,0x00,0x00,0x47,0x00,0x00,0x00, /* ....F.......G... */ \
	0x2d,0x05,0x00,0x00,0x02,0x00,0x00,0x00                                          /* -.......         */


/**************************************
 * MPFS2 C linkable symbols
 **************************************/
// For C18, these are split into seperate arrays because it speeds up compilation a lot.  
// For other compilers, the entire data array must be defined as a single variable to 
// ensure that the linker does not reorder the data chunks in Flash when compiler 
// optimizations are turned on.
#if defined(__18CXX)
	ROM BYTE MPFS_Start[] = {DATACHUNK000000};
	ROM BYTE MPFS_000001[] = {DATACHUNK000001};
	ROM BYTE MPFS_000002[] = {DATACHUNK000002};
	ROM BYTE MPFS_000003[] = {DATACHUNK000003};
	ROM BYTE MPFS_000004[] = {DATACHUNK000004};
	ROM BYTE MPFS_000005[] = {DATACHUNK000005};
	ROM BYTE MPFS_000006[] = {DATACHUNK000006};
	ROM BYTE MPFS_000007[] = {DATACHUNK000007};
	ROM BYTE MPFS_000008[] = {DATACHUNK000008};
	ROM BYTE MPFS_000009[] = {DATACHUNK000009};
	ROM BYTE MPFS_00000a[] = {DATACHUNK00000a};
	ROM BYTE MPFS_00000b[] = {DATACHUNK00000b};
	ROM BYTE MPFS_00000c[] = {DATACHUNK00000c};
	ROM BYTE MPFS_00000d[] = {DATACHUNK00000d};
	ROM BYTE MPFS_00000e[] = {DATACHUNK00000e};
	ROM BYTE MPFS_00000f[] = {DATACHUNK00000f};
	ROM BYTE MPFS_000010[] = {DATACHUNK000010};
	ROM BYTE MPFS_000011[] = {DATACHUNK000011};
	ROM BYTE MPFS_000012[] = {DATACHUNK000012};
#else
	ROM BYTE MPFS_Start[] = {DATACHUNK000000, DATACHUNK000001, DATACHUNK000002, DATACHUNK000003, DATACHUNK000004, DATACHUNK000005, DATACHUNK000006, DATACHUNK000007, DATACHUNK000008, DATACHUNK000009, DATACHUNK00000a, DATACHUNK00000b, DATACHUNK00000c, DATACHUNK00000d, DATACHUNK00000e, DATACHUNK00000f, DATACHUNK000010, DATACHUNK000011, DATACHUNK000012};
#endif


/**************************************************************
 * End of MPFS
 **************************************************************/
#endif // #if defined(STACK_USE_MPFS2)
#endif // #if !defined(MPFS_USE_EEPROM) && !defined(MPFS_USE_SPI_FLASH)
