// global menu state
var menuReady = false;

// pre-cache menubar image pairs
if (document.images) {
    var imagesNormal = new Array();
    imagesNormal["set"] = new Image(20, 60);
    imagesNormal["set"].src  = "./img/set_off.gif";
    imagesNormal["mode"] = new Image(20, 60);
    imagesNormal["mode"].src  = "./img/mode_off.gif";
    imagesNormal["catalog"] = new Image(20, 80);
    imagesNormal["catalog"].src  = "./img/catalog_off.gif";
	imagesNormal["filter"] = new Image(20, 80);
    imagesNormal["filter"].src  = "./img/filter_off.gif";
	imagesNormal["mag"] = new Image(20, 80);
    imagesNormal["mag"].src  = "./img/mag_off.gif";


    var imagesHilite = new Array();
    imagesHilite["set"] = new Image(20, 60);
    imagesHilite["set"].src  = "./img/set_on.gif";
    imagesHilite["mode"] = new Image(20, 60);
    imagesHilite["mode"].src  = "./img/mode_on.gif";
    imagesHilite["catalog"] = new Image(20, 80);
    imagesHilite["catalog"].src  = "./img/catalog_on.gif";
	imagesHilite["filter"] = new Image(20, 80);
    imagesHilite["filter"].src  = "./img/filter_on.gif";
	imagesHilite["mag"] = new Image(20, 80);
    imagesHilite["mag"].src  = "./img/mag_on.gif";

}

function getElementStyle(elem, IEStyleProp, CSSStyleProp) {
    if (elem.currentStyle) {
        return elem.currentStyle[IEStyleProp];
    } else if (window.getComputedStyle) {
        var compStyle = window.getComputedStyle(elem, "");
        return compStyle.getPropertyValue(CSSStyleProp);
    }
    return "";
}

// carry over some critical menu style sheet attribute values
var CSSRuleValues = {menuItemHeight:"18px",
                     menuItemLineHeight:"1.4em",
                     menuWrapperBorderWidth:"2px",
                     menuWrapperPadding:"3px",
                     defaultBodyFontSize:"12px"
                    };

// specifications for menu contents and menubar image associations
var menus = new Array();
menus[0] = {mBarImgId:"menuImg_0",
            mBarImgNormal:imagesNormal["set"],
            mBarImgHilite:imagesHilite["set"],
            menuItems:[ {text:"tile", href:"javascript:tile()"} ,
            {text:"WL/WW setting", href:"javascript:change_wlww_set()"} ,
            {text:"close", href:"javascript:window.close()"} ,
            {text:"big", href:"javascript:change('big')"} ,
            {text:"small", href:"javascript:change('small')"} ],

            elemId:""
           };


menus[1] = {mBarImgId:"menuImg_1",
            mBarImgNormal:imagesNormal["mode"],
            mBarImgHilite:imagesHilite["mode"],
            menuItems:[ {text:"zoom", href:"javascript:select_mod('big')"} ,
            {text:"WLWW change", href:"javascript:select_mod('initDrag')"} ,
			{text:"measure distance", href:"javascript:select_mod('measure_dist')"} ,
			{text:"evaluate CT value", href:"javascript:select_mod('evaluate_huv')"} ,
			{text:"sync change", href:"javascript:sync_change()"} ,
			{text:"none", href:"javascript:select_mod('no')"} , 
			{text:"check image", href:"javascript:checkout_wlww()"} ],

            elemId:""
           };


menus[2] = {mBarImgId:"menuImg_2",
            mBarImgNormal:imagesNormal["catalog"],
            mBarImgHilite:imagesHilite["catalog"],
            menuItems:[ {text:"head/brain", href:"javascript:loadD_script('apply_setting_with_param.js');apply_setting_with_param(power,negate_check,rotate_check,80,200)"} ,
            {text:"abd/soft tissue", href:"javascript:loadD_script('apply_setting_with_param.js');apply_setting_with_param(power,negate_check,rotate_check,40,300)"} ,
            {text:"adb/soft enhance", href:"javascript:loadD_script('apply_setting_with_param.js');apply_setting_with_param(power,negate_check,rotate_check,80,300)"} ,
            {text:"bone", href:"javascript:loadD_script('apply_setting_with_param.js');apply_setting_with_param(power,negate_check,rotate_check,500,1500)"} ,
            {text:"lung", href:"javascript:loadD_script('apply_setting_with_param.js');apply_setting_with_param(power,negate_check,rotate_check,-700,1500)"} 
//			,{text:"win9", href:"javascript:change_9()"}
//			,{text:"win1", href:"javascript:change_1()"}
			 ],


            elemId:""
           };

//loadD_script("apply_setting_with_param.js");"apply_setting_with_param('no','1','no','no','no')
//loadD_script("apply_setting_with_param.js");"apply_setting_with_param(change_power,change_negate_check,change_rotate_check,change_wl,change_ww)
//change_filter(power,1,rotate_check)

menus[3] = {mBarImgId:"menuImg_3",
            mBarImgNormal:imagesNormal["filter"],
            mBarImgHilite:imagesHilite["filter"],
            menuItems:[ {text:"negate", href:"javascript:loadD_script('apply_setting_with_param.js');apply_setting_with_param(power,1,rotate_check,'no','no')"} ,
			{text:"x2 smoothing", href:"javascript:loadD_script('apply_setting_with_param.js');apply_setting_with_param(2,negate_check,rotate_check,'no','no')"} ,
            {text:"x3 smoothing", href:"javascript:loadD_script('apply_setting_with_param.js');apply_setting_with_param(3,negate_check,rotate_check,'no','no')"} ,
			{text:"left", href:"javascript:loadD_script('apply_setting_with_param.js');apply_setting_with_param(power,negate_check,'Rl','no','no')"},
			{text:"right", href:"javascript:loadD_script('apply_setting_with_param.js');apply_setting_with_param(power,negate_check,'Rr','no','no')"},
			{text:"top-down", href:"javascript:loadD_script('apply_setting_with_param.js');apply_setting_with_param(power,negate_check,'Rtd','no','no')"},
			{text:"normal", href:"javascript:loadD_script('apply_setting_with_param.js');apply_setting_with_param(1,0,0,'no','no')"}  ],

            elemId:""
           };

menus[4] = {mBarImgId:"menuImg_4",
            mBarImgNormal:imagesNormal["mag"],
            mBarImgHilite:imagesHilite["mag"],
            menuItems:[ {text:"mag x2", href:"javascript:change_mag(2)"} ,
            {text:"mag x3", href:"javascript:change_mag(3)"} ,
			{text:"mag x4", href:"javascript:change_mag(4)"} ,
			{text:"sensitive", href:"javascript:change_move_ratio(3)"} ,
			{text:"moderate", href:"javascript:change_move_ratio(1)"} ,
			{text:"blunt", href:"javascript:change_move_ratio(0.3)"} ,],

            elemId:""
           };

// create hash table-like lookup for menu objects with id string indexes
function makeHashes() {
    for (var i = 0; i < menus.length; i++) {
        menus[menus[i].elemId] = menus[i];
        menus[menus[i].mBarImgId] = menus[i];
    }
}

// assign menu label image event handlers
function assignLabelEvents() {
    var elem;
    for (var i = 0; i < menus.length; i++) {
        elem = document.getElementById(menus[i].mBarImgId);
        elem.onmouseover = swap;
        elem.onmouseout = swap;
    }
}

// invoked from init(), generates the menu div elements and their contents.
// all this action is invisible to user during construction
function makeMenus() {
    var menuDiv, menuItem, itemLink, mbarImg, textNode, offsetLeft, offsetTop;
    
    // determine key adjustment factors for the total height of menu divs
    
    var menuItemH = 0;
    var bodyFontSize = parseInt(getElementStyle(document.body, "fontSize", "font-size"));
    // test to see if browser's font size has been adjusted by the user
    // and that the new size registers as an applied style property
    if (bodyFontSize == parseInt(CSSRuleValues.defaultBodyFontSize)) {
        menuItemH = (parseFloat(CSSRuleValues.menuItemHeight));
    } else {
        // works nicely in Netscape 7
        menuItemH = parseInt(parseFloat(CSSRuleValues.menuItemLineHeight) * bodyFontSize);
    }
    var heightAdjust = parseInt(CSSRuleValues.menuWrapperPadding) + 
        parseInt(CSSRuleValues.menuWrapperBorderWidth);
    if (navigator.appName == "Microsoft Internet Explorer" && 
        navigator.userAgent.indexOf("Win") != -1 && 
        (typeof document.compatMode == "undefined" || 
        document.compatMode == "BackCompat")) {
        heightAdjust = -heightAdjust;
    }
    
    // use menus array to drive div creation loop
    for (var i = 0; i < menus.length; i++) {
        menuDiv = document.createElement("div");
        menuDiv.id = "popupmenu" + i;
        // preserve menu's ID as property of the menus array item
        menus[i].elemId = "popupmenu" + i;
        menuDiv.className = "menuWrapper";
        if (menus[i].menuItems.length > 0) {
            menuDiv.style.height = (menuItemH * menus[i].menuItems.length) - 
            heightAdjust + "px";
        } else {
            // don't display any menu div lacking menu items
            menuDiv.style.display = "none";
        }
        // define event handlers
        menuDiv.onmouseover = keepMenu;
        menuDiv.onmouseout = requestHide;

        // set stacking order in case other layers are around the page
        menuDiv.style.zIndex = 1000;
        
        // assemble menu item elements for inside menu div
        for (var j = 0; j < menus[i].menuItems.length; j++) {
            menuItem = document.createElement("div");
            menuItem.id = "popupmenuItem_" + i + "_" + j;
            menuItem.className = "menuItem";
            menuItem.onmouseover = toggleHighlight;
            menuItem.onmouseout = toggleHighlight;
            menuItem.onclick = hideMenus;
            menuItem.style.top = menuItemH * j + "px";
            itemLink = document.createElement("a");
            itemLink.href = menus[i].menuItems[j].href;
            itemLink.className = "menuItem";
            itemLink.onmouseover = toggleHighlight;
            itemLink.onmouseout = toggleHighlight;
            textNode = document.createTextNode(menus[i].menuItems[j].text);
            itemLink.appendChild(textNode);
            menuItem.appendChild(itemLink);
            menuDiv.appendChild(menuItem);
        }
        // append each menu div to the body
        document.body.appendChild(menuDiv);
    }
    makeHashes();
    assignLabelEvents();
    // pre-position menu
    for (i = 0; i < menus.length; i++) {
        positionMenu(menus[i].elemId);
    }
    menuReady = true;
}

// initialize global that helps manage menu hiding
var timer;

// invoked from mouseovers inside menus to cancel hide
// request from mouseout of menu bar image et al.
function keepMenu() {
    clearTimeout(timer);
}

function cancelAll() {
    keepMenu();
    menuReady = false;
}

// invoked from mouseouts to request hiding all menus
// in 1/4 second, unless cancelled
function requestHide() {
    timer = setTimeout("hideMenus()", 250);
}

// "brute force" hiding of all menus and restoration
// of normal menu bar images
function hideMenus() {
    for (var i = 0; i < menus.length; i++) {
       document.getElementById(menus[i].mBarImgId).src = menus[i].mBarImgNormal.src;
       var menu = document.getElementById(menus[i].elemId)
       menu.style.visibility = "hidden";
    }
}

// set menu position just before displaying it
function positionMenu(menuId){
    // use the menu bar image for position reference of related div
    var mBarImg = document.getElementById(menus[menuId].mBarImgId);
    var offsetTrail = mBarImg;
    var offsetLeft = 0;
    var offsetTop = 0;
    while (offsetTrail) {
        offsetLeft += offsetTrail.offsetLeft;
        offsetTop += offsetTrail.offsetTop;
        offsetTrail = offsetTrail.offsetParent;
    }
    if (navigator.userAgent.indexOf("Mac") != -1 && 
        typeof document.body.leftMargin != "undefined") {
        offsetLeft += document.body.leftMargin;
        offsetTop += document.body.topMargin;
    }
    var menuDiv = document.getElementById(menuId);
    menuDiv.style.left = offsetLeft + "px";
    menuDiv.style.top = offsetTop + mBarImg.height + "px";
}

// display a particular menu div
function showMenu(menuId) {
    if (menuReady) {
        keepMenu();
        hideMenus();
        positionMenu(menuId);
        var menu = document.getElementById(menuId);
        menu.style.visibility = "visible";
    }
}

// menu bar image swapping, invoked from mouse events in menu bar
// swap style sheets for menu items during rollovers
function toggleHighlight(evt) {
    evt = (evt) ? evt : ((event) ? event : null);
    if (typeof menuReady != "undefined") {
        if (menuReady && evt) {
            var elem = (evt.target) ? evt.target : evt.srcElement;
            if (elem.nodeType == 3) {
                elem = elem.parentNode;
            }
            if (evt.type == "mouseover") {
                keepMenu();
                elem.className ="menuItemOn";
            } else {
                elem.className ="menuItem";
                requestHide();
            }
            evt.cancelBubble = true;
        }
    }
}

function swap(evt) {
    evt = (evt) ? evt : ((event) ? event : null);
    if (typeof menuReady != "undefined") {
        if (evt && (document.getElementById && document.styleSheets) && menuReady) {
            var elem = (evt.target) ? evt.target : evt.srcElement;
            if (elem.className == "menuImg") {
                if (evt.type == "mouseover") {
                    showMenu(menus[elem.id].elemId);
                    elem.src = menus[elem.id].mBarImgHilite.src;
                } else if (evt.type == "mouseout") {
                    requestHide();
                }
                evt.cancelBubble = true;
            }
        }
    }
}

// create menus only if key items are supported
function initMenus() {
    if (document.getElementById && document.styleSheets) {
        setTimeout("makeMenus()", 5);
        window.onunload=cancelAll;
    }
}
