/*
file	convert-y.c
version	0.3
author	NORIYA Yokohama
date	2007.01.12
brief	Image scaling, invert, Sharpen filter
*/


#include <cv.h>
#include <highgui.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>


int main(int argc, char *argv[])
{
	if (argc<7){
		fprintf(stderr, "usage: %s -s pace-of-expansion -n(or -i) -n(or -f) src-file dst-file\n", argv[0]);
		return -1;
	}
	
	int step, channels;
	int i, j, k;
	uchar *data;
	CvMat* kernel=0;

	IplImage *src  = cvLoadImage(argv[5],-1);
	const double scale = atof(argv[2]);

	CvSize size = cvSize( (int)(src->width*scale), (int)(src->height*scale));
	channels = src->nChannels;
	IplImage *dst = cvCreateImage(size, IPL_DEPTH_8U, channels);
	
	cvResize(src, dst, CV_INTER_CUBIC);
//	cvResize(src, dst, CV_INTER_LINEAR);

	//check flag arguments
        if(strcmp(argv[3],"-n") || strcmp(argv[4],"-n")){
        	printf("invalid arguments\n");
	        return -1;
        }

	//check invert flag
	if(!strcmp(argv[3],"-i")){
		printf("invert\n");
  		step = dst->widthStep;
		data = (uchar *)dst->imageData;
		
		for(i=0; i < dst->height; i++) 
			for(j=0; j < dst->width; j++) 
				for(k=0; k < channels;k++)
    					data[i*step+j*channels+k]=255-data[i*step+j*channels+k];
		 
	}

	//check sharpen filter check
	if(!strcmp(argv[4],"-f")){
		printf("filtering\n");
		IplImage *tmp = cvCloneImage(dst);
		kernel = cvCreateMat(9,9,CV_32FC1);
		
		cvSet2D( kernel, 0, 0, cvRealScalar(0) );
		cvSet2D( kernel, 0, 1, cvRealScalar(-1) );
		cvSet2D( kernel, 0, 2, cvRealScalar(0) );
		cvSet2D( kernel, 1, 0, cvRealScalar(-1) );
		cvSet2D( kernel, 1, 1, cvRealScalar(5) );
		cvSet2D( kernel, 1, 2, cvRealScalar(-1) );
		cvSet2D( kernel, 2, 0, cvRealScalar(0) );
		cvSet2D( kernel, 2, 1, cvRealScalar(-1) );
		cvSet2D( kernel, 2, 2, cvRealScalar(0) );
		
		cvFilter2D( tmp, dst, kernel, cvPoint(-1,-1) );

	}

	cvSaveImage(argv[6], dst);
	
	cvReleaseImage(&src);
	cvReleaseImage(&dst); 

	return 0;
}
