
X.Dom.Image = {
	_actualSize : {},
	
/*
 * original
 * LICENSE: MIT
 * AUTHOR: uupaa.js@gmail.com
 */	
	getActualDimension : function( XnodeOrImageElemOrSrc ){
		var xnode, img, remove, ret, run, memW, memH, w, h;
	
		if( X.Type.isString( XnodeOrImageElemOrSrc ) ){
			if( ret = X.Dom.Image._actualSize[ X.Dom.getAbsolutePath( XnodeOrImageElemOrSrc ) ] ) return ret;
			
			xnode = X.Dom.Node._systemNode.create(
				'img',
				{
					src : XnodeOrImageElemOrSrc
				},
				{
					position   : 'absolute'
				}
			);
			Node.root._startUpdate();
			img    = xnode._ie4getRawNode ? xnode._ie4getRawNode() : xnode._rawNode;
			remove = true;
		} else {
			if( XnodeOrImageElemOrSrc.constructor === X.Dom.Node ){
				xnode = XnodeOrImageElemOrSrc;
				img   = xnode._ie4getRawNode ? xnode._ie4getRawNode() : xnode._rawNode;
			} else
			if( X.Type.isHTMLElement( XnodeOrImageElemOrSrc ) ){
				img = XnodeOrImageElemOrSrc;
			} else {
				return;
			};
			if( ret = X.Dom.Image._actualSize[ img.src ] ) return ret;
		};

		// for Firefox, Safari, Google Chrome
		if( img.naturalWidth ) return [ img.naturalWidth, img.naturalHeight ];
	
		if( X.UA.IE && 5 <= X.UA.IE ){// for IE
			run  = img.runtimeStyle;
			memW = run.width;
			memH = run.height;
	
			// keep runtimeStyle
			run.width  = 'auto';
			// override
			run.height = 'auto';
			w = img.width;
			h = img.height;
			run.width  = memW;
			// restore
			run.height = memH;
		} else {// for Opera and Other
			
			memW = w = img.width;
			memH = h = img.height;
			
			if( img.removeAttribute ){ // Safari1.3 の Image は removeAttribute がない
				// keep current style
				img.removeAttribute( 'width' );
				img.removeAttribute( 'height' );
				
				w = img.width;
				h = img.height;
				
				// restore
				img.width  = memW;
				img.height = memH;
			};
		};
		
		ret = X.Dom.Image._actualSize[ img.src ] = [ w, h ];
		
		remove && xnode.destroy();
		
		return ret;
	},
	
	/* 
	 * original
	 *  LICENSE: MIT?
	 *  URL: http://d.hatena.ne.jp/uupaa/20080413/1208067631
	 *  AUTHOR: uupaa.js@gmail.com
	 * 
	 */
	Loader : X.EventDispatcher.inherits(
		'ImageLoader',
		X.Class.POOL_OBJECT,
		{
			xnode   : null,
			size    : null,
			tick    : 0,
			timerID : 0,
			finish  : false,
			abspath : null,
			delay   : null,
			timeout : 0,
			Constructor : function( abspath, delay, timeout ){
				var img, s, p;
				
				this.abspath = abspath;
				this.delay   = delay || 100;
				this.timeout = timeout || 10000;
				this.xnode =
					(
						window[ 'Image' ] ?
							X.Dom.Node( img = new Image() ) :
							X.Dom.Node._systemNode.create( 'img', { src : abspath } )
					)
					.listen( 'load', this )
					.listen( 'error', this )
					.listen( 'abort', this )
					.listen( X.Dom.Event.LOAD_ASSET_COMPLETE, this )
					.listen( X.Dom.Event.LOAD_ASSET_ERROR, this );
				img && ( img.src = abspath );
				this._detect();
			},
			handleEvent : function( e ){
				var size;
				switch( e.type ){
					case 'error' :
					case 'abort' :
						if( this.finish ) return;
						this.finish = true;
						this.timerID = this.asyncDispatch( 0, { type : X.Dom.Event.LOAD_ASSET_ERROR } );
						break;
					case 'load' :
					// if( finish === true ) return; // これがあると firefox3.6 で駄目、、、
					// if( timer ) return; // これがあると safari3.2 で駄目、、、
						this.finish = true;
						this.timerID && X.Timer.remove( this.timerID );
						if( window.opera && !this.xnode._rawNode.complete ){
							this.timerID = this.asyncDispatch( 0, { type : X.Dom.Event.LOAD_ASSET_ERROR } );
							return;
						};
						size = X.Dom.Image.getActualDimension( X.UA.IE && X.UA.IE < 9 && window.Image ? this.abspath : this.xnode );
						this.timerID = this.asyncDispatch( 0, {
							type : X.Dom.Event.LOAD_ASSET_COMPLETE,
							src  : this.abspath,
							w    : size[ 0 ],
							h    : size[ 1 ]
						} );
						break;
					case X.Dom.Event.LOAD_ASSET_COMPLETE :
					case X.Dom.Event.LOAD_ASSET_ERROR :
						delete this.timerID;
						X.Timer.once( 0, this, this.kill );
						break;
				};
			},	
			_detect : function(){
				if( this.finish === true ) return;
				if( this.xnode._rawNode && this.xnode._rawNode.complete ){
					this.finish = true;
					if( this.xnode._rawNode.width ) return;
					this.timerID = this.asyncDispatch( 0, { type : X.Dom.Event.LOAD_ASSET_ERROR } );
					return;
				};
				if( ( this.tick += this.delay ) > this.timeout ){
					this.finish = true;
					this.timerID = this.asyncDispatch( 0, { type : X.Dom.Event.LOAD_ASSET_ERROR, msg : 'timeout' } );
					return;
				};
				this.timerID = X.Timer.once( this.delay, this, this._detect );
			},
			stop : function(){
				// if( this.dispatch( { type : X.Dom.Event.LOAD_BEFORE_STOP } ) & X.Callback.CANCEL_NOW ) return;
				
				// this.dispacth( { type : X.Dom.Event.LOAD_ASSET_STOPED } );
				this.kill();
			},
			onKill : function(){
				this.timerID && X.Timer.remove( this.timerID );
				this.xnode.destroy();
				this.unlisten();
			}
		}
	)
};
