X.Dom.Attr = {
	toName  : [],
	toIndex : {
		id           : 0,
		className    : 1,
		'class'      : 1, //
		name         : 2,
		title        : 3,
		accessKey    : 4,
		accesskey    : 4, //
		tabIndex     : 5,
		tabindex     : 5, //
		dir          : 6,
		lang         : 7,
		'xml:lang'   : 8,
		'xml:space'  : 9,
		abbr         : 10,
		accept       : 11,
		acceptCharset : 12,
		'accept-charset' : 12,
		action       : 13,
		align        : 14,
		alink        : 15,
		alt          : 16,
		archive      : 17,
		axis         : 18,
		background   : 19,
		bgColor      : 20,
		bgcolor      : 20, //
		border       : 21,
		cellPadding  : 22,
		cellpadding  : 22, //
		cellSpacing  : 23,
		cellspacing  : 23, //
		ch           : 24,
		'char'       : 24, //
		chOff        : 25,
		charoff      : 25, //
		charset      : 26,
		checked      : 27,
		cite         : 28,
		classid      : 29,
		clear        : 30,
		code         : 31,
		codeBase     : 32,
		codebase     : 32, //
		codeType     : 33,
		codetype     : 33, //
		color        : 34,
		cols         : 35,
		colspan      : 36,
		colSpan      : 36,
		compact      : 37,
		content      : 38,
		coords       : 39,
		data         : 40,
		dateTime     : 41,
		datetime     : 41, //
		declare      : 42,
		defer        : 43,
		disabled     : 44,
		enctype      : 45,
		face         : 46,
		htmlFor      : 47,
		'for'        : 47, //
		frame        : 48,
		frameBorder  : 49,
		frameborder  : 49, //
		headers      : 50,
		height       : 51,
		href         : 52,
		hreflang     : 53,
		hspace       : 54,
		httpEquiv    : 55,
		'http-equiv' : 55, //
		ismap        : 56,
		isMap        : 56,
		label        : 57,
		language     : 58,
		longDesc     : 59,
		longdesc     : 59, //
		marginheight : 60,
		marginwidth  : 61,
		maxLength    : 62,
		maxlength    : 62, //
		media        : 63,
		method       : 64,
		multiple     : 65,
		noHref       : 66,
		nohref       : 66,
		noresize     : 67,
		noshade      : 68,
		nowrap       : 69,
		object       : 71,
		profile      : 72,
		prompt       : 73,
		readOnly     : 74,
		readonly     : 74,
		rel          : 75,
		rev          : 76,
		rows         : 77,
		rowspan      : 78,
		rowSpan      : 78,
		rules        : 79,
		scheme       : 80,
		scope        : 81,
		scrolling    : 82,
		selected     : 83,
		shape        : 84,
		size         : 85,
		span         : 86,
		src          : 87,
		standby      : 88,
		start        : 89,
		summary      : 90,
		target       : 91,
		text         : 92,
		type         : 93,
		useMap       : 94,
		usemap       : 94,
		valign       : 95,
		value        : 96,
		valueType    : 97,
		valuetype    : 97,
		version      : 98,
		vlink        : 99,
		vspace       : 100,
		width        : 101,
		wrap         : 102,
		xmlns        : 103
	},
	noValue : {
		checked  : 1,
		compact  : 1,
		declare  : 1,
		defer    : 1,
		disabled : 1,
		ismap    : 1,
		multiple : 1,
		nohref   : 1,
		noresize : 1,
		noshade  : 1,
		nowrap   : 1,
		readonly : 1,
		selected : 1
	},
	renameForDOM : {
		'class'          : 'className',
		accesskey        : 'accessKey',
		'accept-charset' : 'acceptCharset',
		bgcolor          : 'bgColor',
		cellpadding      : 'cellPadding',
		cellspacing      : 'cellSpacing',
		'char'           : 'ch',
		charoff          : 'chOff',
		codebase         : 'codeBase',
		codetype         : 'codeType',
		colspan          : 'colSpan',
		datetime         : 'dateTime',
		'for'            : 'htmlFor',
		frameborder      : 'frameBorder',
		'http-equiv'     : 'httpEquiv',
		ismap            : 'isMap',
		longdesc         : 'longDesc',
		maxlength        : 'maxLength',
		nohref           : 'noHref',
		readonly         : 'readOnly',
		rowspan          : 'rowSpan',
		tabindex         : 'tabIndex',
		usemap           : 'useMap',
		valuetype        : 'valueType',
		checked          : 'defaultChecked'
	},
	
	HAS_VALUE : {
		INPUT    : true,
		TEXTAREA : true,
		SELECT   : true
	},
	
	renameForTag : {},
	// http://nanto.asablo.jp/blog/2005/10/29/123294
	// checked -> defaultChecked
	// 動的に生成した input 要素を文書ツリーに挿入する前に設定した checked 属性は反映されず、defaultChecked だと反映される
	// 先頭にスペース
	objToAttrText : function( obj ){
		var noValue = X.Dom.Attr.noValue,
			attrs = [ '' ], n = 0, p, v;
		for( p in obj ){
			v = obj[ p ];
			if( p === 'value' ){
				v = v.split( '"' ).join( '&quot;' ).split( '>' ).join( '&gt;' ).split( '<' ).join( '&lt;' );
			};
			attrs[ ++n ] = noValue[ p ] ? p : [ p, '="', v, '"' ].join( '' );
		};
		return 0 < n ? attrs.join( ' ' ) : '';
	}
};

(function( toIndex, toName, renameForDOM, renameForTag ){
	var name, i;
	for( name in toIndex ){
		if( typeof ( i = toIndex[ name ] ) === 'number' ){
			toName[ i ] = name;
		};
	};
	for( name in renameForDOM ){
		renameForTag[ renameForDOM[ name ] ] = name;
	};
})( X.Dom.Attr.toIndex, X.Dom.Attr.toName, X.Dom.Attr.renameForDOM, X.Dom.Attr.renameForTag );



/* --------------------------------------
 *  attribute
 *  X.Dom.Attr.toIndex に定義されている 属性の場合
 * 
 * http://nanto.asablo.jp/blog/2005/10/29/123294
 * className, onclick等 はここで設定しない
 * 
 */
X.Dom.Node.prototype.attr = function( nameOrObj /* v */ ){
	var attrs = this._attrs, newAttrs, f, p;
	
	if( this._xnodeType !== 1 ) return this;
	
	if( nameOrObj && X.Type.isObject( nameOrObj ) ){
		attrs || ( attrs = this._attrs = {} );
		newAttrs = this._newAttrs || ( this._newAttrs = {} );
		
		for( p in nameOrObj ){
			if( this._setAttr( attrs, newAttrs, p, nameOrObj[ p ] ) === true ) f = true;
		};
		if( f ){
			delete this._attrText;
			this._dirty |= X.Dom.Dirty.ATTR;
			this._root && this._reserveUpdate();			
		};
		return this;
	} else
	if( 1 < arguments.length ){
		// setter
		if( this._setAttr( attrs || ( this._attrs = {} ), this._newAttrs || ( this._newAttrs = {} ), nameOrObj, arguments[ 1 ] ) === true ){
			delete this._attrText;
			this._dirty |= X.Dom.Dirty.ATTR;
			this._root && this._reserveUpdate();
		};
		return this;
	} else
	if( nameOrObj === 'value' && X.Dom.Attr.HAS_VALUE[ this._tag.toUpperCase() ] ){
		if( this._newAttrs && this._newAttrs.value ) return this._newAttrs.value;
		if( elm = X.Dom.DOM_IE4 ? this._rawNode || this._ie4getRawNode() : this._rawNode ){
			attrs.value = elm.value;
		};
		return attrs.value;
	} else
	if( typeof nameOrObj === 'string' && attrs ){
		// getter
		return attrs[ nameOrObj ];
	};
};
X.Dom.Node.prototype._setAttr = function( attrs, newAttrs, name, v ){
	if( name === 'UID' ) return;
	if( name === 'id' ){
		v = ( v !== 'ie4uid' + this._uid ) ? v : undefined;
		if( v !== this._id ){
			this._id = v;
			this._dirty |= X.Dom.Dirty.ID;
			this._root && this._reserveUpdate();
		};
		return;
	};	
	if( name === 'class' ) return this.className( v );	
	if( name === 'style' ) return this.cssText( v );
	
	if( name.indexOf( 'on' ) === 0 ){
		X.Notification.warn( 'xnode.attr("' + name + '") is wrong, xnode.listen() & xnode.unlisten().' );
		return;
	};
	
	name = X.Dom.Attr.renameForTag[ name ] || name;
	if( attrs[ name ] === v ) return;
	
	if( v == null ){
		newAttrs[ name ] = undefined;
		if( attrs.hasOwnProperty( name ) ) delete attrs[ name ];
	} else {
		newAttrs[ name ] = attrs[ name ] = v;
	};
	return true;
};

