﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Net;
using System.Text;
using Progressive.PecaStarter.Common;
using Progressive.PecaStarter.DTO;

namespace Progressive.PecaStarter.Model.Peercast
{
    class Peercast
    {
        public string serverAddress { get; set; }

        public Peercast(string serverAddress)
        {
            this.serverAddress = serverAddress;
        }

        public void Broadcast(BroadcastDTO dto)
        {
            RequestToPeercast(string.Format(
                PeercastDefine.BROADCAST_GETMETHOD,
                Uri.EscapeDataString(dto.Url),
                Uri.EscapeDataString(dto.Name),
                Uri.EscapeDataString(dto.Genre),
                Uri.EscapeDataString(dto.Description),
                Uri.EscapeDataString(dto.Type.ToString())));
        }

        public void Update(UpdateDTO dto)
        {
            RequestToPeercast(string.Format(
                PeercastDefine.UPDATE_GETMETHOD,
                Uri.EscapeDataString(dto.Name),
                Uri.EscapeDataString(dto.Genre),
                Uri.EscapeDataString(dto.Description),
                Uri.EscapeDataString(dto.Url),
                Uri.EscapeDataString(dto.Comment),
                Uri.EscapeDataString(dto.TrackArtist),
                Uri.EscapeDataString(dto.TrackTitle),
                Uri.EscapeDataString(dto.TrackAlbum),
                Uri.EscapeDataString(dto.TrackGenre),
                Uri.EscapeDataString(dto.TrackContact)));
        }

        public void DisableKeep(string id)
        {
            RequestToPeercast(string.Format(PeercastDefine.KEEP_GETMETHOD, id));
        }

        public void Stop(string id)
        {
            RequestToPeercast(string.Format(PeercastDefine.STOP_GETMETHOD, id));
        }

        public void SaveSettings(List<KeyValuePair<string, string>> list)
        {
            var sb = new StringBuilder(PeercastDefine.ADMIN_URL);
            foreach (var setting in list)
            {
                sb.Append(setting.Key).Append('=').Append(setting.Value).Append('&');
            }
            RequestToPeercast(sb.ToString());
        }

        public XmlStatus XmlStatus
        {
            get
            {
                return new XmlStatus(new StreamReader(RequestToPeercast(PeercastDefine.VIEW_XML_URL).GetResponseStream()).ReadToEnd());
            }
        }

        public SettingsHtml SettingsHtml
        {
            get
            {
                return new SettingsHtml(new StreamReader(RequestToPeercast(PeercastDefine.SETTINGS_URL).GetResponseStream()).ReadToEnd());
            }
        }

        private HttpWebResponse RequestToPeercast(string url)
        {
            var webRequest = HttpWebRequest.Create("http://" + serverAddress + url);
            webRequest.Method = "GET";
            webRequest.Timeout = PeercastDefine.TIMEOUT;
            var response = webRequest.GetResponse() as HttpWebResponse;
            if (response.StatusCode != HttpStatusCode.OK)
            {
                throw new WebException(MessageDefine.CONNECT_TO_PEERCAST_FAILED);
            }
            return response;
        }
    }
}
