﻿using Progressive.PecaStarter.Common;

namespace Progressive.PecaStarter.Entity
{
    public class Channel
    {
        public string Name { get; set; }
        public string Id { get; set; }
        public Type Type { get; set; }
        public string Genre { get; set; }
        public string Desc { get; set; }
        public string Url { get; set; }
        public string Comment { get; set; }
        public Relay Relay { get; set; }
        public Track Track { get; set; }

        public Channel()
        {
            Name = "";
            Id = "";
            Type = Type.WMV;
            Genre = "";
            Desc = "";
            Url = "";
            Comment = "";
            Relay = new Relay();
            Track = new Track();
        }
    }

    public class Track
    {
        public string Title { get; set; }
        public string Artist { get; set; }
        public string Album { get; set; }
        public string Genre { get; set; }
        public string Contact { get; set; }

        public Track()
        {
            Title = "";
            Artist = "";
            Album = "";
            Genre = "";
            Contact = "";
        }
    }

    public class Relay
    {
        public Status Status { get; set; }

        public Relay()
        {
            Status = Status.ERROR;
        }
    }
}
