﻿using System;
using System.Collections.Generic;

namespace Progressive.PecaStarter.ViewModel
{

    public class HistoriableTextViewModel : ViewModelBase
    {
        private const int MAX_HISTORY = 50;
        private Action OnPropertyChanged;

        public string Text
        {
            get
            {
                if (List.Count == 0)
                {
                    return "";
                }
                return List[0];
            }
            set
            {
                var list = new List<string>(MAX_HISTORY);
                list.Add(value);
                foreach (var item in List)
                {
                    if (list.Count >= MAX_HISTORY)
                    {
                        break;
                    }
                    if (value == item)
                    {
                        continue;
                    }
                    list.Add(item);
                }
                List = list;
                NotifyPropertyChanged("Text");
                NotifyPropertyChanged("History");
                OnPropertyChanged();
            }
        }
        public List<string> History
        {
            get { return List; }
            set
            {
                List = value;
                NotifyPropertyChanged("History");
                OnPropertyChanged();
            }
        }
        private List<string> List;

        public HistoriableTextViewModel(Action onPropertyChanged)
        {
            List = new List<string>();
            OnPropertyChanged = onPropertyChanged;
        }

        public void RemoveText()
        {
            var list = new List<string>(List.Count - 1);
            for (int i = 1, len = List.Count; i < len; i++)
            {
                list.Add(List[i]);
            }
            List = list;
            NotifyPropertyChanged("History");
            NotifyPropertyChanged("Text");
        }
    }
}
