﻿using System;
using System.ComponentModel;

namespace Progressive.PecaStarter.ViewModel.Command
{
    public abstract class AsyncCommandBase : CommandBase
    {
        private BackgroundWorker Worker;
        public event EventHandler Completed;

        public AsyncCommandBase(BroadcastViewModel viewModel)
            : base(viewModel)
        {
            Worker = new BackgroundWorker();
            Worker.DoWork += ((sender, ev) =>
            {
                try
                {
                    ViewModel.Alert = "";
                    ev.Result = AsyncExecute(ev.Argument);
                }
                catch (ApplicationException e)
                {
                    ViewModel.Alert = e.Message;
                    throw e;
                }
                catch (Exception e)
                {
                    ViewModel.Alert = "致命的なエラー:" + e.Message;
                    throw e;
                }
            });
            Worker.RunWorkerCompleted += (s, ev) =>
            {
                try
                {
                    if (ev.Error == null) AsyncCompleted(ev.Result);
                    if (Completed != null) Completed(s, ev);
                }
                catch (ApplicationException e)
                {
                    ViewModel.Alert = e.Message;
                }
                catch (Exception e)
                {
                    ViewModel.Alert = "処理終了時の致命的なエラー:" + e.Message;
                }
                ViewModel.Feedback = "完了";
            };
        }

        protected override sealed void OnExecute(object parameter)
        {
            ViewModel.Feedback = "処理中";
            Worker.RunWorkerAsync(parameter);
        }

        protected abstract object AsyncExecute(object parameter);
        protected virtual void AsyncCompleted(object result) { }
    }
}
