﻿using System.Collections.Generic;

namespace Progressive.PecaStarter.ViewModel.Broadcast
{
    public class CurrentTrackViewModel : ViewModelBase
    {
        public BroadcastViewModel Parent { get; set; }
        public HistoriableTextViewModel Artist { get; set; }
        public HistoriableTextViewModel Title { get; set; }
        public HistoriableTextViewModel Album { get; set; }
        public HistoriableTextViewModel Genre { get; set; }
        public HistoriableTextViewModel Contact { get; set; }

        public CurrentTrackViewModel(BroadcastViewModel parent)
        {
            Parent = parent;
            Artist = new HistoriableTextViewModel(() => NotifyPropertyChanged("Artist"));
            Title = new HistoriableTextViewModel(() => NotifyPropertyChanged("Title"));
            Album = new HistoriableTextViewModel(() => NotifyPropertyChanged("Album"));
            Genre = new HistoriableTextViewModel(() => NotifyPropertyChanged("Genre"));
            Contact = new HistoriableTextViewModel(() => NotifyPropertyChanged("Contact"));
        }
    }
}
