﻿using System.Configuration;
using System.IO;
using Progressive.PecaStarter.Entity;
using Progressive.PecaStarter.Properties;

namespace Progressive.PecaStarter.DAO
{
    public class SaveDataDAOApplicationSettingsImpl : SaveDataDAO
    {
        public void Update(SaveData saveData)
        {
            try
            {
                Settings.Default.SaveData = saveData;
                Settings.Default.Save();
            }
            catch (ConfigurationErrorsException)
            {
                File.Delete(ConfigurationManager.OpenExeConfiguration(ConfigurationUserLevel.PerUserRoamingAndLocal).FilePath);
                try
                {
                    Settings.Default.SaveData = saveData;
                    Settings.Default.Save();
                }
                catch (ConfigurationErrorsException)
                {
                    File.Delete(ConfigurationManager.OpenExeConfiguration(ConfigurationUserLevel.PerUserRoamingAndLocal).FilePath);
                }
            }
        }

        public SaveData Select()
        {
            try
            {
                return Settings.Default.SaveData;
            }
            catch (ConfigurationErrorsException)
            {
                try
                {
                    Settings.Default.Upgrade();
                    return Settings.Default.SaveData;
                }
                catch (ConfigurationErrorsException)
                {
                    return null;
                }
            }
        }
    }
}
