﻿using System;
using System.Collections.Generic;
using System.Net;
using Progressive.PecaStarter.Common;
using Progressive.PecaStarter.DTO;
using Progressive.PecaStarter.Entity;
using Progressive.PecaStarter.Model.Peercast;
using System.Threading;

namespace Progressive.PecaStarter.Service
{
    public class PeercastService
    {
        public string Broadcast(string server, string yellowPagesUrl, BroadcastDTO dto)
        {
            var peercast = new Peercast(server);
            try
            {
                if (peercast.XmlStatus.IsExistOnRelaysByName(dto.Name))
                {
                    throw new ApplicationException(MessageDefine.CHANNEL_ALREADY_EXIST);
                }
                SetYellowPages(peercast, yellowPagesUrl);
                peercast.Broadcast(dto);
                string id;
                for (int i = 0; i < 5; i++)
                {
                    id = peercast.XmlStatus.GetChannelId(dto.Name);
                    if (id != PeercastDefine.NULL_RELAY_ID)
                    {
                        goto ACCEPT;
                    }
                    Thread.Sleep(1000);
                }
                throw new ApplicationException(MessageDefine.BROADCAST_FAILED);
            ACCEPT:
                return id;
            }
            catch (WebException)
            {
                throw new ApplicationException(MessageDefine.PEERCAST_NOT_FOUND);
            }
        }

        public void Update(string server, string yellowPagesUrl, UpdateDTO dto)
        {
            var peercast = new Peercast(server);
            try
            {
                if (!peercast.XmlStatus.IsExistOnRelaysByName(dto.Name))
                {
                    throw new ApplicationException(MessageDefine.CHANNEL_NOT_EXIST);
                }
                SetYellowPages(peercast, yellowPagesUrl);
                peercast.Update(dto);
                if (!peercast.XmlStatus.IsAgreementChannelStatus(dto))
                {
                    throw new ApplicationException(MessageDefine.UPDATE_FAILED);
                }
            }
            catch (WebException)
            {
                throw new ApplicationException(MessageDefine.PEERCAST_NOT_FOUND);
            }
        }

        public void Stop(string server, string id)
        {
            var peercast = new Peercast(server);
            try
            {
                if (!peercast.XmlStatus.IsExistOnRelaysById(id))
                {
                    throw new ApplicationException(MessageDefine.CHANNEL_NOT_EXIST);
                }
                peercast.DisableKeep(id);
                peercast.Stop(id);
            }
            catch (WebException)
            {
                throw new ApplicationException(MessageDefine.PEERCAST_NOT_FOUND);
            }
        }

        public ChannelDTO[] GetBroadcastChannels(string server)
        {
            List<ChannelDTO> channelDTOs = new List<ChannelDTO>();
            try
            {
                foreach (Channel channel in new Peercast(server).XmlStatus.Channels)
                {
                    if (channel.Relay.Status != Status.BROADCAST)
                    {
                        continue;
                    }
                    channelDTOs.Add(new ChannelDTO
                    {
                        Name = channel.Name,
                        Id = channel.Id,
                        Type = channel.Type,
                        Genre = channel.Genre,
                        Description = channel.Desc,
                        Url = channel.Url,
                        Comment = channel.Comment,
                        TrackTitle = channel.Track.Title,
                        TrackArtist = channel.Track.Artist,
                        TrackAlbum = channel.Track.Album,
                        TrackGenre = channel.Track.Genre,
                        TrackContact = channel.Track.Contact,
                    });
                }
                return channelDTOs.ToArray();
            }
            catch (WebException)
            {
                throw new ApplicationException(MessageDefine.PEERCAST_NOT_FOUND);
            }
        }

        private void SetYellowPages(Peercast peercast, string url)
        {
            var parameters = peercast.SettingsHtml.Parameters;
            var newParameters = new List<KeyValuePair<string, string>>();
            foreach (var parameter in parameters)
            {
                if (parameter.Key != "yp")
                {
                    newParameters.Add(parameter);
                    continue;
                }
                if (parameter.Value == url)
                {
                    return;
                }
                newParameters.Add(new KeyValuePair<string, string>(parameter.Key, url));
            }
            peercast.SaveSettings(newParameters);
            return;
        }
    }
}
