﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Reflection;
using System.Xml.Linq;
using Progressive.PecaStarter.Model;

namespace Progressive.PecaStarter.DAO
{
    class YellowPagesDAO
    {
        private const string HIDDEN = "hidden";
        private const string TEXT = "text";
        private const string CHECK = "check";
        private const string COMBO = "combo";

        public YellowPages[] Select()
        {
            string targetDirectory = Path.GetDirectoryName(Assembly.GetEntryAssembly().Location) + Path.DirectorySeparatorChar + "yellowpages";
            var yellowPagesSites = new List<YellowPages>();
            if (!Directory.Exists(targetDirectory))
            {
                Directory.CreateDirectory(targetDirectory);
            }
            foreach (string file in Directory.GetFiles(targetDirectory))
            {
                if (Path.GetExtension(file).Equals(".xml", StringComparison.OrdinalIgnoreCase))
                {
                    var yp = new YellowPages();
                    try
                    {
                        var source = XElement.Load(file);
                        yp.Name = source.Attribute("name").Value;
                        yp.Host = source.Attribute("host").Value;
                        var notice = source.Attribute("notice").Value;
                        yp.Notice = notice != null ? notice : "http://" + yp.Host;
                        var options = new List<YellowPages.Option>();
                        foreach (XElement optionSource in source.Elements("option"))
                        {
                            if (HIDDEN == optionSource.Attribute("type").Value)
                            {
                                var option = new YellowPages.HiddenOption();
                                option.Sign = optionSource.Attribute("sign").Value;
                                options.Add(option);
                                continue;
                            }
                            if (TEXT == optionSource.Attribute("type").Value)
                            {
                                var option = new YellowPages.TextOption();
                                option.Name = optionSource.Attribute("name").Value;
                                option.Sign = optionSource.Attribute("sign").Value;
                                options.Add(option);
                                continue;
                            }
                            if (CHECK == optionSource.Attribute("type").Value)
                            {
                                var option = new YellowPages.CheckOption();
                                option.Name = optionSource.Attribute("name").Value;
                                option.Sign = optionSource.Attribute("sign").Value;
                                options.Add(option);
                                continue;
                            }
                            if (COMBO == optionSource.Attribute("type").Value)
                            {
                                var option = new YellowPages.ComboOption();
                                option.Name = optionSource.Attribute("name").Value;
                                var comboItems = new List<YellowPages.ComboOptionItem>();
                                foreach (XElement itemElement in optionSource.Elements("item"))
                                {
                                    var comboItem = new YellowPages.ComboOptionItem();
                                    comboItem.Name = itemElement.Attribute("name").Value;
                                    comboItem.Sign = itemElement.Attribute("sign").Value;
                                    comboItems.Add(comboItem);
                                }
                                option.ComboItems = comboItems.ToArray();
                                options.Add(option);
                                continue;
                            }
                        }
                        yp.Options = options.ToArray();
                    }
                    catch (Exception e)
                    {
                        throw new ApplicationException(file + "の読み込みに失敗しました。（" + e.Message + "）");
                    }
                    yellowPagesSites.Add(yp);
                }
            }
            return yellowPagesSites.ToArray();
        }
    }
}
