﻿using System;
using System.IO;
using System.Text.RegularExpressions;
using Progressive.PecaStarter.Model;

namespace Progressive.PecaStarter.ViewModel.Page
{
    public class SettingsViewModel : ViewModelBase
    {
        #region Variables
        private Peercast peercast;
        private Logger logger;
        private MainWindowViewModel parent;
        private bool isNotifyIcon;
        private bool isSavePosition;
        private bool logging;
        private uint delay;
        #endregion

        #region Binding Properties
        public uint Port
        {
            get
            {
                var match = Regex.Match(peercast.Address, @"^localhost:(\d{1,5})$");
                if (!match.Success)
                {
                    peercast.Address = "localhost:7144";
                    return Port;
                }
                return uint.Parse(match.Groups[1].Value);
            }
            set
            {
                peercast.Address = "localhost:" + value;
                NotifyPropertyChanged("Port");
            }
        }
        public bool IsNotifyIcon
        {
            get { return isNotifyIcon; }
            set
            {
                isNotifyIcon = value;
                NotifyPropertyChanged("IsNotifyIcon");
            }
        }
        public bool IsSavePosition
        {
            get { return isSavePosition; }
            set
            {
                isSavePosition = value;
                NotifyPropertyChanged("IsSavePosition");
            }
        }
        public bool Logging
        {
            get { return logging; }
            set
            {
                logging = value;
                NotifyPropertyChanged("Logging");
            }
        }
        public bool IsLoggingEnabled
        {
            get { return !parent.IsBroadcast; }
        }
        public string LogPath
        {
            get { return logger.Path; }
            set
            {
                logger.Path = value;
                if (logger.Path == null || logger.Path.Length == 0)
                {
                    logger.Path = Environment.GetFolderPath(Environment.SpecialFolder.Personal) + Path.DirectorySeparatorChar + "PeercastLog";
                }
                NotifyPropertyChanged("LogPath");
            }
        }
        public bool IsLogPathEnabled
        {
            get { return IsLoggingEnabled && logging; }
        }
        public uint Delay
        {
            get { return delay; }
            set
            {
                delay = value;
                NotifyPropertyChanged("Delay");
            }
        }
        public bool IsDelayEnabled { get { return false;/* parent.Countdown;*/ } }
        #endregion

        public SettingsViewModel(MainWindowViewModel parent, Peercast peercast, Logger logger)
        {
            this.parent = parent;
            this.peercast = peercast;
            this.logger = logger;
            isNotifyIcon = false;
            isSavePosition = false;
            logging = false;
            delay = 0;
            Port = 7144;
            AddRelation(parent, "IsBroadcast", "IsLoggingEnabled");
            AddRelation("IsLoggingEnabled", "IsLogPathEnabled");
            AddRelation("Logging", "IsLogPathEnabled");
        }
    }
}
