﻿using System;
using System.Collections.Generic;
using System.Text;
using Progressive.PecaStarter.Model;
using Progressive.PecaStarter.Common;

namespace Progressive.PecaStarter.ViewModel.Page
{
    public class YellowPagesViewModel : DynamicObjectViewModel
    {
        #region Variables
        private MainWindowViewModel parent;
        private YellowPages model;
        private bool isAccepted;
        #endregion

        #region Properties
        public int AcceptedHash { get; set; }
        #endregion

        #region Binding Properties
        public string Name { get { return model.Name; } }
        public string NoticeUrl { get { return model.NoticeUrl; } }
        public bool IsAccepted
        {
            get { return isAccepted; }
            set
            {
                isAccepted = value;
                NotifyPropertyChanged("IsAccepted");
                AcceptedHash = value ? model.GetNoticeHash() : 0;
            }
        }
        public ICollection<string> Keys { get { return model.Components; } }
        public bool IsStaticParameterEnabled { get { return !parent.IsBusy && !parent.IsBroadcast; } }
        public string Prefix
        {
            get
            {
                if (!(model is PeercastYellowPages))
                {
                    return "";
                }
                var pyp = model as PeercastYellowPages;
                var sb = new StringBuilder();
                sb.Append(pyp.Header);
                foreach (var param in pyp.Parameters)
                {
                    var value = this[param] as string;
                    switch (param)
                    {
                        case YellowPagesDefine.Namespace:
                            if (String.IsNullOrEmpty(value))
                            {
                                break;
                            }
                            sb.Append(value + ':');
                            break;
                        case YellowPagesDefine.PortBandwidthCheck:
                            if (string.IsNullOrEmpty(value))
                            {
                                break;
                            }
                            switch (value)
                            {
                                case "1":
                                    sb.Append('@');
                                    break;
                                case "2":
                                    sb.Append("@@");
                                    break;
                                case "3":
                                    sb.Append("@@@");
                                    break;
                            }
                            break;
                        case YellowPagesDefine.OutsideDisplay:
                            if (string.IsNullOrEmpty(value))
                            {
                                break;
                            }
                            switch (value)
                            {
                                case "1":
                                    sb.Append('#');
                                    break;
                                case "2":
                                    sb.Append("##");
                                    break;
                            }
                            break;
                        case YellowPagesDefine.ListenersInvisibility:
                            if (value != "True")
                            {
                                break;
                            }
                            sb.Append('?');
                            break;
                        case YellowPagesDefine.ListenersVisibility:
                            if (value != "True")
                            {
                                break;
                            }
                            sb.Append('?');
                            break;
                        case YellowPagesDefine.NoLog:
                            if (value != "True")
                            {
                                break;
                            }
                            sb.Append('+');
                            break;
                        case YellowPagesDefine.TimeInvisibility:
                            if (value != "True")
                            {
                                break;
                            }
                            sb.Append('~');
                            break;
                        default:
                            sb.Append(this[param] as string);
                            break;
                    }
                }
                return sb.ToString();
            }
        }
        #endregion

        public YellowPagesViewModel(MainWindowViewModel parent, YellowPages model)
        {
            this.parent = parent;
            this.model = model;
            foreach (var component in model.Components)
            {
                switch (component)
                {
                    case YellowPagesDefine.ListenersInvisibility:
                    case YellowPagesDefine.ListenersVisibility:
                    case YellowPagesDefine.NoLog:
                    case YellowPagesDefine.TimeInvisibility:
                        this[component] = "False";
                        continue;
                    default:
                        this[component] = "";
                        continue;
                }
            }
            AddRelation(parent, "IsBusy", "IsStaticParameterEnabled");
            AddRelation(parent, "IsBroadcast", "IsStaticParameterEnabled");
        }

        public string Parse(string value)
        {
            if (!(model is PeercastYellowPages))
            {
                return value;
            }
            var pyp = model as PeercastYellowPages;
            Clear();
            int index = 0;
            if (!Check(value, pyp.Header, ref index))
            {
                return value;
            }
            foreach (var param in pyp.Parameters)
            {
                this[param] = GetParam(value, param, ref index);
            }
            return value.Substring(index);
        }

        private string GetParam(string value, string param, ref int index)
        {
            switch (param)
            {
                case YellowPagesDefine.Namespace:
                    int end = value.IndexOf(':', index);
                    if (end < 0)
                    {
                        return "";
                    }
                    var result = value.Substring(index, end - index);
                    index = end + 1;
                    return result;
                case YellowPagesDefine.ListenersVisibility:
                    if (!Check(value, "?", ref index))
                    {
                        return "False";
                    }
                    return "True";
                case YellowPagesDefine.ListenersInvisibility:
                    if (!Check(value, "?", ref index))
                    {
                        return "False";
                    }
                    return "True";
                case YellowPagesDefine.TimeInvisibility:
                    if (!Check(value, "~", ref index))
                    {
                        return "False";
                    }
                    return "True";
                case YellowPagesDefine.OutsideDisplay:
                    if (!Check(value, "#", ref index))
                    {
                        return "0";
                    }
                    if (!Check(value, "#", ref index))
                    {
                        return "1";
                    }
                    return "2";
                case YellowPagesDefine.PortBandwidthCheck:
                    if (!Check(value, "@", ref index))
                    {
                        return "0";
                    }
                    if (!Check(value, "@", ref index))
                    {
                        return "1";
                    }
                    if (!Check(value, "@", ref index))
                    {
                        return "2";
                    }
                    return "3";
                case YellowPagesDefine.NoLog:
                    if (!Check(value, "+", ref index))
                    {
                        return "False";
                    }
                    return "True";
                default:
                    throw new ArgumentException();
            }
        }

        /// <summary>
        /// valueの先頭にsignがあるかを返します。signがあった場合はindexをその分だけ移動させます
        /// </summary>
        private bool Check(string value, string sign, ref int index)
        {
            if (sign != value.Substring(index, sign.Length))
            {
                return false;
            }
            index += sign.Length;
            return true;
        }
    }
}
