﻿using System.Collections.Generic;
using System.Windows;
using Progressive.PecaStarter.Model;
using System;
using System.Windows.Input;
using Progressive.PecaStarter.ViewModel.Command;

namespace Progressive.PecaStarter.ViewModel.Page
{
    public class ExternalSourceViewModel : ViewModelBase
    {
        #region Variables
        private MainWindowViewModel parent;
        private Peercast peercast;
        private readonly ICommand removeItemCommand;
        private string streamUrl;
        #endregion

        #region Properties
        #endregion

        #region Binding Properties
        public string StreamUrl
        {
            get { return streamUrl; }
            set
            {
                streamUrl = value;
                NotifyPropertyChanged("StreamUrl");
            }
        }
        public bool IsStreamUrlEnabled
        {
            get { return !parent.IsBusy && !parent.IsBroadcast; }
        }
        public TextBoxWithHistoryViewModel Name { get; private set; }
        public bool IsNameEnabled
        {
            get { return !parent.IsBusy && !parent.IsBroadcast; }
        }
        public string Prefix
        {
            get
            {
                return PrefixVisibility == Visibility.Visible ? parent.YellowPagesesViewModel.SelectedYellowPages.Prefix : "";
            }
        }
        public Visibility PrefixVisibility
        {
            get
            {
                var yp = parent.YellowPagesesViewModel.SelectedYellowPages;
                if (yp == null)
                {
                    return Visibility.Collapsed;
                }
                return !string.IsNullOrEmpty(yp.Prefix) ? Visibility.Visible : Visibility.Collapsed;
            }
        }
        public TextBoxWithHistoryViewModel Genre { get; private set; }
        public TextBoxWithHistoryViewModel Description { get; private set; }
        public TextBoxWithHistoryViewModel ContactUrl { get; private set; }
        public TextBoxWithHistoryViewModel Comment { get; private set; }
        #endregion

        public ExternalSourceViewModel(MainWindowViewModel parent, Peercast peercast)
        {
            this.parent = parent;
            this.peercast = peercast;
            removeItemCommand = new RemoveItemCommand();
            streamUrl = "";
            Name = new TextBoxWithHistoryViewModel(removeItemCommand);
            Genre = new TextBoxWithHistoryViewModel(removeItemCommand);
            Description = new TextBoxWithHistoryViewModel(removeItemCommand);
            ContactUrl = new TextBoxWithHistoryViewModel(removeItemCommand);
            Comment = new TextBoxWithHistoryViewModel(removeItemCommand);
            AddRelation(parent, "IsBusy", "IsStreamUrlEnabled");
            AddRelation(parent, "IsBroadcast", "IsStreamUrlEnabled");
            AddRelation(parent, "IsBusy", "IsNameEnabled");
            AddRelation(parent, "IsBroadcast", "IsNameEnabled");
            AddRelation(parent, "SelectedIndex", "Prefix");
            AddRelation(parent, "SelectedIndex", "PrefixVisibility");
        }

        #region Methods
        public void UpdateHistory()
        {
            Name.UpdateHistory();
            Genre.UpdateHistory();
            Description.UpdateHistory();
            ContactUrl.UpdateHistory();
            Comment.UpdateHistory();
        }

        private string UpdateHistory(IList<string> history, string value)
        {
            if (history.Contains(value))
            {
                history.Remove(value);
            }
            history.Insert(0, value);
            while (history.Count > 20)
            {
                history.RemoveAt(history.Count - 1);
            }
            return history[0];
        }
        #endregion
    }
}
