﻿using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Progressive.PecaStarter.Model;
using Progressive.PecaStarter.Model.Internal;
using Progressive.PecaStarter.ViewModel.Page;

namespace Progressive.PecaStarter.ViewModel.Command
{
    public class StopCommand : ChannelCommandBase
    {
        public StopCommand(Peercast peercast, Logger logger, IList<YellowPages> yellowPageses, MainWindowViewModel viewModel)
            : base(peercast, logger, yellowPageses, viewModel) { }

        protected override bool CanExecute()
        {
            if (!peercast.IsBroadcast)
            {
                return false;
            }
            var ypvm = viewModel.YellowPagesesViewModel.SelectedYellowPages;
            var yp = yellowPageses.Single(a => a.Name == ypvm.Name);
            if (yp is PeercastYellowPages)
            {
                return true;
            }
            else
            {
                foreach (var param in (yp as WebApiYellowPages).StopParameters)
                {
                    if (WebApiDefine.ExcludeParameters.Contains(param))
                    {
                        continue;
                    }
                    if (!TryLength(ypvm[param])) return false;
                }
                return true;
            }
        }
        protected override async Task Execute()
        {
            viewModel.Feedback = "通信中...";
            var esvm = viewModel.ExternalSourceViewModel;
            var ypvm = viewModel.YellowPagesesViewModel.SelectedYellowPages;
            var yp = yellowPageses.Single(a => a.Name == ypvm.Name);
            if (yp is PeercastYellowPages)
            {
                var result = await PeercastYpExecute();
                if (result != Result.Success)
                {
                    viewModel.Feedback = "中止";
                    viewModel.NotifyAlert("チャンネルの切断時にエラーが発生しました。\n原因: " + GetErrorMessage(result));
                    return;
                }
            }
            else
            {
                var info = await WebApiYpExecute(yp as WebApiYellowPages, ypvm, esvm);
                if (info.Result != Result.Success)
                {
                    viewModel.Feedback = "中止";
                    viewModel.NotifyAlert("チャンネルの切断時にエラーが発生しました。\n原因: " + GetErrorMessage(info));
                    return;
                }
            }
            if (viewModel.IsTimerRunning)
            {
                if (viewModel.SettingsViewModel.Logging)
                {
                    viewModel.EndTimer("（配信終了）");
                }
                else
                {
                    viewModel.EndTimer();
                }
            }
            viewModel.Feedback = "チャンネルを切断しました";
        }

        private async Task<Result> PeercastYpExecute()
        {
            return await peercast.Stop();
        }
        private async Task<ResultInfo<string>> WebApiYpExecute(WebApiYellowPages wyp, YellowPagesViewModel ypvm, ExternalSourceViewModel esvm)
        {
            var result = await peercast.Stop();
            if (result != Result.Success)
            {
                return ResultInfo.Create(result, "");
            }
            return await wyp.Stop(GetWebApiParameters(wyp.StopParameters, 0, ypvm, esvm, ""));
        }
    }
}
