﻿using System.Collections.Generic;
using System.Collections.Specialized;
using System.Linq;
using System.Net;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Linq;
using Codeplex.Data;
using Progressive.PecaStarter.Model.Internal;
using Progressive.PecaStarter.Common;

namespace Progressive.PecaStarter.Model
{
    public class WebApiYellowPages : YellowPages
    {
        public override IList<string> Components
        {
            get
            {
                var list = base.Components;
                if (list.Count != 0)
                {
                    return list;
                }
                var set = new HashSet<string>();
                foreach (var param in BroadcastParameters) set.Add(param);
                foreach (var param in UpdateParameters) set.Add(param);
                foreach (var param in WebApiDefine.ExcludeParameters) set.Remove(param);
                set.Add(YellowPagesDefine.ListenersInvisibility);
                return set.ToList();
            }
        }
        public IList<string> BroadcastParameters
        {
            get
            {
                // 既定値を使用
                // TODO: ファイルから読み込み
                return WebApiDefine.DefaultBroadcastParameters;
            }
        }
        public IList<string> UpdateParameters
        {
            get
            {
                // 既定値を使用
                // TODO: ファイルから読み込み
                return WebApiDefine.DefaultUpdateParameters;
            }
        }
        public IList<string> StopParameters
        {
            get
            {
                // 既定値を使用
                // TODO: ファイルから読み込み
                return WebApiDefine.DefaultStopParameters;
            }
        }

        public WebApiYellowPages(string text) : base(text) { }
        public WebApiYellowPages(XDocument xml) : base(xml) { }

        public async Task<ResultInfo<string>> Broadcast(NameValueCollection parameters)
        {
            return await Post(Xml.Element("yellowpages").Element("webapi").Element("method").Element("start").Value, parameters);
        }
        public async Task<ResultInfo<string>> Update(NameValueCollection parameters)
        {
            return await Post(Xml.Element("yellowpages").Element("webapi").Element("method").Element("update").Value, parameters);
        }
        public async Task<ResultInfo<string>> Stop(NameValueCollection parameters)
        {
            return await Post(Xml.Element("yellowpages").Element("webapi").Element("method").Element("stop").Value, parameters);
        }
        private async Task<ResultInfo<string>> Post(string url, NameValueCollection parameters)
        {
            dynamic json;
            using (var client = new WebClient())
            {
                try
                {
                    json = DynamicJson.Parse(await Task.Factory.StartNew(() => Encoding.UTF8.GetString(client.UploadValues(url, parameters))));
                }
                catch (WebException e)
                {
                    if (e.Status == WebExceptionStatus.ConnectFailure)
                    {
                        return ResultInfo.Create(Result.ConnectFailure, "");
                    }
                    if (e.Status == WebExceptionStatus.ProtocolError)
                    {
                        var res = (HttpWebResponse)e.Response;
                        return ResultInfo.Create(Result.ConnectFailure, (int)res.StatusCode + ": " + res.StatusDescription);
                    }
                    throw e;
                }
            }
            if (json.result != "successful")
            {
                return ResultInfo.Create(Result.YellowPagesFailure, json.message);
            }
            return ResultInfo.Create(Result.Success, json.message);
        }
    }
}
