﻿using System;
using System.IO;
using System.Text;

namespace Progressive.PecaStarter.Model
{
    public class Logger
    {
        public string Path { get; set; }
        public string Name { get; set; }
        public DateTime StartAt { get; set; }

        public void insert(string listeners, string relays, string genre, string description, string comment)
        {
            if (!Directory.Exists(Path))
            {
                Directory.CreateDirectory(Path);
            }
            var sb = new StringBuilder();
            sb.Append(DateTime.Now).Append(',');
            sb.Append(listeners).Append(',');
            sb.Append(relays).Append(',');
            sb.Append('"').Append(genre.Replace("\"", "\"\"")).Append('"').Append(',');
            sb.Append('"').Append(description.Replace("\"", "\"\"")).Append('"').Append(',');
            sb.Append('"').Append(comment.Replace("\"", "\"\"")).Append('"');
            sb.Append("\r\n");
            File.AppendAllText(Path + System.IO.Path.DirectorySeparatorChar
                + StartAt.ToString("yyyyMMdd_HHmmss-") + Name + ".csv", sb.ToString());
        }
    }
}
