﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;
using System.Reflection;
using System.Deployment.Application;

namespace Progressive.PecaStarter.Model
{
    public class Core
    {
        public IList<YellowPages> GetYellowPages()
        {
            var path = Path.GetDirectoryName(Assembly.GetEntryAssembly().Location) + Path.DirectorySeparatorChar + "yellowpages" + Path.DirectorySeparatorChar;
            var list = new List<YellowPages>();
            foreach (var fp in Directory.EnumerateFiles(path, "*.xml"))
            {
                list.Add(YellowPages.GetInstance(fp));
            }
            return list;
        }

        public string ApplicationTitle
        {
            get
            {
                if (!ApplicationDeployment.IsNetworkDeployed)
                {
                    return "Peca Starter 4 (Stand Alone)";
                }
                var version = ApplicationDeployment.CurrentDeployment.CurrentVersion;
                var sb = new StringBuilder("Peca Starter").Append(" ");
                sb.Append(version.Major.ToString()).Append('.');
                sb.Append(version.Minor.ToString()).Append('.');
                sb.Append(version.Build.ToString()).Append('.');
                sb.Append(version.Revision.ToString());
                return sb.ToString();
            }
        }
    }
}
