﻿using System;
using System.Configuration;
using System.IO;
using Progressive.PecaStarter.Entity;
using Progressive.PecaStarter.Properties;

namespace Progressive.PecaStarter.Dao
{
    public class SaveDataDao
    {
        public SaveData Select()
        {
            try
            {
                return Settings.Default.SaveData;
            }
            catch (SystemException)
            {
                try
                {
                    Settings.Default.Upgrade();
                    return Settings.Default.SaveData;
                }
                catch (SystemException)
                {
                    return null;
                }
            }
        }

        public void Update(SaveData saveData)
        {
            try
            {
                Settings.Default.SaveData = saveData;
                Settings.Default.Save();
            }
            catch (ConfigurationErrorsException)
            {
                var conf = ConfigurationManager.OpenExeConfiguration(ConfigurationUserLevel.PerUserRoamingAndLocal).FilePath;
                File.Delete(conf);
                try
                {
                    Settings.Default.SaveData = saveData;
                    Settings.Default.Save();
                }
                catch (ConfigurationErrorsException)
                {
                    File.Delete(conf);
                    throw new ApplicationException("設定ファイルの状態が異常です。アプリケーションを再インストールしてください。");
                }
            }
        }
    }
}
