/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.console;

import org.eclipse.debug.ui.console.IConsole;
import org.eclipse.debug.ui.console.IConsoleLineTrackerExtension;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.php.internal.debug.core.launching.HyperlinkEntry;
import org.eclipse.php.internal.debug.core.launching.PHPHyperLink;
import org.eclipse.php.internal.debug.core.launching.PHPProcess;
import org.eclipse.php.internal.debug.ui.Logger;
import org.eclipse.ui.console.IHyperlink;

public class PHPLineTracker
implements IConsoleLineTrackerExtension {
    private IConsole fConsole;
    private PHPHyperLink fPHPHyperLink;

    public void init(IConsole console) {
        this.fConsole = console;
        this.fPHPHyperLink = ((PHPProcess)this.fConsole.getProcess()).getPHPHyperLink();
    }

    public void lineAppended(IRegion line) {
        IHyperlink link;
        String message = "";
        try {
            message = this.fConsole.getDocument().get(line.getOffset(), line.getLength());
        }
        catch (BadLocationException e) {
            Logger.logException("PHPLineTracker error getting message", e);
            return;
        }
        HyperlinkEntry hyperLink = this.fPHPHyperLink.getHyperlinkEntry(message);
        if (hyperLink != null && (link = hyperLink.getLink()) != null) {
            this.fConsole.addLink(link, line.getOffset(), hyperLink.getHyperLength());
        }
    }

    public void dispose() {
        this.fConsole = null;
        this.fPHPHyperLink = null;
    }

    public void consoleClosed() {
        this.fPHPHyperLink.dispose();
    }
}

